<?xml version="1.0" encoding="UTF-8"?>
<!--
This file was generated by Altova MapForce 2008

YOU SHOULD NOT MODIFY THIS FILE, BECAUSE IT WILL BE
OVERWRITTEN WHEN YOU RE-RUN CODE GENERATION.

Refer to the Altova MapForce Documentation for further details.
http://www.altova.com/mapforce
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<xsl:template match="/KNet">
		<KNet>
			<xsl:attribute name="xsi:noNamespaceSchemaLocation">
				<xsl:value-of select="'/Roboter/Config/System/Common/Schemes/KNet.xsd'"/>
			</xsl:attribute>
			<xsl:for-each select="Version">
				<Version>
					<xsl:for-each select="@Label">
						<xsl:attribute name="Label">
							<xsl:value-of select="."/>
						</xsl:attribute>
					</xsl:for-each>
					<xsl:for-each select="Info">
						<Info>
							<xsl:attribute name="Version">
								<xsl:value-of select="'KUKA V8.3'"/>
							</xsl:attribute>
						</Info>
					</xsl:for-each>
					<xsl:for-each select="Schema">
						<Schema>
							<xsl:attribute name="Version">
								<xsl:value-of select="'200'"/>
							</xsl:attribute>
						</Schema>
					</xsl:for-each>
				</Version>
			</xsl:for-each>
			<xsl:for-each select="HostTable">
				<xsl:variable name="SYS_NRT_Host" select="Host[@Name='SYS_NRT']"/>
				<xsl:variable name="SYS_RT_Host" select="Host[@Name='SYS_RT']"/>
				
				<!-- Anhand des 3. Tupels der SYS_RT-IP entscheiden, ob es sich
				um einen RoboTeam-Teilnehmer handelt oder nicht -->
				<xsl:variable name="RT_IP" select="$SYS_RT_Host/@IpAddress"/>
				<xsl:variable name="ControllerNumber" select="substring-before(substring-after(substring-after($RT_IP, '.'), '.'), '.')"/>
				<RoboTeamVLAN>
					<xsl:variable name="RoboTeamFlag">
						<xsl:choose>
							<xsl:when test="$ControllerNumber='0'">
								<xsl:value-of select="'false'"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="'true'"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>
					<xsl:attribute name="isActive">	
						<xsl:value-of select="$RoboTeamFlag"/>
					</xsl:attribute>
				</RoboTeamVLAN>
				<HostTable>
				
					<!-- 
					RoboTeam-Fall:
					- SYS_RT und SYS_NRT-Eintraege herausfiltern
					- Namen uebernehmen
					- Fuer RealtimeIp bereits vorhandene IP uebernehmen
					- Fuer NonRealtimeIp SYS_NRT und jeweilige Controllernummer zusammenbauen
					- Falls RealtimeIp der SYS_NRT-Adresse entspricht, isLocalHost-Flag setzen
					-->
					<xsl:if test="$ControllerNumber!='0'">
						<xsl:for-each select="Host">
						<xsl:variable name="VmarkerloopHost" select="."/>
						<xsl:variable name="ExistsResult">
							<xsl:for-each select="@Name">
								<xsl:variable name="Vvar10_result">
									<xsl:value-of select="((.) = ('SYS_RT')) or ((.) = ('SYS_NRT'))"/>
								</xsl:variable>
								<xsl:if test="(string($Vvar10_result))='true'">
									<xsl:value-of select="true()"/>
								</xsl:if>
							</xsl:for-each>
						</xsl:variable>
						<xsl:variable name="Vvar7_exists" select="string-length( $ExistsResult )>0"/>
						<xsl:if test="not((string($Vvar7_exists))='true')">
							<Host>
								<xsl:for-each select="@Name">
									<xsl:variable name="Vvar13_result">
										<xsl:value-of select="((.) = ('SYS_RT')) or ((.) = ('SYS_NRT'))"/>
									</xsl:variable>
									<xsl:variable name="Vvar14_cond">
										<xsl:choose>
											<xsl:when test="(string($Vvar13_result))='true'"/>
											<xsl:otherwise>
												<xsl:value-of select="."/>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:variable>
									<xsl:attribute name="Name">
										<xsl:value-of select="$Vvar14_cond"/>
									</xsl:attribute>
								</xsl:for-each>
								<xsl:for-each select="@Name">
									<xsl:variable name="Vvar17_result">
										<xsl:value-of select="((.) = ('SYS_RT')) or ((.) = ('SYS_NRT'))"/>
									</xsl:variable>
									<xsl:variable name="Vvar18_cond">
										<xsl:choose>
											<xsl:when test="(string($Vvar17_result))='true'"/>
											<xsl:otherwise>
												<xsl:for-each select="$VmarkerloopHost/@IpAddress">
													<xsl:value-of select="."/>
												</xsl:for-each>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:variable>
									<xsl:attribute name="RealtimeIp">
										<xsl:value-of select="$Vvar18_cond"/>
									</xsl:attribute>
									<xsl:attribute name="NonRealtimeIp">
										<xsl:variable name="NRT_IP" select="$SYS_NRT_Host/@IpAddress"/>
										<xsl:variable name="_Temp1" select="substring-before($NRT_IP, '.')"/>
										<xsl:variable name="_Temp2" select="substring-before(substring-after($NRT_IP, '.'), '.')"/>
										<xsl:variable name="NRT_SubnetLen" select="string-length(concat($_Temp2, '.')) + string-length(concat($_Temp1, '.')) + 1"/>
										<xsl:variable name="NRT_Subnet" select="substring($NRT_IP, 0, $NRT_SubnetLen)"/>
										<xsl:variable name="HOST_IP" select="$VmarkerloopHost/@IpAddress"/>	
										<xsl:variable name="FirstThreeTupel" select="concat($NRT_Subnet, substring-before(substring-after(substring-after($HOST_IP, '.'), '.'), '.'))"/>
										<xsl:variable name="LastTupel" select="concat('.', substring-after(substring-after(substring-after($NRT_IP, '.'), '.'), '.'))"/>
										<xsl:variable name="TOTAL" select="concat($FirstThreeTupel, $LastTupel)"/>
										<xsl:value-of select="$TOTAL"/>
									</xsl:attribute>
								</xsl:for-each>
								<xsl:variable name="ActualIp" select="$VmarkerloopHost/@IpAddress"/>
								<xsl:if test="$RT_IP = $ActualIp">
									<xsl:attribute name="isLocalHost">
										<xsl:value-of select="'true'"/>
									</xsl:attribute>
								</xsl:if>
								<xsl:if test="$RT_IP != $ActualIp">
									<xsl:attribute name="isLocalHost">
										<xsl:value-of select="'false'"/>
									</xsl:attribute>
								</xsl:if>
							</Host>
						</xsl:if>
					</xsl:for-each>
					</xsl:if>
					
					<!-- StandAlone-Fall, trivial -->
					<xsl:if test="$ControllerNumber='0'">
							<Host>
								<xsl:attribute name="Name">
									<xsl:value-of select="'Local'"/>
								</xsl:attribute>
								<xsl:attribute name="RealtimeIp">
									<xsl:value-of select="$SYS_RT_Host/@IpAddress"/>
								</xsl:attribute>
								<xsl:attribute name="NonRealtimeIp">
									<xsl:value-of select="$SYS_NRT_Host/@IpAddress"/>
								</xsl:attribute>
								<xsl:attribute name="isLocalHost">
									<xsl:value-of select="'true'"/>
								</xsl:attribute>
							</Host>
					</xsl:if>
					
				</HostTable>
			</xsl:for-each>
		</KNet>
	</xsl:template>
</xsl:stylesheet>
