<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:msxsl="urn:schemas-microsoft-com:xslt" exclude-result-prefixes="xs msxsl">
   <xsl:output method="xml" encoding="UTF-8" indent="yes"/>
   <xsl:template match="/FpExceptions">
      <FpExceptions>
         <xsl:attribute name="xsi:noNamespaceSchemaLocation">
            <xsl:value-of select="'/Roboter/Config/System/Common/Schemes/FpExceptions.xsd'"/>
         </xsl:attribute>
         <xsl:for-each select="Version">
            <Version>
               <xsl:for-each select="@Label">
                  <xsl:attribute name="Label">
                     <xsl:value-of select="."/>
                  </xsl:attribute>
               </xsl:for-each>
               <xsl:for-each select="Info">
                  <Info>
                     <xsl:attribute name="Version">
                        <xsl:value-of select="'KRC V8.3'"/>
                     </xsl:attribute>
                  </Info>
               </xsl:for-each>
               <xsl:for-each select="Schema">
                  <Schema>
                     <xsl:attribute name="Version">
                        <xsl:value-of select="100"/>
                     </xsl:attribute>
                  </Schema>
               </xsl:for-each>
            </Version>
         </xsl:for-each>

         <xsl:comment> x86 FPU/SSE-Exceptions
       Exceptions are active if the corresponding XML-attribute is set to 'true'.
       Exceptions not mentioned are implicitly deactivated. Possible attributes:
          Precision="true"
          Underflow="true"
          Overflow="true"
          ZeroDivide="true"
          DenormalizedOperand="true"
          InvalidOperation="true" </xsl:comment>
         <xsl:for-each select="UnmaskedExceptions">
            <xsl:element name="UnmaskedExceptions">
            <!-- Transform Bitmask to Exception-Attributes -->
               <xsl:if test="floor(. div 32) mod 2 = 1">
                  <xsl:attribute name="Precision">true</xsl:attribute>
               </xsl:if>
               <xsl:if test="floor(. div 16) mod 2 = 1">
                  <xsl:attribute name="Underflow">true</xsl:attribute>
               </xsl:if>
               <xsl:if test="floor(. div 8) mod 2 = 1">
                  <xsl:attribute name="Overflow">true</xsl:attribute>
               </xsl:if>
               <xsl:if test="floor(. div 4) mod 2 = 1">
                  <xsl:attribute name="ZeroDivide">true</xsl:attribute>
               </xsl:if>
               <xsl:if test="floor(. div 2) mod 2 = 1">
                  <xsl:attribute name="DenormalizedOperand">true</xsl:attribute>
               </xsl:if>
               <xsl:if test=". mod 2 = 1">
                  <xsl:attribute name="InvalidOperation">true</xsl:attribute>
               </xsl:if>
            </xsl:element>
         </xsl:for-each>

         <xsl:comment> x86 SSE-Modes
       Activate special modes for SSE calculations. Modes not mentioned
       are implicitly deactivated. Possible attributes:
          FlushToZero="true"
          DenormalsAreZero="true" </xsl:comment>
         <xsl:element name="SseModes">
            <xsl:attribute name="FlushToZero">true</xsl:attribute>
            <xsl:attribute name="DenormalsAreZero">true</xsl:attribute>
         </xsl:element>

         <xsl:comment> Deactivate FP-Unit for Tasks that are spawned without Fp support
        (if disabled, issue a warning for those tasks) </xsl:comment>
         <xsl:for-each select="WarnSpawnWithoutFpSupport">
            <DeactivateFpuForNonFpTasks>
               <xsl:value-of select="normalize-space()"/>
            </DeactivateFpuForNonFpTasks>
         </xsl:for-each>

         <xsl:comment> Overwriting global definitions
       List of tasks for which global FPU/SSE-Settings should not apply.
       Tasks listed here can be configured with individual FPU/SSE-Exceptions and
       SSE-Modes and do not inherit any global FPU/SSE-Settings configured elsewhere.
       The task name configured here must match exactly with the task's real name.
       Example:
          &lt;SpecialSettings&gt;
             &lt;Task Name="tNextGen" InvalidOperation="true" FlushToZero="true" DenormalsAreZero="true"/&gt;
          &lt;/SpecialSettings&gt;
       FPU/SSE-Exceptions and SSE-Modes not mentioned are implicitly deactivated </xsl:comment>
         <xsl:for-each select="MaskedTasks">
            <SpecialSettings>
               <xsl:variable name="tokens">
                  <xsl:call-template name="tokenize">
                     <xsl:with-param name="string" select="normalize-space()" />
                     <xsl:with-param name="delim" select="' '" />
                  </xsl:call-template>
               </xsl:variable>
            <!-- Tokenize list with tasks into separate Task-Elements -->
               <xsl:for-each select="msxsl:node-set($tokens)/token">
                  <xsl:element name="Task">
                     <xsl:attribute name="Name">
                        <xsl:value-of select="."/>
                     </xsl:attribute>
                     <xsl:attribute name="FlushToZero">true</xsl:attribute>
                     <xsl:attribute name="DenormalsAreZero">true</xsl:attribute>
                  </xsl:element>
               </xsl:for-each>
            </SpecialSettings>
         </xsl:for-each>

      </FpExceptions>
   </xsl:template>

   <!-- template to split a string into tokens -->
   <xsl:template name="tokenize">
      <xsl:param name="string" />
      <xsl:param name="delim" />
      <xsl:choose>
         <xsl:when test="not($string)" />
         <xsl:when test="contains($string, $delim)">
            <token><xsl:value-of select="substring-before($string, $delim)" /></token>
            <xsl:call-template name="tokenize">
               <xsl:with-param name="string" select="substring-after($string, $delim)" />
               <xsl:with-param name="delim" select="$delim" />
            </xsl:call-template>
         </xsl:when>
         <xsl:otherwise>
            <token><xsl:value-of select="$string" /></token>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template> 

</xsl:stylesheet>
