/*
 *   Copyright (C) 2011-2018, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */


#include "time_verify.h"
#include "AskDialog.h"
#include <wx/ffile.h>
#include <wx/arrstr.h>
#include <wx/dir.h>
#include <wx/busyinfo.h>


//(*InternalHeaders(time_verify)
#include <wx/string.h>
#include <wx/intl.h>
#include <wx/font.h>
//*)

#include "globals.h"
#include "LoadEllKey.h"


//(*IdInit(time_verify)
const long time_verify::ID_BUTTON1 = wxNewId();
const long time_verify::ID_STATICTEXT1 = wxNewId();
const long time_verify::ID_STATICTEXT2 = wxNewId();
const long time_verify::ID_STAMPEE_CTRL = wxNewId();
const long time_verify::ID_BUTTON3 = wxNewId();
const long time_verify::ID_STATICTEXT5 = wxNewId();
const long time_verify::ID_TIM_SIG_FIL_CTRL = wxNewId();
const long time_verify::ID_STATICTEXT4 = wxNewId();
const long time_verify::ID_STATICTEXT3 = wxNewId();
const long time_verify::ID_TIM_INF_CTRL = wxNewId();
const long time_verify::ID_TEXTCTRL3 = wxNewId();
const long time_verify::ID_BUTTON5 = wxNewId();
const long time_verify::ID_STATICTEXT6 = wxNewId();
const long time_verify::ID_STATICTEXT7 = wxNewId();
const long time_verify::ID_KYID_CTRL = wxNewId();
const long time_verify::ID_KYFULLNAM_CTRL = wxNewId();
const long time_verify::ID_TEXTCTRL1 = wxNewId();
const long time_verify::ID_BUTTON2 = wxNewId();
const long time_verify::ID_STATICTEXT8 = wxNewId();
const long time_verify::ID_STATICTEXT9 = wxNewId();
const long time_verify::ID_EVALCTRL = wxNewId();
const long time_verify::ID_TEXTCTRL2 = wxNewId();
const long time_verify::ID_TIMER1 = wxNewId();
//*)

BEGIN_EVENT_TABLE(time_verify,wxDialog)
	//(*EventTable(time_verify)
	//*)
END_EVENT_TABLE()

time_verify::time_verify(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
    longnumber rndnam;

    if(!checkarm()){Close();}
    nostop=true;
	//(*Initialize(time_verify)
	wxFlexGridSizer* FlexGridSizer1;

	Create(parent, id, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("id"));
	SetClientSize(wxDefaultSize);
	Move(wxDefaultPosition);
	FlexGridSizer1 = new wxFlexGridSizer(0, 3, 0, 0);
	Button1 = new wxButton(this, ID_BUTTON1, _("Schliessen"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON1"));
	Button1->SetBackgroundColour(wxColour(244,176,176));
	wxFont Button1Font(10,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button1->SetFont(Button1Font);
	FlexGridSizer1->Add(Button1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText1 = new wxStaticText(this, ID_STATICTEXT1, _("Pruefung des Zeitstempels einer Datei"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT1"));
	wxFont StaticText1Font(14,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText1->SetFont(StaticText1Font);
	FlexGridSizer1->Add(StaticText1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	FlexGridSizer1->Add(20,20,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText2 = new wxStaticText(this, ID_STATICTEXT2, _("Gestempelte Datei:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT2"));
	wxFont StaticText2Font(10,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText2->SetFont(StaticText2Font);
	FlexGridSizer1->Add(StaticText2, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	stmpee_ctrl = new wxTextCtrl(this, ID_STAMPEE_CTRL, _("-"), wxDefaultPosition, wxSize(654,23), 0, wxDefaultValidator, _T("ID_STAMPEE_CTRL"));
	wxFont stmpee_ctrlFont(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	stmpee_ctrl->SetFont(stmpee_ctrlFont);
	FlexGridSizer1->Add(stmpee_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button3 = new wxButton(this, ID_BUTTON3, _("Datei waehlen"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON3"));
	wxFont Button3Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button3->SetFont(Button3Font);
	FlexGridSizer1->Add(Button3, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText5 = new wxStaticText(this, ID_STATICTEXT5, _("Zeitstempel Datei:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT5"));
	wxFont StaticText5Font(10,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText5->SetFont(StaticText5Font);
	FlexGridSizer1->Add(StaticText5, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	tim_sig_fil_ctrl = new wxTextCtrl(this, ID_TIM_SIG_FIL_CTRL, _("-"), wxDefaultPosition, wxSize(657,23), 0, wxDefaultValidator, _T("ID_TIM_SIG_FIL_CTRL"));
	wxFont tim_sig_fil_ctrlFont(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	tim_sig_fil_ctrl->SetFont(tim_sig_fil_ctrlFont);
	FlexGridSizer1->Add(tim_sig_fil_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText4 = new wxStaticText(this, ID_STATICTEXT4, _("Name des\nStemplers:"), wxDefaultPosition, wxSize(106,30), 0, _T("ID_STATICTEXT4"));
	wxFont StaticText4Font(9,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText4->SetFont(StaticText4Font);
	FlexGridSizer1->Add(StaticText4, 1, wxALL|wxALIGN_BOTTOM|wxALIGN_CENTER_HORIZONTAL, 5);
	StaticText3 = new wxStaticText(this, ID_STATICTEXT3, _("Timing_Info:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT3"));
	wxFont StaticText3Font(11,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText3->SetFont(StaticText3Font);
	FlexGridSizer1->Add(StaticText3, 1, wxALL|wxALIGN_RIGHT|wxALIGN_TOP, 5);
	tim_inf_ctrl = new wxTextCtrl(this, ID_TIM_INF_CTRL, _("Bislang kein Inhalt"), wxDefaultPosition, wxSize(683,129), wxTE_MULTILINE|wxTE_READONLY, wxDefaultValidator, _T("ID_TIM_INF_CTRL"));
	tim_inf_ctrl->SetForegroundColour(wxColour(0,0,0));
	tim_inf_ctrl->SetBackgroundColour(wxColour(220,213,213));
	wxFont tim_inf_ctrlFont(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	tim_inf_ctrl->SetFont(tim_inf_ctrlFont);
	FlexGridSizer1->Add(tim_inf_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	ssignam_ctrl = new wxTextCtrl(this, ID_TEXTCTRL3, _("-"), wxDefaultPosition, wxSize(139,23), wxTE_READONLY, wxDefaultValidator, _T("ID_TEXTCTRL3"));
	wxFont ssignam_ctrlFont(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	ssignam_ctrl->SetFont(ssignam_ctrlFont);
	FlexGridSizer1->Add(ssignam_ctrl, 1, wxALL|wxALIGN_TOP|wxALIGN_CENTER_HORIZONTAL, 5);
	Button5 = new wxButton(this, ID_BUTTON5, _("Stemplerschluessel\nwaehlen"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON5"));
	Button5->SetBackgroundColour(wxColour(211,243,203));
	wxFont Button5Font(11,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button5->SetFont(Button5Font);
	FlexGridSizer1->Add(Button5, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText6 = new wxStaticText(this, ID_STATICTEXT6, _("         Stemplername"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT6"));
	StaticText6->SetForegroundColour(wxColour(18,174,11));
	wxFont StaticText6Font(11,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText6->SetFont(StaticText6Font);
	FlexGridSizer1->Add(StaticText6, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	StaticText7 = new wxStaticText(this, ID_STATICTEXT7, _("Key Domain"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT7"));
	wxFont StaticText7Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText7->SetFont(StaticText7Font);
	FlexGridSizer1->Add(StaticText7, 1, wxALL|wxALIGN_BOTTOM|wxALIGN_CENTER_HORIZONTAL, 5);
	kyid_ctrl = new wxTextCtrl(this, ID_KYID_CTRL, _("-"), wxDefaultPosition, wxSize(110,23), 0, wxDefaultValidator, _T("ID_KYID_CTRL"));
	kyid_ctrl->SetBackgroundColour(wxColour(216,250,214));
	wxFont kyid_ctrlFont(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	kyid_ctrl->SetFont(kyid_ctrlFont);
	FlexGridSizer1->Add(kyid_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	ky_fullnam_ctrl = new wxTextCtrl(this, ID_KYFULLNAM_CTRL, _("-"), wxDefaultPosition, wxSize(364,23), 0, wxDefaultValidator, _T("ID_KYFULLNAM_CTRL"));
	ky_fullnam_ctrl->SetBackgroundColour(wxColour(201,242,201));
	wxFont ky_fullnam_ctrlFont(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	ky_fullnam_ctrl->SetFont(ky_fullnam_ctrlFont);
	FlexGridSizer1->Add(ky_fullnam_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	kydom_ctrl = new wxTextCtrl(this, ID_TEXTCTRL1, _("-"), wxDefaultPosition, wxSize(119,22), wxTE_READONLY, wxDefaultValidator, _T("ID_TEXTCTRL1"));
	kydom_ctrl->SetForegroundColour(wxColour(0,0,0));
	kydom_ctrl->SetBackgroundColour(wxColour(255,255,255));
	wxFont kydom_ctrlFont(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	kydom_ctrl->SetFont(kydom_ctrlFont);
	FlexGridSizer1->Add(kydom_ctrl, 1, wxALL|wxALIGN_TOP|wxALIGN_CENTER_HORIZONTAL, 5);
	FlexGridSizer1->Add(30,15,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button2 = new wxButton(this, ID_BUTTON2, _("Stempel pruefen"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON2"));
	Button2->SetBackgroundColour(wxColour(167,208,247));
	wxFont Button2Font(10,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button2->SetFont(Button2Font);
	FlexGridSizer1->Add(Button2, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText8 = new wxStaticText(this, ID_STATICTEXT8, _("Aktuelle Domain"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT8"));
	wxFont StaticText8Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText8->SetFont(StaticText8Font);
	FlexGridSizer1->Add(StaticText8, 1, wxALL|wxALIGN_BOTTOM|wxALIGN_CENTER_HORIZONTAL, 5);
	StaticText9 = new wxStaticText(this, ID_STATICTEXT9, _("Test Result:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT9"));
	wxFont StaticText9Font(11,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText9->SetFont(StaticText9Font);
	FlexGridSizer1->Add(StaticText9, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	eval_ctrl = new wxTextCtrl(this, ID_EVALCTRL, _("bislang noch nicht ausgewertet"), wxDefaultPosition, wxSize(658,34), 0, wxDefaultValidator, _T("ID_EVALCTRL"));
	eval_ctrl->SetForegroundColour(wxColour(20,12,12));
	eval_ctrl->SetBackgroundColour(wxColour(221,223,234));
	wxFont eval_ctrlFont(16,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	eval_ctrl->SetFont(eval_ctrlFont);
	FlexGridSizer1->Add(eval_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	currdom_ctrl = new wxTextCtrl(this, ID_TEXTCTRL2, _("-"), wxDefaultPosition, wxSize(119,21), wxTE_READONLY, wxDefaultValidator, _T("ID_TEXTCTRL2"));
	currdom_ctrl->SetForegroundColour(wxColour(0,0,0));
	currdom_ctrl->SetBackgroundColour(wxColour(255,255,255));
	wxFont currdom_ctrlFont(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	currdom_ctrl->SetFont(currdom_ctrlFont);
	FlexGridSizer1->Add(currdom_ctrl, 1, wxALL|wxALIGN_TOP|wxALIGN_CENTER_HORIZONTAL, 5);
	SetSizer(FlexGridSizer1);
	Timer1.SetOwner(this, ID_TIMER1);
	Timer1.Start(30000, false);
	FlexGridSizer1->Fit(this);
	FlexGridSizer1->SetSizeHints(this);

	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&time_verify::OnExit);
	Connect(ID_BUTTON3,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&time_verify::OnSelFile);
	Connect(ID_BUTTON5,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&time_verify::OnSelPublic);
	Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&time_verify::DoVerify);
	Connect(ID_TIMER1,wxEVT_TIMER,(wxObjectEventFunction)&time_verify::OnTimer);
	//*)

    stmpee_ctrl->DragAcceptFiles(true);
    stmpee_ctrl->Connect(wxEVT_DROP_FILES, wxDropFilesEventHandler(time_verify::OnDropFile), NULL, this);

	currdom_ctrl->SetValue(gdom.name);
	loky.copy_pub_ky(&el_pk );
	kyid_ctrl->SetValue(loky.id);
	ky_fullnam_ctrl->SetValue(loky.fullnam);
	kydom_ctrl->SetValue(loky.domnam);

    redcol.Set(255,120,120);grencol.Set(120,255,120);neutcol.Set(255,200,170);
    //red.SetBackgroundColour(redcol);gren.SetBackgroundColour(grencol);neut.SetBackgroundColour(neutcol);
    //neut.SetTextColour(grencol);
    //r1=res_ctrl->SetStyle(0,5,neut); -> dysfunctional *#@!X
    eval_ctrl->SetValue(_("Noch nicht evaluiert"));
    eval_ctrl->SetBackgroundColour(neutcol);


    //make random name for timefile
	nostop=false;
	half_min_counter=0;
    nostop=false;
}
/************************************************************/
time_verify::~time_verify()
{
	//(*Destroy(time_verify)
	//*)
}

/******************************************************************/
void time_verify::OnExit(wxCommandEvent& event)
{
    EndModal(0);
}
/*************************************************************/
void time_verify::DoVerify(wxCommandEvent& event)
{
    longnumber h_doc,h_time,r,s,rndnam;
    int hnum,lbl,totsize,domfl;
    char *myblock;
    FILE *sfp;
    char buff[4002];
    e_p Vpoint;
    bool result;
    wxString stampfile,sigfile,tmsg_fnam,algo,tmp_fnam,tmp_stmpee,txt,pfnam,t_domnam,num,hashnam,stamptime,h;
    wxString stfilname,sclient,sdate,stime,szone,sname,skeyid,scomment,spath,msg,hlp;
    ellipse verdom;


    if(!checkarm()){Close();}
    nostop=true;
    // set timefile, and signfile  andsplice ects-File
    stampfile=tim_sig_fil_ctrl->GetLineText(0);
    //check for existence
    if(!wxFile::Exists(stampfile))
    {
        throwout(_("Stempeldatei existiert nicht!\nAbbruch."),3);
        return;
    }
    fnam=stmpee_ctrl->GetLineText(0);
    //check for existence
    if(!wxFile::Exists(fnam))
    {
        throwout(_("Gestempelte Datei nicht gefunden!\nAbbruch."),3);
        return;
    }
    if(stampfile.Len()>1000) {throwout(_("ECCS-Stempeldatei-Name zu lang\nAbbruch"),5); return;}
    if(fnam.Len()>1000) {throwout(_("Name der ECCS-gestempelten Datei zu lang\nAbbruch"),5); return;}
    rndnam.makerandom(7);
    rndnam.writehex(&sigfile);
    rndnam.makerandom(9);
    rndnam.writehex(&timefile);
    if(!splicefile(stampfile, sigfile, timefile, _("\nstamp_data: ")))
    {
        // complete sigfile and timefile to full path
        spath = ((wxFileName) stampfile).GetPath(wxPATH_GET_VOLUME|wxPATH_GET_SEPARATOR);
        sigfile = spath+sigfile; timefile=spath + timefile;
        if(wxFile::Exists(sigfile)) wxRemoveFile(sigfile);
        if(wxFile::Exists(timefile)) wxRemoveFile(timefile);
        throwout(_("Trennung der ects-Datei erfolglos\nAbbruch"),20);
        return;
    }
    // complete sigfile and timefile to full path
    spath = ((wxFileName) stampfile).GetPath(wxPATH_GET_VOLUME|wxPATH_GET_SEPARATOR);
    sigfile = spath+sigfile; timefile=spath + timefile;
    //determine hash
    pfnam=_("Hast Du die Quelle\ndes oeffentl. Schluessels serioes geprueft?!!\n\nVertrauen in die Signatur beruht auf\nVertrauen in die Authentizitaet des oefftl. Schluessels!");
    throwout(pfnam,20);
    //check, at stampfile path ob file und elliptic sig vorhanden
    if(! wxFile::Exists(sigfile)) {throwout(_("ECCS-Signatur-Datei existiert nicht")); return;}
    if(! wxFile::Exists(timefile)) {throwout(_("ECTS-Timing Datei existiert nicht")); return;}
    if(sigfile.Len()>800) {throwout(_("ECCS-Signatur-Dateiname missgeformt\nAbbruch"),5); return;}
    if(timefile.Len()>800) {throwout(_("Timeingdatei-Name missgeformt\nAbbruch"),5); return;}
    //lies namen, r und s ein
    strcpy( buff, (const char*)sigfile.mb_str(wxConvLocal) );
    sfp=fopen(buff,"r");
         if(sfp == NULL) {throwout(_("Fehler beimn oeffnen der Datei")); return;}
    lbl=fscanf(sfp,"Domnam: %100s ",buff);
        if(lbl==0)  {throwout(_("Domainname Lesefehler")); fclose(sfp);wxRemoveFile(timefile);wxRemoveFile(sigfile);return;}
    t_domnam=wxString::FromUTF8(buff);
    lbl=fscanf(sfp,"r: %500s ",buff);
            if(lbl==0)  {throwout(_("Parameter r Lesefehler")); fclose(sfp);wxRemoveFile(timefile);wxRemoveFile(sigfile);return;}
    num=wxString::FromUTF8(buff);
    r.storhex(&num);
    lbl=fscanf(sfp,"s: %500s ",buff);
            if(lbl==0)  {throwout(_("Parameter s Lesefehler")); fclose(sfp); wxRemoveFile(timefile);wxRemoveFile(sigfile);return;}
    num=wxString::FromUTF8(buff);
    s.storhex(&num);
    lbl=fscanf(sfp,"Hash: %50s ",buff);
        if(lbl==0)  {throwout(_("Warnung, \nkonnte Hashspezifikation nicht finden")); hashnam=_("Fleas_1_8");fclose(sfp);}
        else
        {
            hashnam=wxString::FromUTF8(buff);
            if(( hashnam != _("Fleas_1_8"))&&( hashnam != _("sha2"))&&( hashnam != _("Fleas_3"))&&( hashnam != _("Fleas_4"))
                &&( hashnam != _("Fleas_5"))&&( hashnam != _("Fleas_x2"))&&( hashnam != _("Fleas_x5"))
                &&( hashnam != _("Fleas_o2"))&&( hashnam != _("Fleas_o5"))&&( hashnam != _("sha4"))&&( hashnam != _("Fleas_l"))
                &&( hashnam != _("Fleas_lx"))&&( hashnam != _("Fleas_lx3"))&&( hashnam != _("Fleas_lc"))
                &&( hashnam != _("Fleas_ld"))&&( hashnam != _("Fleas_lb"))&&( hashnam != _("Fleas_b"))
                &&( hashnam != _("Fleas_c"))&&( hashnam != _("Fleas_d"))&&( hashnam != _("JH"))&&( hashnam != _("skein")) )
            {
                throwout(_("warning: unknown Hash specifier!"),5);
            }
        }
    fclose(sfp);
    //rebuildchain_hash file
    hnum=6;
    if( hashnam==_("sha2")) hnum=0;
    else if( hashnam==_("sha4")) hnum=1;
    else if( hashnam==_("Fleas_3")) hnum=2;
    else if( hashnam==_("Fleas_o2")) hnum=3;
    else if( hashnam==_("Fleas_o5")) hnum=4;
    else if( hashnam==_("Fleas_l")) hnum=5;
    else if( hashnam==_("Fleas_lx")) hnum=6;
    else if( hashnam==_("Fleas_lx3")) hnum=7;
    else if( hashnam==_("Fleas_lc")) hnum=8;
    else if( hashnam==_("Fleas_ld")) hnum=9;
    else if( hashnam==_("Fleas_lb")) hnum=10;
    else if( hashnam==_("Fleas_c")) hnum=8;
    else if( hashnam==_("Fleas_d")) hnum=9;
    else if( hashnam==_("Fleas_b")) hnum=10;
    else if( hashnam==_("JH")) hnum=11;
    else if( hashnam==_("skein")) hnum=12;
    switch(hnum)
    {
        case 0:
          get_lonu_sha2_from_filename(&h_doc, &fnam);
          get_lonu_sha2_from_filename(&h_time, &timefile);
          break;

        case 1:
          get_lonu_sha2_from_filename(&h_doc, &fnam,512);
          get_lonu_sha2_from_filename(&h_time, &timefile,512);
          break;

        case 2:
          get_lonu_hash_from_filename_3(&h_doc, &fnam,128);
          get_lonu_hash_from_filename_3(&h_time, &timefile,128);
          break;

        case 3:
          get_lonu_hash_from_filename_x(&h_doc, &fnam,256,hashnam);
          get_lonu_hash_from_filename_x(&h_time, &timefile,128,hashnam,false);
          break;

        case 4:
        case 5:
        case 6:
        case 7:
        case 8:
          get_lonu_hash_from_filename_x(&h_doc, &fnam,512,hashnam);
          get_lonu_hash_from_filename_x(&h_time, &timefile,128,hashnam,false);
          break;
        case 9:
        case 10:
          get_lonu_hash_from_filename_x(&h_doc, &fnam,512,hashnam);
          get_lonu_hash_from_filename_x(&h_time, &timefile,512,hashnam,false);
          break;

        case 11:
          get_lonu_JH_from_filename(&h_doc, &fnam,512);
          get_lonu_JH_from_filename(&h_time, &timefile,512);
          break;

         case 12:
          get_lonu_skein1024_from_filename(&h_doc, &fnam);
          get_lonu_skein1024_from_filename(&h_time, &timefile);
          break;

         default:
            throwout(_("unbekannter Hash! \nAbbruch"),5);
             //cleanup
            wxRemoveFile(timefile);
            wxRemoveFile(sigfile);
            return;
 }
    h_doc.setsize(true); h_time.setsize(true);
    totsize= (int)(h_doc.size + h_time.size);
    myblock = (char *) malloc(totsize);
    memcpy(myblock, h_doc.ad, h_doc.size);
    memcpy(myblock + h_doc.size, h_time.ad, h_time.size);
    if( !develop_o( myblock, totsize,2,3,2))
      {
        throwout(_("Alarm! Fehler in Zeitstempel-Routine!"),20);
        free(myblock);
        return;
      }
    //in neues File mit zufallsnamen rausschreiben
    rndnam.makerandom(9);
    rndnam.writehex(&tmp_fnam);
    tmp_fnam= spath + tmp_fnam;
    wxFFile tmpfil(tmp_fnam,_("wb"));
    tmpfil.Write(myblock,totsize);
    tmpfil.Close();

    //check domain
    if(t_domnam != loky.domnam)
    {
        msg=_("Domain Namenskonflikt!\nSignatur verlangt Domain: ") + t_domnam;
        msg += _("\n             Schluessel verlangt Domain: ");
        msg += loky.domnam;
        msg +=_("\n Du musst das klaeren! \nKeine Verifikation ohne klare Domainangabe!");
        throwout(msg);
        goto label2; //cleanup files and return
    }
    //check for accessibility of domain in pool
    if(t_domnam == gdom.name) verdom.copyell(&gdom);
    else
    {
       domfl=e_ls.getelp(&verdom,t_domnam);
       if(domfl <0)
       {
        throwout(_("Signaturschluessel-Domain passt zu keiner im Vorrat\n\nKANN NICHT VERIFIZIEREN !\n\nBitte importiere die zum Schluessel passende Domain!"),10);
        return;
       }
    }

    //check signature
    if(!(Vpoint.copy_ep(&(loky.A)))) throwout(_("copy ep error"));
    result= verify_elliptic_qq(tmp_fnam, &(verdom), &(Vpoint), &r, &s,hashnam);
    //document result
    if(result) //Verified!!
    {
        eval_ctrl->SetValue(_("Valider Zeitstempel"));
        //chang color to green
        eval_ctrl->SetBackgroundColour(grencol);
        //now fill time info from file timefile
        if(timefile.Len()>1998)
        {
           throwout(_("Achtung! Zeitdateiname zu lang\n wird gekuerzt!\nBitte pruefe auf Angriffsversuch!"));
        timefile=timefile.Left(1998);
        }
        strcpy( buff, (const char*)timefile.mb_str(wxConvLocal) );
        sfp=fopen(buff,"r"); //opening timefile
           if(sfp == NULL) {throwout(_("timefile opening error"),2); return;}
        // read in the first two items
        lbl=fscanf(sfp," %500s",buff); //the first star stuff
        lbl+=fscanf(sfp," %500s",buff); //the second star stuff
          if(lbl<2)  {throwout(_("b_b Lesefehlerr"),2); goto label1;}
        lbl=fscanf(sfp," Timestamping %500s",buff);
          if(lbl==0)  {throwout(_("Dateiname Lesefehler"),2); goto label1;}
        stfilname=wxString::FromUTF8(buff);
        do
        {
            lbl=fscanf(sfp," %500s",buff);
            sdate = wxString::FromUTF8(buff);
        } while((lbl==1)&&(sdate != _("for")));
        if(lbl==0) {throwout(_("date read error 0"),2); goto label1;}
        lbl=fscanf(sfp," %500s",buff);
          if(lbl==0)  {throwout(_("client read error"),2); goto label1;}
        sclient=wxString::FromUTF8(buff);
        //check until you scan "at: "
        do
        {
            lbl=fscanf(sfp," %500s",buff);
            sdate=wxString::FromUTF8(buff);
        } while((lbl==1)&&(sdate != _("at:")));
        if(lbl==0) {throwout(_("date read error 1"),2); goto label1;}
        lbl=fscanf(sfp," %500s",buff);
          if(lbl==0)  {throwout(_("date read error 2"),2); goto label1;}
        sdate=wxString::FromUTF8(buff);
        lbl=fscanf(sfp," %500s",buff);
          if(lbl==0)  {throwout(_("timeread error"),2); goto label1;}
        stime=wxString::FromUTF8(buff);
        lbl=fscanf(sfp," %500s",buff);
          if(lbl==0)  {throwout(_("zone read error"),2); goto label1;}
        szone=wxString::FromUTF8(buff);
        do
        {
             lbl=fscanf(sfp," %500s",buff);
             if (lbl != 0) //if something was read, check if part of zone or "by"
             {
                 hlp=wxString::FromUTF8(buff);
                 if(hlp != _("by")) szone += _("_") + hlp;//glue additional stuff to timezone info like e.g. "+ 1"
             }
             else
             {
                 throwout(_("unvollstaendige Zeitdatei, \nLeseabbruch!"),3);
                 goto label1; //eof reached
             }
        }while(hlp != _("by"));  //glue additional stuff to timezone info like e.g. "+ 1"
        lbl=fscanf(sfp," %500s",buff); //by has been found, next is stampername
          if(lbl==0)  {throwout(_("Stemplername Lesefehler, \nAbbruch"),2); goto label1;}
        sname=wxString::FromUTF8(buff);
        lbl=fscanf(sfp," using_key: %500s",buff);
          if(lbl==0)  {throwout(_("Stempler ID Lesefehler, \nAbbruch"),2); goto label1;}
        skeyid=wxString::FromUTF8(buff);
        lbl=fscanf(sfp," Comment: %1000s",buff);
          if(lbl==0)  {throwout(_("Kommentar Lesefehler\nAbbruch"),2); goto label1;}
        scomment=wxString::FromUTF8(buff);
label1:
        fclose(sfp);
//now fillt h
        h=_("Timestamped  ") + stfilname + _("    for client ") + sclient +_("\n");
        h=h + _("at: ") + sdate +_(" ") + stime + _("  ") + szone + _("\n");
        h=h + _("by stamper: ") + sname +_("   using_key_id: ") + skeyid + _("\nComment: ") + scomment;
        tim_inf_ctrl->SetValue(h);
    }
    else{
        eval_ctrl->SetValue(_("Zeitstempel abgelehnt"));
        h=_("Ungueltiger Zeitstempel!");
        tim_inf_ctrl->SetValue(h);
        //chang color to red
        eval_ctrl->SetBackgroundColour(redcol);
        throwout(_("Abgelehnt!\nSignatur passt nicht zu Datei\nund/oder oeffentl. Schluessel."));
    }
label2:
    //cleanup
    wxRemoveFile(timefile);
    wxRemoveFile(tmp_fnam);
    wxRemoveFile(sigfile);
    return;
}
/*******************************************************/
void time_verify::OnDropFile(wxDropFilesEvent& event)
    {
    wxString tmsg_fnam,h,stampfile,ext,docp;
    char buff[2002];
    int i,j,res;
    FILE *sfp;

        int filno;
        drop_succ=false;

        if (event.GetNumberOfFiles() > 0) {

            wxString* dropped = event.GetFiles();
            wxASSERT(dropped);

            wxBusyCursor busyCursor;
            wxWindowDisabler disabler;
            wxBusyInfo busyInfo(_("Datei wird eingefuegt, bitte warten..."));

            wxString name;
            filno = event.GetNumberOfFiles();
            if(filno!=1)
            {
				throwout(_("Nur ein Dateiname bitte.\nEinfuegen verweigert!"),3);
				return;
			}
			if( wxDirExists( 	dropped[0]	))
            {
                throwout(_("Das ist ein Verzeichnisname!!\nNur Dateiname moeglich.\nDrop ignoriert!"),3);
                return;
            }
			name = dropped[0];
			if (!wxFileExists(name))
            {
				throwout(_("Datei existiert nicht.\nEinfuegen verweigert!"),5);
				return;
			}

            wxTextCtrl* textCtrl = dynamic_cast<wxTextCtrl*>(event.GetEventObject());
            wxASSERT(textCtrl);
            textCtrl->Clear();
            textCtrl->SetValue(name);
            drop_succ=true;
            fnam= name;

    cur_doc_path= ((wxFileName)fnam).GetPath(); //get new path and store into cur_doc_path
    ext=fnam.Right(5);
    if((ext == _(".ecsg"))||(ext == _(".ects")))
    {
        AskDialog dialog(this,_("Do you really want to verify timestamp\nof a signature file or timestamp ?\nThis would be very unusual!"));
        res=dialog.ShowModal();
        if(res == 0)
        {
           //check if truncated file exists
           ext= fnam.Left(fnam.Len() - 5);
           if(!wxFile::Exists(ext)) return;
           else fnam=ext;
        }
    }
        tmsg_fnam=fnam + _(".ects");
        tim_sig_fil_ctrl->SetValue(tmsg_fnam);
        //check for stamp existence
        if(!wxFileExists(tmsg_fnam)) throwout(_("Warning!\nTime Stamp of the stated name does not exist!"),5);
        if(tmsg_fnam.Len()>500) {throwout(_("Alert!\nmalformed overly long Filename\n rejecting verification!")); return;}
        else
        {
             strcpy( buff, (const char*)tmsg_fnam.mb_str(wxConvLocal) );
             sfp=fopen(buff,"r");
                    if(sfp == NULL) {throwout(_("file opening error")); return;}
             for(i=0;i< 20;i++)
             {
               j= fscanf(sfp," %1000s ",buff);
               if(j != 1) {throwout(_("warning:\nCould not read claimed signer name!"),3);
                            break;}
             }
             if(j==1)
             {
                h= wxString::FromUTF8(buff);
                if(h != _("by")) // if this is not true, smthng was messed up
                {
                    do
                    {
                        j= fscanf(sfp," %1000s ",buff);
                        h= wxString::FromUTF8(buff);
                        i++;
                    } while((j!=0)&&(h != _("by"))&&(i<50));
                    if((j==0)||(i==50))
                    {
                      throwout(_("warning:\nCould not read claimed signer name!"),3);
                       h=_("unknown");
                    }
                    else
                    {
                                   j= fscanf(sfp," %1000s ",buff);
                                    if(j != 1)
                                    {
                                        throwout(_("warning:\nCould still not read claimed signer name!"),3);
                                        h=_("unknown");
                                    }
                                    else{   h= wxString::FromUTF8(buff);  }
                    }
                }
                else    //by was found, next is name
                {
                                   j= fscanf(sfp," %1000s ",buff);
                                    if(j != 1)
                                    {
                                        throwout(_("warning:\nCould not read claimed signer name!"),3);
                                        h=_("unknown");
                                    }
                                    else{   h= wxString::FromUTF8(buff);  }

                }
                ssignam_ctrl->SetValue(h);
             }
             fclose(sfp);
        }
        h=_("Undetermined yet");
        tim_inf_ctrl->SetValue(h);
        eval_ctrl->SetValue(_("Not evaluated yet"));
        eval_ctrl->SetBackgroundColour(neutcol);

        //set signer field
         stampfile=tim_sig_fil_ctrl->GetLineText(0);


         return;
        }
    }
/*********************************************************/
/****************************************************************/
void time_verify::OnSelFile(wxCommandEvent& event)
{
    wxString tmsg_fnam,h,stampfile,ext,docp;
    char buff[2002];
    int i,j,res;
    FILE *sfp;

    nostop=true;
    if(cur_doc_path.IsEmpty())
    {
        docp = doc_path; //first call
    }
    else
    {
        docp = cur_doc_path;
    }
    fnam = wxFileSelector(_("Waehle eine Datei zur Inspektion des Zeitstempels"),docp);
    //check for existence
    if(!wxFile::Exists(fnam))
    {
        throwout(_("Gestempelte Datei existiert nicht!\nAbbruch."),3);
        return;
    }
    cur_doc_path= ((wxFileName)fnam).GetPath(); //get new path and store into cur_doc_path
    //if ecsg or ects -> ask
    ext=fnam.Right(5);
    if((ext == _(".ecsg"))||(ext == _(".ects")))
    {
        AskDialog dialog(this,_("Willst Du wirklich den Zeitstempel\neiner Signatur oder eines Zeitstempels verifizieren?\nDas waere seltsam!"));
        res=dialog.ShowModal();
        if(res == 0)
        {
           //check if truncated file exists
           ext= fnam.Left(fnam.Len() - 5);
           if(!wxFile::Exists(ext)) return;
           else fnam=ext;
        }
    }

    if ( !fnam.empty() )
    {
        stmpee_ctrl->SetValue(fnam);
        tmsg_fnam=fnam + _(".ects");
        tim_sig_fil_ctrl->SetValue(tmsg_fnam);
        //check for stamp existence
        if(!wxFileExists(tmsg_fnam)) throwout(_("Warnung!\nZeitstempel der gewaehlten Datei existiert nicht!"),5);
        if(tmsg_fnam.Len()>500) {throwout(_("Achtung!\nmissgeformter ueberlanger Dateiname\n keine Verifikation!")); return;}
        else
        {
             strcpy( buff, (const char*)tmsg_fnam.mb_str(wxConvLocal) );
             sfp=fopen(buff,"r");
                    if(sfp == NULL) {throwout(_("Kann Datei nicht oeffnen")); return;}
             for(i=0;i< 20;i++)
             {
               j= fscanf(sfp," %1000s ",buff);
               if(j != 1) {throwout(_("Warnung:\nKonnte behaupteten Stemplernamen nicht lesen!"),3);
                            break;}
             }
             if(j==1)
             {
                h= wxString::FromUTF8(buff);
                if(h != _("by")) // if this is not true, smthng was messed up
                {
                    do
                    {
                        j= fscanf(sfp," %1000s ",buff);
                        h= wxString::FromUTF8(buff);
                        i++;
                    } while((j!=0)&&(h != _("by"))&&(i<50));
                    if((j==0)||(i==50))
                    {
                      throwout(_("Warnung:\nKonnte behaupteten Stemplernamen nicht lesen!"),3);
                       h=_("unknown");
                    }
                    else
                    {
                                   j= fscanf(sfp," %1000s ",buff);
                                    if(j != 1)
                                    {
                                        throwout(_("warnung:\nKonnte behaupteten Stemplernamen immer noch nicht lesen!"),3);
                                        h=_("unknown");
                                    }
                                    else{   h= wxString::FromUTF8(buff);  }
                    }
                }
                else    //by was found, next is name
                {
                                   j= fscanf(sfp," %1000s ",buff);
                                    if(j != 1)
                                    {
                                        throwout(_("Warnung:\nKonnte behaupteten Stemplernamen nicht lesen!"),3);
                                        h=_("unknown");
                                    }
                                    else{   h= wxString::FromUTF8(buff);  }

                }
                ssignam_ctrl->SetValue(h);
             }
             fclose(sfp);
        }
    }
    h=_("Bislang unbestimmt");
    tim_inf_ctrl->SetValue(h);
    eval_ctrl->SetValue(_("noch nicht geprueft"));
    eval_ctrl->SetBackgroundColour(neutcol);

    //set signer field
    stampfile=tim_sig_fil_ctrl->GetLineText(0);

    nostop=false;
    return;
}
/****************************************************************/
void time_verify::OnTimer(wxTimerEvent& event)
{
    half_min_counter++;
    if((half_min_counter > 10)&&(!nostop))  //mehr als 5 Minuten idle
    {
        unarm();
        EndModal(0);
    }
    return;
}
/*******************************************************************/
void time_verify::OnSelPublic(wxCommandEvent& event)
{
    wxString h;

    LoadEllKey dialog(this,&loky);
    dialog.ShowModal();


    if(!checkarm()){Close();}
    nostop=true;
    kyid_ctrl->SetValue(loky.id);
    ky_fullnam_ctrl->SetValue(loky.fullnam);
    kydom_ctrl->SetValue(loky.domnam);
    currdom_ctrl->SetValue(gdom.name);
    el_pk.copy_pub_ky(&loky);
    eval_ctrl->SetValue(_("Noch nicht geprueft"));
    //chang color to neutral
    eval_ctrl->SetBackgroundColour(neutcol);
    h=_("Bislang unbestimmt");
    tim_inf_ctrl->SetValue(h);
    eval_ctrl->SetValue(_("Noch nicht geprueft"));
    eval_ctrl->SetBackgroundColour(neutcol);
    nostop=false;
}
/********************************************************************/
