/*
 *   Copyright (C) 2011-2017, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */


#include <wx/arrstr.h>
#include <wx/dir.h>
#include <wx/busyinfo.h>

#include <wx/filename.h>
#include "gpg_verify.h"
#include "gpg_add_pub.h"
#include "globals.h"
#include "gnupg_globals.h"
#include "AskDialog.h"
#include "gpg_wrap.h"

//(*InternalHeaders(gpg_verify)
#include <wx/string.h>
#include <wx/intl.h>
#include <wx/font.h>
//*)
#include <wx/filedlg.h>


//(*IdInit(gpg_verify)
const long gpg_verify::ID_BUTTON1 = wxNewId();
const long gpg_verify::ID_STATICTEXT1 = wxNewId();
const long gpg_verify::ID_STATICTEXT3 = wxNewId();
const long gpg_verify::ID_TEXTCTRL2 = wxNewId();
const long gpg_verify::ID_BUTTON5 = wxNewId();
const long gpg_verify::ID_STATICTEXT2 = wxNewId();
const long gpg_verify::ID_TEXTCTRL1 = wxNewId();
const long gpg_verify::ID_BUTTON2 = wxNewId();
const long gpg_verify::ID_STATICTEXT4 = wxNewId();
const long gpg_verify::ID_TEXTCTRL4 = wxNewId();
const long gpg_verify::ID_TEXTCTRL5 = wxNewId();
const long gpg_verify::ID_BUTTON6 = wxNewId();
const long gpg_verify::ID_BUTTON3 = wxNewId();
const long gpg_verify::ID_TEXTCTRL3 = wxNewId();
const long gpg_verify::ID_TIMER1 = wxNewId();
//*)

BEGIN_EVENT_TABLE(gpg_verify,wxDialog)
	//(*EventTable(gpg_verify)
	//*)
END_EVENT_TABLE()

gpg_verify::gpg_verify(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
	//(*Initialize(gpg_verify)
	wxFlexGridSizer* FlexGridSizer1;

	Create(parent, wxID_ANY, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("wxID_ANY"));
	FlexGridSizer1 = new wxFlexGridSizer(0, 3, 0, 0);
	Button1 = new wxButton(this, ID_BUTTON1, _("Schliessen"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON1"));
	Button1->SetBackgroundColour(wxColour(253,208,208));
	wxFont Button1Font(11,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button1->SetFont(Button1Font);
	FlexGridSizer1->Add(Button1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText1 = new wxStaticText(this, ID_STATICTEXT1, _("Seperate GnuPG Signatur verifizieren"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT1"));
	wxFont StaticText1Font(14,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText1->SetFont(StaticText1Font);
	FlexGridSizer1->Add(StaticText1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	FlexGridSizer1->Add(-1,-1,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText3 = new wxStaticText(this, ID_STATICTEXT3, _("Signiertes Dokument waehlen:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT3"));
	wxFont StaticText3Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText3->SetFont(StaticText3Font);
	FlexGridSizer1->Add(StaticText3, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	fnam_ctrl = new wxTextCtrl(this, ID_TEXTCTRL2, wxEmptyString, wxDefaultPosition, wxSize(618,21), 0, wxDefaultValidator, _T("ID_TEXTCTRL2"));
	wxFont fnam_ctrlFont(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	fnam_ctrl->SetFont(fnam_ctrlFont);
	FlexGridSizer1->Add(fnam_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button5 = new wxButton(this, ID_BUTTON5, _("Dokument\nwaehlen"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON5"));
	wxFont Button5Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button5->SetFont(Button5Font);
	FlexGridSizer1->Add(Button5, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	StaticText2 = new wxStaticText(this, ID_STATICTEXT2, _("Signaturdatei:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT2"));
	wxFont StaticText2Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText2->SetFont(StaticText2Font);
	FlexGridSizer1->Add(StaticText2, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	signam_ctrl = new wxTextCtrl(this, ID_TEXTCTRL1, wxEmptyString, wxDefaultPosition, wxSize(616,21), 0, wxDefaultValidator, _T("ID_TEXTCTRL1"));
	wxFont signam_ctrlFont(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	signam_ctrl->SetFont(signam_ctrlFont);
	FlexGridSizer1->Add(signam_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button2 = new wxButton(this, ID_BUTTON2, _("Signatur\nwaehlen"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON2"));
	wxFont Button2Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button2->SetFont(Button2Font);
	FlexGridSizer1->Add(Button2, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	FlexGridSizer1->Add(20,78,1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	StaticText4 = new wxStaticText(this, ID_STATICTEXT4, _("Oeffentlicher Schluessel des vermuteten Unterzeichners.\nBitte nicht naiv vom Keyserver laden! \nExplizit von einer Quelle, die Sie !SELBST! geprueft haben."), wxDefaultPosition, wxSize(548,64), wxALIGN_CENTRE|wxDOUBLE_BORDER, _T("ID_STATICTEXT4"));
	StaticText4->SetForegroundColour(wxColour(213,5,5));
	wxFont StaticText4Font(11,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText4->SetFont(StaticText4Font);
	FlexGridSizer1->Add(StaticText4, 1, wxALL|wxALIGN_BOTTOM|wxALIGN_CENTER_HORIZONTAL, 5);
	FlexGridSizer1->Add(20,79,1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	pubkyid_ctrl = new wxTextCtrl(this, ID_TEXTCTRL4, wxEmptyString, wxDefaultPosition, wxSize(132,26), 0, wxDefaultValidator, _T("ID_TEXTCTRL4"));
	pubkyid_ctrl->SetForegroundColour(wxColour(0,0,0));
	pubkyid_ctrl->SetBackgroundColour(wxColour(221,244,220));
	wxFont pubkyid_ctrlFont(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	pubkyid_ctrl->SetFont(pubkyid_ctrlFont);
	FlexGridSizer1->Add(pubkyid_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_TOP, 5);
	kylabl_ctrl = new wxTextCtrl(this, ID_TEXTCTRL5, wxEmptyString, wxDefaultPosition, wxSize(647,26), 0, wxDefaultValidator, _T("ID_TEXTCTRL5"));
	kylabl_ctrl->SetBackgroundColour(wxColour(209,248,210));
	wxFont kylabl_ctrlFont(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	kylabl_ctrl->SetFont(kylabl_ctrlFont);
	FlexGridSizer1->Add(kylabl_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_TOP, 5);
	Button6 = new wxButton(this, ID_BUTTON6, _("Waehle oefftl. \nSchluessel"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON6"));
	wxFont Button6Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button6->SetFont(Button6Font);
	FlexGridSizer1->Add(Button6, 1, wxALL|wxALIGN_LEFT|wxALIGN_TOP, 5);
	Button3 = new wxButton(this, ID_BUTTON3, _("Signatur Pruefen"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON3"));
	Button3->SetBackgroundColour(wxColour(197,198,252));
	wxFont Button3Font(10,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button3->SetFont(Button3Font);
	FlexGridSizer1->Add(Button3, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	result_ctrl = new wxTextCtrl(this, ID_TEXTCTRL3, _("Noch unbestimmt"), wxDefaultPosition, wxSize(650,167), wxTE_MULTILINE, wxDefaultValidator, _T("ID_TEXTCTRL3"));
	result_ctrl->SetBackgroundColour(wxColour(208,208,208));
	wxFont result_ctrlFont(11,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	result_ctrl->SetFont(result_ctrlFont);
	FlexGridSizer1->Add(result_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	SetSizer(FlexGridSizer1);
	Timer1.SetOwner(this, ID_TIMER1);
	Timer1.Start(1000, false);
	FlexGridSizer1->Fit(this);
	FlexGridSizer1->SetSizeHints(this);

	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&gpg_verify::OnDone);
	Connect(ID_TEXTCTRL2,wxEVT_COMMAND_TEXT_ENTER,(wxObjectEventFunction)&gpg_verify::OnCheckPresence);
	Connect(ID_BUTTON5,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&gpg_verify::OnSelDocument);
	Connect(ID_TEXTCTRL1,wxEVT_COMMAND_TEXT_ENTER,(wxObjectEventFunction)&gpg_verify::Onrefresh_docname);
	Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&gpg_verify::OnSelSigfile);
	Connect(ID_BUTTON6,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&gpg_verify::OnSelectPubkey);
	Connect(ID_BUTTON3,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&gpg_verify::OnDoVerify);
	Connect(ID_TIMER1,wxEVT_TIMER,(wxObjectEventFunction)&gpg_verify::OnTimer1Trigger);
	//*)


    redcol.Set(255,120,120);grencol.Set(120,255,120);neutcol.Set(200,200,200);
    result_ctrl->SetBackgroundColour(neutcol);

    fnam_ctrl->DragAcceptFiles(true);
    fnam_ctrl->Connect(wxEVT_DROP_FILES, wxDropFilesEventHandler(gpg_verify::OnDropFile), NULL, this);



	//set pubky
    tellerror=false;
    if(get_pub_labels()<1)
    {
        //create key first
        throwout(_("Flawed installation of GnuPG\nno public keys found!\n must create one first\ndirectly in GnuPG"),3);
        tellerror=true;
    }
   if(!tellerror)
   {
	  pubkyid_ctrl->SetValue(pb_kyid[pubk_sel]);
      kylabl_ctrl->SetValue(pb_kylabel[pubk_sel]);
   }
}
/**************************************************************/
gpg_verify::~gpg_verify()
{
	//(*Destroy(gpg_verify)
	//*)
}

/*****************************************************************/
void gpg_verify::OnDone(wxCommandEvent& event)
{
    if(tellerror) EndModal(0);
    else EndModal(1);
}
/*****************************************************************/
void gpg_verify::OnSelSigfile(wxCommandEvent& event)
{
    wxString signam,docp;
    int res;

    if(cur_doc_path.IsEmpty())
    {
        docp = doc_path; //first call
    }
    else
    {
        docp = cur_doc_path;
    }
    signam = wxFileSelector(_("Select a signature file"),docp,_(""),_("sig|"),_("sig file (*.sig)|*.sig|all files(*.*)|*.*"));
    //check if exists
    if(signam.IsEmpty()) return;
    if(!wxFileExists(signam)){throwout(_("Signature file does not exist"),2); return;}
    else signam_ctrl->SetValue(signam);
    cur_doc_path= ((wxFileName)signam).GetPath(); //get new path and store into cur_doc_path
    neutralize();
    return;
}
/*****************************************************************/
void gpg_verify::Onrefresh_docname(wxCommandEvent& event)
{
    neutralize();
}
/*********************************************************************/
/*****************************************************************/
void gpg_verify::OnDoVerify(wxCommandEvent& event)
{
    bool result;
    wxString kid,fnam,snam,msg;

    msg=_("undetermined");
    kid=pubkyid_ctrl->GetLineText(0);
    fnam=fnam_ctrl->GetLineText(0);
    //check for existence
    if(!wxFile::Exists(fnam))
    {
        throwout(_("file to verify does not exist!\nDo Nothing."),3);
        return;
    }
    snam=signam_ctrl->GetLineText(0);
    //check for existence
    if(!wxFile::Exists(fnam))
    {
        throwout(_("signature file does not exist!\nDo Nothing."),3);
        return;
    }
    result=gpg_verify_signature(kid, fnam, snam, &msg);
    if(!result)
    {
        //paint wrong
        result_ctrl->SetBackgroundColour(redcol);
    }
    else
    {
        //paint true/
        result_ctrl->SetBackgroundColour(grencol);
    }
    result_ctrl->SetValue(msg);
}
/*****************************************************************/
void gpg_verify::OnImport(wxCommandEvent& event)
{
    if(!checkarm()){Close();}
    gpg_add_pub dialog(this);
    dialog.ShowModal();
    if (to_quit) Close();
    return;
}

/*****************************************************************/
void gpg_verify::OnCheckPresence(wxCommandEvent& event)
{
        neutralize();
}

/*****************************************************************/
void gpg_verify::OnSelectPubkey(wxCommandEvent& event)
{
    if(!checkarm()){Close();}
    if (to_quit) Close();

    gpg_add_pub dialog(this);
    dialog.ShowModal();

    pubkyid_ctrl->SetValue(pb_kyid[pubk_sel]);
    kylabl_ctrl->SetValue(pb_kylabel[pubk_sel]);
    neutralize();
    return;

}
/*****************************************************************/
void gpg_verify::OnSelDocument(wxCommandEvent& event)
{
    wxString ext,fnam,signam,docp;
    int res;

    if(cur_doc_path.IsEmpty())
    {
        docp = doc_path; //first call
    }
    else
    {
        docp = cur_doc_path;
    }
    fnam = wxFileSelector(_("Open a file for gpg verifying"),docp);
    //check for existence
    if(!wxFile::Exists(fnam))
    {
        throwout(_("file does not exist!\nDo Nothing."),3);
        return;
    }
    cur_doc_path= ((wxFileName)fnam).GetPath(); //get new path and store into cur_doc_path

    //if ecsg or ects -> ask
    ext=fnam.Right(5);
    if((ext == _(".ecsg"))||(ext == _(".ects"))||(fnam.Right(4)==_(".sig")))
    {
        AskDialog dialog(this,_("Do you really want to verify\na signature file or timestamp ?\nThis would be very unusual!"));
        res=dialog.ShowModal();
        if(res == 0)
        {
            return;
        }
    }
    if(fnam.IsEmpty()) return;
    fnam_ctrl->SetValue(fnam);

    signam= fnam +_(".sig");
    if  (wxFileExists(signam)) signam_ctrl->SetValue(signam);
    else
    {
        signam= fnam +_(".asc");
        if(wxFileExists(signam))
        {
            throwout(_("Couldn't find standard sig-file.\nfound and inserted candidate for asc representation ..."),3);
            signam_ctrl->SetValue(signam);
        }
        else
        {
            throwout(_("Could not find *.sig or *.asc signature file.\nYou must select one manually!"),10);
            signam=fnam.Left(fnam.Length()-4) + _(".sig");
        }
    }
    neutralize();
}
/*****************************************************************/
bool gpg_verify::neutralize()
{
        result_ctrl->SetBackgroundColour(neutcol);
        result_ctrl->SetValue(_("New Job\nValidity of Signature not determined yet."));
        return true;
}
/**************************************************************/

void gpg_verify::OnTimer1Trigger(wxTimerEvent& event)
{
    if(tellerror) EndModal(0);
    else{
        Timer1.Start(1000,wxTIMER_ONE_SHOT);
    }

}
/***************************************************************/
/*******************************************************/
void gpg_verify::OnDropFile(wxDropFilesEvent& event)
    {
        int filno,res;
        drop_succ=false;
        wxString signam,fnam,ext;

        if (event.GetNumberOfFiles() > 0) {

            wxString* dropped = event.GetFiles();
            wxASSERT(dropped);

            wxBusyCursor busyCursor;
            wxWindowDisabler disabler;
            wxBusyInfo busyInfo(_("Fuege Datei ein, bitte warten..."));

            wxString name;
            filno = event.GetNumberOfFiles();
            if(filno!=1)
            {
				throwout(_("Bitte nur ein Dateiname.\nDrop ignoriert!"),3);
				return;
			}
			if( wxDirExists( 	dropped[0]	))
            {
                throwout(_("Das ist ein Verzeichnisname!!\nNur Dateiname moeglich.\nDrop ignoriert!"),3);
                return;
            }
			name = dropped[0];
			if (!wxFileExists(name))
            {
				throwout(_("Datei existiert nicht\nDrop ignoriert!"),5);
				return;
			}

            wxTextCtrl* textCtrl = dynamic_cast<wxTextCtrl*>(event.GetEventObject());
            wxASSERT(textCtrl);
            textCtrl->Clear();
            textCtrl->SetValue(name);
            drop_succ=true;
            fnam=name;
            cur_doc_path= ((wxFileName)fnam).GetPath(); //get new path and store into cur_doc_path

    //check for existence
    if(!wxFile::Exists(fnam))
    {
        throwout(_("file does not exist!\nDo Nothing."),3);
        return;
    }
    cur_doc_path= ((wxFileName)fnam).GetPath(); //get new path and store into cur_doc_path

    //if ecsg or ects -> ask
    ext=fnam.Right(5);
    if((ext == _(".ecsg"))||(ext == _(".ects"))||(fnam.Right(4)==_(".sig")))
    {
        AskDialog dialog(this,_("Do you really want to verify\na signature file or timestamp ?\nThis would be very unusual!"));
        res=dialog.ShowModal();
        if(res == 0)
        {
            return;
        }
    }
    if(fnam.IsEmpty()) return;
    //fnam_ctrl->SetValue(fnam);

    signam= fnam +_(".sig");
    if  (wxFileExists(signam)) signam_ctrl->SetValue(signam);
    else
    {
        signam= fnam +_(".asc");
        if(wxFileExists(signam))
        {
            throwout(_("Couldn't find standard sig-file.\nfound and inserted candidate for asc representation ..."),3);
            signam_ctrl->SetValue(signam);
        }
        else
        {
            throwout(_("Could not find *.sig or *.asc signature file.\nYou must select one manually!"),10);
            signam=fnam.Left(fnam.Length()-4) + _(".sig");
        }
    }
    neutralize();
            return;
        }
    }
/*********************************************************/

