/*
 *   Copyright (C) 2011-2016, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
 

#ifndef PWSHOW_H
#define PWSHOW_H

//(*Headers(PWShow)
#include <wx/dialog.h>
#include <wx/sizer.h>
#include <wx/button.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>
#include <wx/timer.h>
//*)

class PWShow: public wxDialog
{
	public:

		PWShow(wxString* d, wxWindow* parent,wxWindowID id=wxID_ANY,const wxPoint& pos=wxDefaultPosition,const wxSize& size=wxDefaultSize);
		virtual ~PWShow();

		//(*Declarations(PWShow)
		wxButton* Button1;
		wxButton* Button2;
		wxStaticText* StaticText1;
		wxTimer Timer1;
		wxTextCtrl* TextCtrl1;
		//*)

	protected:

		//(*Identifiers(PWShow)
		static const long ID_BUTTON1;
		static const long ID_STATICTEXT1;
		static const long ID_BUTTON2;
		static const long ID_TEXTCTRL1;
		static const long ID_TIMER1;
		//*)

	private:

		//(*Handlers(PWShow)
		void OnTimer1Trigger(wxTimerEvent& event);
		void OnExitCancel(wxCommandEvent& event);
		void OnExitAccept(wxCommandEvent& event);
		void OnResetTimer(wxCommandEvent& event);
		//*)

        wxString *pd;

		DECLARE_EVENT_TABLE()
};

#endif
