/*
 *   Copyright (C) 2011-2016, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */


#ifndef ELLIPTIC_ENCIPHER_H
#define ELLIPTIC_ENCIPHER_H

//(*Headers(elliptic_encipher)
#include <wx/checkbox.h>
#include <wx/dialog.h>
#include <wx/sizer.h>
#include <wx/button.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>
#include <wx/choice.h>
//*)
//#include <wx/choice.h>
#include "elliptic1.h"
#include "random_clx.h"

class elliptic_encipher: public wxDialog
{
	public:

		elliptic_encipher(wxWindow* parent);
		virtual ~elliptic_encipher();

		//(*Declarations(elliptic_encipher)
		wxTextCtrl* domnam_ctrl;
		wxTextCtrl* Ax_ctrl;
		wxButton* Button4;
		wxButton* Button1;
		wxButton* Button2;
		wxButton* Button3;
		wxTextCtrl* id_ctrl;
		wxStaticText* StaticText1;
		wxStaticText* StaticText3;
		wxButton* Button5;
		wxStaticText* StaticText8;
		wxStaticText* StaticText7;
		wxChoice* algo_choice;
		wxStaticText* StaticText4;
		wxStaticText* StaticText5;
		wxStaticText* StaticText2;
		wxTextCtrl* Ay_ctrl;
		wxStaticText* StaticText6;
		wxTextCtrl* cfnam_ctrl;
		wxTextCtrl* fullnam_ctrl;
		wxCheckBox* nada_box;
		wxStaticText* StaticText9;
		wxButton* Button6;
		wxTextCtrl* fnam_ctrl;
		//*)

        wxString fnam;
        el_pub loky;
        ellipse locell;

	protected:

		//(*Identifiers(elliptic_encipher)
		static const long ID_BUTTON4;
		static const long ID_STATICTEXT1;
		static const long ID_STATICTEXT2;
		static const long ID_TEXTCTRL1;
		static const long ID_BUTTON1;
		static const long ID_STATICTEXT3;
		static const long ID_BUTTON2;
		static const long ID_STATICTEXT8;
		static const long ID_TEXTCTRL2;
		static const long ID_TEXTCTRL7;
		static const long ID_STATICTEXT9;
		static const long ID_TEXTCTRL3;
		static const long ID_BUTTON3;
		static const long ID_STATICTEXT4;
		static const long ID_TEXTCTRL4;
		static const long ID_NADABOX;
		static const long ID_STATICTEXT5;
		static const long ID_TEXTCTRL5;
		static const long ID_BUTTON6;
		static const long ID_STATICTEXT7;
		static const long ID_TEXTCTRL6;
		static const long ID_STATICTEXT6;
		static const long ID_BUTTON5;
		static const long ID_CHOICE1;
		//*)

	private:

		//(*Handlers(elliptic_encipher)
		void OnSelectFile(wxCommandEvent& event);
		void OnLoadKeyFromStore(wxCommandEvent& event);
		void OnLoadfromKeyfile(wxCommandEvent& event);
		void OnExit_cancel(wxCommandEvent& event);
		void OnDoEnciph(wxCommandEvent& event);
		void Splicetest(wxCommandEvent& event);
		void OnRadioButton1Select(wxCommandEvent& event);
		void OnAy_ctrlText(wxCommandEvent& event);
		void OnNewEncipher(wxCommandEvent& event);
		void OnNADAInfo(wxCommandEvent& event);
		//*)


        void OnDropFile(wxDropFilesEvent& event);
        bool drop_succ;  //provide Feedback

		DECLARE_EVENT_TABLE()
};

#endif
