/*
 *   Copyright (C) 2011-2016, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */


#include "elliptic_encipher.h"
#include "helpersxx.h"
#include "AskInput.h"
#include "Cap_Questn.h"
#include <wx/filedlg.h>
#include <wx/filename.h>
#include <wx/ffile.h>

#include <wx/arrstr.h>
#include <wx/dir.h>
#include <wx/busyinfo.h>


//(*InternalHeaders(elliptic_encipher)
#include <wx/string.h>
#include <wx/intl.h>
#include <wx/font.h>
//*)

#include "LoadEllKey.h"
#include "globals.h"

//(*IdInit(elliptic_encipher)
const long elliptic_encipher::ID_BUTTON4 = wxNewId();
const long elliptic_encipher::ID_STATICTEXT1 = wxNewId();
const long elliptic_encipher::ID_STATICTEXT2 = wxNewId();
const long elliptic_encipher::ID_TEXTCTRL1 = wxNewId();
const long elliptic_encipher::ID_BUTTON1 = wxNewId();
const long elliptic_encipher::ID_STATICTEXT3 = wxNewId();
const long elliptic_encipher::ID_BUTTON2 = wxNewId();
const long elliptic_encipher::ID_STATICTEXT8 = wxNewId();
const long elliptic_encipher::ID_TEXTCTRL2 = wxNewId();
const long elliptic_encipher::ID_TEXTCTRL7 = wxNewId();
const long elliptic_encipher::ID_STATICTEXT9 = wxNewId();
const long elliptic_encipher::ID_TEXTCTRL3 = wxNewId();
const long elliptic_encipher::ID_BUTTON3 = wxNewId();
const long elliptic_encipher::ID_STATICTEXT4 = wxNewId();
const long elliptic_encipher::ID_TEXTCTRL4 = wxNewId();
const long elliptic_encipher::ID_NADABOX = wxNewId();
const long elliptic_encipher::ID_STATICTEXT5 = wxNewId();
const long elliptic_encipher::ID_TEXTCTRL5 = wxNewId();
const long elliptic_encipher::ID_BUTTON6 = wxNewId();
const long elliptic_encipher::ID_STATICTEXT7 = wxNewId();
const long elliptic_encipher::ID_TEXTCTRL6 = wxNewId();
const long elliptic_encipher::ID_STATICTEXT6 = wxNewId();
const long elliptic_encipher::ID_BUTTON5 = wxNewId();
const long elliptic_encipher::ID_CHOICE1 = wxNewId();
//*)

BEGIN_EVENT_TABLE(elliptic_encipher,wxDialog)
	//(*EventTable(elliptic_encipher)
	//*)
END_EVENT_TABLE()

elliptic_encipher::elliptic_encipher(wxWindow* parent)
{
    wxString h;
    if(!checkarm()){Close();}


	//(*Initialize(elliptic_encipher)
	wxFlexGridSizer* FlexGridSizer1;

	Create(parent, wxID_ANY, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("wxID_ANY"));
	FlexGridSizer1 = new wxFlexGridSizer(0, 3, 0, 0);
	Button4 = new wxButton(this, ID_BUTTON4, _("Schliessen"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON4"));
	Button4->SetBackgroundColour(wxColour(232,163,163));
	wxFont Button4Font(11,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button4->SetFont(Button4Font);
	FlexGridSizer1->Add(Button4, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText1 = new wxStaticText(this, ID_STATICTEXT1, _("Chiffrieren mit ECC"), wxDefaultPosition, wxSize(232,36), 0, _T("ID_STATICTEXT1"));
	wxFont StaticText1Font(15,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText1->SetFont(StaticText1Font);
	FlexGridSizer1->Add(StaticText1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	FlexGridSizer1->Add(-1,-1,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText2 = new wxStaticText(this, ID_STATICTEXT2, _("Klartext Datei"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT2"));
	wxFont StaticText2Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText2->SetFont(StaticText2Font);
	FlexGridSizer1->Add(StaticText2, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	fnam_ctrl = new wxTextCtrl(this, ID_TEXTCTRL1, wxEmptyString, wxDefaultPosition, wxSize(565,23), 0, wxDefaultValidator, _T("ID_TEXTCTRL1"));
	wxFont fnam_ctrlFont(6,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	fnam_ctrl->SetFont(fnam_ctrlFont);
	FlexGridSizer1->Add(fnam_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button1 = new wxButton(this, ID_BUTTON1, _("Datei waehlen"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON1"));
	wxFont Button1Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button1->SetFont(Button1Font);
	FlexGridSizer1->Add(Button1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	FlexGridSizer1->Add(-1,-1,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText3 = new wxStaticText(this, ID_STATICTEXT3, _("oefftl. Schluessel des Empfaengers"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT3"));
	wxFont StaticText3Font(11,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText3->SetFont(StaticText3Font);
	FlexGridSizer1->Add(StaticText3, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	Button2 = new wxButton(this, ID_BUTTON2, _("Empfaengerschluessel\n aus Speicher"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON2"));
	wxFont Button2Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button2->SetFont(Button2Font);
	FlexGridSizer1->Add(Button2, 1, wxALL|wxALIGN_TOP|wxALIGN_CENTER_HORIZONTAL, 5);
	StaticText8 = new wxStaticText(this, ID_STATICTEXT8, _("Key ID:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT8"));
	wxFont StaticText8Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText8->SetFont(StaticText8Font);
	FlexGridSizer1->Add(StaticText8, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	id_ctrl = new wxTextCtrl(this, ID_TEXTCTRL2, _("key_id"), wxDefaultPosition, wxSize(235,23), 0, wxDefaultValidator, _T("ID_TEXTCTRL2"));
	id_ctrl->SetBackgroundColour(wxColour(191,248,203));
	wxFont id_ctrlFont(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	id_ctrl->SetFont(id_ctrlFont);
	FlexGridSizer1->Add(id_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	domnam_ctrl = new wxTextCtrl(this, ID_TEXTCTRL7, _("Domnam"), wxDefaultPosition, wxSize(88,20), 0, wxDefaultValidator, _T("ID_TEXTCTRL7"));
	domnam_ctrl->Disable();
	wxFont domnam_ctrlFont(7,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	domnam_ctrl->SetFont(domnam_ctrlFont);
	FlexGridSizer1->Add(domnam_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText9 = new wxStaticText(this, ID_STATICTEXT9, _("voller Name:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT9"));
	wxFont StaticText9Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText9->SetFont(StaticText9Font);
	FlexGridSizer1->Add(StaticText9, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	fullnam_ctrl = new wxTextCtrl(this, ID_TEXTCTRL3, _("Voller Name"), wxDefaultPosition, wxSize(430,23), 0, wxDefaultValidator, _T("ID_TEXTCTRL3"));
	fullnam_ctrl->SetBackgroundColour(wxColour(177,249,187));
	wxFont fullnam_ctrlFont(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	fullnam_ctrl->SetFont(fullnam_ctrlFont);
	FlexGridSizer1->Add(fullnam_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_TOP, 5);
	Button3 = new wxButton(this, ID_BUTTON3, _("Empfaengerschl.\naus Datei"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON3"));
	wxFont Button3Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button3->SetFont(Button3Font);
	FlexGridSizer1->Add(Button3, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText4 = new wxStaticText(this, ID_STATICTEXT4, _("Ax:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT4"));
	wxFont StaticText4Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText4->SetFont(StaticText4Font);
	FlexGridSizer1->Add(StaticText4, 1, wxALL|wxALIGN_RIGHT|wxALIGN_BOTTOM, 5);
	Ax_ctrl = new wxTextCtrl(this, ID_TEXTCTRL4, wxEmptyString, wxDefaultPosition, wxSize(567,23), 0, wxDefaultValidator, _T("ID_TEXTCTRL4"));
	Ax_ctrl->SetBackgroundColour(wxColour(187,242,194));
	wxFont Ax_ctrlFont(7,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Ax_ctrl->SetFont(Ax_ctrlFont);
	FlexGridSizer1->Add(Ax_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	nada_box = new wxCheckBox(this, ID_NADABOX, _("NADA Cap verwenden"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_NADABOX"));
	nada_box->SetValue(false);
	wxFont nada_boxFont(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	nada_box->SetFont(nada_boxFont);
	FlexGridSizer1->Add(nada_box, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText5 = new wxStaticText(this, ID_STATICTEXT5, _("Ay:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT5"));
	wxFont StaticText5Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText5->SetFont(StaticText5Font);
	FlexGridSizer1->Add(StaticText5, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	Ay_ctrl = new wxTextCtrl(this, ID_TEXTCTRL5, wxEmptyString, wxDefaultPosition, wxSize(569,23), 0, wxDefaultValidator, _T("ID_TEXTCTRL5"));
	Ay_ctrl->SetBackgroundColour(wxColour(203,246,209));
	wxFont Ay_ctrlFont(7,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Ay_ctrl->SetFont(Ay_ctrlFont);
	FlexGridSizer1->Add(Ay_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_TOP, 5);
	Button6 = new wxButton(this, ID_BUTTON6, _("Was ist ein\nNADA Cap\?"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON6"));
	Button6->SetBackgroundColour(wxColour(152,207,249));
	wxFont Button6Font(7,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button6->SetFont(Button6Font);
	FlexGridSizer1->Add(Button6, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText7 = new wxStaticText(this, ID_STATICTEXT7, _("Chiffretext\nDateiname"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT7"));
	wxFont StaticText7Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText7->SetFont(StaticText7Font);
	FlexGridSizer1->Add(StaticText7, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	cfnam_ctrl = new wxTextCtrl(this, ID_TEXTCTRL6, _("Cipher Filename"), wxDefaultPosition, wxSize(572,23), 0, wxDefaultValidator, _T("ID_TEXTCTRL6"));
	cfnam_ctrl->SetBackgroundColour(wxColour(255,207,248));
	wxFont cfnam_ctrlFont(7,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	cfnam_ctrl->SetFont(cfnam_ctrlFont);
	FlexGridSizer1->Add(cfnam_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	StaticText6 = new wxStaticText(this, ID_STATICTEXT6, _("Chiffre auswaehlen"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT6"));
	wxFont StaticText6Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText6->SetFont(StaticText6Font);
	FlexGridSizer1->Add(StaticText6, 1, wxALL|wxALIGN_BOTTOM|wxALIGN_CENTER_HORIZONTAL, 5);
	FlexGridSizer1->Add(-1,-1,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button5 = new wxButton(this, ID_BUTTON5, _("Chiffrieren"), wxDefaultPosition, wxSize(224,34), 0, wxDefaultValidator, _T("ID_BUTTON5"));
	Button5->SetBackgroundColour(wxColour(104,210,241));
	wxFont Button5Font(11,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button5->SetFont(Button5Font);
	FlexGridSizer1->Add(Button5, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	algo_choice = new wxChoice(this, ID_CHOICE1, wxDefaultPosition, wxSize(180,29), 0, 0, 0, wxDefaultValidator, _T("ID_CHOICE1"));
	algo_choice->Append(_("Fleas_l    (CBC, Bl:1kb 2pth)"));
	algo_choice->Append(_("Fleas_lb  (CBC, Bl:1kb 2pth)"));
	algo_choice->Append(_("Fleas_lc  (CBC, Bl:1kb 3pth)"));
	algo_choice->Append(_("AES  (CBC,Bl:16b, key:32b)"));
	algo_choice->Append(_("Threefish(CTR, 128 byte)"));
	algo_choice->SetSelection( algo_choice->Append(_("F_cnt_lb (CTR, 2kb, 2pth)")) );
	algo_choice->Append(_("F_cnt_lc (CTR, 2kb, 3 pth)"));
	algo_choice->Append(_("F_cnt_ld (CTR, 2kb, 4 pth)"));
	algo_choice->Append(_("flightx(CTR,2kb,marg. sec!)"));
	algo_choice->Append(_("chimera(CTR,2kb,4paranoia)"));
	wxFont algo_choiceFont(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	algo_choice->SetFont(algo_choiceFont);
	FlexGridSizer1->Add(algo_choice, 1, wxALL|wxALIGN_LEFT|wxALIGN_TOP, 5);
	SetSizer(FlexGridSizer1);
	FlexGridSizer1->Fit(this);
	FlexGridSizer1->SetSizeHints(this);

	Connect(ID_BUTTON4,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&elliptic_encipher::OnExit_cancel);
	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&elliptic_encipher::OnSelectFile);
	Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&elliptic_encipher::OnLoadKeyFromStore);
	Connect(ID_BUTTON3,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&elliptic_encipher::OnLoadfromKeyfile);
	Connect(ID_BUTTON6,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&elliptic_encipher::OnNADAInfo);
	Connect(ID_BUTTON5,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&elliptic_encipher::OnNewEncipher);
	//*)

	fnam_ctrl->DragAcceptFiles(true);
    fnam_ctrl->Connect(wxEVT_DROP_FILES, wxDropFilesEventHandler(elliptic_encipher::OnDropFile), NULL, this);



    //check if still Trivial
	if(el_pk.id==_("Trivial"))
	{
        if(!load_pub_ell_ky(&el_pk, &def_pubkey))
           {
               throwout(_("Could not load default public key!"),5);
               def_pubkey=_("empty");
           }
    }
    loky.copy_pub_ky(&el_pk);
    id_ctrl->SetValue(loky.id);
    fullnam_ctrl->SetValue(loky.fullnam);
    domnam_ctrl->SetValue(loky.domnam);
    loky.A.x.writehex(&h);
    Ax_ctrl->SetValue(h);
    loky.A.y.writehex(&h);
    Ay_ctrl->SetValue(h);

	if((def_cip>-1)&&(def_cip<9))
    {
        switch(def_cip)
        {
          case 0:
            algo_choice->SetSelection(3); break;
          case 1:
            algo_choice->SetSelection(4); break;
          case 2:
            algo_choice->SetSelection(8); break;
          case 3:
            algo_choice->SetSelection(5); break;
          case 4:
            algo_choice->SetSelection(6); break;
          case 5:
            algo_choice->SetSelection(7); break;
          case 6:
            algo_choice->SetSelection(0); break;
          case 7:
            algo_choice->SetSelection(2); break;
          case 8:
            algo_choice->SetSelection(9); break;
           //no default necessary
        }
    }


}
/*****************************************************************************/
elliptic_encipher::~elliptic_encipher()
{
	//(*Destroy(elliptic_encipher)
	//*)
}
/*******************************************************/
void elliptic_encipher::OnDropFile(wxDropFilesEvent& event)
    {
        int filno;
        drop_succ=false;
        unsigned char ch1;

        if (event.GetNumberOfFiles() > 0) {

            wxString* dropped = event.GetFiles();
            wxASSERT(dropped);

            wxBusyCursor busyCursor;
            wxWindowDisabler disabler;
            wxBusyInfo busyInfo(_("Fuege Dateien hinzu, bitte warten..."));

            wxString name;
            filno = event.GetNumberOfFiles();
            if(filno!=1)
            {
				throwout(_("Nur ein Dateiname bitte.\nEinfuegen verweigert!"),3);
				return;
			}
			if( wxDirExists( 	dropped[0]	))
            {
                throwout(_("Das ist ein Verzeichnisname!!\nNur Dateiname moeglich.\nDrop ignoriert!"),3);
                return;
            }
			name = dropped[0];
			if (!wxFileExists(name))
            {
				throwout(_("Datei existiert nicht.\nEinfuegen verweigert!"),5);
				return;
			}

            wxTextCtrl* textCtrl = dynamic_cast<wxTextCtrl*>(event.GetEventObject());
            wxASSERT(textCtrl);
            textCtrl->Clear();
            textCtrl->SetValue(name);
            fnam=name;
            drop_succ=true;
            cur_cry_path= ((wxFileName)fnam).GetPath(); //get new path and store into cur_doc_path
    // set cipherfile name suggestion
    wxString mypath,myname,separator,s,cry_d;
    longnumber rndnam;
    separator=wxFileName::GetPathTerminators();
    wxFileName::SplitPath(fnam, &mypath, &myname,NULL);
    rndnam.makerandom(10);
    rndnam.writehex(&s);
    //determine subtractor from last byte
    ch1= *(rndnam.ad + 9);
    ch1 >>= 5;
    rndnam.writehex(&s);
    if(ch1<9) s.Truncate(19-ch1); //always truncates
    s= mypath + separator + s;
    cfnam_ctrl->SetValue(s);
            return;
        }
    }
/*********************************************************/
/*****************************************************************************/

void elliptic_encipher::OnSelectFile(wxCommandEvent& event)
{
    wxString mypath,myname,separator,s,cry_d;
    longnumber rndnam;
    unsigned char ch1;

    if(!checkarm()){Close();}
    if(cur_cry_path.IsEmpty())
    {
        cry_d = cry_path; //first call
    }
    else
    {
        cry_d = cur_cry_path;
    }
    fnam = wxFileSelector(_("Waehle eine Klardatei zur Chiffrierung"),cry_d);
    if ( !fnam.empty() )
    {
        fnam_ctrl->SetValue(fnam);
        cur_cry_path= ((wxFileName)fnam).GetPath(); //get new path and store into cur_doc_path
    }
    else
    {
		throwout(_("Keine Datei gewaehlt\nAbbruch!"),2);
	}
    // set cipherfile name suggestion
    separator=wxFileName::GetPathTerminators();
    wxFileName::SplitPath(fnam, &mypath, &myname,NULL);
    //make long name
    rndnam.makerandom(10);
    //determine subtractor from last byte
    ch1= *(rndnam.ad + 9);
    ch1 >>= 5;
    rndnam.writehex(&s);
    if(ch1<9) s.Truncate(19-ch1);
    s= mypath + separator + s;
    cfnam_ctrl->SetValue(s);
}
/*****************************************************************************/
void elliptic_encipher::OnLoadKeyFromStore(wxCommandEvent& event)
{
    wxString h;

    if(!checkarm()){Close();}
    LoadEllKey dialog(this,&loky);
    dialog.ShowModal();

    id_ctrl->SetValue(loky.id);
    fullnam_ctrl->SetValue(loky.fullnam);
    domnam_ctrl->SetValue(loky.domnam);
    if(!e_ls.isinlist(loky.domnam)) throwout(_("Schluessel Domain unbekannt\nkann nicht chiffrieren!"),5);
    loky.A.x.writehex(&h);
    Ax_ctrl->SetValue(h);
    loky.A.y.writehex(&h);
    Ay_ctrl->SetValue(h);
    el_pk.copy_pub_ky(&loky);
    def_pubkey=loky.id;
}
/*****************************************************************************/
void elliptic_encipher::OnLoadfromKeyfile(wxCommandEvent& event)
{
    wxString importfile,h;
    el_pub oldkey;
    int elfl;

    if(!checkarm()){Close();}
    oldkey.copy_pub_ky(&loky);
    importfile = wxFileSelector(_("Waehle Schluesseldatei"),kytray,_(""),_("pell"),_("*.pell"));
    loky.get_from_file(importfile);
    //check on curve?
    if(loky.domnam==gdom.name) locell.copyell(&gdom);
    else
    {
            elfl=e_ls.getelp(&locell,loky.domnam);
            if(elfl<0)
            {
                throwout(_("unbekannter Domain Name!\nKann nicht mit diesem Schluessel chiffrieren."),8);
                return;
            }
    }

    if(! (loky.A).is_in_ellipse(&locell))
    {
        wxMessageBox(_("Schluessel ist inkompatibel mit aktueller Domain\n Laden verweigert!\nZurueck gesetzt auf letzten validen Schluessel"));
        loky.copy_pub_ky(&oldkey);
        return;
    }
    // wenn bestanden jetzt alles eintragen
    id_ctrl->SetValue(loky.id);
    fullnam_ctrl->SetValue(loky.fullnam);
    domnam_ctrl->SetValue(loky.domnam);
    loky.A.x.writehex(&h);
    Ax_ctrl->SetValue(h);
    loky.A.y.writehex(&h);
    Ay_ctrl->SetValue(h);
    el_pk.copy_pub_ky(&loky);
}
/*****************************************************************************/
void elliptic_encipher::OnExit_cancel(wxCommandEvent& event)
{
    Close();
}
/*****************************************************************************/
void elliptic_encipher::OnDoEnciph(wxCommandEvent& event)
{
    wxString mypath,myname,separator,myrand,s,mys0,s1n,s2n,ext,domnam,h,h1,cnam,algo=_("Fleas_1_8");
    unsigned char *rbuff;
    int i,anum,elfl;
    unsigned long bufflen,j;
    double decoylen;
    longnumber ke,key;
    e_p B,KY;
    bool hide_names=false;

    if(!checkarm()){Close();}
    //get algo
    anum= algo_choice->GetCurrentSelection();
      if(anum==0) algo= _("Fleas_l");
      else if(anum==1) algo= _("Fleas_lb");
      else if(anum==2) algo= _("Fleas_lc");
      else if(anum==3) algo= _("aes");
      else if(anum==4) algo= _("threefish");
      else if(anum==5) algo= _("F_cnt_1b");
      else if(anum==6) algo= _("F_cnt_1c");
      else if(anum==7) algo= _("F_cnt_1d");
      else if(anum==8) algo= _("flightx");
      else if(anum==9) algo= _("chimera");

         else{ throwout(_("Kein Algorithmus spezifiziert! \nAbbruch.")); return;}
    bufflen=256*(unsigned int)zuf.get_rbyte();
    bufflen += (unsigned int)zuf.get_rbyte();
    rbuff=(unsigned char*) malloc(30); //padding=
    //puffer füllen ohne X: marker(88,58)
    for(i=0;i<30;i++)
    {
        *(rbuff+i)= zuf.get_rbyte();
    }
    for(i=0;i<29;i++) //remove X: markers
    {
        while(*(rbuff+i)=='X' && *(rbuff+i+1)==':') //Marker detected
        {
            *(rbuff+i)= zuf.get_rbyte();
            *(rbuff+i+1)= zuf.get_rbyte();
        }
    }
    fnam = fnam_ctrl->GetLineText(0);
    //check for existence
    if(!wxFile::Exists(fnam))
    {
        throwout(_("Zu chiffrierende Datei existiert nicht!\nTue Nichts."),3);
        return;
    }
    //check for length
    wxFile firfil(fnam);
    decoylen= firfil.Length();
    firfil.Close();
    bufflen= (unsigned long) (sqrt((decoylen * (double)bufflen) / (double)16003 ));
    bufflen+=zuf.get_rbyte();
    // separate path
    separator=wxFileName::GetPathTerminators();
    wxFileName::SplitPath(fnam, &mypath, &myname,&ext);
    longnumber hln1;
    hln1.makerandom(6);
    //convert to string;
    hln1.writehex(&myrand);
    mys0=mypath+separator+_("s0_") + myrand; //hier muss noch myrnd ran
    //change blanks to underscore
    myname.Replace(_(" "),_("_"));
    myname.Replace(_("X:"),_("X_"));  //remove the splicemarker if present
    ext.Replace(_("X:"),_("X_"));
    s=_(" fnam: ") + myname;
    if(!ext.IsEmpty()) s += _(".")+ ext; //nur wenn ext vorhanden, den punkt ran

// to do: add flexible number of non X: chars
    for (j=0;j<bufflen;j++)
    {
        s+=_(" ");
    }
// end to do

    s += _(" X:");
    wxFFile fs0(mys0, _("wb"));
    fs0.Write(rbuff,30);
    fs0.Write(s);
    fs0.Close();
    //concat s0, s_initl to s1  -> muss dann weg!
    s1n=mypath+separator+_("s1")+myrand;
    fileconcat(mys0,fnam,s1n);
        //delete remainder, keep original
    wxRemoveFile(mys0);
    //check if gdom equals adressees domain
    domnam=domnam_ctrl->GetLineText(0);
    if(gdom.name != domnam)
    {
        elfl=e_ls.getelp(&locell,domnam);
        if(elfl<0)
        {
            throwout(_("Empfaengers Schluesseldomain unbekannt 8-O\n-> Du musst zuerst die richtige Domain importieren!"));
            return;
        }
    }
    else locell.copyell(&gdom);
    //build ke, generate key = (d0*ke).x
    //maxsiz= (locell.q).size -1;
    // choose lonu ke as random ephemeralky < q
    ke.makerandom(&(locell.q));
    KY.copy_ep(&(locell.d0));
    KY.mult_p_qj(&ke,&locell);
    key.copynum(&(KY.x));
    key.shrinktofit();
    B.copy_ep(&(loky.A));
    //refresh from testfields
    h=Ax_ctrl->GetLineText(0);
    B.x.storhex(&h);
    h=Ay_ctrl->GetLineText(0);
    B.y.storhex(&h);
    if(! B.is_in_ellipse(&locell))
    {
        wxMessageBox(_("Oefftl. Schluessel ist imkompatibel mit aktueller Domain\n keine Chiffrierung"));
        return;
    }
    B.mult_p_qj(&ke,&locell);
        //lockinplace file s1n
    lockinplace(s1n,&key,algo,1);
   //prepend ell cipherinfo: kid: domnam: Bx: By: X:
    s2n=mypath+separator+_("s2") + myrand;
    wxFFile fs1(s2n, _("wb"));
    //determine if hidekey is set
    if(hide_names)  //if(hide_names->IsChecked())
    {
        h1=_("kid: xxx  ");
    }
    else{
        h1=_("kid: ") + loky.id + _(" ");
    }
    h1 += _("domnam: ") + locell.name + _("\n Bx: ");
    B.x.writehex(&h);
    h1 += h + _("\n By: ");
    B.y.writehex(&h);
    h1 += h + _(" algo: ") +algo +  _(" X:");
    fs1.Write(h1);
    fs1.Close();
    cnam=cfnam_ctrl->GetLineText(0);
    if(algo==_("Fleas_1_8")) fileconcat(s2n,s1n+_("_c3"), cnam);
    else if(algo==_("Fleas_3")) fileconcat(s2n,s1n+_("_f3"), cnam);
    else if(algo==_("Fleas_4")) fileconcat(s2n,s1n+_("_f4"), cnam);
    else if(algo==_("Fleas_5")) fileconcat(s2n,s1n+_("_f5"), cnam);
    else if(algo==_("Fleas_x2")) fileconcat(s2n,s1n+_("_x2"), cnam);
    else if(algo==_("Fleas_x5")) fileconcat(s2n,s1n+_("_x5"), cnam);
    else if(algo==_("Fleas_o2")) fileconcat(s2n,s1n+_("_o2"), cnam);
    else if(algo==_("Fleas_o5")) fileconcat(s2n,s1n+_("_o5"), cnam);
    else if(algo==_("Fleas_l")) fileconcat(s2n,s1n+_("_l"), cnam);
    else if(algo==_("Fleas_ls")) fileconcat(s2n,s1n+_("_ls"), cnam);
    else if(algo==_("Fleas_l3")) fileconcat(s2n,s1n+_("_l3"), cnam);
    else if(algo==_("Fleas_lb")) fileconcat(s2n,s1n+_("_lb"), cnam);
    else if(algo==_("Fleas_lc")) fileconcat(s2n,s1n+_("_lc"), cnam);
    else if(algo==_("Fleas_ld")) fileconcat(s2n,s1n+_("_ld"), cnam);
    else if(algo==_("F_cnt_1c")) fileconcat(s2n,s1n+_("_1c"), cnam);
    else if(algo==_("F_cnt_1d")) fileconcat(s2n,s1n+_("_1d"), cnam);
    else if(algo==_("F_cnt_1b")) fileconcat(s2n,s1n+_("_1b"), cnam);
    else if(algo==_("flight")) fileconcat(s2n,s1n+_("_fl"), cnam);
    else if(algo==_("flightx")) fileconcat(s2n,s1n+_("_fx"), cnam);
    else if(algo==_("aes")) fileconcat(s2n,s1n+_("_ae"), cnam);
    else if(algo==_("threefish")) fileconcat(s2n,s1n+_("_tf"), cnam);
    else if(algo==_("chimera")) fileconcat(s2n,s1n+_("_ff"), cnam);
       else throwout(_("Error 3: Unknown algorithm specifier\nmust clean up manually!"));
    //remove remainders
    wxRemoveFile(s2n);
    if(algo==_("Fleas_1_8")) wxRemoveFile(s1n+_("_c3"));
    else if(algo==_("Fleas_3"))  wxRemoveFile(s1n+_("_f3"));
    else if(algo==_("Fleas_4"))  wxRemoveFile(s1n+_("_f4"));
    else if(algo==_("Fleas_5"))  wxRemoveFile(s1n+_("_f5"));
    else if(algo==_("Fleas_x2"))  wxRemoveFile(s1n+_("_x2"));
    else if(algo==_("Fleas_x5"))  wxRemoveFile(s1n+_("_x5"));
    else if(algo==_("Fleas_o2"))  wxRemoveFile(s1n+_("_o2"));
    else if(algo==_("Fleas_o5"))  wxRemoveFile(s1n+_("_o5"));
    else if(algo==_("Fleas_l"))  wxRemoveFile(s1n+_("_l"));
    else if(algo==_("Fleas_ls"))  wxRemoveFile(s1n+_("_ls"));
    else if(algo==_("Fleas_l3"))  wxRemoveFile(s1n+_("_l3"));
    else if(algo==_("Fleas_lb"))  wxRemoveFile(s1n+_("_lb"));
    else if(algo==_("Fleas_lc"))  wxRemoveFile(s1n+_("_lc"));
    else if(algo==_("Fleas_ld"))  wxRemoveFile(s1n+_("_ld"));
    else if(algo==_("aes"))  wxRemoveFile(s1n+_("_ae"));
    else if(algo==_("F_cnt_1c"))  wxRemoveFile(s1n+_("_1c"));
    else if(algo==_("F_cnt_1d"))  wxRemoveFile(s1n+_("_1d"));
    else if(algo==_("F_cnt_1b"))  wxRemoveFile(s1n+_("_1b"));
    else if(algo==_("flight"))  wxRemoveFile(s1n+_("_fl"));
    else if(algo==_("flightx"))  wxRemoveFile(s1n+_("_fx"));
    else if(algo==_("threefish"))  wxRemoveFile(s1n+_("_tf"));
    else if(algo==_("chimera"))  wxRemoveFile(s1n+_("_ff"));

    throwout(_("enciphered"),2);
}
/*****************************************************************************/

void elliptic_encipher::Splicetest(wxCommandEvent& event)
{
    wxString splfil;

    splfil=fnam_ctrl->GetLineText(0);
    if( splicefile(splfil, _("teil1.txt"), _("teil2.txt"), _("FIN::") )) throwout(_("Splicing erfolgreich!"));
    else throwout(_("kein splicing :-(  "));
}
/********************************************************************************/
void elliptic_encipher::OnNewEncipher(wxCommandEvent& event)
{
    wxString mypath,myname,separator,myrand,s,mys0,s1n,s2n,ext,domnam,h,h1,cnam,capkey,algo=_("Fleas_1_8");
    unsigned char *rbuff;
    int i,anum,elfl,kr,blsiz,res;
    unsigned long bufflen,j;
    double decoylen;
    longnumber ke,key,salt,counter,nckey;
    e_p B,KY;
    bool resenc,hascap=false,intrinsic=true, hide_names=false,islegacy=false;
    char fr;
    wxString endmark=_("X:");
    int saltlen=256, counterlen = 512;
    ellipse el1024;
    int stretch=13;
    int mode = 13; //Fleas ld monothred, 13 is multithread
    int endmsiz, readflag;
    char buff[100],cbuf[100],c,*otpbuff;
    ulong32 usecnt=0,useblock=0;


    //now to do
    if(!checkarm()){Close();}
    //check for plain file existence
    fnam = fnam_ctrl->GetLineText(0);
    if(!wxFile::Exists(fnam))
    {
        throwout(_("Zu chiffrierende Datei nicht vorhanden!\nTue Nichts."),3);
        return;
    }
    //get algo
    anum= algo_choice->GetCurrentSelection();
      if(anum==0) algo= _("Fleas_l");
      else if(anum==1) algo= _("Fleas_lb");
      else if(anum==2) algo= _("Fleas_lc");
      else if(anum==3) algo= _("aes");
      else if(anum==4) algo= _("threefish");
      else if(anum==5) algo= _("F_cnt_1b");
      else if(anum==6) algo= _("F_cnt_1c");
      else if(anum==7) algo= _("F_cnt_1d");
      else if(anum==8) algo= _("flightx");
      else if(anum==9) algo= _("chimera");

         else{ throwout(_("No algorithm specified! \nAborting.")); return;}

    // separate and store name parts
    separator=wxFileName::GetPathTerminators();
    wxFileName::SplitPath(fnam, &mypath, &myname,&ext);
    longnumber hln1;
    hln1.makerandom(6);
    //convert to string;
    hln1.writehex(&myrand);

    //build 1st level header and name with cipherfilename.
   /********* make fist level clear header file  *******/
    domnam=domnam_ctrl->GetLineText(0);
    if(gdom.name != domnam)
    {
        elfl=e_ls.getelp(&locell,domnam);
        if(elfl<0)
        {
            throwout(_("Domain des Empfaengerschluessels unbekannt 8-O\n->Du musst erst die geeignete Domain importieren!"));
            return;
        }
    }
    else locell.copyell(&gdom);
    ke.makerandom(&(locell.q));
    KY.copy_ep(&(locell.d0));
    KY.mult_p_qj(&ke,&locell);
    key.copynum(&(KY.x));
    key.shrinktofit();
    B.copy_ep(&(loky.A));
    //refresh from testfields
    h=Ax_ctrl->GetLineText(0);
    B.x.storhex(&h);
    h=Ay_ctrl->GetLineText(0);
    B.y.storhex(&h);
    if(! B.is_in_ellipse(&locell))
    {
        wxMessageBox(_("Oefftl. Schluessel ist inkompatibel mit aktueller Domain\n keine Chiffrierung"));
        return;
    }
    B.mult_p_qj(&ke,&locell);
   //write 1st level header file, ell cipherinfo: kid: domnam: Bx: By: X:
    cnam=cfnam_ctrl->GetLineText(0); //get cipher file name
    wxFFile fs1(cnam, _("wb")); //open file to write to
    //determine if hidekey is set
     if(hide_names)         //if(hide_names->IsChecked())
    {
        h1=_("kid: xxx  ");
    }
    else{
        h1=_("kid: ") + loky.id + _(" ");
    }
    h1 += _("domnam: ") + locell.name + _("\n Bx: ");
    B.x.writehex(&h);
    h1 += h + _("\n By: ");
    B.y.writehex(&h);
    h1 += h + _(" algo: ") +algo +  _(" X:");
    /******************prepare info relevant for NADA Cap *******************/
    //get status of checkbox
    if(nada_box->IsChecked())
    {
        hascap=true;
    }
    if(hascap)
    {
        //ask for nada cap key
           capkey=_("intrinsic");
           Cap_Questn extrinsicDlg (this,_("Chiffre bekommt NADA-Cap, geben Sie das NADA-Cap Passwort!"),&capkey,&islegacy);
           res=extrinsicDlg.ShowModal();
           if(res==0)//aborted
           {
               throwout(_("Abbruch, Tue Nichts!"),3);
               return;
           }
           else
           {
                if(capkey!=_("intrinsic"))  intrinsic=false;
           }
    }
    /***************/
    if((!intrinsic)&&(hascap))
    {
       //write salt and counter to outfile
       salt.makerandom(saltlen);
       readflag=fs1.Write(salt.ad,saltlen);
    }
    if(hascap)
    {
        counter.makerandom(counterlen);
        readflag=fs1.Write(counter.ad,counterlen);
    }
    if(hascap&&(!intrinsic))
    {
        el1024.ellipse_set_stretch1024();
        //prepare cap data structure for extrinsic cap
          if(!cap_prep_from_String(&capkey, &salt, &counter, (ulong32)counterlen, &nckey,  &el1024, stretch,counterlen, islegacy))
          {
           throwout(_("Error in legacy cap preparation!\naborting!"),5);
           fs1.Close();
           return;
          }
    }
    if(hascap&&intrinsic)
    {
        //determine cap key and true counter from pubkey
       if(!cap_prep_from_pubky(&loky, &counter, (ulong32) counterlen, &nckey, counterlen))
       {
           throwout(_("could not determine cap key \nfrom public key\nAborting."),10);
           fs1.Close();
           return;
       }
    }
    if(hascap)
    {
      counter.inc();
      /***********************************************************************/
      endmsiz= endmark.Len();
      strcpy(buff, (const char*) endmark.mb_str(wxConvUTF8));
      strcpy(cbuf, (const char*) endmark.mb_str(wxConvUTF8));//easiest way to ensure \0 termination
      endmsiz=strlen(buff);
      otpbuff=(char*)malloc(counterlen);
      memcpy(otpbuff,counter.ad,counterlen);
      if(! k_develop_f4(counterlen, otpbuff, 0, NULL, counterlen, (char*) nckey.ad, 2, mode ))  //0,NULL means no cpablocker, algo 10 is fleas Ld 4 Path
      {
       throwout(_("Alert, keydevelop failed for cap!"),5);
       free(otpbuff);
       fs1.Close();
       return;
      }
      // writeout xored compbuffer first
      for(i=0;i<endmsiz;i++)
      {
       if(useblock==(unsigned int)counterlen) //refresh bufer
       {
           counter.inc();
           memcpy(otpbuff,counter.ad,counterlen);
           if(! k_develop_f4(counterlen, otpbuff, 0, NULL, counterlen, (char *)nckey.ad, 2, mode ))  //0,NULL means no cpablocker, algo 10 is fleas Ld 4 Path
            {
                throwout(_("Alert, keydevelop failed for cap!"),5);
                free(otpbuff);
                fs1.Close();
                return;
            }
            useblock=0;
         }
         c= (char) h1.GetChar(i);  //get ith byte from wxstring next line: *(cbuf+i)=c;
         *(cbuf+i)=c;   //update comparebuffer
         c ^= *(otpbuff+useblock);
         useblock++; usecnt++;
         readflag=fs1.Write(&c,1);
       }
           //read in byte , check mark match, xor and writeout
       while((strcmp(buff,cbuf)!=0)&&(usecnt<4000))
       {
          memmove(cbuf,cbuf+1,endmsiz-1); //moveone down
          c= (char) h1.GetChar(usecnt);  //get usecnt_th byte from wxstring
          if(usecnt >= h1.Length()) //EOString reached
            {
                throwout(_("Fehler, zu Cappende Datei ist ausgeschoepft!\n keine Endmarke gefunden!"),5);
                free(otpbuff);
                fs1.Close();
                return;
            }
          *(cbuf+endmsiz-1)=c;  //put into compare buffer
          if(useblock==(unsigned int)counterlen) //refresh buffer if necessary
          {
           counter.inc();
           memcpy(otpbuff,counter.ad,counterlen);
           if(! k_develop_f4(counterlen, otpbuff, 0, NULL, counterlen, (char *)nckey.ad, 2, mode ))  //0,NULL means no cpablocker, algo 10 is fleas Ld 4 Path
            {
                throwout(_("Alert, keydevelop failed for cap!"),5);
                free(otpbuff);
                fs1.Close();
                return;
            }
            useblock=0;
           }
           c ^= *(otpbuff+useblock); //xor with OTP
           useblock++; usecnt++;
           readflag=fs1.Write(&c,1);  //writeout cap byte
        }
        free(otpbuff);
       }
       if(!hascap) fs1.Write(h1);


    fs1.Close();
    /********* 1st level header written  with cipherfilename******************/
    //build second level header with temp name
    /***** create prepend buffer  ****/
    rbuff=(unsigned char*) malloc(30); //padding
    //puffer füllen ohne X: marker(88,58)
    for(i=0;i<30;i++)
    {
        *(rbuff+i)= zuf.get_rbyte();
    }
    for(i=0;i<29;i++) //remove X: markers
    {
        while(*(rbuff+i)=='X' && *(rbuff+i+1)==':') //Marker detected
        {
            *(rbuff+i)= zuf.get_rbyte();
            *(rbuff+i+1)= zuf.get_rbyte();
        }
    }
    /***generate 2nd levl header info and write into file s0_abcdef  ***/
    mys0=mypath+separator+_("s2nd_") + myrand; //prepend 2nd levl filename
    //change blanks to underscore
    myname.Replace(_(" "),_("_"));
    myname.Replace(_("X:"),_("X_"));  //remove the splicemarker if present
    ext.Replace(_("X:"),_("X_"));
    s=_(" fnam: ") + myname;
    if(!ext.IsEmpty()) s += _(".")+ ext; //nur wenn ext vorhanden, den punkt ran
// to do: add flexible number of non X: chars
    bufflen=256*(unsigned int)zuf.get_rbyte();
    bufflen += (unsigned int)zuf.get_rbyte();
        //check for length
    wxFile firfil(fnam);
    decoylen= firfil.Length();
    firfil.Close();
    bufflen= (unsigned long) (sqrt((decoylen * (double)bufflen) / (double)16009 ));
    bufflen += (unsigned int)zuf.get_rbyte();
// determined bufflen
    wxFFile fs0(mys0, _("wb"));
    fs0.Write(rbuff,30);
    fs0.Write(s);
    //append buffer
    for (j=0;j<bufflen;j++)
    {
        fs0.Write(_(" "));
    }
    //append end mark and close
    fs0.Write(_(" X:"));
    fs0.Close();
    /********* secnond level header file written  to  mys0 *********/

    //call encipher file(header_1_name, Header_2_name, plain_name, algo, key etc)
    key.setsize(true);
    if(algo ==_("Fleas_4")) {fr=5;kr=3;blsiz=512;} //new set
    else if(algo ==_("Fleas_5")) {fr=5;kr=3;blsiz=512;}
    else if(algo ==_("Fleas_x2")) {fr=5;kr=3;blsiz=512;}
    else if(algo ==_("Fleas_x5")) {fr=5;kr=3;blsiz=512;}
    else if(algo ==_("Fleas_o2")) {fr=4;kr=2;blsiz=512;}
    else if(algo ==_("Fleas_o5")) {fr=4;kr=2;blsiz=512;}
    else if(algo ==_("Fleas_l")) {fr=4;kr=2;blsiz=512;}
    else if(algo ==_("Fleas_ls")) {fr=4;kr=2;blsiz=480;}
    else if(algo ==_("Fleas_l3")) {fr=4;kr=3;blsiz=480;}
    else if(algo ==_("Fleas_lc")) {fr=4;kr=3;blsiz=480;}
    else if(algo ==_("Fleas_ld")) {fr=4;kr=3;blsiz=480;}
    else if(algo ==_("Fleas_lb")) {fr=4;kr=3;blsiz=480;}
    else if(algo ==_("aes")) {fr=0;kr=1;blsiz=16;}
    else if(algo ==_("threefish")) {fr=0;kr=0;blsiz=128;}
    else if(algo ==_("F_cnt_1c")) {fr=4;kr=3;blsiz=480;}
    else if(algo ==_("F_cnt_1d")) {fr=4;kr=3;blsiz=480;}
    else if(algo ==_("F_cnt_1b")) {fr=4;kr=3;blsiz=480;}
    else if(algo ==_("flight")) {fr=2;kr=1;blsiz=480;}
    else if(algo ==_("flightx")) {fr=2;kr=1;blsiz=480;}
    else if(algo ==_("chimera")) {fr=2;kr=1;blsiz=512;}
    else
    {
        throwout(_("algortihm not known, using\nF_cnt_1c as default"),3);
        algo ==_("F_cnt_1c");
        fr=4;kr=3;blsiz=480;
    }
    resenc=encipher_pair(cnam, mys0, fnam, (char *)key.ad, key.size,fr, kr, blsiz, 1, algo, 1 );
    wxRemoveFile(mys0); //remove secondlevel header
    if(resenc)    throwout(_("enciphered"),2);
    else throwout(_("encipherin failed"),2);
    return;
}
/*********************************************************************************/
void elliptic_encipher::OnNADAInfo(wxCommandEvent& event)
{
    wxString msg;

    msg=_(" \nNADA steht fuer No Access Data Available\n");
    msg+=_("Eine NADA Cap verbirgt jegliche Formatierung\n");
    msg+=_("und bewirkt bei der Chiffredatei vollstaendige\n");

    msg+=_(" Ununterscheidbarkeit gegenueber Rauschen.\n");

    msg+=_("Der Gegner kann kein Bit Informationen herausziehen.\n");
    msg+=_("Er weiss nicht einmal \nob das eine Chiffredatei ist. NADA!!\n");
    msg+=_("Wenn Du \"intrinsic\" als NADA key laesst, wird\n der NADA-cap key aus dem oefftl. Schluessel berechnet.\n");
    msg+=_("Bei \"intrinsic\" muss der Empfaenger raten, \nwelches der Zielschluessel war.\n");
    msg+=_("Bei anderen NADA keys must Du den NADA key \nauf eigenem, alternativem Weg zum Empfaenger bringen.\n");

    throwout(msg,100);
    return;
}
/*********************************************************************************/
