/*
 *   Copyright (C) 2016, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */


#include "Cap_Questn.h"

//(*InternalHeaders(Cap_Questn)
#include <wx/string.h>
#include <wx/intl.h>
#include <wx/font.h>
//*)

#include "helpersxx.h"

//(*IdInit(Cap_Questn)
const long Cap_Questn::ID_BUTTON1 = wxNewId();
const long Cap_Questn::ID_STATICTEXT1 = wxNewId();
const long Cap_Questn::ID_BUTTON2 = wxNewId();
const long Cap_Questn::ID_TEXTCTRL1 = wxNewId();
const long Cap_Questn::ID_CHECKBOX1 = wxNewId();
const long Cap_Questn::ID_TIMER1 = wxNewId();
//*)

BEGIN_EVENT_TABLE(Cap_Questn,wxDialog)
	//(*EventTable(Cap_Questn)
	//*)
END_EVENT_TABLE()

Cap_Questn::Cap_Questn(wxWindow* parent,wxString messg, wxString *panswer, bool *pis_legacy, wxWindowID id,const wxPoint& pos,const wxSize& size)
{
	//(*Initialize(Cap_Questn)
	wxFlexGridSizer* FlexGridSizer1;

	Create(parent, id, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("id"));
	SetClientSize(wxDefaultSize);
	Move(wxDefaultPosition);
	FlexGridSizer1 = new wxFlexGridSizer(0, 3, 0, 0);
	Abort_Button = new wxButton(this, ID_BUTTON1, _("Abbruch"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON1"));
	Abort_Button->SetBackgroundColour(wxColour(247,112,112));
	wxFont Abort_ButtonFont(9,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Abort_Button->SetFont(Abort_ButtonFont);
	FlexGridSizer1->Add(Abort_Button, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText1 = new wxStaticText(this, ID_STATICTEXT1, _("Ersetze \"intrinsic\" durch Passwd fuer extrinsisches Capping"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT1"));
	wxFont StaticText1Font(9,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText1->SetFont(StaticText1Font);
	FlexGridSizer1->Add(StaticText1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Encrypt_Button = new wxButton(this, ID_BUTTON2, _("Do Capped crypt"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON2"));
	Encrypt_Button->SetBackgroundColour(wxColour(137,228,252));
	wxFont Encrypt_ButtonFont(9,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Encrypt_Button->SetFont(Encrypt_ButtonFont);
	FlexGridSizer1->Add(Encrypt_Button, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	FlexGridSizer1->Add(-1,-1,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	pwCtrl = new wxTextCtrl(this, ID_TEXTCTRL1, _("intrinsic"), wxDefaultPosition, wxSize(314,20), wxTE_PROCESS_ENTER, wxDefaultValidator, _T("ID_TEXTCTRL1"));
	pwCtrl->SetBackgroundColour(wxColour(247,169,143));
	wxFont pwCtrlFont(9,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	pwCtrl->SetFont(pwCtrlFont);
	FlexGridSizer1->Add(pwCtrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	FlexGridSizer1->Add(-1,-1,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	FlexGridSizer1->Add(-1,-1,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	FlexGridSizer1->Add(-1,-1,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	CheckLegacy = new wxCheckBox(this, ID_CHECKBOX1, _("use legacy KDF"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_CHECKBOX1"));
	CheckLegacy->SetValue(false);
	wxFont CheckLegacyFont(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	CheckLegacy->SetFont(CheckLegacyFont);
	FlexGridSizer1->Add(CheckLegacy, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	SetSizer(FlexGridSizer1);
	Timer1.SetOwner(this, ID_TIMER1);
	FlexGridSizer1->Fit(this);
	FlexGridSizer1->SetSizeHints(this);

	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&Cap_Questn::OnAbort);
	Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&Cap_Questn::OnCappedEncrypt);
	Connect(ID_TEXTCTRL1,wxEVT_COMMAND_TEXT_ENTER,(wxObjectEventFunction)&Cap_Questn::OnCappedEncrypt);
	Connect(ID_TIMER1,wxEVT_TIMER,(wxObjectEventFunction)&Cap_Questn::OnTimer1Trigger);
	//*)

	half_min_counter=0;
	StaticText1->SetLabelText(_("Ersetze \"intrinsic\" durch Passwd fuer extrinsisches Capping"));
	pansw=&(*panswer);
	pisleg=&(*pis_legacy);
	pwCtrl->SetValue(*panswer);

}
/**********************************************************/
Cap_Questn::~Cap_Questn()
{
	//(*Destroy(Cap_Questn)
	//*)
}
/**********************************************************/

void Cap_Questn::OnAbort(wxCommandEvent& event)
{
	pansw->Empty();
    EndModal(0);
    return;

}
/**********************************************************/

void Cap_Questn::OnCappedEncrypt(wxCommandEvent& event)
{
    wxString lt;

    lt= pwCtrl->GetLineText(0);
    *pansw=lt;
    *pisleg=CheckLegacy->IsChecked();

    EndModal(1);
    return;

}
/**********************************************************/

void Cap_Questn::OnTimer1Trigger(wxTimerEvent& event)
{
	if(half_min_counter>2) //more than 120 seconds
    {
        pansw->Empty();
        EndModal(0);
        throwout(_("timeout\nAbbruch des Dialogs!"),2);
        return;
    }
    else
    {
        Timer1.Start(30000, true);
        half_min_counter++;
        return;
    }

}
/**********************************************************/
