/*
 *   Copyright (C) 2011-2016, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
 

#ifndef GPG_NEW_KEYDIALOG_H
#define GPG_NEW_KEYDIALOG_H

//(*Headers(gpg_new_keyDialog)
#include <wx/dialog.h>
#include <wx/sizer.h>
#include <wx/button.h>
#include <wx/slider.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>
#include <wx/choice.h>
//*)

class gpg_new_keyDialog: public wxDialog
{
	public:

		gpg_new_keyDialog(wxWindow* parent,wxWindowID id=wxID_ANY,const wxPoint& pos=wxDefaultPosition,const wxSize& size=wxDefaultSize);
		virtual ~gpg_new_keyDialog();

		//(*Declarations(gpg_new_keyDialog)
		wxButton* Button1;
		wxButton* Button2;
		wxStaticText* StaticText1;
		wxTextCtrl* imehl_ctrl;
		wxStaticText* StaticText3;
		wxChoice* len_ctrl;
		wxStaticText* StaticText8;
		wxTextCtrl* comm_ctrl;
		wxStaticText* StaticText7;
		wxTextCtrl* name_ctrl;
		wxStaticText* StaticText4;
		wxChoice* algo_ctrl;
		wxStaticText* StaticText5;
		wxStaticText* StaticText2;
		wxTextCtrl* pp2_ctrl;
		wxStaticText* StaticText6;
		wxSlider* Slider1;
		wxTextCtrl* pp1_ctrl;
		wxStaticText* StaticText9;
		//*)

	protected:

		//(*Identifiers(gpg_new_keyDialog)
		static const long ID_BUTTON2;
		static const long ID_STATICTEXT1;
		static const long ID_STATICTEXT2;
		static const long ID_TEXTCTRL1;
		static const long ID_STATICTEXT3;
		static const long ID_TEXTCTRL2;
		static const long ID_STATICTEXT4;
		static const long ID_TEXTCTRL3;
		static const long ID_STATICTEXT5;
		static const long ID_CHOICE1;
		static const long ID_STATICTEXT6;
		static const long ID_CHOICE2;
		static const long ID_STATICTEXT9;
		static const long ID_SLIDER1;
		static const long ID_STATICTEXT7;
		static const long ID_TEXTCTRL4;
		static const long ID_STATICTEXT8;
		static const long ID_TEXTCTRL5;
		static const long ID_BUTTON1;
		//*)

	private:

		//(*Handlers(gpg_new_keyDialog)
		void OnClose(wxCommandEvent& event);
		void OnMakeKey(wxCommandEvent& event);
		//*)

		DECLARE_EVENT_TABLE()
};

#endif
