/*
 *   Copyright (C) 2011-2016, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of ; If you didn't receive a copy of
 *  the GNU General Public License along with this program, you may get one from
 *  the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */


#include "gpg_add_pub.h"
#include "gnupg_globals.h"
#include "gpg_wrap.h"
#include "globals.h"



//(*InternalHeaders(gpg_add_pub)
#include <wx/settings.h>
#include <wx/string.h>
#include <wx/intl.h>
#include <wx/font.h>
//*)

//(*IdInit(gpg_add_pub)
const long gpg_add_pub::ID_BUTTON1 = wxNewId();
const long gpg_add_pub::ID_STATICTEXT1 = wxNewId();
const long gpg_add_pub::ID_BUTTON5 = wxNewId();
const long gpg_add_pub::ID_LISTBOX1 = wxNewId();
const long gpg_add_pub::ID_BUTTON4 = wxNewId();
const long gpg_add_pub::ID_BUTTON2 = wxNewId();
const long gpg_add_pub::ID_BUTTON3 = wxNewId();
const long gpg_add_pub::ID_TEXTCTRL2 = wxNewId();
const long gpg_add_pub::ID_BUTTON6 = wxNewId();
const long gpg_add_pub::ID_STATICTEXT3 = wxNewId();
const long gpg_add_pub::ID_TIMER1 = wxNewId();
//*)

BEGIN_EVENT_TABLE(gpg_add_pub,wxDialog)
	//(*EventTable(gpg_add_pub)
	//*)
END_EVENT_TABLE()

gpg_add_pub::gpg_add_pub(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{

    int i;
	//(*Initialize(gpg_add_pub)
	wxFlexGridSizer* FlexGridSizer1;

	Create(parent, wxID_ANY, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("wxID_ANY"));
	FlexGridSizer1 = new wxFlexGridSizer(0, 2, 0, 0);
	Button1 = new wxButton(this, ID_BUTTON1, _("Schluessel nutzen\nund schliessen"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON1"));
	Button1->SetForegroundColour(wxSystemSettings::GetColour(wxSYS_COLOUR_BTNTEXT));
	Button1->SetBackgroundColour(wxColour(240,162,133));
	wxFont Button1Font(10,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button1->SetFont(Button1Font);
	FlexGridSizer1->Add(Button1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText1 = new wxStaticText(this, ID_STATICTEXT1, _("Schluessel waehlen oder oefftl GnuPG Schluessel importieren"), wxDefaultPosition, wxSize(497,19), 0, _T("ID_STATICTEXT1"));
	wxFont StaticText1Font(12,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText1->SetFont(StaticText1Font);
	FlexGridSizer1->Add(StaticText1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button5 = new wxButton(this, ID_BUTTON5, _("oefftl. Schluessel\nexportieren"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON5"));
	wxFont Button5Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button5->SetFont(Button5Font);
	FlexGridSizer1->Add(Button5, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	kylist_ctrl = new wxListBox(this, ID_LISTBOX1, wxDefaultPosition, wxSize(635,218), 0, 0, 0, wxDefaultValidator, _T("ID_LISTBOX1"));
	wxFont kylist_ctrlFont(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	kylist_ctrl->SetFont(kylist_ctrlFont);
	FlexGridSizer1->Add(kylist_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button4 = new wxButton(this, ID_BUTTON4, _("Schluessel\nloeschen"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON4"));
	wxFont Button4Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button4->SetFont(Button4Font);
	FlexGridSizer1->Add(Button4, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	Button2 = new wxButton(this, ID_BUTTON2, _("Schluessel aus\nDatei laden"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON2"));
	wxFont Button2Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button2->SetFont(Button2Font);
	FlexGridSizer1->Add(Button2, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button3 = new wxButton(this, ID_BUTTON3, _("Aus Textfeld\nladen"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON3"));
	wxFont Button3Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button3->SetFont(Button3Font);
	FlexGridSizer1->Add(Button3, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	armor_ctrl = new wxTextCtrl(this, ID_TEXTCTRL2, wxEmptyString, wxDefaultPosition, wxSize(634,127), wxTE_MULTILINE, wxDefaultValidator, _T("ID_TEXTCTRL2"));
	wxFont armor_ctrlFont(6,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	armor_ctrl->SetFont(armor_ctrlFont);
	FlexGridSizer1->Add(armor_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button6 = new wxButton(this, ID_BUTTON6, _("Sign selected key"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON6"));
	FlexGridSizer1->Add(Button6, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	StaticText3 = new wxStaticText(this, ID_STATICTEXT3, _("Insert armored asc above"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT3"));
	wxFont StaticText3Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText3->SetFont(StaticText3Font);
	FlexGridSizer1->Add(StaticText3, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	SetSizer(FlexGridSizer1);
	Timer1.SetOwner(this, ID_TIMER1);
	FlexGridSizer1->Fit(this);
	FlexGridSizer1->SetSizeHints(this);

	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&gpg_add_pub::OnExit);
	Connect(ID_BUTTON5,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&gpg_add_pub::OnExport);
	Connect(ID_LISTBOX1,wxEVT_COMMAND_LISTBOX_DOUBLECLICKED,(wxObjectEventFunction)&gpg_add_pub::OnExit);
	Connect(ID_BUTTON4,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&gpg_add_pub::OnDelete_sel);
	Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&gpg_add_pub::OnLoadFromFile);
	Connect(ID_BUTTON3,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&gpg_add_pub::OnLoad_text);
	Connect(ID_BUTTON6,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&gpg_add_pub::OnSign);
	Connect(ID_TIMER1,wxEVT_TIMER,(wxObjectEventFunction)&gpg_add_pub::OnTimer1Trigger);
	//*)

	tellerror=false;
    if(get_pub_labels()>0)	kylist_ctrl->InsertItems(pb_kylabel, 0);
    else{
            throwout(_("No public key present!\nPlease create a first one using GnuPG directly.\nAborting!"),3);
            tellerror=true;
            return;
        }

}
/**********************************************************************/
gpg_add_pub::~gpg_add_pub()
{
	//(*Destroy(gpg_add_pub)
	//*)
}
/**********************************************************************/
void gpg_add_pub::OnExit(wxCommandEvent& event)
{
    int selected;
    // read out the selected key
    selected=kylist_ctrl->GetSelection();
    if(selected!=wxNOT_FOUND)
       {
           pubkey=pb_kyid[selected];
           pubk_sel=selected;
       }
    EndModal(1);
    return;
}
/**********************************************************************/
void gpg_add_pub::OnLoadFromFile(wxCommandEvent& event)
{
    wxString pubkyfnam;

    pubkyfnam= wxFileSelector(_("Select a public key file"),kytray,_(""),_("asc|"),_("asc file (*.asc)|*.asc|all files(*.*)|*.*"));
    if(pubkyfnam.IsEmpty()) return;
    if(!wxFileExists(pubkyfnam)){throwout(_("Public-key-file does not exist"),2); return;}
    if(!gpg_import_pubkey(pubkyfnam)) {throwout(_("Import failed!"),2); return;}
    kylist_ctrl->Set(pb_kylabel);
    if(pb_kylabel.GetCount()>0)
            kylist_ctrl->SetSelection(pb_kylabel.GetCount()-1);
    return;
}
/**********************************************************************/
void gpg_add_pub::OnLoad_text(wxCommandEvent& event)
{
    FILE *fp;
    int i,lineno;
    wxString filine;
    //char str[1002];

    lineno=armor_ctrl->GetNumberOfLines();
    if (lineno>2000)
    {
        throwout(_("are you nuts!\nmore than 2000 lines!!!\naborting"),5);
        return;
    }
    fp=fopen("tmp_imp.asc","w");
    for(i=0;i<lineno;i++)
    {
        filine=armor_ctrl->GetLineText(i) + _("\n");
        /*if(filine.Length()>1000)
        {
            throwout(_("are you nuts!\nlines of length > 1000 are inappropriate\naborting"),10);
            fclose(fp);
            wxRemoveFile(_("tmp_imp.asc"));
            return;
        }*/

        fprintf(fp,"%s", (const char *)(filine.mb_str(wxConvUTF8)));
    }
    fclose(fp);
    if(!gpg_import_pubkey(_("tmp_imp.asc"))) {
         throwout(_("Import failed!"),2);
         wxRemoveFile(_("tmp_imp.asc"));
         return;}
    wxRemoveFile(_("tmp_imp.asc"));
    kylist_ctrl->Set(pb_kylabel);
    if(pb_kylabel.GetCount()>0)
    kylist_ctrl->SetSelection(pb_kylabel.GetCount()-1);
    return;
}
/**********************************************************************/
void gpg_add_pub::OnDelete_sel(wxCommandEvent& event)
{
    int selected;
    // read out the selected key
    selected=kylist_ctrl->GetSelection();
    if(selected!=wxNOT_FOUND)
       {
           pubkey=pb_kyid[selected];
           pubk_sel=selected;
           if(gpg_remove_pubkey(pubkey))
           {
               //throwout(_("Public key removed"),1);
               //blank and reset lylist_ctrl,focus to first
               if(    get_pub_labels()>0)
               {
                    kylist_ctrl->Set(pb_kylabel);
               }
               else throwout(_("error in Delete Key,\n should not occur?!?"));
           }
       }
    else throwout(_("No key selected!"),1);
    return;
}
/**********************************************************************/
void gpg_add_pub::OnExport(wxCommandEvent& event)
{
   wxString filnam;
   int selected;
    // read out the selected key
    selected=kylist_ctrl->GetSelection();
    if(selected!=wxNOT_FOUND)
       {
           pubkey=pb_kyid[selected];
           pubk_sel=selected;
           filnam=pb_kylabel[selected] + _(".asc");
           filnam.Replace(_(" "), _("_"),true);
           filnam=wxFileSelector(_("select output filename"), kytray, filnam,_("asc"),_("asc files (*.asc)|*.asc|All files (*.*)|*.*)"),wxFD_SAVE);
           if(gpg_export_pubkey(filnam,pubkey))
           {
               if(!wxFileExists(filnam))
               throwout(_("Public key not exported"),1);
           }
           else throwout(_("Warning:no export!"),2);
       }
    else throwout(_("No key selected!"),1);
    return;
}
/***********************************************************************/
void gpg_add_pub::OnSign(wxCommandEvent& event)
{
   int selected;
    // read out the selected key
    selected=kylist_ctrl->GetSelection();
    if(selected!=wxNOT_FOUND)
       {
           pubkey=pb_kyid[selected];
           pubk_sel=selected;
           if(gpg_sign_pubkey(pubkey))
           {
               throwout(_("Public key signed"),1);
           }
           else throwout(_("Probably Done..."),2);
       }
    else throwout(_("No key selected!"),1);
    return;
}
/************************************************************************/
void gpg_add_pub::OnTimer1Trigger(wxTimerEvent& event)
{
        if(tellerror) EndModal(0);
    else{
        Timer1.Start(1000,wxTIMER_ONE_SHOT);
    }
}
/************************************************************************/
