/*
 *   Copyright (C) 2011-2016, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */



#include "advancd_symm.h"
#include "globals.h"
#include "AskDialog.h"

#include <wx/filedlg.h>
#include <wx/filename.h>
#include <wx/ffile.h>

#include <wx/arrstr.h>
#include <wx/dir.h>
#include <wx/busyinfo.h>


//(*InternalHeaders(advancd_symm)
#include <wx/string.h>
#include <wx/intl.h>
#include <wx/font.h>
//*)

//(*IdInit(advancd_symm)
const long advancd_symm::ID_BUTTON1 = wxNewId();
const long advancd_symm::ID_STATICTEXT1 = wxNewId();
const long advancd_symm::ID_STATICTEXT2 = wxNewId();
const long advancd_symm::ID_TEXTCTRL1 = wxNewId();
const long advancd_symm::ID_BUTTON3 = wxNewId();
const long advancd_symm::ID_STATICTEXT7 = wxNewId();
const long advancd_symm::ID_TEXTCTRL4 = wxNewId();
const long advancd_symm::ID_LEGACY_BOX = wxNewId();
const long advancd_symm::ID_STATICTEXT8 = wxNewId();
const long advancd_symm::ID_TEXTCTRL5 = wxNewId();
const long advancd_symm::ID_BUTTON7 = wxNewId();
const long advancd_symm::ID_STATICTEXT3 = wxNewId();
const long advancd_symm::ID_TEXTCTRL2 = wxNewId();
const long advancd_symm::ID_BUTTON4 = wxNewId();
const long advancd_symm::ID_STATICTEXT4 = wxNewId();
const long advancd_symm::ID_SPINCTRL1 = wxNewId();
const long advancd_symm::ID_STATICTEXT5 = wxNewId();
const long advancd_symm::ID_CHOICE1 = wxNewId();
const long advancd_symm::ID_STATICTEXT6 = wxNewId();
const long advancd_symm::ID_PLSC = wxNewId();
const long advancd_symm::ID_BUTTON2 = wxNewId();
const long advancd_symm::ID_TEXTCTRL3 = wxNewId();
const long advancd_symm::ID_BUTTON5 = wxNewId();
const long advancd_symm::ID_STATICTEXT9 = wxNewId();
const long advancd_symm::ID_BUTTON6 = wxNewId();
//*)

BEGIN_EVENT_TABLE(advancd_symm,wxDialog)
	//(*EventTable(advancd_symm)
	//*)
END_EVENT_TABLE()



advancd_symm::advancd_symm(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
	//(*Initialize(advancd_symm)
	wxFlexGridSizer* FlexGridSizer1;

	Create(parent, wxID_ANY, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("wxID_ANY"));
	FlexGridSizer1 = new wxFlexGridSizer(0, 3, 0, 0);
	Button1 = new wxButton(this, ID_BUTTON1, _("Schliessen"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON1"));
	Button1->SetBackgroundColour(wxColour(251,202,202));
	wxFont Button1Font(11,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button1->SetFont(Button1Font);
	FlexGridSizer1->Add(Button1, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	StaticText1 = new wxStaticText(this, ID_STATICTEXT1, _("Symmetrische Dateiver- und entschluesselung"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT1"));
	wxFont StaticText1Font(13,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText1->SetFont(StaticText1Font);
	FlexGridSizer1->Add(StaticText1, 1, wxALL|wxALIGN_BOTTOM|wxALIGN_CENTER_HORIZONTAL, 5);
	FlexGridSizer1->Add(20,30,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText2 = new wxStaticText(this, ID_STATICTEXT2, _("Datei fuer\nOperation waehlen:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT2"));
	wxFont StaticText2Font(7,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText2->SetFont(StaticText2Font);
	FlexGridSizer1->Add(StaticText2, 1, wxALL|wxALIGN_RIGHT|wxALIGN_BOTTOM, 5);
	fnam_ctrl = new wxTextCtrl(this, ID_TEXTCTRL1, wxEmptyString, wxDefaultPosition, wxSize(524,22), 0, wxDefaultValidator, _T("ID_TEXTCTRL1"));
	wxFont fnam_ctrlFont(7,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	fnam_ctrl->SetFont(fnam_ctrlFont);
	FlexGridSizer1->Add(fnam_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	Button3 = new wxButton(this, ID_BUTTON3, _("Datei waehlen"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON3"));
	wxFont Button3Font(11,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button3->SetFont(Button3Font);
	FlexGridSizer1->Add(Button3, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	StaticText7 = new wxStaticText(this, ID_STATICTEXT7, _("Primaer-\npasswort:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT7"));
	wxFont StaticText7Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText7->SetFont(StaticText7Font);
	FlexGridSizer1->Add(StaticText7, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	key_ctrl = new wxTextCtrl(this, ID_TEXTCTRL4, wxEmptyString, wxDefaultPosition, wxSize(523,21), wxTE_PROCESS_ENTER, wxDefaultValidator, _T("ID_TEXTCTRL4"));
	key_ctrl->SetBackgroundColour(wxColour(247,190,190));
	wxFont key_ctrlFont(7,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	key_ctrl->SetFont(key_ctrlFont);
	FlexGridSizer1->Add(key_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	Legacy = new wxCheckBox(this, ID_LEGACY_BOX, _("alte Passwort\nInterpretation"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_LEGACY_BOX"));
	Legacy->SetValue(false);
	FlexGridSizer1->Add(Legacy, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText8 = new wxStaticText(this, ID_STATICTEXT8, _("abgeleiteter Schluessel"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT8"));
	wxFont StaticText8Font(7,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText8->SetFont(StaticText8Font);
	FlexGridSizer1->Add(StaticText8, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	dirkey_ctrl = new wxTextCtrl(this, ID_TEXTCTRL5, wxEmptyString, wxDefaultPosition, wxSize(526,132), wxTE_MULTILINE|wxTE_READONLY|wxVSCROLL, wxDefaultValidator, _T("ID_TEXTCTRL5"));
	dirkey_ctrl->SetForegroundColour(wxColour(8,3,202));
	dirkey_ctrl->SetBackgroundColour(wxColour(233,224,224));
	wxFont dirkey_ctrlFont(7,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Liberation Sans"),wxFONTENCODING_DEFAULT);
	dirkey_ctrl->SetFont(dirkey_ctrlFont);
	FlexGridSizer1->Add(dirkey_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	Button7 = new wxButton(this, ID_BUTTON7, _("Vorschau des\nabgeleiteten Schluessels"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON7"));
	wxFont Button7Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button7->SetFont(Button7Font);
	FlexGridSizer1->Add(Button7, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText3 = new wxStaticText(this, ID_STATICTEXT3, _("Salt:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT3"));
	wxFont StaticText3Font(7,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText3->SetFont(StaticText3Font);
	FlexGridSizer1->Add(StaticText3, 1, wxALL|wxALIGN_RIGHT|wxALIGN_TOP, 5);
	salt_ctrl = new wxTextCtrl(this, ID_TEXTCTRL2, wxEmptyString, wxDefaultPosition, wxSize(523,22), 0, wxDefaultValidator, _T("ID_TEXTCTRL2"));
	salt_ctrl->SetForegroundColour(wxColour(144,144,144));
	wxFont salt_ctrlFont(7,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	salt_ctrl->SetFont(salt_ctrlFont);
	FlexGridSizer1->Add(salt_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_TOP, 5);
	Button4 = new wxButton(this, ID_BUTTON4, _("Salt aendern"), wxDefaultPosition, wxSize(106,23), 0, wxDefaultValidator, _T("ID_BUTTON4"));
	wxFont Button4Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button4->SetFont(Button4Font);
	FlexGridSizer1->Add(Button4, 1, wxALL|wxALIGN_LEFT|wxALIGN_TOP, 5);
	StaticText4 = new wxStaticText(this, ID_STATICTEXT4, _("elliptic stretch\nfactor:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT4"));
	wxFont StaticText4Font(7,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText4->SetFont(StaticText4Font);
	FlexGridSizer1->Add(StaticText4, 1, wxALL|wxALIGN_RIGHT|wxALIGN_BOTTOM, 5);
	stretch_ctrl = new wxSpinCtrl(this, ID_SPINCTRL1, _T("40"), wxDefaultPosition, wxSize(67,27), 0, 0, 800, 40, _T("ID_SPINCTRL1"));
	stretch_ctrl->SetValue(_T("40"));
	wxFont stretch_ctrlFont(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	stretch_ctrl->SetFont(stretch_ctrlFont);
	FlexGridSizer1->Add(stretch_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	FlexGridSizer1->Add(20,21,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText5 = new wxStaticText(this, ID_STATICTEXT5, _("Cipher\nAlgortihmus"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT5"));
	wxFont StaticText5Font(7,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText5->SetFont(StaticText5Font);
	FlexGridSizer1->Add(StaticText5, 1, wxALL|wxALIGN_RIGHT|wxALIGN_BOTTOM, 5);
	algo_ctrl = new wxChoice(this, ID_CHOICE1, wxDefaultPosition, wxSize(158,29), 0, 0, 0, wxDefaultValidator, _T("ID_CHOICE1"));
	algo_ctrl->Append(_("AES"));
	algo_ctrl->Append(_("Fleas_1_8"));
	algo_ctrl->Append(_("Fleas_3"));
	algo_ctrl->Append(_("Fleas_o2"));
	algo_ctrl->Append(_("Fleas_o5"));
	algo_ctrl->Append(_("Fleas_l"));
	algo_ctrl->Append(_("Fleas_ls"));
	algo_ctrl->Append(_("Fleas_l3"));
	algo_ctrl->Append(_("Fleas_lb"));
	algo_ctrl->Append(_("Fleas_lc"));
	algo_ctrl->Append(_("Fleas_ld"));
	algo_ctrl->Append(_("Threefish"));
	algo_ctrl->SetSelection( algo_ctrl->Append(_("F_cnt_1c")) );
	algo_ctrl->Append(_("F_cnt_1d"));
	algo_ctrl->Append(_("F_cnt_1b"));
	algo_ctrl->Append(_("flight"));
	algo_ctrl->Append(_("flight_x"));
	algo_ctrl->Append(_("chimera"));
	wxFont algo_ctrlFont(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	algo_ctrl->SetFont(algo_ctrlFont);
	FlexGridSizer1->Add(algo_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	StaticText6 = new wxStaticText(this, ID_STATICTEXT6, _("stretch elliptic\ndomain name"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT6"));
	wxFont StaticText6Font(7,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText6->SetFont(StaticText6Font);
	FlexGridSizer1->Add(StaticText6, 1, wxALL|wxALIGN_BOTTOM|wxALIGN_CENTER_HORIZONTAL, 5);
	plsc_chkd = new wxCheckBox(this, ID_PLSC, _("Payload size \ncamouflage"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_PLSC"));
	plsc_chkd->SetValue(true);
	FlexGridSizer1->Add(plsc_chkd, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button2 = new wxButton(this, ID_BUTTON2, _("Ausfuehren"), wxDefaultPosition, wxSize(97,32), 0, wxDefaultValidator, _T("ID_BUTTON2"));
	Button2->SetBackgroundColour(wxColour(207,206,247));
	wxFont Button2Font(10,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button2->SetFont(Button2Font);
	FlexGridSizer1->Add(Button2, 1, wxALL|wxALIGN_BOTTOM|wxALIGN_CENTER_HORIZONTAL, 5);
	stretch_ell_nam_ctrl = new wxTextCtrl(this, ID_TEXTCTRL3, wxEmptyString, wxDefaultPosition, wxSize(108,21), wxTE_READONLY, wxDefaultValidator, _T("ID_TEXTCTRL3"));
	stretch_ell_nam_ctrl->SetForegroundColour(wxColour(144,144,144));
	wxFont stretch_ell_nam_ctrlFont(6,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	stretch_ell_nam_ctrl->SetFont(stretch_ell_nam_ctrlFont);
	FlexGridSizer1->Add(stretch_ell_nam_ctrl, 1, wxALL|wxALIGN_TOP|wxALIGN_CENTER_HORIZONTAL, 5);
	Button5 = new wxButton(this, ID_BUTTON5, _("Erzwinge\nChiffrieren"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON5"));
	Button5->SetDefault();
	Button5->SetBackgroundColour(wxColour(245,210,129));
	wxFont Button5Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button5->SetFont(Button5Font);
	FlexGridSizer1->Add(Button5, 1, wxALL|wxALIGN_BOTTOM|wxALIGN_CENTER_HORIZONTAL, 5);
	StaticText9 = new wxStaticText(this, ID_STATICTEXT9, _("<- untere Buttons erzwingen Aktion unabhaengig vom Dateinamen  ->"), wxDefaultPosition, wxSize(447,31), 0, _T("ID_STATICTEXT9"));
	wxFont StaticText9Font(9,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText9->SetFont(StaticText9Font);
	FlexGridSizer1->Add(StaticText9, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button6 = new wxButton(this, ID_BUTTON6, _("Erzwinge\nDechiffrieren"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON6"));
	Button6->SetBackgroundColour(wxColour(226,253,247));
	wxFont Button6Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button6->SetFont(Button6Font);
	FlexGridSizer1->Add(Button6, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	SetSizer(FlexGridSizer1);
	FlexGridSizer1->Fit(this);
	FlexGridSizer1->SetSizeHints(this);

	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&advancd_symm::OnExit);
	Connect(ID_BUTTON3,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&advancd_symm::OnFileSel);
	Connect(ID_TEXTCTRL4,wxEVT_COMMAND_TEXT_ENTER,(wxObjectEventFunction)&advancd_symm::OnDo);
	Connect(ID_BUTTON7,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&advancd_symm::Onprecalc);
	Connect(ID_BUTTON4,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&advancd_symm::OnNewSalt);
	Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&advancd_symm::OnDo);
	Connect(ID_BUTTON5,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&advancd_symm::OnEncipher);
	Connect(ID_BUTTON6,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&advancd_symm::OnDecipher);
	//*)

    fnam_ctrl->DragAcceptFiles(true);
    fnam_ctrl->Connect(wxEVT_DROP_FILES, wxDropFilesEventHandler(advancd_symm::OnDropFile), NULL, this);

	//set stretch ellipse name
	stretch_ell_nam_ctrl->SetValue(stretch_ell.name);
	//set salt
		//insert salt
    locsalt.makerandom(32);
    //zuf.p_makerandom(&salt,32);
    locsalt.writehex(&loc_salt_str);
    salt_ctrl->SetValue(loc_salt_str);
    ss_klen=512; //set keylength to 512bit
  //set preferred cipher
	if((def_cip>-1)&&(def_cip<9))
    {
        switch(def_cip)
        {
          case 0:
            algo_ctrl->SetSelection(0); break; //aes
          case 1:
            algo_ctrl->SetSelection(11); break;  //Threefish
          case 2:
            algo_ctrl->SetSelection(16); break;  //flight_x
          case 3:
            algo_ctrl->SetSelection(14); break;  //F_cnt_lb
          case 4:
            algo_ctrl->SetSelection(12); break;  //F_cnt_lc
          case 5:
            algo_ctrl->SetSelection(13); break;  //F_cnt_ld
          case 6:
            algo_ctrl->SetSelection(5); break;  //Fleas_l
          case 7:
            algo_ctrl->SetSelection(9); break;  //Fleas_lc
          case 8:
            algo_ctrl->SetSelection(17); break;  //chimera

           //no default necessary
        }
    }
}
/******************************************************************/
advancd_symm::~advancd_symm()
{
	//(*Destroy(advancd_symm)
	//*)
}
/****************************************************************/
void advancd_symm::OnExit(wxCommandEvent& event)
{
    Close();
}
/****************************************************************/
/****************************************************************/
void advancd_symm::OnDo(wxCommandEvent& event)
{
    wxString fnam;

    //check if extension is .ciph?
    //then either Encipher or Decipher
    fnam=fnam_ctrl->GetLineText(0);
    //check for existence
    if(!wxFile::Exists(fnam))
    {
        throwout(_("file to encipher does not exist!\nDo Nothing."),3);
        return;
    }
    if(fnam.Right(4)==_("ciph")) OnDecipher(event);
    else OnEncipher(event);
    return;
}
/*******************************************************/
void advancd_symm::OnDropFile(wxDropFilesEvent& event)
    {
        int  filno;
        drop_succ=false;

        if (event.GetNumberOfFiles() > 0) {

            wxString* dropped = event.GetFiles();
            wxASSERT(dropped);

            wxBusyCursor busyCursor;
            wxWindowDisabler disabler;
            wxBusyInfo busyInfo(_("Fuege Datei hinzu, bitte warten..."));

            wxString name;
            filno = event.GetNumberOfFiles();
            if(filno!=1)
            {
				throwout(_("Nur ein Dateiname bitte.\nAblage verweigert!"),3);
				return;
			}
			if( wxDirExists( 	dropped[0]	))
            {
                throwout(_("Das ist ein Verzeichnisname!!\nNur Dateiname moeglich.\nDrop ignoriert!"),3);
                return;
            }
			name = dropped[0];
			if (!wxFileExists(name))
            {
				throwout(_("Datei existiert nicht\nAblage verweigert!"),5);
				return;
			}

            wxTextCtrl* textCtrl = dynamic_cast<wxTextCtrl*>(event.GetEventObject());
            wxASSERT(textCtrl);
            textCtrl->Clear();
            textCtrl->SetValue(name);
            drop_succ=true;
            cur_cry_path= ((wxFileName)name).GetPath(); //get new path and store into cur_doc_path
        return;
        }
    }
/*********************************************************/
/****************************************************************/
void advancd_symm::OnFileSel(wxCommandEvent& event)
{
    wxString xfile,cry_d;

    if(cur_cry_path.IsEmpty())
    {
        cry_d = cry_path; //first call
    }
    else
    {
        cry_d = cur_cry_path;
    }
    xfile = wxFileSelector(_("Waehle zu bearbeitende Datei"),cry_d,_(""),_("*|ciph"),_("plainfiles (*.*)|*|ciphers(*.ciph)|*.ciph"));
    if(xfile.IsEmpty())
    {
        wxMessageBox(_("Datei existiert nicht!\nAbbruch!"));
        return;
    }
    else
    {
        fnam_ctrl->SetValue(xfile);
        cur_cry_path= ((wxFileName)xfile).GetPath(); //get new path and store into cur_doc_path
        return;
    }
}
/****************************************************************/
void advancd_symm::OnNewSalt(wxCommandEvent& event)
{    		//insert salt
    locsalt.makerandom(32);
    //zuf.p_makerandom(&salt,32);
    locsalt.writehex(&loc_salt_str);
    salt_ctrl->SetValue(loc_salt_str);
}
/****************************************************************/
void advancd_symm::OnEncipher(wxCommandEvent& event)
{
    int namlen,stretch,anum,fr,kr,h_len;
    wxString fnam,skey,hx,extn,algo,dkytxt,cfnam, cm_str,halgo, plsc_str;
    longnumber lky,hmacky;
    longnumber nonce,calc_mac, pre_plsc,plsc_ky;
    long long filen;
    double decoylen;
    ulong32 bufflen=0;
    char *bfnam;
    bool ciphres, legacy, usd_cntr=false, has_plsc= false;
    FILE *pkf;


        //get passwd and prepare key
        //truncate to 800
    fnam=fnam_ctrl->GetLineText(0);
    has_plsc=plsc_chkd->IsChecked();
    //check for existence
    if(!wxFileExists(fnam))
    {
        throwout(_("Datei existiert nicht!\nAbbruch!"),4);
        return;
    }
    if(has_plsc)
    {
      wxFile tmpfl(fnam);
      filen=tmpfl.Length();
      tmpfl.Close();
      decoylen = (double) filen;
      bufflen = 256 * (unsigned int)zuf.get_rbyte();
      bufflen += (unsigned int)zuf.get_rbyte();
      bufflen= (ulong32) (sqrt((decoylen * (double)bufflen)/ (double) 20003));
      bufflen += (unsigned int) zuf.get_rbyte();
      //make plsc longnumber
      pre_plsc.makerandom(32);
      pre_plsc.setsize(true);
      memcpy(pre_plsc.ad,&bufflen,4);
      pre_plsc.setsize(true);
      pre_plsc.shrinktofit();
    }
    if(fnam.Right(4)==_("ciph")) throwout(_("Warnung: \nChiffrieren einer Chiffre !?!"),4);
    namlen=fnam.Len();
    if(namlen>1000) {throwout(_("Dateiname zu lang, Abbruch")); return;}
    else bfnam = (char *) malloc(4*fnam.Len()+2);
    strcpy( bfnam, (const char*)fnam.mb_str(wxConvLocal) );
    //get key
    skey = key_ctrl->GetLineText(0);
    //truncate to 400
    if(skey.Len()>400) skey.Truncate(400);
    loc_salt_str=salt_ctrl->GetLineText(0);
    locsalt.storhex(&loc_salt_str);
    //set parameters for enciphering
    anum= algo_ctrl->GetCurrentSelection();
    if(anum==0) {algo=_("aes");fr=0; kr=1; h_len=16;extn=_("_ae");}
      else if(anum==1) {algo= _("Fleas_1_8"); fr=4;kr=2;h_len=65;extn=_("_c3");}
      else if(anum==2) {algo= _("Fleas_3"); fr=4;kr=2;h_len=65;extn=_("_f3");}
      else if(anum==3) {algo= _("Fleas_o2");fr=4;kr=2;h_len=512;extn=_("_o2");}
      else if(anum==4) {algo= _("Fleas_o5");fr=4;kr=2;h_len=512;extn=_("_o5");}
      else if(anum==5) {algo= _("Fleas_l");fr=4;kr=2;h_len=512;extn=_("_l");}
      else if(anum==6) {algo= _("Fleas_ls");fr=4;kr=2;h_len=512;extn=_("_ls");}
      else if(anum==7) {algo= _("Fleas_l3");fr=4;kr=3;h_len=512;extn=_("_l3");}
      else if(anum==8) {algo= _("Fleas_lb");fr=4;kr=3;h_len=512;extn=_("_lb");}
      else if(anum==9) {algo= _("Fleas_lc");fr=4;kr=3;h_len=512;extn=_("_lc");}
      else if(anum==10) {algo= _("Fleas_ld");fr=4;kr=3;h_len=512;extn=_("_ld");}
      else if(anum==11) {algo= _("threefish"); fr=0;kr=1;h_len=128;extn=_("_tf");}
      else if(anum==12) {algo= _("F_cnt_1c");fr=4;kr=3;h_len=512;extn=_("_1c");}
      else if(anum==13) {algo= _("F_cnt_1d");fr=4;kr=4;h_len=512;extn=_("_1d");}
      else if(anum==14) {algo= _("F_cnt_1b");fr=4;kr=4;h_len=512;extn=_("_1b");}
      else if(anum==15) {
            algo= _("flight");fr=3;kr=1;h_len=512;extn=_("_fl");
      }
      else if(anum==16) {
            algo= _("flightx");fr=3;kr=1;h_len=512;extn=_("_fx"); //h_len and ss_klen add up to pow of 2
      }
      else if(anum==17) {
            algo= _("chimera");fr=3;kr=1;h_len=512;extn=_("_ff"); //chimera or fleafish, h_len and ss_klen add up to pow of 2
      }
        else{ throwout(_("Kein valider Algorithmus spezifiziert! \nAbbruch.")); free(bfnam); return;}


    //prepare key
    stretch=stretch_ctrl->GetValue();
    legacy=Legacy->GetValue();
    if(!kyprep(&lky, &skey, &locsalt, &stretch_ell, stretch,ss_klen,legacy ))  //make ky
    {
        throwout(_("Fataler Fehler in kyprep!!"));
        free(bfnam);
        return;
    }




     if(anum > 10) usd_cntr=true;  //for safety reasons change salt after using counter mode! Mark salt as used
    //encipher file
    lky.setsize(true);
    if(has_plsc) //if plsc active and prestructures set
    {
        //separate key to protect real key
        plsc_ky.copynum(&lky);
        develop_ln2((char *)plsc_ky.ad,plsc_ky.size,3,3,3,3);
        plsc_ky.setsize(true);
        //recover plsc value
        pre_plsc.lonu_lock(&plsc_ky,_("flightx"));
        pre_plsc.setsize(true);
        pre_plsc.writehex(&plsc_str);
    }
    //write out key
    lky.writehex(&dkytxt);
    dirkey_ctrl->SetValue(dkytxt);
    if(lky.length< (unsigned int) ss_klen) lky.resizelonu(ss_klen);
    ciphres=encipher_file(bfnam, (char *)lky.ad, ss_klen, (char) fr, kr, h_len, 1, algo,1);
    free(bfnam);
    //give message
    if(ciphres) throwout(_("chiffriert"),1);
     else {
         throwout(_("Chiffrierung Gescheitert!"));
         return;
     }
    //create prepend file
    hx=_("prep_file.pre");
    if((pkf=fopen((const char*)hx.mb_str(wxConvLocal),"w")) == NULL)
        {
            throwout(_("Fehler! Oeffnen der prepend-Datei gescheitert!?!"));
            return;
        }
    fprintf(pkf,"salt: %s \n",(const char*)loc_salt_str.mb_str(wxConvUTF8));
    fprintf(pkf,"algo: %s \n",(const char*)algo.mb_str(wxConvUTF8));
    fprintf(pkf,"stretch: %i %s \n",stretch, (const char*)(stretch_ell.name).mb_str(wxConvUTF8));

    //determine hmac key
    nonce.makerandom(48);
    nonce.setsize(true);
    hmacky.copynum(&lky);
    hmacky.setsize(true);
    hmacky.shrinktofit();
    co_develop_ln2((char *)(hmacky.ad),(int)(hmacky.size), (char *)(nonce.ad),(int)(nonce.size),2,3 );
    halgo = algo;
    if(halgo == _("aes")) halgo= _("sha2");
       else if(halgo == _("Fleas_l")) halgo=_("Fleas_b");
         else if(halgo== _("F_cnt_1b")) halgo= _("Fleas_b");
         else if(halgo== _("threefish")) halgo= _("skein");
           else if(halgo== _("F_cnt_1c")) halgo= _("Fleas_c");
             else if(halgo== _("F_cnt_1d")) halgo= _("Fleas_d");
             else if(halgo== _("Fleas_lb")) halgo= _("Fleas_b"); //use new Hashes
             else if(halgo== _("Fleas_lc")) halgo= _("Fleas_c");
             else if(halgo== _("Fleas_ld")) halgo= _("Fleas_d");
             else if(halgo== _("flight")) halgo= _("JH");
             else if(halgo== _("flightx")) halgo= _("JH");
             else if(halgo== _("chimera")) halgo= _("skein");
                else if((anum>0)&&(anum<8)) halgo= _("Fleas_c"); //older ciphers
    cfnam= fnam+extn;
    hmacky.setsize(true);
    hmacky.shrinktofit();
    if((unsigned int)h_len> hmacky.length) hmacky.resizelonu(h_len);
    get_lonu_hmac_from_filename_x(&calc_mac,&cfnam, &hmacky, h_len, halgo, 1,0);
    calc_mac.resizelonu(48,0);
    calc_mac.writehex(&cm_str);
    fprintf(pkf,"MAC: %s  %s \n",(const char*)halgo.mb_str(wxConvUTF8),(const char*)cm_str.mb_str(wxConvUTF8));
    nonce.writehex(&cm_str);  //reusing string
    fprintf(pkf,"nonce: %s \n",(const char*)cm_str.mb_str(wxConvUTF8));
    if(has_plsc)
    {
          // write plsc to file
          fprintf(pkf,"plsc: %s \n",(const char*)plsc_str.mb_str(wxConvUTF8));
    }
    fclose(pkf);
    //concatenate files and cleanup
   if(!fileconcat(hx, fnam+extn, fnam +_("_ciph"), _("end_header_info::"),bufflen))
        {
          throwout(_("Fehler!\nciph-Datei konnte nicht aus den Komponenten erstellt werden"),20);
        }
    else throwout(_("Chiffre *_ciph erzeugt\nim gleichen Verzeichnis wie Klardatei!"),2);
        //delete concat wells
    wxRemoveFile(hx);
    wxRemoveFile(fnam+extn);
    //if counter mode was used change salt! Never use same key twice!
    if(usd_cntr)
    {
        OnNewSalt(event);
        usd_cntr=false;
    }
    return;
}
/****************************************************************/
void advancd_symm::OnDecipher(wxCommandEvent& event)
{
    wxString fnam,kpath,ciphnam,headnam,hs,algo,loc_se_id,skey,extn,dkytxt,macnam,h2,halgo,mymssg;
    int namlen,stretch,fr,kr,h_len,answer;
    char buff1[4002];
    int rcnt;
    FILE *pkf;
    longnumber lky,hmacky, pre_plsc, plsc_ky;
    longnumber c_mac,nonce,calc_mac;
    char *pnam,*cnam;
    bool ciphres, legacy, has_plsc=false;
    ulong32 deadhead,plsc=0;

    //check file-extension and possibly warn
    fnam=fnam_ctrl->GetLineText(0);
    if(fnam.Right(4)!=_("ciph")) throwout(_("Warnung: \nDechiffrierung einer Klardatei !?!"),4);
    namlen=fnam.Len();
    if(namlen>1000) {throwout(_("Dateiname zu lang, Abbruch")); return;}
    if(!wxFileExists(fnam))
    {
        throwout(_("Datei existiert nicht!\n Abbruch."),4);
        return;
    }
    //splicefile
    kpath=((wxFileName) fnam).GetPath(wxPATH_GET_VOLUME|wxPATH_GET_SEPARATOR);
    headnam= ((wxFileName) fnam).GetName();
// replace splicing to speed up
    if(!file_pos_past(fnam,_("end_header_info::"),&deadhead,2000))
    {
        throwout(_("header Marke nicht gefunden!\nAbbruch"),5);
        return;
    }
    wxFFile pkfil(fnam,_("rb"));
    if(!pkfil.IsOpened())
    {
        throwout(_("Fehler: Konnte Datei nicht oeffnen: ") + fnam +_("\n Abbruch"), 4);
        return;
    }
    pkf=pkfil.fp();
    //pkf=fopen((const char*)fnam.mb_str(wxConvLocal), "r");
    if(pkf==NULL){throwout(_("Fehler beim oeffnen des Kopfblockes der Chiffre"),4); return;}
    rcnt= fscanf(pkf,"salt: %400s ",buff1);
    if(rcnt != 1) {throwout(_("Fehler beim Lesen des salt"),4); //fclose(pkf);
         return;}
    hs=wxString::FromUTF8(buff1);
    locsalt.storhex(&hs);
    rcnt= fscanf(pkf,"algo: %400s ",buff1);
    if(rcnt != 1) {throwout(_("Fehler beim Lesen des algo"),4); //fclose(pkf);
         return;}
    algo=wxString::FromUTF8(buff1);
    rcnt= fscanf(pkf,"stretch: %i ",&stretch);
    if(rcnt != 1) {throwout(_("Fehler beim Lesen des stretch"),4); //fclose(pkf);
         return;}
    rcnt= fscanf(pkf,"%400s ",buff1);
    if(rcnt != 1) {throwout(_("Fehler beim Lesen des stretch_ell id"),4); //fclose(pkf);
         return;}
    loc_se_id=wxString::FromUTF8(buff1);
    if(loc_se_id != stretch_ell.name) throwout(_("Starke Warnung!\n stretcher Domain Konflikt.\nSchluesselpreparation wird wahrscheinlich versagen!"));
    //check for tag
    rcnt= fscanf(pkf,"%10s ",buff1);
    if(rcnt != 1)
    {
            throwout(_("Warnung, defekte header Datei!\nAbbruch."),2);
            //fclose(pkf);
            return;
    }
    else
    {
         h2=wxString::FromUTF8(buff1);
         if(h2==_("MAC:"))
         {
             rcnt= fscanf(pkf,"%400s ",buff1);
             if(rcnt == 1)
             {
                macnam=wxString::FromUTF8(buff1);
                rcnt= fscanf(pkf,"%1000s ",buff1);
                if(rcnt != 1) {throwout(_("Lesefehler des MAC Wertes\n keine Dechiffrierung."),2);//fclose(pkf);
                    return;}
                h2=wxString::FromUTF8(buff1);
                c_mac.storhex(&h2);
                rcnt = fscanf(pkf," nonce: %1000s ",buff1);
                if(rcnt != 1) {throwout(_("Lesefehler des Nonce-Wertes\n keine Dechiffrierung."),2);//fclose(pkf);
                    return;}
                h2=wxString::FromUTF8(buff1);
                nonce.storhex(&h2);
             }
             else
             {
                 throwout(_("Lesefehler des MAC Typs\n keine Dechiffrierung."),4);
                 //fclose(pkf);
                 return;
             }


         }
         else
         {
             throwout(_("Warnung, Kein Integritaetscheck moeglich"),2);
             //fclose(pkf);
             OnOlDecipher(event); //old unautheticated pattern
             return;
         }
    }
    //check for payload size camouflage
    rcnt= fscanf(pkf," plsc: %1000s ",buff1);
    if(rcnt == 1) // sonst einfach ende
    {
        has_plsc=true;
        h2=wxString::FromUTF8(buff1);
        //put into longnumber
        pre_plsc.storhex(&h2);
        pre_plsc.setsize(true);
        pre_plsc.shrinktofit(); //lowest 4 byte of deciphered lonu will be plsc value
        throwout(_("PLSC gefunden"),1);
    }



    //fclose(pkf);
    if(!pkfil.Close())
    {
        throwout(_("Fehler beim Schliessen von pkfil in \"OnDecipher\" "),5);
    }
    //get key and prepare
        //get key
    skey = key_ctrl->GetLineText(0);
    //truncate to 400
    if(skey.Len()>400) skey.Truncate(400);
    //determine algorithm
    if(algo==_("aes")){fr=0; kr=1; h_len=16;extn=_("_ae");}
      else if(algo== _("threefish")) {fr=0;kr=1;h_len=128;extn=_("_tf");}
      else if(algo== _("Fleas_1_8")) {fr=4;kr=2;h_len=65;extn=_("_c3");}
      else if(algo== _("Fleas_3")) {fr=4;kr=2;h_len=65;extn=_("_f3");}
      else if(algo== _("Fleas_o2")){fr=4;kr=2;h_len=512;extn=_("_o2");}
      else if(algo== _("Fleas_o5")){fr=4;kr=2;h_len=512;extn=_("_o5");}
      else if(algo== _("Fleas_l")){fr=4;kr=2;h_len=512;extn=_("_l");}
      else if(algo== _("Fleas_ls")){fr=4;kr=2;h_len=512;extn=_("_ls");}
      else if(algo== _("Fleas_l3")){fr=4;kr=3;h_len=512;extn=_("_l3");}
      else if(algo== _("Fleas_lb")){fr=4;kr=3;h_len=512;extn=_("_lb");}
      else if(algo== _("Fleas_lc")){fr=4;kr=3;h_len=512;extn=_("_lc");}
      else if(algo== _("Fleas_ld")){fr=4;kr=3;h_len=512;extn=_("_ld");}
      else if(algo== _("F_cnt_1c")){fr=4;kr=3;h_len=512;extn=_("_1c");}
      else if(algo== _("F_cnt_1d")){fr=4;kr=4;h_len=512;extn=_("_1d");}
      else if(algo== _("F_cnt_1b")){fr=4;kr=4;h_len=512;extn=_("_1b");}
      else if(algo== _("flight")){fr=4;kr=4;h_len=512;extn=_("_fl");}
      else if(algo== _("flightx")){ fr=4;kr=4;h_len=512;extn=_("_fx");}
      else if(algo== _("chimera")){ fr=4;kr=4;h_len=512;extn=_("_ff");}
        else{ throwout(_("Kein Valider oder bekannter Algorithmus spezifiziert! \nAbbruch.")); return;}
        //prepare key
    legacy=Legacy->GetValue();
    if(!kyprep(&lky, &skey, &locsalt, &stretch_ell, stretch,ss_klen,legacy ))  //make ky
    {
        throwout(_("Fatal error in kyprep!!"));
        return;
    }
    lky.setsize(true);
    //write out key
    lky.writehex(&dkytxt);
    dirkey_ctrl->SetValue(dkytxt);
    if(has_plsc) //then develop true plsc value
    {
        //separate key to protect real key
        plsc_ky.copynum(&lky);
        develop_ln2((char *)plsc_ky.ad,plsc_ky.size,3,3,3,3);
        plsc_ky.setsize(true);
        //recover plsc value
        pre_plsc.lonu_unlock(&plsc_ky,_("flightx"));
        memcpy(&plsc,pre_plsc.ad,4);
        deadhead += plsc; //and done now :-)
    }

     //determine hmac key
    hmacky.copynum(&lky);
    hmacky.setsize(true);
    hmacky.shrinktofit();
    co_develop_ln2((char *)(hmacky.ad),(int)(hmacky.size),(char *)(nonce.ad),(int)(nonce.size), 2,3 );

    halgo = algo;
    if(halgo == _("aes")) halgo= _("sha2");
       else if(halgo == _("Fleas_l")) halgo=_("Fleas_b");
         else if(halgo== _("F_cnt_1b")) halgo= _("Fleas_b");
           else if(halgo== _("F_cnt_1c")) halgo= _("Fleas_c");
             else if(halgo== _("F_cnt_1d")) halgo= _("Fleas_d");
              else if(halgo== _("Fleas_ld")) halgo= _("Fleas_d");
              else if(halgo== _("Fleas_lb")) halgo= _("Fleas_b");
              else if(halgo== _("Fleas_lc")) halgo= _("Fleas_c");
               else if(halgo== _("flight")) halgo= _("JH");
               else if(halgo== _("flightx")) halgo= _("JH");
               else if(halgo== _("threefish")) halgo= _("skein");
               else if(halgo== _("chimera")) halgo= _("skein");
                else halgo= _("Fleas_c"); //older ciphers
    if(halgo != macnam)
    {
        throwout(_("Warnung!\n Unuebliche Wahl des MAC-Algorithmus !?!"),4);
    }
    hmacky.setsize(true);
    hmacky.shrinktofit();
    if((unsigned int)h_len> hmacky.length) hmacky.resizelonu(h_len);
    get_lonu_hmac_from_filename_x(&calc_mac,&fnam, &hmacky, h_len, macnam, 1, deadhead );
    calc_mac.resizelonu(48,0);
    if( calc_mac.compare(&c_mac) != 0 ) //wrong mac!
    {
        //new policy: Simply reject on wrong HMAC
        throwout(_("Falsches Passwort oder Integritaetsverletzung beim Chiffrat\nEntschluesselung verweigert!"),3);
        return;
        //the following is obsolete
        mymssg=_("DRINGENDE WARNUNG!!! Integritaetsverletzung(oder falsches Passwort)!!!\n Chiffrat koennte manipuliert worden sein, Du solltest die Dechiffrierung abbrechen.\nTrau der erzeugten Klardatei NICHT!!!\n");
        mymssg +=  _("Abbruch(OK) oder \nSoll die Dechiffrierung trotzdem versucht werden(NO) ?");
        AskDialog d1(this,mymssg);
        answer=d1.ShowModal();
        if(answer==1) return;
    }
    else
        {
            //throwout(_(" Sound cipher integrity :-)"),2);
        }



    wxString p_nam;
    p_nam=fnam.Left(fnam.Len()-5);
    pnam = (char *) malloc(4*fnam.Len()+2);
    cnam = (char *) malloc(4*fnam.Len()+2);
    strcpy( pnam, (const char*)p_nam.mb_str(wxConvLocal) );
    strcpy( cnam, (const char*)fnam.mb_str(wxConvLocal) );
    if(lky.length< (unsigned int)ss_klen) lky.resizelonu(ss_klen);
    ciphres=dec_fil(deadhead,cnam,pnam, (char *)lky.ad, ss_klen, (char) fr, kr, h_len, 1, algo,1);
    free(pnam); free(cnam);
    //give message
    if(ciphres)
    {
        throwout(_("dechiffriert."),1);
    }
     else {
         throwout(_("Dechiffrierung GESCHEITERT!"));
         return;
     }
    //delete intermediate cipher

    //wxRemoveFile(hs);
    return;
}
/****************************************************************/
/****************************************************************/
void advancd_symm::OnOlDecipher(wxCommandEvent& event)
{
    wxString fnam,kpath,ciphnam,headnam,hs,algo,loc_se_id,skey,extn,dkytxt,macnam,h2;
    int namlen,stretch,fr,kr,h_len;
    char buff1[802];
    int rcnt;
    FILE *pkf;
    longnumber lky;
    longnumber c_mac;
    char *pnam,*cnam;
    bool ciphres;
    ulong32 deadhead;



    //check file-extension and possibly warn
    fnam=fnam_ctrl->GetLineText(0);
    if(fnam.Right(5)!=_(".ciph")) throwout(_("warning: \nDeciphering a non-cipher !?!"),4);
    namlen=fnam.Len();
    if(namlen>1000) {throwout(_("filename too long, aborting")); return;}
    if(!wxFileExists(fnam))
    {
        throwout(_("File does not exist!\n Do nothing."),4);
        return;
    }
    //splicefile
    kpath=((wxFileName) fnam).GetPath(wxPATH_GET_VOLUME|wxPATH_GET_SEPARATOR);
    headnam= ((wxFileName) fnam).GetName();
// replace splicing to speed up
    if(!file_pos_past(fnam,_("end_header_info::"),&deadhead,2000))
    {
        throwout(_("header mark not found!\naborting"),5);
        return;
    }
    /*ciphnam=headnam + _("_l");
    //headnam= headnam +_(".head");
    if(!splicefile(fnam, headnam, ciphnam, _("end_header_info::")))
    {
        throwout(_("Splicing cipher file not successful\nAborting"),20);
        return;
    } */
    //get kyprep parameters and algorithm
         //read pars to loc
    pkf=fopen((const char*)fnam.mb_str(wxConvLocal), "r");
    if(pkf==NULL){throwout(_("error opening head-file of cipher"),4); return;}
    rcnt= fscanf(pkf,"salt: %400s ",buff1);
    if(rcnt != 1) {throwout(_("error reading salt"),4); fclose(pkf); return;}
    hs=wxString::FromUTF8(buff1);
    locsalt.storhex(&hs);
    rcnt= fscanf(pkf,"algo: %400s ",buff1);
    if(rcnt != 1) {throwout(_("error reading algo"),4); fclose(pkf); return;}
    algo=wxString::FromUTF8(buff1);
    rcnt= fscanf(pkf,"stretch: %i ",&stretch);
    if(rcnt != 1) {throwout(_("error reading stretch"),4); fclose(pkf); return;}
    rcnt= fscanf(pkf,"%400s ",buff1);
    if(rcnt != 1) {throwout(_("error reading stretch_ell id"),4); fclose(pkf); return;}
    loc_se_id=wxString::FromUTF8(buff1);
    if(loc_se_id != stretch_ell.name) throwout(_("WARNUNG!\en stretcher ellipse Widerspruch.\nSchluesselvorbereitung wird\nvermutlich scheitern!"));
    //check for tag
    rcnt= fscanf(pkf,"%400s ",buff1);
    if(rcnt != 1) {throwout(_("Warnung, kein Integritaetscheck moegl."),2);}
    else
    {
         h2=wxString::FromUTF8(buff1);
         if(h2==_("MAC:"))
         {
             rcnt= fscanf(pkf,"%400s ",buff1);
             if(rcnt == 1)
             {
                macnam=wxString::FromUTF8(buff1);
                rcnt= fscanf(pkf,"%800s ",buff1);
                if(rcnt != 1) {throwout(_("Lesefehler MAC-Wert\n keine Entschl."),2);fclose(pkf); return;}
                h2=wxString::FromUTF8(buff1);
                c_mac.storhex(&h2);
             }
             else
             {
                 throwout(_("Lesefehler MAC type\n keine Entschl."),4);
                 fclose(pkf);
                 return;
             }


         }
         else
         {
             throwout(_("Warnung, \nkein Integritaetscheck moeglich"),2);
         }
    }

    fclose(pkf);
    //get key and prepare
        //get key
    skey = key_ctrl->GetLineText(0);
    //truncate to 400
    if(skey.Len()>400) skey.Truncate(400);
    //determine algorithm
    if(algo==_("aes")){fr=0; kr=1; h_len=16;extn=_("_ae");}
      else if(algo== _("Fleas_1_8")) {fr=4;kr=2;h_len=65;extn=_("_c3");}
      else if(algo== _("Fleas_3")) {fr=4;kr=2;h_len=65;extn=_("_f3");}
      else if(algo== _("Fleas_o2")){fr=4;kr=2;h_len=512;extn=_("_o2");}
      else if(algo== _("Fleas_o5")){fr=4;kr=2;h_len=512;extn=_("_o5");}
      else if(algo== _("Fleas_l")){fr=4;kr=2;h_len=512;extn=_("_l");}
      else if(algo== _("Fleas_ls")){fr=4;kr=2;h_len=512;extn=_("_ls");}
      else if(algo== _("Fleas_l3")){fr=4;kr=3;h_len=512;extn=_("_l3");}
      else if(algo== _("Fleas_lc")){fr=4;kr=3;h_len=512;extn=_("_lc");}
      else if(algo== _("Fleas_ld")){fr=4;kr=3;h_len=512;extn=_("_ld");}
      else if(algo== _("F_cnt_1c")){fr=4;kr=3;h_len=512;extn=_("_1c");}
      else if(algo== _("F_cnt_1d")){fr=4;kr=4;h_len=512;extn=_("_1d");}
      else if(algo== _("F_cnt_1b")){fr=4;kr=4;h_len=512;extn=_("_1b");}
      else if(algo== _("threefish")) {fr=0;kr=1;h_len=128;extn=_("_tf");}
      else if(algo== _("flight")){fr=4;kr=4;h_len=512;extn=_("_fl");}
      else if(algo== _("flightx")){ fr=4;kr=4;h_len=512;extn=_("_fx");}
      else if(algo== _("chimera")){ fr=4;kr=4;h_len=512;extn=_("_ff");}
        else{ throwout(_("Kein bekannter Algorithmus spezifiziert! \nAbbruch.")); return;}
        //prepare key
    if(!kyprep(&lky, &skey, &locsalt, &stretch_ell, stretch,ss_klen ))  //make ky
    {
        throwout(_("Fatal error in kyprep!!"));
        return;
    }

    lky.setsize(true);
    //write out key
    lky.writehex(&dkytxt);
    dirkey_ctrl->SetValue(dkytxt);
    wxString p_nam;
    p_nam=fnam.Left(fnam.Len()-5);
    pnam = (char *) malloc(2*fnam.Len()+2);
    cnam = (char *) malloc(2*fnam.Len()+2);
    strcpy( pnam, (const char*)p_nam.mb_str(wxConvLocal) );
    strcpy( cnam, (const char*)fnam.mb_str(wxConvLocal) );
    // if macced call macced routine! make hashromfile incl deadhead
    ciphres=dec_fil(deadhead,cnam,pnam, (char *)lky.ad, ss_klen, (char) fr, kr, h_len, 1, algo,1);
    free(pnam); free(cnam);
    if(ciphres) throwout(_("dechiffiert"),1);
     else {
         throwout(_("entschluesselung\n Fehlgeschlagen!"));
     }
    return;
}
/****************************************************************/
void advancd_symm::Onprecalc(wxCommandEvent& event)
{
    int stretch;
    wxString dkytxt,skey,hx,extn,algo;
    longnumber lky;
    bool legacy;

    //get key
    skey = key_ctrl->GetLineText(0);
    //truncate to 400
    if(skey.Len()>400) skey.Truncate(400);
    loc_salt_str=salt_ctrl->GetLineText(0);
    locsalt.storhex(&loc_salt_str);
    //get stretch
    stretch=stretch_ctrl->GetValue();
    legacy=Legacy->GetValue();
    if(!kyprep(&lky, &skey, &locsalt, &stretch_ell, stretch,ss_klen,legacy ))  //make ky
    {
        throwout(_("Fataler Fehler in kyprep!!"));
        return;
    }
    //write out key
    lky.setsize(true);
    lky.writehex(&dkytxt);
    dirkey_ctrl->SetValue(dkytxt);
    return;
}
/***************************************************************/


