/*
 *   Copyright (C) 2011-2017, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
 

#ifndef LOADELLKEY_H
#define LOADELLKEY_H

//(*Headers(LoadEllKey)
#include <wx/dialog.h>
#include <wx/sizer.h>
#include <wx/button.h>
#include <wx/stattext.h>
#include <wx/timer.h>
#include <wx/listbox.h>
//*)

#include "elliptic1.h"

class LoadEllKey: public wxDialog
{
	public:

		LoadEllKey(wxWindow* parent,el_pub* loky1, wxWindowID id=wxID_ANY,const wxPoint& pos=wxDefaultPosition,const wxSize& size=wxDefaultSize);
		virtual ~LoadEllKey();

		//(*Declarations(LoadEllKey)
		wxListBox* ListBox1;
		wxButton* Button1;
		wxButton* Button2;
		wxStaticText* StaticText1;
		wxTimer Timer1;
		wxStaticText* StaticText2;
		//*)

        wxArrayString ids; // da werden die Listbox-Einträge abgelegt

		//meins
		el_pub *loky;


	protected:

		//(*Identifiers(LoadEllKey)
		static const long ID_BUTTON1;
		static const long ID_STATICTEXT1;
		static const long ID_STATICTEXT2;
		static const long ID_BUTTON2;
		static const long ID_LISTBOX1;
		static const long ID_TIMER1;
		//*)

	private:

		//(*Handlers(LoadEllKey)
		void OnLoad(wxCommandEvent& event);
		void OnCancel(wxCommandEvent& event);
		void OnTimeout(wxTimerEvent& event) ;
		void OnTimer1Trigger(wxTimerEvent& event);
		//*)

		DECLARE_EVENT_TABLE()
};

#endif
