/*
 *   Copyright (C) 2011-2016, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */


#ifndef SIGN_ELLIP_H
#define SIGN_ELLIP_H

//(*Headers(sign_ellip)
#include <wx/checkbox.h>
#include <wx/dialog.h>
#include <wx/sizer.h>
#include <wx/button.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>
#include <wx/choice.h>
#include <wx/timer.h>
#include <wx/statbmp.h>
//*)

#include "elliptic1.h"


class sign_ellip: public wxDialog
{
	public:

		sign_ellip(wxWindow* parent,wxWindowID id=wxID_ANY,const wxPoint& pos=wxDefaultPosition,const wxSize& size=wxDefaultSize);
		virtual ~sign_ellip();

		//(*Declarations(sign_ellip)
		wxTextCtrl* cdom_ctrl;
		wxButton* Button4;
		wxButton* Button1;
		wxButton* Button2;
		wxButton* Button3;
		wxStaticText* StaticText1;
		wxTimer Timer1;
		wxTextCtrl* filnam_ctrl;
		wxStaticText* StaticText3;
		wxTextCtrl* keydom_ctrl;
		wxChoice* Hash_choice;
		wxStaticText* StaticText4;
		wxButton* MULTI_SIG;
		wxTextCtrl* kid_ctrl;
		wxStaticText* StaticText5;
		wxStaticText* StaticText2;
		wxStaticBitmap* StaticBitmap1;
		wxStaticText* StaticText6;
		wxTextCtrl* fullnam_ctrl;
		wxCheckBox* detbox;
		//*)

		wxString fnam;

	protected:

		//(*Identifiers(sign_ellip)
		static const long ID_BUTTON4;
		static const long ID_STATICTEXT1;
		static const long ID_CHECKBOX1;
		static const long ID_STATICTEXT2;
		static const long ID_TEXTCTRL1;
		static const long ID_BUTTON1;
		static const long ID_STATICTEXT3;
		static const long ID_TEXTCTRL2;
		static const long ID_BUTTON2;
		static const long ID_STATICTEXT5;
		static const long ID_TEXTCTRL5;
		static const long ID_STATICTEXT6;
		static const long ID_STATICTEXT4;
		static const long ID_STATICBITMAP1;
		static const long ID_CHOICE1;
		static const long ID_TEXTCTRL3;
		static const long ID_BUTTON3;
		static const long ID_BUTTON5;
		static const long ID_TEXTCTRL4;
		static const long ID_TIMER1;
		//*)

	private:

		//(*Handlers(sign_ellip)
		void OnFileSel(wxCommandEvent& event);
		void OnSelKey(wxCommandEvent& event);
		void OnCancel(wxCommandEvent& event);
		void OnSign(wxCommandEvent& event);
		void OnTimer(wxTimerEvent& event);
		void OnMultiSign(wxCommandEvent& event);
		//*)
        int half_min_counter;
        bool nostop;
        precalc pre;
        ellipse elp;  //module scope foof for threaded calculation
        bool thread_runs;
        bool detmin;

       void OnDropFile(wxDropFilesEvent& event);
       bool drop_succ;  //provide Feedback

		DECLARE_EVENT_TABLE()
};



#endif
