/*
 *   Copyright (C) 2011-2017, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */


#ifndef ENCIPH_N_AUTHENT_H
#define ENCIPH_N_AUTHENT_H

//(*Headers(enciph_n_authent)
#include <wx/checkbox.h>
#include <wx/dialog.h>
#include <wx/sizer.h>
#include <wx/button.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>
#include <wx/choice.h>
#include <wx/timer.h>
//*)

#include "globals.h"

class enciph_n_authent: public wxDialog
{
	public:

		enciph_n_authent(wxWindow* parent,wxWindowID id=wxID_ANY,const wxPoint& pos=wxDefaultPosition,const wxSize& size=wxDefaultSize);
		virtual ~enciph_n_authent();

		//(*Declarations(enciph_n_authent)
		wxTextCtrl* outfnam_ctrl;
		wxButton* Button4;
		wxButton* Button1;
		wxButton* Button2;
		wxButton* Button3;
		wxChoice* sign_algo_ctrl;
		wxStaticText* StaticText1;
		wxStaticText* StaticText10;
		wxTextCtrl* pubkey_ctrl;
		wxTimer Timer1;
		wxTextCtrl* filnam_ctrl;
		wxStaticText* StaticText3;
		wxButton* Button5;
		wxChoice* algo_choice;
		wxTextCtrl* skid_ctrl;
		wxStaticText* StaticText4;
		wxCheckBox* NADA_ChkBox;
		wxStaticText* StaticText5;
		wxStaticText* StaticText2;
		wxButton* Button7;
		wxCheckBox* detbox;
		wxButton* Button6;
		wxStaticText* StaticText11;
		//*)

		wxString fnam,signam;
        el_pub loky;


	protected:

		//(*Identifiers(enciph_n_authent)
		static const long ID_BUTTON1;
		static const long ID_STATICTEXT1;
		static const long ID_STATICTEXT2;
		static const long ID_TEXTCTRL1;
		static const long ID_BUTTON2;
		static const long ID_STATICTEXT5;
		static const long ID_TEXTCTRL4;
		static const long ID_BUTTON7;
		static const long ID_STATICTEXT3;
		static const long ID_TEXTCTRL2;
		static const long ID_BUTTON3;
		static const long ID_STATICTEXT4;
		static const long ID_TEXTCTRL3;
		static const long ID_BUTTON4;
		static const long ID_CHECKBOX2;
		static const long ID_BUTTON5;
		static const long ID_NADACHECKBOX;
		static const long ID_STATICTEXT10;
		static const long ID_STATICTEXT11;
		static const long ID_BUTTON6;
		static const long ID_CHOICE2;
		static const long ID_CHOICE1;
		static const long ID_TIMER1;
		//*)

	private:

		//(*Handlers(enciph_n_authent)
		void OnExit(wxCommandEvent& event);
		void OnDo_it(wxCommandEvent& event);
		void OnFileSel(wxCommandEvent& event);
		void OnSelPublic(wxCommandEvent& event);
		void OnSelPrivate(wxCommandEvent& event);
		void OnTimer1Trigger(wxTimerEvent& event);
		void Onalgo_choiceSelect(wxCommandEvent& event);
		void OnNADA_ChkBoxClick(wxCommandEvent& event);
		void OnChangeOutput(wxCommandEvent& event);
		//*)

        int half_min_counter;
        bool nostop;
        bool detmin;

      void OnDropFile(wxDropFilesEvent& event);
      bool drop_succ;  //provide Feedback

		DECLARE_EVENT_TABLE()
};

#endif
