/*
 *   Copyright (C) 2011-2016, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

//#include <sys/mman.h>  //allow for memory locking of keyinfo


//#include  "helpers.h"
//#include  "memanag.h"
//#include  "dolonu.h" //schon in helpers drin

//extern fixedmem bl;
#include <wx/intl.h>
#include <wx/ffile.h>

#include <wx/msgdlg.h>
#include <wx/string.h>

#include "helpersxx.h"
#include "globals.h"


//#ifndef DEBUG_LONU   //spezielle Debug-Fehlerabfang-Routinen
//#define DEBUG_LONU   // auskommentieren für speed in release
//#endif


/********************************************/
longnumber::longnumber(ulong32 len)
{
  ulong32 i;

  ad = (unsigned char *)malloc(len);
  if(ad==NULL) wxMessageBox(_("Error creating\n longnumber"), _("Message:"));
  length= len;
  memset(ad,0,length);
  trusiz=false;
  israre=false;
  asum=NULL;asub=NULL;
  setsize();
}
/*********************************************/
longnumber::~longnumber()
{
  if( ad != NULL)
  {
   free((unsigned char*)ad);
   length=0;
   if(israre)
   {
       if(asum!=NULL) free(asum);
       if(asub!=NULL) free(asub);
   }
  }
  else wxMessageBox(_("Error destructing\n longnumber"), _("Message:"));
}
/*********************************************/
bool longnumber::integrate(unsigned char begbyte, unsigned char inc, unsigned char backflag)
  // integriert bis size und addiert begbyte am Anfang und inc bei jedem Schritt, backflag 2 heißt auch rückwärts
  // dient dazu codeinfo in zu dispergieren und entropie zu erhöhen
{
    ulong32 indx;

    if((length==0)||(size==0)) return false;
    *(ad) += begbyte;
    for(indx=1;indx<length-1;indx++)
    {
         *(ad + indx) += *(ad + indx-1) + inc;
    }
    if(backflag==2)
    {
        *(ad+size -1) += begbyte;
        for(indx=length-2;indx>0;indx--)
            {
                 *(ad + indx-1) += *(ad + indx) + inc;
            }
    }
    trusiz=false;
    return true;
}
/*********************************************/
ulong32 longnumber::setsize(bool force) //size aktualisieren
{
  long indx;

  if(trusiz && !force) return 0;
  if (length==0) {size=0; return 0;}
  for(indx=length-1;indx>=0;indx--)
  {
    if( *(ad+indx)!=0)
    {
      size= (indx+1);
      if (size>= 8388607) //bei mehr als 2^23 gibts mit hibit ein Ueberlaufproblem
      {
            throwout(_("warning: overflow in bitcounting possible!!!\n arithmetic errors in divisions possible"));
      }
      //hibit setzen
      hibit=get_hibit((ulong32) size);
      trusiz=true;
      return size;
    }
    if(indx==0)
    {
      size=0;
      hibit=-1;
      trusiz=true;
      return size;
    }
  }
  throwout(_("never see this error:setsize"));
  return size;  //never reached
}
/*********************************************/
/*********************************************/
ulong32 longnumber::setsizefrom(ulong32 lasthi) //size aktualisieren
{
  long indx;

  if (length==0) {size=0; return 0;}
  for(indx=lasthi>>3;indx>=0;indx--)
  {
    if( *(ad+indx)!=0)
    {
      size= (indx+1);
      if (size>= 8388607) //bei mehr als 2^23 gibts mit hibit ein Ueberlaufproblem
      {
            throwout(_("warning: overflow in bitcounting possible!!!\n arithmetic errors in divisions possible"));
      }
      //hibit setzen
      hibit=get_hibit_spec(lasthi);
      trusiz=true;
      return size;
    }
    if(indx==0)
    {
      size=0;
      hibit=-1;
      trusiz=true;
      return size;
    }
  }
  throwout(_("never see this error"));
  return size;  //never reached
}
/*********************************************/
bool longnumber::resizelonu(ulong32 newlength, unsigned char flag) //groesse neu setzen
{
  ulong32 ind;

  if((newlength < size)&&(flag==1))
  {
      throwout(_("warning: longnum truncated"));
  }
  if(newlength==0)
  {
      throwout(_("warning: longnum of length 0 \ndoes not make sense!"));
      return false;
  }
  ad= (unsigned char *) realloc((void*)ad,newlength);
  if(ad== NULL)
  {
      throwout(_("resize error")); return false;}
  if(newlength>length)
  {
    for(ind=length;ind<newlength;ind++)
      *(ad+ind)=0;
  }
  else if(newlength<=size)  trusiz=false;
  length = newlength;
  //if(mlock(ad,length)!=0)
    //throwout(_("warning\nlongnumber is swappable."),1);
  setsize(); // nach hinten verlagert (okt 2010), war vorher erstes Statement
  return true;
}
/*********************************************/
ulong32 longnumber::lconvert() //konv. die niedrigsten 4 byte to long
{
  ulong32 result=0;
  unsigned char h1;
  int i;

  for(i=3;i>=0;i--)
  {
    result *= 256;
    h1= *(ad+i);
    result += (ulong32)h1;
  }
  return result;
}
/****************************************************/
bool longnumber::stortext_old(wxString* text)
  // schreibt einen Text (ohne Konversion) blank in die lonu rein
  //neglect Sonderzeichen
{
    ulong32 strlen,i,hlp;
    char c;

    strlen= text->length();
    if(strlen==0)
    {
        storlong(0);
        return false;
    }
    //reassign lonulength
    resizelonu(strlen,0);
    for(i=0;i<strlen;i++)
    {
        //this one for old versions of wxWidgets
#ifdef WX28
           *(ad+i)=text->GetChar(i);
#else
        //this one for new wxwidgets 3.0.1 and higher
        if((text->GetChar(i)).GetAsChar(&c)) //monobyte conversion
           *(ad+i)= c;
        else//multibyte representation
            {
                *(ad+i)= 63;
            }
#endif
    }
    trusiz=false;
    setsize();
    return true;
}
/****************************************************/
bool longnumber::stortext(wxString* text)
  // schreibt einen Text (ohne Konversion) blank in die lonu rein
  // True utf8
{
    ulong32 istrglen,charlen,i;
    char *cbuff;

    istrglen= text->length();
    if(istrglen==0)
    {
        storlong(0);
        return false;
    }
    cbuff= (char *) malloc(4*istrglen+2);
    //to do convert to utf8 first
    strcpy(cbuff, (const char*)text->mb_str(wxConvUTF8));
    //then determine length
    charlen=strlen((char *)cbuff);
    //then resize longnumber
    resizelonu(charlen,0);
    //thenstore into longnumber
    memcpy(ad,cbuff,charlen);
    free((void*)cbuff);
    trusiz=false;
    setsize();
    return true;
}
/*********************************************/
unsigned char ishexchar(char c)
{
    if((c<58)&&(c>47))  return(c-48); //reduziere zur reinen Zahl
    else if((c<103)&&(c>96)) return(c-87); //reduziere zur reinen Zahl
            else if((c<71)&&(c>64)) return(c - 55); //reduziere zur reinen Zahl
                 else if((c=10)||(c=9)||(c=13)||(c=9)||(c=32) )return 16; //mark whitespace
                    else return 17;//mark as No hex!
}
/**************************************************************/
bool longnumber::storhex(wxString* text)
  //reads hex-string and stores to lonu
{
  int cnt=0, max,i,hexno;
  longnumber scratch;
  char c;
  unsigned char cn,h;
  char buff[300],b2[10];
  bool clean=true;
  wxString msg;
  wxString ctxt,htx;


  trusiz=false;
  if(text->IsEmpty()) {throwout(_("empty string")); return false;}
  max= text->Length();
// integrity check and number counting
  for(i=max-1;i>=0;i--)
  {
      if(i==1)
      {
          hexno = cnt;
      }
      c= text->GetChar(i); //hol den char
      cn=ishexchar(c);
      if(cn==16) continue;
      if(cn>16)
      {
          sprintf(buff,"Warning!\nnon_hexnumber encountered\n at position %d \n truncating!",i);
          throwout(wxString::FromAscii(buff),3);
          clean=false;
      }
      else {
          cnt++;
          sprintf(b2,"%c",c);
          htx=wxString::FromAscii(b2);
          ctxt = htx + ctxt;
          }
      if(!clean) break;
  }
  hexno=cnt;
  hexno=ctxt.Len();
  if(hexno==0) {throwout(_("no hex in string")); return false;}
  if((hexno&1)==1) ctxt= _("0") + ctxt; //now its even
  //prepare space
  scratch.resizelonu((ulong32)hexno/2+4);
  scratch.wipezero();
  //read in cleaned hexnumber
  for(i=0;i<(int)ctxt.Len()/2;i++)
  {
      c= ctxt.GetChar(2*i); //hol den char
      cn=ishexchar(c);
      if(cn>15)
      {
          sprintf(buff,"Never see this error 8-0");
          throwout(wxString::FromAscii(buff),3);
          return false;
      }
      cn<<=4;
      h=cn;
      c= ctxt.GetChar(2*i+1); //hol den char
      cn=ishexchar(c);
      if(cn>15)
      {
          sprintf(buff,"Never see this error 8-0");
          throwout(wxString::FromAscii(buff),3);
          return false;
      }
      h+=cn;
      *((scratch.ad)+ (ctxt.Len()/2 -1 -i) )=h;
   }
   scratch.setsize(true);
   scratch.shrinktofit();
   copynum(&scratch);
   return true;
}
/*********************************************//**************************************************************/
bool longnumber::storchar(wxString* text)
  //füllt mit dem konvertierten dezimalstring
{
  int cnt=0, max;
  longnumber scratch,zehn,faktor,akku;
  char c;
  char buff[80];
  long h1;

  if(text->IsEmpty()) {throwout(_("empty string")); return false;}
  trusiz=false; //aendert Zahleninhalt
  max= text->Length();
  akku.storlong(0);
  zehn.storlong(10);
  faktor.storlong(1);

  cnt=max-1;
  do
  {
    c= text->GetChar(cnt); //hol den char
    if((c>57)||(c<48))  // wenn keine Ziffer
    {
      sprintf(buff,"non_number encountered\n at position %d",cnt);

      throwout(wxString::FromAscii(buff));

      //throwout(_T("*buff"));
      if(cnt==max-1) { // wenns sofort passiert war Fehler
          //copynum(&akku);  //mit 0 füllen
          storlong(0);
          return false;
      }
      else // sonst wars fertig
      {
         copynum(&akku); // kopiere den buffer in lonu und raus!-> muss nicht hier der akuu rein?
         return true;
      }
    }
    h1=((long)c-48); //reduziere zur reinen Zahl
    scratch.storlong(h1); // schreibts als long in scratch rein
    scratch.multnum_q(&faktor); // Multipliziere mit dezimalfaktor 1, 10, 100 etc
    scratch.setsize(true); //resizen
    if(scratch.size >= akku.length) akku.resizelonu(scratch.size + 8); //evtl akku resizen
    akku.addnum_q(&scratch); // scratch in den Akku rein
    akku.setsize();
    faktor.multnum_q(&zehn);  // Faktor für nächste Dezimalrunde hochsetzen
    cnt--;  // restliche Textlänge decr. (wieder ein char geschafft)
  } while(cnt>=0);//regel-aussprung bei count = 0
  copynum(&akku);

  return true;
}
/*********************************************/
bool longnumber::shrinktofit(unsigned char bufz)
{
  setsize();
  return resizelonu(size+bufz,0);
}
/*********************************************/
bool longnumber::writewxstring(wxString* outtext, char flag)
  //schreibt den Puffer in den String hinein
  //(ohne Kontrolle, sollte echter ascii-Text sein, sonst Salat!
{
    setsize();
    shrinktofit();
    outtext->Clear();
    if(flag==1) throwout(wxString::FromAscii((char *)ad));
    *outtext+= wxString::FromAscii((char *)ad); //erste Alternative
    //outtext->FromUTF8((char *)ad,size); // 2. Alternative
    return true;
}
/*********************************************/
bool longnumber::writebin(wxString* text)
  //füllt mit dem konvertierten binärstring
{
  ulong32 highest1,indx;
  wxString hlptxt;

  setsize(true);
  if(size==0) {*text=_("0");return true;}
  if((9*size)>32767){throwout(_("number too large\nfor wxString")); return FALSE;}
  text->Empty();

  highest1= ( size<<3);  //höchstes einserbit finden
  do
  {
    highest1--;
  } while( !getbit(highest1));

  for(indx=highest1+1;indx>0;indx--)
  {
    if(getbit(indx-1))
        *text = *text + _("1");
     else
        *text = *text + _("0");
    if((((indx-1)>>3)<<3) == (indx-1))
        *text = *text + _(" ");
  }
  return true;
}
/*********************************************/
bool longnumber::writehex(wxString* text, bool highbyteleft)
  //schreibt in den String Text hinein
{
  longnumber remain,sixteen,akku;
  unsigned char c,hi,lo;
  unsigned int i,j;
  wxString hlptxt;

  setsize(true);
  if(size==0) {*text=_("0");return TRUE;}
  if(size*2>32767){throwout(_("number too large\nfor wxString")); return FALSE;}
  shrinktofit();
  text->Empty();//makes string empty, but doesn't free memory

  for(j=0;j<size;j++)
  {
    if(highbyteleft)
    {
        i=size-j-1;
    }
    else i=j;
    hi=*(ad+size-1-i);
    lo=hi&15;
    hi>>=4;
    //hihex first
    if(hi<10) c= hi +48;
    else c= hi +87;
    *text += c;
    //lohex then
    if(lo<10) c= lo +48;
    else c= lo +87;
    *text += c;
  }
  return true;
}
/*********************************************//*********************************************/
bool longnumber::writechar(wxString* text)
  //schreibt in den String Text hinein
{
  longnumber remain,zehn,akku;
  char c;
  ulong32 h1, oldsize;
  wxString hlptxt;

  oldsize=setsize();
  if(size==0) {*text=_("0");return true;}
  if(size* 2.40824 >32767){throwout(_("number too large\nfor wxString")); return false;}
  shrinktofit();
  text->Empty();//makes string empty, but doesn't free memory

  akku.copynum(this);//kopiert dies longnum nach akku
  zehn.storlong(10);  //schreibt 10 nach longnumber zehn

  do
  {
    akku.divnum_qqq_e(&zehn,&remain);
    h1=remain.lconvert();
    c= (char)(h1 & 255) +48;
    //hlptxt = _(c);
    //*text = hlptxt + *text;
    *text += c;
    akku.setsize();
  }while (akku.size > 0);
  // reverse String
  reverse_wxstring(text);
  return true;
}
/*********************************************/
bool longnumber::fillwith(char* wellad, long32 nobytes)
  //füllt mit inhalt eines anderen Buffers
{
  long32 i;

  trusiz=false; //aendert Zahleninhalt
  if(!resizelonu(nobytes,0)) return false;
  memmove(ad,wellad,nobytes);
  setsize(true);
  return true;
}
/*********************************************/
bool longnumber::storlong(ulong32 food)
                 //füllt mit ulong32
{
  int i;
  ulong32 ind;
  ldiv_t x;

  wipezero();
/*  res=resizelonu(5,0);
         if(!res)
         { throwout(_("ERROR")); return FALSE;}
*/
  if(length <6) resizelonu(6);
  for(i=0;i<4;i++)
  {
    x=ldiv(food,256);
    *(ad+i)= (unsigned char)x.rem;
    food = x.quot;
  }
  ind=4;
  while(ind<length)  //rest nullen
  { *(ad+ind)=0; ind++;}
  trusiz=false; //aendert Zahleninhalt
  setsize();
  return true;
}
/*********************************************/
bool longnumber::mirrornum(longnumber* quelle)
{
  //ulong32 ind1;

  if(!resizelonu(quelle->length,0)) // ziel(this) im Format anpassen
    {
        //throwout(_("memerr in copy"));
        return false;
    }
  memcpy(ad,quelle->ad,length);
  size=quelle->size;
  trusiz=quelle->trusiz; hibit=quelle->hibit;
  if((quelle->israre))
  {
      israre=true;
      asum=(unsigned char*)malloc( (*(quelle->asum))*2+1);
      memcpy(asum,(quelle->asum), (*(quelle->asum))*2+1 );
      asub=(unsigned char*)malloc( (*(quelle->asub))*2+1);
      memcpy(asub,(quelle->asub), (*(quelle->asub))*2+1 );
  }
  else israre=false;
  return true;
}
/*********************************************/
/*********************************************/
bool longnumber::copynum(longnumber* quelle, bool ir)
{
    ulong32 ind1;

   if(!quelle->trusiz)
    {
        quelle->setsize();
    }
    //check for matching size
   if((quelle->length > length)||(quelle->length +8 < length)||(!quelle->trusiz))
   {
       if(!resizelonu(quelle->length,0)) // ziel(this) im Format anpassen
        {
            return false;
        }
   }
  memcpy(ad,quelle->ad,quelle->size);
  memset(ad+(quelle->size),0,length-(quelle->size));
  size=quelle->size;
  trusiz=quelle->trusiz; hibit=quelle->hibit;
  if((quelle->israre)&&(ir))
  {
      israre=true;
      asum=(unsigned char*)malloc( (*(quelle->asum))*2+1);
      memcpy(asum,(quelle->asum), (*(quelle->asum))*2+1 );
      asub=(unsigned char*)malloc( (*(quelle->asub))*2+1);
      memcpy(asub,(quelle->asub), (*(quelle->asub))*2+1 );
  }
  else israre=false;
  return true;
}
/*********************************************/
int longnumber::compare(longnumber* ar)  //vergl.größe, 1: diese größer, 0:gleich, -1:ar größer
{
  long ind;

  if(!trusiz) setsize();
  if(!ar->trusiz) ar->setsize();
  if(size > ar->size) return 1; //auch fuer ueberlange Zahlen korrekt
  if(size< ar->size) return -1;
  if(hibit > ar->hibit) return 1;
  if(hibit< ar->hibit) return -1;
  //sizes müssen gleich sein !
  if(size==0) return 0;
  //size mind 1!
  for(ind=size-1;ind>=0;ind--)
  {
    if(*(ad+ind) > *(ar->ad +ind)) return 1;
    if(*(ad+ind) < *(ar->ad +ind)) return -1;
  }
  return 0;
}
/*********************************************/
bool longnumber::incrpos(ulong32 bytepos)
//incrementiert an Positionbytepos
//FALSE, wenns overflow wuerde
{
  #ifdef DEBUG_LONU
  setsize();
  if(length==0)
  {
      throwout(_("error\ncanot increment zero length number"),1);
      return false;
  }
  if(bytepos+1>=length) resizelonu(bytepos+2);
  #endif
  do
  {
    if( *(ad+bytepos) < 255 )
    {
      (*(ad+bytepos)) ++;
      if(trusiz)
      {
          if((bytepos+1>= size)||(size==0)) trusiz=false;
      }
      return true;
    }
    else
    {
      *(ad+bytepos) = 0;
      bytepos++;
    }
  } while(bytepos<length);
  throwout(_("increment ERROR"));
  trusiz=false;
  return false;
}
/*********************************************/
bool longnumber::decrpos(ulong32 bytepos)
//decrementiert an Positionbytepos
//FALSE, wenns negativ wuerde
{
    #ifdef DEBUG_LONU
  setsize();
  if(size==0)
      return false;
  if(size<bytepos+1)
        return false;
  #endif
  do
  {
    if( *(ad+bytepos) >0 )
    {
      *(ad+bytepos) -= 1; //wen res != 0 or bytepos != size-1 size stays
      if(bytepos+1== size) trusiz=false;
      return true;
    }
    else
    {
      *(ad+bytepos) = (unsigned char) 255;
      bytepos++;
    }
  } while(bytepos<length);
  throwout(_("decrementERROR"));
  return false;
}
/*********************************************/

bool longnumber::inc()
{
  return incrpos(0);
}
/*********************************************/
bool longnumber::dec()
{
  return decrpos(0);
}
/********************************************* new  */
bool longnumber::pushbyte(ulong32 plpos, unsigned char plval)
//without range control
{
    unsigned short *pint,tmpsh;
    unsigned char c,d;

    #ifdef DEBUG_LONU
    setsize();
    if(((plpos+2>length)&&(plpos<length))||(length<2))
    {
        resizelonu(plpos+2);
    }
    #endif
    pint=(unsigned short*) (ad+plpos); //die jetzige stelle im short format
    tmpsh=*pint;
    c=(unsigned char) tmpsh;
    tmpsh+=plval;
    d=(unsigned char) tmpsh;
    if(d>=c) //no carry whatsoever
    {
        *(ad+plpos)=d;
        if((plpos+1>=size)||(size<1)) trusiz=false;
        return true;
    }
    if( tmpsh>>8 != 0) //nur lokales carry
    {
        *pint += (unsigned short)plval;
        if((plpos+2 >=size)) trusiz=false;
        return true;
    }
    else //ausgreifendes carry (lokales carry + ff eins höher) selten!!
    {
        *pint =tmpsh;
        //carry durchreichen
        if((plpos+3 >=size)) trusiz=false;
        return(incrpos(plpos+2));
    }
}
/*********************************************/
/*****************  old  ****************************
bool longnumber::pushbyte(ulong32 plpos, unsigned char plval)
//without range control
{
    unsigned short *pint,tmpsh;
    unsigned char c,d;

    #ifdef DEBUG_LONU
    setsize();
    if(((plpos>length-2)&&(plpos<length))||(length<2))
    {
        resizelonu(plpos+2);
    }
    #endif
    pint=(unsigned short*) (ad+plpos); //die jetzige stelle im short format
    tmpsh=*pint;
    c=(unsigned char) tmpsh;
    tmpsh+=plval;
    d=(unsigned char) tmpsh;
    if(d>=c) //no carry whatsoever
    {
        *(ad+plpos)=d;
        if((plpos==size-1)||(size<1)) trusiz=false;
        return true;
    }
    if( tmpsh>>8 != 0) //nur lokales carry
    {
        *pint += (unsigned short)plval;
        if((plpos>=size-2)||(size<2)) trusiz=false;
        return true;
    }
    else //ausgreifendes carry (lokales carry + ff eins höher) selten!!
    {
        *pint =tmpsh;
        //carry durchreichen
        if((plpos>=size-3)||(size<3)) trusiz=false;
        return(incrpos(plpos+2));
    }
}
*********************************************/


/*********************************************/
bool longnumber::pushlong(ulong32 plpos, ulong32 plval)
//without range control
{
    ulong32 *plng,t,to;
    unsigned short c,d;

    #ifdef DEBUG_LONU
    setsize();
    if((plpos+4>=length))
    {
        if(plpos+2> length)
        {
            //throwout(_("warning, must extend receiving number"),1);
        }
        resizelonu(plpos+5);
    }
    #endif
    to=*((ulong32*) (ad+plpos));
    t =to+(ulong32)plval;
    //check for carry
    if(t >= to)  //kein übergreifendes carry
    {
        *((ulong32*) (ad+plpos)) = t;
        if(plpos+3<size) return true;  //simplest most frequent case
        else //may have touched hibyte
        {
            if( t>>16 == to>>16) //no two highest bytes unchanged
            {
                if(plpos+2> size) trusiz=false;
                return true;
            }
            else  //may have touched higher two bytes
            {
                if(t>>24 == to>>24) //byte 3 only touched
                {
                    if(plpos+3 >size) trusiz=false;
                    return true;
                }
                else   //upper byte touched
                {
                    if(plpos+4 > size) trusiz=false;
                    return true;
                }

            }
        }
    }
    else   // übergreifendes carry
    {
        *((ulong32*) (ad+plpos)) = t;
        return(incrpos(plpos+4)); //size bookkeeping taken care of by incrpos
    }
}
/*********************************************/
bool longnumber::pushshort(ulong32 plpos, unsigned short plval)
//without range control
{
    ulong32 *plng,t,to;
    unsigned short c,d;

    #ifdef DEBUG_LONU
    setsize();
    if(plpos+3 >=length)
    {
        if(plpos+2> length) throwout(_("warning, must extend receiving number"),2);
        resizelonu(plpos+5);
    }
    #endif
    to=*((ulong32*) (ad+plpos));
    t =to+(ulong32)plval;
    //check for carry
    if(t >= to)  //kein übergreifendes carry
    {
        *((ulong32*) (ad+plpos)) = t;
        if(plpos+3 < size) return true;  //simplest most frequent case, hibyte not touched
        else //may have touched hibyte
        {
            if( t>>16 == to>>16) //no carry even within
            {
                if((plpos+2> size)) trusiz=false;
                return true;
            }
            else  //may have touched higher two bytes
            {
                if(t>>24 == to>>24) //byte 3 only touched
                {
                    if((plpos+3> size)) trusiz=false;
                    return true;
                }
                else   //upper byte touched
                {
                    if((plpos+4> size)) trusiz=false;
                    return true;
                }

            }
        }
    }
    else   //selten: übergreifendes carry
    {
        *((ulong32*) (ad+plpos)) = t;
        return(incrpos(plpos+4)); //size bookkeeping taken care of by incrpos
    }
}
/*********************************************/
/************************************ stillegen, andere marginal schneller! *********
bool longnumber::pluckbyte(ulong32 plpos, unsigned char plval)
//without range control
{
    unsigned char ov,d;

    if(plval==0) return true;
    //trusiz=false;
    #ifdef DEBUG_LONU
    setsize();
    if((plpos>length-2)&&(plpos<length))
    {
        resizelonu(length+2);
    }
    else
    {
        if(plpos>=size)
        {
            throwout(_("error in pluckbyte"),3);
            return false;
        }
    }
    #endif
	if(plpos==size-1) trusiz=false;
    ov=*(ad+plpos);
    d= ov -plval;
    *(ad+plpos)=d;
    if(d>ov)
    {
       return(decrpos(plpos+1));
    }
    else return true;
} **/
/*********************************************  is ok  **/
bool longnumber::pluckbyte(ulong32 plpos, unsigned char plval)
{
    unsigned short *pint;

    if(plval==0) return true;
    //trusiz=false;
    #ifdef DEBUG_LONU
    setsize();
    if((plpos+2>length)&&(plpos<length))
    {
        resizelonu(length+2);
    }
    else
    {
        if(plpos>=size)
        {
            throwout(_("error in pluckbyte"),3);
            return false;
        }
    }
    #endif
    pint=(unsigned short*) (ad+plpos);
    if( *(ad+plpos+1) > 0)
    {
        *pint -= (unsigned int)plval;
        return true;
    }
    else
    {
       if( *(ad+plpos)>=plval )
       {
           *(ad+plpos) -= plval;
           return true;
       }
       else
       {
           *(ad+plpos) -= plval;
           return(decrpos(plpos+1));
       }
    }
}
/*********************************************/
bool longnumber::plucklong(ulong32 plpos, ulong32 plval)
{
    ulong32 *plng,tmp,tmp2;
    bool res;

    if(plval==0) return true;
    //trusiz=false;
    #ifdef DEBUG_LONU
    setsize();
    if((plpos+4>length)&&(plpos<length))
    {
        resizelonu(length+4);
    }
        if((plpos >=size) || ((plpos+3>=size)&&((plval&0xff000000)>0))||((plpos+2>=size)&&((plval&0xffff0000)>0))
            ||((plpos+1>=size)&&((plval&0xffffff00)>0)))
        {
            throwout(_("error in plucklong"),3);
            return false;
        }
    #endif
    plng=(ulong32*) (ad+plpos);
    tmp=*plng;
    tmp2=tmp;
    tmp -= plval;
    *plng=tmp;
     if(tmp>tmp2)  // carry occured
        {
            res= decrpos(plpos+4);
            if(!res)
            {
                throwout(_("decrpos failed!"));
            }
            return res;
        }
    else //no carry
        {
            if(plpos+4>size) trusiz=false; //hibyte was touched
            return true;
        }
    return false; //never get here
}
/******************************************* **/
bool longnumber::pluckshort(ulong32 plpos, unsigned short plval)
{
    ulong32 *plng;

    if(plval==0) return true;
    //trusiz=false;
    #ifdef DEBUG_LONU
    setsize();
    if((plpos+4>length)&&(plpos<length))
    {
        resizelonu(length+4);
    }
        if(plpos+1>size)
        {
            throwout(_("error in pluckshort"),3);
            return false;
        }
    #endif
    plng=(ulong32*) (ad+plpos);
    if( *((unsigned short*)(ad+plpos+2)) > 0)  //carry could be accomodated
    {
        *plng -= (ulong32)plval;
        if(plpos+3>=size) trusiz=false;
        return true;
    }
    else  //carry could not be accomodated
    {
       if( *((unsigned short*)(ad+plpos))>=plval )  //no carry
       {
           *((unsigned short*)(ad+plpos)) -= plval;
           if(plpos+3>=size) trusiz=false;
           return true;
       }
       else //carry will occur and next higher short is zero
       {
           *((unsigned short*)(ad+plpos)) -= plval;
           *((unsigned short*)(ad+plpos+2)) =0xffff;
           return(decrpos(plpos+4));
       }
    }
}
/*********************************************/
/*********************************************/
bool longnumber::subtrnum(longnumber* subtrh, longnumber* modul)
  //Differenz, needs subtrh < lonum, False sonst
{
  int flag,carry;
  unsigned char h1,h2;
  long ind;
  longnumber sbt;

  lonumodulo(modul);
  sbt.copynum(subtrh);
  sbt.lonumodulo(modul);//module herausziehen
  flag=compare(&sbt);
  switch(flag)
  {
    case 0:
      for(ind=size-1;ind>=0;ind--)
        *(ad+ind)=0;
        trusiz=false;
      return true;
    case -1:
        addnum(modul);
      //fall through to next case !
    case 1:
      trusiz=false;
      for(ind=(sbt.size -1);ind>=0;ind--)
      {
        h1= *(ad+ind);
        h2= *(sbt.ad + ind);
        if(h1>=h2)
        {
          *(ad+ind)=h1-h2;
        }
        else
        {
          carry= 256 + h1 -h2;
          *(ad+ind)= (unsigned char) carry&255;
          if(!decrpos(ind+1))
           {throwout(_("ERROR c")); return false;}
        }
      }
      return true;
    default:
      throwout(_("ERROR d"));
      return false;
  }
}
/*********************************************/
bool longnumber::subtrnum_q(longnumber* subtrh, longnumber* modul)
//geht immer, evtl modulergaenzung
//Vorsicht, nicht bei bereinigungsrechnungen wie lonumodulo verwenden!
{
    int compres,c2,x;
    longnumber xsb(4 + modul->size);

    compres=compare(subtrh);
    switch(compres)
    {
      case 1:
        subtrnum_q(subtrh);
        x=lonumodulo_qqq_e(modul);//zur Info
        return true;
      case 0:
        wipezero();
        return true;
      case -1:
        xsb.copynum(subtrh);
        x=lonumodulo_qqq_e(modul);
        x=xsb.lonumodulo_qqq_e(modul);
        c2=compare(&xsb);
        if(c2==1)
        {
           subtrnum_q(&xsb);
           return true;
        }
        else if(c2 == -1)
            {
              addnum_q(modul);
              subtrnum_q(&xsb);
              return true;
            }
            else if(c2==0)
               {
                   wipezero();
                   return true;
               }
        return false;
      default:
        return false;
    }
}
/*********************************************/
bool longnumber::subtrnum_qx(longnumber* subtrh, long32 lowestone)
  //Differenz, needs subtrh < lonum, False sonst
{
  ulong32 ind,stinx,subinx,lowestbyte;

  int flag;//,carry=0;
  ulong32 *h1,*h2;//,tmp=0xffffffff; // ist ff ff ff ff

  flag=compare(subtrh);
  if(flag==-1) {
      throwout(_("wrong call on subtrnum")); return false;}
  if(flag ==0) {wipezero(); return true;}
  //else -> calculate
  //laengen durch 4 teilbar machen
  setsize(); subtrh->setsize();
  stinx=    ((size>>2)+1)<<2;  //durch 4 +1 mal4
  subinx=   ((subtrh->size >> 2 )+1) << 2;  //ditto
  if(length< stinx+1 ) resizelonu(stinx+1);
  if(subtrh->length< subinx+1 ) subtrh->resizelonu(subinx+1);
  if(lowestone==-1) //lowestone setzen
  {
    for(lowestbyte=0;lowestbyte<subtrh->size;lowestbyte++)
    {
        if(*(ad+lowestbyte) >0) break;
    }
    if(lowestbyte>0) lowestbyte--;
  }
  else  lowestbyte= lowestone>>3;
  for(ind=subinx-4;ind>=0; ind -=4) //von oben runter subtrahieren in vierergruppen
  {
     if(ind+3 < lowestbyte) // nur noch nullen im subtrahend -> fertig!
     { break;}
    // in die ulong32 variablen einsetzen
     h2=(ulong32 *)(subtrh->ad +ind);// wenn das null ist, ganze Schleife kippen
     h1=(ulong32 *)(ad+ind);
     if(*h1 >= *h2)  //einfacher Fall
              *h1 -= *h2;
     else //falsche groessen -> extrabehandlung mit carry
     {
       *h1= *h2 -*h1;
       *h1 ^= 0xffffffff;  //invertieren
       (*h1)++;
      if(!punchcarry( (ulong32*)(ad+ind+4), length-ind))
      {
            throwout(_("Alert!! \n error in punchcarry \n should never see this error!"));
            return false;
      }
     }
     if(ind==0) break;  //ind ist unsigned und deshalb immer >=0 !!
   }
   trusiz=false;
return true;
}
/*********************************************/
bool longnumber::subtrnum_q_b(longnumber* subtrh,ulong32 boffs, bool sizing)
  //Differenz, needs subtrh < lonum, False sonst
{
  ulong32 indx,i,i2,offs;
  unsigned char c;

  ulong32 *h1,*h2,carry=0,a1,hv2,hl=0;;
  unsigned short *s1,*s2,a2,hs2,hls;
  unsigned char boff;
  int flag;

      #ifdef DEBUG_LONU
  flag=compare(subtrh);
  if(flag==-1) {
      throwout(_("wrong call on subtrnum")); return false;}
  if(flag ==0) {wipezero(); return true;}
     #endif
  //else -> calculate
  offs=boffs>>3; //divided by 8
  boff=(unsigned char)(boffs&7);
  if(subtrh->size==0) return true; //subtract zero
  if(subtrh->israre) return(subtrnum_rare_b(subtrh,boffs));
  if(boff==0) return( subtrnum_q(subtrh,(unsigned int)offs,sizing) );
  if(sizing)
  {
    if(!trusiz) setsize();
    if(!subtrh->trusiz) subtrh->setsize();
  }
  if(subtrh->size == 0) return true;
  indx=offs;
  if(subtrh->size>4)
  {
   for(indx=offs;indx+4<subtrh->size+offs;indx+=4)
   {
      h1=(ulong32 *)(ad+indx);
      h2=(ulong32 *)(subtrh->ad +indx-offs);// wenn das null ist, ganze Schleife kippen
      hv2=*h2<<boff;
      hv2+=hl;
      hl=*h2>>(32-boff);
      if(carry)
      {
          a1 = *h1-(hv2 + 1);
          if(a1>=*h1) carry=1;
          else carry=0;
          *h1=a1;
      }
      else
      {
         if(hv2==0) continue;
         a1= *h1-hv2;
         if(a1>*h1) carry=1;
         else carry =0;
         *h1=a1;
      }
   }
  }
  hls=(unsigned short)hl;
  for(;indx<subtrh->size+offs;indx+=2) //rest aufräumen, indx stays
  {
      s1=(unsigned short *)(ad+indx);
      s2=(unsigned short *)(subtrh->ad +indx-offs);// wenn das null ist, ganze Schleife kippen

      hs2 = *s2 << boff;
      hs2+= hls;
      hls= *s2 >> (16-boff);
      if(carry)
      {
          a2 = *s1-(hs2 + 1);
          if(a2>=*s1) carry=1;
          else carry=0;
          *s1=a2;
      }
      else
      {
         if(hs2==0) continue;
         a2= *s1-hs2;
         if(a2>*s1) carry=1;
         else carry =0;
         *s1=a2;
      }
  }
  //jetzt ist noch ein hls über
  if(hls>0)
  {
    if(!pluckbyte(indx,(unsigned char) hls))
    {
      throwout(_("Error 5 in subtrnum_q_b"),3);
    }
  }
  if((carry==0)&&(indx+1>=size)) //trusiz destroyed
  {
      //get size
      for(i=size-1;i>0;i--)
      {
          if( *(ad+i) != 0)
          {
              c=*(ad+i);
              size=i+1;
              i2= (i<<3) -1;
              do
              {
                  c >>= 1;
                  i2++;
              } while(c!=0);
              //determined hibit
              hibit=i2;
              #ifdef DEBUG_LONU
              //debug
              setsize(true);
              if(i2!= hibit)
              {
                  a1=size;
                  throwout(_("error in fly-setsize"));
              }
              //end debug
              #endif
              return true;
          }
      }

  }

  if(carry)
  {
      if(!decrpos(indx))
      {
        throwout(_("error in subtrnum_q_b"));
         trusiz=false;
         return false;
      }
  }
  trusiz=false;
  return true;
 }
 /*********************************************/
bool longnumber::subtrnum_q(longnumber* subtrh,ulong32 offs, bool sizing)
  //Differenz, needs subtrh < lonum, False sonst
{
  ulong32 indx,i;
  long32 i2;
  unsigned char c;

  ulong32 *h1,*h2,carry=0,a1;
  unsigned short *s1,*s2,a2;
  int flag;

      #ifdef DEBUG_LONU
  flag=compare(subtrh);
  if(flag==-1) {
      throwout(_("wrong call on subtrnum_b")); return false;}
  if(flag ==0) {wipezero(); return true;}
     #endif
  //else -> calculate

  if(subtrh->israre) return(subtrnum_rare(subtrh,offs));
  if(subtrh->size==0) return true;
  if(sizing)
  {
    if(!trusiz) setsize();
    if(!subtrh->trusiz) subtrh->setsize();
  }
  if(subtrh->size == 0) return true;
  indx=offs;
  if(subtrh->size>4)
  {
   for(indx=offs;indx<subtrh->size-4+offs;indx+=4)
   {
      h1=(ulong32 *)(ad+indx);
      h2=(ulong32 *)(subtrh->ad +indx-offs);// wenn das null ist, ganze Schleife kippen
      if(carry)
      {
          a1 = *h1-(*h2 + 1);
          if(a1>=*h1) carry=1;
          else carry=0;
          *h1=a1;
      }
      else
      {
         if(*h2==0) continue;
         a1= *h1-*h2;
         if(a1>*h1) carry=1;
         else carry =0;
         *h1=a1;
      }
   }
  }
  for(;indx<subtrh->size+offs;indx+=2) //rest aufräumen, indx stays
  {
      s1=(unsigned short *)(ad+indx);
      s2=(unsigned short *)(subtrh->ad +indx-offs);// wenn das null ist, ganze Schleife kippen
      if(carry)
      {
          a2 = *s1-(*s2 + 1);
          if(a2>=*s1) carry=1;
          else carry=0;
          *s1=a2;
      }
      else
      {
         if(*s2==0) continue;
         a2= *s1-*s2;
         if(a2>*s1) carry=1;
         else carry =0;
         *s1=a2;
      }
  }
  if((carry==0)&&(indx+1>=size)) //trusiz destroyed
  {
      //get size
      for(i=size-1;i>=0;i--)
      {
          if( *(ad+i) != 0)
          {
              c=*(ad+i);
              size=i+1; //bis hier ok

              i2= (long32)(i<<3)-1;
              while(c>0)
              {
                  c >>= 1;
                  i2++;
              }
              //determined hibit
              hibit=i2;
              #ifdef DEBUG_LONU
              //debug
              setsize(true);
              if(i2!= hibit)
              {
                  a1=size;
                  throwout(_("error in fly-setsize"));
              }
              //end debug
              #endif
              return true;
          }
      }

  }

  if(carry)
  {
      if(!decrpos(indx))
      {
        throwout(_("error in subtrnum_q"),1);
         trusiz=false;
         return false;
      }
  }
  trusiz=false;
  return true;
 }
/**********************************************************/

/*********************** stillgelegt **********************
bool longnumber::subtrnum_q(longnumber* subtrh)
  //Differenz, needs subtrh < lonum, False sonst
{
  ulong32 ind,stinx,subinx;

  int flag;//,carry=0;
  ulong32 *h1,*h2;

      #ifdef DEBUG_LONU
  flag=compare(subtrh);
  if(flag==-1) {
      throwout(_("wrong call on subtrnum")); return false;}
  if(flag ==0) {wipezero(); return true;}
     #endif
  //else -> calculate

  if(subtrh->israre) return(subtrnum_rare(subtrh));
  //laengen durch 4 teilbar machen
  setsize(); subtrh->setsize();
  stinx=    ((size>>2)+1)<<2;  //durch 4 +1 mal4
  subinx=   ((subtrh->size >> 2 )+1) << 2;  //ditto
  if(length< stinx+1 ) resizelonu(stinx+1);
  if(subtrh->length< subinx+1 ) subtrh->resizelonu(subinx+1);
  for(ind=subinx-4;ind>=0; ind -=4) //von oben runter subtrahieren in vierergruppen
  {
    // in die ulong32 variablen einsetzen
     h2=(ulong32 *)(subtrh->ad +ind);// wenn das null ist, ganze Schleife kippen
     h1=(ulong32 *)(ad+ind);
     if(*h1 >= *h2)  //einfacher Fall
              *h1 -= *h2;
     else //falsche groessen -> extrabehandlung mit carry
     {
       *h1= *h2 -*h1;
       *h1 ^= 0xffffffff;  //invertieren
       (*h1)++;
      if(!punchcarry( (ulong32*)(ad+ind+4), length-ind))
      {
            throwout(_("Alert!! \n error in punchcarry \n should never see this error!"));
            return false;
      }
     }
     if(ind==0) break;  //ind ist unsigned und deshalb immer >=0 !!
   }
   trusiz=false;
return true;
}
*********************************************/
bool longnumber::punchcarry(ulong32* start, ulong32 maxlen)
  // drueckt das Carrybit bei Subtraktion durch, falls unzureichende Laengen, return false
  //start ist der naechsthoehere viererblock
{
    ulong32 ind;
    ulong32 *p;

    ind=0;
    while(ind < maxlen)
    {
        p= start+ind;
        if(*p != 0)
        {
            (*p)--;
            return true;
        }
        else{
            *p=0xffffffff;
            ind ++;
        }
    }
    throwout(_("error in Punchthrough!"));
    return false;
}
/*********************************************/
bool longnumber::subtrnum(longnumber* subtrh)
  //Differenz, needs subtrh < lonum, False sonst
{
  int flag,carry;
  unsigned char h1,h2;
  long ind;

  flag=compare(subtrh);
  switch(flag)
  {
    case 0:
      for(ind=size-1;ind>=0;ind--)
                         *(ad+ind)=0;
        trusiz=false;
      return true;
    case -1:
      return false;
    case 1:
      if(subtrh->size==0) //subtract zero
      {
         return true;
      }
      for(ind=(subtrh->size -1);ind>=0;ind--)
      {
        h1= *(ad+ind);
        h2= *(subtrh->ad + ind);
        if(h1>=h2)
        {
          *(ad+ind)=h1-h2;
        }
        else
        {
          carry= 256 + h1 -h2;
          *(ad+ind)= (unsigned char) carry&255;
          if(!decrpos(ind+1))
           {throwout(_("ERROR c")); return FALSE;}
        }
      }
      trusiz=false;
      return true;
    default:
      throwout(_("ERROR d"));
      return false;
  }
}
/*********************************************/
int longnumber::addnum(longnumber* summand, longnumber* modul)
//Summe mit Modul
{
  unsigned int carry=0;
  unsigned char h1,h2;
  unsigned int h3=0;
  ulong32 indx;

  summand->setsize();
  setsize();
  lonumodulo(modul);
  summand->lonumodulo(modul);
  if(size == length)
    if(!resizelonu(length+2)) {throwout(_("resize-error 1 in addnum"));
                               return -1;}
  if(summand->size >= length)
     if(!resizelonu(summand->size + 2)) {throwout(_("resize-error 2in addnum"));
                               return -1;}
  for(indx=0;indx<summand->size;indx++)
  {
      h1=  *(ad+indx);
      h2=  *(summand->ad+indx);
      h3= (unsigned int)h1 + (unsigned int)h2;
      carry += h3;
      *(ad + indx)= (unsigned char) carry;
      carry /= 256;
  }
  while ((carry >0)&&(indx<length))
  {
    h1=  *(ad+indx);
    carry += (unsigned int) h1;
    *(ad + indx)= (unsigned char) carry;
    carry /= 256;indx++;
  }
  if(carry >0) throwout(_("overflow in add\n care for carry!"));
  trusiz=false;
  lonumodulo(modul);
  return (int) carry;
}
/*********************************************
int longnumber::addnum_qq(longnumber* summand, int ckflag)
//Summe mit Modul
{
  char carry= 0;
  ulong32 h1;
  ulong32 indx,steps;
  char cr;
  unsigned char h2;
  bool rarcar;

  if(ckflag==1)
  {
    summand->setsize();
    setsize();
    cr= compare(summand);
  }
  else cr=1;

  if(cr >= 0) // wenn this groesser als summand
  {
    if(size > length-4)
      if(!resizelonu(size+4)) {throwout(_("resize-error 1 in addnum"));
                               return -1;}
  //determine # of 4byte addsteps
    steps=summand->size / 4;

    for(indx=0;indx<steps;indx++)  //4byte operationen machen
    {
      rarcar=false;
      h1=  *((ulong32*) (ad+ 4*indx))+ carry;
      if((carry==1)&&(h1==0)) rarcar=true;
      h1 += *((ulong32*) (summand->ad+4*indx));
      if((h1 < *((ulong32 *) (ad+ 4*indx)))||rarcar) carry= 1;
      else carry = 0;
      *((ulong32 *) (ad+ 4*indx)) = h1;
    }
    for( indx=4*steps;indx<summand->size;indx++) //restliche einzelbyte-operationen
    {
      rarcar=false;
      h2=   *(ad+ indx)+ carry;
      if((carry==1)&&(h2==0)) rarcar=true;
      h2 +=  *(summand->ad+indx);
      if((h2 < (carry + *(ad+ indx)))||rarcar) carry= 1;
      else carry = 0;
      *(ad+ indx) = h2;
    }
    while ((carry >0)&&(indx<length)) //carry noch abraeumen
    {
      h2=  *(ad+indx) + carry;
      if(h2 < ( *(ad+indx))) carry = 1;
      else carry=0;
      *(ad+indx)=h2;
      if(carry==0) break; // carrykette abgeschlossen
      indx++; //carrykette laeuft weiter
    }
    if(carry >0) throwout(_("overflow in add\n care for carry!"));
    trusiz=false;
    return (int) carry;
  }

  else // wenn this kleiner gleich  summand
  {
    //swapnum(summand);
    longnumber newnum;
    newnum.copynum(summand);
    carry=newnum.addnum_q(this,0);
    copynum(&newnum);
    return (int) carry;
  }
}
*********************************************/
int longnumber::addnum_om(longnumber* summand, ulong32 bytoff, unsigned short mfac, int ckflag)
//Summe mit Modul
{
  //char carry= 0;
  ulong32 h1,h1o,hb,req;
  ulong32 indx,ind4,inp4,steps;
  unsigned char h2;
  unsigned short usho;
  unsigned long long v;
  bool cy=false;

  //if(summand->israre) return(addnum_rare(summand)); //works also for larger summand

  if(ckflag==1)
  {
    summand->setsize();
    setsize();
    req=summand->size;
    req+=bytoff;
    if(mfac>1) req+=2;
    if(req+4>length)
    {
        if(!resizelonu(req+4)) {throwout(_("resize-error 1 in addnum_om"));
                               return -1;}
    }
  }

  //determine # of 4byte addsteps
    steps=summand->size >>2;

    for(indx=0;indx<steps;indx++)  //4byte operationen machen
    {
      {
                ind4=indx<<2;
                inp4=(indx+1)<<2;
          //to do change * 4 by <<2
                h1o=  *((ulong32*) (ad+bytoff+ ind4));
                hb= *((ulong32*) (summand->ad+ind4));
                v=((unsigned long long) hb) * mfac; //jetzt 6 byte lang
                usho=(unsigned short)(v>>32);
                h1= (ulong32) v + h1o;
                *((ulong32*) (ad+ bytoff + ind4))=h1;
                if(h1<h1o) cy=true;
                else cy=false;
                if(cy)
                {
                    usho++;
                    if(usho==0)
                    {
                        if(!incrpos(bytoff + inp4+2)){throwout(_("error1 in addnum_om"),1); return (-1);}
                    }
                    else
                    {
                        if(!pushshort(bytoff + inp4,usho)) {throwout(_("error2 in addnum_om")); return(-1);}
                    }
                }
                else
                {
                    if(!pushshort(bytoff + inp4,usho)) {throwout(_("error3 in addnum_om")); return(-1);}
                }
      }
    }
    for( indx=steps<<2;indx<summand->size;indx++) //restliche einzelbyte-operationen
    {
            h2 =  *(summand->ad+indx);
            hb=((ulong32) h2) * mfac; //jetzt 3 byte groß
            if(!pushlong((bytoff + indx),hb)) {throwout(_("error2 in addnum_om")); return(-1);}
    }
    if(summand->size + bytoff+3>=size)
       trusiz=false;
    return 0;
}
/***************************************************************************/
/*********************************************/
int longnumber::addnum_om_bit(longnumber* summand, ulong32 bitoff, unsigned short mfac, int ckflag)
//Summe mit Modul
{
  //char carry= 0;
  ulong32 h1,h1o,hb,req,bytoff;
  ulong32 indx,ind4,inp4,steps;
  unsigned char h2,boffs;
  ulong32 ulo;
  unsigned long long v;
  bool cy=false;

  //if(summand->israre) return(addnum_rare(summand)); //works also for larger summand

  if(ckflag==1)
  {
    summand->setsize();
    setsize();
    req=summand->size;
    req+=bitoff>>3;
    if(mfac>1) req+=2;
    if(req+4>length)
    {
        if(!resizelonu(req+4)) {throwout(_("resize-error 1 in addnum_om"));
                               return -1;}
    }
  }
    bytoff=bitoff>>3;
    boffs=(unsigned char)(bitoff&7);
  //determine # of 4byte addsteps
    steps=summand->size >>2;

    for(indx=0;indx<steps;indx++)  //4byte operationen machen
    {
      {
                ind4=indx<<2;
                inp4=(indx+1)<<2;
          //to do change * 4 by <<2
                h1o=  *((ulong32*) (ad+bytoff+ ind4));
                hb= *((ulong32*) (summand->ad+ind4));
                v=((unsigned long long) hb) * mfac; //jetzt 6 byte lang
                v <<= boffs; //jetzt bitoffset berücksichtigt, v max 7 bit lang
                ulo=(ulong32)(v>>32); //upper short
                h1= (ulong32) v + h1o;
                *((ulong32*) (ad+ bytoff + ind4))=h1;
                if(h1<h1o) cy=true;
                else cy=false;
                if(cy)
                {
                   /* ulo++;
                    if(ulo==0)
                    {
                        if(!incrpos(bytoff + inp4+2)){throwout(_("error1 in addnum_om"),1); return (-1);}
                    }
                    else*/
                    {
                        if(!pushlong(bytoff + inp4,ulo)) {throwout(_("error2 in addnum_om_bit")); return(-1);}
                    }
                }
                else
                {
                    if(!pushlong(bytoff + inp4,ulo)) {throwout(_("error3 in addnum_om_bit")); return(-1);}
                }
      }
    }
    for( indx=steps<<2;indx<summand->size;indx++) //restliche einzelbyte-operationen
    {
            h2 =  *(summand->ad+indx);
            hb=((ulong32) h2) * mfac; //jetzt 3 byte groß
            hb <<= boffs;  //max vier byte gross, kleiner als ffffffff
            if(!pushlong((bytoff + indx),hb)) {throwout(_("error2 in addnum_om")); return(-1);}
    }
    if(summand->size + bytoff+3>=size)
       trusiz=false;
    return 0;
}
/***************************************************************************/
bool longnumber::subtrnum_om_bit(longnumber* subtrh, ulong32 bitoff, unsigned short mfac, int ckflag)
//Summe mit Modul
{
  //char carry= 0;
  ulong32 h1,h1o,hb,req,bytoff;
  ulong32 indx,in4,inp4,steps;
  unsigned char h2,boffs;
  ulong32 ulo;
  unsigned long long v;
  long crs=0;
  bool cy=false;
  int i;

  if(subtrh->israre) return(subtrnum_om_bit_rare(subtrh, bitoff, mfac, ckflag));

  if(mfac==0) return true;;
  if(ckflag==1)
  {
    subtrh->setsize();
    setsize();
    //crs=compare(subtrh);

    crs=hibit - (subtrh->hibit + (bitoff) );
    if (crs<0)
    {
        throwout(_("error in subtrnum_om"),1);
        return false;
    }
  }


  bytoff=bitoff>>3;
  boffs=(unsigned char) bitoff&7;
  //determine # of 4byte addsteps
    steps=subtrh->size >> 2;

    for(indx=0;indx<steps;indx++)  //4byte operationen machen
    {
      {
          //to do change * 4 by <<2
                in4=indx<<2;
                h1o=  *((ulong32*) (ad+bytoff+ in4));
                hb= *((ulong32*) (subtrh->ad+ in4));
                v=((unsigned long long) hb) * mfac; //jetzt 6 byte lang
                v <<=boffs; //jetzt bis 9 byte

                ulo=(ulong32)(v>>32);
                h1= h1o - (ulong32) v;
                *((ulong32*) (ad+ bytoff + in4))=h1;
                if(h1<=h1o) cy=false;
                else cy=true;
                inp4=(indx+1)<<2;
                if(cy)
                {
                    ulo++;
                    if(ulo==0) //impossible
                    {
                        if(!decrpos(bytoff + inp4 +2))
                        {
                            throwout(_("error in subtrnum_om"),1);
                            return false;
                        }
                    }
                    else
                    {
                        if(!plucklong(bytoff + inp4,ulo))
                        {
                            throwout(_("error1 in subtrnum_om"));
                            return false;
                        }
                    }
                }
                else
                {
                    if(!plucklong(bytoff + inp4,ulo))
                    {
                        throwout(_("error2 in subtrnum_om"));
                        return false;
                    }
                }

      }
    }
    for( indx=4*steps;indx<subtrh->size;indx++) //restliche einzelbyte-operationen
    {
            h2 =  *(subtrh->ad+indx);
            hb=((ulong32) h2) * mfac; //jetzt 3 byte groß
            hb <<= boffs;
            if(!plucklong((bytoff + indx),hb)) {throwout(_("error3 in subtrnum_om")); return(-1);}
            //hb +=  *(ad+indx+bytoff); //passt auf jeden fall
            /*usho= (unsigned short) hb;
            if(!pushshort((bytoff + indx),usho)) {throwout(_("error2 in addnum_om")); return(-1);}
            h2=(unsigned char) (hb>>16);
            if(!pushbyte((bytoff + indx+2),h2)) {throwout(_("error3 in addnum_om")); return(-1);}*/
    }
    i=4;
    if(boffs>0) i++;
    if(subtrh->size + bytoff+i >=size)
                            trusiz=false;
    return 0;
}
/*********************************************/
/***************************************************************************/
bool longnumber::subtrnum_om_bit_rare(longnumber* subtrh, ulong32 bitoff, unsigned short mfac, int ckflag)
//Summe mit Modul
{
  //char carry= 0;
  ulong32 h1,h1o,hb,req,bytoff;
  ulong32 indx,steps;
  unsigned char h3,boffs;
  ulong32 ulo;
  unsigned long long v;
  long crs=0;
  bool cy=false;
  int i;
  unsigned short fetchno;

  if(!subtrh->israre) return(subtrnum_om_bit(subtrh,bitoff,mfac,ckflag)); //works also for larger summand

  if(mfac==0) return true;
  if(ckflag==1)
  {
    subtrh->setsize();
    setsize();

    crs=hibit - (subtrh->hibit + (bitoff));
    if (crs<0)
    {
        throwout(_("error in subtrnum_om"),1);
        return false;
    }
  }


  bytoff=bitoff>>3;
  boffs=(unsigned char) bitoff&7;

    for(i=0;i<(unsigned char)*(subtrh->asub);i++)
    {
        //beg test
       fetchno= *((unsigned short *)  (subtrh->asub+1+(i<<1))); //lobyte has offset, hibyte has value
       h1=(ulong32) (fetchno>>8); // get hibyte for value
       h3=(unsigned char) (fetchno&0xff); //get lobyte for offset
       //end test
       //aufbereiten
       //h1=(ulong32) (*(subtrh->asub+((i+1)<<1) ));
       h1 *= mfac;  //jetzt drei byte
       h1 <<= boffs; //jetzt vier byte
       if(! pushlong( bytoff+(ulong32)(h3),  h1))
          {
              throwout(_("error in subtr_om_bit rare2"));
              return false;
          }
    }
    for(i=0;i<*(subtrh->asum);i++)
    {
       fetchno= *((unsigned short *)  (subtrh->asum+1+(i<<1))); //lobyte has offse, hibyte has value
       h1=(ulong32) (fetchno>>8); // get hibyte for value
       h3=(unsigned char) (fetchno&0xff); //get lobyte for offset
        //aufbereiten
       //h1=(ulong32) (*(subtrh->asum+((i+1)<<1) ));
       h1 *= mfac;  //jetzt drei byte
       h1 <<= boffs; //jetzt vier byte
       if(! plucklong(bytoff + (ulong32)h3, h1))
          {
              throwout(_("error in subtr_om_bit_rare3"));
              return false;
          }
    }
    return true;
}
/*********************************************/

/*********************************************/
bool longnumber::subtrnum_om(longnumber* subtrh, ulong32 bytoff, unsigned short mfac, int ckflag)
//Summe mit Modul
{
  //char carry= 0;
  ulong32 h1,h1o,hb,req;
  ulong32 indx,steps;
  unsigned char h2;
  unsigned short usho;
  unsigned long long v;
  long crs=0;
  bool cy=false;

  //if(summand->israre) return(addnum_rare(summand)); //works also for larger summand

  if(mfac==0) return true;;
  if(ckflag==1)
  {
    subtrh->setsize();
    setsize();
    //crs=compare(subtrh);

    crs=hibit - (subtrh->hibit + (bytoff<<3) +16);
    if (crs<0)
    {
        throwout(_("error in subtrnum_om"),1);
        return false;
    }
  }



  //determine # of 4byte addsteps
    steps=subtrh->size / 4;

    for(indx=0;indx<steps;indx++)  //4byte operationen machen
    {
      {
          //to do change * 4 by <<2
                h1o=  *((ulong32*) (ad+bytoff+ 4*indx));
                hb= *((ulong32*) (subtrh->ad+4*indx));
                v=((unsigned long long) hb) * mfac; //jetzt 6 byte lang
                usho=(unsigned short)(v>>32);
                h1= h1o - (ulong32) v;
                *((ulong32*) (ad+ bytoff + 4*indx))=h1;
                if(h1<=h1o) cy=false;
                else cy=true;
                if(cy)
                {
                    usho++;
                    if(usho==0)
                    {
                        if(!decrpos(bytoff + ((indx +1)<<2)+2)){throwout(_("error in subtrnum_om"),1); return false;}
                    }
                    else
                    {
                        if(!pluckshort(bytoff + 4*(indx +1),usho)) {throwout(_("error1 in addnum_om")); return false;}
                    }
                }
                else
                {
                    if(!pluckshort(bytoff + 4*(indx +1),usho)) {throwout(_("error1 in addnum_om")); return false;}
                }

      }
    }
    for( indx=4*steps;indx<subtrh->size;indx++) //restliche einzelbyte-operationen
    {
            h2 =  *(subtrh->ad+indx);
            hb=((ulong32) h2) * mfac; //jetzt 3 byte groß
            if(!plucklong((bytoff + indx),hb)) {throwout(_("error2 in addnum_om")); return(-1);}
            //hb +=  *(ad+indx+bytoff); //passt auf jeden fall
            /*usho= (unsigned short) hb;
            if(!pushshort((bytoff + indx),usho)) {throwout(_("error2 in addnum_om")); return(-1);}
            h2=(unsigned char) (hb>>16);
            if(!pushbyte((bytoff + indx+2),h2)) {throwout(_("error3 in addnum_om")); return(-1);}*/
    }
    if(subtrh->size + bytoff+4 >=size)
       trusiz=false;
    return 0;
}
/*********************************************/
int longnumber::addnum_q(longnumber* summand, int ckflag)
//Summe mit Modul
{
  //char carry= 0;
  ulong32 h1,hb;
  ulong32 indx,steps,indx4;
  char cr;
  unsigned char h2;
  bool cy;
  int tmp;

  if(summand->israre) return(addnum_rare(summand)); //works also for larger summand

  if(ckflag==1)
  {
    if(!summand->trusiz) summand->setsize();
    if(!trusiz) setsize();
    cr= compare(summand);
  }
  else cr=1;

  if(cr >= 0) // wenn this groesser als summand
  {
    if(size+4 > length)
      if(!resizelonu(size+4)) {throwout(_("resize-error 1 in addnum"));
                               return -1;}
  //determine # of 4byte addsteps
    steps=summand->size >>2;
    cy=false;

    for(indx=0;indx<steps;indx++)  //4byte operationen machen
    {
      indx4=indx<<2;
      if(!cy)
      {
                h1=  *((ulong32*) (ad+ indx4));
                hb= *((ulong32*) (summand->ad+indx4));
                h1+=hb;
                *((ulong32*) (ad+ indx4))=h1;
                if(h1<hb) cy=true;
                else cy=false;
      }
      else
      {
                h1=  *((ulong32*) (ad+ indx4));
                hb= *((ulong32*) (summand->ad+indx4));
                h1+=hb;
                if(h1<hb)
                {
                    cy=true;
                    h1++;
                }
                else
                {
                    h1++;
                    if(h1==0) cy=true;
                    else cy=false;
                }
                *((ulong32*) (ad+ indx4))=h1;
      }
    }
    for( indx=steps<<2;indx<summand->size;indx++) //restliche einzelbyte-operationen
    {
        if(!cy)
        {
            h2=   *(ad+ indx);
            h2 +=  *(summand->ad+indx);
            if(h2<*(ad+ indx) )
            {
                cy=true;
            }
            else cy=false;
            *(ad+indx)=h2;
        }
        else
        {
            h2=   *(ad+ indx);
            h2 +=  *(summand->ad+indx);
            if(h2<*(ad+ indx) )
            {
                cy=true;
                h2++;
            }
            else
            {
                h2++;
                if(h2==0) cy=true;
                else cy=false;
            }
            *(ad+ indx)=h2;
        }
    }
    while (cy &&(indx<length)) //carry noch abraeumen
    {
      h2=  *(ad+indx);
      h2++;
      if(h2==0) cy=true;
      else cy=false;
      *(ad+indx)=h2;
      indx++;
    }
    if(cy) throwout(_("overflow in add\n care for carry!"));
    trusiz=false;
    if(cy) return -1;
    else return 0;
  }

  else // wenn this kleiner gleich  summand
  {
    longnumber newnum;
    newnum.copynum(summand);
    tmp=newnum.addnum_q(this,0);
    copynum(&newnum);
    return tmp;
  }
}
/*********************************************/
/*********************************************
int longnumber::addnum_q_b(longnumber* summand, ulong32 boffs, int ckflag)
//Summe mit Modul
{
  //char carry= 0;
  ulong32 h1,hb;
  ulong32 indx,steps;
  long cr;
  unsigned char h2;
  bool cy;
  int tmp;
  ulong32 offs;
  unsigned char boff;

  if(summand->israre) return(addnum_rare_b(summand,boffs)); //works also for larger summand

  if(ckflag==1)
  {
    summand->setsize();
    setsize();
    cr=hibit-summand->hibit;
    if((cr>0) &&())
    {

    }
  }
  else cr=1;

  if(cr >= 0) // wenn this groesser als summand
  {
    if(size > length-4)
      if(!resizelonu(size+4)) {throwout(_("resize-error 1 in addnum"));
                               return -1;}
  //determine # of 4byte addsteps
    steps=summand->size / 4;
    cy=false;

    for(indx=0;indx<steps;indx++)  //4byte operationen machen
    {
      if(!cy)
      {
                h1=  *((ulong32*) (ad+ 4*indx));
                hb= *((ulong32*) (summand->ad+4*indx));
                h1+=hb;
                *((ulong32*) (ad+ 4*indx))=h1;
                if(h1<hb) cy=true;
                else cy=false;
      }
      else
      {
                h1=  *((ulong32*) (ad+ 4*indx));
                hb= *((ulong32*) (summand->ad+4*indx));
                h1+=hb;
                if(h1<hb)
                {
                    cy=true;
                    h1++;
                }
                else
                {
                    h1++;
                    if(h1==0) cy=true;
                    else cy=false;
                }
                *((ulong32*) (ad+ 4*indx))=h1;
      }
    }
    for( indx=4*steps;indx<summand->size;indx++) //restliche einzelbyte-operationen
    {
        if(!cy)
        {
            h2=   *(ad+ indx);
            h2 +=  *(summand->ad+indx);
            if(h2<*(ad+ indx) )
            {
                cy=true;
            }
            else cy=false;
            *(ad+indx)=h2;
        }
        else
        {
            h2=   *(ad+ indx);
            h2 +=  *(summand->ad+indx);
            if(h2<*(ad+ indx) )
            {
                cy=true;
                h2++;
            }
            else
            {
                h2++;
                if(h2==0) cy=true;
                else cy=false;
            }
            *(ad+ indx)=h2;
        }
    }
    while (cy &&(indx<length)) //carry noch abraeumen
    {
      h2=  *(ad+indx);
      h2++;
      if(h2==0) cy=true;
      else cy=false;
      *(ad+indx)=h2;
      indx++;
    }
    if(cy) throwout(_("overflow in add\n care for carry!"));
    trusiz=false;
    if(cy) return -1;
    else return 0;
  }

  else // wenn this kleiner gleich  summand
  {
    longnumber newnum;
    newnum.copynum(summand);
    tmp=newnum.addnum_q(this,0);
    copynum(&newnum);
    return tmp;
  }
}
*********************************************/
/*********************************************/
int longnumber::addnum_q(longnumber* summand, longnumber *modul, int ckflag)
//Summe mit Modul
{
  //char carry= 0;
  ulong32 h1,hb;
  ulong32 indx,steps,offs;
  char cr;
  unsigned char h2;
  bool cy,didreduce;
  int tmp,flag;

  if(ckflag==1)
  {
    summand->setsize();
    setsize();
    flag=lonumodulo_qqq_e(modul);
    flag=summand->lonumodulo_qqq_e(modul);
    cr= compare(summand);
  }
  else cr=1;

  if(cr >= 0) // wenn this groesser als summand
  {
    if(size > length-4)
      if(!resizelonu(size+4)) {throwout(_("resize-error 1 in addnum"));
                               return -1;}
  //determine # of 4byte addsteps
    steps=summand->size >> 2;  //schneller als /4
    cy=false;

    for(indx=0;indx<steps;indx++)  //4byte operationen machen
    {
      offs=indx<<2; //mal 4
      if(!cy)
      {
                h1=  *((ulong32*) (ad+ offs));
                hb= *((ulong32*) (summand->ad+offs));
                h1+=hb;
                *((ulong32*) (ad+ offs))=h1;
                if(h1<hb) cy=true;
                else cy=false;
      }
      else
      {
                h1=  *((ulong32*) (ad+ offs));
                hb= *((ulong32*) (summand->ad+offs));
                h1+=hb;
                if(h1<hb)
                {
                    cy=true;
                    h1++;
                }
                else
                {
                    h1++;
                    if(h1==0) cy=true;
                    else cy=false;
                }
                *((ulong32*) (ad+ offs))=h1;
      }
    }
    for( indx=steps<<2;indx<summand->size;indx++) //restliche einzelbyte-operationen
    {
        if(!cy)
        {
            h2=   *(ad+ indx);
            h2 +=  *(summand->ad+indx);
            if(h2<*(ad+ indx) )
            {
                cy=true;
            }
            else cy=false;
            *(ad+indx)=h2;
        }
        else
        {
            h2=   *(ad+ indx);
            h2 +=  *(summand->ad+indx);
            if(h2<*(ad+ indx) )
            {
                cy=true;
                h2++;
            }
            else
            {
                h2++;
                if(h2==0) cy=true;
                else cy=false;
            }
            *(ad+ indx)=h2;
        }
    }
    while (cy &&(indx<length)) //carry noch abraeumen
    {
      h2=  *(ad+indx);
      h2++;
      if(h2==0) cy=true;
      else cy=false;
      *(ad+indx)=h2;
      indx++;
    }
    if(cy) throwout(_("overflow in add\n care for carry!"));
    trusiz=false;
    didreduce=cheap_modreduce(modul);
    if(cy) return -1;
    else return 0;
  }

  else // wenn this kleiner gleich  summand
  {
    //swapnum(summand);
    longnumber newnum;
    newnum.copynum(summand);
    tmp=newnum.addnum_q(this,modul,0);
    copynum(&newnum);
    return tmp;
  }
}
/*********************************************/
void longnumber::swapnum(longnumber* other)
//nummern effizient tauschen
{
    long h;
    ulong32 hul;
    unsigned char *had;
    bool hb;

    had= other->ad;     other->ad    = ad;     ad     = had;
    hul  = other->length; other->length= length; length = hul;
    hul  = other->size;   other->size  = size;   size   = hul;
    hb  = other->trusiz;   other->trusiz  = trusiz;   trusiz   = hb;
    h  = other->hibit;   other->hibit  = hibit;   hibit   = h;
    if(!israre&&!(other->israre)) return;
    else
    {
        had= other->asum; other->asum=asum; asum=had;
        had= other->asub; other->asub=asub; asub=had;
        hb= other->israre; other->israre=israre; israre=hb;
    }
}
/*********************************************
int longnumber::addnum_qq(longnumber* summand, longnumber* modul,int ckflag)
//Summe mit Modul
{
  char carry= 0;
  ulong32 h1;
  ulong32 indx,steps;
  char cr;
  unsigned char h2;
  int flag; bool didreduce;
  bool rarcar;

  if(ckflag==1)
  {
    summand->setsize();
    setsize();
    flag=lonumodulo_qqq(modul);
    flag=summand->lonumodulo_qqq(modul);
    cr= compare(summand);
  }
  else cr=1;

  if(cr >= 0) // wenn this groesser als summand
  {
    if(size > length-4)
      if(!resizelonu(size+4)) {throwout(_("resize-error 1 in addnum"));
                               return -1;}
  //determine # of 4byte addsteps
    steps=summand->size / 4;

    for(indx=0;indx<steps;indx++)  //4byte operationen machen
    {
      rarcar=false;
      h1=  *((ulong32*) (ad+ 4*indx))+ carry;
      if((carry==1)&&(h1==0)) rarcar=true;
      h1 += *((ulong32*) (summand->ad+4*indx));
      if((h1 < *((ulong32 *) (ad+ 4*indx)))||rarcar) carry= 1;
      else carry = 0;
      *((ulong32 *) (ad+ 4*indx)) = h1;
    }
    for( indx=4*steps;indx<summand->size;indx++) //restliche einzelbyte-operationen
    {
      rarcar=false;
      h2=   *(ad+ indx)+ carry;
      if((carry==1)&&(h2==0)) rarcar=true;
      h2 +=  *(summand->ad+indx);
      if((h2 < (carry + *(ad+ indx)))||rarcar) carry= 1;
      else carry = 0;
      *(ad+ indx) = h2;
    }
    while ((carry >0)&&(indx<length)) //carry noch abraeumen
    {
      h2=  *(ad+indx) + carry;
      if(h2 < ( *(ad+indx))) carry = 1;
      else carry=0;
      *(ad+indx)=h2;
      if(carry==0) break; // carrykette abgeschlossen
      indx++; //carrykette laeuft weiter
    }
    if(carry >0) throwout(_("overflow in add\n care for carry!"));
    //cheap_modreduce(modul);
    trusiz=false;
    setsize();
    didreduce=cheap_modreduce(modul);
    return (int) carry;
  }

  else // wenn this kleiner gleich  summand
  {
    longnumber newnum;
    newnum.copynum(summand);
    carry=newnum.addnum_q(this,modul,0);
    copynum(&newnum);
    return (int) carry;
  }
}
*********************************************/
bool longnumber::subtrnum_rare(longnumber* summand, ulong32 offs)
{
    unsigned short i;
    //check for size requirement
    #ifdef DEBUG_LONU
    if(compare(summand)<0)
    {
              throwout(_("error in subtr_rare1"));
              return false;
    }
    #endif
    for(i=0;i<(unsigned char)*(summand->asub);i++)
    {
       if(! pushbyte(offs+ (ulong32)((unsigned char)*(summand->asub+1+(i<<1))), (unsigned char)*(summand->asub+((i+1)<<1) )))
          {
              throwout(_("error in subtr_rare2"));
              return false;
          }
    }
    for(i=0;i<(unsigned char)*(summand->asum);i++)
    {
       if(! pluckbyte(offs+ (ulong32)((unsigned char)*(summand->asum+1+(i<<1))), (unsigned char)*(summand->asum+((i+1)<<1) )))
          {
              throwout(_("error in subtr_rare3"));
              return false;
          }
    }
    trusiz=false;
    return true;
}
/*********************************************/
bool longnumber::subtrnum_rare_b(longnumber* summand, ulong32 boffs)
//to Do
{
    int i;
    ulong32 offs;
    unsigned char boff,dch;
    unsigned short pval;
    //check for size requirement
    #ifdef DEBUG_LONU
    if(compare(summand)<0)
    {
              throwout(_("error in subtr_rare1"));
              return false;
    }
    #endif
    offs=boffs>>3; //divided by 8
    boff=(unsigned char) (boffs&7); //lowest three bit
    if(boff==0) return( subtrnum_rare(summand,offs) );

    for(i=0;i<(unsigned char)*(summand->asub);i++)
    {
        // build the short
        dch=(unsigned char)*(summand->asub+2*(i+1));
        pval= ((unsigned short)dch)<<boff;
       if(! pushshort(offs+ (ulong32)((unsigned char)*(summand->asub+1+2*i)), pval))
          {
              throwout(_("error in subtr_rare_b2"));
              return false;
          }
    }
    for(i=0;i<*(summand->asum);i++)
    {
        // build the short
        dch=(unsigned char)*(summand->asum+2*(i+1));
        pval= ((unsigned short)dch)<<boff;
        if(! pluckshort(offs+ (ulong32)((unsigned char)*(summand->asum+1+2*i)), pval))
          {
              throwout(_("error in subtr_rare_b3"));
              return false;
          }
    }
    trusiz=false;
    return true;
}
/*********************************************/
/*********************************************/
int longnumber::addnum_rare(longnumber* summand)
{
    int i;

    if((summand->size + 2)>=length) resizelonu(summand->size + 3);
    for(i=0;i<*(summand->asum);i++)
    {
       if(! pushbyte( (ulong32)*(summand->asum+1+2*i), *(summand->asum+2*(i+1) )))
          {
              throwout(_("error in addrare1"));
              return -1;
          }
    }
    for(i=0;i<*(summand->asub);i++)
    {
       if(! pluckbyte( (ulong32)*(summand->asub+1+2*i), *(summand->asub+2*(i+1) )))
          {
              throwout(_("error in addrare2"));
              return -1;
          }
    }
    trusiz=false;
    return 0;
}
/*********************************************/
int longnumber::addnum(longnumber* summand)
//Einfache Summe ohne modul
{
  unsigned int carry=0;
  unsigned char h1,h2;
  unsigned int h3=0;
  ulong32 indx;

  setsize();
  summand->setsize();
  if(size == length)
    if(!resizelonu(length+2)) {throwout(_("resize-error 1 in addnum"));
                               return -1;}
  if(summand->size >= length)
     if(!resizelonu(summand->size + 2)) {throwout(_("resize-error 2in addnum"));
                               return -1;}
  if(summand->israre) return(addnum_rare(summand));
  for(indx=0;indx<summand->size;indx++)
  {
      h1=  *(ad+indx);
      h2=  *(summand->ad+indx);
      h3= (unsigned int)h1 + (unsigned int)h2;
      carry += h3;
      *(ad + indx)= (unsigned char) carry;
      carry /= 256;
  }
  while ((carry >0)&&(indx<length))
  {
    h1=  *(ad+indx);
    carry += (unsigned int) h1;
    *(ad + indx)= (unsigned char) carry;
    carry /= 256;indx++;
  }
  if(carry >0) throwout(_("overflow in add\n care for carry!"));
  trusiz=false;
  return (int) carry;
}
/*********************************************/
bool longnumber::isconsistent()
//consistency check
{
    if(!israre) return true;
    else
    {
        longnumber test;

        test.addnum_rare(this);
        if(compare(&test)!=0)
        {
            throwout(_("inconsistent number in add_rare!"));
            return false;
        }
        else return true;
    }
}
/*********************************************************/
int longnumber::r_compar(ulong32 bpos, longnumber* divsr, ulong32 d_bpos, long32 divminone)
//vergleicht die Reste auf der niederwertigen seite  ab der angeg Positionen
//divminone =-1 zeigt an, dass noch gesucht werden muss
{
    ulong32 i,j, minone;
    long loops, loops2;
    bool bit,bitdiv;
    #ifdef DEBUG_LONU
    if((divsr->hibit > get_hibit() )||((d_bpos>>3)>=(divsr->length ))||(bpos>>3 >=(length)))
    {
        throwout(_("Wrong use of restcompare"));
        return -2;
    }
    #endif
    //abbruchbed finden
    minone= get_lowest_one();
    if(divminone == -1) divminone= divsr->get_lowest_one();
    loops=(long)bpos-(long)minone;
    loops2=(long)d_bpos - (long)divminone;
    if(loops2<0) return 0; //rest kann bei divisor nicht groesser sien!
    if(loops<0) return -1; //bei divsr kommt noch was und bei dividnd nix
    if(loops2 < loops) loops=loops2; //findet zuerst den Boden bei *divsr
    #ifdef DEBUG_LONU
    if(loops<0)
    {
        throwout(_("gulasch in r-compar"));
        return 0;
    }
    #endif
    i=bpos+1; j= d_bpos+1;
    while(loops>=0)
    {
        i--;j--; // damit am Schluss kein neg index ersch kann, wenns bis 0 runterlaeuft!!
        bit=getbit(i); bitdiv=divsr->getbit(j);
        if( bit && (!bitdiv)) return 1;
        else
          if( !bit && bitdiv ) return -1;
          loops--;
    }
    // im bereich keinen Gewinner gefunden
    if(i>(ulong32) minone) return 1;
    if(j>(ulong32)divminone) return -1;
    return 0;
}

/*********************************************************/
/*********************************************************/
int longnumber::restcompare(longnumber* divsr, ulong32 pos)
//pos ab "0"
{
    ulong32 i;
    bool bit,bitdiv;
    if((divsr->get_hibit() > get_hibit() )||(pos>=((divsr->length )<<3))||(pos>=((length)<<3)))
    {
        throwout(_("Wrong use of restcompare"));
        return -2;
    }
    for (i=pos;i>=0;i--)
    {
        bit=getbit(i); bitdiv=divsr->getbit(i);
        if( bit && (!bitdiv)) return 1;
        else
          if( !bit && bitdiv ) return -1;
    }
    return 0;
}

/*********************************************************/
int longnumber::overnum(longnumber* divsr, longnumber* resno)
//gibt wert über position wo divisor = 1 ist
{
    ulong32  divsr_hi,t_hi;

    divsr_hi=divsr->get_hibit();
    t_hi=get_hibit();
    if(t_hi== divsr_hi)
    {
        resno->storlong(0);
        return 0;
    }
    if(t_hi< divsr_hi)
    {
        resno->storlong(0);
        throwout(_("wrong use of overnum"));
        return -1;
    }
    resno->copynum(this);
    resno->shiftbits_q(-(long)(divsr_hi+1));
    return ((int)(t_hi - divsr_hi));
}
/*********************************************/
long32 longnumber::gethighest_long(ulong32 *lp)
  // holt die hoechsten 32 bit ab, bei hibit 0, secondhi 1 und stopft sie in den longzahl-pointer
  //rückgabe index des niedrigsten bit
{
    longnumber h(7);
    int bitshift;

    setsize();
    //hoechste 5 byte nach scratch
    if(size >=5)
    {
      memcpy(h.ad, ad+size-5,5);
      bitshift=(int)(7- (hibit&7));
      h.shiftbits_q(bitshift);
      memcpy(lp,h.ad+1,4);
      *lp>>=1; //hibit soll 0 sein
      return (hibit-30);
    }
    else{
        *lp=0;
        memcpy(lp,ad,size);
        if( (*((unsigned char *)lp+3) & 128) == 128)
        {
            *lp>>=1;
            return 1;
        }
        return 0;
    }
}
/*********************************************/
long32 longnumber::gethighest_int(ulong32 *ip)
 // holt die hoechsten 16 bit ab, bei hibit 1 und stopft sie in den integer-pointer
//rückgabe index des niedrigsten bit
{
    longnumber h(5);
    long32 bitshift;

    setsize();
    //hoechste 5 byte nach scratch
    if(size >=3)
    {
     memcpy(h.ad, ad+size-3,3); //höchste 3 byte + 0
     bitshift=(long32)(7- (hibit &7));
     h.shiftbits_q(bitshift);
     memcpy(ip,h.ad+1,2);
     return (hibit-15);
    }
    else{
        *ip=0;
        memcpy(ip,ad,size);
        return 0;
    }
}
/*********************************************/
int longnumber::q_pownum(longnumber* expon, longnumber* p, longnumber* q)
{
    lonucrt *tmp;

    tmp = new lonucrt(this, p, q);
    tmp->powcrt(expon);
    tmp->exportnum(this);
    free(tmp);
    return 1;
}

/*********************************************/
int longnumber::pownum(longnumber* expon, longnumber* modul)
  //erheben zur expon´ten Potenz
{
   longnumber akku(2*modul->length),slidefac(2*modul->length),ex;
   ulong32 indx,highest1;
//   char buffer[20];

   expon->setsize();
   if(expon->size==0){storlong(1); return 0;} //hoch 0 abfangen

   lonumodulo(modul); //erstmal basis reinigen
   ex.copynum(expon); //exponenten modulmaessig reinigen (mod (modul-1))
   ex.inc();
   if(ex.compare(modul) >= 0) //modulbildung noetig!
   {
       ex.dec();
       modul->dec(); ex.lonumodulo(modul); modul->inc(); // mod (modul -1)
   } else ex.dec();//auf jeden Fall wieder decrementieren

   setsize(); ex.setsize();
   if(size==0){storlong(0);return 0;}//0 hoch was gibt 0

   slidefac.copynum(this);
   akku.storlong(1);

   highest1= (8* ex.size);  //höchstes einserbit finden
   do
   {
     highest1--;
   } while( !ex.getbit(highest1));

   for(indx=0;indx<=highest1;indx++)
   {
      if(ex.getbit(indx))
      {
        akku.multnum(&slidefac);
        akku.lonumodulo(modul);
      }
      slidefac.quadmodul(modul);
//      sprintf(buffer,"working on bit: %ld", indx);
//      throwout(buffer);
   }
   copynum(&akku);
   return 1;
}
/*********************************************/
int longnumber::pownum_pz(longnumber* expon, longnumber* modul)  //wird das noch gebraucht ??
  //Panzerknackervariante
{
   wxString offender1,offender2;
   longnumber akku(2*modul->length),slidefac(2*modul->length),ex;
   ulong32 indx,highest1;
   int flag,flago,flagn,cm,cm2;

   longnumber o_th,n_th,o_ex,n_ex,last_slidefac,last_akku;
   longnumber o_akku(2*modul->length),o_slidefac(2*modul->length);


   expon->setsize();
   if(expon->size==0){storlong(1); return 0;} //hoch 0 abfangen

   flag=lonumodulo_qqq(modul); //erstmal basis reinigen
   ex.copynum(expon); //exponenten modulmaessig reinigen (mod (modul-1))
   ex.inc();
   if(ex.compare(modul) >= 0) //modulbildung noetig!
   {
       ex.dec();
       modul->dec(); ex.lonumodulo(modul); modul->inc(); // mod (modul -1)
   } else ex.dec();//auf jeden Fall wieder decrementieren

   setsize(); ex.setsize();
   if(size==0){storlong(0);return 0;}//0 hoch was gibt 0

   slidefac.copynum(this);
   akku.storlong(1); akku.setsize();
   o_slidefac.copynum(this);
   o_akku.storlong(1); akku.setsize();

   highest1= (8* ex.size);  //höchstes einserbit finden
   do
   {
     highest1--;
   } while( !ex.getbit(highest1));

   o_th.copynum(this);n_th.copynum(this);
   o_ex.copynum(&ex); n_ex.copynum(&ex);

   for(indx=0;indx<=highest1;indx++)
   {
      if(o_ex.getbit(indx))
      {
        flagn=akku.multnum_q(&slidefac,modul);
        flago=o_akku.multnum(&o_slidefac);
        flag=o_akku.lonumodulo(modul);
        cm=akku.compare(&o_akku);
        if(cm!=0) // test auf multiplikationsresult
        { //hab ich dich!!
            //last akku und last slidefac in hex strings gießen und rausschreiben
            last_akku.writehex(&offender1);
            last_slidefac.writehex(&offender2);
            offender1 += _("<-akku,\n slidefac->");
            offender1 += offender2;
            throwout(_("error found"));
            indx--;
            akku.copynum(&last_akku);o_akku.copynum(&last_akku);
            o_slidefac.copynum(&last_slidefac);slidefac.copynum(&last_slidefac);
        }
      }
      last_slidefac.copynum(&slidefac);
      last_akku.copynum(&akku);
      slidefac.quadmodul_q(modul);
      o_slidefac.quadmodul(modul);
      cm2=slidefac.compare(&o_slidefac);
      if(cm2 !=0)
      {//hab ich dich schon wieder
          last_slidefac.writehex(&offender1);
          last_slidefac.lonu_to_file(_("faktor.bin"));
          offender1 += _("<-letzter sfac in hex \n");
          slidefac.writehex(&offender2);
          slidefac.lonu_to_file(_("falschergebnis.bin"));
          offender2 += _("<- _q slidefac \n");
          offender1 +=offender2;
          o_slidefac.writehex(&offender2);
          offender2 += _("<- old slidefac \n");
          offender1 +=offender2;
          modul->writehex(&offender2);
          modul->lonu_to_file(_("modul.bin"));
          offender2 += _("<- Modul in hex");
          offender1 += offender2;
          throwout(offender1);
          indx--;
          akku.copynum(&last_akku);o_akku.copynum(&last_akku);
          o_slidefac.copynum(&last_slidefac);slidefac.copynum(&last_slidefac);

      }
   }
   copynum(&akku);
   return 1;
}

/*********************************************/
int longnumber::pownum_q(longnumber* expon, longnumber* modul)
  //erheben zur expon´ten Potenz
{
   longnumber akku(2*modul->length),slidefac(2*modul->length),longbuf(2*modul->length),ex;
   ulong32 indx,highest1; int flag;
//   char buffer[20];

   expon->setsize();
   if(expon->size==0){storlong(1); return 0;} //hoch 0 abfangen

   flag=lonumodulo_qqq_e(modul); //erstmal basis reinigen
   ex.copynum(expon); //exponenten modulmaessig reinigen (mod (modul-1))
   ex.inc();
   if(ex.compare(modul) >= 0) //modulbildung noetig!
   {
       ex.dec();
       modul->dec(); ex.lonumodulo_qqq_e(modul); modul->inc(); // mod (modul -1)
   } else ex.dec();//auf jeden Fall wieder decrementieren

   setsize(); ex.setsize();
   if(size==0){storlong(0);return 0;}//0 hoch was gibt 0

   slidefac.copynum(this);
   akku.storlong(1); akku.setsize();

   /*highest1= (8* ex.size);  //höchstes einserbit finden
   do
   {
     highest1--;
   } while( !ex.getbit(highest1));*/
   highest1=ex.hibit; //das geht doch so schneller!
   for(indx=0;indx<=highest1;indx++)
   {
      if(ex.getbit(indx))
      {
        akku.multnum_l1(&slidefac,modul,&longbuf);
        //akku.multnum(&slidefac);
        //akku.lonumodulo(modul);
      }
      slidefac.quadmodul_l1(modul,&longbuf);
//      sprintf(buffer,"working on bit: %ld", indx);
//      throwout(buffer);
   }
   copynum(&akku);
   return 1;
}
/*********************************************/
int longnumber::quadmodul_qqq(longnumber* modul,bool incheck)
  //quadrieren und modul bilden
{
   longnumber faktor(length);
   int flag =0;

   if(incheck) flag += lonumodulo_qqqq(modul); // wenn aktiv -> flag =1
   faktor.copynum(this);
   if(multnum_qqq(&faktor,modul,incheck)==-1)
     {throwout(_("Error1 in quadmodul_qqq"));return -1;}
   //flag += lonumodulo_q(modul);
   return flag;
}
/*********************************************/
int longnumber::quadmodul_qqqq(longnumber* modul,bool incheck)
  //quadrieren und modul bilden
{
   longnumber faktor(length);
   int flag =0;

   if(incheck) flag += lonumodulo_qqqq(modul); // wenn aktiv -> flag =1
   faktor.copynum(this);
   if(multnum_qqqq(&faktor,modul,incheck)==-1)
     {throwout(_("Error1 in quadmodul_qqqq"));return -1;}
   //flag += lonumodulo_q(modul);
   return flag;
}

/*********************************************/
int longnumber::quadmodul_qq(longnumber* modul)
  //quadrieren und modul bilden
{
   longnumber faktor(length);
   int flag =0;

   flag += lonumodulo_qqq(modul); // wenn aktiv -> flag =1
   faktor.copynum(this);
   if(multnum_qq(&faktor,modul)==-1)
     {throwout(_("Error1 in quadmodul_qq"));return -1;}
   //flag += lonumodulo_q(modul);
   return flag;
}
/*********************************************/
int longnumber::quadmodul_q(longnumber* modul,bool incheck)
  //quadrieren und modul bilden
{
   longnumber faktor(length);
   int flag =0;

   if(incheck) flag += lonumodulo_qqq(modul); // wenn aktiv -> flag =1
   faktor.copynum(this);
   if(multnum_q(&faktor,modul,false)==-1)
     {throwout(_("Error1 in quadmodul"));return -1;}
   //flag += lonumodulo_q(modul);
   return flag;
}
/*********************************************/
int longnumber::quadmodul(longnumber* modul)
  //quadrieren und modul bilden
{
   longnumber faktor(length);
   int flag =0;

   flag += lonumodulo(modul); // wenn aktiv -> flag =1
   faktor.copynum(this);
   if(multnum(&faktor)==-1)
     {throwout(_("Error1 in quadmodul"));return -1;}
   flag += lonumodulo(modul);
   return flag;
}
/*********************************************/
bool longnumber::getbit(ulong32 bitpos)
//gibt true, wenn das bit (von hinten ab "0") 1 ist
{
  unsigned char c,mask,result;
  ulong32 bytpos;

  //setsize(); not necessary
  if(size==0) return false;
  bytpos= bitpos>> 3;
  #ifdef DEBUG_LONU
  if(bytpos >= length)
  {
      throwout(_("attempting illegal readout in getbit"));
      return false;
  }
  #endif
  c=*(ad+(bytpos));
  mask=((unsigned char)(1<<(bitpos & 7)));
  result=mask & c;
  if(result == 0) return false;
  else return true;
}
/*********************************************/
int longnumber::lonumodulo_qqq(longnumber* divsr)
  //superquick Int division mit einer longnumber
  // rest wird in longnum remdr zurückgegeben
{
    ulong32 dv_lowest;
    int cflag,restflag,lc=0;
    longnumber temp_d;
    long bitpos, hidiff;


    divsr->setsize(true); setsize(true); //braucht man das??
    cflag=compare(divsr);  //jetzt trivialfall abfangen
    if(cflag==-1) return 0; //tunix
    if(cflag==0){ storlong(0); return 0;}
//muss was tun
    if(divsr->hibit ==0) // durch eins teilen
       { storlong(0); return 0;}
    if(divsr->hibit <0) //durch 0 teilen!
      { throwout(_("Division by 0 in lonumodulo_qqq")); storlong(0); return -1;}

    dv_lowest=divsr->get_lowest_one();
    temp_d.copynum(divsr);
    temp_d.shiftbits_q(hibit-divsr->hibit);
    //i=0;
    bitpos=hibit-divsr->hibit;
    while(cflag>=0)
    {
     hidiff= (long) hibit -(long) temp_d.hibit;
     if(hidiff<0)
     {
         temp_d.shiftbits_q(hidiff); // auf gleiche bithoehe bringen
         bitpos += hidiff; //bitpos auch runtersetzen
         hidiff=0; // wurde jetzt explizit hergestellt
     }
     if(hidiff==0) restflag= r_compar(hibit-1, divsr, divsr->hibit-1,dv_lowest);
     else restflag =0;
     if(restflag>=0)
     {
        subtrnum_qx(&temp_d, dv_lowest+bitpos);
        setsize();
        lc++;
        cflag=compare(divsr);
     }
     temp_d.shiftonedown_q();
     //i++;
     bitpos--;
     #ifdef DEBUG_LONU
     if((bitpos <0)&&(cflag>=0))
     {
         throwout(_("Error in d_qqq \n cannot set neg index-bit"));
         return -1;
     }
     #endif

    }
    return lc;
}
/*********************************************/
unsigned short longnumber::get_hi_short()
{
    ulong32 ires=0;
    unsigned short us1;
    unsigned short shft;

   setsize();
   if(size>2)
   {
       setsize();
       ires=(ulong32) (*(ad+size-1)) ;
       ires <<= 16;
       us1 = *((unsigned short*) (ad+size-3));
       ires += (ulong32) us1; //jetzt isses in ulong32 , now shift
       shft= 8 + hibit - ((size<<3)-1);
       ires >>= shft;
       return((unsigned short)ires);
   }
   else if(size==2)
   {
       us1= *((unsigned short*) ad);
       return(us1);
   }
   else if(size==1)
   {
       us1=(unsigned short) (*(ad));
       return(us1);
   }
   else return(0);
}
/*********************************************/
inline unsigned short longnumber::get_hi_short(longnumber *divsr, ulong32 *poffs)
{
    ulong32 hi_this, hi_div,bn,t;
    unsigned char boffs;
    unsigned short retval,h1;
    int i;

    if(!trusiz) setsize();
    if(size==0)
    {
        *poffs=0;
        return(0);
    }
    if(!divsr->trusiz) divsr->setsize();

    hi_this=hibit;
    hi_div=divsr->hibit;

    if((hi_this >= 16+hi_div)&&(hi_div>24)) //standardfall
    {
        //get corresponding bytenumber
       bn= hi_this>>3;
       boffs= hi_this&7;  //get bitoffset within
       t= *((ulong32 *)(ad +bn -3));
       t <<= (7-boffs);  //now hibit is 1
       //take upper two bytes
       t>>= 16;
       retval= (unsigned short) t;
       *poffs= hi_this - hi_div-16;
       return(retval);
    }
    else
      if(hi_div<hi_this)  //zu knapp, letzter bereinigungsschritt
      {
        i=1;
        retval=0x8000; //only highest bit set
        h1=retval;
        h1 >>= 1;
        while((hi_this >hi_div+i)&&(i<16))
        {
           if(getbit(hi_this-i)) retval |=h1;
           i++; //up index
           h1 >>= 1; //shift mask
        }
        //pushdown to fit
        retval >>= (16-i);
        //*poffs=i;
        *poffs=hi_this - hi_div-i;
        return retval;
      }
      else   //(hi_div>=hi_this) -> error or floor found
      {
        *poffs=0;
        return(0);
      }
}
/*********************************************/
int longnumber::lonumodulo_qqq_e(longnumber* divsr)
{
    unsigned short hishort,hisdiv,shino,redbit=12;
    ulong32 moffs,hl1;
    long32 lasthi;

    if(compare(divsr) < 0) return(0);
    lasthi=hibit;
    hishort= get_hi_short(divsr,&moffs);
    hisdiv= divsr->get_hi_short();
    shino=16;
    if(divsr->hibit<15) shino=(unsigned short)(1+divsr->hibit); //for extremely short divisors
    if(shino<16) redbit=shino>>1;
    hl1=(ulong32) hishort;
    hl1<<=shino;
    hl1/=(hisdiv+1);
    while(hl1>65535)
    {
        hl1>>=1;
        moffs+=1;
    }
    //hishort=(unsigned short) hl1;
    while(hl1>=1)
    {
        if(divsr->israre)
        {
            subtrnum_om_bit_rare(divsr, moffs,(unsigned short)hl1,0);
        }
        else
        {
            subtrnum_om_bit(divsr, moffs,(unsigned short)hl1,0);
        }
        if(moffs>0)
        {
            lasthi -= redbit;
        }
        setsizefrom(lasthi);
       /* if(lasthi==hibit)
        {
            //throwout(_("cought the endless loop"),2);
            setsizefrom(lasthi);
        }*/
        lasthi=hibit;
        hishort= get_hi_short(divsr,&moffs);
        if((hishort<=1)&&(moffs==0)) break;
        hl1=(ulong32) hishort;
        hl1<<=shino;
        hl1/=(hisdiv+1);
        if(hl1>65535)
        {
            hl1>>=1;
            moffs+=1;
        }
        //hishort=(unsigned short) hl1;
    }
    //return(lonumodulo_qqqq(divsr));
    while(compare(divsr)>=0)
    {
        cheap_modreduce(divsr);
    }
    return 1;
}
/*********************************************/
int longnumber::divnum_qqq_e(longnumber* divsr, longnumber* remdr )
{
    unsigned short hishort,hisdiv,shino,redbit=12;
    ulong32 moffs,hl1;
    long32 lasthi;
    int rescmp;

    remdr->wipezero();
    rescmp=compare(divsr);
    if(divsr->hibit==-1)  //div by zero
    {
        throwout(_("ERROR!\ndivision by zero in divnum_qqq_e"),1);
        return -1;
    }
    if(divsr->hibit==0)  //div by one
    {
        remdr->wipezero();
        return 1;
    }
    if(rescmp < 0)
    {
        remdr->copynum(this);
        wipezero();
        return(0);
    }
    if(rescmp==0) //equal
    {
        remdr->wipezero();
        storlong(1);
        return 1;
    }
    if(remdr->length < size+2) remdr->resizelonu(size + 2);
    lasthi=hibit;
    hishort= get_hi_short(divsr,&moffs);
    hisdiv= divsr->get_hi_short();
    shino=16;
    if(divsr->hibit<15) shino=(unsigned short)(1+divsr->hibit); //for extremely short divisors
    if(shino<16) redbit=shino>>1;
    hl1=(ulong32) hishort;
    hl1<<=shino;
    hl1/=(hisdiv+1);
    while(hl1>65535)
    {
        hl1>>=1;
        moffs+=1;
    }
    //hishort=(unsigned short) hl1;
    while(hl1>=1)
    {
        if(divsr->israre)
        {
            subtrnum_om_bit_rare(divsr, moffs,(unsigned short)hl1,0);
            remdr->pushlong(moffs>>3, hl1<<(moffs&7));
        }
        else
        {
            subtrnum_om_bit(divsr, moffs,(unsigned short)hl1,0);
            remdr->pushlong(moffs>>3, hl1<<(moffs&7));
        }
        if(moffs>0)
        {
            lasthi-= redbit;
        }
        setsizefrom(lasthi);
       /* if(lasthi==hibit)
        {
            //throwout(_("cought the endless loop"),2);
            setsizefrom(lasthi);
        }*/
        lasthi=hibit;
        hishort= get_hi_short(divsr,&moffs);
        if((hishort<=1)&&(moffs==0)) break;
        hl1=(ulong32) hishort;
        hl1<<=shino;
        hl1/=(hisdiv+1);
        if(hl1>65535)
        {
            hl1>>=1;
            moffs+=1;
        }
        //hishort=(unsigned short) hl1;
    }
    //return(lonumodulo_qqqq(divsr));
    while(compare(divsr)>=0)
    {
        cheap_modreduce(divsr);
        remdr->inc();
    }
    swapnum(remdr); //remdr was used as quotient, this is remaindr, swap back
    return 1;
}
/*********************************************/
/*********************************************/
int longnumber::lonumodulo_qqqq(longnumber* divsr)
  //superquick Int division mit einer longnumber
{
    ulong32 lasthi;
    int cflag;
    long bitpos, hidiff;


    divsr->setsize(); setsize(); //braucht man das??
    cflag=compare(divsr);  //jetzt trivialfall abfangen
    if(cflag==-1) return 0; //tunix
    if(cflag==0){ storlong(0); return 0;}
//muss was tun
    if(divsr->hibit ==0) // durch eins teilen
       { storlong(0); return 0;}
    if(divsr->hibit <0) //durch 0 teilen!
      { throwout(_("Division by 0 in lonumodulo_qqq")); storlong(0); return -1;}

    if(divsr->israre)
    {
      lasthi=hibit;
      while(lasthi>divsr->hibit)
      {
        subtrnum_rare_b(divsr,hibit-divsr->hibit -1);
        //if(!trusiz)
            //setsize();
        hibit=get_hibit_spec(lasthi);
        lasthi=hibit;
      }
    }
    else
    {
      lasthi=hibit;
      while(hibit>divsr->hibit)
      {
        subtrnum_q_b(divsr,hibit-divsr->hibit -1,false);
        //if(!trusiz)
            //setsize();
        hibit=get_hibit_spec(lasthi);
        lasthi=hibit;
      }
    }
    cheap_modreduce(divsr);
    return 1;
}
/*********************************************/
/*********************************************/
int longnumber::lonumodulo_q(longnumber* divsr)
  //return 0 wenn inaktiv, 1 wenn aktiv, -1 wenn error
  // rest wird in longnum remdr zurückgegeben
{
  int flag,groesser;
  unsigned int kleiner;
  ulong32 ddi,dvi;

  divsr->setsize();setsize();
  if(divsr->size == 0)
  { throwout(_("div by 0 rejected")); return -1;}
  flag=compare(divsr);
  switch(flag)
  {
    case 0:
      storlong(0);
      return 1;
    case -1:
      return 0;
    case 1: //division nötig!
      ulong32 h1,h2,nix,zix,quix; //variablen
      longnumber quot,oldnum;
      quot.storlong(0);
      quot.resizelonu(length,0);
      //noch tempquot nullen

      ldiv_t x;
      divsr->setsize(true); setsize(true);
      oldnum.copynum(this);
      do
      {
        nix=divsr->size-1; //adresse offset hoechstes byte von Divisor
        zix=size-1; // ditto fuer dividend
        quix=zix-nix; // byteabstand, muss >=0 sein!
        h1= (ulong32) *(ad+zix); //hibite von lonu
        h2 =1 + (ulong32) *(divsr->ad+nix); //hibyte von divisor
        // jetzt checken, ob korrekturbedarf wg kleineren rests des dividends
        dvi=nix;
        ddi=zix;
        kleiner=0;//wenns durchläuft hat am ende der dividend mehr stellen(sonst vorher schon rausgeflogen)
        do
        {
           if(*(ad+ddi) > *(divsr->ad +dvi)) break; //wenn dividend groesser, alles ok
           else if( *(ad+ddi) < *(divsr->ad +dvi)) // wenn divisorrest groesser
           {

              kleiner =1; //Dividendrest  ist kleiner
           }
           if(kleiner == 1) break;
           if(dvi == 0) break;
           if(ddi == 0)
           {
               throwout(_("Alarm, recipe for disaster"));
           }
           dvi--;
           ddi--;
        }while(dvi>=0);
        x=ldiv(h1,h2);
        //if(x.quot > 0) x.quot -= kleiner; //wenn restdividend kleiner als restdivisor und quot >= 1-> hinten einmal weniger abziehen

        if(x.quot>0) // div fand statt, jetzt Resultat an korrekte Stelle reinquetschen
        {
          squeezebyte((unsigned char)(x.quot)
             ,quot.ad,quix,quot.length); //quotient Anteil rein
             quot.trusiz=false;
        }
        else //triv divresultat = 0
        {
          //throwout(_("Special case!"));
          if((h1+1<h2)||(quix>0)) //wenn didendbyte < divisorbyte(normalfall) und nicht gleiche lonusize
          {
            h1*=256; // auf naechstunteres byte umskalieren
            zix--; //dividendsize heruntersetzen
            quix--;//entspr sizeabstand heruntersetzen
            h1 += (ulong32) *(ad+zix); //zu neuem "byte" vereinigen
            x=ldiv(h1,h2); // nochmal, aber jetzt muss es echte div werden
            squeezebyte((unsigned char)(x.quot)
             ,quot.ad,quix,quot.length); //quotient Anteil rein
             quot.trusiz=false;
             kleiner = 0;
          }
          else // gleiche lonusize und hibyte gleich !!!
          {
 //           throwout(_("Should never see this errormessg from lonumodulo!"));
 //           return 0; //sollte nicht vorkommen
            if( kleiner == 1)
            {
                throwout(_("Should never see this messg from lonumodulo!"));
               return 0; //solte nicht vorkommen
            }
            else // rest des dividenden ist groesser sizes sind gleich unf hibyte ist gleich
            {
                quot.inc(); //da soll 1 rein
            }
          }
        }
        quot.multnum_q(divsr); //wieder mit divisor mult
        subtrnum_q(&quot); // urspr. dididenden bereinigen
        groesser=compare(divsr);
        if(groesser==-1) // fertig, wenn nunmehr kleiner als Divisor
        {
          return 1;
        }
        if(groesser==0) //falls genau noch einer uebrig->geht auf
        {
          storlong(0); //geht auf
          return 1;
        }
        //wenn noch immer groesser als der divisor
        trusiz=false;
        setsize();
        if(compare(&oldnum) == 0)
        {
            throwout(_("Alarm!! number not changed anymore!!!"));
        }
        oldnum.copynum(this);
        quot.resizelonu(size+1,0);
        quot.wipezero();
      }while(   ((long)zix-(long)nix)>=0);
      return -1;
  }
  return -1;
}
/*********************************************/

/*********************************************/
int longnumber::lonumodulo(longnumber* divsr)
//modulo bilden  return 0 wenn inaktiv, 1 wenn aktiv, -1 wenn error
{
  int flag;

  divsr->setsize();setsize();
  if(divsr->size == 0)
  { throwout(_("div by 0 rejected")); return -1;}
  flag=compare(divsr);
  switch(flag)
  {
    case 0:
      storlong(0);
      return 1;
    case -1:
      return 0;
    case 1:
      longnumber remdr(length);  //speicher kreieren
      remdr.storlong(0);
      //nullen weils als zwischensp benutzt wird
      ulong32 h1,h2;
      long nix,zix,quix; //variablen
      longnumber hlnum(length),hlnumb(length);
      //mehr zwischenspeicher
      hlnum.storlong(0); hlnumb.copynum(this);
      ldiv_t x;                         //variablen

      do
      {
        nix=(long)(divsr->size-1); zix=(long)(hlnumb.size-1); quix=zix-nix;
        h1= (ulong32) *(hlnumb.ad+zix); h2 = 1+ (ulong32) *(divsr->ad+nix);
        x=ldiv(h1,h2);
        if(x.quot>0)
        {
          squeezebyte((unsigned char)(x.quot)
             ,remdr.ad,quix,remdr.length);
             remdr.trusiz=false;
        }
        else
        {
          if((h1+1<h2)||(quix>0))
          {
            h1*=256;
            zix--;
            quix--;
            h1 += (ulong32) *(hlnumb.ad+zix);
            x=ldiv(h1,h2);
            squeezebyte((unsigned char)(x.quot)
               ,remdr.ad,quix,remdr.length);
            remdr.trusiz=false;
          }
          else
          {
            if(h1>0)squeezebyte(1,remdr.ad,quix,remdr.length);
            remdr.trusiz=false;
            // jetzt muss er auch fertig sein
          }
        }
        hlnum.copynum(&remdr);
        hlnum.multnum(divsr);
        hlnumb.copynum(this);
        hlnumb.subtrnum_q(&hlnum);
        if(hlnumb.compare(divsr)==-1)
        {
          copynum(&hlnumb);
          return 1;
        }
        if(hlnumb.compare(divsr)==0)
        {
          storlong(0);
          return 1;
        }
        hlnumb.setsize();
      }while(((long)zix-(long)nix)>=0);
      return -1;
  }
  return -1;
}
/*********************************************/
long32 longnumber::get_hibit()
//gibt den index des hibits
{
    long32 indx,tix;

    if(trusiz) return hibit;  //wenn schon ok tu nix
    size=0;
    for(indx=length-1;indx>=0;indx--)
    {
        if(*(ad + indx) !=0)
        {
            size = indx+1;
            if (size>= 8388607) //bei mehr als 2^23 gibts mit hibit ein Ueberlaufproblem
            {
                throwout(_("warning: overflow in bitcounting possible!!!\n arithmetic errors in divisions possible"));
            }
            break;
        }
    }
    if(size==0)
    {
        hibit=-1;
        trusiz=true;
        return -1;
    }
    trusiz=true; //kann man hier schon sagen
    for(indx=size-1;indx>=0;indx--)
    {
        tix=indx<<3;
        if( *(ad+indx) > 127)
        {
            hibit=(long32) (tix+ 7);
            return hibit;
        }
        else if( *(ad+indx) > 63) hibit=(long32) (tix + 6);
             else if( *(ad+indx) > 31)  hibit=(long32) (tix + 5);
                 else if( *(ad+indx) > 15)  hibit=(long32) (tix + 4);
                     else if( *(ad+indx) > 7)  hibit=(long32) (tix + 3);
                         else if( *(ad+indx) > 3)  hibit=(long32) (tix + 2);
                             else if( *(ad+indx) > 1)  hibit=(long32) (tix + 1);
                                 else if( *(ad+indx) == 1)  hibit=(long32) (tix); //kann nur hier 1 sein
                                   else{hibit = -1; throwout(_("this error is impossible 8-0")); return 0;}
        return hibit;

    }
    hibit = -1; throwout(_("this error yvxwe is impossible 8-0"));
    return 0;
}
/*********************************************/
long32 longnumber::get_lowest_one() //hoechstes bit ab dieser byte-Zahl, echter index
// darf trusiz und hibit nicht anfassen, da universeller einsetzbar
{
    ulong32 indx,bindx;

    setsize();
    for(indx=0;indx<size;indx++)
    {
        if(*(ad+indx) >0) break;
    }
    if(indx==size) return -1;//das waere ein Fehler
    bindx = indx<<3;
    if( (*(ad+indx) & 1) == 1)
        {
            return (long32) (bindx );
        }
        else if( (*(ad+indx) &2) ==2) return (long32) (bindx + 1);
             else if( (*(ad+indx) &4) ==4)  return (long32) (bindx + 2);
                 else if( (*(ad+indx) &8)==8)  return (long32) (bindx + 3);
                     else if(( *(ad+indx) &16)==16)  return (long32) (bindx + 4);
                         else if(( *(ad+indx) & 32) ==32)  return (long32) (bindx + 5);
                             else if(( *(ad+indx) &64)== 64)  return (long32) (bindx + 6);
                                 else   return (long32) (bindx + 7);

    throwout(_("this error yvxwe is impossible 8-0"));
    return -1;
}

/*********************************************/
long32 longnumber::get_hibit(ulong32 t_siz) //hoechstes bit ab dieser byte-Zahl, echter index
// darf trusiz und hibit nicht anfassen, da universeller einsetzbar
{
    ulong32 indx,im8,posbyt;

    if(t_siz==0)
    {
        return -1;
    }
    if(t_siz > 8388608)
    {
        throwout(_("error, overflow in return value possible"));
    }
    if(t_siz> length)
    {
        throwout(_("can't be serious!! \n index out of bounds"));
        return -1;
    }
    for(indx=t_siz-1;indx>=0;indx--)
    {
        im8=indx<<3;
        posbyt=*(ad+indx);
        if(posbyt==0) continue; //
        if( posbyt & 128)
        {
            return (long) (im8+ 7);
        }
        else if( posbyt & 64) return (long32) (im8 + 6);
             else if( posbyt & 32)  return (long32) (im8 + 5);
                 else if( posbyt & 16)  return (long32) (im8 + 4);
                     else if( posbyt & 8)  return (long32) (im8 + 3);
                         else if( posbyt & 4)  return (long32) (im8 + 2);
                             else if( posbyt & 2)  return (long32) (im8 + 1);
                                 else if( posbyt & 1)  return (long32) (im8);
    }
    throwout(_("this error yvxwe is impossible 8-0"));
    return -1;
}
/*********************************************/
/*********************************************/
inline long32 longnumber::get_hibit_spec(ulong32 t_siz) //hoechstes bit ab dieser bit-Zahl nach unten, echter index
// darf trusiz und hibit nicht anfassen, da universeller einsetzbar
{
    ulong32 posbyt;
    long32 indx;
    unsigned char pby,iw;

    if(t_siz > 8388608)
    {
        throwout(_("error, overflow in return value possible"));
    }
    posbyt=t_siz>>3; //byteposition
    if(posbyt>= length)
    {
        throwout(_("can't be serious!! \n index out of bounds"));
        return -1;
    }
    for(indx=(long32)posbyt;indx>=0;indx--)
    {
        pby=*(ad+indx);
        if(pby==0) continue; //
        iw=7;
        do
        {
            if(pby&128)
            {
                return( (indx<<3) + iw );
            }
            iw--;
            pby <<= 1;
        } while(iw<8);
    }
    //hit ground, number is zero
    return -1;
}
/*********************************************/

bool longnumber::cheap_modreduce(longnumber* modp)
  //zieht modul einmal ab falls groesser als modul
{
    int r;
    bool flag;

    r=compare(modp);
    switch(r)
    {
        case -1:
            return false;
        case 0:
            wipezero();
            return true;
        case 1:
            if(modp->israre) flag=subtrnum_rare(modp);
            else flag=subtrnum_q(modp);
            if(!flag){throwout(_("cheapmod_alarm!")); return false;}
            setsize();
            return true;
    }
    return false;
}
/*********************************************/
/*********************************************/
bool longnumber::lazy_modreduce(longnumber* modp)
  //zieht modul ein paar mal schnell byteversetzt ab
{
    int r;
    bool flag=true;

    ulong32 i;
    long offs=0;

    modp->setsize();
    setsize();
    if((size==0)&&(modp->size>0)) return true; //subtracting zero from zero
    if(modp->size==0) return true;
    if(size<(modp->size)) return true;
    if(size==(modp->size)) return true;

    offs=size- modp->size;
    if( *(ad+size-1) <= *((modp->ad)+(modp->size) -1))
    {
        offs--;
    }
    if(offs>0) flag=subtrnum_q(modp,(ulong32)offs);
    return flag;
}
/*********************************************/
int longnumber::multnum_q(longnumber* fak1)
//Produkt mit einer longnumber
{
    longnumber cfac,result;
    ulong32 hibit,bitzahl;
    //bool active;

    cfac.storlong(0);
    result.storlong(0);
    result.resizelonu( size + fak1->size +2);
    if(fak1->compare(&cfac) == 0) {wipezero(); return 0;}
    if(compare(&cfac) == 0) {wipezero(); return 0;}
    cfac.copynum(this);

    hibit=fak1->get_hibit();
    if(hibit == 0) return 0; //faktor 1

    for(bitzahl=0;bitzahl<=hibit;bitzahl++)
    {
        if(fak1->getbit(bitzahl))
        {
            result.addnum_q(&cfac);
           // active =result.cheap_modreduce(modul);
        }
        cfac.shiftoneup_q();
//        active=cfac.cheap_modreduce(modul);
    }
    copynum(&result);
    return (int) bitzahl;
}
/*********************************************/
int longnumber::multnum_qq(longnumber* fak1)
//Produkt mit einer longnumber
{
    longnumber cfac,result;
    ulong32 hibitm,bitzahl,shift_debt=0;
    //bool active;

    cfac.storlong(0);
    result.storlong(0);
    result.resizelonu( size + fak1->size +2);
    if(fak1->compare(&cfac) == 0) {wipezero(); return 0;}
    if(compare(&cfac) == 0) {wipezero(); return 0;}
    cfac.swapnum(this);

    hibitm=fak1->get_hibit();
    if(hibitm == 0)
    {
        cfac.swapnum(this);
        return 0; //faktor 1
    }

    for(bitzahl=0;bitzahl<=hibitm;bitzahl++)
    {
        if(fak1->getbit(bitzahl))
        {
            cfac.shiftbits_q(shift_debt);
            result.addnum_q(&cfac);
            shift_debt=1;
        }
        else   shift_debt++;
    }
    swapnum(&result);
    return (int) bitzahl;
}
/*********************************************/
int longnumber::multnum_q(longnumber* fak1, longnumber* modul, bool incheck)
//Produkt mit einer longnumber
{
    longnumber cfac,result,tmp;
    ulong32 hibitm,bitzahl;
    bool active; int flag;

    if(incheck)
    {
        flag=lonumodulo_qqq(modul);
        flag=fak1->lonumodulo_qqq(modul);
    }
    //cfac.storlong(0);
    //result.storlong(0);
    result.resizelonu( modul->length +4); //hier erhoehen!!!
    if(fak1->compare(&cfac) == 0) {wipezero(); return 0;}
    if(compare(&cfac) == 0) {wipezero(); return 0;}
    cfac.copynum(this);

    hibitm=fak1->get_hibit();
    if(hibitm == 0) return 0; //faktor 1

    for(bitzahl=0;bitzahl<=hibitm;bitzahl++)
    {
        if(fak1->getbit(bitzahl))
        {
            //alternativ altes addieren
            //result.addnum(&cfac);
            result.addnum_q(&cfac);
            //alternativ altes lonumodulo
            active =result.cheap_modreduce(modul);
            //result.lonumodulo(modul);
        }
        //alternativ umstaendliches shiftup
        if(bitzahl==hibitm) break; //speedup..
        cfac.shiftoneup_q();
        //alternativ altes lonumodulo
        active=cfac.cheap_modreduce(modul);
    }
    copynum(&result);
    return (int) bitzahl;
}
/*********************************************/
int longnumber::mult3mod( longnumber* modul)
{
    longnumber hn;

    //if(compare(modul)<1) lonumodulo_qqq_e(modul); //muss noch modreduced werden!
    hn.copynum(this);
    //hn.shiftoneup_q();
    //hn.cheap_modreduce(modul);
    addnum_om(&hn,0,2,0);
    lonumodulo_qqq_e(modul);
    return 1;
}
/*********************************************/
int longnumber::multnum_qqqq(longnumber* fak1, longnumber* modul, bool incheck)
//Produkt mit einer longnumber

// to do:  kobitz expansion ausnutzen
// expand kobitz factor
//adapt loop
{
    longnumber cfac,result,sresult,tmp,fs,fa;
    ulong32 bitzahl;
    long h1,hibitm;
    bool active,add,sub;
    int flag;

    if(incheck)
    {
        flag=lonumodulo_qqqq(modul);
        flag=fak1->lonumodulo_qqqq(modul);
    }
    cfac.storlong(0);
    result.storlong(0); sresult.storlong(0);
    result.resizelonu( modul->length +4); sresult.resizelonu( modul->length +4);//hier erhoehen!!!
    if(fak1->compare(&cfac) == 0) {wipezero(); return 0;}
    if(compare(&cfac) == 0) {wipezero(); return 0;}
    cfac.copynum(this);

    hibitm=fak1->get_hibit();
    if(hibitm == 0)
    {
        return 0; //faktor 1
    }
    if(hibitm<16) //kobitz expansion is nuts for very small numbers
    {
        return multnum_q(fak1, modul);
    }
    //praeluminarien erledigt
    fak1->kobz_trans(&fa,&fs);
    hibitm=fa.get_hibit();h1=fs.get_hibit();
    if( (hibitm<0)&&(h1<0) )
    {
        //cannot happen! factor is not zero here
        throwout(_("Error in multnum_qqq()"),10);
        return -1;
    }
    if( h1>=0)
    {
        if( (h1>hibitm)) hibitm=h1;
    }
    for(bitzahl=0;bitzahl<=(ulong32)hibitm;bitzahl++)
    {
        if(fa.getbit(bitzahl))
        {
                result.addnum_q(&cfac);
                active =result.cheap_modreduce(modul);
        }
        if(fs.getbit(bitzahl))
        {
                sresult.addnum_q(&cfac);
                active =sresult.cheap_modreduce(modul);
        }
        if(bitzahl<hibitm)
        {
            cfac.shiftoneup_q();
            cfac.cheap_modreduce(modul);
        }
    }
    result.subtrnum_q(&sresult,modul);
    copynum(&result);
    return (int) bitzahl;
}
/*********************************************/
int longnumber::multnum_qqq_e(longnumber* fak1, longnumber* modul, bool incheck)
//Produkt mit einer longnumber

// to do:  kobitz expansion ausnutzen
// expand kobitz factor
//adapt loop
{

    ulong32 bytezahl;
    long h1,hibyte,hibitm;
    bool active,add,sub;
    int flag;
    ulong32 bysiz;
    unsigned short sh_ad,sh_sb;

    /*if(!modul->israre)
       return(multnum_qqq_e(fak1,modul,incheck));*/
    if(incheck)
    {
        flag=lonumodulo_qqq_e(modul);
        flag=fak1->lonumodulo_qqq_e(modul);
    }
    bysiz=modul->size + 4;
    longnumber cfac(bysiz),result(bysiz+2),sresult(bysiz+2),tmp(bysiz),fs(bysiz),fa(bysiz);
    cfac.storlong(0);
    result.storlong(0); sresult.storlong(0);
    //result.resizelonu( modul->length +4); sresult.resizelonu( modul->length +4);//hier erhoehen!!!
    if(fak1->compare(&cfac) == 0) {wipezero(); return 0;}
    if(compare(&cfac) == 0) {wipezero(); return 0;}
    cfac.copynum(this);

    hibitm=fak1->get_hibit();
    if(hibitm == 0)
    {
        return 0; //faktor 1
    }
    if(hibitm<16) //kobitz expansion is nuts for very small numbers
    {
        return multnum_q(fak1, modul);
    }
    //praeluminarien erledigt
    fak1->kobz_trans(&fa,&fs);
    fa.setsize(); fs.setsize();
    bysiz=fa.size; h1=fs.size;
    if( (bysiz<1)&&(h1<1) )
    {
        //cannot happen! factor is not zero here
        throwout(_("Error in multnum_qqq_f()"),10);
        return -1;
    }
    if( h1>=1)
    {
        if( (h1>bysiz)) bysiz=h1;
    }
    //the loop!!!
    for(bytezahl=0;bytezahl<bysiz;bytezahl+=2)
    {
        sh_ad=*((unsigned short*) (fa.ad+bytezahl));
        sh_sb=*((unsigned short*) (fs.ad+bytezahl));
        if(sh_ad>0)
        {
                result.addnum_om(&cfac,0,sh_ad);
                //active =result.cheap_modreduce(modul);
        }
        if(sh_sb>0)
        {
                sresult.addnum_om(&cfac,0,sh_sb);
                //active =sresult.cheap_modreduce(modul);
        }
        cfac.byteshift(2);
        cfac.lonumodulo_qqq_e(modul);
        if((bytezahl&255)==255)
        {
            if(!result.lazy_modreduce(modul))
               throwout(_("error in lazy_reduce(1)"),3);
            if(!sresult.lazy_modreduce(modul))
               throwout(_("error in lazy_reduce(2)"),3);
        }
    }
    result.subtrnum_q(&sresult,modul);
    copynum(&result);
    return (int) bytezahl;
}
/*********************************************/
int longnumber::multnum_qqq_f(longnumber* fak1, longnumber* modul, bool incheck)
//Produkt mit einer longnumber

// to do:  kobitz expansion ausnutzen
// expand kobitz factor
//adapt loop
{
    longnumber cfac,result,sresult,tmp,fs,fa;
    ulong32 bitzahl;
    long h1,hibitm;
    bool active,add,sub;
    int flag;

    /*if(!modul->israre)
       return(multnum_qqq_e(fak1,modul,incheck));*/
    if(incheck)
    {
        flag=lonumodulo_qqq_e(modul);
        flag=fak1->lonumodulo_qqq_e(modul);
    }
    cfac.storlong(0);
    result.storlong(0); sresult.storlong(0);
    result.resizelonu( modul->length +4); sresult.resizelonu( modul->length +4);//hier erhoehen!!!
    if(fak1->compare(&cfac) == 0) {wipezero(); return 0;}
    if(compare(&cfac) == 0) {wipezero(); return 0;}
    cfac.copynum(this);

    hibitm=fak1->get_hibit();
    if(hibitm == 0)
    {
        return 0; //faktor 1
    }
    if(hibitm<16) //kobitz expansion is nuts for very small numbers
    {
        return multnum_q(fak1, modul);
    }
    //praeluminarien erledigt
    fak1->kobz_trans(&fa,&fs);
    hibitm=fa.get_hibit();h1=fs.get_hibit();
    if( (hibitm<0)&&(h1<0) )
    {
        //cannot happen! factor is not zero here
        throwout(_("Error in multnum_qqqq()"),10);
        return -1;
    }
    if( h1>=0)
    {
        if( (h1>hibitm)) hibitm=h1;
    }
    for(bitzahl=0;bitzahl<=(ulong32)hibitm;bitzahl++)
    {
        if(fa.getbit(bitzahl))
        {
                result.addnum_q(&cfac);
                //active =result.cheap_modreduce(modul);
        }
        if(fs.getbit(bitzahl))
        {
                sresult.addnum_q(&cfac);
                //active =sresult.cheap_modreduce(modul);
        }
        if(bitzahl<hibitm)
        {
            cfac.shiftoneup_q();
            cfac.cheap_modreduce(modul);
            //cfac.lazy_modreduce(modul);
        }
        /*if((bitzahl&15)==15)
        {
            if(!cfac.lazy_modreduce(modul))
               throwout(_("error in lazy_reduce(3)"),3);
        }*/
        if((bitzahl&63)==63)
        {
            if(!result.lazy_modreduce(modul))
               throwout(_("error in lazy_reduce(1)"),3);
            if(!sresult.lazy_modreduce(modul))
               throwout(_("error in lazy_reduce(2)"),3);
        }
    }
    //to Do: try subtr first then modreduce
    /*if(result.compare(&sresult) > 0)
       {
           result.subtrnum_q(&sresult);
       }*/
    result.subtrnum_q(&sresult,modul);
    copynum(&result);
    return (int) bitzahl;
}
/*********************************************/

/*********************************************/
int longnumber::multnum_qqq(longnumber* fak1, longnumber* modul, bool incheck)
//Produkt mit einer longnumber
//neueste!!!

{

    ulong32 bytezahl;
    long32 hibitm;

    int flag;
    ulong32 bysiz;
    unsigned short sh_ad;

    /*if(!modul->israre)
       return(multnum_qqq_e(fak1,modul,incheck));*/
    if(incheck)
    {
        flag=lonumodulo_qqq_e(modul);
        flag=fak1->lonumodulo_qqq_e(modul);
    }
    bysiz=modul->size + 4;
    longnumber cfac(bysiz),result(bysiz+2),tmp(bysiz);
    cfac.storlong(0);
    result.storlong(0);
    //result.resizelonu( modul->length +4); sresult.resizelonu( modul->length +4);//hier erhoehen!!!
    if(fak1->compare(&cfac) == 0) {wipezero(); return 0;}
    if(compare(&cfac) == 0) {wipezero(); return 0;}
    cfac.copynum(this);

    hibitm=fak1->get_hibit();
    if(hibitm == 0)
    {
        return 0; //faktor 1
    }
    if(hibitm<48) //this is nuts for very small numbers
    {
        return multnum_q(fak1, modul);
    }
    bysiz=fak1->size;
    //the loop!!!
    for(bytezahl=0;bytezahl<bysiz;bytezahl+=2)
    {
        sh_ad=*((unsigned short*) ((fak1->ad)+bytezahl));
        if(sh_ad>0)
        {
                result.addnum_om(&cfac,0,sh_ad);
                //active =result.cheap_modreduce(modul);
        }
        cfac.byteshift(2);
        cfac.lonumodulo_qqq_e(modul);
        if((bytezahl&255)==255)
        {
            if(!result.lazy_modreduce(modul))
              throwout(_("Error in Lazymodreduce"));
        }
    }

    result.lonumodulo_qqq_e(modul);
    copynum(&result);
    return (int) bytezahl;
}
/*********************************************/
int longnumber::multnum_qq(longnumber* fak1, longnumber* modul)
//Produkt mit einer longnumber

// to do:  multishift einfuehren
{
    longnumber cfac,result,tmp;
    ulong32 hibitm,bitzahl,shift_debt=0;
    bool active; int flag;

    flag=lonumodulo_qqq(modul);
    flag=fak1->lonumodulo_qqq(modul);
    cfac.storlong(0);
    result.storlong(0);
    result.resizelonu( modul->length +4); //hier erhoehen!!!
    if(fak1->compare(&cfac) == 0) {wipezero(); return 0;}
    if(compare(&cfac) == 0) {wipezero(); return 0;}
    cfac.swapnum(this);

    hibitm=fak1->get_hibit();
    if(hibitm == 0)
    {
        cfac.swapnum(this);
        return 0; //faktor 1
    }

    for(bitzahl=0;bitzahl<=hibitm;bitzahl++)
    {
        if(fak1->getbit(bitzahl))
        {
            cfac.shiftbits_q(shift_debt);
            if(shift_debt==1)
                     cfac.cheap_modreduce(modul);
                     else
                        cfac.lonumodulo_qqq(modul); //wenn mehrfach geshiftet
            result.addnum_q(&cfac);
            //if(shift_debt==1)  // wenn nur 1 geshiftet
                 //active =result.cheap_modreduce(modul);
            //else
            active = result.lonumodulo_qqq(modul); //wenn mehrfach geshiftet
            shift_debt=1; //shiftdebt auf 1 zuruecksetzen
        }
        else
            shift_debt++;
    }
    swapnum(&result);
    return (int) bitzahl;
}
/*********************************************/
int longnumber::count_ones()
{
    long i,cnt=0;

    setsize();
    for(i=0;i<hibit;i++)
    {
        if(getbit(i)) cnt++;
    }
    return ((int)cnt);
}
/*******************************************************/
bool longnumber::un_rare()
{
    if(israre)
    {
        free(asum);
        asum=NULL;
        free(asub);
        asub=NULL;
        israre=false;
    }
    return true;
}
/*******************************************************/
bool longnumber::try_rare()
//only to be called via ellipse function
{
    longnumber ksum,ksub;
    int kres,rarepar;
    unsigned char nonz,sumbyt,subbyt,i;
    unsigned int indx;

    setsize();
    if((size>253)||(size<5)) return false;
    if(israre) return true;
    kres=kobz_trans_byte(&ksum, &ksub);
    ksum.setsize();
    ksub.setsize();
    sumbyt=0;subbyt=0;
    if(ksum.size>0)
    {
      for(i=0;i<ksum.size;i++)
      {
       if( (*(ksum.ad+i))!=0) sumbyt++;
      }
    }
    if(ksub.size>0)
    {
      for(i=0;i<ksub.size;i++)
      {
        if( (*(ksub.ad+i))!=0) subbyt++;
      }
    }
    //now check if is rare
    rarepar=(size>>1)/(sumbyt+subbyt);
    if(rarepar<1)  //todo set to 2 or three later
    {
        return false;
    }
    else // rarefy
    //throwout(_("rarefying!"),1); //spaeter weg
    {
        //count nonzero bytes in sum
        nonz=sumbyt;
        asum=(unsigned char*)malloc(2*(unsigned int)nonz+1);
        *asum=(unsigned char)nonz;
        indx=1;
        for(i=0;i<ksum.size;i++)
        {
          if( (*(ksum.ad+i))!=0)
          {
             *(asum+indx)=(unsigned char)i;
             *(asum+indx+1)=(*(ksum.ad+i));
             indx+=2;
          }
        }
        //count nonzero bytes in sub
        nonz=subbyt;
        asub=(unsigned char*)malloc(2*nonz+1);
        *asub=(unsigned char)nonz;
        indx=1;
        for(i=0;i<ksub.size;i++)
        {
          if( (*(ksub.ad+i))!=0)
          {
             *(asub+indx)=(unsigned char)i;
             *(asub+indx+1)=(*(ksub.ad+i));
             indx+=2;
          }
        }
        israre=true;
        return true;
    }
}
/*********************************************/
int longnumber::kobz_trans(longnumber* ksum, longnumber* ksub)
{
    int gain;
    ulong32 i,strt,bpos;
    bool currbit,inchain=false;
    long hl1;
    unsigned int mycache=0;
    unsigned char offs,cachecnt,newbyte;

    setsize();
    if (size+1>=length) resizelonu(length+2); //in case no leading zerobyte, make one
    //dummy ops
    ksum->copynum(this);
    ksum->resizelonu(length+1);
    ksub->storlong(0);
    ksub->resizelonu(length+1);
    //put true obs here
    hl1=get_lowest_one();
    if(hl1==-1) return -1; //error input is zero! do nothing but return two zeroes
    strt=(ulong32) hl1;
    bpos=strt>>3;//byteadress
    offs=(unsigned char) (strt&7);
    mycache= *((unsigned int *)(ad+bpos));
    cachecnt=16;
    mycache>>=offs;
    cachecnt -= offs;
    for(i=strt;i<=(ulong32)hibit+1;i++)
    {
        //check for chain
        currbit=mycache&1;  //getbit(i);
        if(!inchain)
        {
            if(currbit)
            {
                if((mycache&2)&&(mycache&4)) //if(getbit(i+1)&&getbit(i+2)) //startchain
                {
                    inchain=true;
                    //deposit -1
                    ksub->setbit(i,true);
                    ksum->setbit(i,false);
                }
            }
            else
            {
                //leave 1 or zero, do nothin and continue

            }
        }
        else  //in inchain
        {
            if(currbit)
            {
                //convert 1 to zero
                ksum->setbit(i,false);
            }
            else  //zerobit, chain might end
            {
                //case more than one zero to follow
                if(!(mycache&2))  //        if(!getbit(i+1)) //train of at least two zeroes
                {
                    //set zero to one
                    ksum->setbit(i,true);
                    inchain = false;
                }
                else //overnext is a one
                {
                    //is it singular?
                    if(!(mycache&4))   //     if(!getbit(i+2)) //it is singular!
                    {
                        //also end chain
                        //set zero to one in sum and leave 0 in sub
                        ksum->setbit(i,true);
                        inchain = false;
                    }
                    else  //it is not singular!
                    {
                        //set 1 in subtrahend, leave zero in sum and stay in chain
                        ksub->setbit(i,true);
                    }
                }
            }
        }
        cachecnt--;
        mycache>>=1;
        if(cachecnt==8)
        {
            //oberes byte neu fuellen
            newbyte = *(ad + (i>>3) +2);
            *(((unsigned char *) &mycache)+1)=newbyte;
            cachecnt+=8;
        }
    }
#ifdef DEBUG_LONU
    gain= count_ones();
    gain -= ksum->count_ones();
    gain -= ksub->count_ones();



    longnumber kbtot;
    kbtot.copynum(ksum);
    kbtot.subtrnum(ksub);
    if(compare(&kbtot)!=0) throwout(_("Error, Transformation incorrect"));
    return gain;
#endif

    return 0;//gain;
}
/*********************************************/
/*********************************************/
int longnumber::kobz_trans_byte(longnumber* ksum, longnumber* ksub)
{
    int gain=0;
    ulong32 i,fsiz;
    bool inchain=false;
    unsigned char currbyte,nextbyte,ovrnxtbyte;

    setsize();
    fsiz=size;
    if (size+3>=length) resizelonu(size+3); //ensure two leading zeroes
    ksum->copynum(this);
    ksum->resizelonu(length+1);
    ksub->storlong(0);
    ksub->resizelonu(length+1);
    //search for successive ff with nonzero top- if no return plain
    if(size<3) return 0; //transformation does not make sense!
    currbyte=*(ad);
    nextbyte=*(ad+1);
    for(i=0;i<fsiz;i++)
    {
        ovrnxtbyte=*(ad+i+2);
        //check for chain
        if(!inchain)
        {
            if(currbyte==255)
            {
                if((nextbyte==255)&&(ovrnxtbyte!=0)) //start chain
                {
                    inchain=true;
                    ksub->incrpos(i);
                    *((ksum->ad) + i)=0;
                    inchain=true;
                }
            }
        }
        else  //in inchain
        {
            if(currbyte==255)
            {
                //convert 1 to zero
                *((ksum->ad) + i)=0;
                gain++;
            }
            else  //non 255 byte, chain ends
            {
                ksum->incrpos(i);
                inchain=false;
            }
        }
        currbyte=nextbyte;
        nextbyte=ovrnxtbyte;

    }
    if(inchain) ksum->incrpos(fsiz);
#ifdef DEBUG_LONU
    longnumber kbtot;
    kbtot.copynum(ksum);
    kbtot.subtrnum_q(ksub);
    if(compare(&kbtot)!=0) throwout(_("Error, Transformation incorrect"));
#endif

    return gain;
}
/*********************************************/
int longnumber::multnum_l1(longnumber* fak1)
//Produkt mit einer longnumber
{
  ulong32 zind,ind1, ind2,newsiz;
  ulong32 h2;
  unsigned long long wsto,lwsto;
  unsigned short carry=0;

  if(!fak1->trusiz) fak1->setsize();
  if(!trusiz) setsize();
  newsiz=((2+(fak1->size) + size)>>2)<<2; //durch 4 teilb
  //beide faktoren mit je vier kopfnullen ausstatten
  if(length<size+4) resizelonu(size+4);
  if(fak1->length < (fak1->size+4)) fak1->resizelonu(fak1->size +4);

  longnumber hlp(newsiz+4);

  if(newsiz+4>length)
  {
     //throwout("warning, range extended");
     if(!resizelonu(newsiz+4)) {throwout(_("ERROR"));return -1;}
  }
  for(zind=0;zind<(1+size+fak1->size)/2;zind+=2)
  {
        ind1=0; ind2=zind<<1;
        //jump to first nonzero
        while(ind2> fak1->size-1)
        {
            //wippe runtersetzen
            //
            ind2-=4;
            ind1 += 4;
        }//startposition erreicht jetzt kippen bis ind2=0 oder ind1 ==size
        lwsto=wsto=0; //initialize intermediates
        while((ind1<size+2)&&(ind2<=(zind<<3)))  //secnd condition tests >=0 for ulong32
        {
            wsto+= (unsigned long long) *((ulong32 *) (ad+ind1))
                   * (unsigned long long) *((ulong32 *) ((fak1->ad)+ind2));
            if(wsto<lwsto) carry++;
            lwsto=wsto;

            //incr indices aka tilt seasaw
            ind1 +=4;
            ind2 -=4;
        }
        //seasaw cycle complete, now stor into resultnumber "hlp"
        h2=(ulong32) wsto;
        if(h2>0)
        {
            if(!hlp.pushlong(zind<<1, h2)) throwout(_("error in pushlong"));
            //if(!hlp.trusiz) hlp.setsize();
        }
        h2= (ulong32) (wsto>>32);
        if(h2>0)
        {
            if(!hlp.pushlong(4 + (zind<<1), h2)) throwout(_("Error in pushlong"));
            //if(!hlp.trusiz)hlp.setsize();
        }
        if(carry>0)
        {
            if(!hlp.pushshort(8+ (zind<<1), carry)) throwout(_("error from pushshort"));
            //if(!hlp.trusiz)hlp.setsize();
            carry=0;
        }
        lwsto=wsto=0; //reinitialize intermediates
  }
  copynum(&hlp);
  setsize();
  return 0;
}
/****************************************************************************/
/*********************************************/
int longnumber::k_mult_l1(longnumber* fak1, unsigned int thresh)
//Karatsuba Produkt
{
  ulong32 newsiz;

  if(!fak1->trusiz) fak1->setsize();
  if(!trusiz) setsize();

  if((fak1->size < thresh)||(size < thresh)) //refer to normal l1 procedure
  {
      return multnum_l1(fak1);
  }

  newsiz=((2+(fak1->size) + size)>>2)<<2; //durch 4 teilb
  //beide faktoren mit je vier kopfnullen ausstatten
  if(length<size+4) resizelonu(size+4);
  if(fak1->length < (fak1->size+4)) fak1->resizelonu(fak1->size +4);

  //longnumber hlp(newsiz+4);

  if(newsiz+4>length)
  {
     //throwout("warning, range extended");
     if(!resizelonu(newsiz+4)) {throwout(_("ERROR"));return -1;}
  }
  //after preparations now the Karatsuba core
  //determine splitpoint
  ulong32 spp,sppy;

  spp= fak1->size >> 1;  //halbieren der size
  sppy= size >> 1;
  if(sppy>spp)spp=sppy; //sppx is max of both

  longnumber z1(2*spp+4),z2(2*spp+8),z3(size + fak1->size -2*spp +4 ),x0(spp+4),x1(fak1->size-spp+4),y0(spp+4),y1(size-spp+4),hln(spp+4);
   //set vars x from fak1 y from lonu
  memcpy(x0.ad, fak1->ad, spp); x0.setsize(true);
  memcpy(x1.ad, fak1->ad+spp, fak1->size-spp); x1.setsize(true);
  memcpy(y0.ad, ad, spp); y0.setsize(true);
  memcpy(y1.ad, ad+spp, size-spp); y1.setsize(true);

  z1.copynum(&x0);
  z1.k_mult_l1(&y0); //z1 is set
  //z1.multnum_l1(&y0); //only for deb
  z3.copynum(&x1);
  z3.k_mult_l1(&y1); //z3 is set
  //z3.multnum_l1(&y1); //only 1 step for deb
  hln.copynum(&y0);
  hln.addnum_q(&y1);
  z2.copynum(&x0);
  z2.addnum_q(&x1);
  z2.k_mult_l1(&hln);
  //z2.multnum_l1(&hln); //only for deb
  z2.subtrnum_q(&z1);
  z2.subtrnum_q(&z3);
  // richtig gephast nach hlp transferieren
  copynum(&z1);
     //z2.shiftbits_q(8*spp);
     //z2.setsize(true);
     //hlp.addnum_q(&z2);
  addnum_om(&z2, spp);
     //z3.shiftbits_q(16*spp);
     //z3.setsize(true);
     //hlp.addnum_q(&z3);

  addnum_om(&z3, 2*spp );
  //copynum(&hlp);
  setsize();
  return 0;
}
/****************************************************************************/
/*********************************************/
int longnumber::multnum_l1(longnumber* fak1, longnumber* modul, longnumber* bufflong)
//Produkt mit einer longnumber
{
  ulong32 zind,ind1, ind2,newsiz;
  ulong32 h2;
  unsigned long long wsto,lwsto;
  unsigned short carry=0;
  bool ownbuff;
  longnumber *hlp;

  if(!fak1->trusiz) fak1->setsize(true);
  if(!trusiz) setsize(true);
  if(fak1->size ==0)
  {
      wipezero();
      return 0;
  }

  newsiz=((2+(fak1->size) + size)>>2)<<2; //durch 4 teilb
  if(bufflong==NULL) //make new buffer
  {
      hlp= new longnumber(newsiz+12);
      ownbuff=true;
      bufflong=hlp;
  }
  else
  {
      ownbuff=false;
      bufflong->wipezero();
      if(bufflong->length<newsiz+12)  bufflong->resizelonu(newsiz+12);
      //hlp=bufflong;
  }


 //beide faktoren mit je vier kopfnullen ausstatten
  if(length<size+12) resizelonu(size+12);
  if(fak1->length < (fak1->size+12)) fak1->resizelonu(fak1->size +12);

  for(zind=0;zind<((1+size+fak1->size)>>1);zind+=2)
  {
        ind1=0; ind2=zind<<1;
        //jump to first nonzero
        while(ind2+1> fak1->size)
        {
            //wippe runtersetzen
            //
            ind2-=4;
            ind1 += 4;
        }//startposition erreicht jetzt kippen bis ind2=0 oder ind1 ==size
        lwsto=wsto=0; //initialize intermediates
        while((ind1<size+2)&&(ind2<=(zind<<3)))  //secnd condition tests >=0 for ulong32
        {
            wsto+= (unsigned long long) *((ulong32 *) (ad+ind1))
                   * (unsigned long long) *((ulong32 *) ((fak1->ad)+ind2));
            if(wsto<lwsto) carry++;
            lwsto=wsto;

            //incr indices aka tilt seasaw
            ind1 +=4;
            ind2 -=4;
        }
        //seasaw cycle complete, now stor into resultnumber "hlp"
        h2=(ulong32) wsto;
        if(h2>0)
        {
            if(!bufflong->pushlong(zind<<1, h2)) throwout(_("error in pushlong"));
            //if(!hlp.trusiz) hlp.setsize();
        }
        h2= (ulong32) (wsto>>32);
        if(h2>0)
        {
            if(!bufflong->pushlong(4 + (zind<<1), h2)) throwout(_("Error in pushlong"));
            //if(!hlp.trusiz)hlp.setsize();
        }
        if(carry>0)
        {
            if(!bufflong->pushshort(8+ (zind<<1), carry)) throwout(_("error from pushshort"));
            //if(!hlp.trusiz)hlp.setsize();
            carry=0;
        }
        lwsto=wsto=0; //reinitialize intermediates
  }
  bufflong->lonumodulo_qqq_e(modul);
  bufflong->setsize();
  copynum(bufflong);
  if(ownbuff) delete(hlp);
  return 0;
}
/****************************************************************************/
/*********************************************/
int longnumber::k_mult_l1(longnumber* fak1, longnumber* modul, longnumber* bufflong)
//Produkt mit einer longnumber
{
  ulong32 zind,ind1, ind2,newsiz;
  ulong32 h2;
  unsigned long long wsto,lwsto;
  unsigned short carry=0;
  bool ownbuff;
  longnumber *hlp;

  if(!fak1->trusiz) fak1->setsize(true);
  if(!trusiz) setsize(true);
  if(fak1->size ==0)
  {
      wipezero();
      return 0;
  }

  newsiz=((2+(fak1->size) + size)>>2)<<2; //durch 4 teilb
  if(bufflong==NULL) //make new buffer
  {
      hlp= new longnumber(newsiz+12);
      ownbuff=true;
      bufflong=hlp;
  }
  else
  {
      ownbuff=false;
      bufflong->wipezero();
      if(bufflong->length<newsiz+12)  bufflong->resizelonu(newsiz+12);
      //hlp=bufflong;
  }


 //beide faktoren mit je vier kopfnullen ausstatten
  if(length<size+12) resizelonu(size+12);
  if(fak1->length < (fak1->size+12)) fak1->resizelonu(fak1->size +12);

  for(zind=0;zind<((1+size+fak1->size)>>1);zind+=2)
  {
        ind1=0; ind2=zind<<1;
        //jump to first nonzero
        while(ind2+1> fak1->size)
        {
            //wippe runtersetzen
            //
            ind2-=4;
            ind1 += 4;
        }//startposition erreicht jetzt kippen bis ind2=0 oder ind1 ==size
        lwsto=wsto=0; //initialize intermediates
        while((ind1<size+2)&&(ind2<=(zind<<3)))  //secnd condition tests >=0 for ulong32
        {
            wsto+= (unsigned long long) *((ulong32 *) (ad+ind1))
                   * (unsigned long long) *((ulong32 *) ((fak1->ad)+ind2));
            if(wsto<lwsto) carry++;
            lwsto=wsto;

            //incr indices aka tilt seasaw
            ind1 +=4;
            ind2 -=4;
        }
        //seasaw cycle complete, now stor into resultnumber "hlp"
        h2=(ulong32) wsto;
        if(h2>0)
        {
            if(!bufflong->pushlong(zind<<1, h2)) throwout(_("error in pushlong"));
            //if(!hlp.trusiz) hlp.setsize();
        }
        h2= (ulong32) (wsto>>32);
        if(h2>0)
        {
            if(!bufflong->pushlong(4 + (zind<<1), h2)) throwout(_("Error in pushlong"));
            //if(!hlp.trusiz)hlp.setsize();
        }
        if(carry>0)
        {
            if(!bufflong->pushshort(8+ (zind<<1), carry)) throwout(_("error from pushshort"));
            //if(!hlp.trusiz)hlp.setsize();
            carry=0;
        }
        lwsto=wsto=0; //reinitialize intermediates
  }
  bufflong->lonumodulo_qqq_e(modul);
  bufflong->setsize();
  copynum(bufflong);
  if(ownbuff) delete(hlp);
  return 0;
}
/****************************************************************************/
/*********************************************/
int longnumber::quadmodul_l1(longnumber* modul,longnumber* hlpin)
//Produkt mit einer longnumber
{
  ulong32 zind,ind1, ind2,newsiz;
  ulong32 h2;
  unsigned long long v,wsto,lwsto;
  unsigned short carry=0;
  longnumber *hlp;

  if(!trusiz)setsize();
  newsiz=((2+(size<<1))>>2)<<2; //durch 4 teilb
  if(newsiz<8) newsiz=8;   //prevent small number error

  //if necessary allocate buffernumber
  if(hlpin==NULL)
  {
      hlp=new longnumber(newsiz+4);
  }
  else hlp=hlpin;
  //end of allocation job

  if(newsiz+4>hlp->length)
  {
     //throwout("warning, range extended");
     if(!hlp->resizelonu(newsiz+4)) {throwout(_("ERROR"));return -1;}
  }
  hlp->wipezero();


  for(zind=0;zind<(1+(size<<1))/2;zind+=2) //Wippenlagerindex
  {
        ind1=0; ind2=zind<<1;
        //jump to first nonzero
        while(ind2+1> size)
        {
            //wippe runtersetzen
            //
            ind2-=4;
            ind1 += 4;
        }//startposition erreicht jetzt kippen bis ind2=0 oder ind1 ==size
        lwsto=wsto=0; //initialize intermediates
        while((ind1<=ind2)&&(ind1<size+2)&&(ind2<=(zind<<3)))  // seasaw shall mostly reach level
        {
            v= (unsigned long long) *((ulong32 *) (ad+ind1))
                   * (unsigned long long) *((ulong32 *) (ad+ind2));
            wsto+=v;
            if(wsto<lwsto) carry++;
            lwsto=wsto;
            if(ind1!=ind2)
            {
                //add again
                wsto+=v;
                if(wsto<lwsto) carry++;
                lwsto=wsto;
            }

            //incr indices aka tilt seasaw
            ind1 +=4;
            ind2 -=4;
        }
        //seasaw cycle complete, now stor into resultnumber "hlp"
        h2=(ulong32) wsto;
        if(h2>0)
        {
            if(!hlp->pushlong(zind<<1, h2)) throwout(_("error in pushlong"));
            //if(!hlp.trusiz) hlp.setsize();
        }
        h2= (ulong32) (wsto>>32);
        if(h2>0)
        {
            if(!hlp->pushlong(4 + (zind<<1), h2)) throwout(_("Error in pushlong"));
            //if(!hlp.trusiz)hlp.setsize();
        }
        if(carry>0)
        {
            if(!hlp->pushshort(8+ (zind<<1), carry)) throwout(_("error from pushshort"));
            //if(!hlp.trusiz)hlp.setsize();
            carry=0;
        }
        lwsto=wsto=0; //reinitialize intermediates
  }
  hlp->lonumodulo_qqq_e(modul);
  hlp->setsize();
  copynum(hlp);
    //ggf free buffer
  if(hlpin==NULL)
     delete(hlp);

  return 0;
}
/****************************************************************************/
int longnumber::quadmodul_l(longnumber* modul,longnumber *hlpin)
//hlp sollte gut die doppelte größe wie this haben
{
  ulong32 ind1, ind2,newsiz, bytepos;
  ulong32 h1,h2;
  unsigned long long v;
  int i;
  unsigned short carry=0;
  longnumber *hlp;

  setsize();
  newsiz=((2+(size) + size)>>2)<<2; //durch 4 teilb
  if(newsiz<8) newsiz=8;   //prevent small number error

  //if necessary allocate buffernumber
  if(hlpin==NULL)
  {
      hlp=new longnumber(newsiz+4);
  }
  else hlp=hlpin;
  //end of allocation job

  if(newsiz+4>hlp->length)
  {
     //throwout("warning, range extended");
     if(!hlp->resizelonu(newsiz+4)) {throwout(_("ERROR"));return -1;}
  }
  hlp->wipezero();
  for(ind1=0;ind1<size;ind1+=4)
  {
    for(ind2=0;ind2<ind1;ind2+=4)
    {
       bytepos=ind1+ind2;
       h1=  *((ulong32*)(ad+ind1));
       h2= *((ulong32*)(ad+ind2));
       v=(unsigned long long) h1 * (ulong32) h2;
       h1= (ulong32) v;
       h2= (ulong32) (v>>32); //upper long
       if(!hlp->pushlong(bytepos, h1))
       {
           throwout(_("error in multnum_la"));
           //ggf free buffer
           if(hlpin==NULL) delete(hlp);
           return -1;
       }
       if(!hlp->pushlong(bytepos+4, h2))
       {
           throwout(_("error in multnum_lb"));
           if(hlpin==NULL) delete(hlp);
           return -1;
       }
    }
  }
  hlp->shiftoneup_q();
  for(ind1=0;ind1<size;ind1+=4)
  {
       bytepos=ind1<<1;
       h1=  *((ulong32*)(ad+ind1));
       v=(unsigned long long) h1 * (ulong32) h1;
       h1= (ulong32) v;
       h2= (ulong32) (v>>32); //upper long
       if(!hlp->pushlong(bytepos, h1))
       {
           throwout(_("error in multnum_la"));
           if(hlpin==NULL) delete(hlp);
           return -1;
       }
       if(!hlp->pushlong(bytepos+4, h2))
       {
           throwout(_("error in multnum_lb"));
           if(hlpin==NULL) delete(hlp);
           return -1;
       }
  }
  hlp->lonumodulo_qqq_e(modul);
  hlp->setsize();
  copynum(hlp);
//ggf free buffer
  if(hlpin==NULL)
     delete(hlp);
  return 0;
}
/*********************************************/
int longnumber::multnum_l(longnumber* fak1, longnumber* modul,longnumber *bufflong)
//Produkt mit einer longnumber
{
  ulong32 ind1, ind2,newsiz, bytepos;
  ulong32 h1,h2;
  unsigned long long v;
  unsigned short carry=0;
  bool ownbuff;
  longnumber *hlp;


  fak1->setsize();
  setsize();
  newsiz=((2+(fak1->size) + size)>>2)<<2; //durch 4 teilb
  if(bufflong==NULL) //make new buffer
  {
      hlp= new longnumber(newsiz+4);
      bufflong=hlp;
      ownbuff=true;
  }
  else
  {
      ownbuff=false;
      bufflong->wipezero();
      if(bufflong->length<newsiz+4)  bufflong->resizelonu(newsiz+4);
  }
  for(ind1=0;ind1<size;ind1+=4)
  {
    for(ind2=0;ind2<fak1->size;ind2+=4)
    {
       bytepos=ind1+ind2;
       h1=  *((ulong32*)(ad+ind1));
       h2= *((ulong32*)(fak1->ad+ind2));
       v=(unsigned long long) h1 * (ulong32) h2;
       h1= (ulong32) v;
       h2= (ulong32) (v>>32); //upper long
       if(!bufflong->pushlong(bytepos, h1))
       {
           throwout(_("error in multnum_la"));
           return -1;
       }
       if(!bufflong->pushlong(bytepos+4, h2))
       {
           throwout(_("error in multnum_lb"));
           return -1;
       }
    }
  }
  bufflong->lonumodulo_qqq_e(modul);
  bufflong->setsize();
  copynum(bufflong);
  if(ownbuff) delete(hlp);
  return 0;
}
/*********************************************/
int longnumber::multnum_l(longnumber* fak1)
//Produkt mit einer longnumber
{
  ulong32 ind1, ind2,newsiz, bytepos;
  ulong32 h1,h2;
  unsigned long long v;

  if(!fak1->trusiz) fak1->setsize();
  if(!trusiz) setsize();
  newsiz=((2+(fak1->size) + size)>>2)<<2; //durch 4 teilb
  longnumber hlp(newsiz+4);

  if(newsiz+4>length)
  {
     //throwout("warning, range extended");
     if(!resizelonu(newsiz+4)) {throwout(_("ERROR"));return -1;}
  }
  for(ind1=0;ind1<size;ind1+=4)
  {
    for(ind2=0;ind2<fak1->size;ind2+=4)
    {
       bytepos=ind1+ind2;
       h1=  *((ulong32*)(ad+ind1));
       h2= *((ulong32*)(fak1->ad+ind2));
       v=(unsigned long long) h1 * (ulong32) h2;
       h1= (ulong32) v;
       h2= (ulong32) (v>>32); //upper long
       if(!hlp.pushlong(bytepos, h1))
       {
           throwout(_("error in multnum_la"));
           return -1;
       }
       if(!hlp.pushlong(bytepos+4, h2))
       {
           throwout(_("error in multnum_lb"));
           return -1;
       }
    }
  }
  copynum(&hlp);
  setsize();
  return 0;
}
/*********************************************/

/*********************************************/
int longnumber::multnum(longnumber* fak1)
//Produkt mit einer longnumber

{

  ulong32 ind1, ind2,newsiz, bytepos;
  unsigned char buffer[257];
  unsigned char h1,h2;
  unsigned char *adhlp;
  int i;
  unsigned short carry=0;

  adhlp=&(buffer[0]);
  for(i=0;i<256;i++) *(adhlp + i)=0;
  fak1->setsize();
  setsize();
  newsiz=(fak1->size + size);
  if(newsiz>256)
  {
    //throwout(_("warning: \nlarge size slows down"));
    adhlp = (unsigned char *) malloc(newsiz);
    for(ind1=0;ind1<newsiz;ind1++) *(adhlp+ind1)=0;
  }
  if(newsiz>length)
  {
     //throwout("warning, range extended");
     if(!resizelonu(newsiz)) {throwout(_("ERROR"));return -1;}
  }
  for(ind1=0;ind1<size;ind1++)
  {
    for(ind2=0;ind2<fak1->size;ind2++)
    {
       bytepos=ind1+ind2;
       h1= (unsigned char) *(ad+ind1);
       h2= (unsigned char) *(fak1->ad+ind2);
       carry = (unsigned short)h1*(unsigned short)h2;
       h1= (unsigned char) (carry & 255);
       if(!squeezebyte(h1,adhlp,bytepos,newsiz))
           throwout(_("squeeze ERROR a"));

       h1= (unsigned char) (carry>>=8);
       if(!squeezebyte(h1,adhlp,bytepos+1,newsiz))
           throwout(_("squeeze ERROR b"));

    }
  }
  for(ind1=0;ind1<newsiz;ind1++)
  {
    *(ad+ind1)=
       *(adhlp+ind1);
  }
  trusiz=false;
  if(newsiz>256) free((char*)adhlp);
  return 0;
}

/*********************************************/
bool longnumber::squeezebyte(unsigned char h1,unsigned char* adhlp,ulong32 bytepos,ulong32 maxpos)
  //quetscht ein byte in eine longnumberadresse
{
  unsigned short carry=0;
  unsigned char h2;

  while((h1 != 0)&&(bytepos <= maxpos))
  {
    h2= *(adhlp+ bytepos);
    carry = (unsigned short)h2 + (unsigned short)h1;
    //carry=0;
    //carry+=h2+h1;
    *(adhlp+ bytepos)= (unsigned char) (carry&255);
    carry >>= 8;  //  /= 256;
    h1= (unsigned char) (carry&255);
    bytepos++;
  }
  if(h1 != 0)
  {
    throwout(_("ERROR in sqeeze"));
    return false;
  }
  //trusiz=false;
  return true;
}
/*********************************************/
double longnumber::dconvert()
{
  double res=0, fakt=1;
  ulong32 indx;

  shrinktofit();

  if(size==0) return 0;
  for(indx=0;indx<size;indx++)
  {
    res += fakt * (double)*(ad + indx);
    fakt*=256;
  }
  throwout(_("longnumber converted"));
  return(res);
}
/**********************************************/
bool longnumber::lonu_from_lodoub(long double z)
  // wandelt long double in longnumber um longnumber ist "floor": i.e.0 for 0.99
{
  long double h1,h2;
  ulong32 indx,losiz;
  unsigned char zw;

  if(z<0) return false;
  if(z< 65536) {storlong((ulong32) floor(z)); return true;}

  h1= log(z)/log(256.0);
  losiz= (ulong32) ceil(h1);
  if(!resizelonu(losiz+1)) return false; //jetzt ist der Platz da!
  *(ad+losiz) = 0; //höchstes byte auf 0
  indx=losiz;
  h2=pow(256.0,losiz-1);
  while(indx!=0)
  {
     indx--;
     zw = (unsigned char) floor((z / h2));
     *(ad+indx)= zw;
     z -= zw * h2;
     h2 /= 256.0;
  }
  trusiz=false;
  setsize();
  return true;
}
/*********************************************/
bool longnumber::sqrtnum(longnumber *pstart)
// errechnet die Quadratwurzel nach Newtonverfahren(ohne modul)
// gibt true, wenn ein sauberes quadrat ist, false sonst
//setzt longnumber auf groesste ganze Zahl kleiner der Wurzel
{
bool lo=true,krit=true,lastlo=true,hbol;
longnumber diff, step, lsq, t,zwei,h2, lobo, hibo,laststep;
long double h1,hr;
int flag;
ulong32 i1,i2;

zwei.storlong(2);
laststep.storlong(13);

if(pstart==NULL) //selber startwert finden
{
  setsize();
  if(lodoub_from_lonu(&h1))
  {
    hr=sqrt(h1);
    lsq.lonu_from_lodoub(hr); //erster Schätzwert gefunden
  }
  else{
    shrinktofit();
    lsq.copynum(this);
    if(size < 6)
    {
        throwout(_("error in sqrt routine 8-O"));
        return false;
    }
    //gerade zahl bytes heruntersatzen
    i1=size;
    if(i1&1)  //ungerade
    {
        i1=5;
        lsq.shiftbits_q(-(size-i1)<<3);
        hbol=lsq.sqrtnum();
        lsq.shiftbits_q((size-i1)<<2);
    }
    else //gerade
    {
        i1=4;
        lsq.shiftbits_q(-(size-i1)<<3);
        hbol=lsq.sqrtnum();
        lsq.shiftbits_q((size-i1)<<2);
    }
    //wurzelziehen
    //halbe zahl wieder hochsezuen
    //lsq.setsize();
    //lsq.resizelonu(lsq.size/2,0);
    //lsq.shrinktofit();
  }
}
else //Startparameter übernehmen
{
    lsq.copynum(pstart);
}
lobo.storlong(1); //Wurzel ist mindestens 1
hibo.copynum(this); // Wurzel ist höchstens originalzahl

do {
     t.copynum(&lsq);
     //t.shrinktofit();
     t.multnum_l1(&t);
     flag = compare(&t);
     if(flag == 0)
     {
         copynum(&lsq);
         return true;
     }
     if(flag == 1)// t zu klein
     {
         lastlo=lo;
         lo=true;
         diff.copynum(this);
         diff.subtrnum_q(&t);
         diff.setsize();
         //diff.shrinktofit();
         if(lobo.compare(&lsq) == -1)  lobo.copynum(&lsq);
     }
     if(flag == -1) //t zu gross
     {
         lastlo=lo;
         lo= false;
         diff.copynum(&t);
         diff.subtrnum_q(this);
         diff.setsize();
         //diff.shrinktofit();
         if(hibo.compare(&lsq) ==1) hibo.copynum(&lsq);
     }
     step.copynum(&diff); //y-Differenz nach step: dx = dy*2*x^1/2
     //step.divnum_qqq_e(&zwei,&h2); //durch 2

     //step.multnum(this);  // mal x (das quadrat)
     step.setsize();
     if(lsq.hibit==-1) //avoid div by zero
     {
         step.copynum(&lobo);
         step.addnum_q(&hibo);
         step.shiftbits_q(-1);
     }
     else
     {
        step.divnum_qqq_e( &lsq,&h2); //durch die bisher geschaetzte Wurzel
     }
     step.setsize(true);

     //step.setsize();
     //step.shrinktofit();
     //step smaller if decreasing
     /*if(!lo)
     {
         step.shiftonedown_q();
     }*/
     step.inc(); step.inc();
     step.setsize();
     if(step.compare(&zwei)==0) step.inc();
     //step.setsize();
     step.dec(); step.dec();
     step.setsize();
     if(step.hibit >0) step.shiftonedown_q(); //schneller div 2
     //check for stalled
     if(laststep.compare(&step)==0) //repeated steps are sign for stallment
     {
         if(lastlo ^ lo) //idle pingpong
         {
             //throwout(_("idle pingpong to be resolved"),1);
             step.copynum(&hibo);
             step.subtrnum_q(&lobo);
             step.shiftbits_down(1);
             step.setsize();   //step set to mid of interval
         }
         else
         {
             //throwout(_("snailmode encountered-> resolve!"),1);
             step.copynum(&hibo);
             step.subtrnum_q(&lobo);
             step.shiftbits_down(1);
             step.setsize();     //step set to mid of interval
         }
     }

     laststep.copynum(&step);
     if(lo) lsq.addnum_q(&step);
     else lsq.subtrnum_q(&step);
     //lsq.shrinktofit();

     lobo.inc();
     if(hibo.compare(&lobo)==0) krit = false;
     lobo.dec();
   } while (krit);
   //if(!lo) lsq.dec(); //wenn quad zu gross, um eins kleinere Zahl ausgeben
   copynum(&lobo);
   lobo.shrinktofit();
   return false;
}
/**********************************************/
 bool longnumber::sqrtest()
 {
     bool flag;
     longnumber init;

     storlong(876543210);
     //init.copynum(this);

     multnum_q(this);
     multnum_q(this);
     multnum_q(this);
     multnum_q(this);
     multnum_q(this);
     init.copynum(this);
     multnum_q(this);
     //inc(); inc();
     setsize();

     flag = sqrtnum();
     if(!flag)
     {
         throwout(_("trueroot not found :-(  "));
     }
     else{
             throwout(_("trueroot found :-))  "));
        }
     if( compare(&init) == 0) throwout(_("calculated correctly"));
             else throwout(_("falsely calculated !!"));
     return flag;
 }
/**********************************************/
bool longnumber::lodoub_from_lonu(long double *z)
{
  long double res=0, fakt=1, lres;
  ulong32 indx;

  shrinktofit();
  if(size==0)
  {
      *z=0;
      return true;
  }
  fakt = pow( 256, size-1);
  if(fakt == HUGE_VAL)
  {
       return false;
  }
  indx=size;
  while(indx!=0)
  {
    indx--;
    lres=res;
    res += fakt * (long double)*(ad + indx);
    fakt /=256;
    if((lres ==res)||(indx==0))
    {
        *z= res;
        return true;
    }
  }
  //throwout(_("longnumber converted"));
  *z= res;
  return(true);
}
/**********************************************/
//static bool warn=true;
/************************************/
void longnumber::makerandom( int bytenumber)
  // setze zufallszahl mit systemfunktion rnd -> weak!!
  //reine Null wird vermieden
{
   int i;
   bool iszero=true;

   if(bytenumber<0){throwout(_("negative bytenumber does not\nmake sense\nAborting makerandom!"),3); return;}
   if( !resizelonu((ulong32)bytenumber +2,0))
   { throwout(_("err in makerand")); return;}

   for( i = 0;i< bytenumber;i++ )
   {
      *(ad+i)= zuf.get_rbyte();
      //if(warn){ throwout(_("Warning, using weak random numbers")); warn=false;}
      //*(ad+i)= (unsigned char)(rand()) &255;
      if(*(ad+i) != 0) iszero = false;
   }
   *(ad+i)= 0; *(ad+i+1)=0;
   if(iszero) inc();
   setsize(true);
   return;
}
/**********************************************/
/************************************/
void longnumber::makerandom(longnumber *ceil)
  // setze zufallszahl kleiner als ceil
{
   int i;
   bool iszero=true;
   int bytenumber;

   ceil->setsize();
   bytenumber= ceil->size;
   if(bytenumber<0){throwout(_("negative bytenumber does not\nmake sense\nAborting makerandom!"),3); return;}
   if( !resizelonu((ulong32)bytenumber +1,0))
   { throwout(_("err in makerand")); return;}

   for( i = 0;i< bytenumber;i++ )
   {
      *(ad+i)= zuf.get_rbyte();
      //if(warn){ throwout(_("Warning, using weak random numbers")); warn=false;}
      //*(ad+i)= (unsigned char)(rand()) &255;
      if(*(ad+i) != 0) iszero = false;
   }
   *(ad+i)= 0;
   if(iszero) inc();
   if(*(ad+bytenumber-1)>*((ceil->ad)+bytenumber-1)) //when hibyte larger than ceil modreduce
        *(ad+bytenumber-1) %= *((ceil->ad)+bytenumber-1);
   else if(*(ad+bytenumber-1) == *((ceil->ad)+bytenumber-1)) //when hibyte equal
             (*(ad+bytenumber-1))--;
   setsize(true);
   return;
}
/**********************************************/
bool longnumber::isprime(int tries)
  //  fastsicher Primzahl ?
{
  int i;
//  char buff[40];

  if(!primecheaptest(200))return false;
  for(i=0;i<tries;i++)
  {
    if(!maybeprime())
    {
      //sprintf(buff,"nottaprime \nattmpt# %d",i);
      //throwout(buff);
      return false;
    }
    else
    {
      //sprintf(buff,"couldbe_prime \nattmpt# %d",i);
      //throwout(buff);
    }
  }
  return true;
}
/**********************************************/
bool longnumber::primecheaptest(long32 max)
  //  Primzahlvortest  (div 3,5,7,11,13,17,19,23,29,31,37 etc)
{
  long32 i;
  long32 mx2;
  longnumber qln(4),scratch(length);

  setsize();

  if(size<4)
  {
    mx2=(long)lconvert();
    if(mx2<2)return false;
    if(mx2<1000)return erasieve(mx2);
    while(mx2<(max*max))
    {
      max--;
    }
  }
  scratch.copynum(this);
  //scratch.setsize();
  for(i=2;i<max;i++)
  {
    if (erasieve(i))
    {
      scratch.copynum(this);
      qln.storlong((ulong32)i);
      scratch.lonumodulo_qqq_e(&qln);
      scratch.setsize();
      if(scratch.size ==0)
      {
         return false;
      }

      scratch.copynum(this);
    }
  }
  return true;
}
/**********************************************/
bool longnumber::maybeprime()
  //  vielleicht Primzahl ? Test nach Rabin Miller
{
  unsigned int b,j;
  longnumber a,m,z,hlp;
  int randsiz;

  setsize(true);
  if(((*ad)&1) == 0)
  {
    if((size==1)&&(*ad == 2)) return true; // könnte ja einfach die 2 sein
    else return false; //gerade Zahl, das war nix
  }
  if((size==1)&&(*ad<2))return false; // die eins ist keine

  decrpos(0);
  b=0;
  while(!getbit(b)) b++; // niedrigstes bit mit wert 1 (ausser stelle 0)suchen und stelle in b speichern
  if(! m.copynum(this))
        {throwout(_("error isp#1"));return false;}
  m.shiftright(b); // wofür war das nochmal....??
  incrpos(0);
  setsize(true);

  randsiz=(int)size-1; //größe der zufallszahl in byte
  if(randsiz<1) randsiz=1;
  do
  {
    a.makerandom(randsiz); //zufallszahl als witness bestimmen
    a.setsize(true);
  } while((compare(&a) !=1)||(a.size<1)); //nicht gleich testzahl und nicht leer

  j=0;
  z.copynum(&a); //nach z schreiben
  z.pownum_q(&m,this); //z: witness hoch ((2 hoch b) mal testzahl) modulo testzahl
  z.setsize(true);
  if((z.size==1)&&(*(z.ad)==1))return true;//maybeprime if res is 1
  z.incrpos(0);
  if(z.compare(this)==0) return true;//maybeprime if res +1 = testzahl
  z.decrpos(0);
  do
  {
    z.setsize(true);
    if((j>0)&&(z.size==1)&&(*(z.ad)==1))return false; //nottaprime
    j++;
    z.incrpos(0);
    if(j<b)
    {
      if(z.compare(this)!=0)
      {
        z.decrpos(0);
        z.quadmodul_l1(this);
        continue;
      }
      else
      {
        return true;  //maybeprime
      }
    }
    if(j==b)
    {
      if(z.compare(this)!=0) return false; //nottaprime
    }
  }while(j<b);
  return true;
}
/***********************************************************/
  bool longnumber::test3mod4()
  // testet auf den Fall: Zahl ist kongruent 3 modulo 4
  //still to test
  {
      if((*(ad)&3) ==3) return true;
      else return false;
  }
/***********************************************************/
  bool longnumber::root3m4( longnumber* p, longnumber* root, bool losolution)
  // gibt die Quadratwurzel modulo p zurück, wenn p=3 mod 4 und y^2 tats. ein quad
  // still to test

  {
      longnumber rtex,ph,hlp;
      bool lower;

      if(!p->test3mod4()) return false;
      rtex.copynum(p);
      rtex.inc();
      rtex.shiftbits_down(2);
      root->copynum(this);
      root->pownum_q(&rtex,p);
      ph.copynum(p);
      ph.shiftonedown_q();
      if((root->compare(&ph))!=1) lower=true;
      else lower=false;
      if(losolution)
      {
          if(!lower)
          {
            //return p minus number
            hlp.copynum(p);
            hlp.subtrnum_q(root);
            root->copynum(&hlp);
          }
          //test if square
          hlp.copynum(root);
          hlp.quadmodul_l1(p);
          if(hlp.compare(this) ==0 ) return true;
          else return false;
      }
      else //hisolution
      {
          if(lower)
          {
            //return p minus number
            hlp.copynum(p);
            hlp.subtrnum_q(root);
            root->copynum(&hlp);
          }
          //test if square
          hlp.copynum(root);
          hlp.quadmodul_l1(p);
          if(hlp.compare(this) ==0 ) return true;
          else return false;
      }
  }

/**********************************************/
void longnumber::setbit(long32 bitpos, bool val)
{
  ulong32 x;
  unsigned char c,d,e;

  x=(ulong32) (bitpos>>3);
  if((x>(length-1))||(bitpos<0))
       {throwout(_("out of bounds in setbit")); return;}
  d=bitpos&7;
  e= 1<<d; //maske für das bit
  c=*(ad+x);
  if(val)  *(ad+x) |= e; // auf 1 setzen
  else *(ad+x) &= (e ^ 255);  //alle anderen unber. wenn bit 1 => 0, wenn 0 => 1
  if(bitpos >=hibit) trusiz=false;
  return;
}
/**********************************************/
void longnumber::shiftright(ulong32 bshift)
{
  ulong32 ind;

  setsize();
  for(ind=0;ind<8*size-bshift;ind++)
    setbit(ind,getbit(ind+bshift));
  for(ind=8*size-bshift;ind < 8*size; ind++)
    setbit(ind,false);
  trusiz=false;
}
/**********************************************/
bool longnumber::byteshift(long32 offs)
{
    long luft;

    if(offs>0)
    {
        //mach platz
        setsize();
        luft= length-size;
        if(luft< offs +2) resizelonu(size+offs+2); //jetzt ist platz
        //jetzt im turbotempo hoch
        memmove((ad+offs),ad,size);
        //jetzt noch unten nullen
        memset(ad,0,offs);
        trusiz=false;
        setsize();
        return true;
    }
    else
    {
     if(offs<0)
        {
            setsize();
            if(abs(offs) >= ((long32) size)){storlong(0); return true;}//alles weg!
            memmove(ad, ad-offs, size+offs); //jetzt runtergesetzt
            //nun oben nullen
            memset(ad+size+offs,0,-offs);
            trusiz=false;
            setsize();
            return true;
        }
      else return false;
    }
    return false; //hier niemals ankommen!
}
/**********************************************/
void longnumber::shiftbits_down(long32 offs)
{
  ulong32 ind,stinx;
  long byshift;
  char bitshift;
  register ulong32 scratch;
  unsigned char mask=0,plug;

  if(offs==0) return;
  setsize();
  //auftrennen in byteshift und bitshift
  byshift= offs >> 3; //die anzahl bytes der Verschiebung durch 8
  if(byshift!=0)  byteshift(-byshift);
  bitshift= offs & 7; //unterste 3 bit
  if(bitshift==0) return; // alles easy
  //if(negative) bitshift+=8; // muss dann spaeter nochmal eins runtergesetzt werden
  //laenge durch 4 teilbar machen
  stinx= ((size >>2)+1)<<2; //auf viererperiode
  if(length< stinx+1 ) resizelonu(stinx+1);
  // jetzt der Verschiebealgorithmus mit pos. Verschiebung zw 1 und 7
  for(ind=0;ind < stinx-4; ind +=4) //bis zur vorletzten vierergruppe
  {
    scratch = *((ulong32 *)  (ad+ind )); //4 byte gruppe
    //runter rotieren
    scratch >>= bitshift; // um bitshift runter rotieren
    *((ulong32 *)  (ad+ind))=scratch;
    //uoberste bitshift bit holen und oben rein schreiben
    //maske setzen
    switch(bitshift)
    {
        case 7:
          mask=127;
          break;
        case 6:
          mask=63;
          break;
        case 5:
          mask=31;
          break;
        case 4:
          mask=15;
          break;
        case 3:
          mask=7; break;
        case 2:
          mask=3; break;
        case 1:
          mask=1;
          break;
        default:
          throwout(_("never reach this case-error"));
    }
    plug=*(ad+ind +4) & mask;
    //8-bitshift  hoch rotieren
    plug<<=(8-bitshift);
    *(ad+ind +3) |= plug;
  }
  scratch = *((ulong32 *)  (ad+ind )); //4 byte gruppe
  scratch >>= bitshift;
  *((ulong32 *)  (ad+ind ))=scratch;
  trusiz=false;
  setsize();
  return;
}
/**********************************************/
void longnumber::shiftbits_q(long32 offs)
{
  ulong32 ind,stinx;
  long32 byshift;
  char bitshift;
  register ulong32 scratch;
  unsigned char mask=0,plug;

  if(offs==0) return;
  if(offs<0) {shiftbits_down(-offs); return;}
  setsize();
  //auftrennen in byteshift und bitshift
  byshift= offs >> 3; //die anzahl bytes der Verschiebung durch 8
  if(byshift!=0)  byteshift(byshift);
  bitshift= offs & 7; //unterste 3 bit
  if(bitshift==0) return; // alles easy
  //if(negative) bitshift+=8; // muss dann spaeter nochmal eins runtergesetzt werden
  //laenge durch 4 teilbar machen
  stinx= ((size >>2)+1)<<2; //auf viererperiode
  if(length< stinx+1 ) resizelonu(stinx+1);
  // jetzt der Verschiebealgorithmus mit pos. Verschiebung zw 1 und 7
  for(ind=stinx-1;ind >= 7; ind -=4) //bis zur vorletzten vierergruppe
  {
    scratch = *((ulong32 *)  (ad+ind - 3)); //4 byte gruppe
    //hochrotieren
    scratch <<= bitshift; // um bitshift hochrotieren
    *((ulong32 *)  (ad+ind - 3))=scratch;
    //unterste bitshift bit holen und unten rein schreiben
    //maske setzen
    switch(bitshift)
    {
        case 7:
          mask=254;break;
        case 6:
          mask=252;break;
        case 5:
          mask=248; break;
        case 4:
          mask=240; break;
        case 3:
          mask=224;break;
        case 2:
          mask=192;break;
        case 1:
          mask =128;
          break;
        default:
          throwout(_("never reach this case-error"));
    }
    plug=*(ad+ind -4) & mask;
    //8-bitshift runterrotieren
    plug>>=(8-bitshift);
    *(ad+ind -3) |= plug;
  }
  scratch = *((ulong32 *)  (ad+ind - 3)); //4 byte gruppe
  scratch <<= bitshift;
  *((ulong32 *)  (ad+ind - 3))=scratch;
  trusiz=false;
  setsize();
  return;
}
/**********************************************/
void longnumber::shiftonedown_q()
{
  ulong32 ind,stinx;
  register ulong32 scratch;

  setsize();
  //laenge durch 4 teilbar machen
  stinx= ((size / 4)+1)*4;

  if(length< stinx+1 ) resizelonu(stinx+1);
  for(ind=3;ind <stinx-3 ; ind +=4) //bis zur vorletzten vierergruppe
  {
    scratch = *((ulong32 *)  (ad+ind - 3)); //4 byte gruppe
    //runterrotieren
    scratch >>= 1;
    *((ulong32 *)  (ad+ind - 3))=scratch;
    //unterststes bit drüber holen und oben rein schreiben
    if(( *(ad+ind +1) & 1)==1) *(ad+ind) |= 128;
  }
  scratch = *((ulong32 *)  (ad+ind - 3)); //4 byte gruppe
  scratch >>= 1;
  *((ulong32 *)  (ad+ind - 3))=scratch;
  hibit--;
  if((hibit & 7) ==7) size--;
  //setsize();
}
/**********************************************/
/**********************************************/
void longnumber::shiftoneup_q()
{
  ulong32 ind,stinx;
  register ulong32 scratch;

  setsize();
  if(hibit==-1) return;  //wenn 0 dann tunix
  //laenge durch 4 teilbar machen
  stinx= ((size / 4)+1)*4;

  if(length< stinx+1 ) resizelonu(stinx+1);
  for(ind=stinx-1;ind >= 7; ind -=4) //bis zur vorletzten vierergruppe
  {
    scratch = *((ulong32 *)  (ad+ind - 3)); //4 byte gruppe
    //hochrotieren
    scratch <<= 1;
    *((ulong32 *)  (ad+ind - 3))=scratch;
    //unterstes bit holen und unten rein schreiben
    if(( *(ad+ind -4) & 128)==128) *(ad+ind -3) |= 1;
  }
  scratch = *((ulong32 *)  (ad+ind - 3)); //4 byte gruppe
  scratch <<= 1;
  *((ulong32 *)  (ad+ind - 3))=scratch;
  hibit++;
  if(hibit % 8 ==0) size++;
  //setsize();
}
/**********************************************/
void longnumber::shiftup(ulong32 upshift)
{
  ulong32 ind;

  setsize();
  resizelonu(size+1 + (upshift>>3),0);
  for(ind=(size<<3) +upshift-1;ind > upshift-1; ind--)
    setbit(ind,getbit(ind-upshift));
  for(ind=0;ind < upshift; ind++)
    setbit(ind,false);
  trusiz=false;
  setsize();
}
/**********************************************/
bool longnumber::ggt(longnumber* b, longnumber* g)
  //Größter gemeinsamer Teiler nach Euklid´s Algorithmus, ergebnis nach g
{
   setsize();       //Erstmal auf eingang von null testen
   if(size==0)      //wenn ja gibt´s false zurück wg. keine echten Teiler1!
   {  g->copynum(b); return FALSE;}

   b->setsize(); if(b->size==0) {g->copynum(this); return FALSE;}

   longnumber ha(length),hb(b->length);
   longnumber *pa,*pb,*pr;
   //arbeitsvariablen kreieren

   ha.copynum(this); hb.copynum(b);
   pa=&ha;pb=&hb;pr=&ha; //pointer setzen
   do
   {
     pa->lonumodulo_qqq_e(pb);
     pr=pa;
     pa=pb;
     pb=pr;
     pb->trusiz=false;
     pb->setsize(true);
   }while(pr->size>0);
   g->copynum(pa);
   return true;
}
/**********************************************/
bool longnumber::get_mod_inv(longnumber* inv, longnumber* modul)
// bestimmt das module inverse bezgl. eines Prim_moduls,
//bei testprime>0 wir auch auf Primzahleigenschaft mit sicherheitsparameter max 5 getestet
{
    bool bezret;
    longnumber eins,vielleicht_eins,t;
  eins.storlong(1);
  bezret=bezout_q(modul,&vielleicht_eins, inv, &t);
  if(eins.compare(&vielleicht_eins) != 0) // this and modul not relative prime, result invalid!
  {
      throwout(_("this and modul not relative prime in get_mod_inv,\n invalid result!"));
      return false;
  }
  if(!bezret) throwout(_("Error in Bezout"));
  return bezret;
}
/**********************************************/
bool longnumber::get_mod_inv_q(longnumber* inv, longnumber* modul)
// bestimmt das module inverse bezgl. eines Prim_moduls,
//ohne kinkerlitzchen und tests
// geht davon aus, dass *this< modul und beide != 0
{
   setsize();       //Erstmal auf eingang von null testen
   if(size==0)      //wenn ja gibt´s false zurück wg. keine echten Teiler1!
   {  inv->storlong(0);return false;}

   modul->setsize();
   if(modul->size==0)
   { inv->storlong(1);return false;}

   longnumber ha(length),hb(modul->length),s1,s2,t1,t2,hq,hr,hlp1,t;
   longnumber *pa,*pb,*pr;
   //arbeitsvariablen kreieren

   ha.copynum(this); hb.copynum(modul);
   pa=&ha;pb=&hb;pr=&hr; //pointer setzen
   //modul.copynum(pa);modul.multnum(pb);modul.setsize(); //hier obsolet, da echtes modul verfuegbar
   s1.storlong(1);s2.storlong(0);inv->storlong(0);
   t1.storlong(0);t2.storlong(1);t.storlong(1);
   hq.copynum(pa);//ist *this
   // hq.divnum_qqq(pb,pr); //obsolet, weil < modul -> dafuer naechste zeile
   pr->copynum(this);
   //pr->setsize();  //obsolet
   while(pr->size>0)
   {
      //s->copynum(&s1); // s1 wird anschl. verworfen!
      inv->swapnum(&s1);
      hlp1.copynum(&hq);
      //hlp1.setsize(true);  //new
      hlp1.multnum_l1(&s2,modul);
      inv->subtrnum_q(&hlp1,modul);
      //inv->setsize(); //new


      //t->copynum(&t1); // t1 wird anschl. verworfen
      t.swapnum(&t1);
      hlp1.copynum(&hq); //hq wird dann verworfen
      //hlp1.swapnum(&hq);
      //hlp1.setsize();
      hlp1.multnum_l1(&t2,modul);
      t.subtrnum_q(&hlp1, modul);
      //t.setsize(); //new


      //s1.copynum(&s2);
      s1.swapnum(&s2); //jetzt ist s2 kaputt wird aber nicht mehr gebr.
      s2.copynum(inv);
      //s2.setsize(); //new
      //s2.swapnum(s); // jetzt ist s kaputt, wird aber oben neu besetzt
      //t1.copynum(&t2);
      t1.swapnum(&t2); // jetzt ist t2 kaputt
      t2.copynum(&t); //kann geswappt werden, wenn t nicht gebraucht wird
      //t2.swapnum(t); // jetzt ist t kaputt wird aber oben neu geholt

      //pa->copynum(pb);pb->copynum(pr);
      pa->swapnum(pb); pb->copynum(pr);
      hq.copynum(pa);
      hq.divnum_qqq_e(pb,pr);
      pr->trusiz=false;
      pr->setsize();
    }
    //g->copynum(pb); //obsolet
    return true;
}
/**********************************************//**********************************************/
bool longnumber::bezout(longnumber* b, longnumber* g, longnumber* s, longnumber* t)
  //Erweiterter Euklid´scher Algorithmus nach Bézout (Vielfachsummendarstellung)
  // g= s*a(=this) + t*b
  // a ist meist die gewählte Zahl "e", g ist 1, b: der Modul fi(p*q), t wird nicht gebraucht, s ist das modulare inverse "d"
  // !! 1 = "d"* "e" + t * "fi(p*q)
{
   setsize();       //Erstmal auf eingang von null testen
   if(size==0)      //wenn ja gibt´s false zurück wg. keine echten Teiler1!
   {  g->copynum(b); s->storlong(0); t->storlong(1);return FALSE;}

   b->setsize();
   if(b->size==0)
   {g->copynum(this); s->storlong(1); t->storlong(0);return false;}

   longnumber ha(length),hb(b->length),s1,s2,t1,t2,hq,hr,hlp1,modul;
   longnumber *pa,*pb,*pr;
   //arbeitsvariablen kreieren

   ha.copynum(this); hb.copynum(b);
   pa=&ha;pb=&hb;pr=&hr; //pointer setzen
   modul.copynum(pa);modul.multnum_l1(pb);modul.setsize();
   s1.storlong(1);s2.storlong(0);s->storlong(0);
   t1.storlong(0);t2.storlong(1);t->storlong(1);
   hq.copynum(pa);
   hq.divnum_qqq_e(pb,pr);
   pr->setsize();
   while(pr->size>0)
   {
      s->copynum(&s1);
      hlp1.copynum(&hq);
      hlp1.multnum_l1(&s2);
      s->subtrnum_q(&hlp1,&modul);


      t->copynum(&t1);
      hlp1.copynum(&hq);
      hlp1.multnum_l1(&t2);
      t->subtrnum_q(&hlp1, &modul);


      s1.copynum(&s2);
      s2.copynum(s);
      t1.copynum(&t2);
      t2.copynum(t);

      pa->copynum(pb);pb->copynum(pr);
      hq.copynum(pa);
      hq.divnum_qqq_e(pb,pr);
      pr->setsize();
    }
    g->copynum(pb);
    return true;
}
/**********************************************//**********************************************/
bool longnumber::bezout_q(longnumber* b, longnumber* g, longnumber* s, longnumber* t)
  //Erweiterter Euklid´scher Algorithmus nach Bézout (Vielfachsummendarstellung)
  // g= s*a(=this) + t*b
  // a ist meist die gewählte Zahl "e", g ist 1, b: der Modul fi(p*q), t wird nicht gebraucht, s ist das modulare inverse "d"
  // !! 1 = "d"* "e" + t * "fi(p*q)
{
   setsize();       //Erstmal auf eingang von null testen
   if(size==0)      //wenn ja gibt´s false zurück wg. keine echten Teiler1!
   {  g->copynum(b); s->storlong(0); t->storlong(1);return false;}

   b->setsize();
   if(b->size==0)
   {g->copynum(this); s->storlong(1); t->storlong(0);return false;}

   longnumber ha(length),hb(b->length),s1,s2,t1,t2,hq,hr,hlp1,modul;
   longnumber *pa,*pb,*pr;
   //arbeitsvariablen kreieren

   ha.copynum(this); hb.copynum(b);
   pa=&ha;pb=&hb;pr=&hr; //pointer setzen
   modul.copynum(pa);modul.multnum_l1(pb);modul.setsize();
   s1.storlong(1);s2.storlong(0);s->storlong(0);
   t1.storlong(0);t2.storlong(1);t->storlong(1);
   hq.copynum(pa);
   hq.divnum_qqq_e(pb,pr);
   pr->setsize();
   while(pr->size>0) //ueberarbeitung am 10.2.11 einf qqq und swap statt umkopieren
   {
      //s->copynum(&s1); // s1 wird anschl. verworfen!
      s->swapnum(&s1);
      hlp1.copynum(&hq);
      hlp1.multnum_l1(&s2);
      s->subtrnum_q(&hlp1,&modul);


      //t->copynum(&t1); // t1 wird anschl. verworfen
      t->swapnum(&t1);
      hlp1.copynum(&hq); //hq wird dann verworfen
      //hlp1.swapnum(&hq);
      hlp1.multnum_l1(&t2);
      t->subtrnum_q(&hlp1, &modul);


      //s1.copynum(&s2);
      s1.swapnum(&s2); //jetzt ist s2 kaputt wird aber nicht mehr gebr.
      s2.copynum(s);
      //s2.swapnum(s); // jetzt ist s kaputt, wird aber oben neu besetzt
      //t1.copynum(&t2);
      t1.swapnum(&t2); // jetzt ist t2 kaputt
      t2.copynum(t); //kann geswappt werden, wenn t nicht gebraucht wird
      //t2.swapnum(t); // jetzt ist t kaputt wird aber oben neu geholt

      //pa->copynum(pb);pb->copynum(pr);
      pa->swapnum(pb); pb->copynum(pr);
      hq.copynum(pa);
      hq.divnum_qqq_e(pb,pr);
      pr->trusiz=false;
      pr->setsize();
    }
    g->copynum(pb);
    return true;
}
/***********************************************/
bool longnumber::crt_combine(longnumber* p1, longnumber* xp1, longnumber* p2, longnumber* xp2, longnumber* pcomb )
  //kombiniert die Lösung kongruent zweier teilerfremder Zahlen modulo dem Produkt beider Zahlen
{
    longnumber res,s,t,g,h1;
    bool noswap=true;

    if(p1->compare(p2) <0)  //swap numbers, p1 should be the bigger one
    {
        p1->swapnum(p2);
        xp1->swapnum(xp2);
        noswap=false;
    }
    if(! p1->bezout_q(p2,&g,&s,&t))
    {
        throwout(_("error in bezout"));
        return false;
    }
    //check for mutual primeness
    if(g.hibit!=0)
    {
        throwout(_("error, submodules are not relative prime!"));
        return false;
    }
    pcomb->copynum(p1);
    pcomb->multnum_l1(p2);  //combi-module is set
    this->copynum(p1);
    this->multnum_l1(&s);
    this->multnum_l1(xp2); //erster Term is set
    h1.copynum(p2);
    h1.multnum_l1(&t);
    h1.multnum_l1(xp1);  //zweiter term is set
    this->addnum_q(&h1,pcomb); //add both modular big module
    if(!noswap)
    {
        p1->swapnum(p2);
        xp1->swapnum(xp2);
    }
    return true;
}
/**********************************************/
long longnumber::giv_siz()
{
    setsize();
    return hibit;
}
/**********************************************/
ulong32 longnumber::counteqlbytes(longnumber* refad)
  //zählt die Anzahl an identischen bytes
{
  ulong32 retval,indx;

  indx=0; retval=0;
  if((length==0)||(refad->length == 0)) return 0;
  do
  {
    if( *(ad+indx)== *(refad->ad +indx))
      retval++;
    indx++;
  }while((indx<length)&&(indx< refad->length));
  return retval;
}
/**********************************************/
bool longnumber::randomize_o( long32 rounds, longnumber* mate, ulong32 outlength, ulong32 cagesize, char warnflag)
// Funktion mixert und permutiert den block mit mate durch
//wenn cagesize > length+mate->length intermediately larger cage
{
   ulong32 maxlength,indx,stindx;
   longnumber hlp;
   bool res,m=true;;

   //mixersize bestimmen
   maxlength=length;
   if(mate !=NULL) mate->setsize(true);
   if((mate==NULL)||(mate->size ==0)) m=false;
   if(mate !=NULL) maxlength += mate->size;
   if (outlength> maxlength) maxlength = outlength;
   if(cagesize> maxlength) maxlength = cagesize;
   setsize(true);
   if (maxlength<2) return false;
   //auffuellen
   hlp.copynum(this);
   if(mate !=NULL) hlp.appendnum(mate);
   hlp.resizelonu(maxlength);
   if(mate !=NULL) stindx=length+mate->size;
   else stindx=length;
   if(m)
   {
     for(indx=stindx;indx<hlp.length;indx++)
     {
       //mit reentrant zahlen auffuellen
       *(hlp.ad +indx)= *(ad+(indx%size));
       *(hlp.ad +indx) ^= *(mate->ad + (indx%mate->size));
     }
   }
   else //without mate involvement
   {
     for(indx=stindx;indx<hlp.length;indx++)
     {
       //mit reentrant zahlen auffuellen
       *(hlp.ad +indx)= *(ad+(indx%size));
     }
   }
   if((warnflag==1)&&(hlp.length<25))
   {throwout(_("Warning!!!\n Random Longnumber too short\n WEAK random numbers!"));}
   //res=hlp.randomize_d(rounds,0);
   res=hlp.lndevelop(rounds,2,0); //develop_o , 2branches, bytadd_a only
   hlp.setsize(true);
   //ausgangsformat reduzieren, outlength cannot be larger than maxlength
   resizelonu(outlength,0);
   memcpy(ad, hlp.ad+(maxlength-outlength)/2, outlength);
   trusiz=false;
   return res;
}
/**************************************************************/
bool longnumber::randomize( long32 rounds, longnumber* mate, ulong32 outlength, ulong32 cagesize, char warnflag)
// Funktion mixert und permutiert den block mit mate durch
//wenn cagesize > length+mate->length intermediately larger cage
{
   ulong32 maxlength,indx,stindx;
   longnumber hlp;
   bool res;

   //mixersize bestimmen
   maxlength=length;
   if(mate !=NULL) maxlength += mate->size;
   if (outlength> maxlength) maxlength = outlength;
   if(cagesize> maxlength) maxlength = cagesize;
   setsize(true); if(mate !=NULL) mate->setsize(true);
   if (maxlength<2) return false;
   //auffuellen
   hlp.copynum(this);
   if(mate !=NULL) hlp.appendnum(mate);
   hlp.resizelonu(maxlength);
   if(mate !=NULL) stindx=length+mate->size;
   else stindx=length;
   for(indx=stindx;indx<hlp.length;indx++)
   {
       //mit reentrant zahlen auffuellen
       *(hlp.ad +indx)= *(ad+(indx%size));
       if(mate != NULL) *(hlp.ad +indx) ^= *(mate->ad + (indx%mate->size));
   }
   if((warnflag==1)&&(hlp.length<25))
   {throwout(_("Warning!!!\n Random Longnumber too short\n WEAK random numbers!"));}
   res=hlp.randomize_d(rounds,0);
   //res=lndevelop(rounds,2,0); //develop_o , 2branches, bytadd_a only
   hlp.setsize(true);
   //ausgangsformat reduzieren, outlength cannot be larger than maxlength
   resizelonu(outlength,0);
   memcpy(ad, hlp.ad+(maxlength-outlength)/2, outlength);
   trusiz=false;
   return res;
}
/*********************************************/
bool longnumber::appendnum(longnumber* pextnum)
  // anndere lonu anhaengen, terminating 0 embedded
{
    ulong32 oldlen;

    oldlen = length;
    resizelonu(length+ pextnum->length,0);
    memcpy(ad+oldlen, pextnum->ad, pextnum->length);
    setsize(true);
    return true;
}
/**************************************************************/
bool longnumber::randomize_d( long32 rounds, char warnflag)
// Funktion mixert und permutiert den block massiv durch
//erzwingt höchstes byte != null
{
   ulong32 oldsize,indx;
   longnumber hlp,secp;
   int i;

   setsize(true);
   oldsize = size; // to ensure that size is not shrinking
   if (size<2) return false;
   //hlp.copynum(this);
   if((warnflag==1)&&(size<25))
   {throwout(_("Warning!!!\n Random Longnumber too short\n WEAK random numbers!"));}
   //prepare copy for parallel path
   secp.copynum(this);
//major round
   for(i=0;i<rounds;i++)
   {
     if( !integrate(127,1,2)) return false; //to "uncode" and disperse Info
     if( !lnperm_x1(1)) return false;
     if( !lnxor_x1( 1)) return false;
   }
   //secondary round in different sequence
   for(i=0;i<rounds;i++)
   {
     if( !secp.integrate(63,7,2)) return false; //to "uncode" and disperse Info
     if( !secp.lnxor_x1( 1)) return false;
     if( !secp.lnperm_x1(1)) return false;
   }
   //Final xoring
   for(indx=0;indx<length;indx++) *(ad+indx) ^= *(secp.ad + indx);
   //cleaning if accidentally shortened
   setsize(true);
   if(size < oldsize){
        *(ad+ oldsize -1)= (char)(oldsize*size);
        setsize(true);
        if (size<oldsize) {
            *(ad+ oldsize -1)= 42; //die Antwort auf alle Fragen!
            setsize(true);
        }
   }
   return true;
}
/**************************************************************/
bool longnumber::randomize_e( long32 rounds, char warnflag)
// Funktion mixert und permutiert den block massiv durch
//erzwingt höchstes byte != null
{
   ulong32 oldsize;
   int i;

   setsize(true);
   oldsize = size; // to ensure that size is not shrinking
   if ((size<2)||(size> 32000))
   {
       throwout(_("irregular lonu-size, aborting"),8);
       return false;
   }
   if((warnflag==1)&&(size<25))
   {throwout(_("Warning!!!\n Random Longnumber too short\n WEAK random numbers!"),5);}
   //call develop_ln2_mt
   if(!develop_ln2_mt((char *)ad,(int)size,2,3,1,1))
   {
       throwout(_("error in develop_ln2!!!, aborting"),3);
       return false;
   }
   //ensure top byte is not zero
   if(*(ad+size-1)==0)
   {
       i=0;
       do
       {
           if(*(ad+i)== 0)
              i++;
           else
           {
              *(ad+size-1)= *(ad + i);
              break;
           }
       } while ((unsigned int)i< size -2);
       if((unsigned int)i== size-2) //all zeroes ???!!!
       {
           //force to one at hibit
           throwout(_("Intruder Alert!! \nZero as random number encountered!"),2);
           *(ad + size -1) = 253;
       }
    }
    setsize(true);
   return true;
}
/*********************************************/
/**************************************************************/
/*********************************************/
/**************************************************************/
bool longnumber::randomize( long32 rounds, char warnflag)
// Funktion mixert und permutiert den block massiv durch
//erzwingt höchstes byte != null
{
   ulong32 oldsize;
   longnumber hlp;
   long32 i;

   setsize(true);
   oldsize = size; // to ensure that size is not shrinking
   if (size<2) return false;
   //hlp.copynum(this);
   if((warnflag==1)&&(size<25))
   {throwout(_("Warning!!!\n Random Longnumber too short\n WEAK random numbers!"));}
   for(i=0;i<rounds;i++)
   {
     if( !integrate(127,1,2)) return false; //to "uncode" and disperse Info
     if( !lnperm_x1(1)) return false;
     //if( !integrate(127,1,2)) return false; //to "uncode" and disperse Info
     if( !lnxor_x1( 1)) return false;
     //if( !integrate(127,1,2)) return false; //to "uncode" and disperse Info

   }
   setsize(true);
   if(size < oldsize){
        *(ad+ oldsize -1)= (char)(oldsize*size);
        setsize(true);
        if (size<oldsize) {
            *(ad+ oldsize -1)= 42; //die Antwort auf alle Fragen!
            setsize(true);
        }
   }
   return true;
}
/*********************************************/
bool longnumber::lnxor_x1( long32 rounds)
//Funktion setzt einen blolen großen Block in
//einen blolengroßen Permutationsarray um
//1.wohin zeigt byte-wohin zeigt das wieder+ index, original wird mit dem gexort
//2. wohin zeigt byte, wird mit dem gexort, wohin zeigt das, wird mit dem gexort etc blolen mal
// bei zwei heisst zeigt: alter index + neuer + index modulo blolen

{
  ulong32 ind,oi,hind,blolen;
  unsigned char *blad,h1,h2;
  long32 k;


  if(size<2)return false;

  blolen = length-1; //oberstes byte sollte nullbuffer sein
  blad=ad; //direkter Zugriff auf buffer
  for(k=0;k<rounds;k++)
  {
      for(oi=0;oi<blolen;oi++) //erste schleife systematisch
      {
          hind = (ulong32)   *(blad +( *(blad + oi) * *(blad+(oi+1)%blolen)) %blolen )%blolen; // pointed-to index bestimmen
          if(hind!=oi) *(blad + oi) += rotbyte(*(blad+hind),((unsigned char)(hind+oi)&7));
          //*(blad +oi)=rotbyte(*(blad+oi),(unsigned char)hind&7);
          *(blad+oi)+=63+(unsigned char)oi;
          if(oi%2 == 0) *(blad+hind) = *(blad+hind) ^255; //jedes zweite mal bei hind invertieren
      }
      ind=0;
      for(oi=0;oi<blolen;oi++) //zweite schleife wild gesprungwen
      {
          hind = (ulong32)*(blad+ind)%blolen; // pointed-to index bestimmen
         if(hind!= ind) *(blad + ind) += rotbyte(*(blad+hind),(unsigned char)(ind+hind)&7); //wird mit zeigerziel ge xort
         // *(blad +ind)=rotbyte(*(blad+ind),(unsigned char)oi&7);
          *(blad+ind)+=63+(unsigned char)oi;//nullenkiller
          if(oi%2 == 1) *(blad+hind) = *(blad+hind) ^255; //jedes zweite mal bei hind invertieren
          ind = (ind +hind+oi)%blolen; //neuer index wo# s hinzeigt plus 1 modulo blono
     }
      //now statistically closing the lid
      h1=(unsigned char) ind;  h2=(unsigned char) (hind+ind);
      for(oi=0;oi<2*blolen;oi++) //dritte schleife, retrace buster
      {
          hind = ((int) *(blad+((oi+ind)%blolen)))  %blolen; // pointed-to index bestimmen
          //nicht sicher rueckabwickelbare entscheidung
          if( ((*(blad + hind) >> (oi&7))&1) ==1)
          {
              //der rotator
              h2+=*(blad+hind);
              *(blad+hind)= rotbyte(*(blad+hind),h1&7);
          }
          else
          {
              // der xor step
              h1+= *(blad+hind);
              *(blad+hind) =rotbyte(*(blad+hind),h2&7);
          }
          ind = hind;
      }
  }
  trusiz=false;
  return true;
}
/**************************************************************/
bool longnumber::lndevelop( long32 rounds,char paths,char algoflag)
{
   if(size<2)return false;
   return (develop_o( (char *) ad, size, rounds, paths,algoflag));
}

/*********************************************/
bool longnumber::lnperm_x1( long32 rounds)

//Funktion setzt einen blolen großen Block in
//einen blolengroßen Bit-Permutationsarray um
// Bit Dispersion über Multiplikation
//1.wohin zeigt byte-wohin zeigt das wieder+ index, original wird mit dem vertauscht
//2. wohin zeigt byte, wird mit dem gexort, wohin zeigt das, wird mit dem gexort etc blolen mal
// bei zwei heisst zeigt: alter index + neuer + index modulo blolen

{
  ulong32 oi,ind,hind,blolen;
  unsigned char *blad,h1,h2,*zsto;
  long32 k;
  ulong32 ihl;


  if(size<2)return false;

  blolen = length-1;//oberstes byte sollte nullbuffer sein
  blad=ad; //direkter Zugriff auf buffer  for(hi=0;hi<rounds;hi++)
  for(k=0;k<rounds;k++)
  {
      for(oi=0;oi<blolen;oi++) //erste schleife systematisch
      {
          hind = (ulong32)   *(blad + (*(blad+oi)%blolen))%blolen ; // pointed-to pointed to index bestimmen
          hind = (hind + oi)%blolen; //wegen homogener durchwanderung mit oi addieren
          // jetzt multipl. und splitten
          if(hind&4) { *(blad+oi) ^= 255;} //invertieren
          ihl= oi+ ((ulong32) *(blad+hind)) * ((ulong32) *(blad+oi)); //Bitdiffusion durch Multiplikation
          ihl%=257;
          ihl+=oi;
          //if(ihl==0){ihl = oi*oi+ (*(blad+hind)*  *(blad+hind) ) + (*(blad+oi) * *(blad+oi));}
         *(blad+oi)=  ((unsigned char)ihl)+ ((unsigned char)ihl>>8); //bytzusammenfuehrung
          //if(*(blad+oi)==0) *(blad+oi)=(unsigned char) (ihl+hind);
          // jetzt der Entropiestep
          if(hind&1) { *(blad+oi) ^= 255;}
                     //jetzt der rotator
          *(blad+hind)= rotbyte(*(blad+hind),((unsigned char)(oi))&7);
      }
      ind = blolen/2;
      zsto=(unsigned char *) malloc(blolen);
      memcpy(zsto,blad,blolen);
      for(oi=0;oi<blolen;oi++) //zweite schleife wild gesprungwen
      {
          hind =  (*(blad +(ulong32) *(blad+((oi+ind)%blolen))  %blolen) )%blolen ; // pointed-to pointed to index bestimmen
          hind = (hind + oi)%blolen; //wegen homogener durchwanderung mit oi addieren
          // jetzt ein Entropiestep
          if(hind&4) { *(blad+(oi%blolen)) ^= 255;}
          //mit hind vertauschen
          ihl=  (ulong32)oi +((ulong32) *(blad+hind)) * ((ulong32) *(blad+ind)); //Bitdiffusion durch Multiplikation
          ihl%=257;
          //if(ihl<2){ihl = oi*oi+ (*(blad+hind)*  *(blad+hind) ) + (*(blad+ind) * *(blad+ind));}
          *(zsto+ind)= (unsigned char) oi+ ((unsigned char)ihl&255)+ (unsigned char)(ihl>>8); //unteres byte
          //*(blad+hind)= (unsigned char) (ihl>>8);  //oberes byte lieber nicht nehmen
          //Nullenfresser
          //if(*(blad+ind)==0) *(blad+ind)=(unsigned char) hind;
          // jetzt der Entropiestep
          if(hind&1) { *(zsto+ind) ^= 255;}
           //jetzt der rotator
          *(zsto+ind)= rotbyte(*(zsto+ind),((unsigned char)(ind))&7);
          //einmal durchwechseln
          ind = hind;
      }
      memcpy(blad,zsto,blolen);
      free(zsto);
     //now statistically closing the lid
      h1=(unsigned char) ind;  h2=(unsigned char) (hind+ind);
      for(oi=0;oi<2*blolen;oi++) //dritte schleife, retrace buster
      {
          hind = ((long32) *(blad+((oi+ind)%blolen)))  %blolen; // pointed-to index bestimmen
          //nicht sicher rueckabwickelbare entscheidung
          if( ((*(blad + hind) >> (oi&7))&1) ==1)
          {
              //der rotator
              h2+=*(blad+hind);
              *(blad+hind)= rotbyte(*(blad+hind),h1&7);
          }
          else
          {
              // der alternativer rotator
              h1+= *(blad+hind);
              *(blad+hind) =rotbyte(*(blad+hind),h2&7);
          }
          ind = hind;
      }
  }
  trusiz=false;
  return true;
}
/**************************************************************/
/**************************************************************/
bool longnumber::formforkey(ulong32 blosiz)
{
    return resizelonu(blosiz,0);
}
/**************************************************************/
  bool longnumber::qrsa_encipher(longnumber* ptarget, longnumber* pd, longnumber* pn, ulong32 blosiz)
  {
      ptarget->copynum(this);
      ptarget->formforkey(blosiz);
      ptarget->pownum_q(pd,pn);
      return true;
  }
  /**************************************************************/
  bool longnumber::qrsa_decipher(longnumber* cipher,longnumber* pe, longnumber* pn, ulong32 blosiz)
  {
      this->copynum(cipher);
      pownum_q(pe,pn);
      formforkey(blosiz);
      return true;
  }
/**************************************************************/
bool longnumber::lonu_lock(longnumber *pky, wxString algo)
{

    return lonu_enciph( pky, 5,3,algo);
}
/**************************************************************/
bool longnumber::lonu_unlock(longnumber *pky, wxString algo)
{

    return lonu_enciph( pky, 5,-3,algo);
}
/**************************************************************/
bool longnumber::lonu_enciph( longnumber *p_lnk, int kang_r, int frounds, wxString algo)
// frounds zeigt an, ob encipher oder decipher

{
  int hlen,i,j,cpa_blen;
  char *ptxt, *ctxt, *cpa_bl;
  longnumber key;
  unsigned int i1;

  if(size<14)
    {
        resizelonu(15);
        size=14;
    }
  else if(size%2 == 1)
      { // size gerade machen
          shrinktofit();
          resizelonu(size + 1);
          *(ad + size) =0;
          size++;
      //jetzt ist lonu im Umfang geradzahlig
      }
  key.copynum(p_lnk); //kopie von schluessel ziehen
  ptxt= (char*)malloc(size);
  ctxt= (char*)malloc(size);
  cpa_blen=size; //cpa_blen is matching blolen
  if(algo==_("Fleas_o2")||algo==_("Fleas_o5"))
  {
      cpa_bl=develop_o_malloc(key.size,(char *)(key.ad),4,3,cpa_blen,0);
  }
  else if((algo==_("Fleas_l")) ||algo==_("Fleas_ls")||algo==_("Fleas_l3")||algo==_("Fleas_lc") )
  {
      cpa_bl=develop_l_malloc(key.size,(char *)(key.ad),3,cpa_blen);
  }
  else cpa_bl=bytmixxmalloc(key.size,(char *)(key.ad),6,cpa_blen); //cpa_blocker gesetzt

  for(i1=0;i1<size;i1++)   //Kopie ziehen
     *(ptxt+i1)= *(ad+i1);

  hlen=size/2;

  for(j=0;j<frounds;j++)   //encipher
  {
    for(i=0;i<hlen;i++)  // Li = R(i-1)
    {
      *(ctxt+i)=*(ptxt+hlen+i);
      *(ctxt+i+hlen)=*(ptxt+hlen+i);//vorbereitg für unten
    }

             // Ri = L(i-1) XOR roundfun(R(i-1),Key)

    if(!roundfun(hlen,key.size,(ctxt+hlen),(char *)(key.ad),kang_r, cpa_blen, cpa_bl,algo))
          {throwout(_("roundfun ERROR!"));return false;}
    for(i=0;i<hlen;i++)  // Ri = L(i-1) XOR roundfun(R(i-1),Key)
    {
      *(ctxt+hlen+i) ^= *(ptxt+i);
    }
    for(i1=0;i1<size;i1++)
    {
      *(ptxt+i1)=*(ctxt+i1);
    }
  }
  for(j=0;j<-frounds;j++)  //decipher
  {
    for(i=0;i<hlen;i++)  // ((Li =)) R(i-1) =Li
    {
      *(ctxt+i+hlen)=*(ptxt+i);
      *(ctxt+i)=*(ptxt+i);//vorbereitg für unten
    }

             // ((Ri =))) L(i-1) XOR roundfun(R(i-1),Key)

    if(!roundfun(hlen,key.size,ctxt,(char *)(key.ad), kang_r,  cpa_blen, cpa_bl,algo))
        {throwout(_("roundfun ERROR!"));return false;}
    for(i=0;i<hlen;i++)  // ((Ri =)) L(i-1) XOR roundfun(R(i-1),Key)
    {
      *(ctxt+i) ^= *(ptxt+hlen+i);
    }
    for(i1=0;i1<size;i1++)
    {
      *(ptxt+i1)=*(ctxt+i1);
    }
  }
  for(i1=0;i1<size;i1++)   //Kopie ziehen
     *(ad+i1)= *(ctxt+i1);

  if(ptxt != NULL) free((void *) ptxt);
  if(ctxt != NULL) free((void *) ctxt);
  if(cpa_bl != NULL) free((void *) cpa_bl);
  return true;
}

  /****************************************************************/
  //class lonucrt
   lonucrt::lonucrt(longnumber *px, longnumber *pp, longnumber *pq) //constructor
   {
     longnumber g,v,u,imp;
     bool r1;
     long rl1;

     if(pp->compare(pq) == -1)
     {
       p.copynum( pp);
       q.copynum(pq);
     } else{
       p.copynum(pq); //*pp ist der kleinere faktor
       q.copynum(pp);
     }
     n.copynum(&p); n.multnum_l1(&q); //modul setzen
     imp.copynum(px);
     imp.lonumodulo_qqq_e(&n);//eingangsmodularisierung
     fi.copynum(&p);
     fi.dec(); q.dec();
     fi.multnum_l1(&q); q.inc(); //fehlt nur noch iqmodp

     r1=p.bezout_q(&q, &g, &u, &iqmodp);
     iqmodp.lonumodulo_qqq_e(&p);
     // testing result:
     g.copynum(&q);
     g.multnum_l1(&iqmodp,&p);
     //g.lonumodulo_q(&p);
     rl1=g.lconvert();
     if(rl1 != 1) throwout(_("error in determining modular inverse"));

     a.copynum(&imp); b.copynum(&imp);
     a.lonumodulo_qqq_e(&p);
     b.lonumodulo_qqq_e(&q);
     //constructor hopefully complete!!
   }
/*******************************************************************/
lonucrt::~lonucrt() //destructor
       {

       }
/*******************************************************************/
bool lonucrt::modulocompare(longnumber ext_n) //vergleiche moduli, true, wenns stimmt
{
    longnumber test;

    if(n.compare(&ext_n) !=0)
     return false;
    else return true;
}
/*******************************************************************/
bool lonucrt::import_num(longnumber lonu) // importiere eine Zahl aus normal nach CRT
{
    longnumber imp;

     imp.copynum(&lonu);
     imp.lonumodulo_qqq_e(&n);
     a.copynum(&imp); b.copynum(&imp);
     a.lonumodulo_qqq_e(&p);
     b.lonumodulo_qqq_e(&q);
    return true;
}
/*******************************************************************/
bool lonucrt::exportnum(longnumber *l_ad) //exportiere eine Zahl aus CRT nach normal
{
    longnumber h1;

    //Garners Formel
    l_ad->copynum(&iqmodp);
    h1.copynum(&a);
    h1.subtrnum_q(&b,&p);
    l_ad->multnum_l1(&h1,&p);
    //l_ad->lonumodulo(&p);
    l_ad->multnum_l1(&q);
    l_ad->addnum_q(&b);
    l_ad->lonumodulo_qqq_e(&n);

    return true;
}
/*******************************************************************/
bool lonucrt::addcrt(lonucrt *ps) //addiere lonucrt und checke, ob n stimmt
{
    a.addnum_q(&(ps->a),&p);
    //a.lonumodulo(&p);
    b.addnum_q(&(ps->b),&q);
    //b.lonumodulo(&q);
    return true;
}
/*******************************************************************/
bool lonucrt::subtrcrt(lonucrt *ps) //addiere lonucrt und checke, ob n stimmt
{
    a.subtrnum_q(&(ps->a),&p);
    a.lonumodulo_qqq_e(&p);
    b.subtrnum_q(&(ps->b),&q);
    b.lonumodulo_qqq_e(&q);
    return true;
}
/*******************************************************************/
bool lonucrt::multcrt(lonucrt *pfac) //multipliziere
{
    a.multnum_l1(&(pfac->a),&p);
    //a.lonumodulo(&p);
    b.multnum_l1(&(pfac->b),&q);
    //b.lonumodulo(&q);
    return true;
}
/*******************************************************************/
bool lonucrt::powcrt(longnumber *pexp) //potenziere modulo n
{
    longnumber pm,qm,xp,xq;

    pm.copynum(&p); pm.dec(); qm.copynum(&q); qm.dec();
    xp.copynum(pexp); xp.lonumodulo_qqq_e(&n); xp.lonumodulo_qqq_e(&pm);
    a.pownum_q(&xp,&p);
    xq.copynum(pexp); xq.lonumodulo_qqq_e(&n); xq.lonumodulo_qqq_e(&qm);
    b.pownum_q(&xq,&q);
    return true;
}
/*******************************************************************/
bool longnumber::lonu_to_file(wxString fnam)
{

   wxFFile lonufil(fnam,  _("wb"));

   setsize();
   shrinktofit();
   if( !lonufil.IsOpened() ) {throwout(_("lonufil \n not opened for writing error\n for: ")+fnam); return false; }

   if(lonufil.Write(ad,length) != length)
      {throwout(_("lonufil write error\n for: ")+fnam); lonufil.Close(); return false; };
   lonufil.Close();

   return true;


}
/********************************************************************/
bool longnumber::lonu_from_file(wxString fnam)
{
   ulong32 newlen(4);
   wxFFile lonufil(fnam,  _("rb"));

   if( !lonufil.IsOpened() ) {throwout(_("lonufil \n not opened for reading error\n for: ")+fnam); return false; }
   newlen=lonufil.Length();
   if(newlen>60000)
   {
       throwout(_("Error loading Longnumber from File\n number too long(>60 kbyte)!"));
       return false;
   }
   resizelonu(newlen,0);
   if(lonufil.Read(ad,newlen) != (long) newlen)
      {throwout(_("lonufil read error\n for: ")+fnam); lonufil.Close(); return false; };
   lonufil.Close();
   trusiz=false;
   setsize();
   shrinktofit();
   return true;
}
/***********************************************************************/
bool longnumber::wipezero()
  //ueberschreibt mit nullen
{
    ulong32 i;

    if(israre) un_rare();
    //for(i=0;i<length;i++)  *(ad+i)=0;
    memset(ad,0,length);
    size=0; hibit=-1;
    trusiz=true;
    return true;
}
/*********************************************************************/
  bool longnumber::wipewith(unsigned char c)
  //ueberschreibt mit c's
{
    ulong32 i;

    if(israre) un_rare();
    //for(i=0;i<length;i++)  *(ad+i)=c;
    memset(ad,c,length);
    trusiz=false;
    return true;
}
/*********************************************************************/



