/*
 *   Copyright (C) 2011-2019, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <wx/filename.h>
#include "gnupg_sign.h"
#include "gnupg_globals.h"
#include "gpg_wrap.h"
#include "gpg_manag_priv.h"
#include "globals.h"

#include <wx/arrstr.h>
#include <wx/dir.h>
#include <wx/busyinfo.h>


//(*InternalHeaders(gnupg_sign)
#include <wx/string.h>
#include <wx/intl.h>
#include <wx/font.h>
//*)

//(*IdInit(gnupg_sign)
const long gnupg_sign::ID_BUTTON3 = wxNewId();
const long gnupg_sign::ID_STATICTEXT1 = wxNewId();
const long gnupg_sign::ID_STATICTEXT2 = wxNewId();
const long gnupg_sign::ID_STATICTEXT3 = wxNewId();
const long gnupg_sign::ID_TEXTCTRL1 = wxNewId();
const long gnupg_sign::ID_TEXTCTRL2 = wxNewId();
const long gnupg_sign::ID_BUTTON1 = wxNewId();
const long gnupg_sign::ID_STATICTEXT4 = wxNewId();
const long gnupg_sign::ID_TEXTCTRL3 = wxNewId();
const long gnupg_sign::ID_BUTTON2 = wxNewId();
const long gnupg_sign::ID_STATICTEXT5 = wxNewId();
const long gnupg_sign::ID_TEXTCTRL6 = wxNewId();
const long gnupg_sign::ID_BUTTON4 = wxNewId();
const long gnupg_sign::ID_TIMER1 = wxNewId();
//*)

BEGIN_EVENT_TABLE(gnupg_sign,wxDialog)
	//(*EventTable(gnupg_sign)
	//*)
END_EVENT_TABLE()

gnupg_sign::gnupg_sign(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
	//(*Initialize(gnupg_sign)
	wxFlexGridSizer* FlexGridSizer1;
	wxFlexGridSizer* FlexGridSizer2;

	Create(parent, wxID_ANY, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("wxID_ANY"));
	FlexGridSizer1 = new wxFlexGridSizer(0, 3, 0, 0);
	FlexGridSizer2 = new wxFlexGridSizer(0, 3, 0, 0);
	Button3 = new wxButton(this, ID_BUTTON3, _("Exit/Cancel"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON3"));
	Button3->SetBackgroundColour(wxColour(253,229,229));
	wxFont Button3Font(11,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button3->SetFont(Button3Font);
	FlexGridSizer2->Add(Button3, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	StaticText1 = new wxStaticText(this, ID_STATICTEXT1, _("Create GnuPG detached signature"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT1"));
	wxFont StaticText1Font(13,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText1->SetFont(StaticText1Font);
	FlexGridSizer2->Add(StaticText1, 1, wxALL|wxALIGN_BOTTOM|wxALIGN_CENTER_HORIZONTAL, 5);
	FlexGridSizer2->Add(-1,-1,1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	StaticText2 = new wxStaticText(this, ID_STATICTEXT2, _("use key:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT2"));
	wxFont StaticText2Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText2->SetFont(StaticText2Font);
	FlexGridSizer2->Add(StaticText2, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	StaticText3 = new wxStaticText(this, ID_STATICTEXT3, _("Keyinfo"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT3"));
	wxFont StaticText3Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText3->SetFont(StaticText3Font);
	FlexGridSizer2->Add(StaticText3, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	FlexGridSizer2->Add(-1,-1,1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	kyid_ctrl = new wxTextCtrl(this, ID_TEXTCTRL1, wxEmptyString, wxDefaultPosition, wxSize(132,22), 0, wxDefaultValidator, _T("ID_TEXTCTRL1"));
	wxFont kyid_ctrlFont(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	kyid_ctrl->SetFont(kyid_ctrlFont);
	FlexGridSizer2->Add(kyid_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_TOP, 5);
	kyinf_ctrl = new wxTextCtrl(this, ID_TEXTCTRL2, wxEmptyString, wxDefaultPosition, wxSize(574,48), wxTE_MULTILINE, wxDefaultValidator, _T("ID_TEXTCTRL2"));
	wxFont kyinf_ctrlFont(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	kyinf_ctrl->SetFont(kyinf_ctrlFont);
	FlexGridSizer2->Add(kyinf_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_TOP, 5);
	Button1 = new wxButton(this, ID_BUTTON1, _("Select other \nkey"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON1"));
	wxFont Button1Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button1->SetFont(Button1Font);
	FlexGridSizer2->Add(Button1, 1, wxALL|wxALIGN_LEFT|wxALIGN_TOP, 5);
	FlexGridSizer2->Add(-1,-1,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	FlexGridSizer2->Add(20,67,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	FlexGridSizer2->Add(-1,-1,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText4 = new wxStaticText(this, ID_STATICTEXT4, _("File to sign:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT4"));
	wxFont StaticText4Font(11,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText4->SetFont(StaticText4Font);
	FlexGridSizer2->Add(StaticText4, 1, wxALL|wxALIGN_RIGHT|wxALIGN_BOTTOM, 5);
	fnam_ctrl = new wxTextCtrl(this, ID_TEXTCTRL3, wxEmptyString, wxDefaultPosition, wxSize(576,22), 0, wxDefaultValidator, _T("ID_TEXTCTRL3"));
	wxFont fnam_ctrlFont(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	fnam_ctrl->SetFont(fnam_ctrlFont);
	FlexGridSizer2->Add(fnam_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	Button2 = new wxButton(this, ID_BUTTON2, _("Select File"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON2"));
	wxFont Button2Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button2->SetFont(Button2Font);
	FlexGridSizer2->Add(Button2, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	StaticText5 = new wxStaticText(this, ID_STATICTEXT5, _("Signature File:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT5"));
	wxFont StaticText5Font(11,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText5->SetFont(StaticText5Font);
	FlexGridSizer2->Add(StaticText5, 1, wxALL|wxALIGN_RIGHT|wxALIGN_BOTTOM, 5);
	signam_ctrl = new wxTextCtrl(this, ID_TEXTCTRL6, wxEmptyString, wxDefaultPosition, wxSize(577,22), 0, wxDefaultValidator, _T("ID_TEXTCTRL6"));
	signam_ctrl->Disable();
	wxFont signam_ctrlFont(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	signam_ctrl->SetFont(signam_ctrlFont);
	FlexGridSizer2->Add(signam_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	FlexGridSizer2->Add(-1,-1,1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	FlexGridSizer2->Add(20,56,1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	Button4 = new wxButton(this, ID_BUTTON4, _("Do Sign"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON4"));
	Button4->SetBackgroundColour(wxColour(189,213,247));
	wxFont Button4Font(11,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button4->SetFont(Button4Font);
	FlexGridSizer2->Add(Button4, 1, wxALL|wxALIGN_BOTTOM|wxALIGN_CENTER_HORIZONTAL, 5);
	FlexGridSizer1->Add(FlexGridSizer2, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	SetSizer(FlexGridSizer1);
	Timer1.SetOwner(this, ID_TIMER1);
	Timer1.Start(1000, false);
	FlexGridSizer1->Fit(this);
	FlexGridSizer1->SetSizeHints(this);

	Connect(ID_BUTTON3,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&gnupg_sign::OnExit);
	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&gnupg_sign::OnSelectKey);
	Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&gnupg_sign::OnSelectFile);
	Connect(ID_BUTTON4,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&gnupg_sign::OnDoSign);
	Connect(ID_TIMER1,wxEVT_TIMER,(wxObjectEventFunction)&gnupg_sign::OnTimer1Trigger);
	//*)

    fnam_ctrl->DragAcceptFiles(true);
    fnam_ctrl->Connect(wxEVT_DROP_FILES, wxDropFilesEventHandler(gnupg_sign::OnDropFile), NULL, this);


	//fillfields
	tellerror=false;
	if(get_priv_labels()>0)
	{
	  kyid_ctrl->SetValue(kyid[pk_sel]);
	  kyinf_ctrl->SetValue(kylabel[pk_sel]);
	}
	else
        {
            throwout(_("Error, got empty keylist!\ncannot sign, aborting"),5);
            tellerror = true;
        }
}
/*************************************************************/
gnupg_sign::~gnupg_sign()
{
	//(*Destroy(gnupg_sign)
	//*)
}

/********************************************************/
void gnupg_sign::OnExit(wxCommandEvent& event)
{
    if(tellerror) EndModal(0);
    else EndModal(1);
}
/*********************************************************/
void gnupg_sign::OnSelectKey(wxCommandEvent& event)
{
    gpg_manag_priv dialog(this);
    if(dialog.ShowModal()==1)
    {
	  kyid_ctrl->SetValue(privkey);
	  kyinf_ctrl->SetValue(kylabel[pk_sel]);
    }
}
/******************************************************/
void gnupg_sign::OnSelectFile(wxCommandEvent& event)
{
    wxString signam,fnam,docp;

    if(cur_doc_path.IsEmpty())
    {
        docp = doc_path; //first call
    }
    else
    {
        docp = cur_doc_path;
    }
    fnam = wxFileSelector(_("Open a file for signing"),docp);
    if ( wxFile::Exists(fnam) )
    {
        fnam_ctrl->SetValue(fnam);
        cur_doc_path= ((wxFileName)fnam).GetPath(); //get new path and store into cur_doc_path
        //set also prospective signature file
        signam= fnam + _(".sig");
        signam_ctrl->SetValue(signam);
    }
    else
    {
        throwout(_("file to gnupg-sign does not exist!\nDo Nothing."),3);
        return;
    }

    return;
}
/*************************************************************/
void gnupg_sign::OnDoSign(wxCommandEvent& event)
{
    wxString fnam,snam,pw,k_id;

    fnam=fnam_ctrl->GetLineText(0);
    //check for existence
    if(!wxFile::Exists(fnam))
    {
        throwout(_("file to sign does not exist!\nDo Nothing."),3);
        return;
    }
    snam=signam_ctrl->GetLineText(0);
    k_id=kyid_ctrl->GetLineText(0);

    if(gpg_create_sig(k_id,fnam,snam)) throwout(_("GnuPG detached signature created."),3);
    else{
            gpg_blank();
            EndModal(0);
            Close();
    }
}
/*********************************************************************/

void gnupg_sign::OnTimer1Trigger(wxTimerEvent& event)
{
    if(tellerror) EndModal(0);
    else{
        Timer1.Start(1000,wxTIMER_ONE_SHOT);
    }
}
/*************************************************************************/
/*******************************************************/
void gnupg_sign::OnDropFile(wxDropFilesEvent& event)
    {
        int filno;
        drop_succ=false;
        wxString signam;

        if (event.GetNumberOfFiles() > 0) {

            wxString* dropped = event.GetFiles();
            wxASSERT(dropped);

            wxBusyCursor busyCursor;
            wxWindowDisabler disabler;
            wxBusyInfo busyInfo(_("Adding file, wait please..."));

            wxString name;
            filno = event.GetNumberOfFiles();
            if(filno!=1)
            {
				throwout(_("Can only enter single filename here.\nDrop rejected!"),3);
				return;
			}
			if( wxDirExists( 	dropped[0]	))
            {
                throwout(_("Directoryname!\nCan only enter single filename here.\nDrop rejected!"),3);
                return;
            }
			name = dropped[0];
			if (!wxFileExists(name))
            {
				throwout(_("File does not exist\nDrop rejected!"),5);
				return;
			}

            wxTextCtrl* textCtrl = dynamic_cast<wxTextCtrl*>(event.GetEventObject());
            wxASSERT(textCtrl);
            textCtrl->Clear();
            textCtrl->SetValue(name);
            drop_succ=true;
            fnam=name;
            cur_doc_path= ((wxFileName)fnam).GetPath(); //get new path and store into cur_doc_path

                    //set also prospective signature file
            signam= fnam + _(".sig");
            signam_ctrl->SetValue(signam);

            return;
        }
    }
/*********************************************************/

