/*
 *   Copyright (C) 2011-2019, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */


#include "get_prime.h"
#include "globals.h"

//(*InternalHeaders(get_prime)
#include <wx/string.h>
#include <wx/intl.h>
#include <wx/font.h>
//*)

//(*IdInit(get_prime)
const long get_prime::ID_BUTTON2 = wxNewId();
const long get_prime::ID_STATICTEXT1 = wxNewId();
const long get_prime::ID_STATICTEXT2 = wxNewId();
const long get_prime::ID_TEXTCTRL1 = wxNewId();
const long get_prime::ID_STATICTEXT3 = wxNewId();
const long get_prime::ID_TEXTCTRL2 = wxNewId();
const long get_prime::ID_BUTTON5 = wxNewId();
const long get_prime::ID_BUTTON6 = wxNewId();
const long get_prime::ID_BUTTON1 = wxNewId();
const long get_prime::ID_TEXTCTRL3 = wxNewId();
const long get_prime::ID_BUTTON3 = wxNewId();
const long get_prime::ID_BUTTON4 = wxNewId();
const long get_prime::ID_CHECKBOX1 = wxNewId();
//*)

BEGIN_EVENT_TABLE(get_prime,wxDialog)
	//(*EventTable(get_prime)
	//*)
END_EVENT_TABLE()

get_prime::get_prime(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
	//(*Initialize(get_prime)
	wxFlexGridSizer* FlexGridSizer1;
	Create(parent, id, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("id"));
	FlexGridSizer1 = new wxFlexGridSizer(0, 2, 0, 0);
	Button2 = new wxButton(this, ID_BUTTON2, _("Exit"), wxDefaultPosition, wxSize(80,32), 0, wxDefaultValidator, _T("ID_BUTTON2"));
	Button2->SetBackgroundColour(wxColour(248,172,172));
	wxFont Button2Font(11,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button2->SetFont(Button2Font);
	FlexGridSizer1->Add(Button2, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	StaticText1 = new wxStaticText(this, ID_STATICTEXT1, _("Produce a large Prime"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT1"));
	wxFont StaticText1Font(14,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText1->SetFont(StaticText1Font);
	FlexGridSizer1->Add(StaticText1, 1, wxALL|wxALIGN_BOTTOM|wxALIGN_CENTER_HORIZONTAL, 5);
	StaticText2 = new wxStaticText(this, ID_STATICTEXT2, _("in Hex:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT2"));
	wxFont StaticText2Font(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText2->SetFont(StaticText2Font);
	FlexGridSizer1->Add(StaticText2, 1, wxALL|wxALIGN_RIGHT|wxALIGN_TOP, 5);
	hexprim_ctrl = new wxTextCtrl(this, ID_TEXTCTRL1, _("-"), wxDefaultPosition, wxSize(819,104), wxTE_MULTILINE, wxDefaultValidator, _T("ID_TEXTCTRL1"));
	wxFont hexprim_ctrlFont(6,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	hexprim_ctrl->SetFont(hexprim_ctrlFont);
	FlexGridSizer1->Add(hexprim_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	StaticText3 = new wxStaticText(this, ID_STATICTEXT3, _("Decimal:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT3"));
	wxFont StaticText3Font(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText3->SetFont(StaticText3Font);
	FlexGridSizer1->Add(StaticText3, 1, wxALL|wxALIGN_RIGHT|wxALIGN_TOP, 5);
	decprim_ctrl = new wxTextCtrl(this, ID_TEXTCTRL2, _("-"), wxDefaultPosition, wxSize(818,100), wxTE_MULTILINE, wxDefaultValidator, _T("ID_TEXTCTRL2"));
	wxFont decprim_ctrlFont(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	decprim_ctrl->SetFont(decprim_ctrlFont);
	FlexGridSizer1->Add(decprim_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	Button5 = new wxButton(this, ID_BUTTON5, _("Hex to Dec"), wxDefaultPosition, wxSize(86,27), 0, wxDefaultValidator, _T("ID_BUTTON5"));
	wxFont Button5Font(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button5->SetFont(Button5Font);
	FlexGridSizer1->Add(Button5, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button6 = new wxButton(this, ID_BUTTON6, _("Dec to Hex"), wxDefaultPosition, wxSize(85,26), 0, wxDefaultValidator, _T("ID_BUTTON6"));
	wxFont Button6Font(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button6->SetFont(Button6Font);
	FlexGridSizer1->Add(Button6, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	Button1 = new wxButton(this, ID_BUTTON1, _("Random\nstarter\n->byteno"), wxDefaultPosition, wxSize(86,53), 0, wxDefaultValidator, _T("ID_BUTTON1"));
	wxFont Button1Font(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button1->SetFont(Button1Font);
	FlexGridSizer1->Add(Button1, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	bytno_ctrl = new wxTextCtrl(this, ID_TEXTCTRL3, _("10"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_TEXTCTRL3"));
	wxFont bytno_ctrlFont(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	bytno_ctrl->SetFont(bytno_ctrlFont);
	FlexGridSizer1->Add(bytno_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	Button3 = new wxButton(this, ID_BUTTON3, _("Next from\nHex"), wxDefaultPosition, wxSize(86,36), 0, wxDefaultValidator, _T("ID_BUTTON3"));
	wxFont Button3Font(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button3->SetFont(Button3Font);
	FlexGridSizer1->Add(Button3, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	Button4 = new wxButton(this, ID_BUTTON4, _("Next from\nDecimal"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON4"));
	wxFont Button4Font(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button4->SetFont(Button4Font);
	FlexGridSizer1->Add(Button4, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	FlexGridSizer1->Add(32,20,1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	mod4_ctrl = new wxCheckBox(this, ID_CHECKBOX1, _("only 3 mod 4"), wxDefaultPosition, wxSize(104,22), 0, wxDefaultValidator, _T("ID_CHECKBOX1"));
	mod4_ctrl->SetValue(false);
	wxFont mod4_ctrlFont(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	mod4_ctrl->SetFont(mod4_ctrlFont);
	FlexGridSizer1->Add(mod4_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	SetSizer(FlexGridSizer1);
	FlexGridSizer1->Fit(this);
	FlexGridSizer1->SetSizeHints(this);

	Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&get_prime::OnExit);
	Connect(ID_BUTTON5,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&get_prime::Hex_to_dec);
	Connect(ID_BUTTON6,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&get_prime::Dec_to_hex);
	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&get_prime::OnRandStarter);
	Connect(ID_BUTTON3,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&get_prime::OnNextHex);
	Connect(ID_BUTTON4,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&get_prime::OnNextPrimeDec);
	//*)
}
/**************************************************************************************/
get_prime::~get_prime()
{
	//(*Destroy(get_prime)
	//*)
}

/**************************************************************************************/
void get_prime::OnExit(wxCommandEvent& event)
{
    EndModal(0);
}
/**************************************************************************************/
void get_prime::OnRandStarter(wxCommandEvent& event)
{
    int bytno;
    longnumber stno;
    wxString hexno,decno,hs;

    //produce fitting longnumber from rand
    hs=bytno_ctrl->GetLineText(0);
    bytno = wxAtoi(hs);
    stno.makerandom(bytno);
    //convert and put into both fields
    stno.writehex(&hexno);
    stno.writechar(&decno);
    hexprim_ctrl->SetValue(hexno);
    decprim_ctrl->SetValue(decno);
    throwout(_("Startvalue for Primesearch was set!"),3);
    return;
}
/**************************************************************************************/
void get_prime::OnNextHex(wxCommandEvent& event)
{
    longnumber stno,incstp;
    wxString hexno,decno,mssg;
    unsigned int lino,i;
    unsigned long cnt;
    bool ck3;

    lino= hexprim_ctrl->GetNumberOfLines();
    hexno=hexprim_ctrl->GetLineText(0); //put in first line
    ck3=mod4_ctrl->IsChecked();
    if(ck3) incstp.storlong(4);
         else incstp.storlong(2);
    for(i=1;i<lino;i++) //put in the rest
    {
        hexno += hexprim_ctrl->GetLineText(i);
    }
    stno.storhex(&hexno);
    if(ck3) *(stno.ad) |= 3;
       else *(stno.ad) |= 1;
    stno.writechar(&decno);
    decprim_ctrl->SetValue(decno);
    cnt=1;
    while (!stno.isprime(5))
    {
      if(cnt%400==0)
      {
         mssg.Printf(_("No prime found yet\nafter %li attempts."),cnt);
         if(throwout(mssg,2)==1)
         {
             throwout(_("Aborting search"),1);
             return;
         }
      }
      cnt++;
      stno.addnum_q(&incstp);
    }
    mssg.Printf(_("Prime found after %li attempts."),cnt);
    throwout(mssg,3);
    stno.writehex(&hexno);
    stno.writechar(&decno);
    hexprim_ctrl->SetValue(hexno);
    decprim_ctrl->SetValue(decno);
    return;
}
/**************************************************************************************/
void get_prime::OnNextPrimeDec(wxCommandEvent& event)
{
    longnumber stno,incstp;
    wxString hexno,decno,mssg;
    unsigned long cnt;
    unsigned int lino,i;
    bool ck3;


    lino= decprim_ctrl->GetNumberOfLines();
    decno=decprim_ctrl->GetLineText(0);
    for(i=1;i<lino;i++) //put in the rest
    {
        decno += decprim_ctrl->GetLineText(i);
    }
    stno.storchar(&decno);
    stno.writehex(&hexno);
    hexprim_ctrl->SetValue(hexno);
    ck3=mod4_ctrl->IsChecked();
    if(ck3){ incstp.storlong(4);  *(stno.ad) |= 3;}
         else {incstp.storlong(2); *(stno.ad) |= 1;}
    cnt=1;
    while (!stno.isprime(5))
    {
      if(cnt%400==0)
      {
         mssg.Printf(_("No prime found yet\nafter %li attempts."),cnt);
         if(throwout(mssg,1)==2)
         {
             throwout(_("Aborting search"),1);
             return;
         }
      }
      cnt++;
      stno.addnum_q(&incstp);
    }
    mssg.Printf(_("Prime found after %li attempts."),cnt);
    throwout(mssg,3);
    stno.writehex(&hexno);
    stno.writechar(&decno);
    hexprim_ctrl->SetValue(hexno);
    decprim_ctrl->SetValue(decno);
    return;
}
/**************************************************************************************/
void get_prime::Hex_to_dec(wxCommandEvent& event)
{
    longnumber stno;
    wxString hexno,decno;
    unsigned int lino,i;


    lino= hexprim_ctrl->GetNumberOfLines();
    hexno=hexprim_ctrl->GetLineText(0); //put in first line
    for(i=1;i<lino;i++) //put in the rest
    {
        hexno += hexprim_ctrl->GetLineText(i);
    }
    stno.storhex(&hexno);
    stno.writehex(&hexno);
    stno.writechar(&decno);
    hexprim_ctrl->SetValue(hexno);
    decprim_ctrl->SetValue(decno);
    return;

}
/******************************************************************************************/
void get_prime::Dec_to_hex(wxCommandEvent& event)
{
    longnumber stno;
    wxString hexno,decno;
    unsigned int lino,i;


    lino= decprim_ctrl->GetNumberOfLines();
    decno=decprim_ctrl->GetLineText(0);
    for(i=1;i<lino;i++) //put in the rest
    {
        decno += decprim_ctrl->GetLineText(i);
    }
    stno.storchar(&decno);
    stno.writehex(&hexno);
    stno.writechar(&decno);
    hexprim_ctrl->SetValue(hexno);
    decprim_ctrl->SetValue(decno);
    return;
}
/***********************************************************************************************/
