/*
 *   Copyright (C) 2011-2019, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */


#include "LoadSave_ell_pub.h"

//(*InternalHeaders(LoadSave_ell_pub)
#include <wx/string.h>
#include <wx/intl.h>
#include <wx/font.h>
//*)

//#include "globals.h"  //im Header
#include "LoadEllKey.h"
#include <wx/filedlg.h>

//(*IdInit(LoadSave_ell_pub)
const long LoadSave_ell_pub::ID_BUTTON4 = wxNewId();
const long LoadSave_ell_pub::ID_STATICTEXT1 = wxNewId();
const long LoadSave_ell_pub::ID_STATICTEXT2 = wxNewId();
const long LoadSave_ell_pub::ID_STATICTEXT3 = wxNewId();
const long LoadSave_ell_pub::ID_STATICTEXT4 = wxNewId();
const long LoadSave_ell_pub::ID_TEXTCTRL1 = wxNewId();
const long LoadSave_ell_pub::ID_TEXTCTRL2 = wxNewId();
const long LoadSave_ell_pub::ID_TEXTCTRL3 = wxNewId();
const long LoadSave_ell_pub::ID_STATICTEXT5 = wxNewId();
const long LoadSave_ell_pub::ID_TEXTCTRL4 = wxNewId();
const long LoadSave_ell_pub::ID_STATICTEXT6 = wxNewId();
const long LoadSave_ell_pub::ID_TEXTCTRL5 = wxNewId();
const long LoadSave_ell_pub::ID_BUTTON1 = wxNewId();
const long LoadSave_ell_pub::ID_BUTTON2 = wxNewId();
const long LoadSave_ell_pub::ID_BUTTON3 = wxNewId();
//*)

BEGIN_EVENT_TABLE(LoadSave_ell_pub,wxDialog)
	//(*EventTable(LoadSave_ell_pub)
	//*)
END_EVENT_TABLE()

LoadSave_ell_pub::LoadSave_ell_pub(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
    wxString h;

    if(!checkarm()){Close();}
	//(*Initialize(LoadSave_ell_pub)
	wxFlexGridSizer* FlexGridSizer1;

	Create(parent, id, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("id"));
	SetBackgroundColour(wxColour(204,249,204));
	FlexGridSizer1 = new wxFlexGridSizer(0, 3, 0, 0);
	Button4 = new wxButton(this, ID_BUTTON4, _("Cance/Exit"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON4"));
	Button4->SetBackgroundColour(wxColour(242,174,174));
	wxFont Button4Font(11,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button4->SetFont(Button4Font);
	FlexGridSizer1->Add(Button4, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText1 = new wxStaticText(this, ID_STATICTEXT1, _("Load/Save extern public elliptic key"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT1"));
	StaticText1->SetForegroundColour(wxColour(14,163,40));
	wxFont StaticText1Font(14,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText1->SetFont(StaticText1Font);
	FlexGridSizer1->Add(StaticText1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	FlexGridSizer1->Add(-1,-1,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText2 = new wxStaticText(this, ID_STATICTEXT2, _("ID:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT2"));
	wxFont StaticText2Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText2->SetFont(StaticText2Font);
	FlexGridSizer1->Add(StaticText2, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText3 = new wxStaticText(this, ID_STATICTEXT3, _("Name:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT3"));
	wxFont StaticText3Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText3->SetFont(StaticText3Font);
	FlexGridSizer1->Add(StaticText3, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText4 = new wxStaticText(this, ID_STATICTEXT4, _("Domain Name:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT4"));
	wxFont StaticText4Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText4->SetFont(StaticText4Font);
	FlexGridSizer1->Add(StaticText4, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	id_ctrl = new wxTextCtrl(this, ID_TEXTCTRL1, wxEmptyString, wxDefaultPosition, wxSize(113,23), 0, wxDefaultValidator, _T("ID_TEXTCTRL1"));
	wxFont id_ctrlFont(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	id_ctrl->SetFont(id_ctrlFont);
	FlexGridSizer1->Add(id_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	name_ctrl = new wxTextCtrl(this, ID_TEXTCTRL2, wxEmptyString, wxDefaultPosition, wxSize(387,22), 0, wxDefaultValidator, _T("ID_TEXTCTRL2"));
	wxFont name_ctrlFont(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	name_ctrl->SetFont(name_ctrlFont);
	FlexGridSizer1->Add(name_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	domnam_ctrl = new wxTextCtrl(this, ID_TEXTCTRL3, wxEmptyString, wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_TEXTCTRL3"));
	wxFont domnam_ctrlFont(7,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	domnam_ctrl->SetFont(domnam_ctrlFont);
	FlexGridSizer1->Add(domnam_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText5 = new wxStaticText(this, ID_STATICTEXT5, _("Ax:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT5"));
	wxFont StaticText5Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText5->SetFont(StaticText5Font);
	FlexGridSizer1->Add(StaticText5, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	ax_ctrl = new wxTextCtrl(this, ID_TEXTCTRL4, wxEmptyString, wxDefaultPosition, wxSize(575,22), 0, wxDefaultValidator, _T("ID_TEXTCTRL4"));
	wxFont ax_ctrlFont(7,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	ax_ctrl->SetFont(ax_ctrlFont);
	FlexGridSizer1->Add(ax_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	FlexGridSizer1->Add(20,11,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText6 = new wxStaticText(this, ID_STATICTEXT6, _("Ay:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT6"));
	wxFont StaticText6Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText6->SetFont(StaticText6Font);
	FlexGridSizer1->Add(StaticText6, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	ay_ctrl = new wxTextCtrl(this, ID_TEXTCTRL5, wxEmptyString, wxDefaultPosition, wxSize(577,22), 0, wxDefaultValidator, _T("ID_TEXTCTRL5"));
	wxFont ay_ctrlFont(7,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	ay_ctrl->SetFont(ay_ctrlFont);
	FlexGridSizer1->Add(ay_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	FlexGridSizer1->Add(20,12,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button1 = new wxButton(this, ID_BUTTON1, _("Save Locally"), wxDefaultPosition, wxSize(93,32), 0, wxDefaultValidator, _T("ID_BUTTON1"));
	wxFont Button1Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button1->SetFont(Button1Font);
	FlexGridSizer1->Add(Button1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button2 = new wxButton(this, ID_BUTTON2, _("Retrieve Locally"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON2"));
	wxFont Button2Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button2->SetFont(Button2Font);
	FlexGridSizer1->Add(Button2, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button3 = new wxButton(this, ID_BUTTON3, _("Import from File"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON3"));
	wxFont Button3Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button3->SetFont(Button3Font);
	FlexGridSizer1->Add(Button3, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	SetSizer(FlexGridSizer1);
	FlexGridSizer1->Fit(this);
	FlexGridSizer1->SetSizeHints(this);

	Connect(ID_BUTTON4,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&LoadSave_ell_pub::OnExit);
	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&LoadSave_ell_pub::OnSaveLocal);
	Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&LoadSave_ell_pub::OnGetLocal);
	Connect(ID_BUTTON3,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&LoadSave_ell_pub::OnImportFile);
	//*)

	loky.copy_pub_ky(&el_pk);
	id_ctrl->SetValue(loky.id);
	name_ctrl->SetValue(loky.fullnam);
	domnam_ctrl->SetValue(loky.domnam);
	loky.A.x.writehex(&h);
	ax_ctrl->SetValue(h);
	loky.A.y.writehex(&h);
	ay_ctrl->SetValue(h);
}
/*********************************************************/
LoadSave_ell_pub::~LoadSave_ell_pub()
{
	//(*Destroy(LoadSave_ell_pub)
	//*)
}

/*****************************************************************/
void LoadSave_ell_pub::OnSaveLocal(wxCommandEvent& event)
{
    wxString txa,tya;
    FILE *knamfil, *kfil;
    bool oldname=false;
    char buff1[400],buff2[400];
    int lbl;

    if(!checkarm()){Close();}
    loky.id=id_ctrl->GetLineText(0);
    loky.id.Replace(_(" "), _("_"));

    loky.fullnam=name_ctrl->GetLineText(0);
    loky.fullnam.Replace(_(" "), _("_"));

    loky.domnam=domnam_ctrl->GetLineText(0);
    loky.domnam.Replace(_(" "), _("_"));

    txa=ax_ctrl->GetLineText(0);
    loky.A.x.storhex(&txa);
    tya=ay_ctrl->GetLineText(0);
    loky.A.y.storhex(&tya);


    if(!validate_pubkey(&loky))
    {
        throwout(_("invalid public key"),2);
        return;
    }
    //open keynamfile, append name and id, close keynamfile

    if(!pub_keyid_free(loky.id,false))
    {
        throwout(loky.id + _("\nThis key ID is already in use for a Public Key\n Please use other ID!"));
        return;
    }
    if(!priv_keyid_free(loky.id,false))
    {
        throwout(loky.id + _("\nThis key ID is already used for a Private Key\nIf this is the corresponding Public Part-> derive in \"make new key\" dialog\nElse use other ID!\n Nothing done here!"),20);
        return;
    }
    if(S_FIL) unlockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang); // unlock keynamefile
    if((knamfil = fopen((const char*)(sec_path + _("/e_ell_knamfile.knf")).mb_str(wxConvLocal), "a"))== NULL) return;
    fprintf(knamfil, "id: %s  Name: %s  \n",(const char*)(loky.id).mb_str(wxConvUTF8),
                  (const char*)(loky.fullnam).mb_str(wxConvUTF8));
    fclose(knamfil);
    if(S_FIL) lockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang); // lock again

    // to do: decrypt keyfile
    //open keyfile, store all data and close
    if(S_FIL) unlockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // unlock keyfile
    if((kfil = fopen((const char*)(sec_path + _("/e_ell_Keyfile.kyf")).mb_str(wxConvLocal), "a"))== NULL) return;
    fprintf(kfil, "id: %s  Name: %s DomName: %s\n",(const char*)(loky.id).mb_str(wxConvUTF8),
                  (const char*)(loky.fullnam).mb_str(wxConvUTF8),(const char*)(loky.domnam).mb_str(wxConvUTF8) );
    (loky.A.x).writehex(&txa);
    (loky.A.y).writehex(&tya);

    fprintf(kfil,"Ax: %s \n Ay: %s \n \n", (const char*)txa.mb_str(wxConvUTF8), (const char*)tya.mb_str(wxConvUTF8));
    fclose(kfil);
    if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // unlock keynamefile
    throwout(_("public key saved to \nprotected internal storage!"));
    return;
}
/***************************************************************************/
void LoadSave_ell_pub::OnGetLocal(wxCommandEvent& event)
{
    wxString h;

    LoadEllKey dialog(this,&loky);
    dialog.ShowModal();
    if(!validate_pubkey(&loky))
    {
        throwout(_("invalid public key\nwill not use!"),2);
        return;
    }

    if(!checkarm()){Close();}
    id_ctrl->SetValue(loky.id);
    name_ctrl->SetValue(loky.fullnam);
    domnam_ctrl->SetValue(loky.domnam);
    loky.A.x.writehex(&h);
    ax_ctrl->SetValue(h);
    loky.A.y.writehex(&h);
    ay_ctrl->SetValue(h);
    el_pk.copy_pub_ky(&loky);
}
/********************************************************************/
void LoadSave_ell_pub::OnImportFile(wxCommandEvent& event)
{
    wxString importfile,h;
    el_pub oldkey;
    ellipse el;

    if(!checkarm()){Close();}
    oldkey.copy_pub_ky(&loky);
    importfile = wxFileSelector(_("Choose a file to open"),kytray,_(""),_("pell|"),_("regular pell|*.pell|anyfile|*"));
    if(!loky.get_from_file(importfile))
    {
        throwout(_("malformed key\n aborting key_load!"));
        loky.copy_pub_ky(&oldkey);
        return;
    }
    //check if domnam accessible
    if(!e_ls.isinlist(loky.domnam))
    {
        wxMessageBox(_("claimed key domain is not known\n will not load!\nresetting to last key"));
        loky.copy_pub_ky(&oldkey);
        return;
    }
    //check on curve?
    e_ls.getelp(&el,loky.domnam);
    if(! (loky.A).is_in_ellipse(&el))
    {
        //check if domnam accessible
        wxMessageBox(_("key is incompatible with claimed domain\n will not load!\nresetting to last key"));
        loky.copy_pub_ky(&oldkey);
        return;
    }
    // wenn bestanden jetzt alles eintragen
    id_ctrl->SetValue(loky.id);
    name_ctrl->SetValue(loky.fullnam);
    domnam_ctrl->SetValue(loky.domnam);
    loky.A.x.writehex(&h);
    ax_ctrl->SetValue(h);
    loky.A.y.writehex(&h);
    ay_ctrl->SetValue(h);
    el_pk.copy_pub_ky(&loky);
}
/************************************************************/
void LoadSave_ell_pub::OnExit(wxCommandEvent& event)
{
    Close();
}
/*****************************************************************/
