/*
 *   Copyright (C) 2011-2019, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */



#include "timstamp.h"
#include <wx/filedlg.h>
#include <wx/filename.h>
#include <wx/file.h>
#include <wx/ffile.h>

#include <wx/arrstr.h>
#include <wx/dir.h>
#include <wx/busyinfo.h>

#include "AskDialog.h"
#include "globals.h"
#include "ellky_load1.h"


//(*InternalHeaders(timstamp)
#include <wx/string.h>
#include <wx/intl.h>
#include <wx/font.h>
//*)

//(*IdInit(timstamp)
const long timstamp::ID_BUTTON1 = wxNewId();
const long timstamp::ID_STATICTEXT1 = wxNewId();
const long timstamp::ID_STATICTEXT2 = wxNewId();
const long timstamp::ID_STAMPEE_CTRL = wxNewId();
const long timstamp::ID_BUTTON3 = wxNewId();
const long timstamp::ID_STATICTEXT5 = wxNewId();
const long timstamp::ID_TIM_SIG_FIL_CTRL = wxNewId();
const long timstamp::ID_STATICTEXT3 = wxNewId();
const long timstamp::ID_TIM_INF_CTRL = wxNewId();
const long timstamp::ID_BUTTON4 = wxNewId();
const long timstamp::ID_STATICTEXT10 = wxNewId();
const long timstamp::ID_CLI_NAM = wxNewId();
const long timstamp::ID_STATICTEXT4 = wxNewId();
const long timstamp::ID_STATICTEXT11 = wxNewId();
const long timstamp::ID_COMM_CTRL = wxNewId();
const long timstamp::ID_TEXTCTRL3 = wxNewId();
const long timstamp::ID_STATICTEXT6 = wxNewId();
const long timstamp::ID_BUTTON5 = wxNewId();
const long timstamp::ID_STATICTEXT9 = wxNewId();
const long timstamp::ID_KYID_CTRL = wxNewId();
const long timstamp::ID_KYFULLNAM_CTRL = wxNewId();
const long timstamp::ID_CHOICE1 = wxNewId();
const long timstamp::ID_STATICTEXT7 = wxNewId();
const long timstamp::ID_BUTTON2 = wxNewId();
const long timstamp::ID_STATICTEXT8 = wxNewId();
const long timstamp::ID_TEXTCTRL1 = wxNewId();
const long timstamp::ID_TEXTCTRL2 = wxNewId();
const long timstamp::ID_TIMER1 = wxNewId();
//*)

BEGIN_EVENT_TABLE(timstamp,wxDialog)
	//(*EventTable(timstamp)
	//*)
END_EVENT_TABLE()

timstamp::timstamp(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{

    if(!checkarm()){EndModal(0);return;}
    half_min_counter=0;
    fnam=_("empty");
    nostop=true;
    longnumber  rndnam;


	//(*Initialize(timstamp)
	wxFlexGridSizer* FlexGridSizer1;

	Create(parent, wxID_ANY, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("wxID_ANY"));
	FlexGridSizer1 = new wxFlexGridSizer(0, 3, 0, 0);
	Button1 = new wxButton(this, ID_BUTTON1, _("Cancel/Exit"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON1"));
	Button1->SetBackgroundColour(wxColour(244,176,176));
	wxFont Button1Font(11,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button1->SetFont(Button1Font);
	FlexGridSizer1->Add(Button1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText1 = new wxStaticText(this, ID_STATICTEXT1, _("Make Timestamp for File"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT1"));
	wxFont StaticText1Font(14,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText1->SetFont(StaticText1Font);
	FlexGridSizer1->Add(StaticText1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	FlexGridSizer1->Add(20,14,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText2 = new wxStaticText(this, ID_STATICTEXT2, _("File to stamp:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT2"));
	wxFont StaticText2Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText2->SetFont(StaticText2Font);
	FlexGridSizer1->Add(StaticText2, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	stmpee_ctrl = new wxTextCtrl(this, ID_STAMPEE_CTRL, _("-"), wxDefaultPosition, wxSize(654,23), 0, wxDefaultValidator, _T("ID_STAMPEE_CTRL"));
	wxFont stmpee_ctrlFont(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	stmpee_ctrl->SetFont(stmpee_ctrlFont);
	FlexGridSizer1->Add(stmpee_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button3 = new wxButton(this, ID_BUTTON3, _("Select File to Stamp"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON3"));
	wxFont Button3Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button3->SetFont(Button3Font);
	FlexGridSizer1->Add(Button3, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText5 = new wxStaticText(this, ID_STATICTEXT5, _("Time Stamp File:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT5"));
	wxFont StaticText5Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText5->SetFont(StaticText5Font);
	FlexGridSizer1->Add(StaticText5, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	tim_sig_fil_ctrl = new wxTextCtrl(this, ID_TIM_SIG_FIL_CTRL, _("-"), wxDefaultPosition, wxSize(657,23), 0, wxDefaultValidator, _T("ID_TIM_SIG_FIL_CTRL"));
	wxFont tim_sig_fil_ctrlFont(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	tim_sig_fil_ctrl->SetFont(tim_sig_fil_ctrlFont);
	FlexGridSizer1->Add(tim_sig_fil_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	FlexGridSizer1->Add(-1,-1,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText3 = new wxStaticText(this, ID_STATICTEXT3, _("Timing_info\nand comment:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT3"));
	wxFont StaticText3Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText3->SetFont(StaticText3Font);
	FlexGridSizer1->Add(StaticText3, 1, wxALL|wxALIGN_RIGHT|wxALIGN_TOP, 5);
	tim_inf_ctrl = new wxTextCtrl(this, ID_TIM_INF_CTRL, _("-"), wxDefaultPosition, wxSize(661,74), wxTE_MULTILINE|wxTE_READONLY, wxDefaultValidator, _T("ID_TIM_INF_CTRL"));
	tim_inf_ctrl->SetForegroundColour(wxColour(17,16,119));
	tim_inf_ctrl->SetBackgroundColour(wxColour(225,240,249));
	wxFont tim_inf_ctrlFont(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	tim_inf_ctrl->SetFont(tim_inf_ctrlFont);
	FlexGridSizer1->Add(tim_inf_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	Button4 = new wxButton(this, ID_BUTTON4, _("Refresh"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON4"));
	wxFont Button4Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button4->SetFont(Button4Font);
	FlexGridSizer1->Add(Button4, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText10 = new wxStaticText(this, ID_STATICTEXT10, _("Client Name:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT10"));
	wxFont StaticText10Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText10->SetFont(StaticText10Font);
	FlexGridSizer1->Add(StaticText10, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	cli_nam_ctrl = new wxTextCtrl(this, ID_CLI_NAM, _("anonymous"), wxDefaultPosition, wxSize(658,23), 0, wxDefaultValidator, _T("ID_CLI_NAM"));
	wxFont cli_nam_ctrlFont(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	cli_nam_ctrl->SetFont(cli_nam_ctrlFont);
	FlexGridSizer1->Add(cli_nam_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText4 = new wxStaticText(this, ID_STATICTEXT4, _("Time Zone"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT4"));
	wxFont StaticText4Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText4->SetFont(StaticText4Font);
	FlexGridSizer1->Add(StaticText4, 1, wxALL|wxALIGN_BOTTOM|wxALIGN_CENTER_HORIZONTAL, 5);
	StaticText11 = new wxStaticText(this, ID_STATICTEXT11, _("comment:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT11"));
	wxFont StaticText11Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText11->SetFont(StaticText11Font);
	FlexGridSizer1->Add(StaticText11, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	comment_ctrl = new wxTextCtrl(this, ID_COMM_CTRL, _("-"), wxDefaultPosition, wxSize(657,23), 0, wxDefaultValidator, _T("ID_COMM_CTRL"));
	wxFont comment_ctrlFont(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	comment_ctrl->SetFont(comment_ctrlFont);
	FlexGridSizer1->Add(comment_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	zone_ctrl = new wxTextCtrl(this, ID_TEXTCTRL3, _("MEZ"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_TEXTCTRL3"));
	wxFont zone_ctrlFont(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	zone_ctrl->SetFont(zone_ctrlFont);
	FlexGridSizer1->Add(zone_ctrl, 1, wxALL|wxALIGN_TOP|wxALIGN_CENTER_HORIZONTAL, 5);
	StaticText6 = new wxStaticText(this, ID_STATICTEXT6, _("use this (private) \nstamper key:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT6"));
	StaticText6->SetForegroundColour(wxColour(185,17,17));
	wxFont StaticText6Font(11,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText6->SetFont(StaticText6Font);
	FlexGridSizer1->Add(StaticText6, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button5 = new wxButton(this, ID_BUTTON5, _("Select Private Key"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON5"));
	Button5->SetBackgroundColour(wxColour(254,190,190));
	wxFont Button5Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button5->SetFont(Button5Font);
	FlexGridSizer1->Add(Button5, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	StaticText9 = new wxStaticText(this, ID_STATICTEXT9, _("Select Hash Algorithm"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT9"));
	wxFont StaticText9Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText9->SetFont(StaticText9Font);
	FlexGridSizer1->Add(StaticText9, 1, wxALL|wxALIGN_BOTTOM|wxALIGN_CENTER_HORIZONTAL, 5);
	kyid_ctrl = new wxTextCtrl(this, ID_KYID_CTRL, _("-"), wxDefaultPosition, wxSize(125,23), 0, wxDefaultValidator, _T("ID_KYID_CTRL"));
	kyid_ctrl->SetBackgroundColour(wxColour(249,192,192));
	wxFont kyid_ctrlFont(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	kyid_ctrl->SetFont(kyid_ctrlFont);
	FlexGridSizer1->Add(kyid_ctrl, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	ky_fullnam_ctrl = new wxTextCtrl(this, ID_KYFULLNAM_CTRL, _("-"), wxDefaultPosition, wxSize(367,23), 0, wxDefaultValidator, _T("ID_KYFULLNAM_CTRL"));
	ky_fullnam_ctrl->SetBackgroundColour(wxColour(247,190,190));
	wxFont ky_fullnam_ctrlFont(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	ky_fullnam_ctrl->SetFont(ky_fullnam_ctrlFont);
	FlexGridSizer1->Add(ky_fullnam_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	Choice1 = new wxChoice(this, ID_CHOICE1, wxDefaultPosition, wxSize(121,29), 0, 0, 0, wxDefaultValidator, _T("ID_CHOICE1"));
	Choice1->Append(_("sha256(256 bit)"));
	Choice1->Append(_("sha512(512 bit)"));
	Choice1->Append(_("JH (SHA3 Fin. 512 bit)"));
	Choice1->SetSelection( Choice1->Append(_("skein(SHA3 Fin. 1024bit)")) );
	Choice1->Append(_("Fleas_lx(4096 bit)"));
	Choice1->Append(_("Fleas_lx3(4096 bit)"));
	Choice1->Append(_("Fleas_c(4096 bit, 3 path)"));
	Choice1->Append(_("Fleas_d(4096 bit, 4 path)"));
	Choice1->Append(_("Fleas_b(4096 bit, 2 path)"));
	wxFont Choice1Font(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Choice1->SetFont(Choice1Font);
	FlexGridSizer1->Add(Choice1, 1, wxALL|wxALIGN_TOP|wxALIGN_CENTER_HORIZONTAL, 5);
	StaticText7 = new wxStaticText(this, ID_STATICTEXT7, _("Key Domain"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT7"));
	wxFont StaticText7Font(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText7->SetFont(StaticText7Font);
	FlexGridSizer1->Add(StaticText7, 1, wxALL|wxALIGN_RIGHT|wxALIGN_BOTTOM, 5);
	Button2 = new wxButton(this, ID_BUTTON2, _("Do Stamping"), wxDefaultPosition, wxSize(155,31), 0, wxDefaultValidator, _T("ID_BUTTON2"));
	Button2->SetBackgroundColour(wxColour(167,208,247));
	wxFont Button2Font(11,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button2->SetFont(Button2Font);
	FlexGridSizer1->Add(Button2, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText8 = new wxStaticText(this, ID_STATICTEXT8, _("Current Domain"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT8"));
	wxFont StaticText8Font(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText8->SetFont(StaticText8Font);
	FlexGridSizer1->Add(StaticText8, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	kydom_ctrl = new wxTextCtrl(this, ID_TEXTCTRL1, _("-"), wxDefaultPosition, wxSize(99,23), wxTE_READONLY, wxDefaultValidator, _T("ID_TEXTCTRL1"));
	wxFont kydom_ctrlFont(6,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	kydom_ctrl->SetFont(kydom_ctrlFont);
	FlexGridSizer1->Add(kydom_ctrl, 1, wxALL|wxALIGN_RIGHT|wxALIGN_TOP, 5);
	FlexGridSizer1->Add(20,11,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	currdom_ctrl = new wxTextCtrl(this, ID_TEXTCTRL2, _("-"), wxDefaultPosition, wxSize(102,23), wxTE_READONLY, wxDefaultValidator, _T("ID_TEXTCTRL2"));
	wxFont currdom_ctrlFont(6,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	currdom_ctrl->SetFont(currdom_ctrlFont);
	FlexGridSizer1->Add(currdom_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_TOP, 5);
	SetSizer(FlexGridSizer1);
	Timer1.SetOwner(this, ID_TIMER1);
	Timer1.Start(30000, false);
	FlexGridSizer1->Fit(this);
	FlexGridSizer1->SetSizeHints(this);

	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&timstamp::OnCancel);
	Connect(ID_BUTTON3,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&timstamp::OnSelect_stampee);
	Connect(ID_BUTTON4,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&timstamp::On_Refresh_Timing);
	Connect(ID_CLI_NAM,wxEVT_COMMAND_TEXT_UPDATED,(wxObjectEventFunction)&timstamp::OnChangeClient);
	Connect(ID_COMM_CTRL,wxEVT_COMMAND_TEXT_UPDATED,(wxObjectEventFunction)&timstamp::OnChangeClient);
	Connect(ID_TEXTCTRL3,wxEVT_COMMAND_TEXT_UPDATED,(wxObjectEventFunction)&timstamp::OnChangeClient);
	Connect(ID_BUTTON5,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&timstamp::OnSelPriv);
	Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&timstamp::OnStamp);
	Connect(ID_TIMER1,wxEVT_TIMER,(wxObjectEventFunction)&timstamp::OnTimer);
	//*)

    stmpee_ctrl->DragAcceptFiles(true);
    stmpee_ctrl->Connect(wxEVT_DROP_FILES, wxDropFilesEventHandler(timstamp::OnDropFile), NULL, this);

	currdom_ctrl->SetValue(gdom.name);
	kyid_ctrl->SetValue(elky.id);
	ky_fullnam_ctrl->SetValue(elky.fullnam);
	kydom_ctrl->SetValue(elky.domnam);
    //set timing info
    jetzt.SetToCurrent();
    tstring = jetzt.FormatISODate();
    tstring += _(" ");
    tstring += jetzt.FormatISOTime();
    client= _("anonymous");
    //set prefered hash
    if((def_hash>-1)&&(def_hash<6))
    {
        switch(def_hash)
        {
          case 0:
            Choice1->SetSelection(1); break; //sha512
          case 1:
            Choice1->SetSelection(2); break;  //JH
          case 2:
            Choice1->SetSelection(3); break;  //skein
          case 3:
            Choice1->SetSelection(8); break;  //Fleas_b
          case 4:
            Choice1->SetSelection(6); break;   //Fleas_c
          case 5:
            Choice1->SetSelection(7); break; //Fleas_d
           //no default necessary
        }
    }
    //make random name for timefile in folder of stampee
    rndnam.makerandom(10);
    rndnam.writehex(&timefile);
    keyselected=false;
	nostop=false;
	half_min_counter=0;
}
/***************************************************************/
timstamp::~timstamp()
{
	//(*Destroy(timstamp)
	//*)
}
/***************************************************************/


void timstamp::OnCancel(wxCommandEvent& event)
{
    EndModal(0);
}
/*******************************************************/
void timstamp::OnDropFile(wxDropFilesEvent& event)
    {
        wxString tmsg_fnam;
        int firfil=0, filno;
        drop_succ=false;

        if (event.GetNumberOfFiles() > 0) {

            wxString* dropped = event.GetFiles();
            wxASSERT(dropped);

            wxBusyCursor busyCursor;
            wxWindowDisabler disabler;
            wxBusyInfo busyInfo(_("Adding file, wait please..."));

            wxString name;
            filno = event.GetNumberOfFiles();
            if(filno!=1)
            {
				throwout(_("Can only enter single filename here.\nDrop rejected!"),3);
				return;
			}
			if( wxDirExists( 	dropped[0]	))
            {
                throwout(_("Directoryname!\nCan only enter single filename here.\nDrop rejected!"),3);
                return;
            }
			name = dropped[0];
			if (!wxFileExists(name))
            {
				throwout(_("File does not exist\nDrop rejected!"),5);
				return;
			}
        //first get nude filename for timefile
        timefile= ((wxFileName)timefile).GetName();
        timefile=((wxFileName)name).GetPathWithSep() + timefile;//fixed timefile for win10

            wxTextCtrl* textCtrl = dynamic_cast<wxTextCtrl*>(event.GetEventObject());
            wxASSERT(textCtrl);
            textCtrl->Clear();
            textCtrl->SetValue(name);
            drop_succ=true;
            //now set timefile name
            fnam=name;
            cur_doc_path= ((wxFileName)fnam).GetPath(); //get new path and store into cur_doc_path
            //stmpee_ctrl->SetValue(fnam);
            tmsg_fnam=fnam + _(".ects");
            tim_sig_fil_ctrl->SetValue(tmsg_fnam);
            //On_Refresh_Timing(event);
            return;
        }
    }
/*********************************************************/
/***************************************************************/

void timstamp::OnSelect_stampee(wxCommandEvent& event)
{
    wxString tmsg_fnam,docp;

    nostop=true;
    if(cur_doc_path.IsEmpty())
    {
        docp = doc_path; //first call
    }
    else
    {
        docp = cur_doc_path;
    }
     fnam = wxFileSelector(_("Open a file for time stamping"),docp);
    if ( !fnam.empty() )
    {
        cur_doc_path= ((wxFileName)fnam).GetPath(); //get new path and store into cur_doc_path
        //first get nude filename for timefile
        timefile= ((wxFileName)timefile).GetName();
        timefile=((wxFileName)fnam).GetPathWithSep() + timefile;//fixed timefile for win10
        stmpee_ctrl->SetValue(fnam);
        tmsg_fnam=fnam + _(".ects");
        tim_sig_fil_ctrl->SetValue(tmsg_fnam);
        On_Refresh_Timing(event);
    }
    nostop=false;
    return;
}
/***************************************************************/

void timstamp::On_Refresh_Timing(wxCommandEvent& event)
{
    wxString fnam_trunk,hlp;

    nostop=true;
    jetzt.SetToCurrent();
    tstring = jetzt.FormatISODate();
    tstring += _(" ");
    tstring += jetzt.FormatISOTime();
    fnam=stmpee_ctrl->GetLineText(0);
    fnam_trunk= ((wxFileName)fnam).GetName();
    //change blanks to underscore
    fnam_trunk.Replace(_(" "),_("_"));
    if(((wxFileName) fnam).HasExt())
    {
        fnam_trunk = fnam_trunk + _(".") +((wxFileName)fnam).GetExt();
    }
    client= cli_nam_ctrl->GetLineText(0);
    //change blanks to underscore
    client.Replace(_(" "),_("_"));
    hlp= _("Timestamping ") + fnam_trunk;;
    hlp= hlp + _(" for ");
    hlp= hlp + client;
    hlp= hlp + _("\nat: ");
    tstring= hlp + tstring;
    tstring += _(" ");
    hlp=zone_ctrl->GetLineText(0);
    hlp.Replace(_(" "),_("_"));
    tstring += hlp;
    tstring = tstring + _(" \nby ");
    hlp= ky_fullnam_ctrl->GetLineText(0);
    hlp.Replace(_(" "),_("_"));
    tstring += hlp;
    tstring = tstring + _(" using_key: ");
    tstring += kyid_ctrl->GetLineText(0);
    tstring += _("\nComment: ");
    hlp= comment_ctrl->GetLineText(0);
    hlp.Replace(_(" "),_("_"));
    hlp.Replace(_("\n"),_("_"));
    tstring += hlp;
    tim_inf_ctrl->SetValue(tstring);
    nostop=false;
    return;
}
/*********************************************************/
void timstamp::MakeDateFile()
{
    wxString nts,bb_str;
    int lino,i;

    nostop=true;
//get filename and open
    wxFFile tfil(timefile,_("wb"));
    bb_str= _("\n* ************************************************ ");
    tfil.Write(bb_str + _("\n\n"));
//Write tstring into it
    lino= tim_inf_ctrl->GetNumberOfLines();
    nts=tim_inf_ctrl->GetLineText(0); //put in first line
    for(i=1;i<lino;i++) //put in the rest
    {
        nts += _("\n");
        nts += tim_inf_ctrl->GetLineText(i);
    }
    tstring=nts;
    tfil.Write(nts);
    bb_str= _("\n* ************************************************ ");
    tfil.Write(bb_str+ _("\n"));
//close File
    tfil.Close();
    nostop=false;
    return;
}
/**********************************************************/

void timstamp::OnTimer(wxTimerEvent& event)
{
    half_min_counter++;
    if((half_min_counter > 10)&&(!nostop))  //mehr als 5 Minuten idle
    {
        unarm();
        EndModal(0);
    }
    return;
}
/*********************************************************/
void timstamp::OnStamp(wxCommandEvent& event)
{
    longnumber h_doc,h_time,r,s,rndnam;
    int hnum,domfl;
    char *myblock;
    int totsize;
    ellipse sigdom;

    wxString algo,tmp_fnam,signam,tmp_stmpee,txt;

    //check for presence of keydomain
    if(gdom.name != elky.domnam)
    {
        domfl=e_ls.getelp(&sigdom,elky.domnam);
        if(domfl<0)
        {
        throwout(_("key_domain doesn't match current domain\n nor does it match any in the ellipse portfolio\nwill not sign!\nPlease import domain matching key-domain!\n\n  SIGNING REFUSED!"),10);
        return;
        }
    }
    else sigdom.copyell(&gdom); //if identical copy into local domain
    //check for neglectance key id my_first
    if(!keyselected && (ky_fullnam_ctrl->GetLineText(0)==_("Zorro")))
    {
        throwout(_("You seem to have forgotten to select a valid signer key!\nPlease load appropriate Private Key first!"),20);
        return;
    }
    nostop=true;
    MakeDateFile();
    //readout algorithm
    hnum= Choice1->GetCurrentSelection();
    if(hnum==0) hash=_("sha2");
    else if(hnum==1) hash=_("sha4");
    else if(hnum==2) hash=_("JH");
    else if(hnum==3) hash=_("skein");
    else if(hnum==4) hash=_("Fleas_lx");
    else if(hnum==5) hash=_("Fleas_lx3");
    else if(hnum==6) hash=_("Fleas_c");
    else if(hnum==7) hash=_("Fleas_d");
    else if(hnum==8) hash=_("Fleas_b");
    //if(hnum==3) hash=_("Fleas_o2");
    //if(hnum==4) hash=_("Fleas_o5");
    //if(hnum==5) hash=_("Fleas_l");

    tmp_stmpee=stmpee_ctrl->GetLineText(0);
    //check for existence
    if(!wxFile::Exists(tmp_stmpee))
    {
        throwout(_("file stamp does not exist!\nDo Nothing."),3);
        return;
    }
    //check timefile for existence
    if(!wxFile::Exists(timefile))
    {
        throwout(_("timefile does not exist!\nDo Nothing."),3);
        return;
    }

    switch(hnum)
    {
        case 0:
          get_lonu_sha2_from_filename(&h_doc, &tmp_stmpee);
          get_lonu_sha2_from_filename(&h_time, &timefile);
          break;

        case 1:
          get_lonu_sha2_from_filename(&h_doc, &tmp_stmpee,512);
          get_lonu_sha2_from_filename(&h_time, &timefile,512);
          break;

        case 2:
          get_lonu_JH_from_filename(&h_doc, &tmp_stmpee,512);
          get_lonu_JH_from_filename(&h_time, &timefile,512);
          break;

        case 3:
          get_lonu_skein1024_from_filename(&h_doc, &tmp_stmpee,true);
          get_lonu_skein1024_from_filename(&h_time, &timefile,false);
          break;

        case 4:
        case 5:
        case 6:
          get_lonu_hash_from_filename_x(&h_doc, &tmp_stmpee,512,hash);
          get_lonu_hash_from_filename_x(&h_time, &timefile,128,hash,false);
          break;

        case 7:
        case 8:
          get_lonu_hash_from_filename_x(&h_doc, &tmp_stmpee,512,hash);
          get_lonu_hash_from_filename_x(&h_time, &timefile,512,hash,false);
          break;

        default:
          throwout(_("Warning!\n no hash specifier selected\n defaulting to Fleas_lc"),10);
          get_lonu_hash_from_filename_x(&h_doc, &tmp_stmpee,512,_("Fleas_c"));
          get_lonu_hash_from_filename_x(&h_time, &timefile,128,_("Fleas_c"),false);
    }
    //merge both to new product
    h_doc.setsize(true); h_time.setsize(true);
    totsize= (int)(h_doc.size + h_time.size);
    myblock = (char *) malloc(totsize);
    memcpy(myblock, h_doc.ad, h_doc.size);
    memcpy(myblock + h_doc.size, h_time.ad, h_time.size);
    if( !develop_o( myblock, totsize,2,3,2))
      {
        throwout(_("Alarm! Error in timstamp!"),20);
        free(myblock);
        return;
      }
    //in neues File mit zufallsnamen rausschreiben
    rndnam.makerandom(9);
    rndnam.writehex(&tmp_fnam);
    //brushup on tmp_fnam as with timefile
    tmp_fnam=((wxFileName)timefile).GetPathWithSep() + tmp_fnam;//fixed timefile for win10
    wxFFile tmpfil(tmp_fnam,_("wb"));
    tmpfil.Write(myblock,totsize);
    tmpfil.Close();
    //sign dual_hash_file
    sign_elliptic_qq(tmp_fnam, &sigdom, &elky, &r, &s,&hash,false); //signatur nach r und s
    //rausschreiben nach .ellsig
    signam=tmp_fnam +_(".ecsg");
    if(wxFile::Exists(signam))
    {
        AskDialog dlg(this,_("Elliptic Signature is already present\n overwrite(OK) or Cancel?"));
        if ( dlg.ShowModal() == 0 ) return;
    }
    wxFFile sfile(signam,_("wb"));
    txt=_("Domnam: ") + elky.domnam;
    sfile.Write(txt);
    r.writehex(&txt);
    txt= _("\n r: ") + txt;
    sfile.Write(txt);
    s.writehex(&txt);
    txt= _("\n s: ") + txt +_(" ");
    sfile.Write(txt);
    //for future clarity
    txt=_("\nHash: ") + hash + _(" ");
    sfile.Write(txt);
    sfile.Close();
    //throwout(_(" Signature created !"),3);
    //concatenate signature and timing info and rename to xxx.ects
    //get outfilename from dialog
    if(!fileconcat(signam, timefile, tim_sig_fil_ctrl->GetLineText(0), _("\n\nstamp_data: ")))
    {
        throwout(_("Error!\nFailed to create timestamp."),20);
    }
    else throwout(_("Timestamp generated!"),2);
    //clean away tempfiles
    //remove tempfile
    wxRemoveFile(signam);
    wxRemoveFile(tmp_fnam);
    wxRemoveFile(timefile);
    nostop=false;
    return;


}
/*********************************************************/

void timstamp::OnSelPriv(wxCommandEvent& event)
{
    ellipse keyllips;
    int elfl;

    if(!checkarm()){EndModal(0);return;}
    nostop=true;
    ellky_load1 dialog(this);
    if(dialog.ShowModal() == 1) keyselected = true;
    // ende Dialog
    //alles korrekt eintragen
	kyid_ctrl->SetValue(elky.id);
	ky_fullnam_ctrl->SetValue(elky.fullnam);
	kydom_ctrl->SetValue(elky.domnam);
	//jetzt A ermitteln
	if(elky.domnam == gdom.name) keyllips.copyell(&gdom);
	else
	{
        elfl=e_ls.getelp(&keyllips,elky.domnam);
        if(elfl<0)
        {
            throwout(_("Domain of Key unknown!\nMust import key-domain first\ncannot sign."),8);
        }
	}
    elky.A.copy_ep(&(keyllips.d0));
    elky.A.mult_p_qj(&(elky.d),&(keyllips));
    nostop=false;
    On_Refresh_Timing(event);
    return;
}
/**********************************************************/

void timstamp::OnChangeClient(wxCommandEvent& event)
{
    On_Refresh_Timing(event);
}
/*******************************************************/

