/*
 *   Copyright (C) 2011-2019, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <wx/thread.h>
#include <wx/progdlg.h>
#include <wx/filename.h>
#include "sign_ellip.h"
#include <wx/ffile.h>
#include <wx/arrstr.h>
#include <wx/dir.h>
#include <wx/busyinfo.h>

//(*InternalHeaders(sign_ellip)
#include <wx/string.h>
#include <wx/intl.h>
#include <wx/font.h>
#include <wx/bitmap.h>
#include <wx/image.h>
//*)
#include <wx/filedlg.h>
#include "AskDialog.h"
#include "globals.h"
#include "ellky_load1.h"
#include "AskInput.h"

/**********************************************************/
/**************************************************/
class prec_Thread : public wxThread
{
    public:
      prec_Thread(precalc *pprec, ellipse *pellps)
         : wxThread(wxTHREAD_JOINABLE)
         {
             ppre=pprec;
             telp.copyell(pellps);
             ppre->is_running=true;
             ppre->is_done=false;
         }
         ~prec_Thread();

    protected:
       virtual ExitCode Entry();
       precalc *ppre;
       ellipse telp;
};
/*******************************************************/
wxThread::ExitCode prec_Thread::Entry()
    {

        ppre->set_prec(&telp,true);
        //ppre->copy_pre(ppre);
        ppre->is_running=false;
        ppre->is_done=true;
        return (wxThread::ExitCode)0;     // success
    }

/*******************************************************/
prec_Thread::~prec_Thread()
{
    return;
}
/************************************************/

prec_Thread *m_pThread;




//(*IdInit(sign_ellip)
const long sign_ellip::ID_BUTTON4 = wxNewId();
const long sign_ellip::ID_STATICTEXT1 = wxNewId();
const long sign_ellip::ID_CHECKBOX1 = wxNewId();
const long sign_ellip::ID_STATICTEXT2 = wxNewId();
const long sign_ellip::ID_TEXTCTRL1 = wxNewId();
const long sign_ellip::ID_BUTTON1 = wxNewId();
const long sign_ellip::ID_STATICTEXT3 = wxNewId();
const long sign_ellip::ID_TEXTCTRL2 = wxNewId();
const long sign_ellip::ID_BUTTON2 = wxNewId();
const long sign_ellip::ID_STATICTEXT5 = wxNewId();
const long sign_ellip::ID_TEXTCTRL5 = wxNewId();
const long sign_ellip::ID_STATICTEXT6 = wxNewId();
const long sign_ellip::ID_STATICTEXT4 = wxNewId();
const long sign_ellip::ID_STATICBITMAP1 = wxNewId();
const long sign_ellip::ID_CHOICE1 = wxNewId();
const long sign_ellip::ID_TEXTCTRL3 = wxNewId();
const long sign_ellip::ID_BUTTON3 = wxNewId();
const long sign_ellip::ID_BUTTON5 = wxNewId();
const long sign_ellip::ID_TEXTCTRL4 = wxNewId();
const long sign_ellip::ID_TIMER1 = wxNewId();
//*)

BEGIN_EVENT_TABLE(sign_ellip,wxDialog)
	//(*EventTable(sign_ellip)
	//*)
END_EVENT_TABLE()

sign_ellip::sign_ellip(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
    if(!checkarm()){EndModal(0);return;}
    half_min_counter=0;
    thread_runs=false;
    nostop=true;

	//(*Initialize(sign_ellip)
	wxFlexGridSizer* FlexGridSizer1;

	Create(parent, id, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("id"));
	SetBackgroundColour(wxColour(248,226,226));
	FlexGridSizer1 = new wxFlexGridSizer(0, 3, 0, 0);
	Button4 = new wxButton(this, ID_BUTTON4, _("Cancel/Exit"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON4"));
	Button4->SetBackgroundColour(wxColour(249,175,175));
	wxFont Button4Font(11,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button4->SetFont(Button4Font);
	FlexGridSizer1->Add(Button4, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	StaticText1 = new wxStaticText(this, ID_STATICTEXT1, _("ECCS Sign File"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT1"));
	wxFont StaticText1Font(15,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText1->SetFont(StaticText1Font);
	FlexGridSizer1->Add(StaticText1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	detbox = new wxCheckBox(this, ID_CHECKBOX1, _("Deterministic Signature"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_CHECKBOX1"));
	detbox->SetValue(false);
	FlexGridSizer1->Add(detbox, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText2 = new wxStaticText(this, ID_STATICTEXT2, _("File to Sign:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT2"));
	wxFont StaticText2Font(11,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText2->SetFont(StaticText2Font);
	FlexGridSizer1->Add(StaticText2, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	filnam_ctrl = new wxTextCtrl(this, ID_TEXTCTRL1, wxEmptyString, wxDefaultPosition, wxSize(452,25), wxTE_PROCESS_ENTER, wxDefaultValidator, _T("ID_TEXTCTRL1"));
	wxFont filnam_ctrlFont(9,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	filnam_ctrl->SetFont(filnam_ctrlFont);
	FlexGridSizer1->Add(filnam_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button1 = new wxButton(this, ID_BUTTON1, _("Select File"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON1"));
	wxFont Button1Font(11,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button1->SetFont(Button1Font);
	FlexGridSizer1->Add(Button1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText3 = new wxStaticText(this, ID_STATICTEXT3, _("ECCS-Key ID: "), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT3"));
	wxFont StaticText3Font(11,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText3->SetFont(StaticText3Font);
	FlexGridSizer1->Add(StaticText3, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	kid_ctrl = new wxTextCtrl(this, ID_TEXTCTRL2, wxEmptyString, wxDefaultPosition, wxSize(265,27), 0, wxDefaultValidator, _T("ID_TEXTCTRL2"));
	kid_ctrl->Disable();
	kid_ctrl->SetForegroundColour(wxColour(215,11,11));
	wxFont kid_ctrlFont(11,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	kid_ctrl->SetFont(kid_ctrlFont);
	FlexGridSizer1->Add(kid_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	Button2 = new wxButton(this, ID_BUTTON2, _("Select other Key"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON2"));
	wxFont Button2Font(11,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button2->SetFont(Button2Font);
	FlexGridSizer1->Add(Button2, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText5 = new wxStaticText(this, ID_STATICTEXT5, _("Full Name:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT5"));
	wxFont StaticText5Font(11,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText5->SetFont(StaticText5Font);
	FlexGridSizer1->Add(StaticText5, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	fullnam_ctrl = new wxTextCtrl(this, ID_TEXTCTRL5, wxEmptyString, wxDefaultPosition, wxSize(448,27), 0, wxDefaultValidator, _T("ID_TEXTCTRL5"));
	fullnam_ctrl->Disable();
	wxFont fullnam_ctrlFont(10,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	fullnam_ctrl->SetFont(fullnam_ctrlFont);
	FlexGridSizer1->Add(fullnam_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	StaticText6 = new wxStaticText(this, ID_STATICTEXT6, _("Select Hash"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT6"));
	wxFont StaticText6Font(11,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText6->SetFont(StaticText6Font);
	FlexGridSizer1->Add(StaticText6, 1, wxALL|wxALIGN_BOTTOM|wxALIGN_CENTER_HORIZONTAL, 5);
	StaticText4 = new wxStaticText(this, ID_STATICTEXT4, _("Current System Domain \nKey Domain"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT4"));
	wxFont StaticText4Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText4->SetFont(StaticText4Font);
	FlexGridSizer1->Add(StaticText4, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	StaticBitmap1 = new wxStaticBitmap(this, ID_STATICBITMAP1, wxBitmap(wxImage(_T("unterschrift.png"))), wxDefaultPosition, wxDefaultSize, wxSIMPLE_BORDER, _T("ID_STATICBITMAP1"));
	FlexGridSizer1->Add(StaticBitmap1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Hash_choice = new wxChoice(this, ID_CHOICE1, wxDefaultPosition, wxSize(183,29), 0, 0, 0, wxDefaultValidator, _T("ID_CHOICE1"));
	Hash_choice->Append(_("sha256 (256bit)"));
	Hash_choice->SetSelection( Hash_choice->Append(_("sha512 (512bit)")) );
	Hash_choice->Append(_("JH (512 bit)"));
	Hash_choice->Append(_("skein(1024 bit)"));
	Hash_choice->Append(_("Fleas_lx3(4096 bit)"));
	Hash_choice->Append(_("Fleas_c(4096 bit,3 paths)"));
	Hash_choice->Append(_("Fleas_d(4096 bit,4 paths)"));
	Hash_choice->Append(_("Fleas_b(4096 bit,2 paths)"));
	wxFont Hash_choiceFont(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Hash_choice->SetFont(Hash_choiceFont);
	FlexGridSizer1->Add(Hash_choice, 1, wxALL|wxALIGN_TOP|wxALIGN_CENTER_HORIZONTAL, 5);
	cdom_ctrl = new wxTextCtrl(this, ID_TEXTCTRL3, wxEmptyString, wxDefaultPosition, wxSize(147,23), 0, wxDefaultValidator, _T("ID_TEXTCTRL3"));
	cdom_ctrl->Disable();
	wxFont cdom_ctrlFont(7,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	cdom_ctrl->SetFont(cdom_ctrlFont);
	FlexGridSizer1->Add(cdom_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	Button3 = new wxButton(this, ID_BUTTON3, _("Create Signature"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON3"));
	Button3->SetBackgroundColour(wxColour(206,247,223));
	wxFont Button3Font(11,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button3->SetFont(Button3Font);
	FlexGridSizer1->Add(Button3, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	MULTI_SIG = new wxButton(this, ID_BUTTON5, _("Multiple Signatures"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON5"));
	MULTI_SIG->SetBackgroundColour(wxColour(154,215,247));
	wxFont MULTI_SIGFont(11,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	MULTI_SIG->SetFont(MULTI_SIGFont);
	FlexGridSizer1->Add(MULTI_SIG, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	keydom_ctrl = new wxTextCtrl(this, ID_TEXTCTRL4, wxEmptyString, wxDefaultPosition, wxSize(149,23), 0, wxDefaultValidator, _T("ID_TEXTCTRL4"));
	keydom_ctrl->Disable();
	wxFont keydom_ctrlFont(7,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	keydom_ctrl->SetFont(keydom_ctrlFont);
	FlexGridSizer1->Add(keydom_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_TOP, 5);
	FlexGridSizer1->Add(-1,-1,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	SetSizer(FlexGridSizer1);
	Timer1.SetOwner(this, ID_TIMER1);
	Timer1.Start(6000, false);
	FlexGridSizer1->Fit(this);
	FlexGridSizer1->SetSizeHints(this);

	Connect(ID_BUTTON4,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&sign_ellip::OnCancel);
	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&sign_ellip::OnFileSel);
	Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&sign_ellip::OnSelKey);
	Connect(ID_BUTTON3,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&sign_ellip::OnSign);
	Connect(ID_BUTTON5,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&sign_ellip::OnMultiSign);
	Connect(ID_TIMER1,wxEVT_TIMER,(wxObjectEventFunction)&sign_ellip::OnTimer);
	//*)

    filnam_ctrl->DragAcceptFiles(true);
    filnam_ctrl->Connect(wxEVT_DROP_FILES, wxDropFilesEventHandler(sign_ellip::OnDropFile), NULL, this);

	//check if still Trivial
	if(elky.id==_("42"))
	{
        if(!load_priv_ell_ky(&elky, &def_privkey))
           {
               throwout(_("Could not load default private key!"),5);
               def_privkey=_("empty");
           }
    }

	cdom_ctrl->SetValue(gdom.name);
	kid_ctrl->SetValue(elky.id);
	fullnam_ctrl->SetValue(elky.fullnam);
	keydom_ctrl->SetValue(elky.domnam);
	//set default algorithm
	if((def_hash>-1)&&(def_hash<6))
    {
        switch(def_hash)
        {
          case 0:
            Hash_choice->SetSelection(1); break;

          case 1:
            Hash_choice->SetSelection(2); break;
          case 2:
            Hash_choice->SetSelection(3); break;
          case 3:
            Hash_choice->SetSelection(7); break;
          case 4:
            Hash_choice->SetSelection(5); break;
          case 5:
            Hash_choice->SetSelection(6); break;
           //no default necessary
        }
    }

	//get ellipse of key and precalculate
	if(e_ls.getelp(&elp,elky.domnam) <0)
	{
	    throwout(_("Warning, could not find default keys domain"),3);
	}
	else
	{
        m_pThread = new prec_Thread(&pre,&elp);
        thread_runs=true;
        if ( m_pThread->Create() != wxTHREAD_NO_ERROR )
        {
            throwout(_("Can't create the precalc thread!"),3);
            delete m_pThread;
            m_pThread = NULL;
            thread_runs=false;
        }
        else
        {
            if (m_pThread->Run() != wxTHREAD_NO_ERROR )
            {
                throwout(_("Can't run the precalc thread!"),3);
                delete m_pThread;
                m_pThread = NULL;
                thread_runs=false;
            }
        }
        //thread_runs=true;
	}
	nostop=false;
}
/************************************************************/
sign_ellip::~sign_ellip()
{
        if(thread_runs) //still one thread running -> kill it
        {
            throwout(_("Obsolete Precalculation thread still running\nMust clean up!\n\nPlease wait!"),1);
            m_pThread->Wait();
            delete m_pThread;
        }

	// (*Destroy(sign_ellip)
	// *)
}
/********************************************************/
/*******************************************************/
void sign_ellip::OnDropFile(wxDropFilesEvent& event)
    {
        int filno;
        drop_succ=false;

        if (event.GetNumberOfFiles() > 0) {

            wxString* dropped = event.GetFiles();
            wxASSERT(dropped);

            wxBusyCursor busyCursor;
            wxWindowDisabler disabler;
            wxBusyInfo busyInfo(_("Adding file, wait please..."));

            wxString name;
            filno = event.GetNumberOfFiles();
            if(filno!=1)
            {
				throwout(_("Can only enter single filename here.\nDrop rejected!"),3);
				return;
			}
			name = dropped[0];
			if (!wxFileExists(name))
            {
				throwout(_("File does not exist\nDrop rejected!"),5);
				return;
			}

            wxTextCtrl* textCtrl = dynamic_cast<wxTextCtrl*>(event.GetEventObject());
            wxASSERT(textCtrl);
            textCtrl->Clear();
            textCtrl->SetValue(name);
            drop_succ=true;
            fnam=name;
            cur_doc_path= ((wxFileName)fnam).GetPath(); //get new path and store into cur_doc_path
            return;
        }
    }
/*********************************************************/
void sign_ellip::OnFileSel(wxCommandEvent& event)
{
    wxString docp;

    nostop=true;
    if(cur_doc_path.IsEmpty())
    {
        docp = doc_path; //first call
    }
    else
    {
        docp = cur_doc_path;
    }
    fnam = wxFileSelector(_("Open a file for signing"),docp);
    if ( !fnam.empty() )
    {
        filnam_ctrl->SetValue(fnam);
        cur_doc_path= ((wxFileName)fnam).GetPath(); //get new path and store into cur_doc_path
    }
    nostop=false;
    return;
}
/******************************************************************/
void sign_ellip::OnSelKey(wxCommandEvent& event)
{
    long elfl;

    if(!checkarm()){EndModal(0);return;}
    nostop=true;

    ellky_load1 dialog(this);
    dialog.ShowModal();
    // ende Dialog
    //alles korrekt eintragen
	kid_ctrl->SetValue(elky.id);
	def_privkey=elky.id; //set as default
	fullnam_ctrl->SetValue(elky.fullnam);
	keydom_ctrl->SetValue(elky.domnam);
	//jetzt A ermitteln
	if(elky.domnam == gdom.name) elp.copyell(&gdom);
	else
	{
        elfl=e_ls.getelp(&elp,elky.domnam);
        if(elfl<0)
        {
            throwout(_("Domain of Key unknown!\nMust import key-domain first\ncannot sign."),8);
        }
	}
    //elky.A.copy_ep(&(keyllips.d0));
    //elky.A.mult_p_qj(&(elky.d),&(keyllips));
    //trigger new precalculation if necesary
    if(pre.domnam!=elky.domnam) //wrong pre_structure finish if necessary and start new
    {
        //if thread still running, wait for it to finish
        if(thread_runs)
        {
            //throwout(_("Old Precalculation still running\nmust clean up\n\nPlease wait!"),1);
            elfl=(long) m_pThread->Wait();
            thread_runs=false;
            delete m_pThread;
        }
        m_pThread = new prec_Thread(&pre,&elp);
        thread_runs=true;
        if ( m_pThread->Create() != wxTHREAD_NO_ERROR )
        {
            throwout(_("Can't create the precalc thread!"),3);
            delete m_pThread;
            m_pThread = NULL;
            thread_runs=false;
        }
        else
        {
            if (m_pThread->Run() != wxTHREAD_NO_ERROR )
            {
                throwout(_("Can't run the precalc thread!"),3);
                delete m_pThread;
                m_pThread = NULL;
                thread_runs=false;
            }
        }
        //thread_runs=true;
        //m_pThread->Wait();  //and join again
        //thread_runs=false;
       // pre.set_prec(&elp,true);
    }
    nostop=false;
    return;
}
/******************************************************************/
void sign_ellip::OnCancel(wxCommandEvent& event)
{
        if(thread_runs) //still one thread running -> kill it
        {
            //throwout(_("Obsolete Precalculation thread still running\nMust clean up!\n\nPlease wait!"),1);
            m_pThread->Wait();
            thread_runs=false;
            delete m_pThread;
        }
    EndModal(1);
}
/*******************************************************************************/
void sign_ellip::OnSign(wxCommandEvent& event)
{
    wxString sig2, txt,fnam,signam,hash=_("Fleas_1_8");
    longnumber r,s;
    int ifl,hnum,domfl;
    wxString detword;


    if(!checkarm()){EndModal(0);return;}
    //check if domain name matches
    nostop=true;
    //elp should have been set in entry routine
    detmin=detbox->IsChecked();
    if(elp.name != elky.domnam)
    {
        domfl=e_ls.getelp(&elp,elky.domnam);
        if(domfl<0)
        {
        throwout(_("key_domain doesn't match current domain\n nor does it match any in the ellipse portfolio\nwill not sign!\nPlease import domain matching key-domain!\n\n  SIGNING REFUSED!"),10);
        return;
        }
    }
    fnam =filnam_ctrl->GetLineText(0);
    //check
    if(!wxFileExists(fnam))
    {
        throwout(_("File to sign does not exist\naborting"),4);
        return;
    }
    //gethashvalue from choicebox
    hnum= Hash_choice->GetCurrentSelection();
    if(hnum==0) hash=_("sha2");
    else if(hnum==1) hash=_("sha4");
      else if(hnum==2) hash=_("JH");
        else if(hnum==3) hash=_("skein");
        else if(hnum==4) hash=_("Fleas_lx3");
          else if(hnum==5) hash=_("Fleas_c");
            else if(hnum==6) hash=_("Fleas_d");
              else if(hnum==7) hash=_("Fleas_b");
                else{ throwout(_("error in hash selection!\n defaulting to \"JH\"."),3); hash=_("JH");}
    //if(hnum==5) hash=_("Fleas_x2");
    //if(hnum==6) hash=_("Fleas_x5");
    //if(hnum==3) hash=_("Fleas_o2");
    //if(hnum==4) hash=_("Fleas_o5");
    //if(hnum==5) hash=_("Fleas_l");

    if(!detmin)
    {
       //if for whatever reason no process running
    if(!thread_runs)
    {
        m_pThread = new prec_Thread(&pre,&elp);
        thread_runs=true;
        if ( m_pThread->Create() != wxTHREAD_NO_ERROR )
        {
            throwout(_("Can't create the precalc thread!"),3);
            delete m_pThread;
            m_pThread = NULL;
            thread_runs=false;
        }
        else
        {
            if (m_pThread->Run() != wxTHREAD_NO_ERROR )
            {
                throwout(_("Can't run the precalc thread!"),3);
                delete m_pThread;
                m_pThread = NULL;
                thread_runs=false;
            }
        }
        //thread_runs=true;
        throwout(_("No precalculation thread running yet!?!\nStarting immediately!!!"),3);
        //ifl=sign_elliptic(fnam, &elp, &elky, &r, &s,&hash); //signatur nach r und s
        //pre.is_used=true;
      }
      m_pThread->Wait(); //wait for thread to finish aka join threads
      thread_runs=false;
      delete m_pThread; //added jan19
      if(pre.is_used) throwout(_("Warning\nusing ke a second time!!!?!"),3);
      ifl=sign_elliptic_pre(&pre,fnam, &elp, &elky, &r, &s,&hash); //signatur nach r und s
      pre.is_used=true;
    } //not deterministical
    else //deterministical
    {
        AskInput ainp(NULL,_("Give short determinate word"),&detword);
        if ( ainp.ShowModal() == 1 ) //mix with addtnl input
        ifl=sign_elliptic_qq(fnam,&elp,&elky,&r,&s,&hash,true,detmin,&detword);
        else
        ifl=sign_elliptic_qq(fnam,&elp,&elky,&r,&s,&hash,true,detmin,NULL);
    }

    //rausschreiben nach .ellsig
    signam=fnam +_(".ecsg");
    if(wxFile::Exists(signam))
    {
        AskDialog dlg(this,_("Elliptic Signature is already present\n overwrite(OK) or Cancel?"));
        if ( dlg.ShowModal() == 0 ) return;
    }
    wxFFile sfile(signam,_("wb"));
    txt=_("Domnam: ") + elp.name;
    sfile.Write(txt);
    r.writehex(&txt);
    txt= _("\n r: ") + txt;
    sfile.Write(txt);
    s.writehex(&txt);
    txt= _("\n s: ") + txt +_(" ");
    sfile.Write(txt);
    //for future clarity
    txt=_("\nHash: ") + hash + _(" ");
    sfile.Write(txt);
    sfile.Close();
    def_privkey=elky.id; //set as default
    //pre.set_prec(&elky,&sigdom);
    //use the threaded version instead
    if(!detmin)
    {
    //trigger new precalculation if necesary
    if(thread_runs) //still one running -> kill it
        {
            //should not happen
            throwout(_("eeek! should never see this message"));
            m_pThread->Wait();
            thread_runs=false;
            delete m_pThread;
        }
    m_pThread = new prec_Thread(&pre,&elp);
    thread_runs=true;
        if ( m_pThread->Create() != wxTHREAD_NO_ERROR )
        {
            throwout(_("Can't create the precalc thread!"),3);
            delete m_pThread;
            m_pThread = NULL;
            thread_runs=false;
        }
        else
        {
            if (m_pThread->Run() != wxTHREAD_NO_ERROR )
            {
                throwout(_("Can't run the precalc thread!"),3);
                delete m_pThread;
                m_pThread = NULL;
                thread_runs=false;
            }
        }
        //thread_runs=true;
    }
    //thread fired for next signatures precalculation
    throwout(_("Signature was created (*.ecsg) \n in directory of signed document."),5);
    half_min_counter=10;
    nostop=false;
    return;
}
/************************************************/
void sign_ellip::OnTimer(wxTimerEvent& event)
{
    half_min_counter++;
    if((half_min_counter > 30)&&(!nostop))  //mehr als 2 Minuten idle
    {
        if(thread_runs) //still one running -> kill it
        {
            throwout(_("Timeout"),2);
            m_pThread->Wait();
            thread_runs=false;
            delete m_pThread;
        }
        unarm();
        EndModal(0);
    }
    return;
}
/*************************************************/

void sign_ellip::OnMultiSign(wxCommandEvent& event)
{
    wxString txt,fnam, signam, hash=_("Fleas_1_8");
    longnumber r,s;
    int ifl,hnum,domfl,goodp,defcnt=0;
    wxString detword;
    wxString docp;


    int d_ret,i;
    int filnum;

    if(!checkarm()){EndModal(0);return;}
    //check if domain name matches
    nostop=true;
    detmin=detbox->IsChecked();

    if(cur_doc_path.IsEmpty())
    {
        docp = doc_path; //first call
    }
    else
    {
        docp = cur_doc_path;
    }

    //Get file list
   wxFileDialog fdlg(this, _("Select files for signing"),docp,_(""),_("*"), wxFD_OPEN|wxFD_FILE_MUST_EXIST|wxFD_MULTIPLE );
   wxArrayString wxstrad; //wxStringarray initialisieren
   d_ret=fdlg.ShowModal();
   fdlg.GetPaths(wxstrad);
   filnum=wxstrad.GetCount();
   if(filnum==0)
   {
       throwout(_("No file selected, do nothing!"),2);
       return;
   }
   //pick first as Directory setter
   cur_doc_path= ((wxFileName) (wxstrad.Last())).GetPath(); //get new path and store into cur_doc_path
   if(elp.name != elky.domnam)
   {
        domfl=e_ls.getelp(&elp,elky.domnam);
        if(domfl<0)
        {
        throwout(_("key_domain doesn't match current domain\n nor does it match any in the ellipse portfolio\nwill not sign!\nPlease import domain matching key-domain!\n\n  SIGNING REFUSED!"),10);
        return;
        }
    }
     //gethashvalue from choicebox
    hnum= Hash_choice->GetCurrentSelection();
    if(hnum==0) hash=_("sha2");
    else if(hnum==1) hash=_("sha4");
      else  if(hnum==2) hash=_("JH");
        else  if(hnum==3) hash=_("skein");
        else  if(hnum==4) hash=_("Fleas_lx3");
          else  if(hnum==5) hash=_("Fleas_c");
            else if(hnum==6) hash=_("Fleas_d");
              else if(hnum==7) hash=_("Fleas_b");


     wxProgressDialog *pbar;
     pbar= new wxProgressDialog(_("Signing Progress"),_("Working hard :-)"),filnum+1);

     //get Detword
    if(detmin) //deterministical
    {
        AskInput ainp(NULL,_("Give short determinate word"),&detword);
        if ( ainp.ShowModal() == 0 ) //make empty
        detword.Empty(); //empty the string
        //shorten if excessive to avoid repeated complaints vom signing routine
         if((detword).Len()>100)
         {
           throwout(_("Alert! suggested determinate excessively long\n truncating!"));
           detword.Truncate(100);
         }
    }

   // loop through all filenames and sign
   for(i=0;i<filnum;i++)
   {
       goodp=pbar->Update(i);
       //get name i
       fnam=wxstrad.Item(i);
       if(!wxFileExists(fnam))
       {
        throwout(_("File to sign does not exist\nskipping."),1);
        defcnt++;
        continue;
       }
       //check for deterministic
       detmin=detbox->IsChecked();
       //sign
       ifl=sign_elliptic_qq(fnam, &elp, &elky, &r, &s,&hash, false,detmin,&detword);
       if(ifl < 0)
       {
           txt.Printf(_("signing failed at signature number %i"), i);
           throwout(txt,1);
           defcnt++;
           continue;
       }

       signam=fnam +_(".ecsg");
       wxFFile sfile(signam,_("wb"));
       txt=_("Domnam: ") + elp.name;
       sfile.Write(txt);
       r.writehex(&txt);
       txt= _("\n r: ") + txt;
        sfile.Write(txt);
        s.writehex(&txt);
        txt= _("\n s: ") + txt +_(" ");
        sfile.Write(txt);
    //for future clarity
        txt=_("\nHash: ") + hash + _(" ");
        sfile.Write(txt);
        sfile.Close();
   }
    if(pbar!=NULL) delete pbar;
    def_privkey=elky.id; //set as default
    //final message
   txt.Printf(_("signed %i files out of %i requests\n %i signjobs failed."),filnum-defcnt,filnum,defcnt);
   throwout(txt);

    half_min_counter=10;
    nostop=false;
    return;
}
/*******************************************************/
