/*
 *   Copyright (C) 2011-2012, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */


#ifndef GPG_WRAP_INCLUDED
#define GPG_WRAP_INCLUDED

#include <stdlib.h>
#include <wx/string.h>
#include <wx/intl.h>
#include <wx/file.h>
#include <wx/msgdlg.h>

#include <wx/wx.h>
#include <wx/hashmap.h>
#include <wx/process.h>
#include <wx/txtstrm.h>
#include <wx/tokenzr.h>
#include <wx/regex.h>
#include <wx/textctrl.h>


#include "dolonu.h"
//#include "helpersxx.h"
//#include "helpersxx.h"


/****************************************************/
wxString _OpenGPGProcess(const wxString cmdLine, wxOutputStream * &in, wxInputStream * &out, wxInputStream * &err);
/**********************************************/
bool _CallGPGInt(const wxString cmdLine, wxArrayString &stdIn, wxArrayString &stdOut, wxArrayString &stdErr, wxString suc_code=_(""));
/**************************************************/
bool _CallGPGInt_pw(const wxString cmdLine, wxArrayString &stdIn, wxArrayString &stdOut, wxArrayString &stdErr, wxString suc_code=_("") );
/**************************************************/
bool gpg_version(wxString *pver);
bool gpg_get_name(wxString *name);
bool gpg2_get_name(wxString *name);
bool prog_is_present(wxString progname);
bool prog_is_win_present(wxString progname);
bool prog_is_win_present(wxString progname, wxString ext, wxString *pfullnam);

/**************************************************/
bool gpg_get_prilist(wxArrayString *plist);
/**************************************************/
bool gpg_get_publist(wxArrayString *plist);
/**************************************************/
int get_priv_labels(wxArrayString &lablz);
int get_priv_labels();
/**************************************************/
int get_pub_labels(wxArrayString &lablz);
int get_pub_labels();
/**************************************************/
bool gpg_verify_signature(wxString k_id, wxString fnam, wxString snam, wxString *msg);
/**************************************************/
bool gpg_create_sig(wxString k_id, wxString fnam, wxString snam);
/***************************************************/
bool writelog(wxString fnam, wxString msg);
bool writelog(wxString fnam, wxArrayString msgs);
/***************************************************/
bool gpg_remove_pubkey(wxString keyid);
/****************************************************/
bool gpg_import_pubkey(wxString fnam);
/****************************************************/
bool gpg_export_pubkey(wxString fnam, wxString id_of_key);
/****************************************************/
bool gpg_sign_pubkey(wxString k_id);
/****************************************************/
bool gpg_remove_privkey(wxString keyid);
/****************************************************/
bool gpg_import_privkey(wxString fnam);
/****************************************************/
bool gpg_export_privkey(wxString fnam, wxString id_of_key);
/****************************************************/
bool gpg_make_key(wxString nam, wxString cmnt, wxString imehl, wxString type, wxString klen, wxString pw, wxString expiry );
/***************************************************/
bool gpg_decrypt( wxString fnam, wxString outfile);
/***************************************************/
bool gpg_encode( wxString k_id, wxString fnam, wxString snam, wxString *msg);
/****************************************************/
void gpg_blank(); //disable gnupg on error
/*********************************************************/

#endif
