/*
 *   Copyright (C) 2011-2019, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
 

#ifndef ASKINPUT_H
#define ASKINPUT_H

//(*Headers(AskInput)
#include <wx/dialog.h>
#include <wx/sizer.h>
#include <wx/button.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>
#include <wx/timer.h>
//*)

class AskInput: public wxDialog
{
	public:

		AskInput(wxWindow* parent,wxString messg, wxString *panswer, wxWindowID id=wxID_ANY,const wxPoint& pos=wxDefaultPosition,const wxSize& size=wxDefaultSize);
		virtual ~AskInput();

		//(*Declarations(AskInput)
		wxTextCtrl* line_ctrl;
		wxButton* Button1;
		wxButton* Button2;
		wxTimer Timer1;
		wxTextCtrl* messg_ctrl;
		wxStaticText* StaticText2;
		//*)

	protected:

		//(*Identifiers(AskInput)
		static const long ID_BUTTON1;
		static const long ID_TEXTCTRL1;
		static const long ID_STATICTEXT2;
		static const long ID_TEXTCTRL2;
		static const long ID_BUTTON2;
		static const long ID_TIMER1;
		//*)

	private:

		//(*Handlers(AskInput)
		void OnCancel(wxCommandEvent& event);
		void OnOk(wxCommandEvent& event);
		void OnTimer1Trigger(wxTimerEvent& event);
		//*)

		DECLARE_EVENT_TABLE()


		int half_min_counter;
		wxString *pansw;
};

#endif
