/***************************************************************
 * Name:      clean_pointersMain.cpp
 * Purpose:   Code for Application Frame
 * Author:    mca (an@fh-wedel.de)
 * Created:   2010-09-14
 * Copyright: mca ()
 * License:
 *   Copyright (C) 2011-2014, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 ************************************************************************/

#if defined(__WXMSW__)
  //to be filled
#else
 #include <sys/mman.h>  //allow for memory locking of keyinfo
#endif


//#include <pthread.h>
#include <wx/thread.h>
#include <stdio.h> //needed here?
#include <stdlib.h>  //needed here?

#include <wx/msgdlg.h>
#include <wx/filedlg.h>
#include <wx/file.h>
#include <time.h>
#include <wx/progdlg.h>

//( *InternalHeaders(clean_pointersFrame)
#include <wx/intl.h>
#include <wx/string.h>



#include <wx/string.h>
#include <wx/file.h>
#include <wx/intl.h>
#include <wx/msgdlg.h>

#include "elliptic1.h"
#include "globals.h"


/******************  wxThread  *****************************/
//#include <wx/thread.h>
//void start_my_thread();

/**************************************************/
class MyThread : public wxThread
    {
    public:
        MyThread(void *tq)
            : wxThread(wxTHREAD_JOINABLE)
            {
                tp= (e_p **) tq;
                pp= (e_p *) *tp;
                pf= (longnumber *)  (*(tp+1));
                elp=(ellipse *) (*(tp +2));
            }
        ~MyThread();

    protected:
        virtual ExitCode Entry();
        longnumber *pf;
        e_p *pp,**tp;
        ellipse *elp;
    };
/*******************************************************/
wxThread::ExitCode MyThread::Entry()
    {
        pp->mult_p_qj(pf,elp);

        return (wxThread::ExitCode)0;     // success
    }

/*******************************************************/
MyThread::~MyThread()
{
    return;
}
/************************************************/
/**************************************************/
class DoppThread : public wxThread
    {
    public:
        DoppThread(proj_jacobian *ppt, ellipse *ept)
            : wxThread(wxTHREAD_JOINABLE)
            {
                pp= ppt;
                elp= ept;
            }
        ~DoppThread();

    protected:
        virtual ExitCode Entry();
        proj_jacobian *pp;
        ellipse *elp;
    };
/*******************************************************/
wxThread::ExitCode DoppThread::Entry()
    {
        pp->dopp(elp);

        return (wxThread::ExitCode)0;     // success
    }

/*******************************************************/
DoppThread::~DoppThread()
{
    return;
}
/************************************************/
/**************************************************/
void *th_multip( void *tq );
void *th_doubl( void *tq );
/**********************************/
e_p::e_p()
{
    x.storlong(0);
    y.storlong(0);
    neutral=true;
};
/**********************************/
e_p::e_p(longnumber* xin, longnumber* yin)
{
    x.copynum(xin);
    y.copynum(yin);
    neutral=false;
}
/************************************/
bool e_p::copy_ep(e_p* source)
{
    x.copynum(&(source->x));
    y.copynum(&(source->y));
    neutral= source->neutral;
    return true;
}
/*******************************************************/
int e_p::subtract(e_p* summand,ellipse* ewp)
{
    longnumber yps;

    if(summand->neutral) return 0;
    //invert summand
    e_p subtrh;
    subtrh.copy_ep(summand);
    yps.copynum(&(ewp->p));
    yps.subtrnum_q(&(summand->y),&(ewp->p));
    (subtrh.y).copynum(&yps);
    //inverted?
    //call add
    return (add(&subtrh, ewp));
}
/*******************************************************/
/************************************/
int e_p::add(e_p* summand,ellipse* ewp)
{
    longnumber s,h,h1,y3,x3;
    bool flag;

    //check if equal
    if(isequal(summand,&(ewp->p)))
    {
        return dopp(ewp);
    }
    // if one is neutral...
    if(summand->neutral) return 0;
    if(neutral)
    {
        copy_ep(summand);
        neutral=false;
        return 0;
    }
    // determine s= (y2-y1) / (x2 - x1)
    h.copynum(&(summand->x));
    h.subtrnum_q(&x,&(ewp->p));
    if(h.size==0)
    {
        neutralize();
        return 0;
    }
    //inverses bestimmen
    flag=h.get_mod_inv_q(&s, &(ewp->p));
    h1.copynum(&(summand->y));
    h1.subtrnum_q(&y,&(ewp->p));
    s.multnum_q(&h1,&(ewp->p));
    x3.copynum(&s);
    x3.quadmodul_l1( &(ewp->p));
    // calc x3= s^2 -x1 -x2 and y3= s(x1-x3) - y1
    x3.subtrnum_q(&x, &(ewp->p));
    x3.subtrnum_q(&(summand->x), &(ewp->p));
    y3.copynum(&x);
    y3.subtrnum_q(&x3, &(ewp->p));
    y3.multnum_l1(&s, &(ewp->p));
    y3.subtrnum_q(&y, &(ewp->p));

    x.swapnum(&x3);
    y.swapnum(&y3);

    return 1;
}
/************************************/
int e_p::dopp(ellipse* ewp)
{
    longnumber s,h,h1,y3,x3,drei;
    bool flag;


    if(neutral) return 0;
    // determine s= (3x^2+a)/2y
    h.copynum(&y);
    h.shiftoneup_q();
    h.cheap_modreduce(&(ewp->p));
    flag=h.get_mod_inv_q(&s, &(ewp->p)); //1/2y
    h1.copynum(&x);
    h1.quadmodul_q(&(ewp->p));
    drei.storlong(3);
    h1.multnum_q(&drei,&(ewp->p));
    h1.addnum_q(&(ewp->a));
    s.multnum_q(&h1,&(ewp->p)); //jetzt ist s fertig

    x3.copynum(&s);
    x3.quadmodul_q( &(ewp->p));
    // calc x3= s^2 -x1 -x2 and y3= s(x1-x3) - y1
    x3.subtrnum_q(&x, &(ewp->p));
    x3.subtrnum_q(&x, &(ewp->p)); // jetzt ist x3-dopp fertig

    y3.copynum(&x);
    y3.subtrnum_q(&x3, &(ewp->p));
    y3.multnum_q(&s, &(ewp->p));
    y3.subtrnum_q(&y, &(ewp->p));

    x.swapnum(&x3);
    y.swapnum(&y3);

    return 1;
}
/************************************/
bool e_p::isequal(e_p* point)
{
    if(x.compare(&(point->x)) != 0) return false;
    if(y.compare(&(point->y)) != 0) return false;
    return true;
}
/************************************/
bool e_p::isequal(e_p* point, longnumber* modul)
{
    x.lonumodulo_qqq(modul);
    y.lonumodulo_qqq(modul);
    (point->x).lonumodulo_qqq(modul);
    (point->y).lonumodulo_qqq(modul);

    if(x.compare(&(point->x)) != 0) return false;
    if(y.compare(&(point->y)) != 0) return false;
    return true;
}

/************************************/
e_p::~e_p()
{

};
/************************************/
int e_p::neutralize()
{
    x.wipezero();
    y.wipezero();
    neutral=true;
    return 0;
}
/**************************************/
int e_p::mult_p_q(longnumber* factor,ellipse* ewp)
{
        projective_point prp(this);

        prp.mult_prj_q(factor,ewp);
        prp.spitout(this,ewp);
        return 0;
}
/**************************************/
int e_p::mult_p_qj(longnumber* factor,ellipse* ewp,bool multhread)
{
        proj_jacobian prp(this);

        prp.mult_prj_q(factor,ewp, multhread);
        prp.spitout(this,ewp);
        return 0;
}
/**************************************//**************************************/

int e_p::mult_p(longnumber* factor,ellipse* ewp)
{
    long i,lc=1;
    e_p h;
    bool bit;

   factor->lonumodulo_qqq(&(ewp->q));
   factor->setsize();
   h.copy_ep(this);
   for(i=factor->hibit-1;i>=0;i--)
   {
      h.dopp(ewp);
      bit=factor->getbit(i);
      if(bit)
      {
          h.add(this,ewp);
          lc++;
      }
   }
   copy_ep(&h);
   return ((int) lc);
}
/************************************/
bool e_p::is_in_ellipse(ellipse* ewp)
{
    longnumber hr,hl,h2;
    int fl;
    wxString hlp;

    if(neutral) return true; //trivialer Fall

    hl.copynum(&y); hl.quadmodul_qqq(&(ewp->p));
    hr.copynum(&(ewp->a)); hr.multnum_q(&x,&(ewp->p));
    hr.addnum_q(&(ewp->b),&(ewp->p));
    h2.copynum(&x); h2.quadmodul_q(&(ewp->p));h2.multnum_q(&x,&(ewp->p));
    hr.addnum_q(&h2,&(ewp->p));
    fl=hl.compare(&hr);
    if(fl==0) return true;
    else return false;
}
/**********************************************/
bool e_p::get_y_from_x( ellipse* ewp, bool loval)
{
    longnumber hr,hl,h2,root;
    bool rootres;

    if(neutral) return true; //trivialer Fall
    hr.copynum(&(ewp->a)); hr.multnum_q(&x,&(ewp->p));
    hr.addnum_q(&(ewp->b),&(ewp->p));
    h2.copynum(&x); h2.quadmodul_q(&(ewp->p));h2.multnum_q(&x,&(ewp->p));
    hr.addnum_q(&h2,&(ewp->p)); //hr ist jetzt y^2, bilde jetzt y
    rootres=hr.root3m4(&(ewp->p), &root, loval);
    if(rootres)
    {
        y.copynum(&root);
    }
    return rootres;
}
/************************************/
bool e_p::get_point_in_ellipse(ellipse* ewp)
{
    int i;
    wxString message,h;
    //take check if y is on curve
    if(is_in_ellipse(ewp)) return true;
    //check if prime modul p is 3 mod 4
    if(!(ewp->p).test3mod4()){throwout(_("module is not 3 mod4"),3); return false;}
    //on false, calculate y
    e_p tp;
    tp.copy_ep(this);
    if(!tp.get_y_from_x(ewp,true)) //get into loop
    {
        i=0;
        do{
            tp.x.inc();
            i++;
            if(i%10==0)
            {
                message.Printf(_("Not yet successful after %i attempts"),i);
                throwout(message,1);
            }
        } while ((!tp.get_y_from_x(ewp,true))&&(i<1000));
        if(i==100){throwout(_("Found nothing after many attempts")); return false;}
        message.Printf(_("Successful after %i attempts"),i);
        throwout(message,1);
        tp.x.writehex(&h);
        message.Printf(_("Found primitive point:\nDox: "));
        message += h;
        message=message + _("\nDoy: ");
        tp.y.writehex(&h);
        message += h;
        throwout(message);
    }
    if(!tp.is_in_ellipse(ewp))
        {
            throwout(_("something wrong here in get point!?!"));
            return false;
        }
    copy_ep(&tp);
    return true;
}
/*************************************/
ellipse::ellipse(char* fnam)
{
    wxString messg;

    a.storlong(0);
    b.storlong(0);
    p.storlong(0);
    q.storlong(0);
    d0.neutral=true;
    (d0.x).storlong(0);
    (d0.y).storlong(0);
    name=_("empty");
    if( !el_from_file(fnam))
      throwout(_("Elliptic domain parameter file not found"));
    else{
          messg= _("Loaded elliptic domain: ") + name;
          throwout(messg,5);
    }
    return;
};
/************************************/
ellipse::ellipse()
{
    longnumber h;
    wxString txt;
   // die 256er Domain hartcodiert
    txt=_("7D5A0975FC2C3057EEF67530417AFFE7FB8055C126DC5C6CE94A4B44F330B5D9");
    txt.MakeLower();
    a.storhex(&txt);
    a.setsize(true);a.shrinktofit();

    txt=_("26DC5C6CE94A4B44F330B5D9BBD77CBF958416295CF7E1CE6BCCDC18FF8C07B6");
    txt.MakeLower();
    b.storhex(&txt);
    b.setsize(true);b.shrinktofit();

    txt=_("A9FB57DBA1EEA9BC3E660A909D838D726E3BF623D52620282013481D1F6E5377");
    txt.MakeLower();
    p.storhex(&txt);
    p.setsize(true);p.shrinktofit();
    a.lonumodulo_qqq(&p); a.setsize(true);
    b.lonumodulo_qqq(&p); b.setsize(true);

    txt=_("A9FB57DBA1EEA9BC3E660A909D838D718C397AA3B561A6F7901E0E82974856A7");
    txt.MakeLower();
    q.storhex(&txt);
    q.setsize(true);q.shrinktofit();

    d0.neutral=false;
    txt=_("8BD2AEB9CB7E57CB2C4B482FFC81B7AFB9DE27E1E3BD23C23A4453BD9ACE3262");
    txt.MakeLower();
    (d0.x).storhex(&txt);
    (d0.x).setsize(true);(d0.x).shrinktofit();

    txt=_("547EF835C3DAC4FD97F8461A14611DC9C27745132DED8E545C1D54C72F046997");
    txt.MakeLower();
    (d0.y).storhex(&txt);
    (d0.y).setsize(true);(d0.y).shrinktofit();

    name=_("p256r1");
    a_m3=false;
};
/*********************************************/
ellipse::ellipse( longnumber* ap, longnumber* bp, longnumber* pp, longnumber* pq, e_p* dstart, wxString nam)
{
    a.copynum(ap);
    b.copynum(bp);
    p.copynum(pp);
    q.copynum(pq);
    d0.copy_ep(dstart);
    name=nam;
    makerare();
};
/**********************************/
ellipse::~ellipse()
{
   p.un_rare();
};
/************************************/
void ellipse::ellipse_setintern()
{
    longnumber h;
    wxString txt;
   // die 253er Domain fuers Stretching hartcodiert
    txt=_("DEADBEEF15BADF00DDEADBEEF15BADF00DDEADBEEFDEADBEEFDEADBEEFDEADBE");
    txt.MakeLower();
    a.storhex(&txt);
    a.setsize(true);a.shrinktofit();

    txt=_("0DEADBEEF15BADF00DDEADBEEF15BADF00BADF00DBADF00DBADF00DBADF00E52");
    txt.MakeLower();
    b.storhex(&txt);
    b.setsize(true);b.shrinktofit();

    txt=_("1192C2E34A93083FAE40C0B6D2669AE52B14C8844368D0C10A9AC65C1AE5F903");
    txt.MakeLower();
    p.storhex(&txt);
    p.setsize(true);p.shrinktofit();
    a.lonumodulo_qqq(&p); a.setsize(true);
    b.lonumodulo_qqq(&p); b.setsize(true);

    txt=_("1192C2E34A93083FAE40C0B6D2669AE555D812FB557FD38C61B363BBEEC17731");
    txt.MakeLower();
    q.storhex(&txt);
    q.setsize(true);q.shrinktofit();

    d0.neutral=false;
    txt=_("0badf00dbadf00dbadf00dbadf00dbb0");
    txt.MakeLower();
    (d0.x).storhex(&txt);
    (d0.x).setsize(true);(d0.x).shrinktofit();

    txt=_("05602b4e978a750f400c44c1e46833eacc9aa44b2796de575d2e6f901990187f");
    txt.MakeLower();
    (d0.y).storhex(&txt);
    (d0.y).setsize(true);(d0.y).shrinktofit();

    name=_("stretchdom_253");
    a_m3=false;
};

/***************************************/
void ellipse::copyell(ellipse *src)
{
    p.un_rare();
    a.copynum(&(src->a));
    b.copynum(&(src->b));
    p.copynum(&(src->p),true);
    q.copynum(&(src->q));
    d0.copy_ep(&(src->d0));
    name=src->name;
    a_m3=src->a_m3;
}
/*********************************************/
bool ellipse::makerare()
{
    longnumber test;

    test.copynum(&(a));
    test.inc();test.inc();test.inc();
    if(p.compare(&test)==0) a_m3=true;
    return(p.try_rare());
}
/**********************************************/
long ellipse::giv_siz()
{
    q.setsize();
    return(1+q.hibit);
}
/********************************************/
bool ellipse::el_safety()
{

    longnumber cnt, eins,res,tp,tq;
    unsigned long i;
    wxString num;
    int currpos=0,lastmax=0;
    bool goodp=true;

    cnt.storlong(1);
    eins.copynum(&cnt);
    tp.copynum(&p);
    tq.copynum(&q);
    //immer wieder ?ist p hoch r mod q !=1
//initialize Progress bar
  wxProgressDialog pbar(_("MOV condition test"),_("50 000 checks for MOV condition\nstandard demands only 10 000 ;-)"),100);
    for(i=1;i<50000;i++)
    {
        cnt.storlong(i);
        tp.pownum_q(&cnt, &tq);
        if(tp.compare(&eins)==0)
        {
            cnt.writechar(&num);
            num= _("Insecure domain found at: ") + num;
            throwout( num);
            return false;
        }
        if(i%500 == 0)
        {
         currpos=  (int) (i/500);
         if((currpos >lastmax)&&goodp)
         {
            goodp=pbar.Update(currpos);
            lastmax=currpos;
         }
        }
    }
    throwout(_("test completed\nDomain is reasonably safe towards Menezes Okamoto Vanstone attack."),30);
    return true;
}/*****************************************/
bool ellipse::el_selftest()
{
    int i,j;
    longnumber four,an,bn;

    //test d0 is on ellipse?
    if((this->d0).is_in_ellipse(this) )
            throwout(_("Found: \nCurrent d0 is in ellipse."),2);
    else{throwout(_("Aborting: d0 is not even in ellipse."),5); return false;}
    //test p is prime?
    if(  (this->p).isprime(7) ) throwout(_("Found:\nMod-Parameter p is prime!"),2);
    else{throwout(_("Aborting: \nMod-parameter p is not prime."),5); return false;}
    //test q is prime?
    if(  (this->q).isprime(7) ) throwout(_("Found:\nClaimed group order q is prime!"),2);
    else{throwout(_("Unsafe: \nClaimed group order q is not prime."),5); return false;}
    //checks for singular curve (4 A3 + 27 B2 ≠ 0.)
    four.storlong(4);
    an.copynum(&a);
    an.multnum_qqq(&a,&p);
    an.multnum_qqq(&a,&p);
    an.multnum_qqq(&four,&p);
    four.storlong(27);
    bn.copynum(&b);
    bn.quadmodul_qqq(&p);
    bn.multnum_qqq(&four,&p);
    an.addnum_q(&bn,&p);
    an.setsize(true);
    if(an.giv_siz()<0)
        {throwout(_("INSECURE: \nCurve is singular!!\nplease discard.")); return false;}
    else  throwout(_("Confirmed:\nCurve is not singular!(->good)"),2);

    if(p.israre) throwout(_("modulus p is lean!\n(can make calculations somewhat faster)"),3);
    if(a_m3) throwout(_("parameter a is -3\n(can make calculations somewhat faster)"),3);
    //test arithm: d0*(q-1) +d0 = d0
    e_p ep1; //helper elliptic point
    longnumber fac;
    ep1.copy_ep(&(this->d0));
    fac.copynum(&(this->q)); fac.dec();
    ep1.mult_p_qj(&fac,this);
    ep1.add( &(this->d0),this );
    ep1.add( &(this->d0),this );
    if(ep1.isequal(&(this->d0), &(this->p))){ throwout(_("Found:\nSound arithmetics!\nq is indeed group order."),2); return true;}
    else{throwout(_("Unsafe: \nunsound arithmetics\nq presumably is not true prime group order."),5);}
    return false;
}
/**********************************/
bool ellipse::el_from_file(char* fnam)
{
    FILE* fp;
    unsigned char nambuf[300];
    int readflag,fl2;


    fp=fopen(fnam,"r");
    if(fp==NULL)
    {
        throwout(_("could not open elliptic-domain-file"));
        return false;
    }
    readflag=fscanf(fp,"ID: %300s",nambuf);
    if( readflag != 1) {throwout(_("error, could not read name")); return false;}
    wxString mystring((const char *)nambuf, wxConvUTF8);
    name=mystring;
    //MODUL: p
    readflag=fscanf(fp," MODUL:");
    if( readflag != 0) {throwout(_("error, could not read Modul p")); return false;}
    p.resizelonu(200);
    p.wipezero();
    fl2=read_hex_bytes_from_file(fp, p.ad,(int) p.length-1);
    if( fl2 < 4) {throwout(_("Warning, insufficient byte-# read"),3); }
    p.setsize(true);
    p.shrinktofit();
    //Parameter a und b
    readflag=fscanf(fp," coeff_A:");
    if( readflag != 0) {throwout(_("error, could not Coefficient a")); return false;}
    a.resizelonu(200);
    a.wipezero();
    fl2=read_hex_bytes_from_file(fp, a.ad, (int) a.length-1);
    if( fl2 < 4) {throwout(_("Warning, insufficient byte-# read"),3); }
    a.setsize(true);
    a.shrinktofit();
    readflag=fscanf(fp," coeff_B:");
    if( readflag != 0) {throwout(_("error, could not read coefficient b")); return false;}
    b.resizelonu(200);
    b.wipezero();
    fl2=read_hex_bytes_from_file(fp, b.ad, (int) b.length-1);
    if( fl2 < 4) {throwout(_("Warning, insufficient byte-# read"),3); }
    b.setsize(true);
    b.shrinktofit();
    readflag=fscanf(fp," q_MODUL:");
    if( readflag != 0) {throwout(_("error, could not read Group order q")); return false;}
    //Modul q
    q.resizelonu(200);
    q.wipezero();
    fl2=read_hex_bytes_from_file(fp, q.ad, (int) q.length-1);
    if( fl2 < 4) {throwout(_("Warning, insufficient byte-# read"),3); }
    q.setsize(true);
    q.shrinktofit();
    readflag=fscanf(fp," X0:");
    if( readflag != 0) {throwout(_("error, could not read Point X0")); return false;}
    d0.x.resizelonu(200);
    d0.x.wipezero();
    fl2=read_hex_bytes_from_file(fp, d0.x.ad, (int) d0.x.length-1);
    if( fl2 < 4) {throwout(_("Warning, very low byte-# read"),5); }
    d0.x.setsize(true);
    d0.x.shrinktofit();
    d0.neutral=false;
    readflag=fscanf(fp," Y0:");
    if( readflag != 0) {throwout(_("error, could not read Point Y0")); return false;}
    d0.y.resizelonu(200);
    d0.y.wipezero();
    fl2=read_hex_bytes_from_file(fp, d0.y.ad, (int) d0.y.length-1);
    if( fl2 < 4) {throwout(_("Warning, very low byte-# read"),3); }
    fclose(fp);
    d0.y.setsize(true);
    d0.y.shrinktofit();
    //jetzt waere ein test faellig...
    if(!d0.is_in_ellipse(&gdom))
    {
       throwout(_("wrong domain parameters or incomplete spec of Do! \nsupposedly primitive point d0 is not on curve\n please load valid Domain!"),10);
       throwout(_("trying to evaluate suggestion for primitive point.\nmight try manually edit elps file afterwards"),3);
       return(d0.get_point_in_ellipse(this));
    }
    makerare();
  return true;

};
/********routines of class el_list********************/
el_list::el_list()
    {
        rpt=NULL;
        noel=0;
    }
/*********************************************************/
el_list::~el_list()
    {
        unsigned int i;

        for(i=0;i<noel;i++)
        {
            delete(*(rpt+i));
        }
        if(rpt != NULL)free(rpt);
    }
/*****************************************************/
bool el_list::isinlist(wxString chk_nam)
{
    unsigned int i;

    for(i=0;i<noel;i++)
    {
        if( (*(rpt+i))->name == chk_nam)
        {
            return true;
        }
    }
    return false;
}
/*****************************************************/
int el_list::getelp(ellipse *rep, wxString ell_id) //return ellipse ptr for ell id, return indx on success -1 on fail, fill rep with Null on fail
{
    unsigned int i;

    for(i=0;i<noel;i++)
    {
        if( (*(rpt+i))->name == ell_id)
        {
            rep->copyell( *(rpt+i));
            return i;
        }
    }
    rep=NULL;
    return -1;
}
/*****************************************************/
int el_list::mov_top_ell(int p)
{
    ellipse *tmp;
    int i;

    if((p<0)||(p>(int)noel-1)||(noel==0)) return -1;
    if(p==0) return 0;
    tmp= *(rpt+p);
    for(i=p;i>0;i--)
    {
       *(rpt+i)=*(rpt+i-1);
    }
    *(rpt)=tmp;
    return p;
}
/*****************************************************/
/*****************************************************/
int el_list::mov_bott_ell(int p)
{
    ellipse *tmp;
    int i;

    if((p<0)||(p>(int)noel-1)||(noel==0)) return -1;
    if(p==(int)noel-1) return (noel-1);
    //do by swapping
    for(i=p;i<(int)noel-1;i++)
    {
       swap_ell(i,i+1);
    }
    return p;
}
/*****************************************************/
int el_list::swap_ell(int p1, int p2)
{
    ellipse *tmp;

    if((p1<0)||(p1>(int)noel-1)||(p2<0)||(p2>(int)noel-1)) return -1;
    tmp= *(rpt+p1);
    *(rpt+p1)=*(rpt+p2);
    *(rpt+p2)=tmp;
    return p2;
}
/*********************************************************/
int el_list::getelp(ellipse* rep, unsigned int pos) //return ellipse ptr for ell id, return indx on success -1 on fail, fill rep with Null on fail
{
    if(pos>(noel-1))
    {
      return -1;
    }
    else{
      rep->copyell( *(rpt+pos));
      return (int)pos;
    }
}
/*****************************************************/
void el_list::sortlen()
{
    int j;
    bool chng=false;
    long s1;

    do
    {
        chng=false;
        for(j=0;j<(int)noel-1;j++)
        {
            s1=(*(rpt+j))->q.giv_siz();
            if( (*(rpt+j+1))->giv_siz() < s1 )
            {
                chng=true;
                swap_ell(j,j+1);
            }
        }
    }while(chng==true);
    return;
}
/*****************************************************/
int el_list::add_ellps(ellipse* inell,bool expl)
{

    if(inell==NULL) return -1;
    //check for name presence
    if(isinlist(inell->name))
    {
        if(expl)
        {
            wxString msg;
            msg=_("domain named : \"") + inell->name + _("\" \nis already in domain list.\nnot imported.");
            throwout(msg,3);
        }
        return noel;
    }
    rpt =(ellipse**) realloc(rpt, (noel+1)*sizeof(ellipse*));
    if(  (rpt == NULL))
    {
        throwout(_("Error reallocating root pointer in ellipse list!\nFatal!! \nPlease exit program!"));
        return -1;
    }
   *(rpt+noel)= new ellipse();
   (*(rpt+noel))->copyell(inell);
    (*(rpt+noel))->makerare();
   noel++;
   return noel;
}
/*****************************************************/
int el_list::cut_ellps(wxString ell_id)
{
    unsigned int i=0,pos;

    while((i<noel)&&((*(rpt+i))->name != ell_id)) i++;
    if(i==noel) return -1; //counted to end and didnt find
    else //found!!
    {
        //free deletee & set all others back by one
        delete(*(rpt+i));
        pos=i;
        while(i<noel-1)
        {
            *(rpt+i)=*(rpt+i+1);
            i++;
        }
        //realloc  rpt
        noel--;
        rpt=(ellipse**)realloc(rpt,noel*sizeof(ellipse*));
        return pos;
    }
}
/*****************************************************/
/*****************************************************/
int el_list::cut_ellps(int pos)
{
    unsigned int i;

    if((noel==0)||(pos> (int)noel-1)||(pos<0)) return -1; //counted to end and didnt find
    else //found!!
    {
        //free deletee & set all others back by one
        delete(*(rpt+pos));
        i=pos;
        while(i<noel-1)
        {
            *(rpt+i)=*(rpt+i+1);
            i++;
        }
        //realloc  rpt
        noel--;
        rpt=(ellipse**)realloc(rpt,noel*sizeof(ellipse*));
        return pos;
    }
}
/*****************************************************/
int el_list::getpos4nam(wxString ell_id)
{
    unsigned int i=0;

    while((i<noel)&&((*(rpt+i))->name != ell_id)) i++;
    if(i==noel) return -1; //counted to end and didnt find
    else //found!!
    {
        return (int)i;
    }
}
/*****************************************************/
unsigned int el_list::addfromfile(wxString fnam, bool expl)
{
   FILE* fp;
    unsigned char nambuf[500];
    int readflag;
    unsigned int read=0;
    wxString mywxs;
    ellipse tmpell;


    fp=fopen(fnam.mb_str(wxConvLocal),"r");
    if(fp==NULL)
    {
        throwout(_("could not open domain-list file"));
        return 0;
    }

    do
    {
       readflag=fscanf(fp," %498s",nambuf);
       if(readflag!=1)
       {
          throwout(_("error reading ellipse list file.\naborting"),4);
          fclose(fp);
          return read;
       }
     mywxs = wxString::FromUTF8((const char*)nambuf);
    } while (mywxs!=_("ID:"));

while(mywxs==_("ID:"))
    {
    //go into reading mode
    readflag=fscanf(fp," %498s",nambuf);
    if(readflag!=1)
       {
          throwout(_("error reading ellipse list file.\naborting"),4);
          fclose(fp);
          return read;
       }
    tmpell.name= wxString::FromUTF8((const char*)nambuf);
    //read MODUL:
    readflag=fscanf(fp," MODUL: %498s",nambuf);
    if(readflag!=1)
       {
          throwout(_("error reading ellipse list file.\naborting"),4);
          fclose(fp);
          return read;
       }
     mywxs = wxString::FromUTF8((const char*)nambuf);
    (tmpell.p).storhex(&mywxs);
    readflag=fscanf(fp," coeff_A: %498s",nambuf);
    if(readflag!=1)
       {
          throwout(_("error reading ellipse list file.\naborting"),4);
          fclose(fp);
          return read;
       }
     mywxs = wxString::FromUTF8((const char*)nambuf);
    (tmpell.a).storhex(&mywxs);

    readflag=fscanf(fp," coeff_B: %498s",nambuf);
    if(readflag!=1)
       {
          throwout(_("error reading ellipse list file.\naborting"),4);
          fclose(fp);
          return read;
       }
     mywxs = wxString::FromUTF8((const char*)nambuf);
    (tmpell.b).storhex(&mywxs);

    readflag=fscanf(fp," q_MODUL:  %498s",nambuf);
    if(readflag!=1)
       {
          throwout(_("error reading ellipse list file.\naborting"),4);
          fclose(fp);
          return read;
       }
     mywxs = wxString::FromUTF8((const char*)nambuf);
    (tmpell.q).storhex(&mywxs);

    readflag=fscanf(fp," X0:  %498s",nambuf);
    if(readflag!=1)
       {
          throwout(_("error reading ellipse list file.\naborting"),4);
          fclose(fp);
          return read;
       } //empty list, then addfromfile
     mywxs = wxString::FromUTF8((const char*)nambuf);
    (tmpell.d0.x).storhex(&mywxs);

    readflag=fscanf(fp," Y0:  %498s",nambuf);
    if(readflag!=1)
       {
          throwout(_("error reading ellipse list file.\naborting"),4);
          fclose(fp);
          return read;
       }
     mywxs = wxString::FromUTF8((const char*)nambuf);
    (tmpell.d0.y).storhex(&mywxs);
    tmpell.d0.neutral=false;
    read=add_ellps(&tmpell,expl);

      do
      {
          readflag=fscanf(fp," %498s",nambuf);
          if(readflag!=1)
          {
            throwout(_("error reading ellipse list file.\naborting"),4);
            fclose(fp);
            return read;
         }
     mywxs = wxString::FromUTF8((const char*)nambuf);
       } while( (mywxs!=_("ID:"))&&(mywxs!=_("END")));


    }
    if(mywxs==_("END")) throwout(_("ellipse list file read properly"),1);
    else throwout(_("ellipse list file read but no end statement found ?!"));
    fclose(fp);
    return read;
}
/*****************************************************/
unsigned int el_list::setfromfile(wxString fnam)
{
    //empty list, then addfromfile
    empty_list();
    return addfromfile(fnam);
}
/************************************************/
bool el_list::write_list2file(wxString fnam)
{
    unsigned int i;
    wxString os;
    FILE *fp;
    char buff[502];


    fp=fopen(fnam.mb_str(wxConvLocal),"w");
    if(fp==NULL)
    {
        throwout(_("could not open domain-list file for writing"));
        return false;
    }
    fprintf(fp," \n");
    for(i=0;i<noel;i++)
    {
        fprintf(fp,"ID: %s \n",(const char*)((*(rpt+i))->name).mb_str(wxConvUTF8));
        ((*(rpt+i))->p).writehex(&os);
        fprintf(fp,"MODUL: %s \n",(const char*)os.mb_str(wxConvUTF8) );
        ((*(rpt+i))->a).writehex(&os);
        fprintf(fp,"coeff_A: %s \n",(const char*)os.mb_str(wxConvUTF8));
        ((*(rpt+i))->b).writehex(&os);
        fprintf(fp,"coeff_B: %s \n", (const char*)os.mb_str(wxConvUTF8) );
        ((*(rpt+i))->q).writehex(&os);
        fprintf(fp,"q_MODUL: %s \n",(const char*)os.mb_str(wxConvUTF8));
        ((*(rpt+i))->d0.x).writehex(&os);
        fprintf(fp,"X0: %s \n",(const char*)os.mb_str(wxConvUTF8));
        ((*(rpt+i))->d0.y).writehex(&os);
        fprintf(fp,"Y0: %s \n \n",(const char*)os.mb_str(wxConvUTF8) );
    }
    fprintf(fp," END ");
    fclose(fp);
    return true;
}
/*****************************************************/
void el_list::empty_list()
{
  unsigned int i;

    for(i=0;i<noel;i++)
        {
            delete(*(rpt+i));
        }
    noel=0;
    return;
}
/***************************************************************************/
el_priv::el_priv()
{
    wxString funny=_("deadbeef15badf00d");
    d.storhex( &funny );
    domnam= gdom.name;
    id=_("BSE");
    fullnam=_("Mad_Cow_Desease");
}
/***************************************/
el_priv::el_priv(longnumber* pn, ellipse *domain, wxString id_in, wxString fullnam_in)
{
    d.copynum(pn);
    d.setsize(true);
    A.copy_ep(&(domain->d0));
    A.mult_p_q(&d,domain);
    domnam=domain->name;
    id = id_in; fullnam = fullnam_in;
}
/***************************************/
bool el_priv::copy_priv_ky(el_priv* keyadd)
{
    int fll=-1;

    d.copynum(&(keyadd->d));
    #if defined(__WXMSW__)
        //to be filled
        fll=VirtualLock(d.ad,d.length); //locken to ram in linux
    #else
            fll=mlock(d.ad,d.length); //locken to ram in linux
    #endif

    A.copy_ep(&(keyadd->A));
    domnam=keyadd->domnam;
    id = keyadd->id; fullnam = keyadd->fullnam;
    return true;
}
/***************************************/
el_priv::el_priv(unsigned long lno,ellipse *domain, wxString id_in, wxString fullnam_in)
{
    d.storlong(lno);
    d.setsize(true);
    A.copy_ep(&(domain->d0));
    A.mult_p_qj(&d,domain);
    domnam=domain->name;
    id = id_in; fullnam = fullnam_in;
}


/***************************************/
bool el_priv::set_el_priv(longnumber* pn, ellipse *domain, wxString id_in, wxString fullnam_in)
{
    int fll=-1;

    d.copynum(pn);
    d.setsize(true);
    //A.copy_ep(&(domain->d0));
    //A.mult_p_qj(&d,domain);
    domnam=domain->name;
    id = id_in; fullnam = fullnam_in;
    #if defined(__WXMSW__)
        fll=VirtualLock(d.ad,d.length); //locken to ram in Windows
    #else
            fll=mlock(d.ad,d.length); //locken to ram in linux
    #endif

    return true;
}
/***************************************/
el_priv::~el_priv()
{
   d.wipezero();
}
/***************************************/
el_pub::el_pub()
{
    domnam=_("empty");
    id=_("Trivial");
    fullnam=_("Do_not_use_this_Trivial_Key");
    A.copy_ep(&(gdom.d0));
}
/***************************************/
el_pub::el_pub(e_p* pA, ellipse *domain, wxString id_in, wxString fullnam_in)
{
    A.copy_ep(pA);
    domnam=domain->name;
    id = id_in; fullnam = fullnam_in;
}
/***************************************/
bool el_pub::set_el_pub(e_p* pA, ellipse *domain, wxString id_in, wxString fullnam_in)
{
    A.copy_ep(pA);
    domnam=domain->name;
    id = id_in; fullnam = fullnam_in;
    return true;
}
/***************************************//***************************************/
bool el_pub::get_from_file(wxString fnam)
{
  FILE* filp;
  char buff[600];
  int lbl;
  wxString h;
  char fnambuff[1202];

    if(! wxFile::Exists(fnam))
    {
        throwout(_("File not present!"));
        return false;
    }
    if(fnam.Len()>600)
    {
        throwout(_("Filename has excessive length\n will not load key!"),3);
        return false;
    }
    strcpy(fnambuff, (const char*)fnam.mb_str(wxConvLocal) );
    filp=fopen(fnambuff,"r");
    lbl=fscanf(filp,"ID_of_key: %300s ",buff);
    if(lbl!=1){throwout(_("malformed key\ncannot load"),2); return false;}
    id=wxString::FromUTF8(buff);
    //read name
    lbl=fscanf(filp,"Name_of_Keyholder: %300s ",buff);
    if(lbl!=1){throwout(_("malformed key\ncannot load"),2); return false;}
    fullnam=wxString::FromUTF8(buff);
    //read Domain
    lbl=fscanf(filp,"EllipCurve_Domain_Name: %300s ",buff);
    if(lbl!=1){throwout(_("malformed key\ncannot load"),2); return false;}
    domnam=wxString::FromUTF8(buff);
    //read A
    lbl=fscanf(filp,"Ax: %600s ",buff);
    if(lbl!=1){throwout(_("malformed key\ncannot load"),2); return false;}
    h=wxString::FromUTF8(buff);
    A.x.storhex(&h);
    lbl=fscanf(filp,"Ay: %600s ",buff);
    if(lbl!=1){throwout(_("malformed key\ncannot load"),2); return false;}
    h=wxString::FromUTF8(buff);
    A.y.storhex(&h);

    fclose(filp);
    return true;
}
/***********************************************/
bool el_pub::copy_pub_ky(el_pub* keyadd)
{
    if(keyadd == NULL) return false;
    A.copy_ep(&(keyadd->A));
    domnam=keyadd->domnam;
    id = keyadd->id; fullnam = keyadd->fullnam;
    return true;
}
/***************************************/
el_pub::~el_pub()
{

}
/***************************************//***************************************/
/***************************************/
/***************************************/
/***************************************/
/***************************************/
projective_point::projective_point(e_p* pin)
{
    neutral=pin->neutral;
    if(neutral)
    {
        x.storlong(0); y.storlong(1); z.storlong(0);
    }
    x.copynum(&(pin->x));
    y.copynum(&(pin->y));
    z.storlong(1);
};
/************************************************/
bool projective_point::prj_fill(e_p* pin)
{
    neutral=pin->neutral;
    if(neutral)
    {
        x.storlong(0); y.storlong(1); z.storlong(0);
    }
    x.copynum(&(pin->x));
    y.copynum(&(pin->y));
    z.storlong(1);
    return true;
}
/***************************************/
projective_point::projective_point(projective_point* pin)
{
    copy_prj(pin);
};
/************************************************/
projective_point::~projective_point()
{

};
/*******************************************************/
/*******************************************************/
int projective_point::subtract(projective_point* summand,ellipse* ewp)
{
    longnumber yps;

    if(summand->neutral) return 0;
    //invert summand
    projective_point subtrh(summand);
    yps.copynum(&(ewp->p));
    yps.subtrnum_q(&(summand->y),&(ewp->p));
    (subtrh.y).copynum(&yps);
    //inverted?
    //call add
    return (add(&subtrh, ewp));
}
/*******************************************************/
int projective_point::add(projective_point* summand,ellipse* ewp)
{
    longnumber u1,u2,v1,v2,w,A,vh2v2,vhm2,vh3, u,v,vh3u2,wt;
    int f1,f2;

    if(summand->neutral) return 0;
    if(neutral)
    {
        copy_prj(summand);
        return 0;
    }
    u1.copynum(&(summand->y));
    u1.multnum_q(&(z), &(ewp->p));
    u2.copynum(&y);
    u2.multnum_q(&(summand->z), &(ewp->p));
    v1.copynum(&(summand->x)); v1.multnum_q(&z,&(ewp->p));
    v2.copynum(&x); v2.multnum_q(&(summand->z),&(ewp->p));
    f1=v1.compare(&v2);
    if(f1==0)
    {
        f2=u1.compare(&u2);
        if(f2!=0)
        {
            //neutrales element
            x.storlong(0);y.storlong(1);z.storlong(0);
            neutral=true;
            return 0;
        }
        f2=dopp(ewp);
        return f2;
    } //kontrollen beendet
    u.copynum(&u1); u.subtrnum_q(&u2,&(ewp->p));
    v.copynum(&v1); v.subtrnum_q(&v2,&(ewp->p));
    w.copynum(&z);
    w.multnum_q(&(summand->z),&(ewp->p));
    vh2v2.copynum(&v); vh2v2.quadmodul_q(&(ewp->p));
     //v hoch drei vorbereiten
    vh3.copynum(&vh2v2);
    vh3.multnum_q(&v,&(ewp->p));
    vh2v2.multnum_q(&v2,&(ewp->p));
    vhm2.copynum(&vh2v2); vhm2.shiftoneup_q();
    A.copynum(&u); A.quadmodul_q(&(ewp->p));
    A.multnum_q(&w,&(ewp->p));
    A.subtrnum_q(&vh3,&(ewp->p));
    A.subtrnum_q(&vhm2,&(ewp->p));
    x.copynum(&v); x.multnum_q(&A,&(ewp->p));
    y.copynum(&vh2v2);y.subtrnum_q(&A,&(ewp->p));
    vh3u2.copynum(&vh3);vh3u2.multnum_q(&u2,&(ewp->p));
    y.multnum_q(&u,&(ewp->p));y.subtrnum_q(&vh3u2,&(ewp->p));
    z.copynum(&vh3);z.multnum_q(&w,&(ewp->p));
    //check for zero
    z.setsize();
    if(z.hibit==-1) //is neutral
    {
            //neutrales element
            x.storlong(0);y.storlong(1);z.storlong(0);
            neutral=true;
            return 0;
    }

    return 1;
};
/**********************************************************/
int projective_point::dopp(ellipse* ewp)
{
    longnumber w,wh,s,B,H,drei,squad,wt;

    if(neutral) return 0;
    //drei.storlong(3); //make special mult3 longnumber routine
    wh.copynum(&z); wh.quadmodul_q(&(ewp->p));
    wh.multnum_q(&(ewp->a),&(ewp->p));
    w.copynum(&x);w.quadmodul_q(&(ewp->p));w.mult3mod(&(ewp->p));
    w.addnum_q(&wh,&(ewp->p));
    s.copynum(&y);s.multnum_q(&z,&(ewp->p));
    squad.copynum(&s); squad.quadmodul_q(&(ewp->p));//s^2 voranlegen
    B.copynum(&s); B.multnum_q(&x,&(ewp->p)); B.multnum_q(&y,&(ewp->p));
    wh.copynum(&B);wh.shiftbits_q(3); // ist jetzt -8*B
    H.copynum(&w); H.quadmodul_q(&(ewp->p));  H.subtrnum_q(&wh,&(ewp->p));
    x.copynum(&H);x.multnum_q(&s,&(ewp->p));x.shiftoneup_q(); //x=2*H*s
    wh.copynum(&y); wh.quadmodul_q(&(ewp->p)); wh.multnum_q(&squad,&(ewp->p));
    wh.shiftbits_q(3); //8*y^2*s^2
    y.copynum(&B); y.shiftbits_q(2); y.subtrnum_q(&H,&(ewp->p));
    y.multnum_q(&w,&(ewp->p)); //w*(4B-H)
    y.subtrnum_q(&wh,&(ewp->p));
    z.copynum(&squad); z.shiftbits_q(3); z.multnum_q(&s,&(ewp->p));
    return 1;
};
/**********************************************************/
bool projective_point::copy_prj(projective_point* source)
{
    x.copynum(&(source->x));
    y.copynum(&(source->y));
    z.copynum(&(source->z));
    neutral= source->neutral;
    return true;
};
/**********************************************************/
int projective_point::mult_prj(longnumber* factor,ellipse* ewp)
{
    long i,lc=1;
    projective_point h(this);
    bool bit;

   factor->lonumodulo_qqq(&(ewp->q));
   factor->setsize();
   for(i=factor->hibit-1;i>=0;i--)
   {
      h.dopp(ewp);
      bit=factor->getbit(i);
      if(bit)
      {
          h.add(this,ewp);
          lc++;
      }
   }
   copy_prj(&h);
   return ((int) lc);
};
/**********************************************************/
/**********************************************************/
int projective_point::mult_prj_q(longnumber* factor,ellipse* ewp)
{
    long i,hibitm,h1,bitzahl,lc=1;
    projective_point h(this);
    bool bit,add,sub;
    longnumber fa,fs;

   factor->lonumodulo_qqq(&(ewp->q));
   factor->setsize();
    hibitm=factor->get_hibit();
    if(hibitm == 0)
    {
        return 0; //faktor 1
    }
   if(hibitm==-1) //faktor 0
   {
       neutralize();
       return 0;
   }
   if(hibitm<10) return mult_prj(factor,ewp);
    factor->kobz_trans(&fa,&fs);
    hibitm=fa.get_hibit();h1=fs.get_hibit();
    if(h1>hibitm) hibitm=h1;
    projective_point accu(this);
    accu.neutralize();
    for(bitzahl=0;bitzahl<=hibitm;bitzahl++)
    {
        add=fa.getbit(bitzahl);
        sub=fs.getbit(bitzahl);
        if(add) accu.add(&h,ewp);
        if(sub) accu.subtract(&h,ewp);
        h.dopp(ewp);
    }
    copy_prj(&accu);
   return ((int) bitzahl);
};
/**********************************************************/

bool projective_point::isequal(projective_point* point)
{
    if(neutral && point->neutral) return true;

    if(point->x.compare(&x) !=0 ) return false;
    if(point->y.compare(&y) !=0 ) return false;
    if(point->z.compare(&z) !=0 ) return false;
    return true;
};
/**********************************************************/
bool projective_point::isequal(projective_point* point, longnumber* pmodul, bool test_affine)
{
    longnumber x1,y1,z1,x2,y2,z2;
    bool z_eq=false;

    if(neutral && point->neutral) return true;

    x1.copynum(&x);x1.lonumodulo_qqq_e(pmodul);
    y1.copynum(&y);y1.lonumodulo_qqq_e(pmodul);
    z1.copynum(&z);z1.lonumodulo_qqq_e(pmodul);
    x2.copynum(&(point->x)); x2.lonumodulo_qqq_e(pmodul);
    y2.copynum(&(point->y)); y2.lonumodulo_qqq_e(pmodul);
    z2.copynum(&(point->z)); z2.lonumodulo_qqq_e(pmodul);
    if(test_affine)
    {
        if(z1.compare(&z2)==0) z_eq=true;
        if(!z_eq)
        { x2.multnum_l1(&z1,pmodul);
          x1.multnum_l1(&z2,pmodul);
        }
        if(x2.compare(&x1) !=0 ) return false;

        if(!z_eq)
        {
            y2.multnum_l1(&z1,pmodul);
            y1.multnum_l1(&z2,pmodul);
        }
        if(y2.compare(&y1) !=0 ) return false;

        return true;
    }
    else  //if not affine testing
    {
        if(x2.compare(&x1) !=0 ) return false;
        if(y2.compare(&y1) !=0 ) return false;
        if(z2.compare(&z1) !=0 ) return false;
        return true;
    }
    return false; //never get here
};
/**********************************************************/
int projective_point::neutralize()
{
    x.storlong(0);y.storlong(1);z.storlong(0);
    neutral=true;
    return 0;
};
/**********************************************************/
bool projective_point::spitout(e_p* outpoint,ellipse* ewp)
{
    longnumber zinv;
    bool fl1;

    outpoint->neutral=neutral;
    if(neutral) //neutral
    {
        outpoint->neutralize();
        return true;
    }
    fl1= z.get_mod_inv_q(&zinv, &(ewp->p));
    if(!fl1) return fl1;
    outpoint->x.copynum(&x);
    outpoint->x.multnum_l1(&zinv,&(ewp->p));
    outpoint->y.copynum(&y);
    outpoint->y.multnum_l1(&zinv,&(ewp->p));
    outpoint->neutral=neutral;
    return fl1;
};
/**********************************************************/

/*********Hier die Jacobi Variante******************************/
/***************************************************/
/***************************************/
proj_jacobian::proj_jacobian(e_p* pin)
{
    neutral=pin->neutral;
    if(neutral)
    {
        x.storlong(0); y.storlong(1); z.storlong(0);
    }
    x.copynum(&(pin->x));
    y.copynum(&(pin->y));
    z.storlong(1);
};
/************************************************/
bool proj_jacobian::prj_fill(e_p* pin)
{
    neutral=pin->neutral;
    if(neutral)
    {
        x.storlong(0); y.storlong(1); z.storlong(0);
    }
    x.copynum(&(pin->x));
    y.copynum(&(pin->y));
    z.storlong(1);
    return true;
}
/***************************************/
proj_jacobian::proj_jacobian(proj_jacobian* pin)
{
    copy_prj(pin);
};
/************************************************/
proj_jacobian::~proj_jacobian()
{

};
/*******************************************************/
/*******************************************************/
int proj_jacobian::subtract(proj_jacobian* summand,ellipse* ewp)
{
    longnumber yps;

    if(summand->neutral) return 0;
    //invert summand
    proj_jacobian subtrh(summand);
    yps.copynum(&(ewp->p));
    yps.subtrnum_q(&(summand->y),&(ewp->p));
    (subtrh.y).copynum(&yps);
    //inverted?
    //call add
    return (add(&subtrh, ewp));
}
/************************in progress*******************************/
int proj_jacobian::add_spec(proj_jacobian* summand,ellipse* ewp)
{
    //for a=-3
    int f1,f2;
    longnumber z1z1,z2z2,s1,s2,h,i,j,r,v,x3,y3,z3,vd,sj,myzero,u1,u2;

    if(summand->neutral) return 0;
    if(neutral)
    {
        copy_prj(summand);
        return 0;
    }
    longnumber buff( ((ewp->p).size+4)<<1  );  //buffer for sqaring



    z1z1.copynum(&z);  z1z1.quadmodul_l1(&(ewp->p),&buff); //z1z1.multnum_qqq(&z,&(ewp->p));
    z2z2.copynum(&(summand->z));   z2z2.quadmodul_l1(&(ewp->p),&buff); //z2z2.multnum_qqq(&(summand->z),&(ewp->p));
    u1.copynum(&x); u1.multnum_l1(&z2z2,&(ewp->p));
    u2.copynum(&(summand->x)); u2.multnum_l1(&z1z1,&(ewp->p));
      //S1 = Y1*Z2*Z2Z2
    s1.copynum(&y); s1.multnum_l1(&(summand->z),&(ewp->p));s1.multnum_l1(&z2z2,&(ewp->p));
      //S2 = Y2*Z1*Z1Z1
    s2.copynum(&(summand->y)); s2.multnum_l1(&z,&(ewp->p));s2.multnum_l1(&z1z1,&(ewp->p));
    //check for accidenatl equality, check if x-values are equal
    if(u1.compare(&u2)==0)
    {
        //check if y-values are also equal
        if(s1.compare(&s2)==0)
        {
            //do point doubling
            return dopp(ewp);
        }
        else
        {
             //neutrales element
            x.storlong(0);y.storlong(1);z.storlong(0);
            neutral=true;
            return 0;
       }

    }
      //H = U2-U1
    h.copynum(&u2); h.subtrnum_q(&u1,&(ewp->p));
      //I = (2*H)2
    i.copynum(&h);i.shiftoneup_q(); i.setsize(); i.cheap_modreduce(&(ewp->p));
    i.quadmodul_l1(&(ewp->p));
      //J = H*I
    j.copynum(&i); j.multnum_l1(&h,&(ewp->p));
      //r = 2*(S2-S1)
    r.copynum(&s2); r.subtrnum_q(&s1,&(ewp->p)); r.shiftoneup_q(); r.setsize();r.cheap_modreduce(&(ewp->p));
      //V = U1*I
    v.copynum(&u1); v.multnum_l1(&i,&(ewp->p));
      //X3 = r2-J-2*V
    x3.copynum(&r);  x3.quadmodul_l1(&(ewp->p),&buff);  //x3.multnum_qqq(&r,&(ewp->p));
    vd.copynum(&v); vd.shiftoneup_q(); vd.setsize(); vd.cheap_modreduce(&(ewp->p));
    x3.subtrnum_q(&j,&(ewp->p)); x3.subtrnum_q(&vd,&(ewp->p));
      //Y3 = r*(V-X3)-2*S1*J
    y3.copynum(&v); y3.subtrnum_q(&x3,&(ewp->p));y3.multnum_l1(&r,&(ewp->p));
    sj.copynum(&s1); sj.shiftoneup_q(); sj.setsize();sj.cheap_modreduce(&(ewp->p)); sj.multnum_l1(&j,&(ewp->p));
    y3.subtrnum_q(&sj,&(ewp->p));
      //Z3 = ((Z1+Z2)2-Z1Z1-Z2Z2)*H
    z3.copynum(&z); z3.addnum_q(&(summand->z),&(ewp->p)); z3.quadmodul_l1(&(ewp->p),&buff); //z3.multnum_qqq(&z3,&(ewp->p));
    z3.subtrnum_q(&z1z1,&(ewp->p)); z3.subtrnum_q(&z2z2,&(ewp->p)); z3.multnum_l1(&h,&(ewp->p));
    //all done - hopefully
    z3.setsize();
    if(z3.hibit==-1) //is neutral
    {
            //neutrales element
            x.storlong(0);y.storlong(1);z.storlong(0);
            neutral=true;
            return 0;
    }
    x.copynum(&x3); y.copynum(&y3); z.copynum(&z3);

    return 1;
};
/************************in progress*******************************/
int proj_jacobian::add(proj_jacobian* summand,ellipse* ewp)
{
    int f1,f2;
    longnumber z1z1,z2z2,s1,s2,h,r,v,x3,y3,z3,i,myzero,u1,u2,hh,hhh;
    unsigned long modsize;
    //debug
    //longnumber debh1;

    if(summand->neutral) return 0;
    if(neutral)
    {
        copy_prj(summand);
        return 0;
    }
    if(ewp->a_m3) return(add_spec( summand, ewp));
    longnumber buff( ((ewp->p).size+4)<<1  );
      //Z1Z1 = Z1^2
      //Z2Z2 = Z2^2
      //U1 = X1*Z2Z2
      //U2 = X2*Z1Z1
    z1z1.copynum(&z);
    z1z1.quadmodul_l1(&(ewp->p),&buff);
    z2z2.copynum(&(summand->z)); z2z2.quadmodul_l1(&(ewp->p),&buff); //another squaring
    u1.copynum(&x);
    //debh1.copynum(&x);
    u1.multnum_l1(&z2z2,&(ewp->p),&buff);
 /*   debh1.multnum_l1(&z2z2,&(ewp->p),&buff);
    if(debh1.compare(&u1) !=0)
    {
        //error found
        debh1.copynum(&x);
        debh1.multnum_l1(&z2z2,&(ewp->p),&buff);
    }*/
    u2.copynum(&(summand->x)); u2.multnum_l1(&z1z1,&(ewp->p),&buff);
      //S1 = Y1*Z2*Z2Z2
      //S2 = Y2*Z1*Z1Z1
    s1.copynum(&y); s1.multnum_l1(&(summand->z),&(ewp->p),&buff);s1.multnum_l1(&z2z2,&(ewp->p),&buff);
    s2.copynum(&(summand->y)); s2.multnum_l1(&z,&(ewp->p),&buff);s2.multnum_l1(&z1z1,&(ewp->p),&buff);
    //check for accidenatl equality, check if x-values are equal
    if(u1.compare(&u2)==0)
    {
        //check if y-values are also equal
        if(s1.compare(&s2)==0)
        {
            //do point doubling
            return dopp(ewp);
        }
        else
        {
             //neutrales element
            x.storlong(0);y.storlong(1);z.storlong(0);
            neutral=true;
            return 0;
       }

    }
      //H = U2-U1
    h.copynum(&u2); h.subtrnum_q(&u1,&(ewp->p));
      //HH = H^2
    hh.copynum(&h); hh.quadmodul_l1(&(ewp->p),&buff);
      //HHH = H*HH
    hhh.copynum(&hh); hhh.multnum_l1(&h,&(ewp->p),&buff);
      //r = S2-S1
    r.copynum(&s2); r.subtrnum_q(&s1,&(ewp->p));
      //V = U1*HH
    v.copynum(&u1); v.multnum_l1(&hh,&(ewp->p),&buff);
    //X3 = r^2-HHH-2*V
    x3.copynum(&r); x3.quadmodul_l1(&(ewp->p),&buff); x3.subtrnum_q(&hhh,&(ewp->p));
    i.copynum(&v); i.shiftoneup_q(); i.cheap_modreduce(&(ewp->p));
    x3.subtrnum_q(&i,&(ewp->p));
      //Y3 = r*(V-X3)-S1*HHH
    y3.copynum(&v); y3.subtrnum_q(&x3,&(ewp->p));y3.multnum_l1(&r,&(ewp->p),&buff);
    i.copynum(&s1); i.multnum_l1(&hhh,&(ewp->p),&buff);
    y3.subtrnum_q(&i,&(ewp->p));
      //Z3 = Z1*Z2*H
    z3.copynum(&z); z3.multnum_l1(&(summand->z),&(ewp->p),&buff); z3.multnum_l1(&h,&(ewp->p),&buff);
    //all done - hopefully
    z3.setsize();
    if(z3.hibit==-1) //is neutral
    {
            //neutrales element
            x.storlong(0);y.storlong(1);z.storlong(0);
            neutral=true;
            return 0;
    }
    x.copynum(&x3); y.copynum(&y3); z.copynum(&z3);

    return 1;
};
/**********************************************************/
/**********************************************************/

int proj_jacobian::dopp_spec(ellipse* ewp)
{
    //for  a=-3
    longnumber d,g,b,a,h1,x3,y3,z3,buff;

    if(neutral) return 0;
     //delta = Z1^2
    buff.resizelonu(2*((ewp->q).size +4));

     d.copynum(&z); d.multnum_l1(&z,&(ewp->p),&buff);
      //gamma = Y1^2
     g.copynum(&y); g.multnum_l1(&y,&(ewp->p),&buff);
      //beta = X1*gamma
     b.copynum(&x); b.multnum_l1(&g,&(ewp->p),&buff);
      //alpha = 3*(X1-delta)*(X1+delta)
     h1.copynum(&x);h1.subtrnum_q(&d,&(ewp->p));
     a.copynum(&x);a.addnum_q(&d,&(ewp->p));
     a.multnum_l1(&h1,&(ewp->p),&buff);a.mult3mod(&(ewp->p));
      //X3 = alpha^2-8*beta
    h1.copynum(&b);h1.shiftbits_q(3);h1.lonumodulo_qqq_e(&(ewp->p));
    x3.copynum(&a); x3.multnum_l1(&a,&(ewp->p),&buff);x3.subtrnum_q(&h1,&(ewp->p));
      //Z3 = (Y1+Z1)^2-gamma-delta
    h1.copynum(&y); h1.addnum_q(&z,&(ewp->p));z3.copynum(&h1); z3.multnum_l1(&h1,&(ewp->p),&buff);
    z3.subtrnum_q(&g,&(ewp->p)); z3.subtrnum_q(&d,&(ewp->p));
      //Y3 = alpha*(4*beta-X3)-8*gamma^2
    y3.copynum(&b); y3.shiftbits_q(2); y3.lonumodulo_qqqq(&(ewp->p));
    y3.subtrnum_q(&x3,&(ewp->p)); y3.multnum_l1(&a,&(ewp->p),&buff);
    h1.copynum(&g); h1.multnum_l1(&g,&(ewp->p),&buff);h1.shiftbits_q(3); h1.lonumodulo_qqq_e(&(ewp->p));
    y3.subtrnum_q(&h1,&(ewp->p));
    x.copynum(&x3); y.copynum(&y3); z.copynum(&z3);
    return 1;
};
/**********************************************************/
/**********************************************************/
int proj_jacobian::dopp(ellipse* ewp)
{
    //longnumber w,wh,s,B,H,drei,squad,wt;
    longnumber *pp,h1,h2,z3,y3,x3,xx,yy,zz,s,m,i,buff;

    if(neutral) return 0;
    if(ewp->a_m3) return(dopp_spec(ewp));
    buff.resizelonu(2*((ewp->q).size +4));
    pp=&(ewp->p);
    //XX = X^2
      //YY = Y1^2
      //ZZ = Z1^2
      xx.copynum(&x);
      xx.quadmodul_l1(pp,&buff);
      yy.copynum(&y); yy.quadmodul_l1(pp,&buff);
      zz.copynum(&z); zz.quadmodul_l1(pp,&buff);
      //S = 4*X1*YY
      s.copynum(&yy); s.shiftbits_q(2);s.lonumodulo_qqqq(pp); s.multnum_l1(&x,pp,&buff);
      //M = 3*XX+a*ZZ^2
      m.copynum(&zz); m.quadmodul_l1(pp,&buff);m.multnum_l1(&(ewp->a),pp,&buff);
      //m.copynum(&(ewp->a)); m.multnum_qqq(&zz,pp,false); m.multnum_qqq(&zz,pp,false);
      i.copynum(&xx); i.mult3mod(pp);
      m.addnum_q(&i); m.cheap_modreduce(pp);
      //T = M^2-2*S
      i.copynum(&s); i.shiftoneup_q(); i.cheap_modreduce(pp);
      x3.copynum(&m); x3.quadmodul_l1(pp,&buff); x3.subtrnum_q(&i,pp);x3.setsize();
      //X3 = T
      //x3.copynum(&t);
      //Y3 = M*(S-T)-8*YY^2
      y3.copynum(&s);y3.subtrnum_q(&x3,pp);y3.multnum_l1(&m,pp,&buff);
      i.copynum(&yy); i.quadmodul_l1(pp,&buff); i.shiftbits_q(3); i.lonumodulo_qqq_e(pp);
      y3.subtrnum_q(&i,pp);
      //Z3 = 2*Y1*Z1
      z3.copynum(&z); z3.shiftoneup_q(); z3.cheap_modreduce(pp);z3.multnum_l1(&y,pp,&buff);
    x.copynum(&x3); y.copynum(&y3); z.copynum(&z3);
    return 1;
};
/**********************************************************/
bool proj_jacobian::copy_prj(proj_jacobian* source)
{
    x.copynum(&(source->x));
    y.copynum(&(source->y));
    z.copynum(&(source->z));
    neutral= source->neutral;
    return true;
};
/**********************************************************/
int proj_jacobian::mult_prj(longnumber* factor,ellipse* ewp)
{
    long i,lc=1;
    proj_jacobian h(this);
    bool bit;

   factor->lonumodulo_qqq_e(&(ewp->q));
   factor->setsize();
   for(i=factor->hibit-1;i>=0;i--)
   {
      h.dopp(ewp);
      bit=factor->getbit(i);
      if(bit)
      {
          h.add(this,ewp);
          lc++;
      }
   }
   copy_prj(&h);
   return ((int) lc);
};
/**********************************************************/
int proj_jacobian::mult_prj_q_mc(longnumber* factor,ellipse* ewp) //multicore version
{
    long i,hibitm,h1,bitzahl,lc=1;
    proj_jacobian h(this) ,hj1(this);
    bool bit,add,sub;
    longnumber fa,fs;
    //pthread_t dblthread;
    long iret;
    //ellipse **tp;

   factor->lonumodulo_qqq_e(&(ewp->q));
   factor->setsize();
   h.copy_prj(this);
   hj1.copy_prj(this);
    hibitm=factor->get_hibit();
    if(hibitm == 0)
    {
        return 0; //faktor 1
    }
   if(hibitm==-1) //faktor 0
   {
       neutralize();
       return 0;
   }
   if(hibitm<10)
   {
       return mult_prj(factor,ewp);
   }
    factor->kobz_trans(&fa,&fs);
    hibitm=fa.get_hibit();h1=fs.get_hibit();
    if(h1>hibitm) hibitm=h1;
    proj_jacobian accu(this);
    accu.neutralize();
    proj_jacobian saccu(&accu);
    //hj1.copy_prj(&h);
  DoppThread *m_pThread; //create thread
    for(bitzahl=0;bitzahl<=hibitm;bitzahl++)
    {
        //start doubling of h1 in separate thread
        //tp=(ellipse**)malloc(sizeof(proj_jacobian *) + sizeof(ellipse *));
        //*tp=(ellipse *)&hj1;
        //*(tp+1)=(ellipse *) ewp;
        //iret = pthread_create( &dblthread, NULL, th_doubl, (void *)tp);
        m_pThread = new DoppThread(&hj1,ewp);
        if ( m_pThread->Create() != wxTHREAD_NO_ERROR )
        {
            throwout(_("Can't create the thread!"),3);
            delete m_pThread;
            m_pThread = NULL;
        }
        else
        {
            if (m_pThread->Run() != wxTHREAD_NO_ERROR )
            {
                throwout(_("Can't create the thread!"),3);
                delete m_pThread;
                m_pThread = NULL;
            }
        }
        // thread is fired

        add=fa.getbit(bitzahl);
        sub=fs.getbit(bitzahl);
        if(add) accu.add(&h,ewp);
        if(sub) saccu.add(&h,ewp);
    //join threads again
       iret=(long) m_pThread->Wait();
       delete m_pThread;
        //pthread_join( dblthread, NULL);
        //free(tp);
        //h.dopp(ewp);
        h.copy_prj(&hj1);
    }
    accu.subtract(&saccu,ewp);
    copy_prj(&accu);
   return ((int) bitzahl);
};
/**********************************************************/
void *th_doubl( void *tq )
{
    proj_jacobian *pj;
    ellipse *pe;
    proj_jacobian **tp;

    tp= (proj_jacobian **) tq;
    pj= (proj_jacobian *) *tp;
    pe=(ellipse *) (*(tp +1));
    pj->dopp(pe);
}
/**********************************************************/
int proj_jacobian::mult_prj_q(longnumber* factor,ellipse* ewp, bool mc)
{
    long i,hibitm,h1,bitzahl,lc=1;
    proj_jacobian h(this);
    bool bit,add,sub;
    longnumber fa,fs;

#if defined(__MONOCORE__)
    mc=false;
#endif
   if(mc) return( mult_prj_q_mc(factor, ewp)  );  //if multicore within
   else //explicitly monothread within
   {
     factor->lonumodulo_qqq_e(&(ewp->q));
     factor->setsize();
      hibitm=factor->get_hibit();
      if(hibitm == 0)
      {
          return 0; //faktor 1
      }
     if(hibitm==-1) //faktor 0
       {
         neutralize();
         return 0;
       }
      if(hibitm<10) return mult_prj(factor,ewp);
      factor->kobz_trans(&fa,&fs);
      hibitm=fa.get_hibit();h1=fs.get_hibit();
      if(h1>hibitm) hibitm=h1;
      proj_jacobian accu(this);
      accu.neutralize();
      proj_jacobian saccu(&accu);
      for(bitzahl=0;bitzahl<=hibitm;bitzahl++)
      {
        add=fa.getbit(bitzahl);
        sub=fs.getbit(bitzahl);
        if(add) accu.add(&h,ewp);
        if(sub) saccu.add(&h,ewp);
        h.dopp(ewp);
      }
      accu.subtract(&saccu,ewp);
      copy_prj(&accu);
      return ((int) bitzahl);
   }
};
/**********************************************************/

bool proj_jacobian::isequal(proj_jacobian* point)
{
    if(neutral && point->neutral) return true;

    if(point->x.compare(&x) !=0 ) return false;
    if(point->y.compare(&y) !=0 ) return false;
    if(point->z.compare(&z) !=0 ) return false;
    return true;
};
/************************* to do *********************************/
bool proj_jacobian::isequal(proj_jacobian* point, longnumber* pmodul, bool test_affine)
{
    longnumber x1,y1,z1,x2,y2,z2,h1,drei;
    bool z_eq=false;

    if(neutral && point->neutral) return true;

    x1.copynum(&x);x1.lonumodulo_qqqq(pmodul);
    y1.copynum(&y);y1.lonumodulo_qqqq(pmodul);
    z1.copynum(&z);z1.lonumodulo_qqqq(pmodul);
    x2.copynum(&(point->x)); x2.lonumodulo_qqqq(pmodul);
    y2.copynum(&(point->y)); y2.lonumodulo_qqqq(pmodul);
    z2.copynum(&(point->z)); z2.lonumodulo_qqqq(pmodul);
    if(test_affine)
    {
        if(z1.compare(&z2)==0) z_eq=true;
        if(!z_eq)
        { x2.multnum_qqq(&z1,pmodul);
          x2.multnum_qqq(&z1,pmodul);
          x1.multnum_qqq(&z2,pmodul);
          x1.multnum_qqq(&z2,pmodul);
        }
        if(x2.compare(&x1) !=0 ) return false;

        if(!z_eq)
        {
            drei.storlong(3);
            h1.copynum(&z1);
            h1.pownum(&drei,pmodul);
            y2.multnum_qqq(&h1,pmodul);
            h1.copynum(&z2);
            h1.pownum(&drei,pmodul);
            y1.multnum_qqq(&h1,pmodul);
        }
        if(y2.compare(&y1) !=0 ) return false;

        return true;
    }
    else  //if not affine testing
    {
        if(x2.compare(&x1) !=0 ) return false;
        if(y2.compare(&y1) !=0 ) return false;
        if(z2.compare(&z1) !=0 ) return false;
        return true;
    }
    return false; //never get here
};
/**********************************************************/
int proj_jacobian::neutralize()
{
    x.storlong(0);y.storlong(1);z.storlong(0);
    neutral=true;
    return 0;
};
/**********************************************************/
bool proj_jacobian::spitout(e_p* outpoint,ellipse* ewp)
{
    longnumber zinv,aq,ah3;
    bool fl1;

    outpoint->neutral=neutral;
    if(neutral) //neutral
    {
        outpoint->neutralize();
        return true;
    }
    fl1= z.get_mod_inv_q(&zinv, &(ewp->p));
    if(!fl1) return fl1;
    aq.copynum(&zinv); aq.quadmodul_l(&(ewp->p));
    ah3.copynum(&aq); ah3.multnum_qqq(&zinv,&(ewp->p));
    outpoint->x.copynum(&x);
    outpoint->x.multnum_qqq(&aq,&(ewp->p));
    outpoint->y.copynum(&y);
    outpoint->y.multnum_qqq(&ah3,&(ewp->p));
    outpoint->neutral=neutral;
    return fl1;
};
/**********************************************************/

/***************************************/
/***************************************/

/************Globals about elliptic   ******************/
/***************************************************/
int sign_elliptic(wxString fnam, ellipse *dom_p, el_priv *ky, longnumber *pr, longnumber *ps)
{
   longnumber ke,r,h,ke_inv,s,maybeone;
   unsigned long maxsiz;
   e_p R;
   bool fl1;


    if(!wxFileExists(fnam))
    {
        throwout(_("File does not exist error\ncannot sign"),20);
        return -1;
    }
   maxsiz= (dom_p->q).size -1;
    // choose lonu ke as random ephemeralky < q
   ke.makerandom(maxsiz);
    //Compute R = ke * P0
   R.copy_ep(&(dom_p->d0));
   R.mult_p_q(&ke, dom_p);
    //let r= XR
    pr->copynum(&(R.x));
    //compute s= (h(file) + privkey * r) * (1/ke mod q)
    fl1=get_lonu_hash_from_filename(&h,&fnam,(dom_p->q).size-1);
    ps->copynum(&(ky->d));
    ps->multnum_q(pr,&(dom_p->q));
    ps->addnum_q(&h,&(dom_p->q));
    fl1=ke.get_mod_inv_q(&ke_inv,&(dom_p->q));
    ke_inv.lonumodulo_qqq(&(dom_p->q));
    ps->multnum_q(&ke_inv,&(dom_p->q));
    return 0;
}
/****************************************/
bool verify_elliptic(wxString fnam, ellipse *dom_p, e_p *p_pubky, longnumber *pr, longnumber *ps)
{
    longnumber h,w,u1,u2;
    e_p P1,P2;
    bool fl1;
    int nullgood;

    if(!wxFileExists(fnam))
    {
        throwout(_("File does not exist error\ncannot verify"),4);
        return false;
    }
    // produce h(file)
    fl1=get_lonu_hash_from_filename(&h,&fnam,(dom_p->q).size-1);
    // compute w= (1/s modq)
    fl1=ps->get_mod_inv_q(&w,&(dom_p->q));
    w.lonumodulo_qqq(&(dom_p->q));
    //compute u1= w*h(file) mod q
    u1.copynum(&w);
    u1.multnum_q(&h,&(dom_p->q));
    //compute u2= w*r modq
    u2.copynum(&w);
    u2.multnum_q(pr,&(dom_p->q));
    //compute P= u1* P0 + u2* *p_pubky
    P1.copy_ep(&(dom_p->d0));
    P1.mult_p(&u1,dom_p);
    P2.copy_ep(p_pubky);
    P2.mult_p(&u2,dom_p);
    P1.add(&P2,dom_p);
    //if PX= r mod q ->valid  else invalid
    nullgood=(P1.x).compare(pr); //wenn valide ists 0
    if(nullgood ==0) return true;
    //return result
  return false;
}
/****************************************/
/***************************************************/
int sign_elliptic_q(wxString fnam, ellipse *dom_p, el_priv *ky, longnumber *pr, longnumber *ps)
{
   longnumber ke,r,h,ke_inv,s,maybeone;
   unsigned long maxsiz;
   e_p R;
   bool fl1;

   maxsiz= (dom_p->q).size -1;
    // choose lonu ke as random ephemeralky < q
   ke.makerandom(maxsiz);
    //Compute R = ke * P0
   R.copy_ep(&(dom_p->d0));
   R.mult_p_qj(&ke, dom_p);
    //let r= XR
    pr->copynum(&(R.x));
    //compute s= (h(file) + privkey * r) * (1/ke mod q)
    fl1=get_lonu_hash_from_filename(&h,&fnam,(dom_p->q).size-1);
    ps->copynum(&(ky->d));
    ps->multnum_qqq(pr,&(dom_p->q));
    ps->addnum_q(&h,&(dom_p->q));
    fl1=ke.get_mod_inv_q(&ke_inv,&(dom_p->q));
    ke_inv.lonumodulo_qqq(&(dom_p->q));
    ps->multnum_qqq(&ke_inv,&(dom_p->q));
    return 0;
}
/****************************************/
bool verify_elliptic_q(wxString fnam, ellipse *dom_p, e_p *p_pubky, longnumber *pr, longnumber *ps)
{
    longnumber h,w,u1,u2;
    e_p P1,P2;
    bool fl1;
    int nullgood;

    // produce h(file)
    fl1=get_lonu_hash_from_filename(&h,&fnam,(dom_p->q).size-1);
    // compute w= (1/s modq)
    fl1=ps->get_mod_inv_q(&w,&(dom_p->q));
    w.lonumodulo_qqq(&(dom_p->q));
    //compute u1= w*h(file) mod q
    u1.copynum(&w);
    u1.multnum_qqq(&h,&(dom_p->q));
    //compute u2= w*r modq
    u2.copynum(&w);
    u2.multnum_qqq(pr,&(dom_p->q));
    //compute P= u1* P0 + u2* *p_pubky
    P1.copy_ep(&(dom_p->d0));
    P1.mult_p_qj(&u1,dom_p);
    P2.copy_ep(p_pubky);
    P2.mult_p_qj(&u2,dom_p);
    P1.add(&P2,dom_p);
    //if PX= r mod q ->valid  else invalid
    nullgood=(P1.x).compare(pr); //wenn valide ists 0
    if(nullgood ==0) return true;
    //return result
  return false;
}
/****************************************/
precalc::precalc()
{
    to_abort=false;
    is_done=false;
    is_used=true;
    return;
}
/***************************************************/
void precalc::wipe()
{
    kinv.wipezero();
    ke.wipezero();
    is_done=false;
    to_abort=false;
    domnam=_("empty");
    is_used=true;

    return;
}
/****************************************/
precalc::~precalc()
{
    ke.wipewith(13);
    kinv.wipewith(13);
    return;
}
/****************************************/
bool  precalc::copy_pre(precalc *ppre)
{
      to_abort = ppre->to_abort;
      is_done = ppre->is_done;
      is_used = ppre->is_used;
      is_running = ppre->is_running;
      ke.copynum(&(ppre->ke));
      kinv.copynum(&(ppre->kinv));

#if defined(__WXMSW__)
   VirtualLock(ke.ad,ke.length);
   VirtualLock(kinv.ad,kinv.length);
#else
 mlock(ke.ad,ke.length);
 mlock(kinv.ad,kinv.length);
#endif

      r.copynum(&(ppre->r));
      pe=ppre->pe;
      domnam=ppre->domnam;
      return true;
}
/***************************************************/
bool precalc::set_prec( ellipse *ewp, bool multithread)
{
    unsigned long maxsiz;
    longnumber tst;
    pe=ewp;
    e_p R;
    bool fl1;

    domnam=ewp->name;
    is_running=true;
   (pe->q).setsize(true);
   maxsiz= (pe->q).size;
    // choose lonu ke as random ephemeralky < q
   ke.makerandom(maxsiz);
   ke.setsize(true);
   while(ke.hibit >=  (pe->q).hibit)
   {
       *((ke.ad)+(maxsiz-1))= zuf.get_rbyte();
       if(maxsiz>=2) *((ke.ad)+(maxsiz-2))= zuf.get_rbyte();
       ke.setsize(true);
   }
   //check and throw alert on suspicious ke
   tst.copynum(&ke);
   tst.inc();tst.inc();
   if(tst.compare(&(pe->q))>=1) //alert!!
       {
         printf("alert, strange ephemeral key, aborting!");
         return false;
       }
   //end of intruder check
   fl1=ke.get_mod_inv_q(&kinv,&(pe->q));
   if(!fl1)
   {
       //throwout(_("Warning: \ncould not determine inv of ephemeral key."),3);
       printf("Warning: could not determine inv of ephemeral key.");
       is_done=false;
       is_used=true;
       is_running=false;
       return false;
   }
   kinv.lonumodulo_qqqq(&(pe->q));   //kinv is set!
   //now lock ke into RAM
   #if defined(__WXMSW__)
   VirtualLock(ke.ad,ke.length);
   VirtualLock(kinv.ad,kinv.length);
#else
 mlock(ke.ad,ke.length);
 mlock(kinv.ad,kinv.length);
#endif


   //Compute R = ke * P0
   R.copy_ep(&(pe->d0));
   R.mult_p_qj(&ke, pe, multithread);
    //let r= XR
   r.copynum(&(R.x));  //r is set!
   domnam=pe->name;
   is_done=true;
   is_used=false;
   is_running=false;
    return true;
}
/***************************************************/
int sign_elliptic_pre(precalc *pre, wxString fnam, ellipse *dom_p, el_priv *ky, longnumber *pr, longnumber *ps, wxString* hash)
{
   longnumber ke,r,h,ke_inv,s,maybeone,tst;
   unsigned long maxsiz;
   e_p R;
   bool fl1;

    if(!(pre->is_done)  || (pre->domnam)!=(dom_p->name) || (pre->is_used))
    {
        return (sign_elliptic_qq( fnam, dom_p, ky, pr, ps, hash));
    }
    //pre structure is there!
    if(!wxFileExists(fnam))
    {
        throwout(_("File does not exist error\ncannot verify"),4);
        return false;
    }
    pr->copynum(&(pre->r));
    //compute s= (h(file) + privkey * r) * (1/ke mod q)
    if(*hash==_("Fleas_1_8"))
    {
       fl1=get_lonu_hash_from_filename(&h,&fnam,128);
    }
    else if(*hash==_("sha2"))
      {
          fl1=get_lonu_sha2_from_filename(&h,&fnam);
       }
    else if(*hash==_("sha4"))
      {
          fl1=get_lonu_sha2_from_filename(&h,&fnam,512);
       }
     else if(*hash==_("JH"))
      {
          fl1=get_lonu_JH_from_filename(&h,&fnam,512);
       }
      else if(*hash==_("Fleas_3"))
        {
          fl1=get_lonu_hash_from_filename_3(&h,&fnam,128);
        }
      else if(*hash==_("Fleas_4"))
        {
          fl1=get_lonu_hash_from_filename_4(&h,&fnam,256);
        }
       else if(*hash==_("Fleas_5"))
        {
          fl1=get_lonu_hash_from_filename_5(&h,&fnam,256);
        }
      else if(*hash==_("Fleas_x2")||*hash==_("Fleas_o2"))
        {
          fl1=get_lonu_hash_from_filename_x(&h,&fnam,256,*hash);
        }
       else if(*hash==_("Fleas_x5")||*hash==_("Fleas_o5")||*hash==_("Fleas_l")||*hash==_("Fleas_lx")||*hash==_("Fleas_lx3")||*hash==_("Fleas_lc")
               ||*hash==_("Fleas_ld")||*hash==_("Fleas_lb")||*hash==_("Fleas_c")
               ||*hash==_("Fleas_d")||*hash==_("Fleas_b"))
        {
          fl1=get_lonu_hash_from_filename_x(&h,&fnam,512,*hash);
        }
       else
          {
            throwout(_("unknown hash,\n using Fleas_1_8 instead"));
            fl1=get_lonu_hash_from_filename(&h,&fnam,128);
            *hash=_("Fleas_1_8");
          }

    //modreduction with q
    h.lonumodulo_qqq(&(dom_p->q));
    ps->copynum(&(ky->d));
    ps->multnum_qqq(pr,&(dom_p->q));
    ps->addnum_q(&h,&(dom_p->q));
    //fl1=ke.get_mod_inv_q(&ke_inv,&(dom_p->q));
    ke_inv.copynum(&(pre->kinv));
    //ke_inv.lonumodulo_qqq(&(dom_p->q));
    ps->multnum_qqq(&ke_inv,&(dom_p->q));
    //put r amd s into lonus, schon erledigt
    pre->wipe();
    return 0;
}
/***************************************************/

/***************************************************/
int sign_elliptic_qq(wxString fnam, ellipse *dom_p, el_priv *ky, longnumber *pr, longnumber *ps, wxString* hash, bool shoprog, bool deterministic,wxString* detwordpt)
// if deterministic sign predictably
{
   longnumber ke,r,h,ke_inv,s,maybeone,tst,loc_k,h1;
   unsigned long maxsiz;
   e_p R;
   bool fl1;
   int stln,i;
   char buff[402];

    if(!wxFileExists(fnam))
    {
        throwout(_("File does not exist error\ncannot verify"),4);
        return -1;
    }
   (dom_p->q).setsize(true);
   maxsiz= (dom_p->q).size;
   //get hash value
   if(*hash==_("Fleas_1_8"))
    {
       fl1=get_lonu_hash_from_filename(&h,&fnam,128);
    }
    else if(*hash==_("sha2"))
      {
          fl1=get_lonu_sha2_from_filename(&h,&fnam);
       }
    else if(*hash==_("sha4"))
      {
          fl1=get_lonu_sha2_from_filename(&h,&fnam,512);
       }
    else if(*hash==_("JH"))
      {
          fl1=get_lonu_JH_from_filename(&h,&fnam,512);
       }
      else if(*hash==_("Fleas_3"))
        {
          fl1=get_lonu_hash_from_filename_3(&h,&fnam,128);
        }
      else if(*hash==_("Fleas_4"))
        {
          fl1=get_lonu_hash_from_filename_4(&h,&fnam,256);
        }
       else if(*hash==_("Fleas_5"))
        {
          fl1=get_lonu_hash_from_filename_5(&h,&fnam,256,shoprog);
        }
      else if(*hash==_("Fleas_x2")||*hash==_("Fleas_o2"))
        {
          fl1=get_lonu_hash_from_filename_x(&h,&fnam,256,*hash);
        }
       else if(*hash==_("Fleas_x5")||*hash==_("Fleas_o5")||*hash==_("Fleas_l")||*hash==_("Fleas_lx")||*hash==_("Fleas_lx3")||*hash==_("Fleas_lc")
               ||*hash==_("Fleas_ld")||*hash==_("Fleas_lb")||*hash==_("Fleas_b")||*hash==_("Fleas_c")||*hash==_("Fleas_d"))
        {
          fl1=get_lonu_hash_from_filename_x(&h,&fnam,512,*hash,shoprog);
        }
       else
          {
            throwout(_("unknown hash,\n using Fleas_1_8 instead"));
            fl1=get_lonu_hash_from_filename(&h,&fnam,128);
            *hash=_("Fleas_1_8");
          }
    if(fl1==false)
    {
        throwout(_(" hash calculation failed"),5);
        return -1;
    }
   // hash value found
    h.setsize(true);
   if(!deterministic)
   {
      // choose lonu ke as random ephemeralky < q
     ke.makerandom(maxsiz);
     ke.setsize(true);
     while(ke.hibit >=  (dom_p->q).hibit)
     {
       *((ke.ad)+(maxsiz-1))= zuf.get_rbyte();
       if(maxsiz>=2) *((ke.ad)+(maxsiz-2))= zuf.get_rbyte();
       ke.setsize(true);
     }
   }
   else //deterministic ke
   {
       //fill a lonu with hash
       tst.copynum(&h);
       //derive local key from private key
       loc_k.copynum(&(ky->d));
       if(!loc_k.randomize_e(2))
       {
           throwout(_(" error in randomizing fun"),3);
           return -1;
       }
       //codevelop local key and hash
       tst.randomize(3,&loc_k,(dom_p->q).size); //cagesize 0 and warnflag 0
       tst.setsize(true);
       //use additional longnumber from keyword
       //AskInput ainp(NULL,_("Give short determinate word"),&detword);
       //if ( ainp.ShowModal() == 1 ) //mix with addtnl input
       if(detwordpt!=NULL)
       {
         //convert to longnumber
         if((*detwordpt).Len()>100)
         {
           throwout(_("Alert! suggested determinate excessively long\n truncating!"));
           (*detwordpt).Truncate(100);
         }
         strcpy(buff, (const char*) (*detwordpt).mb_str(wxConvLocal));
         //place buffer in longnumber
         stln= strlen(&buff[0]);
         if(stln>0)
         {
            h1.resizelonu((ulong32)stln+2,0);
            memcpy(h1.ad,&buff[0],stln);
            h1.setsize(true);
            //do the mingle
            tst.randomize(3,&h1,tst.size); //cagesize 0 and warnflag 0
         }
       }
       tst.setsize(true);
       //modreduce wrt group order
       ke.copynum(&tst);
       ke.lonumodulo_qqq_e(&(dom_p->q));
       ke.setsize(true);
    }
    //check and throw alert on suspicious ke; use tst again
    tst.copynum(&ke);
    tst.inc();tst.inc();
    if(tst.compare(&(dom_p->q))>=1) //alert!!
       {
        throwout(_("Intruder alert!\n dysfunctional ephemeral key\nnear impossible to happen accidentally!!!\naborting immediately!"));
        throwout(_("Check integrity of Academic Signature immediately!"));
        return -1;
       }
    tst.storlong(257);
    if(tst.compare(&ke)>1)  //alert 2
       {
        throwout(_("Alert!\n dysfunctionally small ephemeral key\nnear impossible to happen accidentally!!!"));
        throwout(_("If not done on purpose, check integrity of Academic Signature immediately!"));
       }
       //end of intruder check

    //Compute R = ke * P0
   R.copy_ep(&(dom_p->d0));
   R.mult_p_qj(&ke, dom_p);
    //let r= XR
    pr->copynum(&(R.x));
    //compute s= (h(file) + privkey * r) * (1/ke mod q)

    //modreduction with q
    h.lonumodulo_qqq_e(&(dom_p->q));
    ps->copynum(&(ky->d));
    ps->multnum_l1(pr,&(dom_p->q));
    ps->addnum_q(&h,&(dom_p->q));
    fl1=ke.get_mod_inv_q(&ke_inv,&(dom_p->q));
    ke_inv.lonumodulo_qqq_e(&(dom_p->q));
    ps->multnum_l1(&ke_inv,&(dom_p->q));
    //put r amd s into lonus, schon erledigt
    return 0;
}
/****************************************/
bool verify_elliptic_qq(wxString fnam, ellipse *dom_p, e_p *p_pubky, longnumber *pr, longnumber *ps, wxString hash,bool shoprog)
{
    longnumber h,w,u1,u2;
    e_p P1,P2;
    bool fl1;
    int nullgood;
    //pthread_t thread1;
    long iret;
    e_p **tp;


    if(!wxFileExists(fnam))
    {
        throwout(_("File does not exist error\ncannot verify"),4);
        return false;
    }
    // produce h(file)
    if(hash==_("Fleas_1_8"))
    {
       fl1=get_lonu_hash_from_filename(&h,&fnam,128);
    }
    else if(hash==_("sha2"))
      {
        fl1=get_lonu_sha2_from_filename(&h,&fnam);
      }
    else if(hash==_("sha4"))
      {
        fl1=get_lonu_sha2_from_filename(&h,&fnam,512);
      }
    else if(hash==_("JH"))
      {
        fl1=get_lonu_JH_from_filename(&h,&fnam,512);
      }
      else if(hash==_("Fleas_3"))
        {
          fl1=get_lonu_hash_from_filename_3(&h,&fnam,128);
        }
      else if(hash==_("Fleas_4"))
        {
          fl1=get_lonu_hash_from_filename_4(&h,&fnam,256);
        }
       else if(hash==_("Fleas_5"))
        {
          fl1=get_lonu_hash_from_filename_5(&h,&fnam,256,shoprog);
        }
      else if(hash==_("Fleas_x2")||hash==_("Fleas_o2"))
        {
          fl1=get_lonu_hash_from_filename_x(&h,&fnam,256,hash,shoprog);
        }

      else if(hash==_("Fleas_x5")||hash==_("Fleas_o5")||hash==_("Fleas_l")||hash==_("Fleas_lx")||hash==_("Fleas_lx3")||hash==_("Fleas_lc")
              ||hash==_("Fleas_ld")||hash==_("Fleas_lb")||hash==_("Fleas_b")||hash==_("Fleas_c")||hash==_("Fleas_d"))
        {
          if(hash==_("Fleas_l")) throwout(_("Warning: Signature employs insecure Hash algorithm.\nWill prove anyways..."),4);
          fl1=get_lonu_hash_from_filename_x(&h,&fnam,512,hash,shoprog);
        }

          else
          {
              throwout(_("Unknown Hash specifier\naborting verification!"));
              return false;
          }

    //modreduction with q
    h.lonumodulo_qqq_e(&(dom_p->q));
    // compute w= (1/s modq)
    fl1=ps->get_mod_inv_q(&w,&(dom_p->q));
    w.lonumodulo_qqq_e(&(dom_p->q));
    //compute u1= w*h(file) mod q
    u1.copynum(&w);
    u1.multnum_l1(&h,&(dom_p->q));
    //compute u2= w*r modq
    u2.copynum(&w);
    u2.multnum_l1(pr,&(dom_p->q));
    //compute P= u1* P0 + u2* *p_pubky
    P1.copy_ep(&(dom_p->d0));
    //do this in extra thread!
    #if defined(__MONOCORE__)
    P1.mult_p_qj(&u1,dom_p);
    #else
    MyThread *m_pThread;
    tp=(e_p**)malloc(sizeof(e_p *) + sizeof(longnumber *) + sizeof(ellipse *));
    *tp=(e_p *)&P1;
    *(tp+1)=(e_p *) &u1;
    *(tp+2)=(e_p *) dom_p;
    m_pThread = new MyThread((void *)tp);

    if ( m_pThread->Create() != wxTHREAD_NO_ERROR )
        {
            throwout(_("Can't create the thread!"),3);
            delete m_pThread;
            m_pThread = NULL;
        }
        else
        {
            if (m_pThread->Run() != wxTHREAD_NO_ERROR )
            {
                throwout(_("Can't create the thread!"),3);
                delete m_pThread;
                m_pThread = NULL;
            }
        }
        //thread should be on its way


    //iret = pthread_create( &thread1, NULL, th_multip, (void *)tp);
    #endif
    //end of thread
    P2.copy_ep(p_pubky);
    P2.mult_p_qj(&u2,dom_p);

    #if defined(__MONOCORE__)
    //not necessary to wait
    #else
    //join threads again
    iret=(long) m_pThread->Wait();
    delete m_pThread;
    //pthread_join( thread1, NULL);
    //free(tp);
    #endif
    P1.add(&P2,dom_p);
    //if PX= r mod q ->valid  else invalid
    nullgood=(P1.x).compare(pr); //wenn valide ists 0
    if(nullgood ==0) return true;
    //return result
  return false;
}
/****************************************************************/
void *th_multip( void *tq )
{
    e_p *pp1;
    longnumber *pf;
    ellipse *pe;
    e_p **tp;

    tp= (e_p **) tq;
    pp1= (e_p *) *tp;
    pf= (longnumber *)  (*(tp+1));
    pe=(ellipse *) (*(tp +2));
    pp1->mult_p_qj(pf,pe);
    return NULL;
}
/*******************************************************/
/****************************************/
bool recover_ecc_ky(el_priv* p_priv, e_p* pB, longnumber* pky, ellipse* dom_p )
{
    int r1;
    e_p mypoint;
    longnumber invd;
    bool res;

    //invert B to recover key
    // determine privkey inverse
    res= (p_priv->d).get_mod_inv_q(&invd, &(dom_p->q));
    //backroll B
    mypoint.copy_ep(pB);
    r1=mypoint.mult_p_qj(&invd, dom_p);
    //take x-coo for key
    pky->copynum(&(mypoint.x));
    return true;
}
/**********************************************************/
bool make_ecc_ky(longnumber *pke, ellipse *dom_p, e_p *p_pubky, e_p *pB, longnumber *pky)
{
    int r1;
    e_p mypoint;

    pke->setsize(true);
    if( (dom_p->q).compare(pke) <= 0)
    {
        throwout(_("Warning, ephemeral key too large, modreducing."),3);
        pke->lonumodulo_qqq(&(dom_p->q));
    }
    pB->copy_ep(p_pubky);
    r1=pB->mult_p_qj(pke, dom_p); //B is intended for adressee, returnvalue always 0
    //making the key
    mypoint.copy_ep(&(dom_p->d0));
    r1=mypoint.mult_p_qj(pke, dom_p); //B is intended for adressee, returnvalue always 0
    pky->copynum(&(mypoint.x));  //der Schluessel
    return true;
}
/**********************************************************/
bool test_enciph()
{
    longnumber ke,ky, rec_ky;
    e_p B;

    //setprivkey
    el_priv privk(42, &gdom, _("kyidDummy"), _("Frank Zappa"));
    //setpubkey
    el_pub  pubk(&(privk.A), &gdom, _("kyidDummy"), _("Frank Zappa"));
    //make key for Zappa
    ke.storlong(123456789);
    make_ecc_ky(&ke,&gdom, &(pubk.A),&B,&ky);
    //encipher wit ky
    //....
    //pass B to recipient and holder of privkey, recover ky from B
    recover_ecc_ky(&privk, &B, &rec_ky, &gdom);
    if(rec_ky.compare(&ky) !=0)
    {
      throwout(_("test ell enciph failed!"));
      return false;
    }
    else
    {
        throwout(_("test ell enciph succeded!"),3);
        return true;
    }
}
/********************************************************************/
/******************************************************/
/******************************************************/
/******************************************************/
bool kyprep_ol(longnumber *pky, wxString *keystr, longnumber *psalt, ellipse *pse,  int stretch,int outlen )
//produce 512 bit key from ky
{
    longnumber tmp;
    e_p point;
    char *tmpc;
    int i;
    bool goodp;

    // if default return trivial
    pky->stortext(keystr);
    if((*keystr== _("default"))||( (psalt==NULL)&&(stretch==0) ))
    {
        return true; //cut short if default
    }
    pky->setsize(true);
    if(psalt != NULL) pky->appendnum(psalt); //mingle with salt prior to time consuming step
    pky->setsize(true);
    pky->shrinktofit();
    if((outlen>2000)||(outlen<5)){throwout(_("Fatal error!\nkeylength > 2000 bytes or <5 byteis crazy\n aborting!")); return false;}
    tmp.resizelonu(outlen+2,0);
    //expand key into outlen byte with oneway fun from wxstring
    tmpc=develop_o_malloc((int) pky->size, (char *)(pky->ad), 2,5,outlen,2);
    memcpy(tmp.ad,tmpc,outlen);
    free(tmpc);
    tmp.setsize(true);
    if(pse!=NULL)
    {
//initialize Progress bar
       wxProgressDialog pbar(_("stretching"),_("elliptic curve stretching in progress\nplease wait!"),stretch);
       for(i=0;i<stretch;i++) //time consuming operations
       {
           goodp=pbar.Update(i);
         tmp.lonumodulo_qqq(&(pse->q)); //modulo group order q
           //elliptic operations
           point.copy_ep(&(pse->d0));
           point.mult_p_qj(&tmp, pse);
            //put y-coordinate into tmp
            tmp.copynum(&(point.y));
            tmp.appendnum(&(point.x));
            tmp.setsize(true);
       }
    }
    if(psalt != NULL) tmp.randomize_o(2,psalt,(unsigned long)outlen,0,0);//mingle with salt again
    else tmp.randomize_d(2,0);
    tmp.resizelonu(outlen+2,0);
    //expand key into outlen byte with oneway fun from wxstring
    tmpc=develop_o_malloc((int) tmp.size, (char *) tmp.ad, 2,5,outlen,2);
    memcpy(tmp.ad,tmpc,outlen);
    free(tmpc);
    tmp.setsize(true);
    pky->copynum(&tmp);
    //if(
    return true;
}
/*********************************************************/
/******************************************************/
bool kyprep(longnumber *pky, wxString *keystr, longnumber *psalt, ellipse *pse,  int stretch,int outlen, bool legacy )
//produce outlen bit key from ky
{
    longnumber tmp;
    e_p point;
    char *tmpc;
    int i;
    bool goodp;

    // if default return trivial
    if(legacy) pky->stortext_old(keystr);
    else pky->stortext(keystr);
    if((*keystr== _("default"))||( (psalt==NULL)&&(stretch==0) ))
    {
        return true; //cut short if default
    }
    pky->setsize(true);
    pky->shrinktofit(1);
    if(psalt != NULL) pky->appendnum(psalt); //mingle with salt prior to time consuming step
    pky->setsize(true);
    pky->shrinktofit(1);
    if((outlen>2000)||(outlen<5)){throwout(_("Fatal error!\nkeylength > 2000 bytes or <5 byte is crazy\n aborting!")); return false;}
    tmp.resizelonu((unsigned long)(outlen+2),0);
    //expand key into outlen byte with oneway fun from wxstring
    tmpc=develop_o_malloc((int) pky->size, (char *)(pky->ad), 2,5,outlen,2);
    memcpy(tmp.ad,tmpc,outlen);
    free(tmpc);
    tmp.setsize(true);
    if(pse!=NULL)
    {
//initialize Progress bar
       wxProgressDialog pbar(_("stretching"),_("elliptic curve stretching in progress\nplease wait!"),stretch);
       for(i=0;i<stretch;i++) //time consuming operations
       {
           goodp=pbar.Update(i+1u);
         tmp.lonumodulo_qqq_e(&(pse->q)); //modulo group order q
           //elliptic operations
           point.copy_ep(&(pse->d0));
           point.mult_p_qj(&tmp, pse);
            //put y-coordinate into tmp
            tmp.copynum(&(point.y));
            tmp.shrinktofit(1);
            tmp.appendnum(&(point.x));
            tmp.setsize(true);
            tmp.shrinktofit(1);
       }
    }
    if(psalt != NULL) tmp.randomize_o(2,psalt,(unsigned long)outlen,0,0);//mingle with salt again
    else tmp.randomize_d(2,0);
    tmp.resizelonu((unsigned long)(outlen+2),0);
    tmp.setsize(true);
    //expand key into outlen byte with oneway fun from wxstring
    tmpc=develop_o_malloc((int) tmp.size, (char *) tmp.ad, 2,5,outlen,2);
    memcpy(tmp.ad,tmpc,outlen);
    free(tmpc);
    tmp.setsize(true);
    pky->copynum(&tmp);
    //if(
    return true;
}
/*********************************************************/
bool load_pub_ell_ky(el_pub *nky,  wxString *pname)
{
    FILE *kfp;
    int lbl,lbd,elfl;
    char buff[3002];
    long int fpos;
    el_pub oldkey,loky;
    wxString hlp;
    ellipse locell;
    bool lres;

    if(S_FIL) {lres=unlockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang,0,false);} // unlock keyfile
        if(!lres)
        {
            throwout(_("could not unlock public key file!\naborting."),4);
            return false;
        }
    kfp=fopen((const char*) (sec_path +_("/e_ell_Keyfile.kyf")).mb_str(wxConvLocal),"r");


    do{
        lbl=fscanf(kfp," id: %3000s \n",buff);
        if( lbl ==1)
        {
          hlp= wxString::FromUTF8(buff);
          if(hlp != *pname)
          {
             lbd=fscanf(kfp," Name: %3000s ",buff);
             lbd=fscanf(kfp," DomName: %3000s ",buff);
             lbd=fscanf(kfp," Ax: %3000s ",buff);
             lbd=fscanf(kfp," Ay: %3000s ",buff);
          }
        }
        if( lbl == EOF)
        { throwout(_("Key not found/File read Error!"),3);
         fclose(kfp);
         if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // lock keyfile
           return false;
        }
        if(lbl==0)
        {
             fpos=ftell(kfp);
             fpos++;
             fseek ( kfp , fpos , SEEK_SET );
        }
    } while( hlp != *pname);
    loky.id =*pname;
    do{
        if( (lbl=fscanf(kfp,"Name: %3000s ",buff)) == EOF)
        { throwout(_("Name read Error!"));
         fclose(kfp);
         if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // lock keyfile
           return false;
        }
    } while(lbl != 1 );
    //make wxstring from buff
    hlp= wxString::FromUTF8(buff);
    //buff Name nach privkey.rname schreiben
    loky.fullnam= hlp;
    do{
        if( (lbl=fscanf(kfp," DomName: %3000s ",buff)) == EOF)
        { throwout(_("Domain read Error!"));
         fclose(kfp);
         if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // lock keyfile
           return false;
        }
    } while(lbl != 1 );
    //make wxstring from buff
    hlp= wxString::FromUTF8(buff);
    loky.domnam= hlp;

    do{
        if( (lbl=fscanf(kfp,"Ax: %3000s ",buff)) !=1 )
        { throwout(_("Pubkey Ax read Error!"));
            fclose(kfp);
            if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // lock keyfile
            return false;
        }
    } while( lbl != 1);
    // A in den globalen key schreiben
    hlp=wxString::FromUTF8(buff);
    if( !(((loky.A).x).storhex(&hlp))){throwout(_("error reading Ax")); fclose(kfp);
         if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // lock keyfile
         return false;}
    loky.A.x.setsize(); loky.A.x.shrinktofit();

    do{
        if( (lbl=fscanf(kfp,"Ay: %3000s ",buff)) !=1 )
        { throwout(_("Pubkey Ay read Error!"));
            fclose(kfp);
            if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // lock keyfile
            return false;
        }
    } while( lbl != 1);
    fclose(kfp);
    if(S_FIL) {lres=lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang);} // lock keyfile
       if(!lres)
        {
            throwout(_("Alert! could not lock public key file!\nmust clean up manually."),4);
        }
    hlp=wxString::FromUTF8(buff);
    if( !((loky.A.y).storhex(&hlp))){throwout(_("error reading Ay"));
         return false;}
    loky.A.y.setsize(); loky.A.y.shrinktofit();
    //presence of domnam testen
    if(loky.domnam != gdom.name)
    {
        elfl=e_ls.getelp(&locell,loky.domnam);
        if(elfl<0)
        {
            throwout(_("reject to load key based on unknown domain!\nmust import domain: \"")+loky.domnam +_("\" t first!"));
            return false;
        }
    }
    else locell.copyell(&gdom);
    //A testen
    if(! (loky.A).is_in_ellipse(&locell))
    {
        wxMessageBox(_("key is incompatible with own domain!?!\n will not load!\nresetting to last valid key"));
        return false;
    }
    //alles klar, jetzt uebertragen
    if(!nky->copy_pub_ky(&loky))
    {
        throwout(_("Could not kypy key error!?"));
        return false;
    }
    return true;
}
/********************************************************************************************/
/*********************************************************/
bool load_priv_ell_ky(el_priv *nky,  wxString *pname)
{
    FILE *kfp;
    int lbl,lbd,elfl;
    char buff[3002];
    long int fpos;
    el_priv oldkey,loky;
    wxString hlp;
    ellipse locell;

    if(S_FIL) unlockinplace(sec_path + _("/ell_Keyfile.kyf"),&zugang); // unlock keynamefile
    kfp=fopen((const char*) (sec_path +_("/ell_Keyfile.kyf")).mb_str(wxConvLocal),"r");


    do{
        lbl=fscanf(kfp," id: %3000s \n",buff);
        if( lbl ==1)
        {
          hlp= wxString::FromUTF8(buff);
          if(hlp != *pname)
          {
             lbd=fscanf(kfp," Name: %3000s ",buff);
             lbd=fscanf(kfp," DomainName: %3000s ",buff);
             lbd=fscanf(kfp," d: %3000s ",buff);
          }
        }
        if( lbl == EOF)
        { throwout(_("Private Key not found/File read Error!"),3);
         fclose(kfp);
         if(S_FIL) lockinplace(sec_path + _("/ell_Keyfile.kyf"),&zugang); // lock keynamefile
           return false;
        }
        if(lbl==0)
        {
             fpos=ftell(kfp);
             fpos++;
             fseek ( kfp , fpos , SEEK_SET );
        }
    } while( hlp != *pname);
    loky.id =*pname;
    do{
        if( (lbl=fscanf(kfp,"Name: %3000s ",buff)) == EOF)
        { throwout(_("Name read Error!"));
         fclose(kfp);
         if(S_FIL) lockinplace(sec_path + _("/ell_Keyfile.kyf"),&zugang); // lock keynamefile
           return false;
        }
    } while(lbl != 1 );
    //make wxstring from buff
    hlp= wxString::FromUTF8(buff);
    //buff Name nach privkey.rname schreiben
    //underscore durch blank ersetzen
    hlp.Replace(_("_"),_(" "));
    //buff Name nach privkey.rname schreiben
    loky.fullnam= hlp;;
    do{
        if( (lbl=fscanf(kfp," DomainName: %1000s ",buff)) == EOF)
        { throwout(_("Domain read Error!"));
         fclose(kfp);
         if(S_FIL) lockinplace(sec_path + _("/ell_Keyfile.kyf"),&zugang); // lock keynamefile
           return false;
        }
    } while(lbl != 1 );
    //make wxstring from buff
    hlp= wxString::FromUTF8(buff);
    loky.domnam= hlp;
//read the private number
    do{
        if( (lbl=fscanf(kfp," d: %3000s",buff)) !=1 )
        { throwout(_("Privkey d read Error!"));
            fclose(kfp);
            if(S_FIL) lockinplace(sec_path + _("/ell_Keyfile.kyf"),&zugang); // lock keynamefile
            return false;
        }
    } while( lbl != 1);
    // d in den globalen key schreiben
    hlp=wxString::FromUTF8(buff);
    if( !((loky.d).storhex(&hlp))){throwout(_("error reading d")); fclose(kfp);
         if(S_FIL) lockinplace(sec_path + _("/ell_Keyfile.kyf"),&zugang); // lock keynamefile
         return false;}
    //doublecrypt: nochmal exstra entschlüsseln
    loky.d.lonu_unlock(&zugang);
    loky.d.setsize(); loky.d.shrinktofit();

    fclose(kfp);
    if(S_FIL) lockinplace(sec_path + _("/ell_Keyfile.kyf"),&zugang); // lock keynamefile
    //testen auf korrekte domain
    if(gdom.name != loky.domnam)
    {
        elfl=e_ls.getelp(&locell,loky.domnam);
        if(elfl<0)
        {
            throwout(_("reject to load key based on unknown domain!\nmust import domain: \"")+loky.domnam +_("\" t first!"));
            return false;
        }
    }
    else locell.copyell(&gdom);
    if(!elky.set_el_priv(&(loky.d),&(locell),loky.id,loky.fullnam))
    {
        throwout(_("Could not fetch private key error!?"));
        return false;
    }
    loky.d.wipezero(); //blankit
    throwout(_("new private key accepted."),2);
    return true;
}
/********************************************************************************************/
bool export_ellips(ellipse *pelp)
{
    wxString txt;
    char buff[1602];
    FILE *fp;

    if(pelp==NULL) return false;
    //open file with name.ell
    txt=kytray + pelp->name + _(".ell");
    if(txt.length()>800)
    {
        throwout(_("Filename unreasonably long\naborting!\n")+txt);
        return false;
    }
    strcpy(buff,(const char*)txt.mb_str(wxConvLocal));
    if((fp=fopen( buff, "w" ))==NULL)   return false;
    //write ID
    txt=pelp->name;
    strcpy(buff,(const char*)txt.mb_str(wxConvUTF8));
    fprintf(fp,"ID: %s \n",buff);
    //write MODUL:
    pelp->p.writehex(&txt);
    strcpy(buff,(const char*)txt.mb_str(wxConvUTF8));
    fprintf(fp,"MODUL:    %s \n",buff);
     //write coeff_A:
    pelp->a.writehex(&txt);
    strcpy(buff,(const char*)txt.mb_str(wxConvUTF8));
    fprintf(fp,"coeff_A:  %s \n",buff);
    //write coeff_B:
    pelp->b.writehex(&txt);
    strcpy(buff,(const char*)txt.mb_str(wxConvUTF8));
    fprintf(fp,"coeff_B:  %s \n",buff);
    //write q_MODUL:
    pelp->q.writehex(&txt);
    strcpy(buff,(const char*)txt.mb_str(wxConvUTF8));
    fprintf(fp,"q_MODUL:  %s \n",buff);
    //write X0:
    ((pelp->d0).x).writehex(&txt);
    strcpy(buff,(const char*)txt.mb_str(wxConvUTF8));
    fprintf(fp,"X0:       %s \n",buff);
    //write q_MODUL:
    ((pelp->d0).y).writehex(&txt);
    strcpy(buff,(const char*)txt.mb_str(wxConvUTF8));
    fprintf(fp,"Y0:       %s \n",buff);
    fclose(fp);
    return true;
}
/******************************************************/
bool validate_pubkey(el_pub *pk,bool verbose)
//validates public key against domainlist
{
    ellipse locell;
    int elfl;

    if(pk->domnam == gdom.name) locell.copyell(&gdom);
    else
    {
        elfl=e_ls.getelp(&locell,pk->domnam);
        if(elfl<0)
        {
           if(verbose)
                 wxMessageBox(_("key domain unknown\n will not accept public key!"));
           return false;
        }
    }
    if( (pk->A).neutral)
    {
        if(verbose)
            wxMessageBox(_("Public key is neutral elementn\n will not accept key!"));
        return false;
    }
    //check on curve?
    if(! (pk->A).is_in_ellipse(&locell))
    {
        if(verbose)
                wxMessageBox(_("key is incompatible with own domain\n will not accept key!"));
        return false;
    }
    return true;
}
/******************************************************************/
