/***************************************************************
 * Name:      clean_pointersMain.cpp
 * Purpose:   Code for Application Frame
 * Author:    mca (an@fh-wedel.de)
 * Created:   2010-09-14
 * Copyright: mca ()
 * License:
 **************************************************************/
/*
 *   Copyright (C) 2011-2017, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

//#include "../config.h"

#if defined(__WXMSW__)
  //to be filled
#else
 #include <sys/mman.h>  //allow for memory locking of keyinfo
#endif


#include "clean_pointersMain.h"
#include <wx/msgdlg.h>
#include <wx/filedlg.h>
#include <wx/file.h>
#include <time.h>
#include <wx/filefn.h>
#include <wx/icon.h>
#include <wx/dirdlg.h>
#include <wx/utils.h>

//(*InternalHeaders(clean_pointersFrame)
#include <wx/bitmap.h>
#include <wx/icon.h>
#include <wx/font.h>
#include <wx/intl.h>
#include <wx/image.h>
#include <wx/string.h>
//*)

#include "Seedial.h"
#include "elliptic1.h"
#include "ellip_ky_sav.h"
#include "sign_ellip.h"
#include "elliptic_verify.h"
#include "DeletePubEllky.h"
#include "Del_imp_priv.h"
#include "LoadSave_ell_pub.h"
#include "random_clx.h"
#include "hatching.h"
#include "mylogin.h"
#include "changPasphr.h"
#include "elliptic_encipher.h"
#include "deciph_dialog.h"
#include "Settings.h"
#include "enciph_n_authent.h"
#include "timstamp.h"
#include "time_verify.h"
#include "makehash.h"
#include "get_prime.h"
#include "gpg_wrap.h"
#include "gpg_manag_priv.h"
#include "gnupg_sign.h"
#include "gpg_verify.h"
#include "gpg_add_pub.h"
#include "gnupg_select.h"
#include "gpg_enc_dialog.h"
#include "gpg_dec_dialog.h"
#include "advancd_symm.h"
#include "AskDialog.h"
#include "dom_mac.h"
#include "DomainSelector.h"

//#include "globals.h"
/****** global variables ******/
bool thr_wx=true;
bool gpg_here=false;
bool gpg2_here=false;  //ist gpg verfuegbar
bool gpg_pres_checked=false;
wxString gpg_name= _("none "); //gpg Version

char key[200]="abcde"; // Platz für einen Schlüssel -> wird der auch benutzt ???
char f_rnd=5; // Anzahl der Feistel-Runden
int k_rnd=3; // Anzahl der Kangorooh-Runden
int u_len=65; // Einheitslänge
longnumber globlonu; // globale longnumber für
//rsakey privkey; //globaler privater Schlüssel
//rsakey extkey; //aktueller Fremdschlüssel
longnumber zugang; //mein Zugangsschlüssel
longnumber salt; //die nicht geheime salt longnumber
bool S_FIL=true; //:"secure files"
bool is_armed=false; //entsichert?
unsigned long lastarmed; //letzte entsicherung
unsigned long armed_secs=15*60;  //wielange scharf -> 15 minutes
bool to_quit=false;   // flag for exiting
wxString sec_path=_("x_secrets"); // path to secrets file
wxString doc_path;  // default path to documents to sign and verify
wxString cry_path;  // default path to elliptic ciphers
wxString cur_doc_path;  //current path to signature folder
wxString cur_cry_path;  //current path to ciphers folder
wxString salt_ini;  // salt initializer
wxString kytray=_("key_tray/");  // is what it says
int def_cip = -1;
int def_hash = -1;
bool loc_inst=true;  //local installation with secrets
int ss_klen=64;   //stretch and salt keylength in byte
wxString def_pubkey;  //default public key id
wxString def_privkey;  //default private key id key
bool randwritten=false;
/********************/
/***** elliptic globals ****/
ellipse gdom,stretch_ell;
int stretch=1;
el_priv elky(42,&gdom,_("42"),_("42"));
el_pub el_pk;
el_pub public_master;
rpool zuf;
el_list e_ls;


/******************************/
bool isauthorized(wxString fnam);
//checks authorization
void set_public_master();
//does what it says

/****************************************/

//helper functions
enum wxbuildinfoformat {
    short_f, long_f };

wxString wxbuildinfo(wxbuildinfoformat format)
{
    wxString wxbuild(wxVERSION_STRING);

    if (format == long_f )
    {
#if defined(__WXMSW__)
        wxbuild << _T("-Windows");
#elif defined(__UNIX__)
        wxbuild << _T("-Linux");
#endif

#if wxUSE_UNICODE
        wxbuild << _T("-Unicode build");
#else
        wxbuild << _T("-ANSI build");
#endif // wxUSE_UNICODE
    }

    return wxbuild;
}
/*********************  further helper functions  *********************/
bool recode_all(longnumber *newky, longnumber *oldky)
{
    int rc,c2,fl1;
    FILE *okf, *nkf;
    longnumber d;
    char bff1[802],bff2[802],bff3[802],bff4[3202];
    wxString hlp;
    bool goodmac;


    if(!S_FIL) return true;

    if(!unlockinplace(sec_path + _("/ell_knamfile.knf"),oldky))
    {
        throwout(_("error unlocking ell_knamfile,knf_c3\ngeheime Dateien muessen alle vorhanden sein\nBearbeitung verweigert"));
        return false;
    }
    if(!lockinplace(sec_path + _("/ell_knamfile.knf"),newky)) throwout(_("error locking ell_knamfile"));

    if(!unlockinplace(sec_path + _("/ell_Keyfile.kyf"),oldky)) throwout(_("error unlocking ell_Keyfile"));
    //recode all private keys
       //rename original
    wxCopyFile(sec_path + _("/ell_Keyfile.kyf"), sec_path + _("/ell_Keyfile.kyf_o"));
    //open original and new one
    okf=fopen((const char*)(sec_path + _("/ell_Keyfile.kyf_o")).mb_str(wxConvLocal), "r");
    nkf=fopen((const char*)(sec_path + _("/ell_Keyfile.kyf")).mb_str(wxConvLocal), "w");
    //transfer and recode loop
    rc=0;
    do
    {
        c2=fscanf(okf, " id: %200s Name: %200s DomainName: %200s d: %400s ",bff1,bff2,bff3,bff4);
        if(c2==4)
        {
            hlp=wxString::FromUTF8(bff4);
            if( !(d.storhex(&hlp))){throwout(_("error reading d in recode Keyfile"));}
            d.lonu_unlock(oldky);
            d.lonu_lock(newky);
            d.writehex(&hlp);
            fprintf(nkf," id: %s Name: %s DomainName: %s d: %s \n",bff1,bff2,bff3,(const char*)hlp.mb_str(wxConvUTF8));
            rc++;
        }
        else if(rc==0) throwout(_("konnte keinen privaten Schluessel recodieren"));
              else if((rc>0)&&(c2>0)) throwout(_("Fehler bei der Recodierung des privaten Schluessels\nSchluesselinformationen wurden verloren!"));
    } while(c2==4);
    hlp.Printf(_(" %d private Schluessel recodiert"),rc);
    throwout(hlp,2);
    //close source and well and delete source
    fclose(okf);fclose(nkf);
    wxRemoveFile(sec_path + _("/ell_Keyfile.kyf_o"));
    //lock new keyfile
    if(!lockinplace(sec_path + _("/ell_Keyfile.kyf"),newky)) throwout(_("error locking ell_Keyfile"));

    if(!unlockinplace(sec_path + _("/e_ell_knamfile.knf"),oldky)) throwout(_("error unlocking e_ell_knamfile"));
    if(!lockinplace(sec_path + _("/e_ell_knamfile.knf"),newky)) throwout(_("error locking e_ell_knamfile"));

    if(!unlockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),oldky,0,false)) throwout(_("error unlocking e_ell_Keyfile"));
    if(!lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),newky)) throwout(_("error locking e_ell_Keyfile"));
    // now check macs

    if(!wxFileExists(sec_path + _("/ellipse_list.els")))
       {
           throwout(_("Ellipse list not found."),3);
       }
     else
       {
           //first check for accurate MAC

           wxString ellst;
           ellst=sec_path + _("/ellipse_list.els");
           goodmac=check_mac(oldky, ellst, ellst + _(".mac"),true);
           if(!goodmac)
           {
               if(isauthorized(ellst)) goodmac=true;
           }
           if(goodmac) make_mac_file(newky,&ellst,_("sha4"),_("Fleas_l3")) ;
           else
           {
                dom_mac dialog(NULL);
                fl1=dialog.ShowModal();
                switch(fl1)
                {
                    case 0:
                      //load skeleton
                      e_ls.empty_list();
                      e_ls.add_ellps(&gdom);
                      e_ls.add_ellps(&stretch_ell);
                      break;

                    case 1:
                      //check all
                      throwout(_("(noch) nicht implementiert"),2);
                      break;

                    case 2:
                      //accept
                      make_mac_file(newky,&ellst,_("sha4"),_("Fleas_l3"));
                      break;

                    default:
                      e_ls.empty_list();
                      e_ls.add_ellps(&gdom);
                      e_ls.add_ellps(&stretch_ell);
                }
           }
       }

    return true;
}

/**********************************************************************/
bool makesecrets()
{
    if(!S_FIL)
    {
        //restore empty files if necessary
        if( !wxFileExists(sec_path + _("/ell_knamfile.knf")) || !wxFileExists(sec_path + _("/ell_Keyfile.kyf"))   )
        {
            wxFile fil(sec_path + _("/ell_knamfile.knf"),wxFile::write);
            fil.Write(_("  "));
            fil.Close();
            wxFile fil1(sec_path + _("/ell_Keyfile.kyf"),wxFile::write);
            fil1.Write(_("  "));
            fil1.Close();
            throwout(_("resetted and blanked private keys"),3);
        }
        if( !wxFileExists(sec_path + _("/e_ell_knamfile.knf")) || !wxFileExists(sec_path + _("/e_ell_Keyfile.kyf"))   )
        {
            wxFile fil2(sec_path + _("/e_ell_knamfile.knf"),wxFile::write);
            fil2.Write(_("  "));
            fil2.Close();
            wxFile fil3(sec_path + _("/e_ell_Keyfile.kyf"),wxFile::write);
            fil3.Write(_("  "));
            fil3.Close();
            throwout(_("private Schluesselinfo zurueckgesetzt und geleert"),3);
        }
    }
    else
    {
      if(S_FIL)
      {
        //restore empty files if necessary
        if( !wxFileExists(sec_path + _("/ell_knamfile.knf_c3")) || !wxFileExists(sec_path + _("/ell_Keyfile.kyf_c3"))   )
        {
            wxFile fil4(sec_path + _("/ell_knamfile.knf"),wxFile::write);
            fil4.Write(_("  "));
            fil4.Close();
            if(!lockinplace(sec_path + _("/ell_knamfile.knf"),&zugang)) throwout(_("error locking ell_knamfile"));

            wxFile fil5(sec_path + _("/ell_Keyfile.kyf"),wxFile::write);
            fil5.Write(_("  "));
            fil5.Close();
            if(!lockinplace(sec_path + _("/ell_Keyfile.kyf"),&zugang)) throwout(_("error locking ell_Keyfile"));
            throwout(_("resetted and blanked private keys"),3);
        }
        if( !wxFileExists(sec_path + _("/e_ell_knamfile.knf_c3")) || !wxFileExists(sec_path + _("/e_ell_Keyfile.kyf_c3"))   )
        {
            wxFile fil6(sec_path + _("/e_ell_knamfile.knf"),wxFile::write);
            fil6.Write(_("  "));
            fil6.Close();
            if(!lockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang)) throwout(_("error locking e_ell_knamfile"));

            wxFile fil7(sec_path + _("/e_ell_Keyfile.kyf"),wxFile::write);
            fil7.Write(_("  "));
            fil7.Close();
            if(!lockinplace(sec_path + _("/e_ell_Keyfile.kyf"),&zugang)) throwout(_("error locking e_ell_Keyfile"));
            throwout(_("private Schluesselinfo zurueckgesetzt und geleert"),3);
        }
      }
    }
    return true;
}
/*************************************************************/
/**********************************************************************/

//(*IdInit(clean_pointersFrame)
const long clean_pointersFrame::ID_STATICBITMAP2 = wxNewId();
const long clean_pointersFrame::idMenuQuit = wxNewId();
const long clean_pointersFrame::ID_MENUITEM17 = wxNewId();
const long clean_pointersFrame::SETTNGS_ID = wxNewId();
const long clean_pointersFrame::seedrangen = wxNewId();
const long clean_pointersFrame::EL_SIGN = wxNewId();
const long clean_pointersFrame::EL_VERIFY = wxNewId();
const long clean_pointersFrame::ElEnc = wxNewId();
const long clean_pointersFrame::ElDec = wxNewId();
const long clean_pointersFrame::ID_MENUITEM2 = wxNewId();
const long clean_pointersFrame::ID_MAKETIMESTAP = wxNewId();
const long clean_pointersFrame::ID_VERFY_TIMESTAMP = wxNewId();
const long clean_pointersFrame::E_OPER = wxNewId();
const long clean_pointersFrame::savpriv = wxNewId();
const long clean_pointersFrame::dprivKey = wxNewId();
const long clean_pointersFrame::dpk = wxNewId();
const long clean_pointersFrame::LD_EX_PUB = wxNewId();
const long clean_pointersFrame::ELL_KYS = wxNewId();
const long clean_pointersFrame::ID_MENUITEM8 = wxNewId();
const long clean_pointersFrame::ID_MENUITEM6 = wxNewId();
const long clean_pointersFrame::vdpars = wxNewId();
const long clean_pointersFrame::DOM_ID = wxNewId();
const long clean_pointersFrame::ID_MENUITEM5 = wxNewId();
const long clean_pointersFrame::GPG_SIGN = wxNewId();
const long clean_pointersFrame::GPG_VERIFY = wxNewId();
const long clean_pointersFrame::GPG_ENCRYPT = wxNewId();
const long clean_pointersFrame::GPG_DECRYPT = wxNewId();
const long clean_pointersFrame::GPG_PUB = wxNewId();
const long clean_pointersFrame::GPG_PRIV = wxNewId();
const long clean_pointersFrame::ID_MENUITEM7 = wxNewId();
const long clean_pointersFrame::ID_MENUITEM3 = wxNewId();
const long clean_pointersFrame::ID_MENUITEM4 = wxNewId();
const long clean_pointersFrame::idMenuAbout = wxNewId();
const long clean_pointersFrame::ID_STATUSBAR1 = wxNewId();
//*)

BEGIN_EVENT_TABLE(clean_pointersFrame,wxFrame)
    //(*EventTable(clean_pointersFrame)
    //*)
END_EVENT_TABLE()

clean_pointersFrame::clean_pointersFrame(wxWindow* parent,wxWindowID id)
{
    int fl1=0,retval=0,rn,newdir,i;
    unsigned long filpos;
    FILE *setfp,*cf;
    char buff[1004];
    bool rp_res=true, no_tray=false,goodmac=false,sec_fail=false;
    wxString loctray,locsec,hs;
    ellipse *plargell;
    //(*Initialize(clean_pointersFrame)
    wxMenuItem* MenuItem2;
    wxMenuItem* MenuItem1;
    wxMenuItem* MenuItem11;
    wxMenu* Menu1;
    wxMenuBar* MenuBar1;
    wxMenu* Menu2;

    Create(parent, id, _("Crypto_fleas_Full"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_FRAME_STYLE, _T("id"));
    SetClientSize(wxSize(532,323));
    SetBackgroundColour(wxColour(209,187,245));
    wxFont thisFont(9,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
    SetFont(thisFont);
    {
    	wxIcon FrameIcon;
    	FrameIcon.CopyFromBitmap(wxBitmap(wxImage(_T("./aca_sig_icon.png"))));
    	SetIcon(FrameIcon);
    }
    StaticBitmap2 = new wxStaticBitmap(this, ID_STATICBITMAP2, wxBitmap(wxImage(_T("./elliptic_m5_p4_360e_a.png")).Rescale(wxSize(536,328).GetWidth(),wxSize(536,328).GetHeight())), wxPoint(0,0), wxSize(536,328), wxSIMPLE_BORDER, _T("ID_STATICBITMAP2"));
    MenuBar1 = new wxMenuBar();
    Menu1 = new wxMenu();
    MenuItem1 = new wxMenuItem(Menu1, idMenuQuit, _("Ausloggen und Schliessen\tAlt-F4"), _("Schliesst die Anwendung."), wxITEM_NORMAL);
    Menu1->Append(MenuItem1);
    MenuItem48 = new wxMenuItem(Menu1, ID_MENUITEM17, _("Passphrase aendern"), _("Erstellen einer neuen Passphrase oder Salt."), wxITEM_NORMAL);
    Menu1->Append(MenuItem48);
    MenuItem8 = new wxMenuItem(Menu1, SETTNGS_ID, _("Einstellungen"), _("Bietet die Moeglichkeit vorgegebene Einstellungen zu aendern."), wxITEM_NORMAL);
    Menu1->Append(MenuItem8);
    MenuItem22 = new wxMenuItem(Menu1, seedrangen, _("Startwert fuer RNG regenerieren"), _("Manuelle Neuerstellung des Pseudozufallszahlengenerators"), wxITEM_NORMAL);
    Menu1->Append(MenuItem22);
    MenuBar1->Append(Menu1, _("&Datei"));
    Menu9 = new wxMenu();
    MenuItem44 = new wxMenu();
    MenuItem54 = new wxMenuItem(MenuItem44, EL_SIGN, _("ECDSA_Signieren"), wxEmptyString, wxITEM_NORMAL);
    MenuItem44->Append(MenuItem54);
    MenuItem55 = new wxMenuItem(MenuItem44, EL_VERIFY, _("Signatur_Pruefen"), wxEmptyString, wxITEM_NORMAL);
    MenuItem44->Append(MenuItem55);
    MenuItem4 = new wxMenuItem(MenuItem44, ElEnc, _("ECC_Verschluesseln"), wxEmptyString, wxITEM_NORMAL);
    MenuItem44->Append(MenuItem4);
    MenuItem5 = new wxMenuItem(MenuItem44, ElDec, _("ECC_Entschluesseln"), wxEmptyString, wxITEM_NORMAL);
    MenuItem44->Append(MenuItem5);
    MenuItem9 = new wxMenuItem(MenuItem44, ID_MENUITEM2, _("Signieren + Verschluesseln"), wxEmptyString, wxITEM_NORMAL);
    MenuItem44->Append(MenuItem9);
    MenuItem10 = new wxMenuItem(MenuItem44, ID_MAKETIMESTAP, _("Zeitstempel Erstellen"), wxEmptyString, wxITEM_NORMAL);
    MenuItem44->Append(MenuItem10);
    MenuItem11 = new wxMenuItem(MenuItem44, ID_VERFY_TIMESTAMP, _("Zeitstempel Pruefen"), wxEmptyString, wxITEM_NORMAL);
    MenuItem44->Append(MenuItem11);
    Menu9->Append(E_OPER, _("crypto_Funktionen"), MenuItem44, wxEmptyString);
    MenuItem43 = new wxMenu();
    MenuItem57 = new wxMenuItem(MenuItem43, savpriv, _("Erstellen/Laden/Sichern Private Key"), _("Erstellen, Laden oder Sichern von ECC Schluesseln."), wxITEM_NORMAL);
    MenuItem43->Append(MenuItem57);
    MenuItem47 = new wxMenuItem(MenuItem43, dprivKey, _("Loeschen/Importieren Private Key"), wxEmptyString, wxITEM_NORMAL);
    MenuItem43->Append(MenuItem47);
    MenuItem46 = new wxMenuItem(MenuItem43, dpk, _("Public Key Liste bearbeiten"), wxEmptyString, wxITEM_NORMAL);
    MenuItem43->Append(MenuItem46);
    MenuItem51 = new wxMenuItem(MenuItem43, LD_EX_PUB, _("Laden/Sichern Public Key"), _("Auswaehlen und bearbeiten von ECC Schluesseln."), wxITEM_NORMAL);
    MenuItem43->Append(MenuItem51);
    Menu9->Append(ELL_KYS, _("ellip_keys"), MenuItem43, wxEmptyString);
    MenuItem42 = new wxMenu();
    MenuItem24 = new wxMenuItem(MenuItem42, ID_MENUITEM8, _("Domain Dialog"), _("Erweiterte Domain Bearbeitung."), wxITEM_NORMAL);
    MenuItem42->Append(MenuItem24);
    MenuItem19 = new wxMenuItem(MenuItem42, ID_MENUITEM6, _("Domain Sicherheit pruefen"), _("Druchfueren von Sicherheitsueberpruefungen der vorgegebenen Domain."), wxITEM_NORMAL);
    MenuItem42->Append(MenuItem19);
    MenuItem59 = new wxMenuItem(MenuItem42, vdpars, _("Default-Parameter anzeigen"), _("Zeigt die Parameter der Elliptische Kurve an."), wxITEM_NORMAL);
    MenuItem42->Append(MenuItem59);
    Menu9->Append(DOM_ID, _("ellip_domain"), MenuItem42, wxEmptyString);
    MenuBar1->Append(Menu9, _("ECC-Krypto"));
    Menu4 = new wxMenu();
    MenuItem18 = new wxMenuItem(Menu4, ID_MENUITEM5, _("Version auswaehlen"), wxEmptyString, wxITEM_NORMAL);
    Menu4->Append(MenuItem18);
    MenuItem16 = new wxMenuItem(Menu4, GPG_SIGN, _("GPG signieren"), wxEmptyString, wxITEM_NORMAL);
    Menu4->Append(MenuItem16);
    MenuItem17 = new wxMenuItem(Menu4, GPG_VERIFY, _("GPG pruefen"), wxEmptyString, wxITEM_NORMAL);
    Menu4->Append(MenuItem17);
    MenuItem20 = new wxMenuItem(Menu4, GPG_ENCRYPT, _("GPG verschluesseln"), wxEmptyString, wxITEM_NORMAL);
    Menu4->Append(MenuItem20);
    MenuItem21 = new wxMenuItem(Menu4, GPG_DECRYPT, _("GPG entschluesseln"), wxEmptyString, wxITEM_NORMAL);
    Menu4->Append(MenuItem21);
    MenuItem14 = new wxMenuItem(Menu4, GPG_PUB, _("PubKeys verwalten"), wxEmptyString, wxITEM_NORMAL);
    Menu4->Append(MenuItem14);
    MenuItem15 = new wxMenuItem(Menu4, GPG_PRIV, _("Privkeys verwalten"), wxEmptyString, wxITEM_NORMAL);
    Menu4->Append(MenuItem15);
    MenuBar1->Append(Menu4, _("GnuPG einbeziehen"));
    Menu3 = new wxMenu();
    MenuItem23 = new wxMenuItem(Menu3, ID_MENUITEM7, _("Passwort Verschluesselung"), _("Sicherstes verfuegbares symmetrisches Kryptosystem!"), wxITEM_NORMAL);
    Menu3->Append(MenuItem23);
    MenuItem12 = new wxMenuItem(Menu3, ID_MENUITEM3, _("Hash einer Datei erzeugen"), _("Erzeugt den Hash-Wert und gibt diesen als Datei aus."), wxITEM_NORMAL);
    Menu3->Append(MenuItem12);
    MenuItem13 = new wxMenuItem(Menu3, ID_MENUITEM4, _("Primzahl erstellen"), _("In case you need large Primes you can use this one :-)"), wxITEM_NORMAL);
    Menu3->Append(MenuItem13);
    MenuBar1->Append(Menu3, _("Extras"));
    Menu2 = new wxMenu();
    MenuItem2 = new wxMenuItem(Menu2, idMenuAbout, _("Info\tF1"), _("Gibt Informationen ueber diese Anwendung"), wxITEM_NORMAL);
    Menu2->Append(MenuItem2);
    MenuBar1->Append(Menu2, _("Hilfe"));
    SetMenuBar(MenuBar1);
    StatusBar1 = new wxStatusBar(this, ID_STATUSBAR1, 0, _T("ID_STATUSBAR1"));
    int __wxStatusBarWidths_1[1] = { -1 };
    int __wxStatusBarStyles_1[1] = { wxSB_NORMAL };
    StatusBar1->SetFieldsCount(1,__wxStatusBarWidths_1);
    StatusBar1->SetStatusStyles(1,__wxStatusBarStyles_1);
    SetStatusBar(StatusBar1);

    Connect(idMenuQuit,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&clean_pointersFrame::OnQuit);
    Connect(ID_MENUITEM17,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&clean_pointersFrame::OnChangPW);
    Connect(SETTNGS_ID,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&clean_pointersFrame::OnSettings);
    Connect(seedrangen,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&clean_pointersFrame::OnRndSeed);
    Connect(EL_SIGN,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&clean_pointersFrame::OnSignElliptic);
    Connect(EL_VERIFY,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&clean_pointersFrame::OnVerifyElliptic);
    Connect(ElEnc,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&clean_pointersFrame::OnEllFileEncipher);
    Connect(ElDec,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&clean_pointersFrame::OnEllFileDecipher);
    Connect(ID_MENUITEM2,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&clean_pointersFrame::On_sig_enciph);
    Connect(ID_MAKETIMESTAP,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&clean_pointersFrame::OnMakeTimestamp);
    Connect(ID_VERFY_TIMESTAMP,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&clean_pointersFrame::OnVerifyTimestamp);
    Connect(savpriv,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&clean_pointersFrame::OnSavePrivateEllipKey);
    Connect(dprivKey,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&clean_pointersFrame::OnDelPrivKey);
    Connect(dpk,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&clean_pointersFrame::OnDelPubKey);
    Connect(LD_EX_PUB,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&clean_pointersFrame::OnEllipPublic);
    Connect(ID_MENUITEM8,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&clean_pointersFrame::OnDomainDlg);
    Connect(ID_MENUITEM6,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&clean_pointersFrame::OnDomSafety);
    Connect(vdpars,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&clean_pointersFrame::OnViewDomPars);
    Connect(ID_MENUITEM5,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&clean_pointersFrame::OnGnupgSelect);
    Connect(GPG_SIGN,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&clean_pointersFrame::gpg_sign_doc);
    Connect(GPG_VERIFY,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&clean_pointersFrame::gpg_verify_sig);
    Connect(GPG_ENCRYPT,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&clean_pointersFrame::OnGPG_encrypt);
    Connect(GPG_DECRYPT,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&clean_pointersFrame::OnGPG_decrypt);
    Connect(GPG_PUB,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&clean_pointersFrame::gpg_pub_manage);
    Connect(GPG_PRIV,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&clean_pointersFrame::gpg_priv_manage);
    Connect(ID_MENUITEM7,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&clean_pointersFrame::OnAdvancedSymmetric);
    Connect(ID_MENUITEM3,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&clean_pointersFrame::MakeHash);
    Connect(ID_MENUITEM4,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&clean_pointersFrame::OnMakePrimeNumber);
    Connect(idMenuAbout,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&clean_pointersFrame::OnAbout);
    //*)

    thr_wx=true;
    if(wxFileExists(_("aca_sig_icon.xpm")))
       {
           wxIcon icon(_("aca_sig_icon.xpm"));
            SetIcon(icon);
       }
    //default disable of gnupg options
    MenuItem14->Enable(false);
    MenuItem15->Enable(false);
    MenuItem16->Enable(false);
    MenuItem17->Enable(false);
    MenuItem20->Enable(false);
    MenuItem21->Enable(false);
    //check dir-structure
    wxString appdatapath;
    if(!wxFileExists(sec_path+_("/local.flg")))
    {
        //check for absolute location
        loc_inst=false;
        //throwout(_("non-subfolder data storage."));
        #if defined(__WXMSW__)
        //first check for environment
        if(wxGetEnv(_("APPDATA"),&appdatapath))
        {
            //check if directory exists
            if((!wxDirExists(appdatapath + _("/aca_sig") ))||(!wxDirExists(appdatapath + _("/aca_sig/")+sec_path )))
            {
             //if not ask whether to create dummy
             AskDialog adlg(this,_("Standard Datenverzeichnis des Programms fehlt.\nSoll eine leere Version erstellt werden?"));
             newdir=adlg.ShowModal();
             if(newdir==1)
             {
                 if(!wxFileName::Mkdir(appdatapath + _("/aca_sig/") + sec_path, wxS_IWUSR, wxPATH_MKDIR_FULL))
                 {
                    throwout(_("Fatal, konnte das x_secrets Verzeichnis nicht erzeugen ?!?\n Abbruch"),8);
                    Close();return;
                 }
                 if(!wxFileName::Mkdir(appdatapath + _("/aca_sig/") + kytray, wxS_IWUSR, wxPATH_MKDIR_FULL))
                 {
                     throwout(_("Fehler, konnte das key_tray Verzeichnis nicht erzeugen"),4);
                 }
                 //create secrets dummy
                 sec_path=appdatapath + _("/aca_sig/") + sec_path;
                 kytray=appdatapath + _("/aca_sig/") + kytray;
                 makesecrets();
             }
             else{ throwout(_("Nun denn.. \ndann will ich mal woanders suchen..."),2);}
            }
               //throwout(_("helper files lie in: ")+appdatapath+_("\\aca_sig\\"),10);
               hs=appdatapath + _("/aca_sig/") + sec_path;
               //hs=_("c:/aca_sig/")+sec_path;
               if(!wxDirExists(hs))
                    {
                        throwout(_("Konnte x_secrets Verzeichnis nicht finden\nforsche erneut nach..."),3);
                        sec_fail=true;
                    }
                    else
                    {
                        sec_fail=false;
                        sec_path=hs;
                        //throwout(_("secrets in: ")+sec_path, 5);
                        if(wxDirExists(appdatapath + _("/aca_sig/") + kytray))
                        {
                            //kytray= _("c:/aca_sig/") +kytray;
                            kytray=appdatapath + _("/aca_sig/") + kytray;
                            //throwout(_("keytray in: ")+kytray, 5);
                        }
                        else throwout(_("kein key_tray Verzeichnis parallel zu x_secrets?!"),3);
                    }

        }
        if(sec_fail) //first attempt failed
        {
        //check for config file
            throwout(_("fehlendes secrets Verzeichnis,\nsuche an anderen Stellen..."),3);
            if(!wxFileExists(_("aca_config.txt")))
            {
                throwout(_("keine config Datei im Programmverzeichnis gefunden"));
                sec_fail=true;
            }
            //read in config file path
            else
            {
                cf=fopen("aca_config.txt","r");
                rn=fscanf(cf,"secrets: %400s",buff);
                fclose(cf);
                if(rn!=1)
                {
                    throwout(_("config Datei ist vorhanden, aber missgeformt\nLeseabbruch!"),3);
                    sec_fail=true;
                }
                else
                {
                    //convert to wxString
                    hs= wxString::FromUTF8(buff) + _("/") + sec_path;
                    //check if allrigt
                    if(!wxDirExists(hs))
                    {
                        throwout(_("config Datei lesbar, aber wertloser Inhalt"),3);
                        sec_fail=true;
                    }
                    else
                    {
                        sec_fail=false;
                        sec_path=hs;
                        //throwout(_("found hint to: ")+hs);
                        kytray= wxString::FromUTF8(buff) +_("/") + kytray;
                    }
                }//config file read ananalyzed
            } //config file present
            //if unsuccessful, try desperately further
            if(sec_fail)
            {
                if(wxDirExists(_("c:/Documents and Settings/user/Application Data/aca_sig/")+sec_path))
                {
                    sec_path = _("c:/Documents and Settings/user/Application Data/aca_sig/")+sec_path;
                    throwout(_("unterstelle x_secrets liegen in:")+ sec_path);
                    sec_fail=false;
                }
                else if(wxDirExists(_("c:/Dokumente und Einstellungen/All Users/Anwendungsdaten/aca_sig/")+sec_path))
                {
                    sec_path = _("c:/Dokumente und Einstellungen/All Users/Anwendungsdaten/aca_sig/")+sec_path;
                    throwout(_("unterstelle x_secrets liegen in:")+ sec_path);
                    sec_fail=false;
                }
                else
                {
                        throwout(_("Kann ") + sec_path + _(" mit dem x_secrets Verzeichnis nicht finden\nDu musst es manuell eingeben"),10);
                        //Ask for secrets folder
                        //select one if not found
                        if(sec_fail)
                        {
                            throwout(_("Warnung!\nstandard secrets Verzeichnis nicht gefunden"),10);
                            locsec=wxDirSelector(_("x_secrets Verzeichnis nicht gefunden, Bitte manuell lokalisieren!")); //reusing variable
                            if(locsec == _(""))       //.IsEmpty() )
                            {
                                throwout(_("Abbruch"),1);
                                Close();return;
                            }
                            else sec_path=locsec + wxFileName::GetPathTerminators();
                            if(wxFileExists(sec_path + _("e_ell_Keyfile.kyf_c3")))
                            {
                                throwout(sec_path +_("  scheint korrekt."),5);
                                sec_fail=false;
                            }
                        }
                        if(sec_fail)
                        {
                            throwout(_("Alle Versuche, das x_secrets Verzeichnis\nzu lokalisieren gescheitert\nAbbruch!"));
                            Close();return;
                        }
                }
            }//end desperate attempt to find sec_folder in windows
        }//end of alternative file readout
        #else  //if linux and not subfolder
          if(wxGetEnv(_("HOME"),&appdatapath))
          {
               hs=appdatapath + _("/.config/aca_sig/") + sec_path;
          }
          else
          {
              throwout(_("Konnte HOME env-Variable in Linux nicht finden!\nFatal, Abbruch."),10);
              Close();return;
          }

          if(wxDirExists( hs))
          {
              sec_path = hs;
          }
          else //try old location
          {
              //check for existence of ~.aca_sig
              hs=appdatapath + _("/.aca_sig/") + sec_path;
              if(wxDirExists( hs))
                {
                    sec_path = hs;
                }
              else //neither found old location
              {
               //if not ask whether to create dummy
                AskDialog adlg(this,_("Standard Datenverzeichnis des Programms fehlt.\nSoll eine leere Version erstellt werden?"));
                newdir=adlg.ShowModal();
                if(newdir==1)
                {
                 wxFileName::Mkdir( _("~/.config/"),wxS_IRUSR|wxS_IWUSR|wxS_IRGRP|wxS_IWGRP,wxPATH_MKDIR_FULL);
                 if(!wxFileName::Mkdir( _("~/.config/aca_sig/") + sec_path) ,wxS_IRUSR|wxS_IWUSR,wxPATH_MKDIR_FULL)
                 {
                     throwout(_("Fatal, konnte das x_secrets Verzeichnis nicht erzeugen ?!?\n Abbruch"),8);
                     Close();return;
                 }
                 if(!wxFileName::Mkdir( _("~/.config/aca_sig/") + kytray),wxS_IRUSR|wxS_IWUSR,wxPATH_MKDIR_FULL)
                 {
                     throwout(_("Fehler, konnte das key_tray Verzeichnis nicht erzeugen ?!?\n Abbruch"),8);
                 }

                 //create secrets dummy
                 sec_path=_("~/.config/aca_sig/") + sec_path;
                 kytray= _("~/.config/aca_sig/") + kytray;
                 makesecrets();
                }
                else{ //doesnt want to make new
                   throwout(_("Nun denn \nIch muss aufgeben...."),3);
                    throwout(_("Kann ") + sec_path + _(" Verzeichnis nicht findenr\nFatal->Abbruch"),10);
                    Close();return;
                }
            }

        } //try old location end
        #endif

    }
    else
    {
        throwout(_("Lokaler x_secrets Unterverzeichnis gefunden in: " + sec_path),2);
    }
   if( !loc_inst)             //!wxDirExists(kytray))
    {
        //throwout(_("No keytray found in: ")+kytray);
        //loc_inst=false;
        //check for absolute location
        #if defined(__WXMSW__)
          if(wxGetEnv(_("APPDATA"),&appdatapath))
          {
            if(wxDirExists(appdatapath+_("/")+kytray))
            {
              kytray = appdatapath+_("/")+kytray;
              //throwout(_("keytray found in: ")+kytray,10);
            }
          }
          else if(wxDirExists(_("c:/Documents and Settings/user/Application Data/aca_sig/")+kytray))
          {
              kytray = _("c:/Documents and Settings/user/Application Data/aca_sig/")+kytray;
          }
          else if(wxDirExists(_("c:/Dokumente und Einstellungen/All Users/Anwendungsdaten/aca_sig/")+kytray))
          {
              kytray = _("c:/Dokumente und Einstellungen/All Users/Anwendungsdaten/aca_sig/")+kytray;
          }
          else if(wxDirExists(_("c:/aca_sig/")+kytray))
          {
              kytray = _("c:/aca_sig/")+kytray;
          }
          else
          {
            throwout(_("Kann ") + kytray + _(" Verzeichnis nicht finden."),10);
            no_tray=true;
          }
        #else
          if(wxDirExists(appdatapath+ _("/.config/aca_sig/") + kytray))
          {
              kytray = appdatapath+ _("/.config/aca_sig/") + kytray;
              //throwout(_("key_tray found in:\n")+kytray,3);
          }
          else if(wxDirExists(appdatapath+ _("/.aca_sig/") + kytray))
          {
              kytray = appdatapath+ _("/.aca_sig/") + kytray;
              throwout(_("alter Platz!\nkey_tray gefunden in:\n")+kytray,3);
          }
          else
          {
            throwout(_("Kann ") + kytray + _("key_tray Verzeichnis nicht finden."),10);
            no_tray=true;
          }
        #endif
        //select one if notray
        if(no_tray)
        {
          throwout(_("Warnung!\nstandard key_tray Verzeichnis nicht gefunden"),10);
          loctray=wxDirSelector(_("key_tray Verzeichnis nicht gefunden, waehle eine Alternative!"));
          if(loctray == _(""))       //.IsEmpty() )
          {
            throwout(_("Abbruch"),1);
            Close();return;
          }
          else kytray=loctray + wxFileName::GetPathTerminators();
        }
    }


    //dann Zufallsgenerator seeden oder wiederladen
    wxString st=_("default");
    globlonu.stortext(&st);
    zugang.copynum(&globlonu);
    longnumber hln;
    //set strech domain
    stretch_ell.ellipse_setintern();
    set_public_master();
    if(zuf.isvirgin)
    {
        rp_res=zuf.delayed_init_rpool(); //zufallsgenerator initialisieren
        if(!rp_res) {Close(); return;}
    }
    if(wxFileExists(sec_path + _("/paphr_hash.flea")))//load zugangsdialog
    {
       #if defined(__WXMSW__)
            //to be filled
       #else
       // lock anything new
       //fll=mlockall(MCL_FUTURE);
       #endif
        mylogin dialog(this);
        retval=dialog.ShowModal();
        // mylogin cleans up after itself, can unlock again
       #if defined(__WXMSW__)
        fl1=VirtualLock(zugang.ad,zugang.size); //already locked in trylogin
      #else
       // unlock all stuff
       //fll=munlockall();
       // but keep zugang locked
       fl1=mlock(zugang.ad,zugang.size); //already locked in trylogin
       #endif
        if(retval!=1)
        {
            Close();
            return;
        }
    }
    else    //else decode with default-ask for zugang-encode with zugang
    {
        hatching dialog(this);
        retval=dialog.ShowModal();
        #if defined(__WXMSW__)
            fl1=VirtualLock(zugang.ad,zugang.size);
       #else
       // lock zugang
       fl1=mlock(zugang.ad,zugang.size);
       #endif

        if(retval!=1) {Close(); return;}
    }
    //if present, load settings doc_path
    if(wxFileExists(sec_path + _("/settings.txt")))
    {
       setfp=fopen((const char*)(sec_path + _("/settings.txt")).mb_str(wxConvLocal), "r");
       fl1=fscanf(setfp," docpath: %400s",buff);
       if(fl1==1)
       {
           doc_path=wxString::FromUTF8(buff);
       }
       else throwout(_("Konnte docpath Parameter nicht lesen!"),2);
       //if empty ->clear
       if(  doc_path==_("empty"))
       {
         doc_path.Empty();
         throwout(_("docpath immer noch leer"),1);
       }
       if(  (doc_path==_("cryptpath:")) )
       {
         filpos=ftell(setfp);
         filpos -= 11;
         fseek(setfp, filpos,  SEEK_SET); //set back
         doc_path.Empty();
         throwout(_("docpath info fehlt"),1);
       }
       fl1=fscanf(setfp," cryptpath: %400s",buff);
       if(fl1==1)
       {
           cry_path=wxString::FromUTF8(buff);
           if(cry_path==_("empty")) cry_path.Empty();
       }
       else throwout(_("cryptpath immer noch leer!"),1);
       fl1=fscanf(setfp," pubkey: %400s",buff);
       if(fl1==1)
       {
           def_pubkey=wxString::FromUTF8(buff);
           if(def_pubkey==_("empty")) def_pubkey.Empty();
       }
       else throwout(_("default oeffentl. Schluessel noch leer!"),1);
       fl1=fscanf(setfp," privkey: %400s",buff);
       if(fl1==1)
       {
           def_privkey=wxString::FromUTF8(buff);
           if(def_privkey==_("empty")) def_privkey.Empty();
       }
       else throwout(_("default privater Schluessel noch leer!"),1);
       //now get the favourite algorithms
       wxString hlp1;
       fl1=fscanf(setfp," def_cip: %400s",buff);
       if(fl1==1)
       {
           hlp1=wxString::FromUTF8(buff);
           if(hlp1==_("aes")) def_cip=0;
           else if(hlp1==_("threefish")) def_cip=1;
           else if(hlp1==_("flight_x")) def_cip=2;
           else if(hlp1==_("F_cnt_lb")) def_cip=3;
           else if(hlp1==_("F_cnt_lc")) def_cip=4;
           else if(hlp1==_("F_cnt_ld")) def_cip=5;
           else if(hlp1==_("Fleas_l")) def_cip=6;
           else if(hlp1==_("Fleas_lc")) def_cip=7;
           else if(hlp1==_("chimera")) def_cip=8;
           else {
            throwout(_("Warnung, konnte default Chiffre nicht setzen."),3);
            def_cip= 4;
           }
       }
       else throwout(_("default Chiffre immer noch unbestimmt!"),1);

       fl1=fscanf(setfp," def_hash: %400s",buff);
       if(fl1==1)
       {
           hlp1=wxString::FromUTF8(buff);
           if(hlp1==_("sha512")) def_hash=0;
           else if(hlp1==_("JH")) def_hash=1;
           else if(hlp1==_("skein")) def_hash=2;
           else if(hlp1==_("Fleas_b")) def_hash=3;
           else if(hlp1==_("Fleas_c")) def_hash=4;
           else if(hlp1==_("Fleas_d")) def_hash=5;
           else {
            throwout(_("Warnung, konnte default hash nicht setzen."),3);
            def_hash= 1;
           }
       }
       else throwout(_("default hash immer noch unbestimmt!"),1);

       fclose(setfp);
    }
    // set ellipselist
    set_public_master();
    if(!wxFileExists(sec_path + _("/ellipse_list.els")))
       {
           throwout(_("Domain Liste nicht gefunden."),3);
       }
     else
       {
           //first check for accurate MAC

           wxString ellst;
           ellst=sec_path + _("/ellipse_list.els");
           goodmac=check_mac(&zugang, ellst, ellst + _(".mac"),true); //true means "stumm"
           if(goodmac) e_ls.addfromfile(ellst);
           else
           {
               //first check if valid maintainer key is present
               if(isauthorized(ellst)) fl1=2;
               else
               {
                dom_mac dialog(this);
                fl1=dialog.ShowModal();
               }
                switch(fl1)
                {
                    case 0:
                      //load skeleton
                      e_ls.add_ellps(&gdom);
                      e_ls.add_ellps(&stretch_ell);
                      //load 1024 bit domain also
                      plargell=new ellipse();
                      plargell->ellipse_set_stretch1024();
                      e_ls.add_ellps(plargell);
                      delete plargell;
                      break;

                    case 1:
                      //check all
                      throwout(_("noch nicht implementiert,\nwuerde zu lang brauchen.\nwird so akzeptiert, ueberpruefe bitte im einzelnen manuell!"));
                      //break;

                    case 2:
                      //accept
                      make_mac_file(&zugang,&ellst,_("sha4"),_("Fleas_l3"));
                      e_ls.addfromfile(ellst);
                      break;

                    default:
                      e_ls.add_ellps(&gdom);
                      e_ls.add_ellps(&stretch_ell);
                }
           }
       }
}
/******************************************************/
clean_pointersFrame::~clean_pointersFrame()
{
    if(!zuf.isvirgin)
    {
        zuf.stor_rand_class(sec_path+_("/randpool.rnpl"));

    }
}
/************************************************************************/
void clean_pointersFrame::OnQuit(wxCommandEvent& event)
{
    FILE *setfp;
    wxString algo;

    setfp=fopen((const char*)(sec_path + _("/settings.txt")).mb_str(wxConvLocal), "w");
    fprintf(setfp," docpath: ");
    if(doc_path.IsEmpty())  doc_path=_("empty");
    fprintf(setfp,"%s \n", (const char*)(doc_path.mb_str(wxConvLocal)));
    fprintf(setfp,"\n cryptpath: ");
    if(cry_path.IsEmpty()) cry_path=_("empty");
    fprintf(setfp,"%s \n", (const char*)(cry_path.mb_str(wxConvLocal)));
    fprintf(setfp,"\n pubkey: ");
    if(def_pubkey.IsEmpty()) def_pubkey=_("empty");
    fprintf(setfp,"%s \n", (const char*)(def_pubkey.mb_str(wxConvLocal)));
    fprintf(setfp,"\n privkey: ");
    if(def_privkey.IsEmpty()) def_privkey=_("empty");
    fprintf(setfp,"%s \n", (const char*)(def_privkey.mb_str(wxConvLocal)));
    //store default algos
    if((def_cip<0)||(def_cip>8)) def_cip=4;
    if(def_cip==0) algo=_("aes");
    else if(def_cip==1) algo=_("threefish");
    else if(def_cip==2) algo=_("flight_x");
    else if(def_cip==3) algo=_("F_cnt_lb");
    else if(def_cip==4) algo=_("F_cnt_lc");
    else if(def_cip==5) algo=_("F_cnt_ld");
    else if(def_cip==6) algo=_("Fleas_l");
    else if(def_cip==7) algo=_("Fleas_lc");
    else if(def_cip==8) algo=_("chimera");
    fprintf(setfp,"\n def_cip: ");
    fprintf(setfp,"%s \n", (const char*)(algo.mb_str(wxConvLocal)));

    if((def_hash<0)||(def_hash>5)) def_hash=3;
    if(def_hash==0) algo=_("sha512");
    else if(def_hash==1) algo=_("JH");
    else if(def_hash==2) algo=_("skein");
    else if(def_hash==3) algo=_("Fleas_b");
    else if(def_hash==4) algo=_("Fleas_c");
    else if(def_hash==5) algo=_("Fleas_d");
    fprintf(setfp,"\n def_hash: ");
    fprintf(setfp,"%s \n", (const char*)(algo.mb_str(wxConvLocal)));

    fclose(setfp);
    //writeout elpsfile
    //e_ls.write_list2file(sec_path + _("/ellipse_list1_out.els"));

    Close();
}
/********************************************************************************/
void clean_pointersFrame::OnAbout(wxCommandEvent& event)
{

    wxString msg = wxbuildinfo(long_f);
    msg += _("\nAcademic Signature b55 \nSignierer und Verifizierere\n und asymmetrische Verschluesselung\n Version \"Trent\" mit Timestamping\ngeschrieben von Michael Anders, Januar 2018\n build_29_08_18, b55_ger");
    wxMessageBox(msg, _("Willkommen bei..."));

}

/**********************************************************************************************/
void clean_pointersFrame::OnRndSeed(wxCommandEvent& event)
{

    Seedial dialog(this);
    dialog.ShowModal();

}

/*****************************************************/
/*****************************************************/
/***************************************************************************
void clean_pointersFrame::OnLoadDomain(wxCommandEvent& event)
{
    wxString fnam,message;
    char fnambuff[1202];
    ellipse ldom;

    if(!checkarm()){Close();}

    fnam = wxFileSelector(_("Waehle eine Domaindatei zum Laden"),kytray, _(""),_("els|*"),_("dom_files(*.els)|*.els|alle_Dateien(*.*)|*"));
    if(fnam.empty()) return;
    if(fnam.Len()>600){throwout(_("zu langer Dateiname\nAbbruch!"),3); return;}
    strcpy( fnambuff, (const char*)fnam.mb_str(wxConvLocal) );// schreibt den Filenamen in fnambuff rein
    // auf notexist testen
    if(! wxFile::Exists(fnam))
    {
        throwout(_("Fehler, Datei existiert nicht!\n Tue Nichts"),4);
        return;
    }
    // domain holen
    ldom.copyell(&gdom);
    if(!gdom.el_from_file(fnambuff))
    {
        gdom.copyell(&ldom);
        throwout(_("Laden der neuen Domain gescheitert,\nletzte wird wiederhergestellt"));
        return;
    }
    //export_ellips(&gdom); throwout(_("Translated ellips-file on the fly ;-)"),2);
    //Ausgabe der size
    message.Printf(_(" hat Gruppenordnung \n von %i bytes"), (int) gdom.q.size);
    message= _("Domain: ") + gdom.name +message;
    //kleiner Test
    if(gdom.d0.is_in_ellipse(&(gdom))) message += _("\n einfacher Test: d0 ist in elliptischer Kurve(Domain)!");
    else  message += _("\n einfacher Test gescheitert: d0 ist NOT! in der Domain!\n Abbruch empfohlen!");
    throwout(message);
    //include in ellipse file
    if(!e_ls.isinlist(gdom.name))
    {
        e_ls.add_ellps(&gdom);
        //write and mac list anew
        wxString elfllst;
        elfllst=sec_path + _("/ellipse_list.els");
        e_ls.write_list2file(elfllst);
        make_mac_file(&zugang,&elfllst,_("sha4"),_("Fleas_l3"));
        throwout(_("Neue Domain wurde der globalen Liste hinzugefuegt.\neine Sicherheitspruefung wird dennoch noch empfohlen!"),3);
    }
    else throwout(_("Domain Name ist schon in der globalen Liste\nEintrag wird NICHT hinzugefuegt!"),3);
    return;
}
***************************************************************************/

void clean_pointersFrame::OnViewDomPars(wxCommandEvent& event)
{
    wxString message,scratch;

    //message += _("The current Domain Parameters are : \n ");
    scratch= _("Domain Name:   ") + gdom.name +_("\n");
    message+=scratch;
    gdom.a.writehex(&scratch);
    scratch = _("CurvePar A: ") + scratch +_("\n");
    message+=scratch;
    gdom.b.writehex(&scratch);
    scratch = _("CurvePar B: ") + scratch +_("\n");
    message+=scratch;

    gdom.p.writehex(&scratch);
    scratch = _("Prime Module p: ") + scratch +_("\n");
    message+=scratch;

    gdom.q.writehex(&scratch);
    scratch = _("Galois Group order q: ") + scratch +_("\n");
    message+=scratch;

    gdom.d0.x.writehex(&scratch);
    scratch = _("Start with primitive Point X0: ") + scratch +_("\n");
    message+=scratch;
    gdom.d0.y.writehex(&scratch);
    scratch = _("and Y0: ") + scratch +_("\n");
    message+=scratch;
    wxMessageBox(message, _("Die aktuellen default Domain Parameter sind:"));
}
/**********************************************************************************/
void clean_pointersFrame::OnSavePrivateEllipKey(wxCommandEvent& event)
{
            // neuer Dialog
    if(!checkarm()){Close();}
    ellip_ky_sav dialog(this);
    dialog.ShowModal();
    // ende Dialog
    return;
}
/**********************************************************************************/
void clean_pointersFrame::OnSignElliptic(wxCommandEvent& event)
{
    int res;
    if(!checkarm()){Close();}
    sign_ellip dialog(this);
    res=dialog.ShowModal();
    if(res==0) Close();
    return;
}
/**********************************************************************************/
void clean_pointersFrame::OnVerifyElliptic(wxCommandEvent& event)
{
    int res;

    if(!checkarm()){Close();}
    elliptic_verify dialog(this);
    res=dialog.ShowModal();
    if( to_quit) Close();
    return;
}
/**********************************************************************************/
void clean_pointersFrame::OnEllipPublic(wxCommandEvent& event)
{
    int res;

    if(!checkarm()){Close();}
    LoadSave_ell_pub dialog(this);
    res=dialog.ShowModal();
    if (to_quit) Close();
    return;
}
/************************************************************************/

void clean_pointersFrame::OnDelPubKey(wxCommandEvent& event)
{
    int flag=1;

    if(!checkarm()){Close();}


    while(flag ==1)
    {
        DeletePubEllky dialog(this);
        flag=dialog.ShowModal();
        if (to_quit) {Close();return;}
    }
    return;
}
/***********************************************************************/
void clean_pointersFrame::OnDelPrivKey(wxCommandEvent& event)
{
    int flag=1;
    if(!checkarm()){Close();}


    while(flag ==1)
    {
        Del_imp_priv dialog(this);
        flag=dialog.ShowModal();
        if (to_quit) {Close();}
    }
    return;
}
/***********************************************************************/

void clean_pointersFrame::OnChangPW(wxCommandEvent& event)
{
    int flag;

    if(!checkarm()){Close();}
    changPasphr dialog(this);
    flag= dialog.ShowModal();
    if(flag==1) throwout(_("Passphrase Wechsel erfolgreich!"),2);
}
/**********************************************************************/

void clean_pointersFrame::OnRepair(wxCommandEvent& event)
{
    if(!checkarm()){Close();}
    if(!S_FIL)
    {
        //restore empty files if necessary
        if( !wxFileExists(sec_path + _("/ell_knamfile.knf")) || !wxFileExists(sec_path + _("/ell_Keyfile.kyf"))   )
        {
            wxFile fil(sec_path + _("/ell_knamfile.knf"),wxFile::write);
            fil.Write(_("  "));
            fil.Close();
            wxFile fil1(sec_path + _("/ell_Keyfile.kyf"),wxFile::write);
            fil1.Write(_("  "));
            fil1.Close();
            throwout(_("Liste der oefftl. Schluessel wurde\ngeleert und zurueckgesetzt"),3);
        }
        if( !wxFileExists(sec_path + _("/e_ell_knamfile.knf")) || !wxFileExists(sec_path + _("/e_ell_Keyfile.kyf"))   )
        {
            wxFile fil2(sec_path + _("/e_ell_knamfile.knf"),wxFile::write);
            fil2.Write(_("  "));
            fil2.Close();
            wxFile fil3(sec_path + _("/e_ell_Keyfile.kyf"),wxFile::write);
            fil3.Write(_("  "));
            fil3.Close();
            throwout(_("Liste der oefftl. Schluessel wurde\ngeleert und zurueckgesetzt"),3);
        }
    }
    else
    {
      if(S_FIL)
      {
        //restore empty files if necessary
        if( !wxFileExists(sec_path + _("/ell_knamfile.knf_c3")) || !wxFileExists(sec_path + _("/ell_Keyfile.kyf_c3"))   )
        {
            wxFile fil4(sec_path + _("/ell_knamfile.knf"),wxFile::write);
            fil4.Write(_("  "));
            fil4.Close();
            if(!lockinplace(sec_path + _("/ell_knamfile.knf"),&zugang)) throwout(_("error locking ell_knamfile"));

            wxFile fil5(sec_path + _("/ell_Keyfile.kyf"),wxFile::write);
            fil5.Write(_("  "));
            fil5.Close();
            if(!lockinplace(sec_path + _("/ell_Keyfile.kyf"),&zugang)) throwout(_("error locking ell_Keyfile"));
            throwout(_("resetted and blanked private keys"),3);
        }
        if( !wxFileExists(sec_path + _("/e_ell_knamfile.knf_c3")) || !wxFileExists(sec_path + _("/e_ell_Keyfile.kyf_c3"))   )
        {
            wxFile fil6(sec_path + _("/e_ell_knamfile.knf"),wxFile::write);
            fil6.Write(_("  "));
            fil6.Close();
            if(!lockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang)) throwout(_("error locking e_ell_knamfile"));

            wxFile fil7(sec_path + _("/e_ell_Keyfile.kyf"),wxFile::write);
            fil7.Write(_("  "));
            fil7.Close();
            if(!lockinplace(sec_path + _("/e_ell_Keyfile.kyf"),&zugang)) throwout(_("error locking e_ell_Keyfile"));
            throwout(_("Liste der oefftl. Schluessel wurde\ngeleert und zurueckgesetzt"),3);
        }
      }
    }
    return;
}
/*************************************************************/
void clean_pointersFrame::OnEllFileEncipher(wxCommandEvent& event)
{
    if(!checkarm()){Close();}
    elliptic_encipher dialog(this);
    dialog.ShowModal();
    if (to_quit) Close();
    return;
}
/*************************************************************/
void clean_pointersFrame::OnEllFileDecipher(wxCommandEvent& event)
{
    if(!checkarm()){Close();}
    deciph_dialog dialog(this);
    dialog.ShowModal();
    if (to_quit) Close();
    return;
}

/******************************************************************/

void clean_pointersFrame::OnSettings(wxCommandEvent& event)
{
    if(!checkarm()){Close();}
    Settings dialog(this);
    dialog.ShowModal();
    if (to_quit) Close();
    return;
}
/******************************************************************/

void clean_pointersFrame::On_sig_enciph(wxCommandEvent& event)
{
    if(!checkarm()){Close();}
    enciph_n_authent dialog(this);
    dialog.ShowModal();
    if (to_quit) Close();
    return;
}
/************************************************************/

void clean_pointersFrame::OnMakeTimestamp(wxCommandEvent& event)
{
    if(!checkarm()){Close();}
    timstamp dialog(this);
    dialog.ShowModal();
    if (to_quit) Close();
    return;
}
/**************************************************************/
void clean_pointersFrame::OnVerifyTimestamp(wxCommandEvent& event)
{
    if(!checkarm()){Close();}
    time_verify dialog(this);
    dialog.ShowModal();
    if (to_quit) Close();
    return;
}
/***************************************************************/

void clean_pointersFrame::MakeHash(wxCommandEvent& event)
{
    if(!checkarm()){Close();}
    makehash dialog(this);
    dialog.ShowModal();
    if (to_quit) Close();
    return;
}
/****************************************************************/

void clean_pointersFrame::OnMakePrimeNumber(wxCommandEvent& event)
{
    if(!checkarm()){Close();}
    get_prime dialog(this);
    dialog.ShowModal();
    if (to_quit) Close();
    return;
}
/*************************************************************/
void clean_pointersFrame::OnDomSafety(wxCommandEvent& event)
{

    if(!gdom.el_selftest())
    {
        throwout(_("Domain nicht mal oberflaechlich heil!"),10);
        return;
    }
    if(!gdom.el_safety())
    {
        throwout(_("Domain erscheint valide\naber versagte im Crypto-Sicherheitstest"));
        return;
    }
    else{
    throwout(_("Domain hat alle Tests bestanden"));
    }
    return;
}
/*************************************************************/

void clean_pointersFrame::gpg_pub_manage(wxCommandEvent& event)
{
    if(!checkarm()){Close();}
    gpg_add_pub dialog(this);
    dialog.ShowModal();
    if(gpg_name == _("none"))
    {
        //disable menu entries
        MenuItem14->Enable(false);
        MenuItem15->Enable(false);
        MenuItem16->Enable(false);
        MenuItem17->Enable(false);
        MenuItem20->Enable(false);
        MenuItem21->Enable(false);
    }
    if (to_quit) Close();
    return;

}
/*************************************************************/
void clean_pointersFrame::gpg_priv_manage(wxCommandEvent& event)
{
    int retflg=13;


    if(!checkarm()){Close();}
    gpg_manag_priv dialog(this);
    retflg=dialog.ShowModal();
    if(gpg_name == _("none"))
    {
        //disable menu entries
        MenuItem14->Enable(false);
        MenuItem15->Enable(false);
        MenuItem16->Enable(false);
        MenuItem17->Enable(false);
        MenuItem20->Enable(false);
        MenuItem21->Enable(false);
    }
    if (to_quit) Close();
    return;
}
/*************************************************************/
void clean_pointersFrame::gpg_sign_doc(wxCommandEvent& event)
{
    int sel;

    if(!checkarm()){Close();}
    gnupg_sign dialog(this);
    sel=dialog.ShowModal();
    if(sel == 0)
    {
        //disable menu entries
        MenuItem14->Enable(false);
        MenuItem15->Enable(false);
        MenuItem16->Enable(false);
        MenuItem17->Enable(false);
        MenuItem20->Enable(false);
        MenuItem21->Enable(false);
    }
    if (to_quit) Close();
    return;
}
/*************************************************************/
void clean_pointersFrame::gpg_verify_sig(wxCommandEvent& event)
{
    if(!checkarm()){Close();}
    gpg_verify dialog(this);
    dialog.ShowModal();
    if(gpg_name == _("none"))
    {
        //disable menu entries
        MenuItem14->Enable(false);
        MenuItem15->Enable(false);
        MenuItem16->Enable(false);
        MenuItem17->Enable(false);
        MenuItem20->Enable(false);
        MenuItem21->Enable(false);
    }
    if (to_quit) Close();
    return;
}
/*************************************************************/
void clean_pointersFrame::OnGnupgSelect(wxCommandEvent& event)
{
    int sel;

    if(!checkarm()){Close();}
    gnupg_select dialog(this);
    sel= dialog.ShowModal();
    if(sel==10)
    {
        //disable menu entries
        MenuItem14->Enable(false);
        MenuItem15->Enable(false);
        MenuItem16->Enable(false);
        MenuItem17->Enable(false);
        MenuItem20->Enable(false);
        MenuItem21->Enable(false);

    }
    else if((sel==1)||(sel==2))
    {
        //disable menu items
        MenuItem14->Enable(true);
        MenuItem15->Enable(true);
        MenuItem16->Enable(true);
        MenuItem17->Enable(true);
        MenuItem20->Enable(true);
        MenuItem21->Enable(true);
    }
    if (to_quit) Close();
    return;
}
/**************************************************************/

void clean_pointersFrame::OnGPG_encrypt(wxCommandEvent& event)
{
    if(!checkarm()){Close();}
    gpg_enc_dialog dialog(this);
    dialog.ShowModal();
     if(gpg_name == _("none"))
    {
        //disable menu entries
        MenuItem14->Enable(false);
        MenuItem15->Enable(false);
        MenuItem16->Enable(false);
        MenuItem17->Enable(false);
        MenuItem20->Enable(false);
        MenuItem21->Enable(false);
    }
   if (to_quit) Close();
    return;
}
/**************************************************************/
void clean_pointersFrame::OnGPG_decrypt(wxCommandEvent& event)
{
    if(!checkarm()){Close();}
    gpg_dec_dialog dialog(this);
    dialog.ShowModal();
    if(gpg_name == _("none"))
    {
        //disable menu entries
        MenuItem14->Enable(false);
        MenuItem15->Enable(false);
        MenuItem16->Enable(false);
        MenuItem17->Enable(false);
        MenuItem20->Enable(false);
        MenuItem21->Enable(false);
    }
    if (to_quit) Close();
    return;
}
/**************************************************************/

void clean_pointersFrame::OnAdvancedSymmetric(wxCommandEvent& event)
{
    if(!checkarm()){Close();}
    advancd_symm dialog(this);
    dialog.ShowModal();
    if (to_quit) Close();
    return;
}
/********************************************************************/

void clean_pointersFrame::OnDomainDlg(wxCommandEvent& event)
{
    int res;
    if(!checkarm()){Close();}
    do
    {
        DomainSelector dialog(this);
        res=dialog.ShowModal();
    }while(res==-2);
    if (to_quit) Close();
    return;
}
/***********************************************************************/


/**** global helpers ******/
bool isauthorized(wxString fnam)
//checks authorization
{
    bool retval;
    int lbl;
    char buff[1602];
    FILE *sfp;
    wxString t_domnam,num,sfnam,hashnam;
    longnumber r,s;

    if(fnam.Length()>790) return false;
    if(!wxFileExists(fnam) || !wxFileExists(fnam+_(".ecsm"))) return false;
//lies namen, r und s ein
    sfnam= fnam + _(".ecsm");
    strcpy( buff, (const char*)sfnam.mb_str(wxConvLocal) );
    sfp=fopen(buff,"r");
         if(sfp == NULL) return false;
    lbl=fscanf(sfp,"Domnam: %50s ",buff);
        if(lbl==0)  {fclose(sfp); return false;}
    t_domnam=wxString::FromUTF8(buff);
    lbl=fscanf(sfp,"r: %800s ",buff);
            if(lbl==0)  {fclose(sfp); return false;}
    num=wxString::FromUTF8(buff);
    r.storhex(&num);
    lbl=fscanf(sfp,"s: %800s ",buff);
            if(lbl==0)  {fclose(sfp); return false;}
    num=wxString::FromUTF8(buff);
    s.storhex(&num);
    lbl=fscanf(sfp,"Hash: %50s ",buff);
        if(lbl==0)  {fclose(sfp); return false;}
        else
        {
            hashnam=wxString::FromUTF8(buff);
            if(( hashnam != _("Fleas_1_8"))&&( hashnam != _("sha2"))&&( hashnam != _("Fleas_3"))
                &&( hashnam != _("Fleas_o2"))&&( hashnam != _("Fleas_o5"))&&( hashnam != _("sha4"))
                &&( hashnam != _("Fleas_lx"))&&( hashnam != _("Fleas_lx3"))&&( hashnam != _("Fleas_lc"))   ) //Fleas_l and other obsolete ones excluded
            {
                {fclose(sfp); return false;}
            }
        }
    fclose(sfp);
    retval= verify_elliptic_qq(fnam, &stretch_ell, &(public_master.A), &r, &s,hashnam);
    return retval;
}
/******************************************************/
void set_public_master()
{
    longnumber x,y;
    wxString h;

    h=_("04681d48a11d3cf5f4e021747da619d646a2f4fd87f197385178373d0c6bd308");
    x.storhex(&h);
    h=_("02ed0148c8a00b991c36ce723d0d1e9f289c002d5d381a58ffd372f850d4d801");
    y.storhex(&h);
    e_p A(&x,&y);
    public_master.set_el_pub(&A,&stretch_ell,_("master_01"),_("Program_Maintainer(M.Anders)"));
    return;
}
/***********************************************************/
