/*
 *   Copyright (C) 2011-2016, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */


#ifndef GPG_DEC_DIALOG_H
#define GPG_DEC_DIALOG_H

//(*Headers(gpg_dec_dialog)
#include <wx/dialog.h>
#include <wx/sizer.h>
#include <wx/button.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>
//*)

class gpg_dec_dialog: public wxDialog
{
	public:

		gpg_dec_dialog(wxWindow* parent,wxWindowID id=wxID_ANY,const wxPoint& pos=wxDefaultPosition,const wxSize& size=wxDefaultSize);
		virtual ~gpg_dec_dialog();

		//(*Declarations(gpg_dec_dialog)
		wxButton* Button4;
		wxButton* Button2;
		wxButton* Button3;
		wxStaticText* StaticText1;
		wxStaticText* StaticText4;
		wxStaticText* StaticText5;
		wxTextCtrl* ciphnam_ctrl;
		wxTextCtrl* plainnam_ctrl;
		//*)

	protected:

		//(*Identifiers(gpg_dec_dialog)
		static const long ID_BUTTON3;
		static const long ID_STATICTEXT1;
		static const long ID_STATICTEXT4;
		static const long ID_TEXTCTRL3;
		static const long ID_BUTTON2;
		static const long ID_STATICTEXT5;
		static const long ID_TEXTCTRL6;
		static const long ID_BUTTON4;
		//*)

	private:

		//(*Handlers(gpg_dec_dialog)
		void OnSelCipher(wxCommandEvent& event);
		void OnExit(wxCommandEvent& event);
		void OnDoDecipher(wxCommandEvent& event);
		//*)


		DECLARE_EVENT_TABLE()
};

#endif
