/*
 *   Copyright (C) 2011-2016, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
 

#include "gnupg_select.h"

//(*InternalHeaders(gnupg_select)
#include <wx/string.h>
#include <wx/intl.h>
#include <wx/font.h>
//*)


#include "globals.h"
#include "gnupg_globals.h"
#include "gpg_wrap.h"

//(*IdInit(gnupg_select)
const long gnupg_select::ID_STATICTEXT1 = wxNewId();
const long gnupg_select::ID_CHOICE1 = wxNewId();
const long gnupg_select::ID_BUTTON1 = wxNewId();
const long gnupg_select::ID_BUTTON2 = wxNewId();
//*)

BEGIN_EVENT_TABLE(gnupg_select,wxDialog)
	//(*EventTable(gnupg_select)
	//*)
END_EVENT_TABLE()

gnupg_select::gnupg_select(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
	//(*Initialize(gnupg_select)
	wxFlexGridSizer* FlexGridSizer1;

	Create(parent, id, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("id"));
	SetClientSize(wxDefaultSize);
	Move(wxDefaultPosition);
	FlexGridSizer1 = new wxFlexGridSizer(0, 2, 0, 0);
	StaticText1 = new wxStaticText(this, ID_STATICTEXT1, _("Waehle GnuPG"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT1"));
	wxFont StaticText1Font(11,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText1->SetFont(StaticText1Font);
	FlexGridSizer1->Add(StaticText1, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	gnusel_ctrl = new wxChoice(this, ID_CHOICE1, wxDefaultPosition, wxSize(346,32), 0, 0, 0, wxDefaultValidator, _T("ID_CHOICE1"));
	gnusel_ctrl->SetSelection( gnusel_ctrl->Append(_("disable GnuPG")) );
	gnusel_ctrl->Append(_("gpg"));
	gnusel_ctrl->Append(_("gpg2"));
	wxFont gnusel_ctrlFont(10,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	gnusel_ctrl->SetFont(gnusel_ctrlFont);
	FlexGridSizer1->Add(gnusel_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	Button1 = new wxButton(this, ID_BUTTON1, _("OK"), wxDefaultPosition, wxSize(90,30), 0, wxDefaultValidator, _T("ID_BUTTON1"));
	wxFont Button1Font(11,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button1->SetFont(Button1Font);
	FlexGridSizer1->Add(Button1, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	Button2 = new wxButton(this, ID_BUTTON2, _("Abbrechen"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON2"));
	wxFont Button2Font(11,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button2->SetFont(Button2Font);
	FlexGridSizer1->Add(Button2, 1, wxALL|wxALIGN_RIGHT|wxALIGN_BOTTOM, 5);
	SetSizer(FlexGridSizer1);
	FlexGridSizer1->Fit(this);
	FlexGridSizer1->SetSizeHints(this);

	Connect(ID_CHOICE1,wxEVT_COMMAND_CHOICE_SELECTED,(wxObjectEventFunction)&gnupg_select::OnChoice);
	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&gnupg_select::OnOk);
	Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&gnupg_select::OnCancel);
	//*)
    if(!gpg_pres_checked)
    {
    //first check gpg presence, set "gpg_was_checked and set "gpg_here"
        gpg_here= prog_is_present(_("gpg"));
        if(gpg_here) gpg_name=_("gpg ");
        gpg2_here= prog_is_present(_("gpg2"));
        if((gpg2_here)&&(!gpg_here)) gpg_name=_("gpg2 ");
        gpg_pres_checked=true;
        if(!(gpg_here||gpg2_here) )
        {
#ifdef __WXMSW__
            throwout(_("no GnuPG in Path!\ncannot access gpg!\ncannot use gpg!\nif gpg was installed -> update Path-variable"),20);
#else
            throwout(_("Weird! no GnuPG in Path!\ncannot access gpg!\nis there such thing as Linux without gpg???\nif gpg was installed -> update Path-variable"),20);
#endif
        }
    }
	//check presence of gpg and gpg2
	wxString gpg_ver,gpg2_ver;
	if(gpg_here)
	{
	    //gpg here edit choice 1 entry
	    gpg_get_name(&gpg_ver);
	    gnusel_ctrl->SetString(1,_("GnuPG 1: ")+ gpg_ver);
	}
	else gnusel_ctrl->SetString(1,_("GnuPG 1 not present"));

    if(gpg2_here)
	{
	    gpg2_get_name(&gpg2_ver);
	    //gpg here edit choice 1 entry
	    gnusel_ctrl->SetString(2,_("GnuPG 2: ")+ gpg2_ver);
	}
	else gnusel_ctrl->SetString(2,_("GnuPG 2 not present"));
    //set previous selection
    if(gpg_name==_("gpg "))
        gnusel_ctrl->SetSelection(1);
    else if(gpg_name==_("gpg2 "))
        gnusel_ctrl->SetSelection(2);
    else if(gpg_name==_("none "))
        gnusel_ctrl->SetSelection(0);
        else
            gnusel_ctrl->SetSelection(0);
}
/*****************************************************************/
gnupg_select::~gnupg_select()
{
	//(*Destroy(gnupg_select)
	//*)
}
/*****************************************************************/


void gnupg_select::OnOk(wxCommandEvent& event)
{
    int choice;

    choice= gnusel_ctrl->GetSelection();
    //if gpg2 selected
    if(choice==2)
    {
        gpg_name=_("gpg2 ");
        EndModal(2);
        return;
    }
    //if gpg selected
    if(choice==1)
    {
        gpg_name=_("gpg ");
        EndModal(1);
        return;
    }
    //if disable gpg selected
    if(choice==0)
    {
        gpg_name=_("none ");
        EndModal(10);
        return;
    }
    EndModal(0);
    return;
}

void gnupg_select::OnCancel(wxCommandEvent& event)
{
    EndModal(0);
}

void gnupg_select::OnChoice(wxCommandEvent& event)
{
    int choice;

    choice= gnusel_ctrl->GetSelection();
    if(choice==wxNOT_FOUND) return;
    if(!gpg_here && (choice==1))
    {
        throwout(_("gpg not accressible"),1);
        if(gpg2_here) gnusel_ctrl->SetSelection(2);
        else gnusel_ctrl->SetSelection(0);
    }
    if(!gpg2_here && (choice==2))
    {
        throwout(_("gpg2 not accressible"),1);
        if(gpg_here) gnusel_ctrl->SetSelection(1);
        else gnusel_ctrl->SetSelection(0);
    }
}
