﻿/*
 *   Copyright (C) 2011-2016, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but without any warranty; without even the implied warranty of
 *  merchantability or fitness for a particular purpose.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <wx/thread.h>
#include <wx/filename.h>
#include <wx/ffile.h>

#include <wx/arrstr.h>
#include <wx/dir.h>
#include <wx/busyinfo.h>

#include "elliptic_verify.h"

#include "globals.h"
#include "LoadEllKey.h"
#include "AskDialog.h"


//(*InternalHeaders(elliptic_verify)
#include <wx/string.h>
#include <wx/intl.h>
#include <wx/font.h>
//*)
#include <wx/filedlg.h>

/**************************************************/
//result= verify_elliptic_qq(pfnam, &(verdom), &(Vpoint), &r, &s,hashnam);
/**************************************************/
class ver_Thread : public wxThread
{
    public:
      ver_Thread(bool *retval, wxString *pfnam, ellipse *pverdom, e_p *pVpoint, longnumber *pr, longnumber *ps, wxString *phashnam)
         : wxThread(wxTHREAD_JOINABLE)
         {
             retv=retval;
             fnam=pfnam;
             vd=pverdom;
             P=pVpoint;
             r=pr;
             s=ps;
             hash= phashnam;
         }
         ~ver_Thread();

    protected:
       virtual ExitCode Entry();
       bool *retv;
       wxString *fnam;
       ellipse *vd;
       e_p *P;
       longnumber *r;
       longnumber *s;
       wxString *hash;
};
/********************************************************/
wxThread::ExitCode ver_Thread::Entry()
    {
        *retv=verify_elliptic_qq(*fnam, vd, P, r, s,*hash,false);

        return (wxThread::ExitCode)0;     // success
    }

/*******************************************************/
ver_Thread::~ver_Thread()
{
    return;
}
/************************************************/

ver_Thread *m_vThread;


//(*IdInit(elliptic_verify)
const long elliptic_verify::ID_BUTTON5 = wxNewId();
const long elliptic_verify::ID_STATICTEXT1 = wxNewId();
const long elliptic_verify::ID_STATICTEXT2 = wxNewId();
const long elliptic_verify::ID_TEXTCTRL1 = wxNewId();
const long elliptic_verify::ID_BUTTON1 = wxNewId();
const long elliptic_verify::ID_STATICTEXT11 = wxNewId();
const long elliptic_verify::ID_TEXTCTRL9 = wxNewId();
const long elliptic_verify::ID_STATICTEXT3 = wxNewId();
const long elliptic_verify::ID_STATICTEXT10 = wxNewId();
const long elliptic_verify::ID_BUTTON2 = wxNewId();
const long elliptic_verify::ID_STATICTEXT4 = wxNewId();
const long elliptic_verify::ID_STATICTEXT5 = wxNewId();
const long elliptic_verify::ID_STATICTEXT6 = wxNewId();
const long elliptic_verify::ID_TEXTCTRL2 = wxNewId();
const long elliptic_verify::ID_TEXTCTRL3 = wxNewId();
const long elliptic_verify::ID_TEXTCTRL4 = wxNewId();
const long elliptic_verify::ID_STATICTEXT7 = wxNewId();
const long elliptic_verify::ID_TEXTCTRL5 = wxNewId();
const long elliptic_verify::ID_STATICTEXT9 = wxNewId();
const long elliptic_verify::ID_STATICTEXT8 = wxNewId();
const long elliptic_verify::ID_TEXTCTRL6 = wxNewId();
const long elliptic_verify::ID_TEXTCTRL7 = wxNewId();
const long elliptic_verify::ID_BUTTON4 = wxNewId();
const long elliptic_verify::ID_BUTTON6 = wxNewId();
const long elliptic_verify::ID_BUTTON7 = wxNewId();
const long elliptic_verify::ID_BUTTON3 = wxNewId();
const long elliptic_verify::ID_TEXTCTRL8 = wxNewId();
//*)

BEGIN_EVENT_TABLE(elliptic_verify,wxDialog)
	//(*EventTable(elliptic_verify)
	//*)
END_EVENT_TABLE()

elliptic_verify::elliptic_verify(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
    wxString h;

    if(!checkarm()){Close();}

	//(*Initialize(elliptic_verify)
	wxFlexGridSizer* FlexGridSizer1;

	Create(parent, wxID_ANY, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("wxID_ANY"));
	SetBackgroundColour(wxColour(224,228,250));
	FlexGridSizer1 = new wxFlexGridSizer(0, 3, 0, 0);
	Button5 = new wxButton(this, ID_BUTTON5, _("Schliessen"), wxDefaultPosition, wxSize(130,32), 0, wxDefaultValidator, _T("ID_BUTTON5"));
	Button5->SetBackgroundColour(wxColour(238,153,153));
	wxFont Button5Font(11,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button5->SetFont(Button5Font);
	FlexGridSizer1->Add(Button5, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	StaticText1 = new wxStaticText(this, ID_STATICTEXT1, _("ECCS Signatur ueberpruefen"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT1"));
	wxFont StaticText1Font(14,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText1->SetFont(StaticText1Font);
	FlexGridSizer1->Add(StaticText1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	FlexGridSizer1->Add(-1,-1,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText2 = new wxStaticText(this, ID_STATICTEXT2, _("Zu ueberpruefende Datei:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT2"));
	wxFont StaticText2Font(11,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText2->SetFont(StaticText2Font);
	FlexGridSizer1->Add(StaticText2, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	file_ctrl = new wxTextCtrl(this, ID_TEXTCTRL1, wxEmptyString, wxDefaultPosition, wxSize(434,23), 0, wxDefaultValidator, _T("ID_TEXTCTRL1"));
	wxFont file_ctrlFont(9,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	file_ctrl->SetFont(file_ctrlFont);
	FlexGridSizer1->Add(file_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button1 = new wxButton(this, ID_BUTTON1, _("Datei waehlen"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON1"));
	wxFont Button1Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button1->SetFont(Button1Font);
	FlexGridSizer1->Add(Button1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText11 = new wxStaticText(this, ID_STATICTEXT11, _("Signaturdatei:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT11"));
	wxFont StaticText11Font(11,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText11->SetFont(StaticText11Font);
	FlexGridSizer1->Add(StaticText11, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	sigfil_ctrl = new wxTextCtrl(this, ID_TEXTCTRL9, wxEmptyString, wxDefaultPosition, wxSize(442,23), 0, wxDefaultValidator, _T("ID_TEXTCTRL9"));
	sigfil_ctrl->SetForegroundColour(wxColour(164,67,67));
	wxFont sigfil_ctrlFont(9,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	sigfil_ctrl->SetFont(sigfil_ctrlFont);
	FlexGridSizer1->Add(sigfil_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	FlexGridSizer1->Add(-1,-1,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText3 = new wxStaticText(this, ID_STATICTEXT3, _("Public Key of Signer"), wxDefaultPosition, wxSize(179,22), 0, _T("ID_STATICTEXT3"));
	wxFont StaticText3Font(11,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText3->SetFont(StaticText3Font);
	FlexGridSizer1->Add(StaticText3, 1, wxALL|wxALIGN_BOTTOM|wxALIGN_CENTER_HORIZONTAL, 5);
	StaticText10 = new wxStaticText(this, ID_STATICTEXT10, _("Sie koennen Ax,Ay and Domain Name ggf. von der Verifikations-website kopieren.  \nWaehlen Sie dann ID und Name wie gewuenscht oder importieren Sie aus einer Schluesseldatei \noder verwenden Sie einen Schluessel aus dem internen Speicher."), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT10"));
	wxFont StaticText10Font(7,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText10->SetFont(StaticText10Font);
	FlexGridSizer1->Add(StaticText10, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button2 = new wxButton(this, ID_BUTTON2, _("lade oefftl. Schluessel\naus internem Speicher"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON2"));
	wxFont Button2Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button2->SetFont(Button2Font);
	FlexGridSizer1->Add(Button2, 1, wxALL|wxALIGN_BOTTOM|wxALIGN_CENTER_HORIZONTAL, 5);
	StaticText4 = new wxStaticText(this, ID_STATICTEXT4, _("Key ID:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT4"));
	wxFont StaticText4Font(11,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText4->SetFont(StaticText4Font);
	FlexGridSizer1->Add(StaticText4, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText5 = new wxStaticText(this, ID_STATICTEXT5, _("Name des Signierenden"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT5"));
	wxFont StaticText5Font(11,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText5->SetFont(StaticText5Font);
	FlexGridSizer1->Add(StaticText5, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText6 = new wxStaticText(this, ID_STATICTEXT6, _("Key Domain"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT6"));
	wxFont StaticText6Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText6->SetFont(StaticText6Font);
	FlexGridSizer1->Add(StaticText6, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	id_ctrl = new wxTextCtrl(this, ID_TEXTCTRL2, wxEmptyString, wxDefaultPosition, wxSize(152,23), 0, wxDefaultValidator, _T("ID_TEXTCTRL2"));
	wxFont id_ctrlFont(9,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	id_ctrl->SetFont(id_ctrlFont);
	FlexGridSizer1->Add(id_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	fullnam_ctrl = new wxTextCtrl(this, ID_TEXTCTRL3, wxEmptyString, wxDefaultPosition, wxSize(439,23), 0, wxDefaultValidator, _T("ID_TEXTCTRL3"));
	wxFont fullnam_ctrlFont(9,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	fullnam_ctrl->SetFont(fullnam_ctrlFont);
	FlexGridSizer1->Add(fullnam_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	ky_domnam_ctrl = new wxTextCtrl(this, ID_TEXTCTRL4, wxEmptyString, wxDefaultPosition, wxSize(128,23), 0, wxDefaultValidator, _T("ID_TEXTCTRL4"));
	wxFont ky_domnam_ctrlFont(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	ky_domnam_ctrl->SetFont(ky_domnam_ctrlFont);
	FlexGridSizer1->Add(ky_domnam_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText7 = new wxStaticText(this, ID_STATICTEXT7, _("oefftl. Schluessel Ax:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT7"));
	wxFont StaticText7Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText7->SetFont(StaticText7Font);
	FlexGridSizer1->Add(StaticText7, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	ax_ctrl = new wxTextCtrl(this, ID_TEXTCTRL5, wxEmptyString, wxDefaultPosition, wxSize(443,23), 0, wxDefaultValidator, _T("ID_TEXTCTRL5"));
	wxFont ax_ctrlFont(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	ax_ctrl->SetFont(ax_ctrlFont);
	FlexGridSizer1->Add(ax_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText9 = new wxStaticText(this, ID_STATICTEXT9, _("System Domain"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT9"));
	wxFont StaticText9Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText9->SetFont(StaticText9Font);
	FlexGridSizer1->Add(StaticText9, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText8 = new wxStaticText(this, ID_STATICTEXT8, _("Ay:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT8"));
	wxFont StaticText8Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText8->SetFont(StaticText8Font);
	FlexGridSizer1->Add(StaticText8, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	ay_ctrl = new wxTextCtrl(this, ID_TEXTCTRL6, wxEmptyString, wxDefaultPosition, wxSize(443,23), 0, wxDefaultValidator, _T("ID_TEXTCTRL6"));
	wxFont ay_ctrlFont(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	ay_ctrl->SetFont(ay_ctrlFont);
	FlexGridSizer1->Add(ay_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	currdom_ctrl = new wxTextCtrl(this, ID_TEXTCTRL7, wxEmptyString, wxDefaultPosition, wxSize(117,23), 0, wxDefaultValidator, _T("ID_TEXTCTRL7"));
	currdom_ctrl->Disable();
	wxFont currdom_ctrlFont(7,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	currdom_ctrl->SetFont(currdom_ctrlFont);
	FlexGridSizer1->Add(currdom_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button4 = new wxButton(this, ID_BUTTON4, _("oefftl. Schluessel aus Datei"), wxDefaultPosition, wxSize(172,34), 0, wxDefaultValidator, _T("ID_BUTTON4"));
	wxFont Button4Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button4->SetFont(Button4Font);
	FlexGridSizer1->Add(Button4, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button6 = new wxButton(this, ID_BUTTON6, _("ECCS Signatur ueberpruefen"), wxDefaultPosition, wxSize(235,31), wxBU_EXACTFIT, wxDefaultValidator, _T("ID_BUTTON6"));
	Button6->SetBackgroundColour(wxColour(199,230,245));
	wxFont Button6Font(11,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button6->SetFont(Button6Font);
	FlexGridSizer1->Add(Button6, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button7 = new wxButton(this, ID_BUTTON7, _("Neue System Domain"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON7"));
	wxFont Button7Font(7,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button7->SetFont(Button7Font);
	FlexGridSizer1->Add(Button7, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button3 = new wxButton(this, ID_BUTTON3, _("Schluessel intern speichern"), wxDefaultPosition, wxSize(168,32), 0, wxDefaultValidator, _T("ID_BUTTON3"));
	wxFont Button3Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button3->SetFont(Button3Font);
	FlexGridSizer1->Add(Button3, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	res_ctrl = new wxTextCtrl(this, ID_TEXTCTRL8, _("Ergebnis der Ueberpruefung"), wxDefaultPosition, wxSize(425,36), wxTE_READONLY|wxTE_CENTRE, wxDefaultValidator, _T("ID_TEXTCTRL8"));
	res_ctrl->SetForegroundColour(wxColour(97,14,14));
	res_ctrl->SetBackgroundColour(wxColour(251,194,194));
	wxFont res_ctrlFont(12,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_BOLD,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	res_ctrl->SetFont(res_ctrlFont);
	FlexGridSizer1->Add(res_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	FlexGridSizer1->Add(-1,-1,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	SetSizer(FlexGridSizer1);
	FlexGridSizer1->Fit(this);
	FlexGridSizer1->SetSizeHints(this);

	Connect(ID_BUTTON5,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&elliptic_verify::OnCancExit);
	Connect(ID_TEXTCTRL1,wxEVT_COMMAND_TEXT_ENTER,(wxObjectEventFunction)&elliptic_verify::OnFilenameEdit);
	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&elliptic_verify::OnFileSel);
	Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&elliptic_verify::GetStoredPublicKey);
	Connect(ID_BUTTON4,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&elliptic_verify::LoadPukyfromFile);
	Connect(ID_BUTTON6,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&elliptic_verify::OnProove);
	Connect(ID_BUTTON7,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&elliptic_verify::LoadOtherDomain);
	Connect(ID_BUTTON3,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&elliptic_verify::OnSorePubky);
	//*)

    file_ctrl->DragAcceptFiles(true);
    file_ctrl->Connect(wxEVT_DROP_FILES, wxDropFilesEventHandler(elliptic_verify::OnDropFile), NULL, this);

	//check if still Trivial
	if(el_pk.id==_("Trivial"))
	{
        if(!load_pub_ell_ky(&el_pk, &def_pubkey))
           {
               throwout(_("Could not load default public key!"),5);
               def_pubkey=_("empty");
           }
    }
	loky.copy_pub_ky(&el_pk);
    id_ctrl->SetValue(loky.id);
    fullnam_ctrl->SetValue(loky.fullnam);
    ky_domnam_ctrl->SetValue(loky.domnam);
    currdom_ctrl->SetValue(gdom.name);
    loky.A.x.writehex(&h);
    ax_ctrl->SetValue(h);
    loky.A.y.writehex(&h);
    ay_ctrl->SetValue(h);
    el_pk.copy_pub_ky(&loky);
    res_ctrl->SetValue(_("Noch nicht geprueft"));
    redcol.Set(255,120,120);grencol.Set(120,255,120);neutcol.Set(255,200,170);
    //red.SetBackgroundColour(redcol);gren.SetBackgroundColour(grencol);neut.SetBackgroundColour(neutcol);
    //neut.SetTextColour(grencol);
    //r1=res_ctrl->SetStyle(0,5,neut); -> dysfunctional *#@!X
    res_ctrl->SetBackgroundColour(neutcol);
}
/***********************************************************/
elliptic_verify::~elliptic_verify()
{
	//(*Destroy(elliptic_verify)
	//*)
}
/*******************************************************/
void elliptic_verify::OnDropFile(wxDropFilesEvent& event)
    {
       wxString ext;
       int res;
        int filno;
        drop_succ=false;

        if (event.GetNumberOfFiles() > 0) {

            wxString* dropped = event.GetFiles();
            wxASSERT(dropped);

            wxBusyCursor busyCursor;
            wxWindowDisabler disabler;
            wxBusyInfo busyInfo(_("Fuege Datei hinzu, bitte warten..."));

            wxString name;
            filno = event.GetNumberOfFiles();
            if(filno!=1)
            {
				throwout(_("Nur ein Dateiname bitte.\nEinfuegen verweigert!"),3);
				return;
			}
			if( wxDirExists( 	dropped[0]	))
            {
                throwout(_("Das ist ein Verzeichnisname!!\nNur Dateiname moeglich.\nDrop ignoriert!"),3);
                return;
            }
			name = dropped[0];
			if (!wxFileExists(name))
            {
				throwout(_("Datei existiert nicht.\nEinfuegen verweigert!"),5);
				return;
			}

            wxTextCtrl* textCtrl = dynamic_cast<wxTextCtrl*>(event.GetEventObject());
            wxASSERT(textCtrl);
            textCtrl->Clear();
            textCtrl->SetValue(name);
            drop_succ=true;
            fnam= name;
         ext=fnam.Right(5);
         if((ext == _(".ecsg"))||(ext == _(".ects")))
         {
             AskDialog dialog(this,_("Do you really want to verify a signature of\na signature file or a timestamp ?\nThis would be very unusual!"));
             res=dialog.ShowModal();
             if(res == 0)
             {
                //check if truncated file exists
                ext= fnam.Left(fnam.Len() - 5);
                if(!wxFile::Exists(ext)) {return;}
                else fnam=ext;
             }
         }
         signam= fnam +_(".ecsg");
         if ( !fnam.empty() )
         {
             file_ctrl->SetValue(fnam);
             sigfil_ctrl->SetValue(signam);
             res_ctrl->SetValue(_("Not evaluated yet"));
             //chang color to neutral
             res_ctrl->SetBackgroundColour(neutcol);
             //check for presence
             if(!wxFile::Exists(signam))
             throwout(_("Watch out!\nThe given Signature File\ndoes not exist in the documents folder!\nVerification not possible."),10);
             else  cur_doc_path= ((wxFileName)fnam).GetPath(); //get new path and store into cur_doc_path
         }

        return;
        }
    }
/*********************************************************//***********************************************************/
void elliptic_verify::OnFileSel(wxCommandEvent& event)
{
    wxString ext,docp;
    int res;

    if(!checkarm()){Close();}
    if(cur_doc_path.IsEmpty())
    {
        docp = doc_path; //first call
    }
    else
    {
        docp = cur_doc_path;
    }
    fnam = wxFileSelector(_("Waehle Datei fuer Test der Signatur"),docp);
    //if ecsg or ects -> ask
    ext=fnam.Right(5);
    if((ext == _(".ecsg"))||(ext == _(".ects")))
    {
        AskDialog dialog(this,_("Willst Du wirklich die Signatur einer \nSignatur oder eines Zeitstempels pruefen?\nDas waere seltsam!"));
        res=dialog.ShowModal();
        if(res == 0)
        {
           //check if truncated file exists
           ext= fnam.Left(fnam.Len() - 5);
           if(!wxFile::Exists(ext)) {return;}
           else fnam=ext;
        }
    }
    signam= fnam +_(".ecsg");
    if ( !fnam.empty() )
    {
        file_ctrl->SetValue(fnam);
        sigfil_ctrl->SetValue(signam);
        res_ctrl->SetValue(_("Noch nicht geprueft"));
        //chang color to neutral
        res_ctrl->SetBackgroundColour(neutcol);
        //check for presence
        if(!wxFile::Exists(signam))
        throwout(_("Achtung!\nDie gegebene Signaturdatei\nliegt im Verzeichnis der Datei nicht vor!\nVerifikation unmoeglich."),10);
        else  cur_doc_path= ((wxFileName)fnam).GetPath(); //get new path and store into cur_doc_path
    }
    return;
}
/*************************************************************************/
void elliptic_verify::GetStoredPublicKey(wxCommandEvent& event)
{
    wxString h;

    LoadEllKey dialog(this,&loky);
    dialog.ShowModal();

    if(!checkarm()){Close();}
    id_ctrl->SetValue(loky.id);
    fullnam_ctrl->SetValue(loky.fullnam);
    ky_domnam_ctrl->SetValue(loky.domnam);
    currdom_ctrl->SetValue(gdom.name);
    loky.A.x.writehex(&h);
    ax_ctrl->SetValue(h);
    loky.A.y.writehex(&h);
    ay_ctrl->SetValue(h);
    el_pk.copy_pub_ky(&loky);
    res_ctrl->SetValue(_("Noch nicht geprueft"));
    //chang color to neutral
    res_ctrl->SetBackgroundColour(neutcol);
    def_pubkey=el_pk.id;
}
/***************************************************************/
void elliptic_verify::LoadPukyfromFile(wxCommandEvent& event)
{
    wxString importfile,h;
    el_pub oldkey;
    ellipse locell;
    int elfl;

    if(!checkarm()){Close();}
    oldkey.copy_pub_ky(&loky);
    importfile = wxFileSelector(_("Waehle einen oeffentl. Schluessel fuer einmalige Benutzung jetzt."),kytray,_(""),_("pell"),_("*.pell"));
    if(!loky.get_from_file(importfile))
    {
        loky.copy_pub_ky(&oldkey);
        throwout(_("Als Schluessel abgelehnt!\nabbruch des Ladens."),2);
        return;
    }
    if(loky.domnam == gdom.name) locell.copyell(&gdom);
    else
    {
        elfl=e_ls.getelp(&locell,loky.domnam);
        if(elfl<0)
        {
           wxMessageBox(_("Schluesseldomain unbekannt\n kein Laden!\nzurueck zum letzten validen Schluessel"));
           loky.copy_pub_ky(&oldkey);
           return;
        }
    }
    //check on curve?
    if(! (loky.A).is_in_ellipse(&locell))
    {
        wxMessageBox(_("Schluessel is inkompatibel mit eignener Domain?!?\n kein Laden!\nzurueck zum letzten validen Schluessel"));
        loky.copy_pub_ky(&oldkey);
        return;
    }
    // wenn bestanden jetzt alles eintragen
    id_ctrl->SetValue(loky.id);
    fullnam_ctrl->SetValue(loky.fullnam);
    ky_domnam_ctrl->SetValue(loky.domnam);
    currdom_ctrl->SetValue(gdom.name);
    loky.A.x.writehex(&h);
    ax_ctrl->SetValue(h);
    loky.A.y.writehex(&h);
    ay_ctrl->SetValue(h);
    el_pk.copy_pub_ky(&loky);
    res_ctrl->SetValue(_("Noch nicht geprueft"));
        //chang color to neutral
    res_ctrl->SetBackgroundColour(neutcol);
    //def_pubkey=el_pk.id;
}
/****************************************************************/
void elliptic_verify::OnSorePubky(wxCommandEvent& event)
{
    wxString txa,tya;
    FILE *knamfil, *kfil;
    bool oldname=false;
    char buff1[400],buff2[400];
    int lbl,domfl;
    ellipse kyllips;

    if(!checkarm()){Close();}
    loky.id=id_ctrl->GetLineText(0);
    loky.id.Replace(_(" "), _("_"));

    loky.fullnam=fullnam_ctrl->GetLineText(0);
    loky.fullnam.Replace(_(" "), _("_"));

    loky.domnam=ky_domnam_ctrl->GetLineText(0);
    loky.domnam.Replace(_(" "), _("_"));

    txa=ax_ctrl->GetLineText(0);
    loky.A.x.storhex(&txa);

    tya=ay_ctrl->GetLineText(0);
    loky.A.y.storhex(&tya);

    domfl=e_ls.getelp(&kyllips,loky.domnam);
    if(domfl <0)
       {
        throwout(_("Schluesseldomain unbekannt\n\nSchluessel nicht validierbar, kein Import !\n\nBitte erst passende Domain importieren!"),10);
        return;
       }

    if(! (loky.A).is_in_ellipse(&kyllips))
    {
        wxMessageBox(_("Schluesselvalidierung gescheitert\n keine Speicherung!"));
        return;
    }

    //open keynamfile, append name and id, close keynamfile
    if(keyid_free(loky.id,true)!=0)
    {
        throwout(loky.id + _("\nDiese SchluesselID wird bereits genutzt \n Bitte importiere mit geaenderter ID!\nImport verweigert!"));
        return;
    }

    if(S_FIL) unlockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang); // unlock keynamefile
    if((knamfil = fopen((const char*)(sec_path + _("/e_ell_knamfile.knf")).mb_str(wxConvLocal), "a"))== NULL) return;
    fprintf(knamfil, "id: %s  Name: %s  \n",(const char*)(loky.id).mb_str(wxConvUTF8),
                  (const char*)(loky.fullnam).mb_str(wxConvUTF8));
    fclose(knamfil);
    if(S_FIL) lockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang); // lock again

    // to do: decrypt keyfile
    //open keyfile, store all data and close
    if(S_FIL) unlockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang,0,false); // unlock keynamefile
    if((kfil = fopen((const char*)(sec_path + _("/e_ell_Keyfile.kyf")).mb_str(wxConvLocal), "a"))== NULL) return;
    fprintf(kfil, "id: %s  Name: %s DomName: %s\n",(const char*)(loky.id).mb_str(wxConvUTF8),
                  (const char*)(loky.fullnam).mb_str(wxConvUTF8),(const char*)(loky.domnam).mb_str(wxConvUTF8) );
    (loky.A.x).writehex(&txa);
    (loky.A.y).writehex(&tya);

    fprintf(kfil,"Ax: %s \n Ay: %s \n \n", (const char*)txa.mb_str(wxConvUTF8), (const char*)tya.mb_str(wxConvUTF8));
    fclose(kfil);
    if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // unlock keynamefile
    return;
}
/*************************************/
void elliptic_verify::OnProove(wxCommandEvent& event)
{
    bool result,t_ok=true, showprog=true;
    wxString pfnam,sfnam,num,txa,tya,msg;
    FILE *sfp;
    char buff[3202];
    wxString t_domnam,kdomn, hashnam;
    int lbl,domfl;
    longnumber r,s;
    e_p Vpoint;
    ellipse verdom;
    ulong32 flen;


    if(!checkarm()){Close();}
    pfnam=file_ctrl->GetLineText(0);
    //check, ob file und elliptic sig vorhanden und wie gross
    if(pfnam.Len()>800) pfnam.Truncate(800);
    if(! wxFile::Exists(pfnam)) {throwout(_("Datei:\n")+ pfnam + _("\n existiert nicht !?!??")); return;}
    else //determine length and set progressbar appearance
    {
        wxFile wxf1(pfnam);
        flen=wxf1.Length();
        wxf1.Close();
        if(flen > 2000000)
        {
            t_ok=false;
            msg.Printf(_("Datei ist groesser als %ld MB.\nHashen braucht Geduld,\nkeine Vorberechnung!"),flen/1000000);
            throwout(msg,4);
        }
    }
    fnam=pfnam;
    sfnam=sigfil_ctrl->GetLineText(0);
    if(sfnam.Len()>800) pfnam.Truncate(800);
    if(! wxFile::Exists(sfnam)) {throwout(_("ECCS-Signatur-Datei nicht vorhanden")); return;}
    //lies namen, r und s ein
    wxFFile wxff1(sfnam, _("rb"));
    sfp= wxff1.fp();
         if(sfp == NULL) {throwout(_("Datei kann nicht geoeffnet werden")); return;}
    lbl=fscanf(sfp,"Domnam: %50s ",buff);
        if(lbl==0)  {throwout(_("Domnam Fehler")); wxff1.Close();	return;}
    t_domnam=wxString::FromUTF8(buff);
    lbl=fscanf(sfp,"r: %800s ",buff);
            if(lbl==0)  {throwout(_("Parameter r Lesefehler")); wxff1.Close();	return;}
    num=wxString::FromUTF8(buff);
    r.storhex(&num);
    lbl=fscanf(sfp,"s: %800s ",buff);
            if(lbl==0)  {throwout(_("Parameter s Lesefehler")); wxff1.Close();	return;}
    num=wxString::FromUTF8(buff);
    s.storhex(&num);
    lbl=fscanf(sfp,"Hash: %50s ",buff);
        if(lbl==0)  {throwout(_("Warnung, \nkonnte Hashbezeichner nicht lesen")); hashnam=_("Fleas_1_8");
			    wxff1.Close();}
        else
        {
            hashnam=wxString::FromUTF8(buff);
            if(( hashnam != _("Fleas_1_8"))&&( hashnam != _("sha2"))&&( hashnam != _("Fleas_3"))&&( hashnam != _("Fleas_4"))
                &&( hashnam != _("Fleas_5"))&&( hashnam != _("Fleas_x2"))&&( hashnam != _("Fleas_x5"))
                &&( hashnam != _("Fleas_o2"))&&( hashnam != _("Fleas_o5"))&&( hashnam != _("sha4"))&&( hashnam != _("Fleas_l"))
                &&( hashnam != _("Fleas_lx"))&&( hashnam != _("Fleas_lx3"))&&( hashnam != _("Fleas_lc"))
                &&( hashnam != _("Fleas_ld"))&&( hashnam != _("Fleas_lb"))&&( hashnam != _("Fleas_b"))
               &&( hashnam != _("Fleas_c"))&&( hashnam != _("Fleas_d")) &&( hashnam != _("JH"))
               &&( hashnam != _("skein")) )
            {
                throwout(_("warnung: unbekannter Hash-Bezeichner!"),5);
            }
        }
    wxff1.Close();
    //check domain
    kdomn= ky_domnam_ctrl->GetLineText(0);
    if(t_domnam != kdomn)
    {
        msg=_("Domain Namenskonflikt!\nSignature verlangt Domain: ") + t_domnam;
        msg += _("\n               Schluessel verlangt Domain: ");
        msg += kdomn;
        msg +=_("\n Du must das bereinigen! \nKeine Pruefung in unbestimmter Domain!");
        throwout(msg);
        return;
    }
    //check for accessibility of domain in pool
    if(t_domnam == gdom.name) verdom.copyell(&gdom);
    else
    {
       domfl=e_ls.getelp(&verdom,t_domnam);
       if(domfl <0)
       {
        throwout(_("Schluesseldomain unbekannt\n\nSchluessel nicht validierbar!\n\nBitte erst passende Domain importieren!"),10);
        return;
       }
    }
    //get A to loky fields
    if(!(Vpoint.copy_ep(&(loky.A)))) throwout(_("copy ep error"));
    txa=ax_ctrl->GetLineText(0);
    Vpoint.x.storhex(&txa);

    tya=ay_ctrl->GetLineText(0);
    Vpoint.y.storhex(&tya);
    //check validity
    if(! (Vpoint).is_in_ellipse(&verdom))
    {
        wxMessageBox(_("Oeffentl. Schluessel ist inkompatibel mit eigener Domain?!?\n Denk nicht mal an den Versuch einer Pruefung!"));
        res_ctrl->SetValue(_("Signatur abgewiesen"));
        //chang color to red
        res_ctrl->SetBackgroundColour(redcol);
        return;
    }
    if(t_ok)
    {
       m_vThread = new ver_Thread(&result,&pfnam,&(verdom), &(Vpoint), &r, &s,&hashnam);
       if ( m_vThread->Create() != wxTHREAD_NO_ERROR )
       {
            throwout(_("Can't create the precalc thread!\ntrying direct call!"),3);
            delete m_vThread;
            m_vThread = NULL;
            t_ok=false;
       }
       else
       {
        if (m_vThread->Run() != wxTHREAD_NO_ERROR )
        {
            throwout(_("Can't run the precalc thread!\ntrying direct call!"),3);
            delete m_vThread;
            m_vThread = NULL;
            t_ok=false;
        }
       }//thread fired
    }
    msg=_("Koennen Sie der Quelle des angenommenen\nUnterzeichnerschluessels vertrauen?!\n\nVertrauen in die Signatur braucht Vertrauen\nin die Authetizitaet des oeffentl. Schluessels!");
    throwout(msg,20);
    if(t_ok)
    {
        m_vThread->Wait(); //join Thread
    }
    else
    {
        result= verify_elliptic_qq(pfnam, &(verdom), &(Vpoint), &r, &s,hashnam, showprog);
    }
    if(result) //Verified!!
    {
        res_ctrl->SetValue(_("Signatur Verifiziert"));
        //chang color to green
        res_ctrl->SetBackgroundColour(grencol);
        //res_ctrl->SetStyle(1,7,gren); -> dysfunctional *#@!X
        throwout(_("Verifziert!\nInhaber des oeffentlichen Schluessels hat\ndiese Datei mit dem zugehoerigen priv. Schluessel signiert."),20);
        return;
    }
    else{
        res_ctrl->SetValue(_("Signatur abgewiesen"));
        //chang color to red
        res_ctrl->SetBackgroundColour(redcol);
        throwout(_("Abgewiesen!\nSignatur gehoert nicht zur\n Datei und/oder nicht zum oeffentl. Schluessel."));
        return;
    }
}
/********************************************************/
void elliptic_verify::LoadOtherDomain(wxCommandEvent& event)
{
    wxString fnam,message;
    char fnambuff[1602];

    if(!checkarm()){Close();}
    fnam = wxFileSelector(_("Waehle eine Domain-Datei"),kytray, _(""),_("elps"),_("*.elps"));
    if(fnam.Len()>800) fnam.Truncate(800);
    if(fnam.empty()) return;
    // auf notexist testen
    if(! wxFile::Exists(fnam))
    {
        throwout(_("Fehler, Datei existiert nicht!\n Tue Nichts!"));
        return;
    }
    strcpy( fnambuff, (const char*)fnam.mb_str(wxConvLocal) );// schreibt den Filenamen in fnambuff rein
    // domain holen
    gdom.el_from_file(fnambuff);
    //Ausgabe der size
    message.Printf(_(" Hat Gruppenordnung \n von %i bytes"), (int) gdom.q.size);
    message= _("Domain: ") + gdom.name +message;
    //kleiner Test
    if(gdom.d0.is_in_ellipse(&(gdom))) message += _("\n einfacher Test: d0 ist in elliptic curve!");
    else  message += _("\n einfacher test versagt: d0 ist NICHT! in elliptic curve!\n Abbruch empfohlen!");
    throwout(message);
    currdom_ctrl->SetValue(gdom.name);
    res_ctrl->SetValue(_("Noch nicht geprueft"));
        //chang color to neutral
    res_ctrl->SetBackgroundColour(neutcol);
}
/************************************************************/
void elliptic_verify::OnCancExit(wxCommandEvent& event)
{
    Close();
}
/***********************************************************/
void elliptic_verify::OnFilenameEdit(wxCommandEvent& event)
{
    wxString pfnam,signam;

    pfnam=file_ctrl->GetLineText(0);
    signam= pfnam + _(".ecsg");

    sigfil_ctrl->SetValue(signam);
    res_ctrl->SetValue(_("Noch nicht geprueft"));
        //chang color to neutral
    res_ctrl->SetBackgroundColour(neutcol);
        //check for presence
    if(!wxFile::Exists(signam))
    throwout(_("Achtung!\nDie angegebene Signaturdatei\nfehlt im Verzeichnis der Datei!\nVerification nicht moeglich."),10);
    else  cur_doc_path= ((wxFileName)fnam).GetPath(); //get new path and store into cur_doc_path
    throwout(_("Signaturdate Name korrigiert!"),1.5);
}
/***********************************************************/

