/*
 *   Copyright (C) 2011-2012, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */


#ifndef DELETEPUBELLKY_H
#define DELETEPUBELLKY_H

//(*Headers(DeletePubEllky)
#include <wx/sizer.h>
#include <wx/stattext.h>
#include <wx/listbox.h>
#include <wx/button.h>
#include <wx/dialog.h>
#include <wx/timer.h>
//*)

#include "globals.h"

class DeletePubEllky: public wxDialog
{
	public:

		DeletePubEllky(wxWindow* parent,wxWindowID id=wxID_ANY,const wxPoint& pos=wxDefaultPosition,const wxSize& size=wxDefaultSize);
		virtual ~DeletePubEllky();

		//(*Declarations(DeletePubEllky)
		wxButton* Button4;
		wxButton* Button1;
		wxStaticText* StaticText1;
		wxStaticText* StaticText3;
		wxButton* Button2;
		wxButton* Button6;
		wxButton* Button5;
		wxButton* Button3;
		wxButton* Button7;
		wxButton* Exp_key_ctrl;
		wxTimer Timer1;
		wxListBox* ListBox1;
		//*)
        wxArrayString ids; // da werden die Listbox-Einträge abgelegt



	protected:

		//(*Identifiers(DeletePubEllky)
		static const long ID_BUTTON2;
		static const long ID_STATICTEXT1;
		static const long ID_STATICTEXT3;
		static const long ID_EXP_BUTTON;
		static const long ID_BUTTON3;
		static const long ID_BUTTON5;
		static const long ID_BUTTON4;
		static const long ID_BUTTON6;
		static const long ID_BUTTON7;
		static const long ID_BUTTON1;
		static const long ID_LISTBOX1;
		static const long ID_TIMER1;
		//*)

	private:

		//(*Handlers(DeletePubEllky)
		void Import_el_pubky(wxCommandEvent& event);
		void OnExit(wxCommandEvent& event);
		void OnDeleteKey(wxCommandEvent& event);
		void OnTimer1Trigger(wxTimerEvent& event);
		void OnExp_Click(wxCommandEvent& event);
		void OnButtonOneup(wxCommandEvent& event);
		void OnOnedown(wxCommandEvent& event);
		void OnToTop(wxCommandEvent& event);
		void OnToBottom(wxCommandEvent& event);
		//*)

        bool setkylist(el_pub ***ppt,int *pkeyno);
        bool storkylist(el_pub **ppt, int keyno);
        int half_min_counter;
        bool nostop;


		DECLARE_EVENT_TABLE()

};

#endif
