/*
 *   Copyright (C) 2011-2017, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#if defined(__WXMSW__)
  //to be filled
#else
 #include <sys/mman.h>  //allow for memory locking of keyinfo
#endif



#include <wx/msgdlg.h>
#include <wx/filedlg.h>
#include <wx/file.h>
#include <wx/filefn.h>
#include <time.h>

//(* InternalHeaders(clean_pointersFrame)
#include <wx/intl.h>
#include <wx/string.h>



#include <wx/string.h>
#include <wx/file.h>
#include <wx/intl.h>
#include <wx/msgdlg.h>

#include "random_clx.h"
#include "globals.h"
#include "AskInput.h"

/************************** random pool functions  ********************/
rpool::rpool()
{
  wxString fnam;

  isvirgin=true;
  age=0;
  readcnt=0;
  cntnt.storlong(42);
  cntnt.size=1;
  cntnt2.copynum(&cntnt);
  lifespan=2;
  return;
}
/************************************************************************/
bool rpool::delayed_init_rpool()
{
  wxString fnam,xline;
  char cfl=0;
  bool near_empty;
  //int ar;

  if(wxFileExists(sec_path + _("/randpool.rnpl")))
  {
      if(restore_rand_class(sec_path + _("/randpool.rnpl")))
      {
        isvirgin=false;
        return true;
      }
  }
  throwout(_("Random Pool needs secure initialisation for proper hatching!\nSelect file to initialize from\ne.g.choose an arbitrary picture YOU took recently\nwhich has never been published anywhere\n and which is bad enough to be deleted afterwards ;-)"));
  isvirgin=true;
  age=0;
  readcnt=0;
  cntnt.storlong(42);
  cntnt.setsize(true);
  cntnt2.copynum(&cntnt);
  setlifespan();
  if(lifespan<2) lifespan=2;
  do{
        fnam = wxFileSelector(_("Choose a file to prime random class"));
        if(fnam.IsEmpty())
        {
            throwout(_("you didn't select a file!\nAcademic Signature will be closing down"),10);
            return false; //dialog cancelled
        }
        if(! wxFileExists(fnam))throwout(_("Error, File does not exist!\nSelect somethin reasonable!!"));
        if(cfl>2)
        {
            throwout(_("no success after four attempts\nAcademic Signature will be closing down"),10);
            return false; //schon zwei mal falsch versucht
        }

        near_empty=false;
        wxFile myfil(fnam);
        if(myfil.Length() < 3)
          {
            near_empty=true;
            throwout(_("Error, File is empty (or near empty)\nselect something reasonable!!"));
          }
        myfil.Close();
        cfl++;
  } while( near_empty||fnam.IsEmpty()||(! wxFileExists(fnam)) );

  if(!set_pool_from_file(fnam, POOL_SIZE)) //error occurred
  {
    throwout(_("somehow everything failed \n-> surrender!"),3);
  }
  else isvirgin=false;

  return true;
}
/************************************************************************/
rpool::~rpool()
{
    if(!isvirgin)
    {
      //stor_rand_class(); done in main frame-procedure now
      cntnt.wipezero();
      cntnt2.wipezero();
    }
}
/*************************************************************************/
bool rpool::stor_rand_class(wxString fnam)
{
    timerefresh();
    //verschl
    cntnt.lonu_lock(&zugang, _("Fleas_l"));
    //und nach secrets/randpool.rnpl speichern
    cntnt.lonu_to_file(fnam);
    cntnt.lonu_unlock(&zugang, _("Fleas_l"));

    return true;
}
/*************************************************************************/
/*************************************************************************/
bool rpool::restore_rand_class(wxString fnam)
{
    bool near_empty, rnd_ok=true;
    longnumber h;
    int ar,cnt=0,fll;
    wxString xline;
    //check, ob file in reasonable length vorhanden
    if(!wxFileExists(fnam)) rnd_ok=false;
    else
      {
          wxFile myfil(fnam);
          if(myfil.Length() < POOL_SIZE -4) rnd_ok=false;
          if(myfil.Length() > POOL_SIZE +300) rnd_ok=false;
          myfil.Close();
        }
    if(!rnd_ok) //neuinitialisieren
    {
       throwout(_("random pool has not been found or seems damaged...\nselect file to initialize pool from\ne.g.choose an arbitrary picture YOU took recently\nwhich has never been published anywhere\nand which is bad enough to be deleted afterwards ;-)"));
       do{
          fnam = wxFileSelector(_("Choose a file to prime random class"));
          if(! wxFileExists(fnam))
          {
            throwout(_("Error, File does not exist \n select something reasonable!!"));
            cnt++;
          }
          near_empty=false;
          wxFile myfil(fnam);
          if(myfil.Length() < 3)
          {
            near_empty=true;
            throwout(_("Error, File is empty (or near empty)\nselect something reasonable!!"));
            cnt++;
          }
          myfil.Close();
       }  while( (near_empty||fnam.empty()||(! wxFileExists(fnam))) &&(cnt<4) );
       if(cnt==4)
       {
           throwout(_("Giving up after 3 unsuccessful attemts for selecting ANY File  aargh!\n System is in insecure state!!! "),4);
           isvirgin=true;
           return false;
       }

       if(!set_pool_from_file(fnam, POOL_SIZE)) //initialize pool
       {
           throwout(_("severe failure\n could not prime random pool"),5);
           return false;
       }
       throwout(_("pool preset from filename."),1);
       isvirgin=false;

  //ask for additional chars and use
        AskInput dialog(NULL,_("Type some mixed arbitrary charcters, no need to memorize."), &xline);
        ar=dialog.ShowModal();
        if(ar==1) sexwith(xline);
        else{throwout(_("Warning\nno additional entropy from char-line given"),2);}
        setlifespan();
        timerefresh();
        if(!develop(1)) {throwout(_("warning!\n developing pool not successful!")); return false;}
       age=0;
       readcnt=0;
       return true;
    }
    //if reasonable do this:
    cntnt.lonu_from_file(fnam);//read in pool from file
    isvirgin=false;
    //entschl
    cntnt.lonu_unlock(&zugang, _("Fleas_l")); //decipher to regain state when stored last time
    cntnt.resizelonu(POOL_SIZE,false); //if any size change had happened, reform to standard size
    cntnt.setsize(true);
    timerefresh();  //remingle with current time to separate pool from past state
        //writeout immediately
    h.copynum(&cntnt); //copy to helpervar h
    h.lonu_lock(&zugang, _("Fleas_l")); //encrypt h
    h.lonu_to_file(fnam); //write to file in new state(encrypted)
    setlifespan();
    sexwith(&h,cntnt.length); //mix with written cipher to get cryptographically separated new pool
    cntnt2.copynum(&cntnt);  //copy to consumable pool
    cntnt2.setsize(true);  //housekeeping for longnumber soundness
    //now develop consumable pool to separate from rootpool
    if(!develop_ls((char *)(cntnt2.ad), (int)(cntnt2.length), 2,2,13,3))  //2:rounds, 2 paths, 13:spice, 3:increment
    {
        throwout(_("Error in developing cntnt2"));
        return false;
    }
    //lock random pool to ram
  #if defined(__WXMSW__)
    fll=VirtualLock(cntnt.ad,POOL_SIZE);
    fll=VirtualLock(cntnt2.ad,POOL_SIZE);
  #else
    fll=mlock(cntnt.ad,POOL_SIZE);
    fll=mlock(cntnt2.ad,POOL_SIZE);
  #endif
    age=0;
    readcnt=0;
    return true;
}
/*************************************************************************/
bool rpool::set_pool_from_file(wxString fnam, unsigned long pool_len) //initialize pool
{
  bool result;
  wxString xline;
  int ar,fll;

  result=get_lonu_hash_from_filename_x(&cntnt,&fnam, (unsigned int) pool_len, _("Fleas_lb"));
  if(!result) throwout(_("error creating pool from file\ngoing on anyways..."),3);
  else isvirgin=false;
  result=stor_rand_class(  sec_path +_("/randpool.rnpl"));
  if(!result) throwout(_("error storing random pool"));
  //isvirgin=false;

 //ask for additional chars and use
  AskInput dialog(NULL,_("Type arbitrary charcters into here and forget them."), &xline);
  ar=dialog.ShowModal();
  if(ar==1) sexwith(xline);
  else{throwout(_("Warning\nno additional entropy from char-line given"),2);}
  timerefresh();
  if(!develop(1)) {throwout(_("warning!\n developing pool not successful!")); return false;}
  //lock random pool to RAM
  #if defined(__WXMSW__)
        //to be filled
  #else
    fll=mlock(cntnt.ad,POOL_SIZE);
    fll=mlock(cntnt2.ad,POOL_SIZE);
  #endif

  age=0;
  readcnt=0;
  return true;
 }
/************************************************************************/
unsigned char rpool::get_rbyte() //get one random byte
{
    unsigned char retval;

    //if(isvirgin) delayed_init_rpool();
    retval =*(cntnt2.ad+readcnt);
    readcnt++;
    if((unsigned long)readcnt>= cntnt2.size-3) //if getting close to limit
    {
        develop(1);  //refresh consumable pool
        readcnt=0;
    }
  return retval;
}
/************************************************************************/
unsigned long rpool::get_ulong()
{
    unsigned long h;
    bool fl;

    if(isvirgin) delayed_init_rpool();
    fl=push_bytes(4, (unsigned char *) &h);
    return h;
}
/************************************************************************/
unsigned int rpool::get_uint()
{
    unsigned int h;

    if(isvirgin) delayed_init_rpool();
    push_bytes(2, (unsigned char *) &h);
    return h;
}
/************************************************************************/
bool rpool::p_makerandom(longnumber *lnad,unsigned long byteno)
{
  bool fl;

  if(isvirgin) delayed_init_rpool();
  lnad->resizelonu(byteno,0);
  fl=push_bytes(byteno,lnad->ad);
  return fl;
}
/************************************************************************/
bool rpool::develop(int steps)
{
    bool retval;

    cntnt.setsize(true);  //housekeeping for root pool, just in case...
    if(SEC_LEV >1) //for enhanced security level
    {
        retval=develop_o((char *) (cntnt.ad), (int)(cntnt.length), steps,2,2); //develop root pool with old paranoia-level, steps rounds(1), 2 paths, full set of developers
        cntnt2.copynum(&cntnt); //copy to consumable pool
        cntnt2.setsize(true);  //longnumber housekeeping
        develop_ln2((char *) (cntnt2.ad), (int)(cntnt2.length), steps,3,13,5);//separate consumable from rootpool, 3 paths, spice 13 incr 5
    }
    else  //sufficient security level
    {
        retval=develop_a((char *) (cntnt.ad), (int)(cntnt.length), steps); //simple development of root pool
        cntnt2.copynum(&cntnt);
        cntnt2.setsize(true);
        develop_c((char *) (cntnt2.ad), (int)(cntnt2.length), steps+1);
    }
    if (retval)
    {
        age++;
        if(age>lifespan)
        {
            timerefresh();
            age=0;
        }
    }
    else
    {
        throwout(_("Alert! Error in PRNG development!\n stop crypto-ops immediately!\nrestart aca_sig and \nmanually refresh PRNG! "));
    }
  return retval;
}
/************************************************************************/
bool rpool::key_develop(int steps, longnumber* kyad, unsigned long newsize)
{
    bool retval;

    if(newsize==0) newsize= cntnt.length;
    retval=cntnt.randomize_o(steps,kyad,newsize);
    //also refresh derived pool
    refresh_consumable(2);
    //lifespan neu setzen
    age=0;
    readcnt=0;
    setlifespan();
    return retval;
}
/************************************************************************/
bool rpool::sexwith(unsigned long* pmate, unsigned long childsize)
{
    bool retval;
    longnumber mate;

    if(childsize==0) childsize= cntnt.length;
    mate.storlong(*pmate);
    retval=cntnt.randomize_o(3,&mate,childsize);
    //also refresh derived pool
    refresh_consumable(2);
        //lifespan neu setzen
    age=0;
    readcnt=0;
    setlifespan();
    return retval;
}
/************************************************************************/
bool rpool::refresh_consumable(int steps)
{

    if(SEC_LEV >1) //for enhanced security level
    {
        cntnt2.copynum(&cntnt); //copy to consumable pool
        cntnt2.setsize(true);  //longnumber housekeeping
        develop_ln2((char *) (cntnt2.ad), (int)(cntnt2.length), steps,3,11,3);//separate consumable from rootpool, 3 paths, spice 13 incr 5
    }
    else  //sufficient security level
    {
        cntnt2.copynum(&cntnt);
        cntnt2.setsize(true);
        develop_c((char *) (cntnt2.ad), (int)(cntnt2.length), steps+1);
    }
    return true;
}
/************************************************************************/
bool rpool::sexwith(longnumber* pmate, unsigned long childsize)
{
    bool retval;

    if(childsize==0) childsize= cntnt.length;
    retval=cntnt.randomize_o(3,pmate,childsize);
    //also refresh derived pool
    refresh_consumable(2);
    //lifespan neu setzen
    age=0;
    readcnt=0;
    setlifespan();
    return retval;
}
/************************************************************************/
bool rpool::sexwith(wxString mate, unsigned long childsize)
{
    bool retval;
    longnumber h;

    if(childsize==0) childsize= cntnt.length;
    h.stortext(&mate);
    retval=cntnt.randomize_o(3,&h,childsize);
    //also refresh derived pool
    refresh_consumable(2);
    age=0;
    readcnt=0;
    setlifespan();
    return retval;
}
/************************************************************************/
bool rpool::push_bytes(int byteno, unsigned char* destination)
{
    int i;

    if(isvirgin) delayed_init_rpool();
    for(i=0;i<byteno;i++)
    {
        *(destination+i)=get_rbyte();
    }
  return true;
}
/************************************************************************/
bool rpool::timerefresh() //mingle with current time data
{
    unsigned long seconds;

    if(isvirgin) delayed_init_rpool();
    seconds=time(NULL);
    //sexwith also refreshes consumable
    return sexwith(&seconds,POOL_SIZE);
}
/************************************************************************/
bool rpool::setlifespan()
{
    unsigned long h;
    int i;

    //1/4 wurzel  cntnt
    cntnt.setsize(true);
    h=cntnt.size/4;
    if(h>4) //jenseits von gut und boese
    {
        lifespan= 256*256*256*127;
        return true;
    }
    lifespan=1;
    for(i=h-1;i>0;i--)
    {
        lifespan*=256;
    }
    if(lifespan<10) lifespan =10; //mindestens 10
    return false;
}
/*******************************************************************/
long double rpool::chisqtest()
{
    long double zwi,akku=0;
    unsigned long obs[256];
    unsigned long i,j,expc;
    unsigned char byt;
    unsigned long outlop=100, inlop=25600;
    wxString mesg;


    for(j=0;j<256;j++) obs[j]=0;
    for(j=0;j<outlop;j++)
    {
        for(i=0;i<inlop;i++)
        {
            byt= get_rbyte();
            obs[byt]++;
        }
    }
    //auswertung
    expc=outlop*inlop/256;
    for(i=0;i<256;i++)
    {
        zwi=(long double)obs[i]-(long double)expc;
        zwi *=zwi;
        zwi=zwi/(long double) expc;
      akku += zwi;
    }
    mesg.Printf(_("Ciquad value is: %lf \n alfa=0.05 threshhold is 294"),(double)akku);
    throwout(mesg);
akku=0;
    //zum Vergleich
    for(j=0;j<256;j++) obs[j]=0;
    for(j=0;j<outlop;j++)
    {
        for(i=0;i<inlop;i++)
        {
            byt= (unsigned char) (rand()&255);
            obs[byt]++;
        }
    }
    //auswertung
    expc=outlop*inlop/256;
    for(i=0;i<256;i++)
    {
        zwi=(long double)obs[i]-(long double)expc;
        zwi *=zwi;
        zwi=zwi/(long double) expc;
      akku += zwi;
    }
    mesg.Printf(_("Ciquad value of standard rand() is: %lf \n alfa=0.05 threshhold is 294"),(double)akku);
    throwout(mesg);
    return akku;
}
/**********************************************************************************/


