/*
 *   Copyright (C) 2011-2012, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */


#ifndef GPG_VERIFY_H
#define GPG_VERIFY_H

//(*Headers(gpg_verify)
#include <wx/dialog.h>
#include <wx/sizer.h>
#include <wx/button.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>
#include <wx/timer.h>
//*)

#include <wx/colour.h>


class gpg_verify: public wxDialog
{
	public:

		gpg_verify(wxWindow* parent,wxWindowID id=wxID_ANY,const wxPoint& pos=wxDefaultPosition,const wxSize& size=wxDefaultSize);
		virtual ~gpg_verify();

		//(*Declarations(gpg_verify)
		wxTextCtrl* result_ctrl;
		wxButton* Button1;
		wxButton* Button2;
		wxButton* Button3;
		wxStaticText* StaticText1;
		wxTimer Timer1;
		wxTextCtrl* kylabl_ctrl;
		wxStaticText* StaticText3;
		wxButton* Button5;
		wxTextCtrl* signam_ctrl;
		wxStaticText* StaticText4;
		wxStaticText* StaticText2;
		wxButton* Button6;
		wxTextCtrl* pubkyid_ctrl;
		wxTextCtrl* fnam_ctrl;
		//*)

        wxColor redcol,grencol,neutcol;


	protected:

		//(*Identifiers(gpg_verify)
		static const long ID_BUTTON1;
		static const long ID_STATICTEXT1;
		static const long ID_STATICTEXT3;
		static const long ID_TEXTCTRL2;
		static const long ID_BUTTON5;
		static const long ID_STATICTEXT2;
		static const long ID_TEXTCTRL1;
		static const long ID_BUTTON2;
		static const long ID_STATICTEXT4;
		static const long ID_TEXTCTRL4;
		static const long ID_TEXTCTRL5;
		static const long ID_BUTTON6;
		static const long ID_BUTTON3;
		static const long ID_TEXTCTRL3;
		static const long ID_TIMER1;
		//*)

	private:

		//(*Handlers(gpg_verify)
		void OnDone(wxCommandEvent& event);
		void OnSelSigfile(wxCommandEvent& event);
		void Onrefresh_docname(wxCommandEvent& event);
		void OnDoVerify(wxCommandEvent& event);
		void OnImport(wxCommandEvent& event);
		void OnCheckPresence(wxCommandEvent& event);
		void OnSelectPubkey(wxCommandEvent& event);
		void OnSelDocument(wxCommandEvent& event);
		void OnTimer1Trigger(wxTimerEvent& event);
		//*)


		bool neutralize();
		bool tellerror;

		DECLARE_EVENT_TABLE()
};

#endif
