/*
 *   Copyright (C) 2011-2019, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */


#include <wx/string.h>

#include "gpg_wrap.h"
#include "gpg_manag_priv.h"
#include "helpersxx.h"
#include "gnupg_globals.h"
#include "globals.h"
#include "gpg_new_keyDialog.h"

//(*InternalHeaders(gpg_manag_priv)
#include <wx/string.h>
#include <wx/intl.h>
#include <wx/font.h>
//*)

//(*IdInit(gpg_manag_priv)
const long gpg_manag_priv::ID_BUTTON1 = wxNewId();
const long gpg_manag_priv::ID_STATICTEXT1 = wxNewId();
const long gpg_manag_priv::ID_BUTTON5 = wxNewId();
const long gpg_manag_priv::ID_LISTBOX1 = wxNewId();
const long gpg_manag_priv::ID_BUTTON4 = wxNewId();
const long gpg_manag_priv::ID_BUTTON3 = wxNewId();
const long gpg_manag_priv::ID_BUTTON6 = wxNewId();
const long gpg_manag_priv::ID_BUTTON2 = wxNewId();
//*)

BEGIN_EVENT_TABLE(gpg_manag_priv,wxDialog)
	//(*EventTable(gpg_manag_priv)
	//*)
END_EVENT_TABLE()
/****************************************************************************/
gpg_manag_priv::gpg_manag_priv(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{

	//(*Initialize(gpg_manag_priv)
	wxFlexGridSizer* FlexGridSizer1;

	Create(parent, id, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("id"));
	FlexGridSizer1 = new wxFlexGridSizer(0, 2, 0, 0);
	Button1 = new wxButton(this, ID_BUTTON1, _("Exit"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON1"));
	Button1->SetBackgroundColour(wxColour(253,173,133));
	wxFont Button1Font(11,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button1->SetFont(Button1Font);
	FlexGridSizer1->Add(Button1, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	StaticText1 = new wxStaticText(this, ID_STATICTEXT1, _("Manage GnuPG private Keys\nSelect key and action."), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT1"));
	wxFont StaticText1Font(13,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText1->SetFont(StaticText1Font);
	FlexGridSizer1->Add(StaticText1, 1, wxALL|wxALIGN_BOTTOM|wxALIGN_CENTER_HORIZONTAL, 5);
	Button5 = new wxButton(this, ID_BUTTON5, _("Export\nprivate key"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON5"));
	wxFont Button5Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button5->SetFont(Button5Font);
	FlexGridSizer1->Add(Button5, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	keylist_ctrl = new wxListBox(this, ID_LISTBOX1, wxDefaultPosition, wxSize(515,186), 0, 0, 0, wxDefaultValidator, _T("ID_LISTBOX1"));
	keylist_ctrl->SetFocus();
	wxFont keylist_ctrlFont(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	keylist_ctrl->SetFont(keylist_ctrlFont);
	FlexGridSizer1->Add(keylist_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	Button4 = new wxButton(this, ID_BUTTON4, _("Select for\nsigning"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON4"));
	wxFont Button4Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button4->SetFont(Button4Font);
	FlexGridSizer1->Add(Button4, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	Button3 = new wxButton(this, ID_BUTTON3, _("Delete private\nkey"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON3"));
	wxFont Button3Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button3->SetFont(Button3Font);
	FlexGridSizer1->Add(Button3, 1, wxALL|wxALIGN_RIGHT|wxALIGN_BOTTOM, 5);
	Button6 = new wxButton(this, ID_BUTTON6, _("Import\n key"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON6"));
	wxFont Button6Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button6->SetFont(Button6Font);
	FlexGridSizer1->Add(Button6, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	Button2 = new wxButton(this, ID_BUTTON2, _("Make new"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON2"));
	wxFont Button2Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button2->SetFont(Button2Font);
	FlexGridSizer1->Add(Button2, 1, wxALL|wxALIGN_RIGHT|wxALIGN_BOTTOM, 5);
	SetSizer(FlexGridSizer1);
	FlexGridSizer1->Fit(this);
	FlexGridSizer1->SetSizeHints(this);

	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&gpg_manag_priv::OnExit);
	Connect(ID_BUTTON5,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&gpg_manag_priv::OnExportSecret);
	Connect(ID_LISTBOX1,wxEVT_COMMAND_LISTBOX_DOUBLECLICKED,(wxObjectEventFunction)&gpg_manag_priv::OnExit);
	Connect(ID_BUTTON4,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&gpg_manag_priv::OnEdit);
	Connect(ID_BUTTON3,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&gpg_manag_priv::OnDelete);
	Connect(ID_BUTTON6,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&gpg_manag_priv::OnImportPrivate);
	Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&gpg_manag_priv::OnMakeNew);
	//*)

    if(get_priv_labels()>0)	keylist_ctrl->InsertItems(kylabel, 0);
    else{
            throwout(_("No private Key present!\nPlease Create one using GnuPG directly first.\nAborting!"),3);
            Close();
            return;
        }

}

gpg_manag_priv::~gpg_manag_priv()
{
	//(*Destroy(gpg_manag_priv)
	//*)
}


void gpg_manag_priv::OnMakeNew(wxCommandEvent& event)
{
    int ret;
    gpg_new_keyDialog dialog(this);
    ret=dialog.ShowModal();
    if(ret==1)
    {
               if(    get_priv_labels()>0)
               {
                    keylist_ctrl->Set(kylabel);
                    keylist_ctrl->Select(0);
               }
               else throwout(_("error in Make Key,\n should not occur?!?"));
    }
}
/*************************************************************/
void gpg_manag_priv::OnEdit(wxCommandEvent& event) //
{
    int selected;
    // read out the selected key
    selected=keylist_ctrl->GetSelection();
    if(selected!=wxNOT_FOUND)
    {
           privkey=kyid[selected];
           pk_sel=selected;
           EndModal(1);
           return;
    }
    else{ throwout(_("nothing selected!"),2);}
    return;
}
/************************************************************/
void gpg_manag_priv::OnDelete(wxCommandEvent& event)
{
    int selected;
    // read out the selected key
    selected=keylist_ctrl->GetSelection();
    if(selected!=wxNOT_FOUND)
       {
           privkey=kyid[selected];
           pk_sel=selected;
           if(gpg_remove_privkey(kyfprint[selected]))
           {
               if(    get_priv_labels()>0)
               {
                    keylist_ctrl->Set(kylabel);
                    keylist_ctrl->Select(0);
               }
               else throwout(_("error in Delete Key,\n should not occur?!?"));
           }
       }
    else throwout(_("No key selected!"),1);
    return;
}

void gpg_manag_priv::OnExit(wxCommandEvent& event)
{
    int selected;
    // read out the selected key
    selected=keylist_ctrl->GetSelection();
    if(selected!=wxNOT_FOUND)
    {
        pk_sel=selected;
        privkey=kyid[selected];
    }
    EndModal(1);
    return;
}

void gpg_manag_priv::OnExportSecret(wxCommandEvent& event)
{
    wxString filnam;
   int selected;
    // read out the selected key
    selected=keylist_ctrl->GetSelection();
    if(selected!=wxNOT_FOUND)
       {
           privkey=kyid[selected];
           pk_sel=selected;
           filnam=kylabel[selected] + _(".asc");
           filnam.Replace(_(" "), _("_"),true);
           filnam=wxFileSelector(_("select output filename"), kytray, filnam,_("asc"),_("asc files (*.asc)|*.asc|All files (*.*)|*.*)"),wxFD_SAVE);
           if(gpg_export_privkey(filnam,privkey))
           {
               if(!wxFileExists(filnam))
               throwout(_("Private key not exported"),1);
           }
           else throwout(_("Warning:no export!"),2);
       }
    else throwout(_("No key selected!"),1);
    return;
}

void gpg_manag_priv::OnImportPrivate(wxCommandEvent& event)
{
    wxString kyfnam;

    kyfnam= wxFileSelector(_("Select a private key file"),kytray,_(""),_("asc|"),_("asc file (*.asc)|*.asc|all files(*.*)|*.*"));
    if(kyfnam.IsEmpty()) return;
    if(!wxFileExists(kyfnam)){throwout(_("Signature file does not exist"),2); return;}
    if(!gpg_import_privkey(kyfnam)) {throwout(_("Import failed!"),2); return;}
    keylist_ctrl->Set(kylabel);
    if(kylabel.GetCount()>0)
            keylist_ctrl->SetSelection(kylabel.GetCount()-1);
    return;
}
