/***************************************************************
 * Name:      clean_pointersMain.cpp
 * Purpose:   Code for Application Frame
 * Author:    mca (an@fh-wedel.de)
 * Created:   2010-09-14
 * Copyright: mca ()
 * License:
 *   Copyright (C) 2011-2019, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */



#if defined(__WXMSW__)
  //to be filled
#else
 #include <sys/mman.h>  //allow for memory locking of keyinfo
#endif


#include "ellky_load1.h"

//(*InternalHeaders(ellky_load1)
#include <wx/string.h>
#include <wx/intl.h>
#include <wx/font.h>
//*)

#include "globals.h"
//(*IdInit(ellky_load1)
const long ellky_load1::ID_BUTTON1 = wxNewId();
const long ellky_load1::ID_STATICTEXT1 = wxNewId();
const long ellky_load1::ID_STATICTEXT2 = wxNewId();
const long ellky_load1::ID_BUTTON2 = wxNewId();
const long ellky_load1::ID_LISTBOX1 = wxNewId();
const long ellky_load1::ID_TIMER1 = wxNewId();
//*)

BEGIN_EVENT_TABLE(ellky_load1,wxDialog)
	//(*EventTable(ellky_load1)
	//*)
END_EVENT_TABLE()
/*******************************************************************************/
ellky_load1::ellky_load1(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
    FILE *knfp;
    char buff1[2002], buff2[2002];
    int lbl,count;

    if(!checkarm()){Close();}

	//(*Initialize(ellky_load1)
	wxFlexGridSizer* FlexGridSizer1;
	Create(parent, id, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxALWAYS_SHOW_SB, _T("id"));
	SetForegroundColour(wxColour(170,2,2));
	SetBackgroundColour(wxColour(253,229,229));
	FlexGridSizer1 = new wxFlexGridSizer(0, 2, 0, 0);
	Button1 = new wxButton(this, ID_BUTTON1, _("Exit/Cancel"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON1"));
	Button1->SetBackgroundColour(wxColour(243,181,181));
	wxFont Button1Font(11,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button1->SetFont(Button1Font);
	FlexGridSizer1->Add(Button1, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	StaticText1 = new wxStaticText(this, ID_STATICTEXT1, _("Select Private elliptic\nkey to load"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT1"));
	StaticText1->SetForegroundColour(wxColour(142,14,14));
	StaticText1->SetBackgroundColour(wxColour(242,162,162));
	wxFont StaticText1Font(11,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText1->SetFont(StaticText1Font);
	FlexGridSizer1->Add(StaticText1, 1, wxALL|wxALIGN_TOP|wxALIGN_CENTER_HORIZONTAL, 5);
	FlexGridSizer1->Add(20,10,1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	StaticText2 = new wxStaticText(this, ID_STATICTEXT2, _("closing in 30 seconds"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT2"));
	wxFont StaticText2Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText2->SetFont(StaticText2Font);
	FlexGridSizer1->Add(StaticText2, 1, wxALL|wxALIGN_TOP|wxALIGN_CENTER_HORIZONTAL, 5);
	Button2 = new wxButton(this, ID_BUTTON2, _("Load Selected\n Private Key"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON2"));
	Button2->SetBackgroundColour(wxColour(248,210,210));
	wxFont Button2Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button2->SetFont(Button2Font);
	FlexGridSizer1->Add(Button2, 1, wxALL|wxALIGN_TOP|wxALIGN_CENTER_HORIZONTAL, 5);
	ListBox1 = new wxListBox(this, ID_LISTBOX1, wxDefaultPosition, wxSize(331,407), 0, 0, 0, wxDefaultValidator, _T("ID_LISTBOX1"));
	ListBox1->SetForegroundColour(wxColour(161,3,3));
	wxFont ListBox1Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	ListBox1->SetFont(ListBox1Font);
	FlexGridSizer1->Add(ListBox1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	FlexGridSizer1->Add(-1,-1,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	SetSizer(FlexGridSizer1);
	Timer1.SetOwner(this, ID_TIMER1);
	Timer1.Start(30000, false);
	FlexGridSizer1->Fit(this);
	FlexGridSizer1->SetSizeHints(this);

	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&ellky_load1::OnExit);
	Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&ellky_load1::OnLoad);
	Connect(ID_LISTBOX1,wxEVT_COMMAND_LISTBOX_DOUBLECLICKED,(wxObjectEventFunction)&ellky_load1::OnLoad);
	Connect(ID_TIMER1,wxEVT_TIMER,(wxObjectEventFunction)&ellky_load1::OnTimeout);
	//*)
		    // zuerst Namensliste Laden
    wxArrayString wxstrad; //wxStringarray initialisieren
    if(S_FIL) unlockinplace(sec_path + _("/ell_knamfile.knf"),&zugang);
    knfp=fopen((const char*) (sec_path +_("/ell_knamfile.knf")).mb_str(wxConvLocal), "r");
    count=0;
    do{
        lbl=fscanf(knfp, " id: %500s Name: %500s \n",buff1,buff2);
        //in wxstrad einpflegen
        if(lbl==2) {
            wxstrad.Add( (wxString::FromUTF8(buff1)) + _("  ") + (wxString::FromUTF8(buff2)) );
            ids.Add(wxString::FromUTF8(buff1)); //ids ist eine class-variable
            count++;
        }
    }while(lbl == 2);
 	// Jetzt die Listbox initialisieren
    ListBox1->InsertItems(wxstrad,0);
    //als Menu in neuem Dialog anbieten und auswählen

    fclose(knfp);
    if(S_FIL) lockinplace(sec_path + _("/ell_knamfile.knf"),&zugang);
    keyselected=0;
}
/****************************************************************************************/
ellky_load1::~ellky_load1()
{
	//(*Destroy(ellky_load1)
	//*)
}
/*******************************************************************************/

void ellky_load1::OnExit(wxCommandEvent& event)
{
        EndModal(keyselected);
}
/*******************************************************************************/
void ellky_load1::OnLoad(wxCommandEvent& event)
{
    int indx, lbl,lbd,elfl,fll=-1;
    wxString idh,hlp;
    char buff[3000];
    el_priv loky;
    FILE *kfp;
    long int fpos;
    bool f;
    ellipse locell;

    if(!checkarm()){Close();}
    indx=ListBox1->GetSelection();
    if(indx<0)
    {
        throwout(_("nothing selected!\nDo nothing!"),3);
        return;
    }
    idh= ids.Item(indx);
    if(S_FIL) unlockinplace(sec_path + _("/ell_Keyfile.kyf"),&zugang); // unlock keynamefile
    kfp=fopen((const char*) (sec_path +_("/ell_Keyfile.kyf")).mb_str(wxConvLocal),"r");
    do{
        lbl=fscanf(kfp," id: %750s",buff);
        if( lbl ==1)
        {
          hlp= wxString::FromUTF8(buff);
          if(hlp != idh)
          {
             lbd=fscanf(kfp," Name: %750s ",buff);
             lbd=fscanf(kfp," DomainName: %750s ",buff);
             lbd=fscanf(kfp," d: %750s ",buff);
          }
        }
        if( lbl == EOF)
        { throwout(_("File read Error!"));
         fclose(kfp);
         if(S_FIL) lockinplace(sec_path + _("/ell_Keyfile.kyf"),&zugang); // lock keynamefile
           return;
        }
        if(lbl==0)
        {
             fpos=ftell(kfp);
             fpos++;
             fseek ( kfp , fpos , SEEK_SET );
        } else{
          //make wxstring from buff
          //hlp= wxString::FromUTF8(buff);  //already done
        }
    } while( hlp != idh);
    loky.id =idh;
    do{
        if(( (lbl=fscanf(kfp," Name: %750s",buff)) == EOF)||lbl==0)
        { throwout(_("Name read Error!"));
         fclose(kfp);
         if(S_FIL) lockinplace(sec_path + _("/ell_Keyfile.kyf"),&zugang); // lock keynamefile
           return;
        }
    } while(lbl != 1 );
    //make wxstring from buff
    hlp= wxString::FromUTF8(buff);
    //underscore durch blank ersetzen
    hlp.Replace(_("_"),_(" "));
    //buff Name nach privkey.rname schreiben
    loky.fullnam= hlp;
    //Domain Name:
    do{
        if(( (lbl=fscanf(kfp," DomainName: %750s",buff)) == EOF)||(lbl==0))
        { throwout(_("DomainName read Error!"));
         fclose(kfp);
         if(S_FIL) lockinplace(sec_path + _("/ell_Keyfile.kyf"),&zugang); // lock keynamefile
           return;
        }
    } while(lbl != 1 );
    //make wxstring from buff
    hlp= wxString::FromUTF8(buff);
    //buff Name nach privkey.rname schreiben
    loky.domnam= hlp;
//lesen der privaten Zahl d:
    do{
        if( (lbl=fscanf(kfp," d: %1500s",buff)) !=1 )
        { throwout(_("Privkey d read Error!"));
            fclose(kfp);
            if(S_FIL) lockinplace(sec_path + _("/ell_Keyfile.kyf"),&zugang); // lock keynamefile
            return;
        }
    } while( lbl != 1);
    // d in den globalen key schreiben
    hlp=wxString::FromUTF8(buff);
    if( !((loky.d).storhex(&hlp))){throwout(_("error reading d")); fclose(kfp);
         if(S_FIL) lockinplace(sec_path + _("/ell_Keyfile.kyf"),&zugang); // lock keynamefile
         return;}
    //doublecrypt: nochmal exstra entschlüsseln
    loky.d.lonu_unlock(&zugang);
    loky.d.setsize(); loky.d.shrinktofit();
    #if defined(__WXMSW__)
     fll=VirtualLock(loky.d.ad, loky.d.length);
    #else
        fll=mlock(loky.d.ad, loky.d.length);
    #endif

    fclose(kfp);
    if(S_FIL) lockinplace(sec_path + _("/ell_Keyfile.kyf"),&zugang); // lock keynamefile
    //testen auf korrekte domain
    if(gdom.name != loky.domnam)
    {
       throwout(_("warning! \n this key is intended for use with other than current domain!\nWill check if domain is accessible!"),2);
       elfl=e_ls.getelp(&locell,loky.domnam);
       if( elfl<0)
       {
           throwout(_("keydomain not accessible!\nwill wrecklessly adopt for use in current domain\n I recommend NOT TO USE This KEY, however"),20);
           loky.d.lonumodulo_qqq(&(gdom.q));
           loky.domnam=gdom.name;
           loky.id += _("x");
       }
    }
    else locell.copyell(&gdom);
    f=elky.set_el_priv(&(loky.d),&(locell),loky.id,loky.fullnam);

    throwout(_("new private key accepted."),2);
    keyselected=1;
    EndModal(keyselected);
}
/*******************************************************************************/

void ellky_load1::OnTimeout(wxTimerEvent& event)
{
    throwout(_("Timeout\nWindow closing."),3);
    EndModal(keyselected);
}
/************************************************************/
