/*
 *   Copyright (C) 2011-2015, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
//#ifndef WX28
//#define WX28
//#endif

#if (SIZEOF_UNSIGNED_INT -2)
  #define LINUX_64        //for 64 bit linux
#else
   #define LINUX_32      //for 32 bit linux or any windows
#endif



#ifndef DOLONUX_H
#define DOLONUX_H



//defines for my longnumber defaults
//#include "memdef.h"
#include <stdlib.h>
#include <time.h>

#include <wx/string.h>
#include <wx/file.h>

/**************************************************/
#define STARTLENGTH 	8
/*****************************************************/
// riesenzahl-Arithmetik
// die highbytes stehen bei hohen adressen(rechts), kleinstes bit ist das erste
#ifdef LINUX_64
typedef unsigned int ulong32;
typedef int long32;
#else
typedef unsigned long ulong32;
typedef long long32;
#endif
/* #ifdef LINUX_32
typedef unsigned long ulong32;
typedef long long32;
#endif */

/*****************************************************/
class  longnumber
{
public:
  longnumber(ulong32 len = STARTLENGTH);
  //Constructor - muß erstes Memory holen und belegen
  //speed: SLOW, NORMAL, QUICK
  ~longnumber(); // Destructor

  unsigned char  * ad; // Pointer auf das niederwertigste byte
  ulong32 length;  // Länge der Zahl in Byte
  ulong32 size;    //höchstes byte != 0
  long32 hibit;   //hoechstes bit(is signed !)
  bool trusiz;          //size und hibit sind korrekt
  bool israre;
  unsigned char *asum,*asub;


  bool try_rare();
  bool un_rare();
  bool isconsistent();
//consistency check


// neue chiffriermodule Begin
  bool lonu_enciph( longnumber *p_lnk, int kang_r=2, int frounds=4, wxString algo=_("Fleas_1_8"));
  // chiffriere lonu mit dancing fleas, frounds sind positiv für enc und negativ für deciph

  bool lonu_lock(longnumber *pky, wxString algo=_("Fleas_1_8")); // verschluesselt mit fleas 5,3
  bool lonu_unlock(longnumber *pky, wxString algo=_("Fleas_1_8")); // entschluesselt mit fleas 5,-3

  double dconvert();
  // Konvertiert in eine Double Precision Zahl

  bool maybeprime();
  //  Primzahltest nach Rabin&Miller ?

  bool isprime(int tries);
  //  Primzahl ?

  bool ggt(longnumber* b, longnumber* g);
  //Größter gemeinsamer Teiler mit b nach Euklid´s Algorithmus->resultat nach g

  bool get_mod_inv_q(longnumber* inv, longnumber* modul);

  bool get_mod_inv(longnumber* inv, longnumber* modul);
// bestimmt das module inverse bezgl. eines Prim_moduls,
//bei testprime>0 wir auch auf Primzahleigenschaft mit sicherheitsparameter max 5 getestet

  bool bezout(longnumber* b, longnumber* g, longnumber* s, longnumber* t);
  //Erweiterter Euklid´scher Algorithmus nach Bézout (Vielfachsummendarstellung)
  // g= s*a + b*t (s,t mod a*b)
  bool bezout_q(longnumber* b, longnumber* g, longnumber* s, longnumber* t);
  //Erweiterter Euklid´scher Algorithmus nach Bézout (Vielfachsummendarstellung)
  // g= s*a + b*t (s,t mod a*b)
  bool crt_combine(longnumber* p1, longnumber* xp1, longnumber* p2, longnumber* xp2, longnumber* pcomb );
  //kombiniert die Lösung kongruent zweier teilerfremder Zahlen modulo dem Produkt beider Zahlen
  //resultat kommt in this zurück

  void makerandom(int bytenumber);
  // setze zufallszahl
  void makerandom(longnumber* ceil);
  // setze zufallszahl kleiner als ceil
  bool appendnum(longnumber* pextnum);
  // anndere lonu anhaengen, terminating 0 embedded
  int addnum(longnumber* summand, longnumber* modul);
  //Einfache Summe modulo

  int addnum_q(longnumber* summand, longnumber* modul, int ckflag=1);
    //Summe modulo speed-optimiert

  int addnum(longnumber* summand);
  //Einfache Summe
  int addnum_rare(longnumber* summand);
  //Einfache Summe

  int addnum_q(longnumber* summand, int ckflag=1);
  //Einfache Summe
  int addnum_om(longnumber* summand, ulong32 offs=0, unsigned short mfac=1, int ckflag=1);
  //Einfache Summe modulo
  int addnum_om_bit(longnumber* summand, ulong32 offs=0, unsigned short mfac=1, int ckflag=1);
  //Einfache Summe modulo


  long32 get_lowest_one(); //hoechstes bit ab dieser byte-Zahl, echter index
// darf trusiz und hibit nicht anfassen, da universeller einsetzbar
  long32 get_hibit(); //setzt trusiz, size und hibit
  long32 get_hibit(ulong32 t_siz); //setzt trusiz, size und hibit
  inline long32 get_hibit_spec(ulong32 t_siz); //hoechstes bit ab dieser Zahl
// darf trusiz und hibit nicht anfassen, da universeller einsetzbar
  long32 gethighest_long(ulong32 *lp);
  // holt die hoechsten 32 bit ab, bei hibit 1 und stopft sie in den longzahl-pointer
  //gibt index des niedrigsten bis zurueck
  long32 gethighest_int(ulong32 *ip);
  // holt die hoechsten 16 bit ab, bei hibit 1 und stopft sie in den integer-pointer
 //gibt index des niedrigsten bis zurueck

  bool subtrnum_om(longnumber* subtrh, ulong32 bytoff=0, unsigned short mfac=1, int ckflag=1);
  bool subtrnum_om_bit(longnumber* subtrh, ulong32 bitoff=0, unsigned short mfac=1, int ckflag=1);
  bool subtrnum_om_bit_rare(longnumber* subtrh, ulong32 bitoff=0, unsigned short mfac=1, int ckflag=1);

  bool subtrnum_qx(longnumber* subtrh, long32 lowestone=-1);
  //Differenz, needs subtrh < lonum, False sonst

  bool subtrnum_q(longnumber* subtrh,ulong32 offs=0, bool sizing=true);
  //Differenz, needs subtrh < lonum, False sonst offs ist byteoffs
  bool subtrnum_q_b(longnumber* subtrh,ulong32 offs=0, bool sizing=true);
  //Differenz, needs subtrh < lonum, False sonst, offs ist bitoffs

  bool subtrnum_q(longnumber* subtrh, longnumber* modul);
  //Differenz, needs subtrh < lonum, False sonst

  bool subtrnum(longnumber* subtrh, longnumber* modul);
  //Einfache Differenz, nur wenn subtrh < lonum, False sonst

  bool subtrnum(longnumber* subtrh);
  //Einfache Differenz, nur wenn subtrh < lonum, False sonst
  bool subtrnum_rare(longnumber* subtrh,ulong32 offs=0);
  //Einfache Differenz für rare subtrahend, nur wenn subtrh < lonum, False sonst
  bool subtrnum_rare_b(longnumber* subtrh,ulong32 offs=0);
  //Einfache Differenz für rare subtrahend, nur wenn subtrh < lonum, False sonst

  bool resizelonu(ulong32 newlength, unsigned char flag=1);
  //neue Größe, name besser : relengthlonu ;-)
  // bei flag ==1 wird eine warnung bei trunc ausgegeben

  int divnum_qqq_e(longnumber* divsr, longnumber* remdr);
  //the ultimate ultimate speed
  //Int division mit einer longnumber (dritte optimierung

  inline unsigned short get_hi_short(longnumber *divsr, ulong32 *poffs);
  //get highest possible shortnumber ge hibit of this
  unsigned short get_hi_short();
  //get highest possible shortnumber

  int lonumodulo(longnumber* modul);
  //modulo bilden
  //return 0 wenn inaktiv, 1 wenn aktiv, -1 wenn error

  int lonumodulo_q(longnumber* modul);
  //modulo bilden
  //return 0 wenn inaktiv, 1 wenn aktiv, -1 wenn error
  int lonumodulo_qqq(longnumber* modul);
  //modulo bilden
  //return 0 wenn inaktiv, 1 wenn aktiv, -1 wenn error
  int lonumodulo_qqqq(longnumber* divsr);
  //return number of reductions, 0 wenn inaktiv
  int lonumodulo_qqq_e(longnumber* divsr);
  //return number of reduction-rounds, 0 wenn inaktiv

  int multnum(longnumber* fak1);
  int multnum_l(longnumber* fak1);
  int multnum_l(longnumber* fak1, longnumber* modul,longnumber *bufflong=NULL);
  //this one as fastest
  int multnum_l1(longnumber* fak1);
  int multnum_l1(longnumber* fak1, longnumber* modul,longnumber *bufflong=NULL);

  int k_mult_l1(longnumber* fak1, unsigned int thresh=64);
  int k_mult_l1(longnumber* fak1, longnumber* modul,longnumber *bufflong=NULL);
  //Karatsuba versions for long numbers

  int multnum_q(longnumber* fak1, longnumber* modul,bool incheck=true);
  //Produkt mit einer longnumber
  int multnum_q(longnumber* fak1);
  //Produkt mit einer longnumber
  int multnum_qq(longnumber* fak1, longnumber* modul);
  //Produkt mit einer longnumber  !langsamer, als _q
  int multnum_qq(longnumber* fak1);
  //Produkt mit einer longnumber
  int multnum_qqq(longnumber* fak1, longnumber* modul,bool incheck=true);
  //Produkt schnell mit kobitz-expansion
  int multnum_qqq_e(longnumber* fak1, longnumber* modul,bool incheck=true);
  //Produkt schnell mit kobitz-expansion
  int multnum_qqq_f(longnumber* fak1, longnumber* modul,bool incheck=true);
  //Produkt schnell mit kobitz-expansion
  int multnum_qqqq(longnumber* fak1, longnumber* modul,bool incheck=true);
  //Produkt schnell mit kobitz-expansion
  //int multmodul_l(longnumber* fak, longnumber* modul,longnumber *bufflong=NULL);
  //quadrieren und modul bilden

  int mult3mod( longnumber* modul);
  //Quickprodukt mit 3
  int quadmodul(longnumber* modul);
  //quadrieren und modul bilden
  int quadmodul_l(longnumber* modul,longnumber *bufflong=NULL);
  //quadrieren und modul bilden
  int quadmodul_l1(longnumber* modul,longnumber *bufflong=NULL);
  //quadrieren und modul bilden

  int quadmodul_q(longnumber* modul,bool incheck=true);
  //quadrieren und modul bilden
  int quadmodul_qq(longnumber* modul);
  //quadrieren und modul bilden
  int quadmodul_qqq(longnumber* modul,bool incheck=true);
  //quadrieren und modul bilden
  int quadmodul_qqqq(longnumber* modul,bool incheck=true);


  int pownum(longnumber* expon, longnumber* modul);
  //erheben zur expon´ten Potenz
  int pownum_q(longnumber* expon, longnumber* modul);
  //erheben zur expon´ten Potenz
  int pownum_pz(longnumber* expon, longnumber* modul);
  //erheben zur expon´ten Potenz die Panzerknackervariante

  int q_pownum(longnumber* expon, longnumber* p, longnumber* q);
  //effizientere version in der CRT representation

  bool test3mod4();
  // testet auf den Fall: Zahl ist kongruent 3 modulo 4

  bool root3m4( longnumber* p, longnumber* root, bool losolution);
    // gibt die Quadratwurzel modulo p zurück, wenn p=3 mod 4 und y^2 tats. ein quad

  ulong32 lconvert();
  //konv. die niedrigsten 4 byte to long

  bool lodoub_from_lonu(long double *z);
  // wandelt lonu in long double variable um und schreibt nach z

  bool lonu_from_lodoub(long double z);
  // wandelt long double in longnumber um

  bool sqrtnum(longnumber *lp=NULL);
// errechnet die Quadratwurzel (ohne modul)
// gibt true, wenn ein sauberes quadrat ist, false sonst

  bool sqrtest();

  ulong32 counteqlbytes(longnumber* refad);
  //zählt die Anzahl an identischen bytes

  bool storlong(ulong32 food);
  //füllt mit ulong32

  bool fillwith(char* wellad, long32 nobytes);
  //füllt mit ulong32

  bool storchar(wxString* text);
  //füllt mit dem konvertierten dezimalstring
  // Liest einen ZahlenString aus Text in Lonu ein

  bool storhex(wxString* text);  //this is the new one
  //bool storhex_q(wxString* text);
  //füllt mit dem konvertierten dezimalstring
  // Liest einen ZahlenString aus Text in Lonu ein


  bool stortext(wxString* text);
  // schreibt einen Text (ohne Konversion) blank in die lonu rein
  // und schneidet auf die neue Länge
  bool stortext_old(wxString* text);
  // schreibt einen Text (ohne Konversion) blank in die lonu rein
  // und schneidet auf die neue Länge

  bool writechar(wxString* text);
  //schreibt die Longnumber dezimal in den String

  bool writehex(wxString* text, bool highbyteleft=false);
  //schreibt die Longnumber hexagesimal in den String
  //wenn highbyteleft==true, dann in konventioneller Zahlenschreibweise

  bool writebin(wxString* text);
  //füllt mit dem konvertierten binärstring als einsen und nullen

  bool writewxstring(wxString* outtext, char flag=0);
  //schreibt den Puffer in den String hinein (ohne Kontrolle, sollte echter ascii-Text sein, sonst Salat!
  //wenn flag==0, kein eigenener output, bei flag ==1 extra outputfenster

  bool wipezero();
  //ueberschreibt mit nullen
  bool wipewith(unsigned char c);
  //ueberschreibt mit nullen

  int compare(longnumber* ar);
  //vergl.größe, 1: diese größer, o:gleich, -1:ar größer

  bool copynum(longnumber* quelle, bool incl_rare=false);
  //kopiert den wert von quelle
  // neu(okt2010) überträgt auch die Struktur(Länge etc.)
  // neu(dec12) realloziert nur bei grobem missverhaeltnis
  bool mirrornum(longnumber* quelle);
  //kopiert die quelle exakt

  void shiftright(ulong32 bshift); //heruntershiften

  void shiftup(ulong32 upshift); //heraufschiften
  void shiftoneup_q(); //quick um 1 heraufshiften
  bool byteshift(long32 offs);
  void shiftbits_q(long32 offs); //schnelle bitshift routine
  //kann weiter verschnellert werden duch testabschalten -> spaeter??
  void shiftbits_down(long32 offs);//wird von shiftbits_q für neg. argumente aufgerufen
  void shiftonedown_q();

  void setbit(long32 bitpos, bool val);
  // setzt nullbasiertes bitpos bit auf val

  bool inc();//increment und decrement
  bool dec();

  bool primecheaptest(long32 max);
  //  Primzahlvortest  (div 3,5,7,11,13,17,19,23,29,31,37 etc bis max)

  bool randomize( long32 rounds, char warnflag=0);
// Funktion mixert und permutiert den block massiv durch, gibt True zurück
  bool randomize_d( long32 rounds, char warnflag=0);
// double security version: Funktion mixert und permutiert den block massiv durch, gibt True zurück
  bool randomize_e( long32 rounds, char warnflag=0);
// triple security version: Funktion mixert und permutiert den block mit develop_ln2 durch, gibt True zurück
// highbyte != 0 wird erzwungen
  long giv_siz();
  //returns size of lonu in bits i.e. value of hibit;

/**************************************************************/
  bool randomize( long32 rounds, longnumber* mate, ulong32 outlength, ulong32 cagesize=0, char warnflag=0);
  bool randomize_o( long32 rounds, longnumber* mate, ulong32 outlength, ulong32 cagesize=0, char warnflag=0);
// Funktion mixert und permutiert den block mit mate durch
//wenn cagesize > length+mate->length intermediately larger cage

  ulong32 setsize(bool force=false); //aktualisiert die Size incl hibit

  ulong32 setsizefrom(ulong32 lasthibit); //aktualisiert die Sizeincl hibit, always forced, search down from lasthibit


  bool shrinktofit(unsigned char bufz=4);
  // schrumpft bis auf ein byte mehr als size

  bool integrate(unsigned char begbyte=0, unsigned char inc=0, unsigned char backflag=1);
  // integriert und addiert begbyte am Anfang und inc bei jedem Schritt

  bool formforkey(ulong32 blosiz);

  bool qrsa_encipher(longnumber* ptarget, longnumber* pd, longnumber* pn, ulong32 blosiz);
  //quickrsa kappt bei blosiz und enciphered
  bool qrsa_decipher(longnumber* cipher,longnumber* pe, longnumber* pn, ulong32 blosiz);
  // regeneriert die gekappte longnumber

  bool lonu_to_file(wxString fnam);
  bool lonu_from_file(wxString fnam);

    void swapnum(longnumber* other);
  //vertausche nummer ohne memoryumschichtung
  bool cheap_modreduce(longnumber* modp);
  //zieht modul einmal ab falls groesser als modul
/*********************************************/
  bool lazy_modreduce(longnumber* modp);
  //zieht modul ein paar mal schnell byteversetzt ab

  bool getbit(ulong32 bitpos);
  //gibt true, wenn bitpos´te bit von hinten 1 ist(Start bei 0)
  int count_ones();
  //counts occurences of hibits
  int kobz_trans(longnumber* ksum, longnumber* ksub);
  //producec expansion for quick multiplication
  int kobz_trans_byte(longnumber* ksum, longnumber* ksub);
  //producec expansion for quick multiplication
private:



  int overnum(longnumber* divsr, longnumber* resno);
   //gibt die bei high "ueberstehende Zahl"  in resno zurueck
   // hilfsroutine für die schnelle division
  int restcompare(longnumber* divsr, ulong32 pos);
  //vergleicht den "rest" unterhalb der Position pos und gibt 0 zurueck wenn gleich, 1 wenn this groesser, -1 wenn divsr groesser
  int r_compar(ulong32 bpos, longnumber* divsr, ulong32 d_bpos, long32 divminone=-1);
//vergleicht die Reste auf der niederwertigen seite  der angeg Positionen
//divminone =-1 zeigt an, dass noch gesucht werden muss

  inline bool punchcarry(ulong32* start, ulong32 maxlen);
  // drueckt das Carrybit bei Subtraktion durch, falls unzureichende Laengen, return false

  bool squeezebyte(unsigned char h1,unsigned char* adhlp,ulong32 bytepos,ulong32 maxpos);
  //quetscht ein byte in eine longnumberadresse
  inline bool pluckbyte(ulong32 plpos, unsigned char plval);
  //puhlt ein byte aus einer longnumberadresse
  //without range control!
  inline bool pluckshort(ulong32 plpos, unsigned short plval);
  //puhlt ein byte aus einer longnumberadresse
  //without range control!
  inline bool plucklong(ulong32 plpos, ulong32 plval);
  //puhlt ein byte aus einer longnumberadresse
  //without range control!
  inline bool pushbyte(ulong32 plpos, unsigned char plval);
  //quetscht ein byte in eine longnumberadresse - wie squeezebyte
  //without range control

  inline bool pushshort(ulong32 plpos, unsigned short plval);
  //quetscht ein unsigned short byte in eine longnumberadresse - wie squeezebyte
  //without range control
  inline bool pushlong(ulong32 plpos, ulong32 plval);
  //quetscht ein unsigned short byte in eine longnumberadresse - wie squeezebyte
  //without range control

  bool decrpos(ulong32 bytepos);
  // decrementiert an der Position um 1 (nullbasiert)
  inline bool incrpos(ulong32 bytepos);
  // incrementiert an der Position um 1  (nullbasiert)

  bool lnperm_x1( long32 rounds);
//Funktion setzt einen blolen großen Block in
//einen blolengroßen Permutationsarray um
//1.wohin zeigt byte-wohin zeigt das wieder+ index, original wird mit dem vertauscht
//2. wohin zeigt byte, wird mit dem gexort, wohin zeigt das, wird mit dem gexort etc blolen mal
// bei zwei heisst zeigt: alter index + neuer + index modulo blolen
  bool lnxor_x1( long32 rounds);
//Funktion setzt einen blolen großen Block in
//einen blolengroßen Permutationsarray um
//1.wohin zeigt byte-wohin zeigt das wieder+ index, original wird mit dem gexort
//2. wohin zeigt byte, wird mit dem gexort, wohin zeigt das, wird mit dem gexort etc blolen mal
// bei zwei heisst zeigt: alter index + neuer + index modulo blolen
bool lndevelop( long32 rounds,char paths,char algoflag);

/**************************************************************/
 inline unsigned char rotbyte(unsigned char byt, unsigned char rotval)
{
  //return ((byt >> rotval&7) | (byt << (8 - rotval&7)));
     unsigned char ch;

   if(rotval==0) return byt;
   ch=byt;
   byt= byt>>rotval;
   byt= byt | (ch<<(8-rotval));
   return byt;
}
/**************************************************/


};
/**********************************************************/
class lonucrt
{
    public:

    lonucrt(longnumber *px, longnumber *pp, longnumber *pq); //constructor
    ~lonucrt(); //destructor

    bool modulocompare(longnumber ext_n); //vergleiche moduli, true, wenns stimmt
    bool import_num(longnumber lonu); // importiere eine Zahl aus normal nach CRT
    bool exportnum(longnumber *l_ad); //exportiere eine Zahl aus CRT nach normal

    bool addcrt(lonucrt *ps); //addiere lonucrt und checke, ob n stimmt
    bool subtrcrt(lonucrt *ps); //subtrahiere lonucrt
    bool multcrt(lonucrt *pfac); //multipliziere
    bool powcrt(longnumber *pexp); //potenziere modulo n

    longnumber a,b; //crt-Darstellung der Zahl
    longnumber n;// Modul

    private:
    longnumber p,q,iqmodp,fi;

};
/************************************************************/
#endif
