/*
 *   Copyright (C) 2011-2016, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef CAP_QUESTN_H
#define CAP_QUESTN_H

//(*Headers(Cap_Questn)
#include <wx/checkbox.h>
#include <wx/dialog.h>
#include <wx/sizer.h>
#include <wx/button.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>
#include <wx/timer.h>
//*)

class Cap_Questn: public wxDialog
{
	public:

		Cap_Questn(wxWindow* parent,wxString messg, wxString* panswer, bool* pis_legacy, wxWindowID id=wxID_ANY,const wxPoint& pos=wxDefaultPosition,const wxSize& size=wxDefaultSize);
		virtual ~Cap_Questn();

		//(*Declarations(Cap_Questn)
		wxButton* Abort_Button;
		wxTextCtrl* pwCtrl;
		wxStaticText* StaticText1;
		wxTimer Timer1;
		wxCheckBox* CheckLegacy;
		wxButton* Encrypt_Button;
		//*)

	protected:

		//(*Identifiers(Cap_Questn)
		static const long ID_BUTTON1;
		static const long ID_STATICTEXT1;
		static const long ID_BUTTON2;
		static const long ID_TEXTCTRL1;
		static const long ID_CHECKBOX1;
		static const long ID_TIMER1;
		//*)

	private:

		//(*Handlers(Cap_Questn)
		void OnAbort(wxCommandEvent& event);
		void OnCappedEncrypt(wxCommandEvent& event);
		void OnTimer1Trigger(wxTimerEvent& event);
		void OnpwCtrlTextEnter(wxCommandEvent& event);
		//*)

		DECLARE_EVENT_TABLE()


        int half_min_counter;
		wxString *pansw;
		bool *pisleg;

};

#endif
