#include "LoadEllKey.h"

//(*InternalHeaders(LoadEllKey)
#include <wx/string.h>
#include <wx/intl.h>
#include <wx/font.h>
//*)

#include "globals.h"

//(*IdInit(LoadEllKey)
const long LoadEllKey::ID_BUTTON1 = wxNewId();
const long LoadEllKey::ID_STATICTEXT1 = wxNewId();
const long LoadEllKey::ID_STATICTEXT2 = wxNewId();
const long LoadEllKey::ID_BUTTON2 = wxNewId();
const long LoadEllKey::ID_LISTBOX1 = wxNewId();
const long LoadEllKey::ID_TIMER1 = wxNewId();
//*)

BEGIN_EVENT_TABLE(LoadEllKey,wxDialog)
	//(*EventTable(LoadEllKey)
	//*)
END_EVENT_TABLE()

LoadEllKey::LoadEllKey(wxWindow* parent,el_pub* loky1, wxWindowID id,const wxPoint& pos,const wxSize& size)
{
    FILE *knfp=NULL;
    char buff1[1002], buff2[1002];
    int lbl,count;
    bool fl;


    if(!checkarm()){Close(); }
	//(*Initialize(LoadEllKey)
	wxFlexGridSizer* FlexGridSizer1;

	Create(parent, id, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("id"));
	SetForegroundColour(wxColour(7,96,12));
	SetBackgroundColour(wxColour(216,245,219));
	FlexGridSizer1 = new wxFlexGridSizer(0, 2, 0, 0);
	Button1 = new wxButton(this, ID_BUTTON1, _("Cancel/Exit"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON1"));
	Button1->SetBackgroundColour(wxColour(251,198,198));
	wxFont Button1Font(11,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button1->SetFont(Button1Font);
	FlexGridSizer1->Add(Button1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText1 = new wxStaticText(this, ID_STATICTEXT1, _("Load Public Elliptic Key"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT1"));
	StaticText1->SetForegroundColour(wxColour(10,179,12));
	wxFont StaticText1Font(13,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText1->SetFont(StaticText1Font);
	FlexGridSizer1->Add(StaticText1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	FlexGridSizer1->Add(20,10,1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	StaticText2 = new wxStaticText(this, ID_STATICTEXT2, _("30 seconds to select."), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT2"));
	wxFont StaticText2Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText2->SetFont(StaticText2Font);
	FlexGridSizer1->Add(StaticText2, 1, wxALL|wxALIGN_TOP|wxALIGN_CENTER_HORIZONTAL, 5);
	Button2 = new wxButton(this, ID_BUTTON2, _("Load"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON2"));
	Button2->SetBackgroundColour(wxColour(189,241,199));
	wxFont Button2Font(11,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button2->SetFont(Button2Font);
	FlexGridSizer1->Add(Button2, 1, wxALL|wxALIGN_TOP|wxALIGN_CENTER_HORIZONTAL, 5);
	ListBox1 = new wxListBox(this, ID_LISTBOX1, wxDefaultPosition, wxSize(343,323), 0, 0, 0, wxDefaultValidator, _T("ID_LISTBOX1"));
	ListBox1->SetForegroundColour(wxColour(7,112,15));
	wxFont ListBox1Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	ListBox1->SetFont(ListBox1Font);
	FlexGridSizer1->Add(ListBox1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	SetSizer(FlexGridSizer1);
	Timer1.SetOwner(this, ID_TIMER1);
	Timer1.Start(31000, false);
	FlexGridSizer1->Fit(this);
	FlexGridSizer1->SetSizeHints(this);

	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&LoadEllKey::OnCancel);
	Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&LoadEllKey::OnLoad);
	Connect(ID_LISTBOX1,wxEVT_COMMAND_LISTBOX_DOUBLECLICKED,(wxObjectEventFunction)&LoadEllKey::OnLoad);
	Connect(ID_TIMER1,wxEVT_TIMER,(wxObjectEventFunction)&LoadEllKey::OnTimer1Trigger);
	//*)

	loky=loky1;
	    // zuerst Namensliste Laden
    wxArrayString wxstrad; //wxStringarray initialisieren
    if(S_FIL) fl=unlockfile(sec_path + _("/e_ell_knamfile.knf"),&zugang);
    knfp=fopen((const char*) (sec_path +_("/e_ell_knamfile.knf")).mb_str(wxConvLocal), "r");
    if(knfp != NULL)
    {
    count=0;
      do{
        lbl=fscanf(knfp, " id: %1000s Name: %1000s\n",buff1,buff2);
        //in wxstrad einpflegen
        if(lbl==2) {
            wxstrad.Add( (wxString::FromUTF8(buff1)) + _("  ") + (wxString::FromUTF8(buff2)) );
            ids.Add(wxString::FromUTF8(buff1)); //ids ist eine class-variable
            count++;
        }
      }while(lbl == 2);
 	// Jetzt die Listbox initialisieren
    ListBox1->InsertItems(wxstrad,0);
    //als Menu in neuem Dialog anbieten und auswählen

    fclose(knfp);
    }
    if(S_FIL) fl=lockfile(sec_path + _("/e_ell_knamfile.knf"),&zugang);

}
/*************************************************************/
LoadEllKey::~LoadEllKey()
{
	//(*Destroy(LoadEllKey)
	//*)
}

/******************************************************************/
void LoadEllKey::OnLoad(wxCommandEvent& event)
{
    int indx, lbl,lbd,elfl;
    wxString idh,hlp;
    char buff[6002];
    FILE *kfp;
    long int fpos;
    el_pub oldkey;
    ellipse locell;
    bool lres;

    if(!checkarm()){Close();}
    oldkey.copy_pub_ky(loky);
    indx=ListBox1->GetSelection();
    if(indx<0)
    {
        throwout(_("nothing selected!\nDo nothing!"),3);
        return;
    }
    idh= ids.Item(indx);
    if(S_FIL){lres= unlockfile_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang,0,false);} // unlock keynamefile
    if(!lres)
    {
        throwout(_("unlocking public key file failed, aborting"),3);
        return;
    }
    kfp=fopen((const char*) (sec_path +_("/e_ell_Keyfile.kyf")).mb_str(wxConvLocal),"r");

    do{
        lbl=fscanf(kfp," id: %200s \n",buff);
        if( lbl ==1)
        {
          hlp= wxString::FromUTF8(buff);
          if(hlp != idh)
          {
             lbd=fscanf(kfp," Name: %2000s ",buff);
             lbd=fscanf(kfp," DomName: %2000s ",buff);
             lbd=fscanf(kfp," Ax: %2000s ",buff);
             lbd=fscanf(kfp," Ay: %2000s ",buff);
          }
        }
        if( lbl == EOF)
        { throwout(_("File read Error!"));
         fclose(kfp);
         if(S_FIL) lockfile_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // lock keynamefile
           return;
        }
        if(lbl==0)
        {
             fpos=ftell(kfp);
             fpos++;
             fseek ( kfp , fpos , SEEK_SET );
        } else{
          //make wxstring from buff->schon passiert
          //hlp= wxString::FromUTF8(buff);
        }
    } while( hlp != idh);
    loky->id =idh;
    do{
        if( (lbl=fscanf(kfp,"Name: %2000s ",buff)) == EOF)
        { throwout(_("Name read Error!"));
         fclose(kfp);
         if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // lock keynamefile
           return;
        }
    } while(lbl != 1 );
    //make wxstring from buff
    hlp= wxString::FromUTF8(buff);
    //buff Name nach privkey.rname schreiben
    loky->fullnam= hlp;
    do{
        if( (lbl=fscanf(kfp," DomName: %2000s ",buff)) == EOF)
        { throwout(_("Domain read Error!"));
         fclose(kfp);
         if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // lock keynamefile
           return;
        }
    } while(lbl != 1 );
    //make wxstring from buff
    hlp= wxString::FromUTF8(buff);
    loky->domnam= hlp;

    do{
        if( (lbl=fscanf(kfp,"Ax: %2000s ",buff)) !=1 )
        { throwout(_("Pubkey Ax read Error!"));
            fclose(kfp);
            if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // lock keynamefile
            return;
        }
    } while( lbl != 1);
    // A in den globalen key schreiben
    hlp=wxString::FromUTF8(buff);
    if( !((loky->A.x).storhex(&hlp))){throwout(_("error reading Ax")); fclose(kfp);
         if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // lock keynamefile
         return;}
    loky->A.x.setsize(); loky->A.x.shrinktofit();

    do{
        if( (lbl=fscanf(kfp,"Ay: %2000s ",buff)) !=1 )
        { throwout(_("Pubkey Ay read Error!"));
            fclose(kfp);
            if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // lock keynamefile
            return;
        }
    } while( lbl != 1);
    fclose(kfp);
    if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // lock keynamefile
    hlp=wxString::FromUTF8(buff);
    if( !((loky->A.y).storhex(&hlp))){throwout(_("error reading Ay"));
         return;}
    loky->A.y.setsize(); loky->A.y.shrinktofit();
    //check if key-domain is accessible
    if(!(loky->domnam == gdom.name))
    {
        elfl=e_ls.getelp(&locell,loky->domnam);
        if(elfl<0)
        {
            throwout(_("unknown key domain => key not usable!\nMust import domain first\nkey loading rejected!"));
            loky->copy_pub_ky(&oldkey);
            return;
        }
    }
    else
    {
        locell.copyell(&gdom);
    }
    //A testen
    if(! (loky->A).is_in_ellipse(&locell))
    {
        wxMessageBox(_("key is incompatible with own domain!?!\n will not load!\nresetting to last valid key"));
        loky->copy_pub_ky(&oldkey);
        return;
    }
    //A testen auf neutral
    if( (loky->A).neutral)
    {
        wxMessageBox(_("key is neutral element!?!\n will not load!\nresetting to last valid key"));
        loky->copy_pub_ky(&oldkey);
        return;
    }
     Close();
    throwout(_("new public key accepted"),2);
}
/***************************************************************/
void LoadEllKey::OnCancel(wxCommandEvent& event)
{
    Close();
}
/****************************************************************/
void LoadEllKey::OnTimer1Trigger(wxTimerEvent& event)
{
    throwout(_("timeout\nclosing window now"),4);
    Close();
}
/***************************************************************/
