unit MyMemObj;

interface

{   * * * * *   TMyDynamicMemory   * * * * *   }

type
  IndexType = Cardinal;

const
  MyDynamicMemoryRec_PointersInPointerList = 4095;

type
  TMDMRPointerList = array[0..MyDynamicMemoryRec_PointersInPointerList] of Pointer;
  PMDMRPointerList = ^TMDMRPointerList;

  TMyDynamicMemoryRec = object
  protected
    FStart: PMDMRPointerList;
    FMemoryLength: Word;
    FCount: IndexType;
    FTrack: IndexType;
    FThisPL: PMDMRPointerList;
    FThisIndex: 1..MyDynamicMemoryRec_PointersInPointerList;
    function GetPointerList(n :Cardinal): PMDMRPointerList; // nullbasiert
    function GetElement(n :IndexType): Pointer; // nullbasiert
    function AddPointerList: PMDMRPointerList;
    procedure RemovePointerList(n: Cardinal); // nullbasiert
    procedure SetLength(ML :Word);
  public
    constructor Create;
    destructor Destroy;
    property Count: IndexType read FCount;
    property Track: IndexType read FTrack write FTrack;
    property Length: Word read FMemoryLength write SetLength;
     // NICHT nullbasiert
    function Add: Pointer;
    function Insert(n :IndexType): Pointer;
    function Item(n :IndexType): Pointer;
    procedure ExchangeItems(n, m :IndexType);
    procedure Delete(n :IndexType);
    procedure Clear;
    function GetFirstItem: Pointer;
    function GetNextItem: Pointer;
  end;

{   * * * * *   TMyQuader3DData   * * * * *   }

(*   TQuader3DData = record
    Numbers :array[-2..11] of LongInt;
    Distance:Double;
    PlaneID :String[40];
  end;

  PQuader3DData = ^TQuader3DData;

  TMyQuader3DData = object(TMyDynamicMemoryRec)
  private
  public
    constructor Create;
    function Add(New :TQuader3DData): Boolean;
    function Insert(n :Cardinal; New :TQuader3DData): Boolean;
    function Item(n :Cardinal): TQuader3DData;
    function PointItem(n :Cardinal): PQuader3DData;
  end;*)

implementation

uses
  Windows, Forms, MMSystem, Graphics;

{   * * * * *   TMyDynamicMemory   * * * * *   }

constructor TMyDynamicMemoryRec.Create;
begin
FStart := nil;
FCount := 0;
FTrack := 0;      {keinen verfolgen}
FThisPL := nil;
FMemoryLength := 4; {Platz fr z.B. 1 Integer}
end;

destructor TMyDynamicMemoryRec.Destroy;
begin
 Clear;
end;

function TMyDynamicMemoryRec.GetPointerList(n :Cardinal): PMDMRPointerList; // nullbasiert
var      i                  :Cardinal;
begin
Result := FStart;
for i := 1 to n do
 Result := Result^[0];
end;

function TMyDynamicMemoryRec.GetElement(n :IndexType): Pointer; // nullbasiert
begin
Result := GetPointerList(n div MyDynamicMemoryRec_PointersInPointerList)[n mod MyDynamicMemoryRec_PointersInPointerList + 1];
end;

function TMyDynamicMemoryRec.AddPointerList: PMDMRPointerList;
begin
New(Result);
try
  if FCount > 0 then
   GetPointerList((FCount - 1) div MyDynamicMemoryRec_PointersInPointerList)[0] := Result
  else
   FStart := Result;
  Result[0] := nil;
except
  Dispose(Result);
  raise;
end;
end;

procedure TMyDynamicMemoryRec.RemovePointerList(n: Cardinal); // nullbasiert
var      P2                                    :PMDMRPointerList;
begin
P2 := GetPointerList(n);
Dispose(P2);
if n = 0 then
 FStart := nil
else
 GetPointerList(n-1)[0] := nil;
end;

procedure TMyDynamicMemoryRec.SetLength(ML :Word);
begin
if FCount = 0 then
 FMemoryLength := ML;
end;

function TMyDynamicMemoryRec.Add: Pointer;
begin
GetMem(Result, FMemoryLength);
try
  if FCount mod MyDynamicMemoryRec_PointersInPointerList = 0 then
   AddPointerList[1] := Result
  else
   GetPointerList(FCount div MyDynamicMemoryRec_PointersInPointerList)[FCount mod MyDynamicMemoryRec_PointersInPointerList + 1] := Result; {1-Basiert}
  inc(FCount);
except
 FreeMem(Result, FMemoryLength);
 raise;
end;
end;

function TMyDynamicMemoryRec.Insert(n :IndexType): Pointer;
var      PTMP, PTMP2                  :Pointer;
         PL                           :PMDMRPointerList;
         i                            :IndexType;
begin
Result := Add;
if assigned(Result) then
 begin
  dec(n);
  i := n mod MyDynamicMemoryRec_PointersInPointerList + 1;
  PL := GetPointerList(n div MyDynamicMemoryRec_PointersInPointerList);
  PTMP := PL[MyDynamicMemoryRec_PointersInPointerList];
  Move(PL[i], PL[i + 1], SizeOf(Pointer)*(MyDynamicMemoryRec_PointersInPointerList-i));
  PL[i] := Result;
  while assigned(PL[0]) do
   begin
    PL := PL[0];
    PTMP2 := PL[MyDynamicMemoryRec_PointersInPointerList];
    Move(PL[1], PL[2], SizeOf(Pointer)*(MyDynamicMemoryRec_PointersInPointerList-1));
    PL[1] := PTMP;
    PTMP := PTMP2;
  end;
{  for i := FCount - 1 downto n + 1 do //umkopieren
    begin
    P := GetPointerList(i div MyDynamicMemoryRec_PointersInPointerList);
    P2 := GetPointerList((i - 1) div MyDynamicMemoryRec_PointersInPointerList);
    TMDMRPointerList(P^)[i mod MyDynamicMemoryRec_PointersInPointerList + 1] :=
     TMDMRPointerList(P2^)[(i - 1) mod MyDynamicMemoryRec_PointersInPointerList + 1];
   end; //Wert wieder einsetzen
  P := GetPointerList(n div MyDynamicMemoryRec_PointersInPointerList);
  TMDMRPointerList(P^)[n mod MyDynamicMemoryRec_PointersInPointerList + 1] := Result;}
  if FTrack >= n then
   Inc(FTrack);
 end;
end;

function TMyDynamicMemoryRec.Item(n :IndexType): Pointer;
begin
 Result := GetElement(n - 1);
end;

procedure TMyDynamicMemoryRec.ExchangeItems(n, m :IndexType);
var       ZW                               :Pointer;
          P1, P2                           :PMDMRPointerList;
begin
if FTrack = n then
 FTrack := m
else
 if FTrack = m then
  FTrack := n;
dec(n);
dec(m);
P1 := GetPointerList(n div MyDynamicMemoryRec_PointersInPointerList);
P2 := GetPointerList(m div MyDynamicMemoryRec_PointersInPointerList);
n := n mod MyDynamicMemoryRec_PointersInPointerList + 1;
m := m mod MyDynamicMemoryRec_PointersInPointerList + 1;
ZW := P1[n];
P1[n] := P2[m];
P2[m] := ZW;
end;

procedure TMyDynamicMemoryRec.Delete(n :IndexType);
var       PL                        :PMDMRPointerList;
          i                         :IndexType;
begin
if n = FTrack then
 FTrack := 0
else
 if n < FTrack then
  dec(FTrack);
dec(n);         {intern nullbasiert}
PL := GetElement(n);             {interne, nullbasierte Routine}
FreeMem(PL, FMemoryLength);
dec(FCount);
PL := GetPointerList(n div MyDynamicMemoryRec_PointersInPointerList);
i := n mod MyDynamicMemoryRec_PointersInPointerList + 1;
Move(PL[i + 1], PL[i], SizeOf(Pointer)*(MyDynamicMemoryRec_PointersInPointerList-i));
while assigned(PL[0]) do //while not the last PointerList
 begin
  PL[MyDynamicMemoryRec_PointersInPointerList] := TMDMRPointerList(PL[0]^)[1];
  PL := PL[0];
  Move(PL[2], PL[1], SizeOf(Pointer)*(MyDynamicMemoryRec_PointersInPointerList-1));
 end;
{while n < FCount do //xxx
 begin
  P := GetPointerList(n div MyDynamicMemoryRec_PointersInPointerList);
  P2 := GetPointerList((n + 1) div MyDynamicMemoryRec_PointersInPointerList);
  TMDMRPointerList(P^)[n mod MyDynamicMemoryRec_PointersInPointerList + 1] :=    {1-Basiert}
 {  TMDMRPointerList(P2^)[(n + 1) mod MyDynamicMemoryRec_PointersInPointerList + 1];
  inc(n);
 end;}
if FCount mod MyDynamicMemoryRec_PointersInPointerList = 0 then
 RemovePointerList(FCount div MyDynamicMemoryRec_PointersInPointerList);
end;

procedure TMyDynamicMemoryRec.Clear;
var       PL, PTMP           :PMDMRPointerList;
          i                  :IndexType;
begin
if FStart <> nil then
 begin
  PL := FStart;
  i := 0;
  while FCount > 0 do
   begin
    dec(FCount);
    if i = MyDynamicMemoryRec_PointersInPointerList then
     begin
      PTMP := PL[0];
      Dispose(PL);
      PL := PTMP;
      i := 0;
     end;
    inc(i);
    FreeMem(PL[i], FMemoryLength);
   end;
{  for i := 0 to FCount - 1 do
   begin
    P := GetPointerList(i div MyDynamicMemoryRec_PointersInPointerList);
    FreeMem(TMDMRPointerList(P^)[i mod MyDynamicMemoryRec_PointersInPointerList + 1], FMemoryLength);
   end;}
{  P := FStart;
  while P <> nil do
   begin
    P2 := P;
    P := TMDMRPointerList(P^)[0];
    Dispose(P2);
   end;}
  FStart := nil;
 end;
FCount := 0;
FTrack := 0;
end;

function TMyDynamicMemoryRec.GetFirstItem: Pointer;
begin
FThisPL := FStart;
FThisIndex := 1;
Result := FThisPL[FThisIndex];
end;

function TMyDynamicMemoryRec.GetNextItem: Pointer;
begin
inc(FThisIndex);
if FThisIndex >= MyDynamicMemoryRec_PointersInPointerList then
 begin
  FThisPL := FThisPL[0];
  FThisIndex := 1;
 end;
Result := FThisPL[FThisIndex];
end;

{   * * * * *   TMyQuader3DData   * * * * *   }

(*constructor TMyQuader3DData.Create;
begin
 inherited Create;
FMemoryLength := SizeOf(TQuader3DData);
end;

function TMyQuader3DData.Add(New :TQuader3DData): Boolean;
var      P                     :Pointer;
begin
 P := inherited Add;
 if P <> nil then
  TQuader3DData(P^) := New;
 Result := P = nil;
end;

function TMyQuader3DData.Insert(n :Cardinal; New :TQuader3DData): Boolean;
var      P                     :Pointer;
begin
 P := inherited Insert(n);
 if P <> nil then
  TQuader3DData(P^) := New;
 Result := P = nil;
end;

function TMyQuader3DData.Item(n :Cardinal): TQuader3DData;
var      P                     :Pointer;
begin
 P := inherited Item(n);
 Result := TQuader3DData(P^);
end; {zum ndern: ' with MyQuader3DData.PointItem(i)^ do'}

function TMyQuader3DData.PointItem(n :Cardinal): PQuader3DData;
begin
 Result := inherited Item(n);
end;

{function TMyQuader3DData.SetItem(n :Cardinal; New: TQuader3DData;): Boolean;
var      P                     :Pointer;
begin
 P := inherited Item(n);
 if P <> nil then
  P := TQuader3DData(New^);

 Result := P <> nil;
end;}*)

procedure DoInitialization;
var       Time1, Time2    :LongWord;
          bound           :TSize;
Const Text = 'MemoryManagement by Gerold Veith (GoldVision) (1998-1999)';
begin
 with TForm.Create(Application) do
  begin
   BorderStyle := bsNone;
   Position := poScreenCenter;
   bound := Canvas.TextExtent(Text);
   Width := bound.cx;
   Height := bound.cy;
//   Brush.Color := clNone;
   Brush.Style := bsClear;
//   Canvas.Brush.Color := clNone;
   Canvas.Brush.Style := bsClear;
   Show;
   Canvas.TextOut(0, 0, Text);
   Time1 := timeGetTime;
   repeat
     Time2 := timeGetTime;
   until (Time2 - Time1 >= 1000) or (Time2 < Time1);
   Free;
  end;
end;

initialization
 DoInitialization;
end.
