unit My3Unit;

interface

uses
  SysUtils, Windows, StdCtrls, Classes, Dialogs, Forms, Buttons, GVSpin,
  ExtCtrls, Controls, Graphics, Math, MMSystem, CommDlg;

 function GetByteFromFile(FileHandle: Integer): Integer;
 {liest ein Byte an aktuelle Position; gibt Wert zurck, wenn erfolgreich, sonst -1}
 function WriteByteToFile(FileHandle: Integer; Value: Byte): Boolean;
 {schreibt ein Byte an aktuelle Position; gibt True zurck, wenn erfolgreich}
 function sgn(Value: Extended): SmallInt; overload;
 function sgn(Value: Integer): SmallInt; overload;
 {holt Vorzeichen -1|0|+1}
 function HexToInt(Value: String): LongInt;
 {Headezimalzahl nach Integer}
 function IntToRoman(Value: Integer): String;
 {in rmische Zeichen}
(* function Root(Radikant: Double; nteWurzel: Double): Extended;
 {Y/x   Result = RADIKANT/ntewurzel}
 function Log(Basis, Potenz: Extended): Extended;*)
 {errechnet den logarithmus   Result = LOG basis POTENZ}
 function CompareWildCards(Comp, Test: String; NoCase: Boolean): Boolean;
 {Vergleicht zwei Strings, wobei Comp "*" und "?" beinhalten darf.}
 function CompPos(String1, String2: String): Integer;
 {Vergleicht zwei Strings, und gibt die Position, des ersten Fehlers zurck}
{ function XXXCopyFile(Source, Dest: String): Boolean;}
 {kopiert eine Datei, gibt zurck ob es geklappt hat}
 function MyDlgEdit(var Value: String; Name, Text: String): Boolean;
 {ffnet ein Fenster zur Eingabe eines Textes}
 function MyDlgComboBox(var Index: Integer; Name, Text, Elements: String): Boolean;
 {ffnet ein Fenster zur Auswahl in einer ComboBox}
 function MyDlgGVSpinEdit(var Value_: Integer; Name, Text: String; Min, Max: Integer): Boolean;
 {ffnet ein Fenster zur Eingabe einer Ganz-Zahl in einem GVSpinEdit}
 function MyDlgExtSpinEdit(var Value_: Extended; Name, Text :String; Min, Max :Extended): Boolean;
 {ffnet ein Fenster zur Eingabe einer Real-Zahl in einem ExtSpinEdit}
 function MyDlgRadioGroup(var Index: Integer; Name, Text, Elements: String): Boolean;
 {ffnet ein Fenster zur Auswahl in einer RadioGroup}
 function ShowGVEmblem: Pointer;
 {zeigt mein HerstellungsEmblem}
 function ShowBitmap(BtMp: PChar; Cursor: TCursor): Pointer;
 {zeigt eine Bitmap aus der Ressource auf einer Form}
 function StringExpToExtended(Str: String): Extended;
 {wandelt ein String '' '235E+10' '13' '13E+00' in eine Zahl Typ Extended um}
 function ggT(p, q: Integer): Integer;
 {errechnet den "grten gemeinsamen Teiler" der beiden Argumente}
 function kgV(p, q: Integer): Integer;
 {errechnet die "kleinste gemeinsame Vielfache" der beiden Argumente}
 function TestForCountSystem(S: String; System: Byte): Integer;
 {testet einen S String, ob er in dem ZahlenSystem gltig ist; 1 < System < 37}
 function GetFromCountSystem(S: String; System: Byte): LongInt;
 {wandelt eine Zahl in einem 1 < System < 37 in eine Dezimalzahl (System = 10) um}
 function ChangeToCountSystem(X: LongInt;  System: Byte): String;
 {wandelt eine Dezimalzahl in eine Zahl in einem 1 < System < 37 um, gibt sonst 'ERROR' zurck}
{ function ArcusTangens(a, b :Extended): Extended;
 {Wandelt das Seitenverhltnis a/b in den eingeschlossenen Winkel um = arctan(a/b)}
 function ConvertBufferToStr(Buffer: PChar; MaxLength: Integer): String;
 {Wie StrPas; ASCII-Zeichen unter 32 werden im Format '#XX' zurckgegeben.}
 function PathToRegPath(S: String): String;
 {aus jedem '\' wird '\\' fr die Registrierung (RegEdit)}
 function MakeStr(C: Char; Count: Integer): String;
 {liefert einen String zurck der aus Count-mal 'C' besteht}
 function GetUserString(Text, Title: String; var S: String):Boolean;
 {fragt ber ein Dialogfenster einen String vom Benutzer ab}
 function GetFileTitle(FileName: String): String;
 {leitet den Namen einer Datei, meist den Namen, bei einigen ohne Endung, her}

 procedure FillItems(Destination: TStrings; S: String);
 {fgt Elemente zur (ComboBox.)Items 'Destination' hinzu, die S enhlt; die Elemente mssen durch #13 getrennt sein.}
(* procedure SortIntArray(A :TStrings; Count :Integer);*)
 {sortiert eine String-Liste Integern aufsteigend}
procedure HideBitmap(MYF :TForm);
{ procedure HideBitmap(MYB :TImage);
 {routine um das Emblem-Fenster zu schlieen}
 procedure CopyNotBackRect(Source, Dest :TCanvas; x1, y1, x2, y2, x9, y9 :LongInt; Back :TColor);
 {kopiert das Rechteck x1,y1-x2,y2 von Source nach Dest x9,y9, lt alle Pixel,die Back sind, aus}
 procedure ConvertStrToBuffer(S: String; var Buffer: PChar; MaxLength: Integer);
 {GegenFunktion zu ConvertBufferToStr}
 procedure Waitms(ms: LongWord);
 {wartet ms ms und gibt zurck}
(* procedure MemoryCopy(Source, Dest :Pointer; Count :Word);*)
 {Kopiert Count-Bytes von Source nach Dest}

 //Versuch mit BrushCopy und FillStyle := clNone or Something like that
{ procedure DrawTransparent(Source: TCanvas; SRect: TRect;
             Dest: TCanvas; DRect: TRect; Color :TColor);
 {Kopiert SourceRect nach DestRect, wobei Color freigelassen wird}



const    CountSystemChars :String = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';

implementation

function GetByteFromFile(FileHandle: Integer): Integer;
var      Buffer: Char;
         Res: LongWord;
begin
if ReadFile(FileHandle,Buffer,1,Res,nil) and (Res = 1) then    {Liest ein Byte in den Puffer}
 Result := Byte(Buffer)
else
 Result := -1;
end;

function WriteByteToFile(FileHandle: Integer; Value: Byte): Boolean;
var      Res: LongWord;
begin
Result := WriteFile(FileHandle,Value,1, Res, nil) and (Res = 1); {Schreibt ein Byte vom Puffer}
end;

function sgn(Value: Extended): SmallInt;
begin
 if Value > 0 then
  Result := 1
 else
  if Value < 0 then
   Result := -1
  else
   Result := 0;
end;

function sgn(Value: Integer): SmallInt;
begin
 if Value > 0 then
  Result := 1
 else
  if Value < 0 then
   Result := -1
  else
   Result := 0;
end;

function HexToInt(Value:String): LongInt;
var    i                 :Integer;
const  HexStep           :array[1..8] of LongInt = (1,16,256,4096,65536,1048576,16777216,268435456);
begin
Result := 0;
for i := 1 to Length(Value) do
 begin
  if Value[i] > '9' then
   Result := Result + (ord(Value[i])-55) * HexStep[Length(Value)+1-i]
  else
   Result := Result + (ord(Value[i])-48) * HexStep[Length(Value)+1-i];
 end;
end;

function IntToRoman(Value :Integer): String;
var   StrValue            :String;
      i                   :Byte;
const TenNumber    :array[0..3] of Char = ('I','X','C','M');
      FiveNumber   :array[0..2] of Char = ('V','L','D');
begin
if (Value < 1) or (Value > 3888) then
 Result := 'ERROR'
else
 if Value = 4 then
  Result := 'IIII'
 else
  begin
   Result := '';
   StrValue := IntToStr(Value);
   for i := 1 to length(StrValue) do
    begin
     if StrValue[i] = '4' then
      Result := Result + TenNumber[length(StrValue) - i] +
       FiveNumber[length(StrValue) - i];
     if StrValue[i] = '9' then
      Result := Result + TenNumber[length(StrValue) - i] +
       TenNumber[length(StrValue) - i + 1];
     if (StrValue[i] > '4') and (StrValue[i] < '9') then
      Result := Result + FiveNumber[length(StrValue) - i];
     if (StrValue[i] = '1') or (StrValue[i] = '6') then
      Result := Result + TenNumber[length(StrValue) - i];
     if (StrValue[i] = '2') or (StrValue[i] = '7') then
      Result := Result + TenNumber[length(StrValue) - i] + TenNumber[length(StrValue) - i];
     if (StrValue[i] = '3') or (StrValue[i] = '8') then
      Result := Result + TenNumber[length(StrValue) - i] + TenNumber[length(StrValue) - i] + TenNumber[length(StrValue) - i];
    end;
  end;
end;

procedure FillItems(Destination:TStrings;S:String);
{procedure FillComboBox(Destination:TComboBox;S:String);}
begin
while pos(#13,S) > 0 do
 begin
  Destination.Add(copy(S,1,pos(#13,S)-1));
  S := copy(S,pos(#13,S)+1,length(S));
 end;
Destination.Add(S);
end;

(*function Root(Radikant : Double; nteWurzel :Double): Extended;
begin
Result := Power(Radikant, 1/nteWurzel);
end;

function Log(Basis, Potenz :Extended): Extended;    {logarithmus}
begin
Result := ln(Potenz) / ln(Basis);
end;*)

function CompareWildCards(Comp, Test :String; NoCase: Boolean): Boolean;   {Vergleicht mit "*" und "?"}

 function CompPos(String1, String2 :String): Integer;
 begin  {einziger (gewollter) fehler: gibt bei ungleicher lnge das letzte Zeichen des krzeren zurck statt des danachs}
 if length(String1) > length(String2) then
  Result := length(String2)
 else
  Result := length(String1);
 for Result := 1 to Result do
  if String1[Result] <> String2[Result] then
   Break;
 if (String1 = '') or (String2 = '') then
  Result := 0;
 if String1 = String2 then
  Result := -1;
 end;

begin
Result := False;
if NoCase then
 begin
  Comp := AnsiUpperCase(Comp);
  Test := AnsiUpperCase(Test);
 end;
while (CompPos(Comp,Test) > -1) and (Comp[CompPos(Comp,Test)] = '?') do
 Comp[CompPos(Comp,Test)] := Test[CompPos(Comp,Test)];
if (CompPos(Comp,Test) > -1) and (Comp[CompPos(Comp,Test)] = '*') or
 (CompPos(Comp,Test) = length(Test)) and (Comp[length(Test)+1] = '*') or
  (CompPos(Comp,Test) = -1) then
 Result := True;
end;

function CompPos(String1, String2 :String): Integer;
begin
if length(String1) > length(String2) then
 Result := length(String2)
else
 Result := length(String1);
for Result := 1 to Result do
 if String1[Result] <> String2[Result] then
  Break;
if String1[Result] = String2[Result] then
 inc(Result);
if (String1 = '') or (String2 = '') then
 Result := 0;
if String1 = String2 then
 Result := -1;
end;

(*procedure SortIntArray(A :TStrings; Count :Integer);
{procedure SortIntArray(A :Array of LongInt; Count :Integer);}
var       i, j                            :Integer;
          zw                              :String;
begin
A.BeginUpdate;
try
  if Count < 3 then
   begin
    if Count = 2 then
     if StrToInt(A[2]) < StrToInt(A[1]) then
      begin
       zw := A[2];
       A[2] := A[1];
       A[1] := zw;
      end;
   end
  else
   begin
    j := Count - 1;
     while J > 0 do
      begin
       i := j;
       if StrToInt(A[i]) < StrToInt(A[i - 1]) then
        inc(j,2);
       while StrToInt(A[i]) < StrToInt(A[i - 1]) do
        begin
         zw := A[i];
         A[i] := A[i - 1];
         A[i - 1] := zw;
         dec(i);
         if i < 1 then
          i := 1;
        end;
       dec(j);
       if j > (Count - 1) then
        J := Count - 1;
      end;
   end;
finally
  A.EndUpdate;
end;
end;*)

{function XXXCopyFile(Source, Dest :String): Boolean;
var      Buffer                :PChar;
         FS, FD                :Integer;
         x                     :Byte;
begin
Result := False;
if FileExists(Source) and not(FileExists(Dest)) then
 begin
  FS := FileOpen(Source,fmOpenRead);
  FD := FileCreate(Dest);
  GetMem(Buffer, 255);                    {Setze 255 Byte-Puffer
  x := 255;
  while x = 255 do
   begin
    x := _lread(FS,Buffer,255);           {Liest Bytes in den Puffer
    x := _lwrite(FD,Buffer,x);            {Schreibt Bytes aus den Puffer
   end;
  FreeMem(Buffer, 255);                   {Puffer freigeben
  FileClose(FS);
  FileClose(FD);
  Result := True;
 end;
end;}

function MyDlgEdit(var Value: String; Name, Text: String): Boolean;
//function MyDlgEdit(Name, Text, Default :String): String;
var      DlgForm              :TForm;
         Label1               :TLabel;
         Edit1                :TEdit;
         BitBtn1, BitBtn2     :TBitBtn;
begin
 DlgForm := TForm.Create(Screen);
 DlgForm.Position := poScreenCenter;
 DlgForm.BorderStyle := bsDialog;
 DlgForm.Height := 150;
 DlgForm.Width := 400;
 DlgForm.Caption := Name;
 Label1 := TLabel.Create(DlgForm);
 Label1.Parent := DlgForm;
 Label1.Top := 10;
 Label1.AutoSize := False;
 Label1.Width := DlgForm.ClientWidth;
 Label1.Alignment := taCenter;
 Label1.Caption := Text;
 Edit1 := TEdit.Create(DlgForm);
 Edit1.Parent := DlgForm;
 Edit1.Top := 36;
 Edit1.Left := 20;
 Edit1.Width := DlgForm.ClientWidth - 40;
 Edit1.Text := Value;
 BitBtn1 := TBitBtn.Create(DlgForm);
 BitBtn1.Parent := DlgForm;
 BitBtn1.Top := 70;
 BitBtn1.Left := DlgForm.ClientWidth div 5;
 BitBtn1.Kind := bkOK;
 BitBtn2 := TBitBtn.Create(DlgForm);
 BitBtn2.Parent := DlgForm;
 BitBtn2.Top := 70;
 BitBtn2.Left := (4 * DlgForm.ClientWidth div 5) - BitBtn1.Width;
 BitBtn2.Kind := bkCancel;
 Result := DlgForm.ShowModal = 1;
 if Result then
  Value := Edit1.Text;
 DlgForm.Free;
end;

function MyDlgComboBox(var Index: Integer; Name, Text, Elements: String): Boolean;
//function MyDlgComboBox(Name, Text, Elements :String; Default :Integer): Integer;
var      DlgForm              :TForm;
         Label1               :TLabel;
         ComboBox1            :TComboBox;
         BitBtn1, BitBtn2     :TBitBtn;
begin
 DlgForm := TForm.Create(Screen);
 DlgForm.Position := poScreenCenter;
 DlgForm.BorderStyle := bsDialog;
 DlgForm.Height := 150;
 DlgForm.Width := 400;
 DlgForm.Caption := Name;
 Label1 := TLabel.Create(DlgForm);
 Label1.Parent := DlgForm;
 Label1.Top := 10;
 Label1.AutoSize := False;
 Label1.Width := DlgForm.ClientWidth;
 Label1.Alignment := taCenter;
 Label1.Caption := Text;
 ComboBox1 := TComboBox.Create(DlgForm);
 ComboBox1.Parent := DlgForm;
 ComboBox1.Top := 36;
 ComboBox1.Left := 20;
 ComboBox1.Width := DlgForm.ClientWidth - 40;
 ComboBox1.Style := csDropDownList;
 FillItems(ComboBox1.Items, Elements);
 ComboBox1.ItemIndex := Index;
 BitBtn1 := TBitBtn.Create(DlgForm);
 BitBtn1.Parent := DlgForm;
 BitBtn1.Top := 70;
 BitBtn1.Left := DlgForm.ClientWidth div 5;
 BitBtn1.Kind := bkOK;
 BitBtn2 := TBitBtn.Create(DlgForm);
 BitBtn2.Parent := DlgForm;
 BitBtn2.Top := 70;
 BitBtn2.Left := (4 * DlgForm.ClientWidth div 5) - BitBtn1.Width;
 BitBtn2.Kind := bkCancel;
 Result := DlgForm.ShowModal = 1;
 if Result then
  Index := ComboBox1.ItemIndex;
 DlgForm.Free;
end;

function MyDlgGVSpinEdit(var Value_: Integer; Name, Text: String; Min, Max: Integer): Boolean;
//function MyDlgGVSpinEdit(Name, Text :String; Default, Min, Max :LongInt): LongInt;
var      DlgForm              :TForm;
         Label1               :TLabel;
         SpinEdit1            :TGVSpinEdit;
         BitBtn1, BitBtn2     :TBitBtn;
begin
 DlgForm := TForm.Create(Screen);
 DlgForm.Position := poScreenCenter;
 DlgForm.BorderStyle := bsDialog;
 DlgForm.Height := 150;
 DlgForm.Width := 400;
 DlgForm.Caption := Name;
 Label1 := TLabel.Create(DlgForm);
 Label1.Parent := DlgForm;
 Label1.Top := 10;
 Label1.AutoSize := False;
 Label1.Width := DlgForm.ClientWidth;
 Label1.Alignment := taCenter;
 Label1.Caption := Text;
 SpinEdit1 := TGVSpinEdit.Create(DlgForm);
 SpinEdit1.Parent := DlgForm;
 SpinEdit1.Top := 36;
 SpinEdit1.Left := 20;
 SpinEdit1.Width := DlgForm.ClientWidth - 40;
 SpinEdit1.MaxValue := Max;
 SpinEdit1.MinValue := Min;
 SpinEdit1.Value := Value_;
 BitBtn1 := TBitBtn.Create(DlgForm);
 BitBtn1.Parent := DlgForm;
 BitBtn1.Top := 70;
 BitBtn1.Left := DlgForm.ClientWidth div 5;
 BitBtn1.Kind := bkOK;
 BitBtn2 := TBitBtn.Create(DlgForm);
 BitBtn2.Parent := DlgForm;
 BitBtn2.Top := 70;
 BitBtn2.Left := (4 * DlgForm.ClientWidth div 5) - BitBtn1.Width;
 BitBtn2.Kind := bkCancel;
 Result := DlgForm.ShowModal = 1;
 if Result then
  Value_ := SpinEdit1.Value;
 DlgForm.Free;
end;

function MyDlgExtSpinEdit(var Value_: Extended; Name, Text :String; Min, Max :Extended): Boolean;
//function MyDlgExtSpinEdit(Name, Text :String; Default, Min, Max :Extended): Extended;
var      DlgForm              :TForm;
         Label1               :TLabel;
         SpinEdit1            :TExtSpinEdit;
         BitBtn1, BitBtn2     :TBitBtn;
begin
 DlgForm := TForm.Create(Screen);
 DlgForm.Position := poScreenCenter;
 DlgForm.BorderStyle := bsDialog;
 DlgForm.Height := 150;
 DlgForm.Width := 400;
 DlgForm.Caption := Name;
 Label1 := TLabel.Create(DlgForm);
 Label1.Parent := DlgForm;
 Label1.Top := 10;
 Label1.AutoSize := False;
 Label1.Width := DlgForm.ClientWidth;
 Label1.Alignment := taCenter;
 Label1.Caption := Text;
 SpinEdit1 := TExtSpinEdit.Create(DlgForm);
 SpinEdit1.Parent := DlgForm;
 SpinEdit1.Top := 36;
 SpinEdit1.Left := 20;
 SpinEdit1.Width := DlgForm.ClientWidth - 40;
 SpinEdit1.MaxValue := Max;
 SpinEdit1.MinValue := Min;
 SpinEdit1.Value := Value_;
 BitBtn1 := TBitBtn.Create(DlgForm);
 BitBtn1.Parent := DlgForm;
 BitBtn1.Top := 70;
 BitBtn1.Left := DlgForm.ClientWidth div 5;
 BitBtn1.Kind := bkOK;
 BitBtn2 := TBitBtn.Create(DlgForm);
 BitBtn2.Parent := DlgForm;
 BitBtn2.Top := 70;
 BitBtn2.Left := (4 * DlgForm.ClientWidth div 5) - BitBtn1.Width;
 BitBtn2.Kind := bkCancel;
 Result := DlgForm.ShowModal = 1;
 if Result then
  Value_ := SpinEdit1.Value;
 DlgForm.Free;
end;

function MyDlgRadioGroup(var Index: Integer; Name, Text, Elements: String): Boolean;
//function MyDlgRadioGroup(Name, Text, Elements :String; Default :Integer): Integer;
var      DlgForm              :TForm;
         RadioGroup1          :TRadioGroup;
         BitBtn1, BitBtn2     :TBitBtn;
begin
DlgForm := TForm.Create(Screen);
DlgForm.Position := poScreenCenter;
DlgForm.BorderStyle := bsDialog;
DlgForm.Height := 150;
DlgForm.Width := 400;
DlgForm.Caption := Name;
RadioGroup1 := TRadioGroup.Create(DlgForm);
RadioGroup1.Parent := DlgForm;
RadioGroup1.Align := alLeft;
RadioGroup1.Width := DlgForm.ClientWidth - 89;
RadioGroup1.Caption := Text;
FillItems(RadioGroup1.Items, Elements);
RadioGroup1.Columns := RadioGroup1.Items.Count div 5;
RadioGroup1.ItemIndex := Index;
BitBtn1 := TBitBtn.Create(DlgForm);
BitBtn1.Parent := DlgForm;
BitBtn1.Top := DlgForm.ClientHeight div 6;
BitBtn1.Left := DlgForm.ClientWidth - BitBtn1.Width;
BitBtn1.Kind := bkOK;
BitBtn2 := TBitBtn.Create(DlgForm);
BitBtn2.Parent := DlgForm;
BitBtn2.Top := (5 * DlgForm.ClientHeight div 6) - BitBtn1.Height;
BitBtn2.Left := DlgForm.ClientWidth - BitBtn2.Width;
BitBtn2.Kind := bkCancel;
Result := DlgForm.ShowModal = 1;
if Result then
 Index := RadioGroup1.ItemIndex;
DlgForm.Free;
end;

function ShowGVEmblem: Pointer;
var      DlgForm               :TForm;
         Image1                :TImage;
{         MyBoolean             :Boolean;}
begin
DlgForm := TForm.CreateNew(Screen);
DlgForm.FormStyle := fsStayOnTop;
DlgForm.Position := poScreenCenter;
DlgForm.BorderStyle := bsNone;
Image1 := TImage.Create(DlgForm);
Image1.Parent := DlgForm;
Image1.Align := alClient;
Image1.Picture.Bitmap.Handle := LoadBitmap(hInstance, 'GVEMBLEM');
DlgForm.Tag := Image1.Picture.Bitmap.Handle;
Image1.Cursor := crHourGlass;
DlgForm.Height := Image1.Picture.Bitmap.Height;
DlgForm.Width := Image1.Picture.Bitmap.Width;
{MyHandle := LoadBitmap(HInstance, 'GVICON');
Image1.Picture.Bitmap.Handle := MyHandle;
Image1.Picture.Bitmap.LoadFromFile('C:\MY.BMP');}
{MyTimer := TTimer.Create(DlgForm);
MyTimer.OnTimer(MyTimer);

{ assign(HideGVEmblem);
 Application.OnHint := DisplayHint;
 MyTimer.OnTimer := HideGVEmblem               Handle;}
DlgForm.Show;
{MyBoolean := DeleteObject(Image1.Picture.Bitmap.Handle);
DlgForm.Free;}

Result := DlgForm;
end;

procedure HideBitmap(MYF :TForm);
begin
 DeleteObject(MYF.Tag);
 MYF.Release;
end;

function ShowBitmap(BtMp :PChar; Cursor :TCursor): Pointer;
var      DlgForm               :TForm;
         Image1                :TImage;
begin
DlgForm := TForm.CreateNew(Screen);
DlgForm.FormStyle := fsStayOnTop;
DlgForm.Position := poScreenCenter;
DlgForm.BorderStyle := bsNone;
Image1 := TImage.Create(DlgForm);
Image1.Parent := DlgForm;
Image1.Align := alClient;
Image1.Picture.Bitmap.Handle := LoadBitmap(hInstance, BtMp);
DlgForm.Tag := Image1.Picture.Bitmap.Handle;
Image1.Cursor := Cursor;
DlgForm.Height := Image1.Picture.Bitmap.Height;
DlgForm.Width := Image1.Picture.Bitmap.Width;
DlgForm.Show;
Result := DlgForm;
end;

procedure CopyNotBackRect(Source, Dest :TCanvas; x1, y1, x2, y2, x9, y9 :LongInt; Back :TColor);
var       x, y             :LongInt;
begin
if x1 > x2 then
 begin
  x := x1;
  x1 := x2;
  x2 := x;
 end;
if y1 > y2 then
 begin
  y := y1;
  y1 := y2;
  y2 := y;
 end;
for x := x1 to x2 - 1 do
 for y := y1 to y2 - 1 do
  if Source.Pixels[x,y] <> Back then
   Dest.Pixels[x9 + x - x1, y9 + y - y1] := Source.Pixels[x,y];
end;

function StringExpToExtended(Str :String): Extended;
var      S                  :String;
         Code, i, c         :Integer;
         rt                 :LongInt;
begin
Result := 0;
if length(Str) > 0 then
 begin
  if (length(Str) > 3) and (Str[length(Str) - 3] in ['E', 'e']) then
   S := copy(Str,1,length(Str)-4)
  else
   S := Str;
  if length(S) = 0 then
   Result := 1
  else
   begin
    val(S, Result, Code);
    if Code <> 0 then
     if (S[Code] = DecimalSeparator) then
      begin
       val(copy(S,1,Code-1), rt, c);
       val(copy(S,Code+1,255), Result, c);
       if c > 0 then
        val(copy(S,Code+1,Code+c), Result, c);
       for i := 1 to length(S)-Code do
        Result := Result / 10;
       Result := Result + rt;
      end;
   end;
  if S <> Str then
   begin
    if Str[length(Str)-2] = '-' then
     for i := 1 to StrToInt(copy(Str,length(Str)-1,2)) do
      Result := Result / 10
    else
     for i := 1 to StrToInt(copy(Str,length(Str)-1,2)) do
      Result := Result * 10;
   end;
 end;
end;

function ggT(p, q :LongInt):LongInt;
var      m         :Boolean;
begin
if (p <> 0) and (q <> 0) then
 begin
  m := (p < 0) and (q < 0);
  Result := abs(p);
  q := abs(q);
  while Result <> q do
   if Result < q then
    dec(q, Result)
   else
    dec(Result, q);
  if m then
   Result := -Result;
 end
else
 Result := 0;
end;

function kgV(p, q:Integer): Integer;
begin
if (p <> 0) and (q <> 0) then
 if (p < 0) and (q < 0) then
  Result := -(p * q div ggt(p, q))
 else
  Result := p * q div ggt(p, q)
else
 Result := 0;
end;

function TestForCountSystem(S: String; System: Byte): Integer;
var      i                        :Integer;
begin
if (System < 2) or (System > 36) then
 Result := -1
else
 begin
  Result := 0;
  i := 1;
  while (Result = 0) and (i <= length(S)) do
   if (pos(S[i],CountSystemChars) <> 0) and (pos(S[i],CountSystemChars) <= System) then
    i := i + 1
   else
    Result := i;
 end;
end;

function GetFromCountSystem(S: String; System: Byte): LongInt;
var      i                        :Integer;
begin
Result := 0;
for i := 1 to length(S) do
 Result := Result + round((pos(S[i],CountSystemChars) - 1) * exp((length(S) - i) * ln(System)));
end;

function ChangeToCountSystem(X: LongInt;  System: Byte): String;
var      i                         :Integer;
begin
Result := '';
i := 0;
while X >= Power(i + 1, System) do
 i := i + 1;
for i := i downto 0 do
 begin
  Result := Result + CountSystemChars[(X div round(Power(i, System))) + 1];
  X := X mod round(Power(i, System))
 end;
if X <> 0 then
 Result := 'ERROR';
end;

{function ArcusTangens(a, b :Extended): Extended;
begin
if b = 0 then
 begin
  Result := 0;
  if a > 0 then
   Result := 90;
  if a < 0 then
   Result := 270;
 end
else
 begin
  Result := arctan(a/b)/Pi*180;
  if b < 0 then
   Result := Result + 180;
 end;
end;}

function ConvertBufferToStr(Buffer: PChar; MaxLength: Integer): String;
var      i                 : Integer;
begin
Result := '';
i := 0;
while (Buffer[i] <> #0) and (i < MaxLength) do
 begin
  if Buffer[i] > #31 then
   Result := Result + Buffer[i];
  if Buffer[i] = '#' then
   Result := Result + '#';
  if Buffer[i] < #32 then
   Result := Result + Format('%.2x', [ord(Buffer[i])]);
  inc(i);
 end;
end;

procedure ConvertStrToBuffer(S: String; var Buffer: PChar; MaxLength: Integer);
var       i, j              : Integer;
begin
j := 0;
i := 1;
while (i <= length(S)) and (j < MaxLength) do
 begin
  if S[i] <> '#' then
   begin
    Buffer[j] := S[i];
    inc(i);
   end
  else
   begin
    if S[i + 1] = '#' then
     begin
      Buffer[j] := '#';
      inc(i, 2);
     end
    else
     begin
      Buffer[j] := chr(StrToInt('$' + copy(S, i + 1, 2)));
      inc(i, 3);
     end;
   end;
  inc(j);
 end;
if j < MaxLength then
 Buffer[j] := #0
end;

procedure Waitms(ms: LongWord);
var       Ende                :LongWord;
begin
 Ende := ms + timeGetTime;
 inc(ms, timeGetTime);
 if Ende < ms then
  while timeGetTime > ms do ;
 while timeGetTime < ms do ;
end;

function PathToRegPath(S: String): String;
var      i            :Integer;
begin
Result := '';
for i := 1 to length(S) do
 begin
  Result := Result + S[i];
  if S[i] = '\' then
   Result := Result + S[i];
 end;
end;

(*procedure MemoryCopy(Source, Dest :Pointer; Count :Word);
var       i         :Word;
begin
for i := 0 to Count do
 begin
  Byte(Dest^) := Byte(Source^);
  inc(cardinal(Dest));
  inc(cardinal(Source));
 end;
end;*)

function MakeStr(C: Char; Count: Integer): String;
begin
SetString(Result, nil, Count);
FillChar(Pointer(Result)^, Count, ord(C));
{Result := '';
for Count := 1 to Count do
 Result := Result + C;}
end;

function GetUserString(Text, Title: String; var S: String): Boolean;
var      FormDlg: TForm;
         Label1: TLabel;
         Edit1: TEdit;
begin
 FormDlg := TForm.Create(nil);
 FormDlg.Parent := nil;
 FormDlg.BorderStyle := bsDialog;
 FormDlg.Caption := Title;
 FormDlg.Position := poScreenCenter;
 Label1 := TLabel.Create(FormDlg);
 Label1.Parent := FormDlg;
 Label1.Left := 10;
 Label1.Top := 10;
// Label1.Alignment := taCenter;
 Label1.Caption := Text;
 FormDlg.ClientWidth := Max(LongWord(Label1.Width + 20), 210);
 Label1.Width := FormDlg.ClientWidth - 20;
 Edit1 := TEdit.Create(FormDlg);
 Edit1.Parent := FormDlg;
 Edit1.Left := 10;
 Edit1.Top := Label1.Top + Label1.Height + 10;
 Edit1.Text := S;
 Edit1.Width := Label1.Width;
 with TBitBtn.Create(FormDlg) do
 begin
     Parent := FormDlg;
     Kind := bkOK;
     Left := 15;
     Top := Edit1.Top + Edit1.Height + 15;
     Width := 90;
 end;
 with TBitBtn.Create(FormDlg) do
 begin
     Parent := FormDlg;
     Kind := bkCancel;
     Top := Edit1.Top + Edit1.Height + 15;
     Width := 90;
     Left := FormDlg.ClientWidth - Width - 15;
     FormDlg.ClientHeight := Top + Height + 10;
 end;
 FormDlg.ActiveControl := Edit1;
 Result := FormDlg.ShowModal = mrOK;
 if Result then
     S := Edit1.Text;
 FormDlg.Free;
end;

function GetFileTitle(FileName: String): String;
var      Ret         :SmallInt;
begin
// Result := '';
 Ret := CommDlg.GetFileTitle(PChar(FileName), nil, 0);
 if Ret > 0 then
  begin
   SetLength(Result, Ret - 1);
   if CommDlg.GetFileTitle(PChar(FileName), PChar(Result), Ret) <> 0 then
    Result := '';
  end;
end;

{procedure DrawTransparent(Source: TCanvas; SRect: TRect;
             Dest: TCanvas; DRect: TRect; Color :TColor);
var       BMP                            :TBitmap;
          BMPRect                        :TRect;
          DCM                            :TCopyMode;
begin
BMPRect := rect(0, 0, SRect.Right - SRect.Left, SRect.Bottom - SRect.Top);
DCM := Dest.CopyMode;
BMP := TBitmap.Create;
try
// zu CopyMode siehe auch C:\PROGRAMME\BORLAND\SOURCE\RTL\WIN\WINDOWS.PAS; suche "SRCCOPY"

//  BMP.Monochrome := True;
  BMP.Width := BMPRect.Right + 1;
  BMP.Height := BMPRect.Bottom + 1;

//irgendwie eine Schwarz/Wei-Maske erstellen
  BMP.Canvas.CopyMode := cmSrcCopy; //kopieren
  BMP.Canvas.CopyRect(BMPRect, Source, SRect);
  BMP.Canvas.Pen.Color := clBlack; //Color in clBlack umwandeln
  BMP.Canvas.BrushCopy(BMPRect, BMP, BMPRect, Color);
  BMP.Canvas.CopyMode := cmSrcErase; //alles clBlack oder Color
  BMP.Canvas.CopyRect(BMPRect, Source, SRect);
  BMP.Canvas.Pen.Color := clWhite; //Color in clWhite umwandeln
  BMP.Canvas.BrushCopy(BMPRect, BMP, BMPRect, Color);
//Wei = nicht Anzeigen; Schwarz = Anzeigen

  Dest.CopyMode := cmSrcAnd; //Lschen der nicht Transparenten Pixel
  Dest.CopyRect(DRect, BMP.Canvas, BMPRect);

  BMP.Monochrome := False;
  BMP.Canvas.CopyMode := cmSrcErase; //Kopieren mit Lschen der Transparenten Pixel
  BMP.Canvas.CopyRect(BMPRect, Source, SRect);

  Dest.CopyMode := cmSrcPaint; //Verschmelzen der BMP's
  Dest.CopyRect(DRect, BMP.Canvas, BMPRect);
finally
  BMP.Free;
  Dest.CopyMode := DCM;
end;
end;}

end.
