unit GVSpin;

{$D-}
{$L-}
{$Y-}
{$C-}

{in Package C:\PROGRAMME\BORLAND\DELPHI 3\LIB\DCLUSR30.DPK}

interface

uses Windows, Classes, StdCtrls, ExtCtrls, Controls, Messages, SysUtils,
  Forms, Graphics, Menus, Buttons, Math;

var //beachte: VARIABLEN    knnen also gendert werden
  seInitRepeatPause : Integer = 400;  { pause before repeat timer (ms) }
  seRepeatPause     : LongWord = 100;  { pause before second and later timers (ms)}

type

  TMiddleBtnScrollInt = procedure(Sender: TObject; Delta: LongInt) of object;

  TTimerSpeedButton = class;

{ TGVSpinButton }

  TGVSpinButton = class (TWinControl)
  private
    FUpButton: TTimerSpeedButton;
    FMiddleButton: TSpeedButton;
    FDownButton: TTimerSpeedButton;
    FFocusedButton: TSpeedButton;
    FFocusControl: TWinControl;
    FOnUpClick: TNotifyEvent;
    FOnDownClick: TNotifyEvent;
    FOnMiddleBtnMDown: TNotifyEvent;
    FOnMiddleBtnMMove: TMiddleBtnScrollInt;
    FOnMiddleBtnMUp: TNotifyEvent;
    function CreateButton: TTimerSpeedButton;
    function CreateMButton: TSpeedButton;
    function GetUpGlyph: TBitmap;
    function GetDownGlyph: TBitmap;
    procedure SetUpGlyph(Value: TBitmap);
    procedure SetDownGlyph(Value: TBitmap);
    function GetUpNumGlyphs: TNumGlyphs;
    function GetDownNumGlyphs: TNumGlyphs;
    procedure SetUpNumGlyphs(Value: TNumGlyphs);
    procedure SetDownNumGlyphs(Value: TNumGlyphs);
    procedure BtnClick(Sender: TObject);
    procedure BtnMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure MBtnMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure MBtnMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure MBtnMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure AdjustSize (var W, H: Integer); reintroduce;
    procedure WMSize(var Message: TWMSize);  message WM_SIZE;
    procedure WMGetDlgCode(var Message: TWMGetDlgCode); message WM_GETDLGCODE;
    procedure SetFocusBtn(Btn: TSpeedButton);
    procedure SetMiddleButton(Value: Boolean);
    function GetMiddleButton: Boolean;
  protected
    procedure Loaded; override;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
  public
    constructor Create(AOwner: TComponent); override;
    procedure SetBounds(ALeft, ATop, AWidth, AHeight: Integer); override;
    property ButtonUp: TTimerSpeedButton read FUpButton;
    property ButtonMiddle: TSpeedButton read FMiddleButton;
    property ButtonDown: TTimerSpeedButton read FDownButton;
  published
    property Align;
    property Anchors;
    property Constraints;
    property Ctl3D;
    property DownGlyph: TBitmap read GetDownGlyph write SetDownGlyph;
    property DownNumGlyphs: TNumGlyphs read GetDownNumGlyphs write SetDownNumGlyphs default 1;
    property DragCursor;
    property DragKind;
    property DragMode;
    property Enabled;
    property FocusControl: TWinControl read FFocusControl write FFocusControl;
    property MiddleButton: Boolean read GetMiddleButton write SetMiddleButton default True;
    property ParentCtl3D;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property TabOrder;
    property TabStop;
    property UpGlyph: TBitmap read GetUpGlyph write SetUpGlyph;
    property UpNumGlyphs: TNumGlyphs read GetUpNumGlyphs write SetUpNumGlyphs default 1;
    property Visible;
    property OnDownClick: TNotifyEvent read FOnDownClick write FOnDownClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDock;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnMiddleBtnMDown: TNotifyEvent read FOnMiddleBtnMDown write FOnMiddleBtnMDown;
    property OnMiddleBtnMMove: TMiddleBtnScrollInt read FOnMiddleBtnMMove write FOnMiddleBtnMMove;
    property OnMiddleBtnMUp: TNotifyEvent read FOnMiddleBtnMUp write FOnMiddleBtnMUp;
    property OnStartDock;
    property OnStartDrag;
    property OnUpClick: TNotifyEvent read FOnUpClick write FOnUpClick;
  end;

{ TGVSpinEdit }

  TMiddleBtnScroll = procedure(Sender: TObject; Delta: LongInt; StartValue: LongInt; var Value: LongInt) of object;

  TNumGlyphs = Buttons.TNumGlyphs;

  TGVSpinEditOption = (gvseoClipCursor, gvseoMiddleButton);
  TGVSpinEditOptions = set of TGVSpinEditOption;

  TGVSpinEdit = class(TCustomEdit)
  private
    FMinValue: LongInt;
    FMaxValue: LongInt;
    FIncrement: LongInt;
    FButton: TGVSpinButton;
    FEditorEnabled: Boolean;
    FMBDStartValue: LongInt;
    FOptions: TGVSpinEditOptions;
    FPoint: Byte;
    FOnUpClick: TNotifyEvent;
    FOnDownClick: TNotifyEvent;
    FOnMiddleBtnMDown: TNotifyEvent;
    FOnMiddleBtnMMove: TMiddleBtnScroll;
    FOnMiddleBtnMUp: TNotifyEvent;
    function GetValue: LongInt;
    function CheckValue (NewValue: LongInt): LongInt;
    procedure SetValue (NewValue: LongInt);
    procedure WMSize(var Message: TWMSize); message WM_SIZE;
    procedure CMEnter(var Message: TCMGotFocus); message CM_ENTER;
    procedure CMExit(var Message: TCMExit); message CM_EXIT;
    procedure WMPaste(var Message: TWMPaste); message WM_PASTE;
    procedure WMCut(var Message: TWMCut); message WM_CUT;
  protected
    FChangeTimer: TTimer;
    procedure GetChildren(Proc: TGetChildProc; Root: TComponent); override;
    function IsValidChar(Key: Char): Boolean; virtual;
    procedure UpClick (Sender: TObject); virtual;
    procedure DownClick (Sender: TObject); virtual;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure KeyPress(var Key: Char); override;
    procedure CreateParams(var Params: TCreateParams); override; //s. Hilfe: CreateWindowEx
    procedure Change; override;
    procedure ChangeTimerTimer(Sender: TObject);
    procedure SetChangeDelay(Value: LongInt);
    function GetChangeDelay: LongInt;
    procedure DoChange;
    procedure MiddleBtnMDown(Sender: TObject);
    procedure MiddleBtnMMove(Sender: TObject; Delta: LongInt);
    procedure MiddleBtnMUp(Sender: TObject);
    procedure SetOptions(Value: TGVSpinEditOptions);
    procedure SetPoint(New: Byte);
    procedure CreateHandle; override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Assign(Source: TPersistent); override;
    property Button: TGVSpinButton read FButton;
  published
    property Anchors;
    property AutoSelect;
    property AutoSize;
    property BorderStyle;
    property ChangeDelay: LongInt read GetChangeDelay write SetChangeDelay default 0;
    property Color;
    property Constraints;
    property Ctl3D;
    property DragCursor;
    property DragMode;
    property EditorEnabled: Boolean read FEditorEnabled write FEditorEnabled default True;
    property Enabled;
    property Font;
    property Increment: LongInt read FIncrement write FIncrement default 1;
    property MaxLength;
    property MaxValue: LongInt read FMaxValue write FMaxValue default 0;
    property MinValue: LongInt read FMinValue write FMinValue default 0;
    property Options: TGVSpinEditOptions read FOptions write SetOptions default [gvseoMiddleButton];
    property ParentColor;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property Point: Byte read FPoint write SetPoint default 0;
    property PopupMenu;
    property ReadOnly;
    property ShowHint;
    property TabOrder;
    property TabStop;
    property Value: LongInt read GetValue write SetValue default 0;
    property Visible;
    property OnChange;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnMiddleBtnMDown: TNotifyEvent read FOnMiddleBtnMDown write FOnMiddleBtnMDown;
    property OnMiddleBtnMMove: TMiddleBtnScroll read FOnMiddleBtnMMove write FOnMiddleBtnMMove;
    property OnMiddleBtnMUp: TNotifyEvent read FOnMiddleBtnMUp write FOnMiddleBtnMUp;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnStartDrag;
    property OnUpClick: TNotifyEvent read FOnUpClick write FOnUpClick;
    property OnDownClick: TNotifyEvent read FOnDownClick write FOnDownClick;
  end;

{ TExtSpinEdit }

  TMiddleBtnScrollExt = procedure(Sender: TObject; Delta: LongInt; StartValue: Extended; var Value: Extended) of object;

  TExtSpinEditOption = (eseoMiddleButton, eseoRelativIncrement);
  TExtSpinEditOptions = set of TExtSpinEditOption;

  TExtSpinEdit = class(TCustomEdit)
  private
    FMinValue: Extended;
    FMaxValue: Extended;
    FIncrement: Extended;
    FButton: TGVSpinButton;
    FEditorEnabled: Boolean;
    FMBDStartValue: Extended;
    FOptions: TExtSpinEditOptions;
    FOnUpClick: TNotifyEvent;
    FOnDownClick: TNotifyEvent;
    FOnMiddleBtnMDown: TNotifyEvent;
    FOnMiddleBtnMMove: TMiddleBtnScrollExt;
    FOnMiddleBtnMUp: TNotifyEvent;
    function GetValue: Extended;
    function CheckValue(NewValue: Extended): Extended;
    procedure SetValue(NewValue: Extended);
    function GetIncrement(Value: Extended; Factor: Integer): Extended;
    function GetDecrement(Value: Extended; Factor: Integer): Extended;
    procedure WMSize(var Message: TWMSize); message WM_SIZE;
    procedure CMEnter(var Message: TCMGotFocus); message CM_ENTER;
    procedure CMExit(var Message: TCMExit); message CM_EXIT;
    procedure WMPaste(var Message: TWMPaste); message WM_PASTE;
    procedure WMCut(var Message: TWMCut); message WM_CUT;
  protected
    FChangeTimer: TTimer;
    procedure GetChildren(Proc: TGetChildProc; Root: TComponent); override;
    function IsValidChar(Key: Char): Boolean; virtual;
    procedure UpClick (Sender: TObject); virtual;
    procedure DownClick (Sender: TObject); virtual;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure KeyPress(var Key: Char); override;
    procedure CreateParams(var Params: TCreateParams); override; //s. Hilfe: CreateWindowEx
    procedure Change; override;
    procedure ChangeTimerTimer(Sender: TObject);
    procedure SetChangeDelay(Value: LongInt);
    function GetChangeDelay: LongInt;
    procedure DoChange;
    procedure MiddleBtnMDown(Sender: TObject);
    procedure MiddleBtnMMove(Sender: TObject; Delta: LongInt);
    procedure MiddleBtnMUp(Sender: TObject);
    procedure SetOptions(Value: TExtSpinEditOptions);
    procedure CreateHandle; override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Assign(Source: TPersistent); override;
    property Button: TGVSpinButton read FButton;
  published
    property Anchors;
    property AutoSelect;
    property AutoSize;
    property BorderStyle;
    property ChangeDelay: LongInt read GetChangeDelay write SetChangeDelay default 0;
    property Color;
    property Constraints;
    property Ctl3D;
    property DragCursor;
    property DragMode;
    property EditorEnabled: Boolean read FEditorEnabled write FEditorEnabled default True;
    property Enabled;
    property Font;
    property Increment: Extended read FIncrement write FIncrement;
    property MaxLength;
    property MaxValue: Extended read FMaxValue write FMaxValue;
    property MinValue: Extended read FMinValue write FMinValue;
    property Options: TExtSpinEditOptions read FOptions write SetOptions default [eseoMiddleButton, eseoRelativIncrement];
    property ParentColor;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ReadOnly;
    property ShowHint;
    property TabOrder;
    property TabStop;
    property Value: Extended read GetValue write SetValue;
    property Visible;
    property OnChange;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnMiddleBtnMDown: TNotifyEvent read FOnMiddleBtnMDown write FOnMiddleBtnMDown;
    property OnMiddleBtnMMove: TMiddleBtnScrollExt read FOnMiddleBtnMMove write FOnMiddleBtnMMove;
    property OnMiddleBtnMUp: TNotifyEvent read FOnMiddleBtnMUp write FOnMiddleBtnMUp;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnStartDrag;
    property OnUpClick: TNotifyEvent read FOnUpClick write FOnUpClick;
    property OnDownClick: TNotifyEvent read FOnDownClick write FOnDownClick;
  end;

{ TTimerSpeedButton }

  TTimerSpeedButton = class(TSpeedButton)
  private
    FRepeatTimer: TTimer;
    FAllowTimer: Boolean;
    procedure TimerExpired(Sender: TObject);
  protected
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
  public
    destructor Destroy; override;
    property AllowTimer: Boolean read FAllowTimer write FAllowTimer;
  end;

procedure Register;

implementation

  uses
    My3Unit;

{$R GVSpin}

procedure Register;
begin
 RegisterComponents('Beispiele', [TGVSpinEdit, TExtSpinEdit])
end;

{ TGVSpinButton }

constructor TGVSpinButton.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  ControlStyle := ControlStyle - [csAcceptsControls, csSetCaption] +
    [csFramed, csOpaque];

  FUpButton := CreateButton;
  FMiddleButton := CreateMButton;
  FDownButton := CreateButton;
  UpGlyph := nil;   //ladet die Default-Bilder
  DownGlyph := nil; //fr die beiden Buttons.

  SetBounds(Left, Top, 20, 25);
  FFocusedButton := FUpButton;
end;

function TGVSpinButton.CreateButton: TTimerSpeedButton;
begin
  Result := TTimerSpeedButton.Create(Self);
  Result.OnClick := BtnClick;
  Result.OnMouseDown := BtnMouseDown;
  Result.Visible := True;
  Result.Enabled := True;
  Result.Layout := blGlyphBottom;
  Result.AllowTimer := True;
  Result.Parent := Self;
end;

function TGVSpinButton.CreateMButton: TSpeedButton;
begin
  Result := TSpeedButton.Create(Self);
  Result.OnMouseDown := MBtnMouseDown;
  Result.OnMouseMove := MBtnMouseMove;
  Result.OnMouseUp := MBtnMouseUp;
  Result.Cursor := crVSplit;
  Result.Visible := True;
  Result.Enabled := True;
  Result.Parent := Self;
end;

procedure TGVSpinButton.Notification(AComponent: TComponent; Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if (Operation = opRemove) and (AComponent = FFocusControl) then
    FFocusControl := nil;
end;

procedure TGVSpinButton.AdjustSize (var W, H: Integer);
begin
  if (FUpButton = nil) or (csLoading in ComponentState) then Exit;
  if W < 15 then W := 15;
  if FMiddleButton.Visible then
   begin
    FUpButton.SetBounds (0, 0, W, H shr 1);
    FDownButton.SetBounds (0, H - FUpButton.Height + 1, W, FUpButton.Height);
    FMiddleButton.SetBounds(0, FUpButton.Height - 1, W, H - FUpButton.Height - FDownButton.Height + 3);
   end
  else
   begin
    FUpButton.SetBounds (0, 0, W, H shr 1 + 1);
    FDownButton.SetBounds (0, FUpButton.Height - 1, W, H - FUpButton.Height + 2);
   end;
end;

procedure TGVSpinButton.SetBounds(ALeft, ATop, AWidth, AHeight: Integer);
var       W, H         :Integer;
begin
 W := AWidth;
 H := AHeight;
 AdjustSize(W, H);
 inherited SetBounds(ALeft, ATop, W, H);
 if Owner is TCustomEdit then
  (Owner as TCustomEdit).Perform(EM_SETMARGINS, EC_RIGHTMARGIN, (AWidth - 2) shl 16);
end;

procedure TGVSpinButton.WMSize(var Message: TWMSize);
var       W, H                :Integer;
begin
  inherited;
  { check for minimum size }
  W := Width;
  H := Height;
  AdjustSize (W, H);
  if (W <> Width) or (H <> Height) then
    inherited SetBounds(Left, Top, W, H);
  Message.Result := 0;
end;

procedure TGVSpinButton.KeyDown(var Key: Word; Shift: TShiftState);
begin
  case Key of
    VK_UP:
      FUpButton.Click;
    VK_DOWN:
      FDownButton.Click;
    VK_SPACE:
      FFocusedButton.Click;
  end;
end;

procedure TGVSpinButton.BtnMouseDown (Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if Button = mbLeft then
  begin
    SetFocusBtn(TSpeedButton(Sender));
    if (FFocusControl <> nil) and FFocusControl.TabStop and
        FFocusControl.CanFocus and (GetFocus <> FFocusControl.Handle) then
      FFocusControl.SetFocus
    else if TabStop and (GetFocus <> Handle) and CanFocus then
      SetFocus;
  end;
end;

procedure TGVSpinButton.BtnClick(Sender: TObject);
begin
  if Sender = FUpButton then
  begin
    if Assigned(FOnUpClick) then FOnUpClick(Self);
  end
  else
    if Assigned(FOnDownClick) then FOnDownClick(Self);
end;

procedure TGVSpinButton.MBtnMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if Button = mbLeft then
  begin
    SetFocusBtn(TSpeedButton(Sender));
    if (FFocusControl <> nil) and FFocusControl.TabStop and
        FFocusControl.CanFocus and (GetFocus <> FFocusControl.Handle) then
      FFocusControl.SetFocus
    else if TabStop and (GetFocus <> Handle) and CanFocus then
      SetFocus;
    FMiddleButton.Tag := Y;
    if Assigned(FOnMiddleBtnMDown) then
     FOnMiddleBtnMDown(Self);
  end;
end;

procedure TGVSpinButton.MBtnMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
begin
  if ssLeft in Shift then
   if Assigned(FOnMiddleBtnMMove) then
    FOnMiddleBtnMMove(Self, FMiddleButton.Tag - Y);
end;

procedure TGVSpinButton.MBtnMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
 if (Button = mbLeft) and Assigned(FOnMiddleBtnMUp) then
  FOnMiddleBtnMUp(Self);
end;

procedure TGVSpinButton.WMGetDlgCode(var Message: TWMGetDlgCode);
begin
 Message.Result := DLGC_WANTARROWS;
end;

procedure TGVSpinButton.SetFocusBtn(Btn: TSpeedButton);
begin
 FFocusedButton := Btn;
end;

procedure TGVSpinButton.Loaded;
var
  W, H: Integer;
begin
  inherited Loaded;
  W := Width;
  H := Height;
  AdjustSize (W, H);
  if (W <> Width) or (H <> Height) then
    inherited SetBounds (Left, Top, W, H);
end;

procedure TGVSpinButton.SetMiddleButton(Value: Boolean);
var       W, H                         :Integer;
begin
 FMiddleButton.Visible := Value;
 W := Width;
 H := Height;
 AdjustSize(W, H);
end;

function TGVSpinButton.GetMiddleButton: Boolean;
begin
 Result := FMiddleButton.Visible;
end;

function TGVSpinButton.GetUpGlyph: TBitmap;
begin
  Result := FUpButton.Glyph;
end;

procedure TGVSpinButton.SetUpGlyph(Value: TBitmap);
begin
  if Value <> nil then
    FUpButton.Glyph := Value
  else
  begin
    FUpButton.Glyph.Handle := LoadBitmap(HInstance, 'GVSpinUp');
    FUpButton.NumGlyphs := 1;
  end;
  FUpButton.Invalidate;
end;

function TGVSpinButton.GetUpNumGlyphs: TNumGlyphs;
begin
  Result := FUpButton.NumGlyphs;
end;

procedure TGVSpinButton.SetUpNumGlyphs(Value: TNumGlyphs);
begin
  FUpButton.NumGlyphs := Value;
end;

function TGVSpinButton.GetDownGlyph: TBitmap;
begin
  Result := FDownButton.Glyph;
end;

procedure TGVSpinButton.SetDownGlyph(Value: TBitmap);
begin
  if Value <> nil then
    FDownButton.Glyph := Value
  else
  begin
    FDownButton.Glyph.Handle := LoadBitmap(HInstance, 'GVSpinDown');
    FUpButton.NumGlyphs := 1;
  end;
  FDownButton.Invalidate;
end;

function TGVSpinButton.GetDownNumGlyphs: TNumGlyphs;
begin
  Result := FDownButton.NumGlyphs;
end;

procedure TGVSpinButton.SetDownNumGlyphs(Value: TNumGlyphs);
begin
  FDownButton.NumGlyphs := Value;
end;


{ TGVSpinEdit }


constructor TGVSpinEdit.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FButton := TGVSpinButton.Create(Self);
  FButton.Parent := Self;
  FButton.SetBounds(FButton.Left, FButton.Top, 15, 17);
  FButton.Visible := True;
  FButton.FocusControl := Self;
  FButton.OnUpClick := UpClick;
  FButton.OnDownClick := DownClick;
  FButton.OnMiddleBtnMDown := MiddleBtnMDown;
  FButton.OnMiddleBtnMMove := MiddleBtnMMove;
  FButton.OnMiddleBtnMUp := MiddleBtnMUp;
  FChangeTimer := nil;
  FOptions := [gvseoMiddleButton];
  Width := 60;
  MaxLength := 11;
  Text := '0';
  ControlStyle := ControlStyle - [csSetCaption];
  FIncrement := 1;
  FEditorEnabled := True;
  Perform(EM_SETMARGINS, EC_RIGHTMARGIN, 50 shl 16)
end;

destructor TGVSpinEdit.Destroy;
begin
  FButton := nil;
  FChangeTimer.Free;
  inherited Destroy;
end;

procedure TGVSpinEdit.Assign(Source: TPersistent);
begin
 if Source is TGVSpinEdit then
  with Source as TGVSpinEdit do
   begin
    Self.Parent := Parent;
    Self.FMinValue := FMinValue;
    Self.FMaxValue := FMaxValue;
    Self.FIncrement := FIncrement;
    Self.FEditorEnabled := FEditorEnabled;
    Self.FMBDStartValue := FMBDStartValue;
    Self.FOptions := FOptions;
    Self.FPoint := FPoint;
    Self.OnChange := OnChange;
    Self.FOnUpClick := FOnUpClick;
    Self.FOnDownClick := FOnDownClick;
    Self.FOnMiddleBtnMDown := FOnMiddleBtnMDown;
    Self.FOnMiddleBtnMMove := FOnMiddleBtnMMove;
    Self.FOnMiddleBtnMUp := FOnMiddleBtnMUp;

    Self.MaxLength := MaxLength;
    Self.Enabled := Enabled;
    Self.Visible := Visible;
    Self.SetBounds(Left, Top, Width, Height);
//    Self.Perform(WM_SIZE, 0, Self.Height shl 16 or Self.Width);
//    Self.Width := Width;
    Self.Value := Value;
   end
 else
  inherited;
end;

procedure TGVSpinEdit.GetChildren(Proc: TGetChildProc; Root: TComponent);
begin
end;

procedure TGVSpinEdit.KeyDown(var Key: Word; Shift: TShiftState);
begin
 if Key = VK_UP then
  begin
   UpClick(Self);
   Key := 0;
  end
 else
  if Key = VK_DOWN then
   begin
    DownClick(Self);
    Key := 0;
   end
  else
   if (Key = VK_ESCAPE) and (GetCaptureControl = FButton.FMiddleButton) then
    begin
     ReleaseCapture;
     PostMessage(FButton.Handle, WM_LBUTTONUP, 0, 0);
     FButton.FMiddleButton.Down := False;
     Value := FMBDStartValue;
    end
   else
    inherited {KeyDown(Key, Shift)};
end;

procedure TGVSpinEdit.KeyPress(var Key: Char);
begin
 if not IsValidChar(Key) then
  begin
   Key := #0;
   MessageBeep(0)
  end;
 if Key <> #0 then
  inherited {KeyPress(Key)};
end;

function TGVSpinEdit.IsValidChar(Key: Char): Boolean;
begin
 Result := (Key < #32) or (Key in [DecimalSeparator{, '+'}, '-', '0'..'9']); //allg. Valid
 if Result and (Key = '-') and ((pos('-', Text) > 0) or (SelStart > 0)) and (pos('-', SelText) = 0) then
  Result := False;
 if Result and (Key = DecimalSeparator) and ((FPoint = 0) or ((pos(DecimalSeparator, Text) > 0) and (pos(DecimalSeparator, SelText) = 0))) then
  Result := False;
 if Result and not FEditorEnabled and
         ((Key >= #32) or (Key = Char(VK_BACK)) or (Key = Char(VK_DELETE))) then
  Result := False;
end;

procedure TGVSpinEdit.CreateParams(var Params: TCreateParams);
begin //s. Hilfe: CreateWindowEx
 inherited CreateParams(Params);
 Params.Style := Params.Style or WS_CLIPCHILDREN;
end;

procedure TGVSpinEdit.ChangeTimerTimer(Sender: TObject);
begin
 FChangeTimer.Enabled := False;
 DoChange;
end;

procedure TGVSpinEdit.SetChangeDelay(Value: LongInt);
begin
 if Value <> 0 then
  begin
   FChangeTimer := TTimer.Create(Self);
   FChangeTimer.Enabled := False;
   FChangeTimer.Interval := Value;
   FChangeTimer.OnTimer := ChangeTimerTimer;
  end
 else
  if Assigned(FChangeTimer) then
   FChangeTimer.Free;
end;

function TGVSpinEdit.GetChangeDelay: LongInt;
begin
 if assigned(FChangeTimer) then
  Result := FChangeTimer.Interval
 else
  Result := 0;
end;

procedure TGVSpinEdit.SetOptions(Value: TGVSpinEditOptions);
begin
 FButton.MiddleButton := gvseoMiddleButton in Value;
 FOptions := Value;
end;

procedure TGVSpinEdit.CreateHandle;
begin
 inherited;
 Perform(EM_SETMARGINS, EC_RIGHTMARGIN, (FButton.Width - 2) shl 16);
end;

procedure TGVSpinEdit.SetPoint(New: Byte);
var       TMP     :Integer;
          SI      :ShortInt;
begin
 if New <= 10 then
  begin
   TMP := Value;
   SI := FPoint - New;
   FPoint := New;
   if SI > 0 then
    while SI > 0 do
     begin
      TMP := TMP div 10;
      dec(SI);
     end
   else
    while SI < 0 do
     begin
      TMP := TMP * 10;
      inc(SI);
     end;
   Value := TMP;
  end;
end;

procedure TGVSpinEdit.Change;
begin
 if assigned(FChangeTimer) then
  with FChangeTimer do
   begin
    Enabled := False;
    Enabled := True;
   end
 else
  DoChange;
end;

procedure TGVSpinEdit.DoChange;
begin
 inherited Change;
end;

procedure TGVSpinEdit.WMSize(var Message: TWMSize);
begin
 inherited;
 if FButton <> nil then
  begin
//  FButton.Left := Width - FButton.Width;
   if BorderStyle = bsNone then
    FButton.SetBounds(Width - FButton.Width, 0, FButton.Width, Height)
   else
    if NewStyleControls and Ctl3D then //abc
     FButton.SetBounds(Width - FButton.Width - 4, 0, FButton.Width, Height - 4)
    else
     FButton.SetBounds (Width - FButton.Width, 1, FButton.Width, Height - 2);
  end;
end;

procedure TGVSpinEdit.UpClick(Sender: TObject);
begin
 if ReadOnly then
  MessageBeep(0)
 else
  begin
   Modified := True;
   Value := Value + FIncrement;
   if Assigned(FOnUpClick) then
    FOnUpClick(Self);
  end;
end;                

procedure TGVSpinEdit.DownClick(Sender: TObject);
begin
 if ReadOnly then
  MessageBeep(0)
 else
  begin
   Modified := True;
   Value := Value - FIncrement;
   if Assigned(FOnDownClick) then
    FOnDownClick(Self);
  end;
end;

procedure TGVSpinEdit.MiddleBtnMDown(Sender: TObject);
var       MyRect                    :TRect;
          MyPoint                   :TPoint;
begin
 FMBDStartValue := Value;
 if (gvseoClipCursor in FOptions) and (FMaxValue <> FMinValue)then
  begin
   GetCursorPos(MyPoint);
   MyRect.Left := MyPoint.x;//0;
   MyRect.Top := Max(0, MyPoint.y - (FMaxValue - FMBDStartValue) div FIncrement);
   MyRect.Right := MyPoint.x;//Screen.Width-1;
   MyRect.Bottom := Min(Screen.Height-1, MyPoint.y + 1 + (FMBDStartValue - FMinValue) div FIncrement);
   Windows.ClipCursor(@MyRect);
  end;
 if Assigned(FOnMiddleBtnMDown) then
  FOnMiddleBtnMDown(Self);
end;

procedure TGVSpinEdit.MiddleBtnMMove(Sender: TObject; Delta: LongInt);
var       NewValue                  :LongInt;
begin
 NewValue := FMBDStartValue + FIncrement * Delta;
 if Assigned(FOnMiddleBtnMMove) then
  FOnMiddleBtnMMove(Self, Delta, FMBDStartValue, NewValue);
 Modified := True;
 Value := NewValue;
end;

procedure TGVSpinEdit.MiddleBtnMUp(Sender: TObject);
begin
 if gvseoClipCursor in FOptions then
  Windows.ClipCursor(nil);
 if Assigned(FOnMiddleBtnMUp) then
  FOnMiddleBtnMUp(Self);
end;

procedure TGVSpinEdit.WMPaste(var Message: TWMPaste);
begin
 if FEditorEnabled and not ReadOnly then
  inherited;
end;

procedure TGVSpinEdit.WMCut(var Message: TWMPaste);
begin
 if FEditorEnabled and not ReadOnly then
  inherited;
end;

procedure TGVSpinEdit.CMExit(var Message: TCMExit);
begin
 SetValue(GetValue); // oder Value := Value;
 inherited;
end;

function TGVSpinEdit.GetValue: LongInt;
begin
 if ((Text = '') or (Text = '-') or (Text = DecimalSeparator) or (Text = '-' + DecimalSeparator) or (Text = DecimalSeparator + '-')) and (FMinValue <= 0) and (FMaxValue >= 0) then
  Result := 0
 else
  if FPoint = 0 then
   Result := CheckValue(StrToIntDef(Text, FMinValue))
  else
   if pos(DecimalSeparator, Text) = 0 then
    Result := CheckValue(StrToIntDef(Text + MakeStr('0', FPoint), FMinValue))
   else
    begin
     Result := CheckValue(StrToIntDef(
           copy(Text, 1, pos(DecimalSeparator, Text) - 1) +
           copy(Text + MakeStr('0', FPoint), pos(DecimalSeparator, Text) + 1, FPoint),
     FMinValue));
    end;
end;

procedure TGVSpinEdit.SetValue(NewValue: LongInt);
var       S          :String;
begin
 S := IntToStr(CheckValue(NewValue));
 if FPoint > 0 then
  begin
   if Length(S) <= FPoint then
    S := MakeStr('0', FPoint - Length(S) + 1) + S;
   Insert(DecimalSeparator, S, Length(S) - FPoint + 1);
  end;
 Text := S;
end;

function TGVSpinEdit.CheckValue(NewValue: LongInt): LongInt;
begin
 Result := NewValue;
 if (FMaxValue <> FMinValue) then
  if NewValue < FMinValue then
   Result := FMinValue
  else
   if NewValue > FMaxValue then
    Result := FMaxValue;
end;

procedure TGVSpinEdit.CMEnter(var Message: TCMGotFocus);
begin
 if AutoSelect and not (csLButtonDown in ControlState) then
  SelectAll;
 inherited;
end;

{ TExtSpinEdit }

constructor TExtSpinEdit.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FButton := TGVSpinButton.Create(Self);
  FButton.SetBounds(FButton.Left, FButton.Top, 15, 17);
  FButton.Visible := True;
  FButton.Parent := Self;
  FButton.FocusControl := Self;
  FButton.OnUpClick := UpClick;
  FButton.OnDownClick := DownClick;
  FButton.OnMiddleBtnMDown := MiddleBtnMDown;
  FButton.OnMiddleBtnMMove := MiddleBtnMMove;
  FButton.OnMiddleBtnMUp := MiddleBtnMUp;
  FChangeTimer := nil;
  FOptions := [eseoMiddleButton, eseoRelativIncrement];
  Width := 60;
  Text := '0';
  ControlStyle := ControlStyle - [csSetCaption];
  FIncrement := 1.0;
  FEditorEnabled := True;
  Perform(EM_SETMARGINS, EC_RIGHTMARGIN, 50 shl 16)
end;

destructor TExtSpinEdit.Destroy;
begin
  FButton := nil;
  FChangeTimer.Free;
  inherited Destroy;
end;

procedure TExtSpinEdit.Assign(Source: TPersistent);
begin
 if Source is TExtSpinEdit then
  with Source as TExtSpinEdit do
   begin
    Self.Parent := Parent;
    Self.FMinValue := FMinValue;
    Self.FMaxValue := FMaxValue;
    Self.FIncrement := FIncrement;
    Self.FEditorEnabled := FEditorEnabled;
    Self.FMBDStartValue := FMBDStartValue;
    Self.FOptions := FOptions;
    Self.OnChange := OnChange;
    Self.FOnUpClick := FOnUpClick;
    Self.FOnDownClick := FOnDownClick;
    Self.FOnMiddleBtnMDown := FOnMiddleBtnMDown;
    Self.FOnMiddleBtnMMove := FOnMiddleBtnMMove;
    Self.FOnMiddleBtnMUp := FOnMiddleBtnMUp;

    Self.MaxLength := MaxLength;
    Self.Enabled := Enabled;
    Self.Visible := Visible;
    Self.SetBounds(Left, Top, Width, Height);
//    Self.Perform(WM_SIZE, 0, Self.Height shl 16 or Self.Width);
//    Self.Width := Width;
    Self.Value := Value;
   end
 else
  inherited;
end;

procedure TExtSpinEdit.GetChildren(Proc: TGetChildProc; Root: TComponent);
begin
end;

procedure TExtSpinEdit.KeyDown(var Key: Word; Shift: TShiftState);
begin
 if Key = VK_UP then
  begin
   UpClick(Self);
   Key := 0;
  end
 else
  if Key = VK_DOWN then
   begin
    DownClick(Self);
    Key := 0;
   end
  else
   if (Key = VK_ESCAPE) and (GetCaptureControl = FButton.FMiddleButton) then
    begin
     ReleaseCapture;
     PostMessage(FButton.Handle, WM_LBUTTONUP, 0, 0);
     FButton.FMiddleButton.Down := False;
     Value := FMBDStartValue;
    end
   else
    inherited {KeyDown(Key, Shift)};
end;

procedure TExtSpinEdit.KeyPress(var Key: Char);
begin
 if not IsValidChar(Key) then
  begin
   Key := #0;
   MessageBeep(0)
  end;
 if Key <> #0 then
  inherited {KeyPress(Key)};
end;

function TExtSpinEdit.IsValidChar(Key: Char): Boolean;
var      x           :Integer;
begin
 Result := (Key < #32) or (Key in [DecimalSeparator{, '+'}, '-', '0'..'9', 'e', 'E']); //allg. Valid
 if Result and not FEditorEnabled and
         ((Key >= #32) or (Key = Char(VK_BACK)) or (Key = Char(VK_DELETE))) then
  Result := False;
//-xxxxe-yyy
 if Result and (Key = '-') then
  begin
   x := pos('-', Text);
   if x = 0 then
    begin
     if (SelStart > 0) and not(Text[SelStart{-1}] in ['e', 'E']) then
      Result := False
    end
   else
    if ((SelStart > 0) and not (Text[SelStart] in ['e', 'E'])) or // -- && [a-df-z]-
       ((Length(Text) > SelStart) and (Text[SelStart + 1] = '-') and (SelLength = 0)) then // --
     Result := False;
 end;
 if Result and (Key in ['e', 'E']) then
  if (SelStart = 0) or ((pos('e', Text) + pos('E', Text) <> 0) and (pos('e', SelText) + pos('E', SelText) = 0)) then
   Result := False;
 if Result and (Key = DecimalSeparator) and ((pos(DecimalSeparator, Text) > 0) and (pos(DecimalSeparator, SelText) = 0)) then
  Result := False;
end;

procedure TExtSpinEdit.CreateParams(var Params: TCreateParams);
begin //s. Hilfe: CreateWindowEx
 inherited CreateParams(Params);
 Params.Style := Params.Style or WS_CLIPCHILDREN;
end;

procedure TExtSpinEdit.ChangeTimerTimer(Sender: TObject);
begin
 FChangeTimer.Enabled := False;
 DoChange;
end;

procedure TExtSpinEdit.SetChangeDelay(Value: LongInt);
begin
 if Value <> 0 then
  begin
   FChangeTimer := TTimer.Create(Self);
   FChangeTimer.Enabled := False;
   FChangeTimer.Interval := Value;
   FChangeTimer.OnTimer := ChangeTimerTimer;
  end
 else
  if Assigned(FChangeTimer) then
   FChangeTimer.Free;
end;

function TExtSpinEdit.GetChangeDelay: LongInt;
begin
 if assigned(FChangeTimer) then
  Result := FChangeTimer.Interval
 else
  Result := 0;
end;

procedure TExtSpinEdit.SetOptions(Value: TExtSpinEditOptions);
begin
 FButton.MiddleButton := eseoMiddleButton in Value;
 FOptions := Value;
end;

procedure TExtSpinEdit.CreateHandle;
begin
 inherited;
 Perform(EM_SETMARGINS, EC_RIGHTMARGIN, (FButton.Width - 2) shl 16);
end;

procedure TExtSpinEdit.Change;
begin
 if assigned(FChangeTimer) then
  with FChangeTimer do
   begin
    Enabled := False;
    Enabled := True;
   end
 else
  DoChange;
end;

procedure TExtSpinEdit.DoChange;
begin
 inherited Change;
end;

procedure TExtSpinEdit.WMSize(var Message: TWMSize);
begin
 inherited;
 if FButton <> nil then
  begin
//  FButton.Left := Width - FButton.Width;
   if BorderStyle = bsNone then
    FButton.SetBounds(Width - FButton.Width, 0, FButton.Width, Height)
   else
    if NewStyleControls and Ctl3D then //abc
     FButton.SetBounds(Width - FButton.Width - 4, 0, FButton.Width, Height - 4)
    else
     FButton.SetBounds (Width - FButton.Width, 1, FButton.Width, Height - 2);
  end;
end;

procedure TExtSpinEdit.UpClick(Sender: TObject);
var       Val                 :Extended;
begin
 if ReadOnly then
  MessageBeep(0)
 else
  begin
   Modified := True;
   Val := Value;
   if eseoRelativIncrement in FOptions then
    Value := GetIncrement(Val, 1)
   else
    Value := Val + FIncrement;
   if Assigned(FOnUpClick) then
    FOnUpClick(Self);
  end;
end;

procedure TExtSpinEdit.DownClick(Sender: TObject);
var       Val                 :Extended;
begin
 if ReadOnly then
  MessageBeep(0)
 else
  begin
   Modified := True;
   Val := Value;
   if eseoRelativIncrement in FOptions then
    Value := GetDecrement(Val, 1)
   else
    Value := Value - FIncrement;
   if Assigned(FOnDownClick) then
    FOnDownClick(Self);
  end;
end;

procedure TExtSpinEdit.MiddleBtnMDown(Sender: TObject);
{var       MyRect                    :TRect;
          MyPoint                   :TPoint;}
begin
 FMBDStartValue := Value;
{ if (gvseoClipCursor in FOptions) and (FMaxValue <> FMinValue) then
  begin
   GetCursorPos(MyPoint);
   MyRect.Left := MyPoint.x;//0;
   MyRect.Right := MyPoint.x;//Screen.Width-1;
   //   if eseoRelativIncrement in FOptions then
   MyRect.Top := Max(0, MyPoint.y - (FMaxValue - FMBDStartValue) div FIncrement);
   MyRect.Bottom := Min(Screen.Height-1, MyPoint.y + 1 + (FMBDStartValue - FMinValue) div FIncrement);
   Windows.ClipCursor(@MyRect);
  end;  }
 if Assigned(FOnMiddleBtnMDown) then
  FOnMiddleBtnMDown(Self);
end;

procedure TExtSpinEdit.MiddleBtnMMove(Sender: TObject; Delta: LongInt);
var       NewValue                  :Extended;
begin
 if eseoRelativIncrement in FOptions then
  if Delta >= 0 then
   NewValue := GetIncrement(FMBDStartValue, Delta)
  else
   NewValue := GetDecrement(FMBDStartValue, -Delta)
 else
  NewValue := FMBDStartValue + FIncrement * Delta;
 if Assigned(FOnMiddleBtnMMove) then
  FOnMiddleBtnMMove(Self, Delta, FMBDStartValue, NewValue);
 Modified := True;
 Value := NewValue;
end;

procedure TExtSpinEdit.MiddleBtnMUp(Sender: TObject);
begin
{ if gvseoClipCursor in FOptions then
  Windows.ClipCursor(nil);}
 if Assigned(FOnMiddleBtnMUp) then
  FOnMiddleBtnMUp(Self);
end;

procedure TExtSpinEdit.WMPaste(var Message: TWMPaste);
begin
 if FEditorEnabled and not ReadOnly then
  inherited;
end;

procedure TExtSpinEdit.WMCut(var Message: TWMPaste);
begin
 if FEditorEnabled and not ReadOnly then
  inherited;
end;

procedure TExtSpinEdit.CMExit(var Message: TCMExit);
begin
 SetValue(GetValue); // oder Value := Value;
 inherited;
end;

function TExtSpinEdit.GetValue: Extended;
var      Code        :Integer;
         S           :String;
begin
 S := Text;
 Code := pos(DecimalSeparator, S);
 if Code > 0 then
  S[Code] := '.';
 val(S, Result, Code);
 if Code > 1 then
  begin
   val(copy(S, 1, Code - 1), Result, Code);
   if Code > 0 then
    Result := 0.0;
  end
 else
  if Code <> 0 then
   Result := 0.0;
 Result := CheckValue(Result);
end;

procedure TExtSpinEdit.SetValue(NewValue: Extended);
begin
 Text := Format('%g', [CheckValue(NewValue)]);
end;

function TExtSpinEdit.GetIncrement(Value: Extended; Factor: Integer): Extended;
var      tmp, Val                 :Extended;
         Sign                     :Integer;
begin
 if Value = 0 then
  begin
   if FMaxValue <> FMinValue then
    begin
     if FMaxValue > 0 then
      Result := FMaxValue / 100 * Factor
     else
      Result := abs(FMaxValue - FMinValue) / 100 * Factor
    end
   else
    Result := Increment * Factor
  end
 else
  begin
   if Value > 0 then
    Sign := 1
   else
    Sign := -1;
   Val := abs(Value);
   Result := 1;
   if Result > Val then
    begin
     repeat
      Result := Result / 10;
     until Result <= Val;
     if (Sign = -1) and (abs(Val - Result) < Result / 1000) then
      Result := Result / 10;
    end
   else
    begin
     tmp := Result;
     try
       while Result <= Val do
        begin
         tmp := Result;
         Result := Result * 10;
        end;
     except
      Result := tmp;
     end;
     if (Sign = -1) and (abs(Val - tmp) < Result / 1000) and (abs(Val - 1) >= 0.001) then
      Result := tmp / 10
     else
      Result := tmp;
    end;
   try
     Result := Value + Result * Factor;
   except
    Result := Value;
   end;
  end;
end;

function TExtSpinEdit.GetDecrement(Value: Extended; Factor: Integer): Extended;
var      tmp, Val                 :Extended;
         Sign                     :Integer;
begin
 if Value = 0 then
  begin
   if FMaxValue <> FMinValue then
    begin
     if FMaxValue > 0 then
      Result := FMaxValue / -100 * Factor
     else
      Result := abs(FMaxValue - FMinValue) / -100 * Factor
    end
   else
    Result := Increment * -Factor
  end
 else
  begin
   if Value > 0 then
    Sign := 1
   else
    Sign := -1;
   Val := abs(Value);
   Result := 1;
   if Result > Val then
    begin
     repeat
      Result := Result / 10;
     until Result <= Val;
     if (Sign = 1) and (abs(Val - Result) < Result / 1000) then
      Result := Result / 10;
    end
   else
    begin
     tmp := Result;
     try
       while Result <= Val do
        begin
          tmp := Result;
         Result := Result * 10;
        end;
     except
      Result := tmp;
     end;
     if (Sign = 1) and (abs(Val - tmp) < Result / 1000) and (abs(Val - 1) >= 0.001) then
      Result := tmp / 10
     else
      Result := tmp;
    end;
   try
     Result := Value - Result * Factor;
   except
    Result := Value;
   end;
  end;
end;

function TExtSpinEdit.CheckValue(NewValue: Extended): Extended;
begin
 Result := NewValue;
 if (FMaxValue <> FMinValue) then
  if NewValue < FMinValue then
   Result := FMinValue
  else
   if NewValue > FMaxValue then
    Result := FMaxValue;
end;

procedure TExtSpinEdit.CMEnter(var Message: TCMGotFocus);
begin
 if AutoSelect and not (csLButtonDown in ControlState) then
  SelectAll;
 inherited;
end;

{TTimerSpeedButton}

destructor TTimerSpeedButton.Destroy;
begin
 if FRepeatTimer <> nil then
  FRepeatTimer.Free;
 inherited Destroy;
end;

procedure TTimerSpeedButton.MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
 inherited; //MouseDown (Button, Shift, X, Y);
 if FAllowTimer then
  begin
   if FRepeatTimer = nil then
    FRepeatTimer := TTimer.Create(Self);
   FRepeatTimer.OnTimer := TimerExpired;
   FRepeatTimer.Interval := seInitRepeatPause;
   FRepeatTimer.Enabled  := True;
  end;
end;

procedure TTimerSpeedButton.MouseUp(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
 inherited; //MouseUp (Button, Shift, X, Y);
 if FRepeatTimer <> nil then
  FRepeatTimer.Enabled := False;
end;

procedure TTimerSpeedButton.TimerExpired(Sender: TObject);
begin
 FRepeatTimer.Interval := seRepeatPause;
 if (FState = bsDown) and MouseCapture then
  begin
   try
     Click;
   except
     FRepeatTimer.Enabled := False;
     raise;
   end;
  end;
end;




procedure InitializeVars;
var Dummy: Integer;
{BOOL SystemParametersInfo(
     UINT  uiAction,	// system parameter to query or set
    UINT  uiParam,	// depends on action to be taken
    PVOID  pvParam,	// depends on action to be taken
    UINT  fWinIni 	// user profile update flag
   );}
begin
SystemParametersInfo(SPI_GETKEYBOARDDELAY, 0, @Dummy, 0);
if Dummy <> 0 then
 seInitRepeatPause := Dummy;
SystemParametersInfo(SPI_GETKEYBOARDSPEED, 0, @Dummy, 0);
if Dummy <> 0 then
 seRepeatPause := Dummy;
end;

initialization
InitializeVars;

end.
