/*
 *   Copyright (C) 2011-2016, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
 

#include "thrower.h"

//(*InternalHeaders(thrower)
#include <wx/font.h>
#include <wx/intl.h>
#include <wx/string.h>
//*)

//(*IdInit(thrower)
const long thrower::ID_TEXTCTRL1 = wxNewId();
const long thrower::ID_BUTTON1 = wxNewId();
const long thrower::ID_TIMER1 = wxNewId();
//*)

BEGIN_EVENT_TABLE(thrower,wxDialog)
	//(*EventTable(thrower)
	//*)
END_EVENT_TABLE()

thrower::thrower(wxWindow* parent,wxString message, int s,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
	//(*Initialize(thrower)
	wxFlexGridSizer* FlexGridSizer1;

	Create(parent, id, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxSTAY_ON_TOP|wxDEFAULT_DIALOG_STYLE, _T("id"));
	SetClientSize(wxSize(348,265));
	Move(wxDefaultPosition);
	FlexGridSizer1 = new wxFlexGridSizer(0, 1, 0, 0);
	TextCtrl1 = new wxTextCtrl(this, ID_TEXTCTRL1, _("Text"), wxDefaultPosition, wxSize(379,207), wxTE_MULTILINE, wxDefaultValidator, _T("ID_TEXTCTRL1"));
	TextCtrl1->Disable();
	TextCtrl1->SetForegroundColour(wxColour(15,48,210));
	wxFont TextCtrl1Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	TextCtrl1->SetFont(TextCtrl1Font);
	FlexGridSizer1->Add(TextCtrl1, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	Button1 = new wxButton(this, ID_BUTTON1, _("Ok"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON1"));
	Button1->SetFocus();
	wxFont Button1Font(11,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button1->SetFont(Button1Font);
	FlexGridSizer1->Add(Button1, 1, wxALL|wxALIGN_BOTTOM|wxALIGN_CENTER_HORIZONTAL, 5);
	SetSizer(FlexGridSizer1);
	Timer1.SetOwner(this, ID_TIMER1);
	SetSizer(FlexGridSizer1);
	Layout();

	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&thrower::OnOk);
	Connect(ID_TIMER1,wxEVT_TIMER,(wxObjectEventFunction)&thrower::OnTimeout);
	//*)

	TextCtrl1->SetValue(message);

	if(s>31) s=31;
	sec=1000*s;
	if(s==0) Timer1.Stop();
	else Timer1.Start(1000*s,true);
}

thrower::~thrower()
{
	//(*Destroy(thrower)
	//*)
}


void thrower::OnOk(wxCommandEvent& event)
{
    EndModal(1);
}

void thrower::OnTimeout(wxTimerEvent& event)
{
    EndModal(0);
}
