/*
 *   Copyright (C) 2011-2016, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */


#ifndef ADVANCD_SYMM_H
#define ADVANCD_SYMM_H

//(*Headers(advancd_symm)
#include <wx/sizer.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>
#include <wx/checkbox.h>
#include <wx/spinctrl.h>
#include <wx/choice.h>
#include <wx/button.h>
#include <wx/dialog.h>
//*)

#include "helpersxx.h"

class advancd_symm: public wxDialog
{
	public:

		advancd_symm(wxWindow* parent,wxWindowID id=wxID_ANY,const wxPoint& pos=wxDefaultPosition,const wxSize& size=wxDefaultSize);
		virtual ~advancd_symm();

		//(*Declarations(advancd_symm)
		wxStaticText* StaticText9;
		wxCheckBox* Legacy;
		wxButton* Button4;
		wxStaticText* StaticText2;
		wxSpinCtrl* stretch_ctrl;
		wxButton* Button1;
		wxCheckBox* plsc_chkd;
		wxStaticText* StaticText6;
		wxStaticText* StaticText8;
		wxStaticText* StaticText1;
		wxStaticText* StaticText3;
		wxButton* Button2;
		wxChoice* algo_ctrl;
		wxButton* Button6;
		wxButton* Button5;
		wxTextCtrl* dirkey_ctrl;
		wxButton* Button3;
		wxStaticText* StaticText5;
		wxButton* Button7;
		wxStaticText* StaticText7;
		wxTextCtrl* fnam_ctrl;
		wxTextCtrl* stretch_ell_nam_ctrl;
		wxStaticText* StaticText4;
		wxTextCtrl* salt_ctrl;
		wxTextCtrl* key_ctrl;
		//*)

	protected:

		//(*Identifiers(advancd_symm)
		static const long ID_BUTTON1;
		static const long ID_STATICTEXT1;
		static const long ID_STATICTEXT2;
		static const long ID_TEXTCTRL1;
		static const long ID_BUTTON3;
		static const long ID_STATICTEXT7;
		static const long ID_TEXTCTRL4;
		static const long ID_LEGACY_BOX;
		static const long ID_STATICTEXT8;
		static const long ID_TEXTCTRL5;
		static const long ID_BUTTON7;
		static const long ID_STATICTEXT3;
		static const long ID_TEXTCTRL2;
		static const long ID_BUTTON4;
		static const long ID_STATICTEXT4;
		static const long ID_SPINCTRL1;
		static const long ID_STATICTEXT5;
		static const long ID_CHOICE1;
		static const long ID_STATICTEXT6;
		static const long ID_PLSC;
		static const long ID_BUTTON2;
		static const long ID_TEXTCTRL3;
		static const long ID_BUTTON5;
		static const long ID_STATICTEXT9;
		static const long ID_BUTTON6;
		//*)

	private:

		//(*Handlers(advancd_symm)
		void OnExit(wxCommandEvent& event);
		void OnDo(wxCommandEvent& event);
		void OnFileSel(wxCommandEvent& event);
		void OnNewSalt(wxCommandEvent& event);
		void OnEncipher(wxCommandEvent& event);
		void OnDecipher(wxCommandEvent& event);
		void Onprecalc(wxCommandEvent& event);
		//*)

		DECLARE_EVENT_TABLE()

       void OnDropFile(wxDropFilesEvent& event);
       bool drop_succ;  //provide Feedback

		void OnOlDecipher(wxCommandEvent& event);
		wxString loc_salt_str;
		longnumber locsalt;
		int ss_klen;
};

#endif
