/*
 *   Copyright (C) 2011-2016, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */


#include "Settings.h"
#include "globals.h"

#include <wx/dirdlg.h>

//(*InternalHeaders(Settings)
#include <wx/string.h>
#include <wx/intl.h>
#include <wx/font.h>
//*)

//(*IdInit(Settings)
const long Settings::ID_BUTTON3 = wxNewId();
const long Settings::ID_STATICTEXT2 = wxNewId();
const long Settings::ID_BUTTON1 = wxNewId();
const long Settings::ID_STATICTEXT1 = wxNewId();
const long Settings::ID_TEXTCTRL1 = wxNewId();
const long Settings::ID_BUTTON2 = wxNewId();
const long Settings::ID_STATICTEXT3 = wxNewId();
const long Settings::ID_TEXTCTRL2 = wxNewId();
const long Settings::ID_BUTTON4 = wxNewId();
const long Settings::ID_STATICTEXT4 = wxNewId();
const long Settings::ID_CHOICE1 = wxNewId();
const long Settings::ID_STATICTEXT5 = wxNewId();
const long Settings::ID_CHOICE2 = wxNewId();
//*)

BEGIN_EVENT_TABLE(Settings,wxDialog)
	//(*EventTable(Settings)
	//*)
END_EVENT_TABLE()

Settings::Settings(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
    if(!checkarm()){Close();}


	//(*Initialize(Settings)
	wxFlexGridSizer* FlexGridSizer1;

	Create(parent, id, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("id"));
	SetClientSize(wxDefaultSize);
	Move(wxDefaultPosition);
	FlexGridSizer1 = new wxFlexGridSizer(0, 3, 0, 0);
	Button3 = new wxButton(this, ID_BUTTON3, _("Abbrechen"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON3"));
	Button3->SetBackgroundColour(wxColour(250,207,207));
	wxFont Button3Font(11,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button3->SetFont(Button3Font);
	FlexGridSizer1->Add(Button3, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	StaticText2 = new wxStaticText(this, ID_STATICTEXT2, _("Einstellung von Parametervorgabe"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT2"));
	StaticText2->SetBackgroundColour(wxColour(247,196,247));
	wxFont StaticText2Font(14,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText2->SetFont(StaticText2Font);
	FlexGridSizer1->Add(StaticText2, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	FlexGridSizer1->Add(-1,-1,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	FlexGridSizer1->Add(79,20,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button1 = new wxButton(this, ID_BUTTON1, _("Annehmen und Schliessen"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON1"));
	Button1->SetBackgroundColour(wxColour(200,240,213));
	wxFont Button1Font(11,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button1->SetFont(Button1Font);
	FlexGridSizer1->Add(Button1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	FlexGridSizer1->Add(-1,-1,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText1 = new wxStaticText(this, ID_STATICTEXT1, _("Verzeichnis fuer Signierung"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT1"));
	wxFont StaticText1Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText1->SetFont(StaticText1Font);
	FlexGridSizer1->Add(StaticText1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	SignDirCtrl = new wxTextCtrl(this, ID_TEXTCTRL1, wxEmptyString, wxDefaultPosition, wxSize(437,26), 0, wxDefaultValidator, _T("ID_TEXTCTRL1"));
	wxFont SignDirCtrlFont(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	SignDirCtrl->SetFont(SignDirCtrlFont);
	FlexGridSizer1->Add(SignDirCtrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button2 = new wxButton(this, ID_BUTTON2, _("Verzeichnis waehlen"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON2"));
	wxFont Button2Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button2->SetFont(Button2Font);
	FlexGridSizer1->Add(Button2, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText3 = new wxStaticText(this, ID_STATICTEXT3, _("Verzeichnis fuer En/Deciphering"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT3"));
	wxFont StaticText3Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText3->SetFont(StaticText3Font);
	FlexGridSizer1->Add(StaticText3, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	EncDirCtrl = new wxTextCtrl(this, ID_TEXTCTRL2, wxEmptyString, wxDefaultPosition, wxSize(434,26), 0, wxDefaultValidator, _T("ID_TEXTCTRL2"));
	wxFont EncDirCtrlFont(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	EncDirCtrl->SetFont(EncDirCtrlFont);
	FlexGridSizer1->Add(EncDirCtrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button4 = new wxButton(this, ID_BUTTON4, _("Verzeichnis waehlen"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON4"));
	wxFont Button4Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button4->SetFont(Button4Font);
	FlexGridSizer1->Add(Button4, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText4 = new wxStaticText(this, ID_STATICTEXT4, _("Cipher auswaehlen"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT4"));
	wxFont StaticText4Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText4->SetFont(StaticText4Font);
	FlexGridSizer1->Add(StaticText4, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Choice_ciph = new wxChoice(this, ID_CHOICE1, wxDefaultPosition, wxSize(168,29), 0, 0, 0, wxDefaultValidator, _T("ID_CHOICE1"));
	Choice_ciph->Append(_("aes"));
	Choice_ciph->Append(_("threefish"));
	Choice_ciph->Append(_("flight_x"));
	Choice_ciph->Append(_("F_cnt_lb"));
	Choice_ciph->SetSelection( Choice_ciph->Append(_("F_cnt_lc")) );
	Choice_ciph->Append(_("F_cnt_ld"));
	Choice_ciph->Append(_("Fleas_l"));
	Choice_ciph->Append(_("Fleas_lc"));
	Choice_ciph->Append(_("chimera"));
	wxFont Choice_ciphFont(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Choice_ciph->SetFont(Choice_ciphFont);
	FlexGridSizer1->Add(Choice_ciph, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	FlexGridSizer1->Add(-1,-1,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText5 = new wxStaticText(this, ID_STATICTEXT5, _("Hash auswaehlen"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT5"));
	wxFont StaticText5Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText5->SetFont(StaticText5Font);
	FlexGridSizer1->Add(StaticText5, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Choice_hash = new wxChoice(this, ID_CHOICE2, wxDefaultPosition, wxSize(164,29), 0, 0, 0, wxDefaultValidator, _T("ID_CHOICE2"));
	Choice_hash->Append(_("sha512"));
	Choice_hash->Append(_("JH"));
	Choice_hash->Append(_("skein"));
	Choice_hash->Append(_("Fleas_b"));
	Choice_hash->SetSelection( Choice_hash->Append(_("Fleas_c")) );
	Choice_hash->Append(_("Fleas_d"));
	wxFont Choice_hashFont(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Choice_hash->SetFont(Choice_hashFont);
	FlexGridSizer1->Add(Choice_hash, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	SetSizer(FlexGridSizer1);
	FlexGridSizer1->Fit(this);
	FlexGridSizer1->SetSizeHints(this);

	Connect(ID_BUTTON3,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&Settings::OnExCancel);
	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&Settings::OnExAccept);
	Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&Settings::OnSelSignDir);
	Connect(ID_BUTTON4,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&Settings::OnSelEncDir);
	//*)

	//fill empty fields
	EncDirCtrl->SetValue(cry_path);
	SignDirCtrl->SetValue(doc_path);
	if((def_cip >-1)&&(def_cip <10))
        Choice_ciph->SetSelection(def_cip);
	if((def_hash >-1)&&(def_hash <6))
        Choice_hash->SetSelection(def_hash);


}

Settings::~Settings()
{
	//(*Destroy(Settings)
	//*)
}

/*****************************************************/
void Settings::OnExAccept(wxCommandEvent& event)
{
    if(!checkarm()){Close(0);}
    cry_path=EncDirCtrl->GetLineText(0);
    doc_path=SignDirCtrl->GetLineText(0);
    //set preferences
    def_cip=Choice_ciph->GetCurrentSelection();
    def_hash=Choice_hash->GetCurrentSelection();
    Close(1);
}
/*****************************************************/
void Settings::OnExCancel(wxCommandEvent& event)
{
    Close(0);
}
/*****************************************************/
void Settings::OnSelSignDir(wxCommandEvent& event)
{
    int retval;

    if(!checkarm()){Close(0);}
    wxDirDialog dialog(this);
    dialog.SetPath(doc_path);
    dialog.SetMessage(_("Waehle das Arbeitsverzeichnis fuer Signatur und Verifikation"));
    if(dialog.ShowModal()==wxID_OK)
    {
        doc_path=dialog.GetPath();
    }
    else throwout(_("Abbruch, alte Werte beibehalten"),3);
    SignDirCtrl->SetValue(doc_path);
}
/*****************************************************/
void Settings::OnSelEncDir(wxCommandEvent& event)
{
    wxDirDialog dialog(this);
    int retval;

    if(!checkarm()){Close(0);}
    dialog.SetPath(cry_path);
    dialog.SetMessage(_("Waehle das Arbeitsverzeichnis fuer Ver- und Entschluesselung"));
    if(dialog.ShowModal()==wxID_OK)
    {
        cry_path=dialog.GetPath();
    }
    else throwout(_("Abbruch, alte Werte beibehalten"),3);
    EncDirCtrl->SetValue(cry_path);
}
/*****************************************************/
