/*
 *   Copyright (C) 2011-2016, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */


#include "pw_request.h"

//(*InternalHeaders(pw_request)
#include <wx/font.h>
#include <wx/intl.h>
#include <wx/string.h>
//*)

//(*IdInit(pw_request)
const long pw_request::ID_STATICTEXT1 = wxNewId();
const long pw_request::ID_TEXTCTRL1 = wxNewId();
const long pw_request::ID_TEXTCTRL2 = wxNewId();
const long pw_request::ID_BUTTON1 = wxNewId();
const long pw_request::ID_TIMER1 = wxNewId();
//*)

BEGIN_EVENT_TABLE(pw_request,wxDialog)
	//(*EventTable(pw_request)
	//*)
END_EVENT_TABLE()

pw_request::pw_request(wxWindow* parent,wxString msg, wxString *pw, wxWindowID id,const wxPoint& pos,const wxSize& size)
{
	//(*Initialize(pw_request)
	wxFlexGridSizer* FlexGridSizer1;

	Create(parent, id, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxSTAY_ON_TOP|wxDEFAULT_DIALOG_STYLE, _T("id"));
	SetClientSize(wxDefaultSize);
	Move(wxDefaultPosition);
	FlexGridSizer1 = new wxFlexGridSizer(0, 1, 0, 0);
	StaticText1 = new wxStaticText(this, ID_STATICTEXT1, _("Passphrase anfordern (automatische Annahme nach 90 Sek.)"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT1"));
	wxFont StaticText1Font(11,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText1->SetFont(StaticText1Font);
	FlexGridSizer1->Add(StaticText1, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	comm_ctrl = new wxTextCtrl(this, ID_TEXTCTRL1, wxEmptyString, wxDefaultPosition, wxSize(613,22), 0, wxDefaultValidator, _T("ID_TEXTCTRL1"));
	wxFont comm_ctrlFont(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	comm_ctrl->SetFont(comm_ctrlFont);
	FlexGridSizer1->Add(comm_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	pw_ctrl = new wxTextCtrl(this, ID_TEXTCTRL2, wxEmptyString, wxDefaultPosition, wxSize(614,22), 0, wxDefaultValidator, _T("ID_TEXTCTRL2"));
	pw_ctrl->SetFocus();
	pw_ctrl->SetBackgroundColour(wxColour(253,208,208));
	wxFont pw_ctrlFont(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	pw_ctrl->SetFont(pw_ctrlFont);
	FlexGridSizer1->Add(pw_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	Button1 = new wxButton(this, ID_BUTTON1, _("Akzeptieren"), wxDefaultPosition, wxSize(85,23), 0, wxDefaultValidator, _T("ID_BUTTON1"));
	Button1->SetBackgroundColour(wxColour(195,253,200));
	wxFont Button1Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button1->SetFont(Button1Font);
	FlexGridSizer1->Add(Button1, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	SetSizer(FlexGridSizer1);
	Timer1.SetOwner(this, ID_TIMER1);
	Timer1.Start(30000, false);
	FlexGridSizer1->Fit(this);
	FlexGridSizer1->SetSizeHints(this);

	Connect(ID_TEXTCTRL2,wxEVT_COMMAND_TEXT_ENTER,(wxObjectEventFunction)&pw_request::OnSubmit);
	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&pw_request::OnSubmit);
	Connect(ID_TIMER1,wxEVT_TIMER,(wxObjectEventFunction)&pw_request::OnTimer1Trigger);
	//*)
	comm_ctrl->SetValue(msg);
	half_min_counter=0;
	ppw=pw;//assign resultpointer
}

pw_request::~pw_request()
{
	//(*Destroy(pw_request)
	//*)
}


void pw_request::OnTimer1Trigger(wxTimerEvent& event)
{
    if(half_min_counter<2)
    {
        *ppw= pw_ctrl->GetLineText(0);
        pw_ctrl->SetValue(_("deadbeef is bad food for alice")); //wipe it
        EndModal(0);
        return;
    }
    else half_min_counter++;
    return;
}

void pw_request::OnSubmit(wxCommandEvent& event)
{
    *ppw= pw_ctrl->GetLineText(0);
    pw_ctrl->SetValue(_("deadbeef is bad food for bob")); //wipe it
    EndModal(1);
    return;
}
