/*
 *   Copyright (C) 2011-2017, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */


#ifndef MAKEHASH_H
#define MAKEHASH_H

#include <wx/filedlg.h>
#include <wx/filename.h>
#include <wx/file.h>



//(*Headers(makehash)
#include <wx/dialog.h>
#include <wx/sizer.h>
#include <wx/button.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>
#include <wx/choice.h>
//*)

class makehash: public wxDialog
{
	public:

		makehash(wxWindow* parent,wxWindowID id=wxID_ANY,const wxPoint& pos=wxDefaultPosition,const wxSize& size=wxDefaultSize);
		virtual ~makehash();

		//(*Declarations(makehash)
		wxButton* Button1;
		wxButton* Button2;
		wxButton* Button3;
		wxStaticText* StaticText1;
		wxTextCtrl* hash_ctrl;
		wxStaticText* StaticText3;
		wxChoice* Choice1;
		wxStaticText* StaticText4;
		wxStaticText* StaticText5;
		wxStaticText* StaticText2;
		wxTextCtrl* file_ctrl;
		//*)

		wxString fnam;

	protected:

		//(*Identifiers(makehash)
		static const long ID_BUTTON2;
		static const long ID_STATICTEXT1;
		static const long ID_BUTTON3;
		static const long ID_STATICTEXT2;
		static const long ID_TEXTCTRL1;
		static const long ID_BUTTON1;
		static const long ID_STATICTEXT3;
		static const long ID_STATICTEXT4;
		static const long ID_STATICTEXT5;
		static const long ID_TEXTCTRL2;
		static const long ID_CHOICE1;
		//*)

	private:

		//(*Handlers(makehash)
		void OnCancel(wxCommandEvent& event);
		void OnHash(wxCommandEvent& event);
		void OnFileSel(wxCommandEvent& event);
		//*)


       void OnDropFile(wxDropFilesEvent& event);
       bool drop_succ;  //provide Feedback

		DECLARE_EVENT_TABLE()
};

#endif
