/*
 *   Copyright (C) 2011-2017, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <wx/arrstr.h>
#include <wx/dir.h>
#include <wx/busyinfo.h>

#include <wx/filename.h>
#include "gpg_dec_dialog.h"

//(*InternalHeaders(gpg_dec_dialog)
#include <wx/string.h>
#include <wx/intl.h>
#include <wx/font.h>
//*)


#include "gnupg_globals.h"
#include "gpg_wrap.h"
//#include "gpg_manag_priv.h"
#include "globals.h"



//(*IdInit(gpg_dec_dialog)
const long gpg_dec_dialog::ID_BUTTON3 = wxNewId();
const long gpg_dec_dialog::ID_STATICTEXT1 = wxNewId();
const long gpg_dec_dialog::ID_STATICTEXT4 = wxNewId();
const long gpg_dec_dialog::ID_TEXTCTRL3 = wxNewId();
const long gpg_dec_dialog::ID_BUTTON2 = wxNewId();
const long gpg_dec_dialog::ID_STATICTEXT5 = wxNewId();
const long gpg_dec_dialog::ID_TEXTCTRL6 = wxNewId();
const long gpg_dec_dialog::ID_BUTTON4 = wxNewId();
//*)

BEGIN_EVENT_TABLE(gpg_dec_dialog,wxDialog)
	//(*EventTable(gpg_dec_dialog)
	//*)
END_EVENT_TABLE()

gpg_dec_dialog::gpg_dec_dialog(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
	//(*Initialize(gpg_dec_dialog)
	wxFlexGridSizer* FlexGridSizer1;
	wxFlexGridSizer* FlexGridSizer2;

	Create(parent, wxID_ANY, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("wxID_ANY"));
	FlexGridSizer1 = new wxFlexGridSizer(0, 3, 0, 0);
	FlexGridSizer2 = new wxFlexGridSizer(0, 3, 0, 0);
	Button3 = new wxButton(this, ID_BUTTON3, _("Schliessen"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON3"));
	Button3->SetBackgroundColour(wxColour(253,229,229));
	wxFont Button3Font(11,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button3->SetFont(Button3Font);
	FlexGridSizer2->Add(Button3, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	StaticText1 = new wxStaticText(this, ID_STATICTEXT1, _("Dekodieren der GnuPG Chiffre"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT1"));
	wxFont StaticText1Font(13,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText1->SetFont(StaticText1Font);
	FlexGridSizer2->Add(StaticText1, 1, wxALL|wxALIGN_BOTTOM|wxALIGN_CENTER_HORIZONTAL, 5);
	FlexGridSizer2->Add(30,15,1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	StaticText4 = new wxStaticText(this, ID_STATICTEXT4, _("Chiffretextdatei:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT4"));
	wxFont StaticText4Font(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText4->SetFont(StaticText4Font);
	FlexGridSizer2->Add(StaticText4, 1, wxALL|wxALIGN_RIGHT|wxALIGN_BOTTOM, 5);
	ciphnam_ctrl = new wxTextCtrl(this, ID_TEXTCTRL3, wxEmptyString, wxDefaultPosition, wxSize(576,22), 0, wxDefaultValidator, _T("ID_TEXTCTRL3"));
	wxFont ciphnam_ctrlFont(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	ciphnam_ctrl->SetFont(ciphnam_ctrlFont);
	FlexGridSizer2->Add(ciphnam_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	Button2 = new wxButton(this, ID_BUTTON2, _("Chiffretext\nwaehlen"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON2"));
	wxFont Button2Font(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button2->SetFont(Button2Font);
	FlexGridSizer2->Add(Button2, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	StaticText5 = new wxStaticText(this, ID_STATICTEXT5, _("Datei im Klartext"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT5"));
	wxFont StaticText5Font(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText5->SetFont(StaticText5Font);
	FlexGridSizer2->Add(StaticText5, 1, wxALL|wxALIGN_RIGHT|wxALIGN_BOTTOM, 5);
	plainnam_ctrl = new wxTextCtrl(this, ID_TEXTCTRL6, wxEmptyString, wxDefaultPosition, wxSize(577,22), 0, wxDefaultValidator, _T("ID_TEXTCTRL6"));
	plainnam_ctrl->Disable();
	wxFont plainnam_ctrlFont(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	plainnam_ctrl->SetFont(plainnam_ctrlFont);
	FlexGridSizer2->Add(plainnam_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	FlexGridSizer2->Add(30,15,1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	FlexGridSizer2->Add(20,56,1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	Button4 = new wxButton(this, ID_BUTTON4, _("Dechiffrieren"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON4"));
	Button4->SetBackgroundColour(wxColour(189,213,247));
	wxFont Button4Font(11,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button4->SetFont(Button4Font);
	FlexGridSizer2->Add(Button4, 1, wxALL|wxALIGN_BOTTOM|wxALIGN_CENTER_HORIZONTAL, 5);
	FlexGridSizer1->Add(FlexGridSizer2, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	SetSizer(FlexGridSizer1);
	FlexGridSizer1->Fit(this);
	FlexGridSizer1->SetSizeHints(this);

	Connect(ID_BUTTON3,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&gpg_dec_dialog::OnExit);
	Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&gpg_dec_dialog::OnSelCipher);
	Connect(ID_BUTTON4,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&gpg_dec_dialog::OnDoDecipher);
	//*)

    ciphnam_ctrl->DragAcceptFiles(true);
    ciphnam_ctrl->Connect(wxEVT_DROP_FILES, wxDropFilesEventHandler(gpg_dec_dialog::OnDropFile), NULL, this);


}
/********************************************************************/
gpg_dec_dialog::~gpg_dec_dialog()
{
	//(*Destroy(gpg_dec_dialog)
	//*)
}
/********************************************************************/
void gpg_dec_dialog::OnSelCipher(wxCommandEvent& event)
{
    wxString plainnam,ciphnam,cry_d;

    if(cur_cry_path.IsEmpty())
    {
        cry_d = cry_path; //first call
    }
    else
    {
        cry_d = cur_cry_path;
    }
    ciphnam = wxFileSelector(_("Open a file to decipher"),cry_d,_(""),_("gpg|"),_("gpg cipher (*.gpg)|*.gpg|all files(*)|*"));
    if ( wxFile::Exists(ciphnam))
    {
        ciphnam_ctrl->SetValue(ciphnam);
        //set also prospective signature file
        plainnam= ciphnam.Left(ciphnam.Length()-4);
        plainnam_ctrl->SetValue(plainnam);
        cur_cry_path= ((wxFileName)ciphnam).GetPath(); //get new path and store into cur_doc_path
    }
    else
    {
        throwout(_("file to decipher does not exist!\nDo Nothing."),3);
        return;
    }
    return;
}
/********************************************************************/
void gpg_dec_dialog::OnExit(wxCommandEvent& event)
{
    EndModal(0);
}
/********************************************************************/
void gpg_dec_dialog::OnDoDecipher(wxCommandEvent& event)
{
    wxString ciphnam,plainnam;

    ciphnam=ciphnam_ctrl->GetLineText(0);
    //check for existence
    if(!wxFile::Exists(ciphnam))
    {
        throwout(_("file to encipher does not exist!\nDo Nothing."),3);
        return;
    }
    plainnam=plainnam_ctrl->GetLineText(0);

    if(gpg_decrypt(ciphnam,plainnam)) throwout(_("GnuPG Cipher decoded."),3);
    else throwout(_("Could not decode"),10);
    return;
}
/********************************************************************/
/*******************************************************/
void gpg_dec_dialog::OnDropFile(wxDropFilesEvent& event)
    {
        int filno;
        drop_succ=false;
        wxString fnam,plainnam;

        if (event.GetNumberOfFiles() > 0) {

            wxString* dropped = event.GetFiles();
            wxASSERT(dropped);

            wxBusyCursor busyCursor;
            wxWindowDisabler disabler;
            wxBusyInfo busyInfo(_("Fuege Datei ein, bitte warten..."));

            wxString name;
            filno = event.GetNumberOfFiles();
            if(filno!=1)
            {
				throwout(_("Bitte nur ein Dateiname.\nDrop ignoriert!"),3);
				return;
			}
			if( wxDirExists( 	dropped[0]	))
            {
                throwout(_("Das ist ein Verzeichnisname!!\nNur Dateiname moeglich.\nDrop ignoriert!"),3);
                return;
            }
			name = dropped[0];
			if (!wxFileExists(name))
            {
				throwout(_("Datei existiert nicht\nDrop ignoriert!"),5);
				return;
			}

            wxTextCtrl* textCtrl = dynamic_cast<wxTextCtrl*>(event.GetEventObject());
            wxASSERT(textCtrl);
            textCtrl->Clear();
            textCtrl->SetValue(name);
            drop_succ=true;
            fnam=name;
            cur_doc_path= ((wxFileName)fnam).GetPath(); //get new path and store into cur_doc_path

    if ( wxFile::Exists(fnam))
    {
        ciphnam_ctrl->SetValue(fnam);
        //set also prospective signature file
        plainnam= fnam.Left(fnam.Length()-4);
        plainnam_ctrl->SetValue(plainnam);
        cur_cry_path= ((wxFileName)fnam).GetPath(); //get new path and store into cur_doc_path
    }
    else
    {
        throwout(_("file to decipher does not exist!\nDo Nothing."),3);
        return;
    }
    return;

        }
    }
/*********************************************************/

