#ifndef GLOBALS_H_INCLUDED
#define GLOBALS_H_INCLUDED

#include "helpersxx.h"
#include "elliptic1.h"
#include "random_clx.h"

extern bool gpg_here;  //ist gpg verfuegbar
extern bool gpg2_here;  //ist gpg verfuegbar
extern wxString gpg_name; //gpg Version

extern char key[200]; // Platz für den Schlüssel
extern char f_rnd; // Anzahl der Feistel-Runden
extern int k_rnd; // Anzahl der Kangorooh-Runden
extern int u_len; // Einheitslänge
extern longnumber globlonu; //die permanente globale longnumber als seed
extern longnumber salt; //die nicht geheime salt longnumber
extern longnumber zugang; //die permanente globale longnumber als universalschluesselseed
//extern rsakey privkey; //globaler privater Schlüssel
//extern rsakey extkey; //aktueller Fremdschlüssel
extern bool S_FIL; //secure files (default true, use false for debugging

/******* safety  ********/
extern bool thr_wx;
extern bool is_armed; // info on armed state?
extern unsigned long lastarmed; //letzte entsicherung
extern unsigned long armed_secs;  //wielange scharf ?
extern bool to_quit;   // flag for exiting
/************ end safety *****************/
extern wxString sec_path; // path to secrets file
extern wxString doc_path;  // path to documents to sign and verify
extern wxString cry_path;  // default path to elliptic ciphers
extern wxString cur_doc_path;  //current path to signature folder
extern wxString cur_cry_path;  //current path to ciphers folder
extern int def_cip;  //default cipher number
extern int def_hash;  //default hash number

extern wxString salt_ini;  // salt initializer
extern wxString kytray;  // is what it says
extern int ss_klen;   //stretch and salt keylength
extern wxString def_pubkey;  //default public key id
extern wxString def_privkey;  //default private key id
/********************/
/********* elliptic globals   ******************/

extern ellipse gdom;
extern ellipse stretch_ell;
extern int stretch;
extern el_priv elky;
extern el_pub el_pk;
extern rpool zuf;
extern el_list e_ls;
/*****************************************************/
/**** global functions *****/
bool recode_all(longnumber *newky, longnumber *oldky);




#endif // GLOBALS_H_INCLUDED
