/*
 *   Copyright (C) 2011-2016, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include "Del_imp_priv.h"


//(*InternalHeaders(Del_imp_priv)
#include <wx/font.h>
#include <wx/intl.h>
#include <wx/string.h>
//*)

#include <wx/textdlg.h>
#include <wx/filedlg.h>
#include <wx/filename.h>
#include "globals.h"


//(*IdInit(Del_imp_priv)
const long Del_imp_priv::ID_BUTTON2 = wxNewId();
const long Del_imp_priv::ID_STATICTEXT2 = wxNewId();
const long Del_imp_priv::ID_STATICTEXT1 = wxNewId();
const long Del_imp_priv::ID_BUTTON1 = wxNewId();
const long Del_imp_priv::ID_LISTBOX1 = wxNewId();
const long Del_imp_priv::ID_BUTTON3 = wxNewId();
const long Del_imp_priv::ID_TIMER1 = wxNewId();
//*)

BEGIN_EVENT_TABLE(Del_imp_priv,wxDialog)
	//(*EventTable(Del_imp_priv)
	//*)
END_EVENT_TABLE()

Del_imp_priv::Del_imp_priv(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
    FILE *knfp;
    char buff1[1000], buff2[1000];
    int lbl,count;
    wxString fn;


    if(!checkarm()){Close();}
    half_min_counter=0;
    nostop=false;
	//(*Initialize(Del_imp_priv)
	wxFlexGridSizer* FlexGridSizer1;

	Create(parent, wxID_ANY, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("wxID_ANY"));
	SetBackgroundColour(wxColour(250,207,207));
	FlexGridSizer1 = new wxFlexGridSizer(0, 2, 0, 0);
	Button2 = new wxButton(this, ID_BUTTON2, _("Schliessen"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON2"));
	Button2->SetDefault();
	Button2->SetBackgroundColour(wxColour(250,195,195));
	wxFont Button2Font(11,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button2->SetFont(Button2Font);
	FlexGridSizer1->Add(Button2, 1, wxALL|wxALIGN_LEFT|wxALIGN_TOP, 5);
	StaticText2 = new wxStaticText(this, ID_STATICTEXT2, _("Privaten Schluessel\nzum loeschen waehlen"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT2"));
	StaticText2->SetForegroundColour(wxColour(206,12,12));
	wxFont StaticText2Font(13,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText2->SetFont(StaticText2Font);
	FlexGridSizer1->Add(StaticText2, 1, wxALL|wxALIGN_BOTTOM|wxALIGN_CENTER_HORIZONTAL, 5);
	FlexGridSizer1->Add(-1,-1,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText1 = new wxStaticText(this, ID_STATICTEXT1, _("Fenster schliesst zur Sicherheit nach 2 Minuten automatisch"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT1"));
	wxFont StaticText1Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText1->SetFont(StaticText1Font);
	FlexGridSizer1->Add(StaticText1, 1, wxALL|wxALIGN_TOP|wxALIGN_CENTER_HORIZONTAL, 5);
	Button1 = new wxButton(this, ID_BUTTON1, _("Loeschen"), wxDefaultPosition, wxSize(85,30), 0, wxDefaultValidator, _T("ID_BUTTON1"));
	wxFont Button1Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button1->SetFont(Button1Font);
	FlexGridSizer1->Add(Button1, 1, wxALL|wxALIGN_LEFT|wxALIGN_TOP, 5);
	ListBox1 = new wxListBox(this, ID_LISTBOX1, wxDefaultPosition, wxSize(366,397), 0, 0, wxVSCROLL, wxDefaultValidator, _T("ID_LISTBOX1"));
	ListBox1->SetForegroundColour(wxColour(155,17,17));
	wxFont ListBox1Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	ListBox1->SetFont(ListBox1Font);
	FlexGridSizer1->Add(ListBox1, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	FlexGridSizer1->Add(-1,-1,1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	Button3 = new wxButton(this, ID_BUTTON3, _("Privaten ECC Schluessel aus Datei importieren"), wxDefaultPosition, wxSize(370,27), 0, wxDefaultValidator, _T("ID_BUTTON3"));
	Button3->SetBackgroundColour(wxColour(252,209,209));
	wxFont Button3Font(11,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button3->SetFont(Button3Font);
	FlexGridSizer1->Add(Button3, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	SetSizer(FlexGridSizer1);
	Timer1.SetOwner(this, ID_TIMER1);
	Timer1.Start(6000, false);
	FlexGridSizer1->Fit(this);
	FlexGridSizer1->SetSizeHints(this);

	Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&Del_imp_priv::OnExit);
	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&Del_imp_priv::OnDeleteKey);
	Connect(ID_BUTTON3,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&Del_imp_priv::Import_el_privkey);
	Connect(ID_TIMER1,wxEVT_TIMER,(wxObjectEventFunction)&Del_imp_priv::OnTimer1Trigger);
	//*)
		    // zuerst Namensliste Laden
    wxArrayString wxstrad; //wxStringarray initialisieren
    fn=sec_path + _("/ell_knamfile.knf");
nostop=true; //hier nicht aussteigen
    if(S_FIL) unlockfile(fn,&zugang);
    knfp=fopen((const char*) fn.mb_str(wxConvLocal), "r");
    count=0;
    do{
        lbl=fscanf(knfp, " id: %500s Name: %500s\n",buff1,buff2);
        //in wxstrad einpflegen
        if(lbl==2) {
            wxstrad.Add( (wxString::FromUTF8(buff1)) + _("  ") + (wxString::FromUTF8(buff2)) );
            ids.Add(wxString::FromUTF8(buff1)); //ids ist eine class-variable
            count++;
        }
    }while(lbl == 2);
 	// Jetzt die Listbox initialisieren
    ListBox1->InsertItems(wxstrad,0);
    //als Menu in neuem Dialog anbieten und auswählen

    fclose(knfp);
    if(S_FIL) lockfile(fn,&zugang);
nostop=false;
}

Del_imp_priv::~Del_imp_priv()
{
	//(*Destroy(Del_imp_priv)
	//*)
}


void Del_imp_priv::OnExit(wxCommandEvent& event)
{
    EndModal(0);//caller doesn't recall
}
/*******************  helperfunction  ************************************/
bool Del_imp_priv::liberatekylist(int keyz,el_priv **zz)
{
    int i;

nostop=true;
    if(zz==NULL) return false;
    for(i=keyz-1; i>=0; i--)
    {
       delete( *(zz+i));
    }
    free(zz);
nostop=false;
    return true;
}
/***********************************************************************/
void Del_imp_priv::OnDeleteKey(wxCommandEvent& event)
{
    wxString del_id,hlp,txa;
    el_priv **ppt=NULL;
    int keyno,indx,i,lbl;
    el_priv tmpky;
    char buff[800];
    FILE *kfp,*knfp;
    unsigned long fpos;

    half_min_counter=0;
nostop=true;
    if(!checkarm()){Close();}
    //get id of file to delete
    indx=ListBox1->GetSelection();
    if(indx<0) {throwout(_("Nichts gewaehlt, Abbruch!"),2); return;}
    del_id= ids.Item(indx);  //kann nachher weg, ist
    //unlock keyfile and keynamfile
    if(S_FIL) unlockinplace(sec_path + _("/ell_knamfile.knf"),&zugang);
    if(S_FIL) unlockinplace(sec_path + _("/ell_Keyfile.kyf"),&zugang);
    keyno=0;
    hlp=sec_path + _("/ell_Keyfile.kyf");
    kfp=fopen((const char*)hlp.mb_str(wxConvLocal),"r");
// load all keys into memory
    ppt= (el_priv**)malloc(sizeof(el_priv**));
    do{
        lbl=fscanf(kfp," id: %400s \n",buff);
        if( lbl == EOF) break;
        if(lbl==0)
        {
             fpos=ftell(kfp);
             fpos++;
             fseek ( kfp , fpos , SEEK_SET );
        }
        else
        {
          //make wxstring from buff
          hlp= wxString::FromUTF8(buff);
          //mache platz in der Liste
          keyno++;
          ppt= (el_priv **) realloc(ppt,keyno*sizeof(el_priv *));
          *(ppt+keyno-1)= new(el_priv);
          (*(ppt+keyno-1))->id=hlp;
    //lade alle anderen

        if( (lbl=fscanf(kfp,"Name: %400s ",buff)) !=1)
        { throwout(_("Name Lesefehler!"));
         fclose(kfp);
         if(S_FIL) lockinplace(sec_path + _("/ell_Keyfile.kyf"),&zugang); // lock keynamefile
         liberatekylist(keyno,ppt);
         return;
        }

    //make wxstring from buff
    hlp= wxString::FromUTF8(buff);
    (*(ppt+keyno-1))->fullnam=hlp;

        if( (lbl=fscanf(kfp," DomainName: %400s ",buff)) !=1)
        { throwout(_("Domain Lesefehler!"));
         fclose(kfp);
         if(S_FIL) lockinplace(sec_path + _("/ell_Keyfile.kyf"),&zugang); // lock keynamefile
         liberatekylist(keyno,ppt);
           return;
        }

    //make wxstring from buff
    hlp= wxString::FromUTF8(buff);
    (*(ppt+keyno-1))->domnam= hlp;


        if( (lbl=fscanf(kfp,"d: %400s ",buff)) !=1 )
        { throwout(_("Privater Schluessel d: Lesefehler!"));
            fclose(kfp);
            if(S_FIL) lockinplace(sec_path + _("/ell_Keyfile.kyf"),&zugang); // lock keynamefile
            liberatekylist(keyno,ppt);
            return;
        }

    // d: in den key schreiben
    hlp=wxString::FromUTF8(buff);
    if( !(((*(ppt+keyno-1))->d).storhex(&hlp))){throwout(_("error reading Key d")); fclose(kfp);
         if(S_FIL) lockinplace(sec_path + _("/ell_Keyfile.kyf"),&zugang); // lock keynamefile
         liberatekylist(keyno,ppt);
         return;}
    (*(ppt+keyno-1))->d.setsize(); (*(ppt+keyno-1))->d.shrinktofit();

        }
    } while( true);
    fclose(kfp);
    //if(S_FIL) unlockinplace(_("e_ell_knamfile.kyf"),&zugang); // lock keynamefile
   //jetzt sollte die Liste komplett sein
    hlp=sec_path + _("/ell_Keyfile.kyf");
    kfp=fopen((const char*)hlp.mb_str(wxConvLocal),"w");
    hlp=sec_path + _("/ell_knamfile.knf");
    knfp=fopen((const char*)hlp.mb_str(wxConvLocal),"w");

    del_id=(*(ppt+indx))->id;  //wird hier noch nicht benutzt, aber spaeter vielleicht nach sortierung etc.
    for(i=0;i<keyno;i++)
    {
       if(i==indx) continue; //wenns der zu loeschende ist, ueberspringen
       //sonst einfach alle rausschreiben
       lbl=fprintf(knfp,"id: %s  Name: %s  \n",(const char*)( (*(ppt+i))->id).mb_str(wxConvUTF8),
                  (const char*)((*(ppt+i))->fullnam).mb_str(wxConvUTF8));
       lbl=fprintf(kfp,"id: %s  Name: %s DomainName: %s\n",(const char*)((*(ppt+i))->id).mb_str(wxConvUTF8),
                  (const char*)((*(ppt+i))->fullnam).mb_str(wxConvUTF8),(const char*)((*(ppt+i))->domnam).mb_str(wxConvUTF8) );
      ((*(ppt+i))->d).writehex(&txa);
      lbl=fprintf(kfp,"d: %s  \n \n", (const char*)txa.mb_str(wxConvUTF8));
    }
    fclose(knfp); fclose(kfp);
    if(S_FIL) lockinplace(sec_path + _("/ell_Keyfile.kyf"),&zugang); // lock keynamefile
    if(S_FIL) lockinplace(sec_path + _("/ell_knamfile.knf"),&zugang); // lock keynamefile
    liberatekylist(keyno,ppt);
nostop=false;
    EndModal(1);
}
/***********************************************************************/
void Del_imp_priv::Import_el_privkey(wxCommandEvent& event)
{
    wxString importfile,outfile,h,c_ext,algo;
    el_priv loky;
    wxString txa,tya;
    FILE  *pkf;
    char buff1[802],buff2[802],buff3[4096];
    int rcnt;
    bool dom_match=true, loadsuccess=false;
    longnumber oldphrase;

    wxString txt,txd,kpath;
    FILE *knamfil, *kfil;
    bool oldname=false;
    int lbl;
    longnumber tempd;
    longnumber loc_salt;
    int loc_stretch;
    ellipse *loc_se_pt;
    wxString loc_se_id,hs;
    bool st_and_salt=false;
    wxString headnam;
    wxString ciphnam;



nostop=true;
    half_min_counter=0;
    if(!checkarm()){Close();}
nostop=false;
    importfile = wxFileSelector(_("Waehle eine Importdatei"),kytray,_(""),_("ciph|prv_o5"),_("salted&stretched (*.ciph)|*.ciph|o5 encoded nude(*.prv_o5)|*.prv_o5"));
    if(importfile.IsEmpty())
    {
        wxMessageBox(_("Importdatei existiert nicht!\nAbbruch!"));
        return;
    }
    //decide which algo according to last two chars
    c_ext= importfile.Right(5);
    if(c_ext== _(".ciph"))
    {
        //salted,stretched o5
        //separate files
       kpath=((wxFileName) importfile).GetPath(wxPATH_GET_VOLUME|wxPATH_GET_SEPARATOR);
       headnam= ((wxFileName) importfile).GetName();
       ciphnam=headnam + _(".prv");
       headnam= headnam +_(".head");
       //get filenames without path
       if(!splicefile(importfile, headnam, ciphnam, _("end_header_info::")))
       {
        throwout(_("Auftrennen des Importfiles gescheitert\nAbbruch"),20);
        return;
       }
        //read pars to loc
        pkf=fopen((const char*)(kpath+headnam).mb_str(wxConvLocal), "r");
        if(pkf==NULL){throwout(_("Fehler beim oeffnen des head-files der Chiffre"),4); return;}
        rcnt= fscanf(pkf,"salt: %400s ",buff1);
        if(rcnt != 1) {throwout(_("Lesefehler salt"),4); fclose(pkf); return;}
        hs=wxString::FromUTF8(buff1);
        loc_salt.storhex(&hs);

        rcnt= fscanf(pkf,"algo: %400s ",buff1);
        if(rcnt != 1) {throwout(_("Lesefehler algo"),4); fclose(pkf); return;}
        algo=wxString::FromUTF8(buff1);

        rcnt= fscanf(pkf,"stretch: %i ",&loc_stretch);
        if(rcnt != 1) {throwout(_("Lesefehler stretch"),4); fclose(pkf); return;}

        rcnt= fscanf(pkf,"%400s ",buff1);
        if(rcnt != 1) {throwout(_("Lesefehler stretch_ell id"),4); fclose(pkf); return;}
        loc_se_id=wxString::FromUTF8(buff1);
        fclose(pkf);

        if(loc_se_id != stretch_ell.name) //unusual choice of stretcher ellipse
        {
            throwout(_("Warnung!\n ungewoehnliche stretcher Domain."),3);
            if(e_ls.getelp(loc_se_pt, loc_se_id)==-1)
            {
                throwout(_("Fehler: Unbekannte Domain!,\nAbbruch!"),5);
                return;
            }
        }
        else //normal stretcher ellps
        {
            loc_se_pt = &stretch_ell;
        }


        outfile=importfile.Left(importfile.Len()-5) +_(".prv");
        //delete rest
        //st_and_salt=wxRemoveFile(importfile);
        headnam=((wxFileName) importfile).GetPath(wxPATH_GET_VOLUME|wxPATH_GET_SEPARATOR) +headnam;
        st_and_salt=wxRemoveFile(headnam);
        st_and_salt=true;
    }
    else{
      c_ext= importfile.Right(3);
      algo=_("Fleas_o5");

      if(c_ext == _("_x5")) algo=_("Fleas_x5");
      if(c_ext == _("_o5")) algo=_("Fleas_o5");
      else throwout(_("Warnung: Konnte symmetrischen Algorithmus\nnicht bestimmen, muss raten..."),1);
      outfile=importfile.Left(importfile.Len()-3);
    }

//nostop=false;
    wxPasswordEntryDialog mypw(this,_("Geben Sie die Passphrase der ausgebenden Instanz des privaten Schluessels!"), _("Passphrase Dialog"));
    mypw.ShowModal();
    h=mypw.GetValue();
    if(h.IsEmpty())
    {
       throwout(_("Leere Passphrase - Abbruch"));
       //oldphrase.copynum(&zugang); //later introduce dialog
       return;
    }
//nostop=true;
    else oldphrase.stortext(&h);

    //reform key
    if(st_and_salt)
    {
        //reform key
        if(! kyprep(&oldphrase, &h, &loc_salt, loc_se_pt, loc_stretch, ss_klen ))
        {
            throwout(_("Fehler!\nKonnte Schluessel nicht preparieren\nAbbruch"),3);
            return;
        }
    }
    //rename cipherfile
    wxString addendum=_("_o5");
    if(algo== _("Fleas_3")) addendum= _("_f3");
    else if(algo== _("Fleas_o5")) addendum=_("_o5");
    else if(algo== _("Fleas_1_8")) addendum= _("_c3");
    else if(algo== _("Fleas_4"))  addendum= _("_f4");
    else if(algo== _("Fleas_5"))  addendum=_("_f5");
    else if(algo== _("Fleas_x2")) addendum= _("_x2");
    else if(algo== _("Fleas_x5")) addendum= _("_x5");
    else if(algo== _("Fleas_o2")) addendum= _("_o2");
    else if(algo== _("Fleas_l"))  addendum= _("_l");
    else if(algo== _("Fleas_ls")) addendum= _("_ls");
    else if(algo ==_("Fleas_l3")) addendum= _("_l3");
    else if(algo ==_("Fleas_lb")) addendum= _("_lb");
    else if(algo ==_("Fleas_lc")) addendum= _("_lc");
    else if(algo ==_("Fleas_ld")) addendum= _("_ld");
    else if(algo== _("aes"))      addendum= _("_ae");
    else if(algo ==_("F_cnt_1c")) addendum= _("_1c");
    else if(algo ==_("F_cnt_1d")) addendum= _("_1d");
    else if(algo ==_("F_cnt_1b")) addendum= _("_1b");
    else
    {
        throwout(_("Achtung, unbekannter Algo \nKann nicht zugreifen!"));
        return;
    }
    wxRenameFile(kpath+ciphnam,kpath+ciphnam+addendum);

    if(!unlockinplace(outfile,&oldphrase,algo))
    {
        wxMessageBox(_("Konnte Importdatei nicht aufschliessen!\nAbbruch!"));
        return;
    }
    if((pkf=fopen((const char*)outfile.mb_str(wxConvLocal),"r")) == NULL)
    {
        nostop=false;
        throwout(_("Fehler! Konnte aufgeschlossene Importdatei nicht oeffnen!?!"));
        return;
    }
    loadsuccess=true;
    rcnt=fscanf(pkf,"id: %400s \n",buff1);
    if(rcnt==1)
    {
        loky.id=wxString::FromUTF8(buff1);
    }
    else loadsuccess=false;

    rcnt=fscanf(pkf,"fullnam: %400s \n",buff1);
    if(rcnt==1)
    {
        loky.fullnam=wxString::FromUTF8(buff1);
    }
    else loadsuccess=false;

    rcnt=fscanf(pkf,"domnam: %400s \n",buff1);
    if(rcnt==1)
    {
        loky.domnam=wxString::FromUTF8(buff1);
        if(loky.domnam != gdom.name)
        {
            //check for accessible domain
            if(!(e_ls.isinlist(loky.domnam)))
                    throwout(_("Warnung!\nangezeigte Domain liegt hier nicht vor."),5);
            dom_match = false;
        }
    }
    else loadsuccess=false;

    rcnt=fscanf(pkf,"d: %2046s \n",buff3);
    if(rcnt==1)
    {
        h=wxString::FromUTF8(buff3);
        if(!loky.d.storhex(&h))
        {
           throwout(_("Fehler bei Hexzahl Konversion\n Abbruch"));
           loadsuccess=false;
        }
    }
    else loadsuccess=false;
    fclose(pkf);
    if(st_and_salt) wxRemoveFile( outfile); //if ciph format
    else                                    //if nude prv file
    {
      if( !lockinplace(outfile,&oldphrase,algo))
      {
        throwout(_("SICHERHEITSALARM!\n Konnte Schluesseldatei nicht sicher verschliessen.\nSie muessen die Klarfragmente manuell entfernen!!"));
      }
    }
    if(!loadsuccess) return;

    //check if ID already in use
    if(!priv_keyid_free(loky.id,false))
     {
        throwout(loky.id + _("\nSchluessel ID bereits in Benutzung fuer privaten Schluessel\nKann nicht importieren!\nDu muesstest erst den kollidierenden Schluessel entfernen!"));
        return;
    }
    //check if ID already in use
    if(!pub_keyid_free(loky.id,false))
     {
        throwout(loky.id + _("\nSchluessel ID wird bereits fuer einen oeffentl. chluessel benutzt\nkann nicht importieren(Integritaet!)!\nDu musst zuerst den kollidierenden Schluessel entfernen/umbenennen!"));
        return;
    }
    //convert d
    if( !loky.d.lonu_unlock(&oldphrase,algo) )
    {
        throwout(_("lonu aufschliess Fehler\n Abbruch"));
        return;
    }
    /*** not needed here, insert in list instead //copy to elky
    elky.copy_priv_ky(&loky);
    throwout(_("Done, now don't forget to save locally!"));
    //put into dialog fields
	id_ctrl->SetValue(elky.id);
	fullname_ctrl->SetValue(elky.fullnam);
	domnam_ctrl->SetValue(elky.domnam);
	wxString number;
	elky.d.writehex(&number);
	d_ctrl->SetValue(number);
	//jetzt A ermitteln
    if(dom_match) On_A_refresh( event);****/
    //open keynamfile, append name and id, close keynamfile

    if(S_FIL) unlockinplace(sec_path + _("/ell_knamfile.knf"),&zugang); // unlock keynamefile
    hs=sec_path + _("/ell_knamfile.knf");
    if((knamfil = fopen((const char*)hs.mb_str(wxConvLocal), "a"))== NULL) return;
    fprintf(knamfil, "\n id: %s  Name: %s  ",(const char*)loky.id.mb_str(wxConvUTF8),
                  (const char*)loky.fullnam.mb_str(wxConvUTF8));
    fclose(knamfil);
    if(S_FIL) lockinplace(sec_path + _("/ell_knamfile.knf"),&zugang); // lock again

    //open keyfile, store all data and close
    if(S_FIL) unlockinplace(sec_path + _("/ell_Keyfile.kyf"),&zugang); // unlock keynamefile
    if((kfil = fopen((const char*)((sec_path + _("/ell_Keyfile.kyf")).mb_str(wxConvLocal)), "a"))== NULL) return;
    fprintf(kfil, "\n id: %s  Name: %s DomainName: %s",(const char*)loky.id.mb_str(wxConvUTF8),
                  (const char*)loky.fullnam.mb_str(wxConvUTF8),(const char*)loky.domnam.mb_str(wxConvUTF8));
    // doublecrypt: hier vorher extra verschlüsseln
    tempd.copynum(&(loky.d));
    tempd.shrinktofit();
    tempd.lonu_lock(&zugang);
    tempd.writehex(&txd);

    fprintf(kfil,"\n d: %s ", (const char*)txd.mb_str(wxConvUTF8));
    fprintf(kfil," \n");
    fclose(kfil);
    if(S_FIL) lockinplace(sec_path + _("/ell_Keyfile.kyf"),&zugang); // unlock keynamefile
    throwout(_("Privater Schluessel wurde sicher\n im internen Speicher abgelegt."));
nostop=false;    EndModal(1);
}
/*********************************************************/
void Del_imp_priv::OnTimer1Trigger(wxTimerEvent& event)
{
    half_min_counter++;
    if((half_min_counter > 20)&&(!nostop))  //mehr als 2 Minuten idle
    {
        unarm();
        EndModal(0);
    }
    return;
}
/*****************************************************************/
