/*
 *   Copyright (C) 2011-2016, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
 

#ifndef ELLIPTIC_VERIFY_H
#define ELLIPTIC_VERIFY_H

//(*Headers(elliptic_verify)
#include <wx/dialog.h>
#include <wx/sizer.h>
#include <wx/button.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>
//*)
#include "elliptic1.h"
#include "random_clx.h"

#include <wx/colour.h>


class elliptic_verify: public wxDialog
{
	public:

		elliptic_verify(wxWindow* parent,wxWindowID id=wxID_ANY,const wxPoint& pos=wxDefaultPosition,const wxSize& size=wxDefaultSize);
		virtual ~elliptic_verify();

		//(*Declarations(elliptic_verify)
		wxTextCtrl* ax_ctrl;
		wxButton* Button4;
		wxButton* Button1;
		wxButton* Button2;
		wxButton* Button3;
		wxTextCtrl* id_ctrl;
		wxStaticText* StaticText1;
		wxStaticText* StaticText10;
		wxStaticText* StaticText3;
		wxTextCtrl* ky_domnam_ctrl;
		wxTextCtrl* sigfil_ctrl;
		wxButton* Button5;
		wxStaticText* StaticText8;
		wxStaticText* StaticText7;
		wxTextCtrl* ay_ctrl;
		wxStaticText* StaticText4;
		wxStaticText* StaticText5;
		wxStaticText* StaticText2;
		wxStaticText* StaticText6;
		wxTextCtrl* fullnam_ctrl;
		wxButton* Button7;
		wxTextCtrl* currdom_ctrl;
		wxTextCtrl* file_ctrl;
		wxStaticText* StaticText9;
		wxButton* Button6;
		wxTextCtrl* res_ctrl;
		wxStaticText* StaticText11;
		//*)
		wxString fnam,signam;
        el_pub loky;
        wxColor redcol,grencol,neutcol;
        //wxTextAttr red,gren,neut; -> dysfunctional *#@!X
        //wxColor redcol(255,120,120),grencol(120,255,120),neutcol(255,200,170);

	protected:

		//(*Identifiers(elliptic_verify)
		static const long ID_BUTTON5;
		static const long ID_STATICTEXT1;
		static const long ID_STATICTEXT2;
		static const long ID_TEXTCTRL1;
		static const long ID_BUTTON1;
		static const long ID_STATICTEXT11;
		static const long ID_TEXTCTRL9;
		static const long ID_STATICTEXT3;
		static const long ID_STATICTEXT10;
		static const long ID_BUTTON2;
		static const long ID_STATICTEXT4;
		static const long ID_STATICTEXT5;
		static const long ID_STATICTEXT6;
		static const long ID_TEXTCTRL2;
		static const long ID_TEXTCTRL3;
		static const long ID_TEXTCTRL4;
		static const long ID_STATICTEXT7;
		static const long ID_TEXTCTRL5;
		static const long ID_STATICTEXT9;
		static const long ID_STATICTEXT8;
		static const long ID_TEXTCTRL6;
		static const long ID_TEXTCTRL7;
		static const long ID_BUTTON4;
		static const long ID_BUTTON6;
		static const long ID_BUTTON7;
		static const long ID_BUTTON3;
		static const long ID_TEXTCTRL8;
		//*)

	private:

		//(*Handlers(elliptic_verify)
		void OnFileSel(wxCommandEvent& event);
		void GetStoredPublicKey(wxCommandEvent& event);
		void LoadPukyfromFile(wxCommandEvent& event);
		void OnSorePubky(wxCommandEvent& event);
		void OnProove(wxCommandEvent& event);
		void LoadOtherDomain(wxCommandEvent& event);
		void OnCancExit(wxCommandEvent& event);
		void OnFilenameEdit(wxCommandEvent& event);
		//*)
 
        void OnDropFile(wxDropFilesEvent& event); //manually edited handler
        bool drop_succ;  //provide Feedback

		DECLARE_EVENT_TABLE()
};

#endif
