/*
 *   Copyright (C) 2011-2012, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */





//#ifndef __MONOCORE__
//#define __MONOCORE__
//#endif

#ifndef ELLIPTIC1_H_INCLUDED
#define ELLIPTIC1_H_INCLUDED



#include <stdlib.h>
#include <wx/string.h>
#include <wx/intl.h>
#include <wx/file.h>
#include <wx/msgdlg.h>

#include "dolonu.h"
//#include "helpersxx.h"



class ellipse;
/***********************************/
class e_p
{
    public:
      e_p();
      ~e_p();
      e_p(longnumber *xin, longnumber *yin);
      int subtract(e_p* summand,ellipse* ewp);
      int add(e_p* summand,ellipse* ewp);
      int dopp(ellipse* ewp);
      bool copy_ep(e_p* source);
      int mult_p(longnumber* factor,ellipse* ewp);
      int mult_p_q(longnumber* factor,ellipse* ewp);
      int mult_p_qj(longnumber* factor,ellipse* ewp, bool multhr=true);
      bool isequal(e_p* point);
      bool isequal(e_p* point, longnumber* pmodul);
      bool is_in_ellipse(ellipse* ewp);
      bool get_y_from_x( ellipse* ewp, bool loval);
      bool get_point_in_ellipse(ellipse* ewp);
      int neutralize();

      longnumber x;
      longnumber y;
      bool neutral;
};
/************************************/
/***********************************/
class projective_point
{
    public:
      projective_point(e_p* pin);
      projective_point(projective_point* pin);
     ~projective_point();
      int add(projective_point* summand,ellipse* ewp);
      int subtract(projective_point* summand,ellipse* ewp);
      int dopp(ellipse* ewp);
      bool copy_prj(projective_point* source);
      int mult_prj(longnumber* factor,ellipse* ewp);
      int mult_prj_q(longnumber* factor,ellipse* ewp);
      bool isequal(projective_point* point);
      bool isequal(projective_point* point, longnumber* pmodul, bool test_affine=false);
      int neutralize();
      bool spitout(e_p* outpoint,ellipse* ewp);
      bool prj_fill(e_p* pin);

      longnumber x;
      longnumber y;
      longnumber z;
      bool neutral;
};
/************************************/
/***********************************/
class proj_jacobian
{
    public:
      proj_jacobian(e_p* pin);
      proj_jacobian(proj_jacobian* pin);
     ~proj_jacobian();
      int add(proj_jacobian* summand,ellipse* ewp);
      int add_spec(proj_jacobian* summand,ellipse* ewp);
      int subtract(proj_jacobian* summand,ellipse* ewp);
      int dopp(ellipse* ewp);
      int dopp_spec(ellipse* ewp);
      bool copy_prj(proj_jacobian* source);
      int mult_prj(longnumber* factor,ellipse* ewp);
      int mult_prj_q(longnumber* factor,ellipse* ewp,bool mc=true);
      int mult_prj_q_mc(longnumber* factor,ellipse* ewp); //multicore version
      bool isequal(proj_jacobian* point);
      bool isequal(proj_jacobian* point, longnumber* pmodul, bool test_affine=false);
      int neutralize();
      bool spitout(e_p* outpoint,ellipse* ewp);
      bool prj_fill(e_p* pin);

      longnumber x;
      longnumber y;
      longnumber z;
      bool neutral;
};
/************************************/
class ellipse
{
  public:
    ellipse();
    ellipse(char* fnam);
    ellipse( longnumber* ap, longnumber* bp, longnumber* pp, longnumber* pq, e_p* d0, wxString name=_("empty"));
    ~ellipse();
    void copyell(ellipse *src);
    void ellipse_setintern();
    void ellipse_set_stretch1024();
    void ellipse_set_768();

    bool el_from_file(char* fnam);
    bool el_selftest();
    bool el_safety();
    long giv_siz();
    bool makerare();



    wxString name;
    longnumber a;
    longnumber b;
    longnumber p; //ist das Modul
    longnumber q; //Galois-Periode der ellipse
    e_p d0;  // ist der Startpunkt
    bool a_m3; //true if parameter a is minus three
};
/*****************************************/
class el_list
{
  public:
    el_list();
    ~el_list();

    int getelp(ellipse *rep, wxString ell_id); //return ellipse ptr for ell id, return 1 on success 0 on fail, fill rep with Null on fail
    int getelp(ellipse *rep, unsigned int pos); //return ellipse ptr for ell id, return 1 on success 0 on fail, fill rep with Null on fail
    void sortlen();
    int add_ellps(ellipse *inell, bool expl=false);
    int cut_ellps(wxString ell_id);
    int swap_ell(int p1, int p2);
    int mov_top_ell(int p);
    int mov_bott_ell(int p);
    int cut_ellps(int pos);
    int getpos4nam(wxString ell_id);
    unsigned int addfromfile(wxString fnam, bool expl=false);
    unsigned int setfromfile(wxString fnam);
    void empty_list();
    bool write_list2file(wxString fnam);
    bool isinlist(wxString name);

    ellipse **rpt;
    unsigned int noel;

};
/******************************************/
class el_priv
{
  public:
    el_priv();
    el_priv(longnumber* pn, ellipse *domain, wxString id_in, wxString fullnam_in);
    el_priv(unsigned long kyz, ellipse *domain, wxString id_in, wxString fullnam_in);
    ~el_priv();

    bool set_el_priv(longnumber* pn, ellipse *domain, wxString id_in, wxString fullnam_in);
    bool copy_priv_ky(el_priv* keyadd);

    longnumber d;
    wxString domnam;
    wxString id;
    wxString fullnam;
    e_p A;
};
/*****************************************/
/*****************************************/
class el_pub
{
  public:
    el_pub();
    el_pub(e_p* A, ellipse *domain, wxString id_in, wxString fullnam_in);
    ~el_pub();

    bool set_el_pub(e_p* pA, ellipse *domain, wxString id_in, wxString fullnam_in);
    bool get_from_file(wxString fnam);
    bool copy_pub_ky(el_pub* keyadd);

    wxString domnam;
    wxString id;
    wxString fullnam;
    e_p A;
};
/*************************************************************/
class precalc
{
    public:
      precalc();
      ~precalc();

      bool set_prec( ellipse *ewp, bool multithread); //returns true on success
      bool copy_pre(precalc *ppre); //copies pre from source
      void wipe();

      bool to_abort;
      bool is_done;
      bool is_used;
      bool is_running;
      longnumber ke;
      longnumber kinv;
      longnumber r;
      ellipse *pe;
      wxString domnam;
};
/***********************************/
/*****************************************/
/** Globals in elliptics   *****/
/***************************************************/
int sign_elliptic(wxString fnam, ellipse *dom_p, el_priv *ky, longnumber *pr, longnumber *ps);
//elliptic signer
/**********************************************************/
bool verify_elliptic(wxString fnam, ellipse *dom_p, e_p *p_pubky, longnumber *pr, longnumber *ps);
/**********************************************************/
/***************************************************/
int sign_elliptic_q(wxString fnam, ellipse *dom_p, el_priv *ky, longnumber *pr, longnumber *ps);
//elliptic signer
/**********************************************************/
bool verify_elliptic_q(wxString fnam, ellipse *dom_p, e_p *p_pubky, longnumber *pr, longnumber *ps);
/**********************************************************/
/***************************************************/
int sign_elliptic_qq(wxString fnam, ellipse *dom_p, el_priv *ky, longnumber *pr, longnumber *ps,wxString *hash,bool shoprog=true, bool deterministic=false,wxString *detwordpt=NULL);
//elliptic signer
/***************************************************/
int sign_elliptic_pre(precalc *pre, wxString fnam, ellipse *dom_p, el_priv *ky, longnumber *pr, longnumber *ps,wxString *hash);
//elliptic signer
/**********************************************************/
/**********************************************************/
bool verify_elliptic_qq(wxString fnam, ellipse *dom_p, e_p *p_pubky, longnumber *pr, longnumber *ps, wxString hash,bool shoprog=true);
/**********************************************************/
bool recover_ecc_ky(el_priv *p_priv, e_p *pB, longnumber *pky, ellipse *dom_p );
/**********************************************************/
bool make_ecc_ky(longnumber *pke, ellipse *dom_p, e_p *p_pubky, e_p *pB, longnumber *pky);
/**********************************************************/
bool test_enciph();
/**********************************************************/
/***************Global Funs***********************/
bool kyprep(longnumber *pky, wxString *keystr, longnumber *psalt, ellipse *pse,  int stretch, int outlen, bool legacy=false );
/*********************************************************************/
bool kyprep_longblock(longnumber *pky, wxString *keystr, longnumber *psalt, ellipse *pse,  int stretch,int outlen, ulong32 memsize );
/**********************************************************/
bool load_pub_ell_ky(el_pub *nky,  wxString *pname);
//loads the key with ID *pname into *nky, returns true if successful
/**********************************************************************/
bool load_priv_ell_ky(el_priv *nky,  wxString *pname);
//loads the key with ID *pname into *nky, returns true if successful
/**********************************************************************/
bool export_ellips(ellipse *pelp);
//exportiert ellipsetextfile nach <id>.ell in keytray
/**************************************************************/
bool validate_pubkey(el_pub *ppubky, bool verbose=true);
//validates public key against domainlist
/******************************************************************/
bool cap_prep_from_String(wxString *keyin, longnumber *psalt, longnumber *pcounter, ulong32 cntlen, longnumber *pkey,  ellipse *pse,  int stretch,int outlen, bool islegacy);
/**********************************************************************/
bool cap_prep_from_pubky(el_pub *ppub, longnumber *pcounter, ulong32 cntlen, longnumber *pkey, int outlen);
/**************************************************************/
bool cap_prep_from_point(e_p *pp, longnumber *pcounter, ulong32 cntlen, longnumber *pkey, int outlen);
/**************************************************************/
bool Make_DeCapped(wxString *pkeyword, wxString *pfnam, wxString *scratchnam, wxString *endmark, e_p *ppoint, unsigned int *pdeadhd, bool verbose=true, bool cutshort=false, bool islegacy=false);
/********************************************************************************/



#endif // ELLIPTIC1_H_INCLUDED
