/*
 *   Copyright (C) 2011-2018, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */


#include "makehash.h"
#include "globals.h"

#include <wx/file.h>
#include <wx/ffile.h>
#include "skein.h"


#include <wx/arrstr.h>
#include <wx/dir.h>
#include <wx/busyinfo.h>


//(*InternalHeaders(makehash)
#include <wx/settings.h>
#include <wx/string.h>
#include <wx/intl.h>
#include <wx/font.h>
//*)

//(*IdInit(makehash)
const long makehash::ID_BUTTON2 = wxNewId();
const long makehash::ID_STATICTEXT1 = wxNewId();
const long makehash::ID_BUTTON3 = wxNewId();
const long makehash::ID_STATICTEXT2 = wxNewId();
const long makehash::ID_TEXTCTRL1 = wxNewId();
const long makehash::ID_BUTTON1 = wxNewId();
const long makehash::ID_STATICTEXT3 = wxNewId();
const long makehash::ID_STATICTEXT4 = wxNewId();
const long makehash::ID_STATICTEXT5 = wxNewId();
const long makehash::ID_TEXTCTRL2 = wxNewId();
const long makehash::ID_CHOICE1 = wxNewId();
//*)

BEGIN_EVENT_TABLE(makehash,wxDialog)
	//(*EventTable(makehash)
	//*)
END_EVENT_TABLE()

makehash::makehash(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
	//(*Initialize(makehash)
	wxFlexGridSizer* FlexGridSizer1;

	Create(parent, id, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("id"));
	SetClientSize(wxSize(873,417));
	Move(wxDefaultPosition);
	FlexGridSizer1 = new wxFlexGridSizer(0, 3, 0, 0);
	Button2 = new wxButton(this, ID_BUTTON2, _("Schliessen"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON2"));
	Button2->SetBackgroundColour(wxColour(243,206,206));
	wxFont Button2Font(11,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button2->SetFont(Button2Font);
	FlexGridSizer1->Add(Button2, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText1 = new wxStaticText(this, ID_STATICTEXT1, _("Berechnen des Hashwertes einer Datei"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT1"));
	wxFont StaticText1Font(14,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText1->SetFont(StaticText1Font);
	FlexGridSizer1->Add(StaticText1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button3 = new wxButton(this, ID_BUTTON3, _("Hash erstellen"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON3"));
	Button3->SetBackgroundColour(wxColour(203,213,242));
	wxFont Button3Font(11,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button3->SetFont(Button3Font);
	FlexGridSizer1->Add(Button3, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText2 = new wxStaticText(this, ID_STATICTEXT2, _("Datei fuer Hash:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT2"));
	wxFont StaticText2Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText2->SetFont(StaticText2Font);
	FlexGridSizer1->Add(StaticText2, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	file_ctrl = new wxTextCtrl(this, ID_TEXTCTRL1, _("-"), wxDefaultPosition, wxSize(549,23), 0, wxDefaultValidator, _T("ID_TEXTCTRL1"));
	wxFont file_ctrlFont(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	file_ctrl->SetFont(file_ctrlFont);
	FlexGridSizer1->Add(file_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button1 = new wxButton(this, ID_BUTTON1, _("Datei waehlen"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON1"));
	wxFont Button1Font(11,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button1->SetFont(Button1Font);
	FlexGridSizer1->Add(Button1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	FlexGridSizer1->Add(-1,-1,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText3 = new wxStaticText(this, ID_STATICTEXT3, _("Die Datei mit dem Hashwert als Hexzahl liegt im \ngleichen Verzeichnis, wie die Zieldatei."), wxDefaultPosition, wxSize(283,32), 0, _T("ID_STATICTEXT3"));
	wxFont StaticText3Font = wxSystemSettings::GetFont(wxSYS_OEM_FIXED_FONT);
	if ( !StaticText3Font.Ok() ) StaticText3Font = wxSystemSettings::GetFont(wxSYS_DEFAULT_GUI_FONT);
	StaticText3Font.SetPointSize(8);
	StaticText3Font.SetStyle(wxFONTSTYLE_NORMAL);
	StaticText3Font.SetWeight(wxNORMAL);
	StaticText3Font.SetUnderlined(false);
	StaticText3Font.SetFamily(wxSWISS);
	StaticText3Font.SetFaceName(_T("Sans"));
	StaticText3->SetFont(StaticText3Font);
	FlexGridSizer1->Add(StaticText3, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText4 = new wxStaticText(this, ID_STATICTEXT4, _("Waehle Hash Algorithmus"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT4"));
	wxFont StaticText4Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText4->SetFont(StaticText4Font);
	FlexGridSizer1->Add(StaticText4, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText5 = new wxStaticText(this, ID_STATICTEXT5, _("Hash Wert:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT5"));
	wxFont StaticText5Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText5->SetFont(StaticText5Font);
	FlexGridSizer1->Add(StaticText5, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	hash_ctrl = new wxTextCtrl(this, ID_TEXTCTRL2, _("-"), wxDefaultPosition, wxSize(542,249), wxTE_MULTILINE, wxDefaultValidator, _T("ID_TEXTCTRL2"));
	wxFont hash_ctrlFont(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	hash_ctrl->SetFont(hash_ctrlFont);
	FlexGridSizer1->Add(hash_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Choice1 = new wxChoice(this, ID_CHOICE1, wxDefaultPosition, wxSize(169,22), 0, 0, 0, wxDefaultValidator, _T("ID_CHOICE1"));
	Choice1->Append(_("sha256(256 bit)"));
	Choice1->Append(_("sha512(512 bit)"));
	Choice1->Append(_("JH (SHA3-Finalist 512 bit)"));
	Choice1->SetSelection( Choice1->Append(_("skein(SHA3-Finalist 1024 bit)")) );
	Choice1->Append(_("Fleas_1_8(1024 bit)"));
	Choice1->Append(_("Fleas_3(1024 bit)"));
	Choice1->Append(_("Fleas_o2(2048 bit)"));
	Choice1->Append(_("Fleas_o5(4096 bit)"));
	Choice1->Append(_("Fleas_l(4096 bit)"));
	Choice1->Append(_("Fleas_lx(4096 bit)"));
	Choice1->Append(_("Fleas_lx3(4096 bit)"));
	Choice1->Append(_("Fleas_lc(4096 bit,3 Paths)"));
	Choice1->Append(_("Fleas_ld(4096 bit,4 Paths)"));
	Choice1->Append(_("Fleas_lb(4096 bit,2 Paths)"));
	Choice1->Append(_("Fleas_c(4096 bit,3 Paths)"));
	Choice1->Append(_("Fleas_d(4096 bit,4 Paths)"));
	Choice1->Append(_("Fleas_b(4096 bit,2 Paths)"));
	wxFont Choice1Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Choice1->SetFont(Choice1Font);
	FlexGridSizer1->Add(Choice1, 1, wxALL|wxALIGN_TOP|wxALIGN_CENTER_HORIZONTAL, 5);
	SetSizer(FlexGridSizer1);
	SetSizer(FlexGridSizer1);
	Layout();

	Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&makehash::OnCancel);
	Connect(ID_BUTTON3,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&makehash::OnHash);
	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&makehash::OnFileSel);
	//*)

    file_ctrl->DragAcceptFiles(true);
    file_ctrl->Connect(wxEVT_DROP_FILES, wxDropFilesEventHandler(makehash::OnDropFile), NULL, this);

}

makehash::~makehash()
{
	//(*Destroy(makehash)
	//*)
}


void makehash::OnCancel(wxCommandEvent& event)
{
    EndModal(0);
}
/******************************************************/
void makehash::OnHash(wxCommandEvent& event)
{
    int hnum;
    wxString hash,outnam,hstr;
    longnumber h_doc;
    unsigned long len,i;
    char *buff;
    bool succ;
    //get filename
    fnam=file_ctrl->GetLineText(0);
    //check for existence
    if(!wxFile::Exists(fnam))
    {
        throwout(_("Zu hashende Datei existiert nicht!\nTuNix."),3);
        return;
    }
    //get algortihm
    hash=_("Fleas_lx");
    hnum= Choice1->GetCurrentSelection();
    if(hnum==0) hash=_("sha2");
    else if(hnum==1) hash=_("sha4");
    else if(hnum==2) hash=_("JH");
    else if(hnum==3) hash=_("skein");
    else if(hnum==4) hash=_("Fleas_1_8");
    else if(hnum==5) hash=_("Fleas_3");
    else if(hnum==6) hash=_("Fleas_o2");
    else if(hnum==7) hash=_("Fleas_o5");
    else if(hnum==8) hash=_("Fleas_l");
    else if(hnum==9) hash=_("Fleas_lx");
    else if(hnum==10) hash=_("Fleas_lx3");
    else if(hnum==11) hash=_("Fleas_lc");
    else if(hnum==12) hash=_("Fleas_ld");
    else if(hnum==13) hash=_("Fleas_lb");
    else if(hnum==14) hash=_("Fleas_c");
    else if(hnum==15) hash=_("Fleas_d");
    else if(hnum==16) hash=_("Fleas_b");
     //calculate hash

    switch(hnum)
    {
        case 0:
          succ=get_lonu_sha2_from_filename(&h_doc, &fnam);
          break;

        case 1:
          succ=get_lonu_sha2_from_filename(&h_doc, &fnam,512);
          break;

        case 2:
          succ=get_lonu_JH_from_filename(&h_doc, &fnam,512);
          break;

        case 3:
          succ=get_lonu_skein1024_from_filename(&h_doc, &fnam);
          break;

        case 4:
          succ=get_lonu_hash_from_filename(&h_doc, &fnam,128);
          break;

        case 5:
          succ=get_lonu_hash_from_filename_3(&h_doc, &fnam,128);
          break;

        case 6:
          succ=get_lonu_hash_from_filename_x(&h_doc, &fnam,256,hash);
          break;

        case 7:
        case 8:
        case 9:
        case 10:
        case 11:
        case 12:
        case 13:
        case 14:
        case 15:
        case 16:
          succ=get_lonu_hash_from_filename_x(&h_doc, &fnam,512,hash);
          break;
        default:
          throwout(_("Warnung!\n kein Hash Algorithmus gewaehlt\n defaulting zu Fleas_l"),10);
          succ=get_lonu_hash_from_filename_x(&h_doc, &fnam,512,_("Fleas_lc"));
    }
    //build new filename
    outnam=fnam + _(".") + hash;
    h_doc.writehex(&hstr,true);
    //check length
    len= hstr.Len();
    if(len>10000)
    {
        throwout(_("Warnung!\n Excessive Laenge des Hash Wertes(>10000)\nKappung auf 10000"),5);
        len=10000;
        hstr= hstr.Left(len);
    }
    if(len>4000)
    {
        hash_ctrl->SetValue(hstr.Left(4000));
        throwout(_("Warnung\nGekappt im Textfeld auf 4000 Zeichen"),3);
    }
    else hash_ctrl->SetValue(hstr);
    //throwout(_("hash calculated!\nnow writing result file."),3);
    buff= (char *) malloc(2*len+2);
    strcpy( buff, (const char*)hstr.mb_str(wxConvUTF8) );// schreibt den hash in buff rein
        //write into file
    if(succ)
    {
      wxFFile of(outnam,_("wb"));
      of.Write(buff,len);
      of.Close();
      throwout((_("Hashing  ") + fnam + _("\nTextfile: ") + outnam + _(" erzeugt in hex Notation, Hibyte links")),10);
    }
    free(buff);
    return;
}
/*******************************************************/
void makehash::OnFileSel(wxCommandEvent& event)
{
    wxString tmsg_fnam;

    fnam = wxFileSelector(_("Waehle eine Date zum hashen"),doc_path);
    if ( !fnam.empty() )
    {
        file_ctrl->SetValue(fnam);
    }
    return;
}
/**********************************************************/
/*******************************************************/
void makehash::OnDropFile(wxDropFilesEvent& event)
    {
        int filno;
        drop_succ=false;

        if (event.GetNumberOfFiles() > 0) {

            wxString* dropped = event.GetFiles();
            wxASSERT(dropped);

            wxBusyCursor busyCursor;
            wxWindowDisabler disabler;
            wxBusyInfo busyInfo(_("Adding file, wait please..."));

            wxString name;
            filno = event.GetNumberOfFiles();
            if(filno!=1)
            {
				throwout(_("Nur ein Dateiname moeglich.\nDrop abgelehnt!"),3);
				return;
			}
			if( wxDirExists( 	dropped[0]	))
            {
                throwout(_("Das ist ein Verzeichnisname!!\nNur Dateiname moeglich.\nDrop ignoriert!"),3);
                return;
            }
			name = dropped[0];
			if (!wxFileExists(name))
            {
				throwout(_("Datei existiert nicht\nDrop abgelehnt!"),5);
				return;
			}

            wxTextCtrl* textCtrl = dynamic_cast<wxTextCtrl*>(event.GetEventObject());
            wxASSERT(textCtrl);
            textCtrl->Clear();
            textCtrl->SetValue(name);
            drop_succ=true;
            fnam=name;
            cur_doc_path= ((wxFileName)fnam).GetPath(); //get new path and store into cur_doc_path


            return;
        }
    }
/*********************************************************/
