/*
 *   Copyright (C) 2011-2016, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */


#include <wx/string.h>

#include "gpg_wrap.h"
#include "gpg_manag_priv.h"
#include "helpersxx.h"
#include "gnupg_globals.h"
#include "globals.h"
#include "gpg_new_keyDialog.h"






//(*InternalHeaders(gpg_new_keyDialog)
#include <wx/string.h>
#include <wx/intl.h>
#include <wx/font.h>
//*)

//(*IdInit(gpg_new_keyDialog)
const long gpg_new_keyDialog::ID_BUTTON2 = wxNewId();
const long gpg_new_keyDialog::ID_STATICTEXT1 = wxNewId();
const long gpg_new_keyDialog::ID_STATICTEXT2 = wxNewId();
const long gpg_new_keyDialog::ID_TEXTCTRL1 = wxNewId();
const long gpg_new_keyDialog::ID_STATICTEXT3 = wxNewId();
const long gpg_new_keyDialog::ID_TEXTCTRL2 = wxNewId();
const long gpg_new_keyDialog::ID_STATICTEXT4 = wxNewId();
const long gpg_new_keyDialog::ID_TEXTCTRL3 = wxNewId();
const long gpg_new_keyDialog::ID_STATICTEXT5 = wxNewId();
const long gpg_new_keyDialog::ID_CHOICE1 = wxNewId();
const long gpg_new_keyDialog::ID_STATICTEXT6 = wxNewId();
const long gpg_new_keyDialog::ID_CHOICE2 = wxNewId();
const long gpg_new_keyDialog::ID_STATICTEXT9 = wxNewId();
const long gpg_new_keyDialog::ID_SLIDER1 = wxNewId();
const long gpg_new_keyDialog::ID_STATICTEXT7 = wxNewId();
const long gpg_new_keyDialog::ID_TEXTCTRL4 = wxNewId();
const long gpg_new_keyDialog::ID_STATICTEXT8 = wxNewId();
const long gpg_new_keyDialog::ID_TEXTCTRL5 = wxNewId();
const long gpg_new_keyDialog::ID_BUTTON1 = wxNewId();
//*)

BEGIN_EVENT_TABLE(gpg_new_keyDialog,wxDialog)
	//(*EventTable(gpg_new_keyDialog)
	//*)
END_EVENT_TABLE()

gpg_new_keyDialog::gpg_new_keyDialog(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
	//(*Initialize(gpg_new_keyDialog)
	wxFlexGridSizer* FlexGridSizer1;

	Create(parent, id, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("id"));
	SetClientSize(wxDefaultSize);
	Move(wxDefaultPosition);
	FlexGridSizer1 = new wxFlexGridSizer(0, 2, 0, 0);
	Button2 = new wxButton(this, ID_BUTTON2, _("Schliessen"), wxDefaultPosition, wxSize(99,30), 0, wxDefaultValidator, _T("ID_BUTTON2"));
	Button2->SetBackgroundColour(wxColour(246,181,150));
	wxFont Button2Font(11,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button2->SetFont(Button2Font);
	FlexGridSizer1->Add(Button2, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	StaticText1 = new wxStaticText(this, ID_STATICTEXT1, _("Neuen GnuPG Schluessel erstellen"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT1"));
	wxFont StaticText1Font(13,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText1->SetFont(StaticText1Font);
	FlexGridSizer1->Add(StaticText1, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	StaticText2 = new wxStaticText(this, ID_STATICTEXT2, _("Ihr Name:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT2"));
	wxFont StaticText2Font(10,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText2->SetFont(StaticText2Font);
	FlexGridSizer1->Add(StaticText2, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	name_ctrl = new wxTextCtrl(this, ID_TEXTCTRL1, wxEmptyString, wxDefaultPosition, wxSize(375,22), 0, wxDefaultValidator, _T("ID_TEXTCTRL1"));
	wxFont name_ctrlFont(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	name_ctrl->SetFont(name_ctrlFont);
	FlexGridSizer1->Add(name_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	StaticText3 = new wxStaticText(this, ID_STATICTEXT3, _("Kommentar eingeben:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT3"));
	wxFont StaticText3Font(10,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText3->SetFont(StaticText3Font);
	FlexGridSizer1->Add(StaticText3, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	comm_ctrl = new wxTextCtrl(this, ID_TEXTCTRL2, wxEmptyString, wxDefaultPosition, wxSize(375,22), 0, wxDefaultValidator, _T("ID_TEXTCTRL2"));
	wxFont comm_ctrlFont(10,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	comm_ctrl->SetFont(comm_ctrlFont);
	FlexGridSizer1->Add(comm_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	StaticText4 = new wxStaticText(this, ID_STATICTEXT4, _("Ihre e-mail:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT4"));
	wxFont StaticText4Font(10,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText4->SetFont(StaticText4Font);
	FlexGridSizer1->Add(StaticText4, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	imehl_ctrl = new wxTextCtrl(this, ID_TEXTCTRL3, wxEmptyString, wxDefaultPosition, wxSize(375,22), 0, wxDefaultValidator, _T("ID_TEXTCTRL3"));
	wxFont imehl_ctrlFont(10,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	imehl_ctrl->SetFont(imehl_ctrlFont);
	FlexGridSizer1->Add(imehl_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	StaticText5 = new wxStaticText(this, ID_STATICTEXT5, _("asymm.Algorithmus:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT5"));
	wxFont StaticText5Font(10,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText5->SetFont(StaticText5Font);
	FlexGridSizer1->Add(StaticText5, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	algo_ctrl = new wxChoice(this, ID_CHOICE1, wxDefaultPosition, wxSize(220,29), 0, 0, 0, wxDefaultValidator, _T("ID_CHOICE1"));
	algo_ctrl->SetSelection( algo_ctrl->Append(_("RSA")) );
	algo_ctrl->Append(_("DSA"));
	wxFont algo_ctrlFont(10,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	algo_ctrl->SetFont(algo_ctrlFont);
	FlexGridSizer1->Add(algo_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	StaticText6 = new wxStaticText(this, ID_STATICTEXT6, _("Schluessellaenge:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT6"));
	wxFont StaticText6Font(10,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText6->SetFont(StaticText6Font);
	FlexGridSizer1->Add(StaticText6, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	len_ctrl = new wxChoice(this, ID_CHOICE2, wxDefaultPosition, wxSize(219,29), 0, 0, 0, wxDefaultValidator, _T("ID_CHOICE2"));
	len_ctrl->Append(_("1024"));
	len_ctrl->Append(_("2048"));
	len_ctrl->SetSelection( len_ctrl->Append(_("3072")) );
	len_ctrl->Append(_("4096"));
	wxFont len_ctrlFont(10,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	len_ctrl->SetFont(len_ctrlFont);
	FlexGridSizer1->Add(len_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	StaticText9 = new wxStaticText(this, ID_STATICTEXT9, _("Gueltigkeit[Jahre]:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT9"));
	wxFont StaticText9Font(10,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText9->SetFont(StaticText9Font);
	FlexGridSizer1->Add(StaticText9, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	Slider1 = new wxSlider(this, ID_SLIDER1, 5, 1, 20, wxDefaultPosition, wxSize(173,51), wxSL_AUTOTICKS|wxSL_LABELS|wxALWAYS_SHOW_SB, wxDefaultValidator, _T("ID_SLIDER1"));
	Slider1->SetSelection(1, 20);
	wxFont Slider1Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Slider1->SetFont(Slider1Font);
	FlexGridSizer1->Add(Slider1, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	StaticText7 = new wxStaticText(this, ID_STATICTEXT7, _("Passphrase:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT7"));
	wxFont StaticText7Font(10,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText7->SetFont(StaticText7Font);
	FlexGridSizer1->Add(StaticText7, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	pp1_ctrl = new wxTextCtrl(this, ID_TEXTCTRL4, wxEmptyString, wxDefaultPosition, wxSize(361,22), 0, wxDefaultValidator, _T("ID_TEXTCTRL4"));
	wxFont pp1_ctrlFont(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	pp1_ctrl->SetFont(pp1_ctrlFont);
	FlexGridSizer1->Add(pp1_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	StaticText8 = new wxStaticText(this, ID_STATICTEXT8, _("Pass. wiederholen:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT8"));
	wxFont StaticText8Font(10,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText8->SetFont(StaticText8Font);
	FlexGridSizer1->Add(StaticText8, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	pp2_ctrl = new wxTextCtrl(this, ID_TEXTCTRL5, wxEmptyString, wxDefaultPosition, wxSize(358,22), 0, wxDefaultValidator, _T("ID_TEXTCTRL5"));
	wxFont pp2_ctrlFont(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	pp2_ctrl->SetFont(pp2_ctrlFont);
	FlexGridSizer1->Add(pp2_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	Button1 = new wxButton(this, ID_BUTTON1, _("Schluessel\nerstellen"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON1"));
	Button1->SetBackgroundColour(wxColour(157,241,192));
	wxFont Button1Font(11,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button1->SetFont(Button1Font);
	FlexGridSizer1->Add(Button1, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	SetSizer(FlexGridSizer1);
	FlexGridSizer1->Fit(this);
	FlexGridSizer1->SetSizeHints(this);

	Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&gpg_new_keyDialog::OnClose);
	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&gpg_new_keyDialog::OnMakeKey);
	//*)
}

gpg_new_keyDialog::~gpg_new_keyDialog()
{
	//(*Destroy(gpg_new_keyDialog)
	//*)
}


void gpg_new_keyDialog::OnClose(wxCommandEvent& event)
{
    EndModal(0);
}

void gpg_new_keyDialog::OnMakeKey(wxCommandEvent& event)
{
    bool result;
    wxString nam,cmnt,imehl,algor,kysiz,pw1,pw2,years;
    int al_no,yno,sizlab;;

    //check for double pw and get pw
    pw1=pp1_ctrl->GetLineText(0);
    pw2=pp2_ctrl->GetLineText(0);
    if(pw1 !=pw2)
    {
        throwout(_("Passphrases don't match!\n enter anew."),2);
        pp1_ctrl->SetValue(_(""));
        pp2_ctrl->SetValue(_(""));
        return;
    }
    //get name, comm and email
    nam=name_ctrl->GetLineText(0);
    cmnt=comm_ctrl->GetLineText(0);
    imehl=imehl_ctrl->GetLineText(0);
    //get algo, years and keylen
    al_no=algo_ctrl->GetSelection();
    if(al_no==0) algor=_("RSA");
    else if(al_no==1) algor=_("DSA");
        else algor=_("RSA");
    yno=Slider1->GetValue();
    years.Printf(_("%dy"),yno);
    sizlab=len_ctrl->GetSelection();
    switch(sizlab)
    {
        case 0:
          kysiz=_("1024");
          break;
        case 1:
          kysiz=_("2048");
          break;
        case 2:
          kysiz=_("3072");
          break;
        case 3:
          kysiz=_("4096");
          break;
        default:
          kysiz=_("2048");
    }

    result=gpg_make_key(nam,cmnt,imehl, algor, kysiz, pw1, years );
    if(result) EndModal(1);
    else EndModal(0);
}
